/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AvailabilityZoneStringListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.SnapshotIdStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnableFastSnapshotRestoresRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, EnableFastSnapshotRestoresRequest> {
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(EnableFastSnapshotRestoresRequest.getter(EnableFastSnapshotRestoresRequest::availabilityZones)).setter(EnableFastSnapshotRestoresRequest.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("AvailabilityZone").build(), ListTrait.builder().memberLocationName("AvailabilityZone").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("AvailabilityZone").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SOURCE_SNAPSHOT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceSnapshotIds").getter(EnableFastSnapshotRestoresRequest.getter(EnableFastSnapshotRestoresRequest::sourceSnapshotIds)).setter(EnableFastSnapshotRestoresRequest.setter(Builder::sourceSnapshotIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSnapshotId").unmarshallLocationName("SourceSnapshotId").build(), ListTrait.builder().memberLocationName("SnapshotId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("SnapshotId").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(EnableFastSnapshotRestoresRequest.getter(EnableFastSnapshotRestoresRequest::dryRun)).setter(EnableFastSnapshotRestoresRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONES_FIELD, SOURCE_SNAPSHOT_IDS_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnableFastSnapshotRestoresRequest.memberNameToFieldInitializer();
    private final List<String> availabilityZones;
    private final List<String> sourceSnapshotIds;
    private final Boolean dryRun;

    private EnableFastSnapshotRestoresRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZones = builder.availabilityZones;
        this.sourceSnapshotIds = builder.sourceSnapshotIds;
        this.dryRun = builder.dryRun;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public final boolean hasSourceSnapshotIds() {
        return this.sourceSnapshotIds != null && !(this.sourceSnapshotIds instanceof SdkAutoConstructList);
    }

    public final List<String> sourceSnapshotIds() {
        return this.sourceSnapshotIds;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceSnapshotIds() ? this.sourceSnapshotIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableFastSnapshotRestoresRequest)) {
            return false;
        }
        EnableFastSnapshotRestoresRequest other = (EnableFastSnapshotRestoresRequest)((Object)obj);
        return this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && this.hasSourceSnapshotIds() == other.hasSourceSnapshotIds() && Objects.equals(this.sourceSnapshotIds(), other.sourceSnapshotIds()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"EnableFastSnapshotRestoresRequest").add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("SourceSnapshotIds", this.hasSourceSnapshotIds() ? this.sourceSnapshotIds() : null).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "SourceSnapshotIds": {
                return Optional.ofNullable(clazz.cast(this.sourceSnapshotIds()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AvailabilityZone", AVAILABILITY_ZONES_FIELD);
        map.put("SourceSnapshotId", SOURCE_SNAPSHOT_IDS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableFastSnapshotRestoresRequest, T> g) {
        return obj -> g.apply((EnableFastSnapshotRestoresRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private List<String> sourceSnapshotIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableFastSnapshotRestoresRequest model) {
            super(model);
            this.availabilityZones(model.availabilityZones);
            this.sourceSnapshotIds(model.sourceSnapshotIds);
            this.dryRun(model.dryRun);
        }

        public final Collection<String> getAvailabilityZones() {
            if (this.availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZoneStringListCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZoneStringListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final Collection<String> getSourceSnapshotIds() {
            if (this.sourceSnapshotIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceSnapshotIds;
        }

        public final void setSourceSnapshotIds(Collection<String> sourceSnapshotIds) {
            this.sourceSnapshotIds = SnapshotIdStringListCopier.copy(sourceSnapshotIds);
        }

        @Override
        public final Builder sourceSnapshotIds(Collection<String> sourceSnapshotIds) {
            this.sourceSnapshotIds = SnapshotIdStringListCopier.copy(sourceSnapshotIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceSnapshotIds(String ... sourceSnapshotIds) {
            this.sourceSnapshotIds(Arrays.asList(sourceSnapshotIds));
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableFastSnapshotRestoresRequest build() {
            return new EnableFastSnapshotRestoresRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EnableFastSnapshotRestoresRequest> {
        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder sourceSnapshotIds(Collection<String> var1);

        public Builder sourceSnapshotIds(String ... var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

