/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse;
import software.amazon.awssdk.services.ec2.model.InstanceStatus;

public class DescribeInstanceStatusPublisher
implements SdkPublisher<DescribeInstanceStatusResponse> {
    private final Ec2AsyncClient client;
    private final DescribeInstanceStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeInstanceStatusPublisher(Ec2AsyncClient client, DescribeInstanceStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeInstanceStatusPublisher(Ec2AsyncClient client, DescribeInstanceStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeInstanceStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeInstanceStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InstanceStatus> instanceStatuses() {
        Function<DescribeInstanceStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceStatuses() != null) {
                return response.instanceStatuses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeInstanceStatusResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeInstanceStatusResponseFetcher
    implements AsyncPageFetcher<DescribeInstanceStatusResponse> {
        private DescribeInstanceStatusResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeInstanceStatusResponse> nextPage(DescribeInstanceStatusResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceStatusPublisher.this.client.describeInstanceStatus(DescribeInstanceStatusPublisher.this.firstRequest);
            }
            return DescribeInstanceStatusPublisher.this.client.describeInstanceStatus((DescribeInstanceStatusRequest)((Object)DescribeInstanceStatusPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

