/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.transfermanager;

import com.google.cloud.storage.transfermanager.Qos;
import com.google.cloud.storage.transfermanager.TransferManagerConfig;

final class DefaultQos
implements Qos {
    private final long divideAndConquerThreshold;
    private final long parallelCompositeUploadThreshold;
    private boolean threadThresholdMet;

    private DefaultQos(long divideAndConquerThreshold, long parallelCompositeUploadThreshold, boolean threadThresholdMet) {
        this.divideAndConquerThreshold = divideAndConquerThreshold;
        this.parallelCompositeUploadThreshold = parallelCompositeUploadThreshold;
        this.threadThresholdMet = threadThresholdMet;
    }

    @Override
    public boolean divideAndConquer(long objectSize) {
        return objectSize > this.divideAndConquerThreshold;
    }

    @Override
    public boolean parallelCompositeUpload(long objectSize) {
        return this.threadThresholdMet && objectSize > this.parallelCompositeUploadThreshold;
    }

    static DefaultQos of(TransferManagerConfig config) {
        return new DefaultQos(0x8000000L, 4L * (long)config.getPerWorkerBufferSize(), config.getMaxWorkers() > 2);
    }
}

