/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.utils.BlocLines;

public abstract class CommandMultilines3<S extends Diagram>
implements Command<S> {
    private final IRegex starting;
    private final MultilinesStrategy strategy;
    private final Trim trimEnd;
    private final IRegex patternEnd;

    public CommandMultilines3(IRegex patternStart, MultilinesStrategy strategy, Trim trimEnd, IRegex patternEnd) {
        assert (patternStart.getPatternAsString().startsWith("^") && patternStart.getPatternAsString().endsWith("$"));
        this.strategy = strategy;
        this.starting = patternStart;
        this.trimEnd = trimEnd;
        this.patternEnd = patternEnd;
    }

    @Override
    public final CommandControl isValid(BlocLines lines) {
        StringLocated potentialLast;
        lines = lines.cleanList(this.strategy);
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        StringLocated first = lines.getFirst();
        if (first == null) {
            return CommandControl.NOT_OK;
        }
        boolean result1 = this.starting.match(first.getTrimmed());
        if (!result1) {
            return CommandControl.NOT_OK;
        }
        if (lines.size() == 1) {
            return CommandControl.OK_PARTIAL;
        }
        if (this.trimEnd == Trim.NONE) {
            potentialLast = lines.getLast();
        } else if (this.trimEnd == Trim.BOTH) {
            potentialLast = lines.getLast().getTrimmed();
        } else {
            throw new IllegalStateException();
        }
        boolean m1 = this.patternEnd.match(potentialLast);
        if (!m1) {
            return CommandControl.OK_PARTIAL;
        }
        return this.finalVerification();
    }

    @Override
    public final CommandExecutionResult execute(S system, BlocLines lines, ParserPass currentPass) throws NoSuchColorException {
        lines = lines.cleanList(this.strategy);
        return this.executeNow(system, lines);
    }

    protected abstract CommandExecutionResult executeNow(S var1, BlocLines var2) throws NoSuchColorException;

    protected boolean isCommandForbidden() {
        return false;
    }

    protected CommandControl finalVerification() {
        return CommandControl.OK;
    }

    protected final IRegex getStartingPattern() {
        return this.starting;
    }

    protected final IRegex getEndingPattern() {
        return this.patternEnd;
    }

    @Override
    public boolean isEligibleFor(ParserPass pass) {
        return pass == ParserPass.ONE;
    }
}

