/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.util.Enumeration;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;

class ValuesEnumerator
implements Enumeration<String> {
    private int pos;
    private final int size;
    private MessageBytes next;
    private final MimeHeaders headers;
    private final String name;

    ValuesEnumerator(MimeHeaders mimeHeaders, String string) {
        this.name = string;
        this.headers = mimeHeaders;
        this.pos = 0;
        this.size = mimeHeaders.size();
        this.findNext();
    }

    private void findNext() {
        this.next = null;
        while (this.pos < this.size) {
            MessageBytes messageBytes = this.headers.getName(this.pos);
            if (messageBytes.equalsIgnoreCase(this.name)) {
                this.next = this.headers.getValue(this.pos);
                break;
            }
            ++this.pos;
        }
        ++this.pos;
    }

    @Override
    public boolean hasMoreElements() {
        return this.next != null;
    }

    @Override
    public String nextElement() {
        MessageBytes messageBytes = this.next;
        this.findNext();
        return messageBytes.toStringType();
    }
}

