//! @file a68g-prelude-gsl.h
//! @author J. Marcel van der Veer

//! @section Copyright
//!
//! This file is part of Algol68G - an Algol 68 compiler-interpreter.
//! Copyright 2001-2024 J. Marcel van der Veer [algol68g@xs4all.nl].

//! @section License
//!
//! This program is free software; you can redistribute it and/or modify it 
//! under the terms of the GNU General Public License as published by the 
//! Free Software Foundation; either version 3 of the License, or 
//! (at your option) any later version.
//!
//! This program is distributed in the hope that it will be useful, but 
//! WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
//! or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
//! more details. You should have received a copy of the GNU General Public 
//! License along with this program. If not, see [http://www.gnu.org/licenses/].

//! @section Synopsis
//!
//! GSL definitions.

#if !defined (__A68G_PRELUDE_GSL_H__)
#define __A68G_PRELUDE_GSL_H__

#if defined (HAVE_GSL)

void stand_gsl (void);

GPROC genie_airy_ai_deriv_real;
GPROC genie_airy_ai_deriv_scaled_real;
GPROC genie_airy_ai_real;
GPROC genie_airy_ai_scaled_real;
GPROC genie_airy_bi_deriv_real;
GPROC genie_airy_bi_deriv_scaled_real;
GPROC genie_airy_bi_real;
GPROC genie_airy_bi_scaled_real;
GPROC genie_airy_zero_ai_deriv_real;
GPROC genie_airy_zero_ai_real;
GPROC genie_airy_zero_bi_deriv_real;
GPROC genie_airy_zero_bi_real;
GPROC genie_angle_restrict_pos_real;
GPROC genie_angle_restrict_symm_real;
GPROC genie_atanint_real;
GPROC genie_bessel_il0_scaled_real;
GPROC genie_bessel_il1_scaled_real;
GPROC genie_bessel_il2_scaled_real;
GPROC genie_bessel_il_scaled_real;
GPROC genie_bessel_in0_real;
GPROC genie_bessel_in0_scaled_real;
GPROC genie_bessel_in1_real;
GPROC genie_bessel_in1_scaled_real;
GPROC genie_bessel_in_real;
GPROC genie_bessel_in_scaled_real;
GPROC genie_bessel_inu_real;
GPROC genie_bessel_inu_scaled_real;
GPROC genie_bessel_jl0_real;
GPROC genie_bessel_jl1_real;
GPROC genie_bessel_jl2_real;
GPROC genie_bessel_jl_real;
GPROC genie_bessel_jn0_real;
GPROC genie_bessel_jn1_real;
GPROC genie_bessel_jn_real;
GPROC genie_bessel_jnu_real;
GPROC genie_bessel_kl0_scaled_real;
GPROC genie_bessel_kl1_scaled_real;
GPROC genie_bessel_kl2_scaled_real;
GPROC genie_bessel_kl_scaled_real;
GPROC genie_bessel_kn0_real;
GPROC genie_bessel_kn0_scaled_real;
GPROC genie_bessel_kn1_real;
GPROC genie_bessel_kn1_scaled_real;
GPROC genie_bessel_kn_real;
GPROC genie_bessel_kn_scaled_real;
GPROC genie_bessel_knu_real;
GPROC genie_bessel_knu_scaled_real;
GPROC genie_bessel_knu_scaled_real;
GPROC genie_bessel_ln_knu_real;
GPROC genie_bessel_yl0_real;
GPROC genie_bessel_yl1_real;
GPROC genie_bessel_yl2_real;
GPROC genie_bessel_yl_real;
GPROC genie_bessel_yn0_real;
GPROC genie_bessel_yn1_real;
GPROC genie_bessel_yn_real;
GPROC genie_bessel_ynu_real;
GPROC genie_bessel_zero_jnu0_real;
GPROC genie_bessel_zero_jnu1_real;
GPROC genie_bessel_zero_jnu_real;
GPROC genie_beta_inc_gsl_real;
GPROC genie_beta_inc_real;
GPROC genie_chi_real;
GPROC genie_ci_real;
GPROC genie_clausen_real;
GPROC genie_conicalp_0_real;
GPROC genie_conicalp_1_real;
GPROC genie_conicalp_cyl_reg_real;
GPROC genie_conicalp_half_real;
GPROC genie_conicalp_mhalf_real;
GPROC genie_conicalp_sph_reg_real;
GPROC genie_dawson_real;
GPROC genie_debye_1_real;
GPROC genie_debye_2_real;
GPROC genie_debye_3_real;
GPROC genie_debye_4_real;
GPROC genie_debye_5_real;
GPROC genie_debye_6_real;
GPROC genie_dilog_real;
GPROC genie_doublefact_real;
GPROC genie_ellint_d_real;
GPROC genie_ellint_d_real;
GPROC genie_ellint_e_comp_real;
GPROC genie_ellint_e_real;
GPROC genie_ellint_f_real;
GPROC genie_ellint_k_comp_real;
GPROC genie_ellint_p_comp_real;
GPROC genie_ellint_p_real;
GPROC genie_ellint_rc_real;
GPROC genie_ellint_rd_real;
GPROC genie_ellint_rf_real;
GPROC genie_ellint_rj_real;
GPROC genie_etaint_real;
GPROC genie_eta_real;
GPROC genie_expint_3_real;
GPROC genie_expint_e1_real;
GPROC genie_expint_e2_real;
GPROC genie_expint_ei_real;
GPROC genie_expint_en_real;
GPROC genie_expm1_real;
GPROC genie_exprel_2_real;
GPROC genie_exprel_n_real;
GPROC genie_exprel_real;
GPROC genie_fact_real;
GPROC genie_fermi_dirac_0_real;
GPROC genie_fermi_dirac_1_real;
GPROC genie_fermi_dirac_2_real;
GPROC genie_fermi_dirac_3half_real;
GPROC genie_fermi_dirac_half_real;
GPROC genie_fermi_dirac_inc_0_real;
GPROC genie_fermi_dirac_int_real;
GPROC genie_fermi_dirac_m1_real;
GPROC genie_fermi_dirac_mhalf_real;
GPROC genie_gamma_inc_real;
GPROC genie_gamma_inc_p_real;
GPROC genie_gamma_inc_q_real;
GPROC genie_gammainv_real;
GPROC genie_gammastar_real;
GPROC genie_gegenpoly_1_real;
GPROC genie_gegenpoly_2_real;
GPROC genie_gegenpoly_3_real;
GPROC genie_gegenpoly_n_real;
GPROC genie_hermite_func_real;
GPROC genie_hypot_real;
GPROC genie_hzeta_real;
GPROC genie_laguerre_1_real;
GPROC genie_laguerre_2_real;
GPROC genie_laguerre_3_real;
GPROC genie_laguerre_n_real;
GPROC genie_lambert_w0_real;
GPROC genie_lambert_wm1_real;
GPROC genie_legendre_h3d_0_real;
GPROC genie_legendre_h3d_1_real;
GPROC genie_legendre_H3d_real;
GPROC genie_legendre_p1_real;
GPROC genie_legendre_p2_real;
GPROC genie_legendre_p3_real;
GPROC genie_legendre_pl_real;
GPROC genie_legendre_q0_real;
GPROC genie_legendre_q1_real;
GPROC genie_legendre_ql_real;
GPROC genie_lncosh_real;
GPROC genie_lndoublefact_real;
GPROC genie_lnfact_real;
GPROC genie_lnpoch_real;
GPROC genie_lnsinh_real;
GPROC genie_log_1plusx_mx_real;
GPROC genie_log_1plusx_real;
GPROC genie_log_abs_real;
GPROC genie_poch_real;
GPROC genie_pochrel_real;
GPROC genie_print_matrix;
GPROC genie_print_vector;
GPROC genie_psi_1_int_real;
GPROC genie_psi_1piy_real;
GPROC genie_psi_1_real;
GPROC genie_psi_int_real;
GPROC genie_psi_n_real;
GPROC genie_psi_real;
GPROC genie_shi_real;
GPROC genie_sinc_real;
GPROC genie_si_real;
GPROC genie_synchrotron_1_real;
GPROC genie_synchrotron_2_real;
GPROC genie_taylorcoeff_real;
GPROC genie_transport_2_real;
GPROC genie_transport_3_real;
GPROC genie_transport_4_real;
GPROC genie_transport_5_real;
GPROC genie_zeta_int_real;
GPROC genie_zetam1_int_real;
GPROC genie_zetam1_real;
GPROC genie_zeta_real;
GPROC genie_poch_real;
GPROC genie_prime_factors;
GPROC genie_beta_inc_real;
GPROC genie_digamma_real;
GPROC genie_gamma_inc_real;
GPROC genie_laplace;

GPROC genie_fft_backward;
GPROC genie_fft_complex_backward;
GPROC genie_fft_complex_forward;
GPROC genie_fft_complex_inverse;
GPROC genie_fft_forward;
GPROC genie_fft_inverse;

GPROC genie_complex_scale_matrix_complex;
GPROC genie_complex_scale_vector_complex;
GPROC genie_left_columns;
GPROC genie_matrix_add;
GPROC genie_matrix_ch;
GPROC genie_matrix_ch_solve;
GPROC genie_matrix_column_mean;
GPROC genie_matrix_complex_add;
GPROC genie_matrix_complex_det;
GPROC genie_matrix_complex_div_complex;
GPROC genie_matrix_complex_div_complex_ab;
GPROC genie_matrix_complex_echo;
GPROC genie_matrix_complex_eq;
GPROC genie_matrix_complex_inv;
GPROC genie_matrix_complex_lu;
GPROC genie_matrix_complex_lu_det;
GPROC genie_matrix_complex_lu_inv;
GPROC genie_matrix_complex_lu_solve;
GPROC genie_matrix_complex_minus;
GPROC genie_matrix_complex_minusab;
GPROC genie_matrix_complex_ne;
GPROC genie_matrix_complex_plusab;
GPROC genie_matrix_complex_scale_complex;
GPROC genie_matrix_complex_scale_complex_ab;
GPROC genie_matrix_complex_sub;
GPROC genie_matrix_complex_times_matrix;
GPROC genie_matrix_complex_times_vector;
GPROC genie_matrix_complex_trace;
GPROC genie_matrix_complex_transpose;
GPROC genie_matrix_det;
GPROC genie_matrix_div_real;
GPROC genie_matrix_div_real_ab;
GPROC genie_matrix_echo;
GPROC genie_matrix_eq;
GPROC genie_matrix_hcat;
GPROC genie_matrix_inv;
GPROC genie_matrix_lu;
GPROC genie_matrix_lu_det;
GPROC genie_matrix_lu_inv;
GPROC genie_matrix_lu_solve;
GPROC genie_matrix_minus;
GPROC genie_matrix_minusab;
GPROC genie_matrix_ne;
GPROC genie_matrix_norm;
GPROC genie_matrix_ols;
GPROC genie_matrix_pca_cv;
GPROC genie_matrix_pca_svd;
GPROC genie_matrix_pca_svd_full;
GPROC genie_matrix_pcr;
GPROC genie_matrix_pinv;
GPROC genie_matrix_pinv_lim;
GPROC genie_matrix_pls1;
GPROC genie_matrix_pls2;
GPROC genie_matrix_plusab;
GPROC genie_matrix_qr;
GPROC genie_matrix_qr_ls_solve;
GPROC genie_matrix_qr_solve;
GPROC genie_matrix_scale_real;
GPROC genie_matrix_scale_real_ab;
GPROC genie_matrix_sub;
GPROC genie_matrix_svd;
GPROC genie_matrix_svd_solve;
GPROC genie_matrix_times_matrix;
GPROC genie_matrix_times_vector;
GPROC genie_matrix_tls;
GPROC genie_matrix_trace;
GPROC genie_matrix_transpose;
GPROC genie_matrix_vcat;
GPROC genie_real_scale_matrix;
GPROC genie_real_scale_vector;
GPROC genie_vector_add;
GPROC genie_vector_col;
GPROC genie_vector_complex_add;
GPROC genie_vector_complex_div_complex;
GPROC genie_vector_complex_div_complex_ab;
GPROC genie_vector_complex_dot;
GPROC genie_vector_complex_dyad;
GPROC genie_vector_complex_echo;
GPROC genie_vector_complex_eq;
GPROC genie_vector_complex_minus;
GPROC genie_vector_complex_minusab;
GPROC genie_vector_complex_ne;
GPROC genie_vector_complex_norm;
GPROC genie_vector_complex_plusab;
GPROC genie_vector_complex_scale_complex;
GPROC genie_vector_complex_scale_complex_ab;
GPROC genie_vector_complex_sub;
GPROC genie_vector_complex_times_matrix;
GPROC genie_vector_div_real;
GPROC genie_vector_div_real_ab;
GPROC genie_vector_dot;
GPROC genie_vector_dyad;
GPROC genie_vector_echo;
GPROC genie_vector_eq;
GPROC genie_vector_minus;
GPROC genie_vector_minusab;
GPROC genie_vector_ne;
GPROC genie_vector_norm;
GPROC genie_vector_plusab;
GPROC genie_vector_row;
GPROC genie_vector_scale_real;
GPROC genie_vector_scale_real_ab;
GPROC genie_vector_sub;
GPROC genie_vector_times_matrix;

// Constants ex GSL

GPROC genie_cgs_acre;
GPROC genie_cgs_angstrom;
GPROC genie_cgs_astronomical_unit;
GPROC genie_cgs_bar;
GPROC genie_cgs_barn;
GPROC genie_cgs_bohr_magneton;
GPROC genie_cgs_bohr_radius;
GPROC genie_cgs_boltzmann;
GPROC genie_cgs_btu;
GPROC genie_cgs_calorie;
GPROC genie_cgs_canadian_gallon;
GPROC genie_cgs_carat;
GPROC genie_cgs_cup;
GPROC genie_cgs_curie;
GPROC genie_cgs_day;
GPROC genie_cgs_dyne;
GPROC genie_cgs_electron_charge;
GPROC genie_cgs_electron_magnetic_moment;
GPROC genie_cgs_electron_volt;
GPROC genie_cgs_erg;
GPROC genie_cgs_faraday;
GPROC genie_cgs_fathom;
GPROC genie_cgs_fluid_ounce;
GPROC genie_cgs_foot;
GPROC genie_cgs_footcandle;
GPROC genie_cgs_footlambert;
GPROC genie_cgs_gauss;
GPROC genie_cgs_gram_force;
GPROC genie_cgs_grav_accel;
GPROC genie_cgs_gravitational_constant;
GPROC genie_cgs_hectare;
GPROC genie_cgs_horsepower;
GPROC genie_cgs_hour;
GPROC genie_cgs_inch;
GPROC genie_cgs_inch_of_mercury;
GPROC genie_cgs_inch_of_water;
GPROC genie_cgs_joule;
GPROC genie_cgs_kilometers_per_hour;
GPROC genie_cgs_kilopound_force;
GPROC genie_cgs_knot;
GPROC genie_cgs_lambert;
GPROC genie_cgs_light_year;
GPROC genie_cgs_liter;
GPROC genie_cgs_lumen;
GPROC genie_cgs_lux;
GPROC genie_cgs_mass_electron;
GPROC genie_cgs_mass_muon;
GPROC genie_cgs_mass_neutron;
GPROC genie_cgs_mass_proton;
GPROC genie_cgs_meter_of_mercury;
GPROC genie_cgs_metric_ton;
GPROC genie_cgs_micron;
GPROC genie_cgs_mil;
GPROC genie_cgs_mile;
GPROC genie_cgs_miles_per_hour;
GPROC genie_cgs_minute;
GPROC genie_cgs_molar_gas;
GPROC genie_cgs_nautical_mile;
GPROC genie_cgs_newton;
GPROC genie_cgs_nuclear_magneton;
GPROC genie_cgs_ounce_mass;
GPROC genie_cgs_parsec;
GPROC genie_cgs_phot;
GPROC genie_cgs_pint;
GPROC genie_cgs_planck_constant_h;
GPROC genie_cgs_planck_constant_hbar;
GPROC genie_cgs_point;
GPROC genie_cgs_poise;
GPROC genie_cgs_pound_force;
GPROC genie_cgs_pound_mass;
GPROC genie_cgs_poundal;
GPROC genie_cgs_proton_magnetic_moment;
GPROC genie_cgs_psi;
GPROC genie_cgs_quart;
GPROC genie_cgs_rad;
GPROC genie_cgs_roentgen;
GPROC genie_cgs_rydberg;
GPROC genie_cgs_solar_mass;
GPROC genie_cgs_speed_of_light;
GPROC genie_cgs_standard_gas_volume;
GPROC genie_cgs_std_atmosphere;
GPROC genie_cgs_stilb;
GPROC genie_cgs_stokes;
GPROC genie_cgs_tablespoon;
GPROC genie_cgs_teaspoon;
GPROC genie_cgs_texpoint;
GPROC genie_cgs_therm;
GPROC genie_cgs_ton;
GPROC genie_cgs_torr;
GPROC genie_cgs_troy_ounce;
GPROC genie_cgs_uk_gallon;
GPROC genie_cgs_uk_ton;
GPROC genie_cgs_unified_atomic_mass;
GPROC genie_cgs_us_gallon;
GPROC genie_cgs_week;
GPROC genie_cgs_yard;
GPROC genie_mks_acre;
GPROC genie_mks_angstrom;
GPROC genie_mks_astronomical_unit;
GPROC genie_mks_bar;
GPROC genie_mks_barn;
GPROC genie_mks_bohr_magneton;
GPROC genie_mks_bohr_radius;
GPROC genie_mks_boltzmann;
GPROC genie_mks_btu;
GPROC genie_mks_calorie;
GPROC genie_mks_canadian_gallon;
GPROC genie_mks_carat;
GPROC genie_mks_cup;
GPROC genie_mks_curie;
GPROC genie_mks_day;
GPROC genie_mks_dyne;
GPROC genie_mks_electron_charge;
GPROC genie_mks_electron_magnetic_moment;
GPROC genie_mks_electron_volt;
GPROC genie_mks_erg;
GPROC genie_mks_faraday;
GPROC genie_mks_fathom;
GPROC genie_mks_fluid_ounce;
GPROC genie_mks_foot;
GPROC genie_mks_footcandle;
GPROC genie_mks_footlambert;
GPROC genie_mks_gauss;
GPROC genie_mks_gram_force;
GPROC genie_mks_grav_accel;
GPROC genie_mks_gravitational_constant;
GPROC genie_mks_hectare;
GPROC genie_mks_horsepower;
GPROC genie_mks_hour;
GPROC genie_mks_inch;
GPROC genie_mks_inch_of_mercury;
GPROC genie_mks_inch_of_water;
GPROC genie_mks_joule;
GPROC genie_mks_kilometers_per_hour;
GPROC genie_mks_kilopound_force;
GPROC genie_mks_knot;
GPROC genie_mks_lambert;
GPROC genie_mks_light_year;
GPROC genie_mks_liter;
GPROC genie_mks_lumen;
GPROC genie_mks_lux;
GPROC genie_mks_mass_electron;
GPROC genie_mks_mass_muon;
GPROC genie_mks_mass_neutron;
GPROC genie_mks_mass_proton;
GPROC genie_mks_meter_of_mercury;
GPROC genie_mks_metric_ton;
GPROC genie_mks_micron;
GPROC genie_mks_mil;
GPROC genie_mks_mile;
GPROC genie_mks_miles_per_hour;
GPROC genie_mks_minute;
GPROC genie_mks_molar_gas;
GPROC genie_mks_nautical_mile;
GPROC genie_mks_newton;
GPROC genie_mks_nuclear_magneton;
GPROC genie_mks_ounce_mass;
GPROC genie_mks_parsec;
GPROC genie_mks_phot;
GPROC genie_mks_pint;
GPROC genie_mks_planck_constant_h;
GPROC genie_mks_planck_constant_hbar;
GPROC genie_mks_point;
GPROC genie_mks_poise;
GPROC genie_mks_pound_force;
GPROC genie_mks_pound_mass;
GPROC genie_mks_poundal;
GPROC genie_mks_proton_magnetic_moment;
GPROC genie_mks_psi;
GPROC genie_mks_quart;
GPROC genie_mks_rad;
GPROC genie_mks_roentgen;
GPROC genie_mks_rydberg;
GPROC genie_mks_solar_mass;
GPROC genie_mks_speed_of_light;
GPROC genie_mks_standard_gas_volume;
GPROC genie_mks_std_atmosphere;
GPROC genie_mks_stilb;
GPROC genie_mks_stokes;
GPROC genie_mks_tablespoon;
GPROC genie_mks_teaspoon;
GPROC genie_mks_texpoint;
GPROC genie_mks_therm;
GPROC genie_mks_ton;
GPROC genie_mks_torr;
GPROC genie_mks_troy_ounce;
GPROC genie_mks_uk_gallon;
GPROC genie_mks_uk_ton;
GPROC genie_mks_unified_atomic_mass;
GPROC genie_mks_us_gallon;
GPROC genie_mks_vacuum_permeability;
GPROC genie_mks_vacuum_permittivity;
GPROC genie_mks_week;
GPROC genie_mks_yard;
GPROC genie_num_atto;
GPROC genie_num_avogadro;
GPROC genie_num_exa;
GPROC genie_num_femto;
GPROC genie_num_fine_structure;
GPROC genie_num_giga;
GPROC genie_num_kilo;
GPROC genie_num_mega;
GPROC genie_num_micro;
GPROC genie_num_milli;
GPROC genie_num_nano;
GPROC genie_num_peta;
GPROC genie_num_pico;
GPROC genie_num_tera;
GPROC genie_num_yocto;
GPROC genie_num_yotta;
GPROC genie_num_zepto;
GPROC genie_num_zetta;
#endif

#endif
