; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s | FileCheck %s

@x = global [6 x i32] [i32 0, i32 1, i32 2, i32 3, i32 4, i32 5], align 4
@check = global [6 x i32] [i32 0, i32 1, i32 2, i32 3, i32 4, i32 5], align 4

; This test case checks whether the base address of an array is repeatedly
; rematerialised within a unrolled loop.
define signext i32 @unroll_loop_cse() {
; CHECK-LABEL: unroll_loop_cse:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a0, %hi(x)
; CHECK-NEXT:    lui a1, %hi(check)
; CHECK-NEXT:    lw a2, %lo(x)(a0)
; CHECK-NEXT:    lw a1, %lo(check)(a1)
; CHECK-NEXT:    li a0, 1
; CHECK-NEXT:    bne a2, a1, .LBB0_6
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a1, %hi(x)
; CHECK-NEXT:    addi a1, a1, %lo(x)
; CHECK-NEXT:    lui a2, %hi(check)
; CHECK-NEXT:    addi a2, a2, %lo(check)
; CHECK-NEXT:    lw a3, 4(a1)
; CHECK-NEXT:    lw a4, 4(a2)
; CHECK-NEXT:    bne a3, a4, .LBB0_6
; CHECK-NEXT:  # %bb.2:
; CHECK-NEXT:    lw a3, 8(a1)
; CHECK-NEXT:    lw a4, 8(a2)
; CHECK-NEXT:    bne a3, a4, .LBB0_6
; CHECK-NEXT:  # %bb.3:
; CHECK-NEXT:    lw a3, 12(a1)
; CHECK-NEXT:    lw a4, 12(a2)
; CHECK-NEXT:    bne a3, a4, .LBB0_6
; CHECK-NEXT:  # %bb.4:
; CHECK-NEXT:    lw a3, 16(a1)
; CHECK-NEXT:    lw a4, 16(a2)
; CHECK-NEXT:    bne a3, a4, .LBB0_6
; CHECK-NEXT:  # %bb.5:
; CHECK-NEXT:    lw a0, 20(a1)
; CHECK-NEXT:    lw a1, 20(a2)
; CHECK-NEXT:    xor a0, a0, a1
; CHECK-NEXT:    snez a0, a0
; CHECK-NEXT:  .LBB0_6:
; CHECK-NEXT:    ret
  %1 = load i32, ptr @x, align 4
  %2 = load i32, ptr @check, align 4
  %3 = icmp eq i32 %1, %2
  br i1 %3, label %4, label %25

4:
  %5 = load i32, ptr getelementptr inbounds ([6 x i32], ptr @x, i64 0, i64 1), align 4
  %6 = load i32, ptr getelementptr inbounds ([6 x i32], ptr @check, i64 0, i64 1), align 4
  %7 = icmp eq i32 %5, %6
  br i1 %7, label %8, label %25

8:
  %9 = load i32, ptr getelementptr inbounds ([6 x i32], ptr @x, i64 0, i64 2), align 4
  %10 = load i32, ptr getelementptr inbounds ([6 x i32], ptr @check, i64 0, i64 2), align 4
  %11 = icmp eq i32 %9, %10
  br i1 %11, label %12, label %25

12:
  %13 = load i32, ptr getelementptr inbounds ([6 x i32], ptr @x, i64 0, i64 3), align 4
  %14 = load i32, ptr getelementptr inbounds ([6 x i32], ptr @check, i64 0, i64 3), align 4
  %15 = icmp eq i32 %13, %14
  br i1 %15, label %16, label %25

16:
  %17 = load i32, ptr getelementptr inbounds ([6 x i32], ptr @x, i64 0, i64 4), align 4
  %18 = load i32, ptr getelementptr inbounds ([6 x i32], ptr @check, i64 0, i64 4), align 4
  %19 = icmp eq i32 %17, %18
  br i1 %19, label %20, label %25

20:
  %21 = load i32, ptr getelementptr inbounds ([6 x i32], ptr @x, i64 0, i64 5), align 4
  %22 = load i32, ptr getelementptr inbounds ([6 x i32], ptr @check, i64 0, i64 5), align 4
  %23 = icmp ne i32 %21, %22
  %24 = zext i1 %23 to i32
  br label %25

25:
  %26 = phi i32 [ 1, %0 ], [ 1, %4 ], [ 1, %8 ], [ 1, %12 ], [ 1, %16 ], [ %24, %20 ]
  ret i32 %26
}
