#
# Cygwin-specific customizations for fish
#

# Prepend system directories to PATH
for p in /bin /usr/local/bin
	if not contains $p $PATH
		set --prepend PATH $p
	end
end
__fish_reconstruct_path	# ... but make sure fish_user_paths still comes first


#
# Settings for login shells
#

if status is-login

	# Run commands in /etc/profile.d/*.fish
	for file in /etc/profile.d/*.fish
		source $file
	end
	
	# Set a default value for LANG if it's not already set
	if not set --query LANG
		set --global --export LANG en_US.UTF-8
	end

	# Start in $HOME
	if not set --query CHERE_INVOKING
		cd
	end

end

#
# Settings for interactive shells
#

if status is-interactive

	# BROWSER tells fish (for example, the fish_config and open commands) what
	# app to use to open HTML files. If BROWSER isn't set, fish will try to use
	# a text or X11 browser. For Cygwin cygstart is a better default choice,
	# because it opens a tab in the default Windows browser, and also converts
	# paths in file:// URLs from Cygwin to Windows form.
	if not set --query BROWSER
		set --global --export BROWSER cygstart
	end

end
