/* backend.c generated by valac 0.35.3.10-6b27, the Vala compiler
 * generated from backend.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors :Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <stdio.h>
#include <gio/gio.h>
#include <folks/folks-tracker.h>
#include <gobject/gvaluecollector.h>


#define TRACKER_TEST_TYPE_BACKEND (tracker_test_backend_get_type ())
#define TRACKER_TEST_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TEST_TYPE_BACKEND, TrackerTestBackend))
#define TRACKER_TEST_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TEST_TYPE_BACKEND, TrackerTestBackendClass))
#define TRACKER_TEST_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TEST_TYPE_BACKEND))
#define TRACKER_TEST_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TEST_TYPE_BACKEND))
#define TRACKER_TEST_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TEST_TYPE_BACKEND, TrackerTestBackendClass))

typedef struct _TrackerTestBackend TrackerTestBackend;
typedef struct _TrackerTestBackendClass TrackerTestBackendClass;
typedef struct _TrackerTestBackendPrivate TrackerTestBackendPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TrackerTestParamSpecBackend TrackerTestParamSpecBackend;

typedef enum  {
	TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED
} TrackerTestBackendSetupError;
#define TRACKER_TEST_BACKEND_SETUP_ERROR tracker_test_backend_setup_error_quark ()
struct _TrackerTestBackend {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerTestBackendPrivate * priv;
};

struct _TrackerTestBackendClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerTestBackend *self);
};

struct _TrackerTestBackendPrivate {
	gboolean _debug;
	GList* _contacts;
	TrackerSparqlConnection* _connection;
};

struct _TrackerTestParamSpecBackend {
	GParamSpec parent_instance;
};


static gpointer tracker_test_backend_parent_class = NULL;

GQuark tracker_test_backend_setup_error_quark (void);
gpointer tracker_test_backend_ref (gpointer instance);
void tracker_test_backend_unref (gpointer instance);
GParamSpec* tracker_test_param_spec_backend (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_test_value_set_backend (GValue* value, gpointer v_object);
void tracker_test_value_take_backend (GValue* value, gpointer v_object);
gpointer tracker_test_value_get_backend (const GValue* value);
GType tracker_test_backend_get_type (void) G_GNUC_CONST;
#define TRACKER_TEST_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TEST_TYPE_BACKEND, TrackerTestBackendPrivate))
enum  {
	TRACKER_TEST_BACKEND_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
#define TRACKER_TEST_BACKEND_URN "urn:contact"
#define TRACKER_TEST_BACKEND_URLS "nco:urls"
TrackerTestBackend* tracker_test_backend_new (void);
TrackerTestBackend* tracker_test_backend_construct (GType object_type);
void tracker_test_backend_set_debug (TrackerTestBackend* self, gboolean value);
void tracker_test_backend_add_contact (TrackerTestBackend* self, GeeHashMap* c);
static GeeHashMap* _tracker_test_backend_copy_hash_map (TrackerTestBackend* self, GeeHashMap* orig);
void tracker_test_backend_tear_down (TrackerTestBackend* self);
void tracker_test_backend_reset (TrackerTestBackend* self);
void tracker_test_backend_set_up (TrackerTestBackend* self);
static void _tracker_test_backend_setup_connection (TrackerTestBackend* self, GError** error);
static void _tracker_test_backend_add_contacts (TrackerTestBackend* self, GError** error);
gboolean tracker_test_backend_update_contact (TrackerTestBackend* self, const gchar* contact_urn, const gchar* predicate, const gchar* literal_subject);
static gboolean _tracker_test_backend_do_update_query (TrackerTestBackend* self, const gchar* query);
gboolean tracker_test_backend_update_favourite (TrackerTestBackend* self, const gchar* contact_urn, gboolean is_favourite);
gboolean tracker_test_backend_remove_contact (TrackerTestBackend* self, const gchar* tracker_id);
gboolean tracker_test_backend_remove_triplet (TrackerTestBackend* self, const gchar* subject_urn, const gchar* pred, const gchar* object_urn);
gboolean tracker_test_backend_insert_triplet (TrackerTestBackend* self, const gchar* subject_iri, const gchar* pred, const gchar* object_iri, const gchar* pred_b, const gchar* obj_literal_b, const gchar* pred_c, const gchar* obj_literal_c);
gboolean tracker_test_backend_get_debug (TrackerTestBackend* self);
static gchar* _tracker_test_backend_get_insert_query (TrackerTestBackend* self, GeeHashMap* contact);
static GeeHashMap* _tracker_test_backend_parse_addrs (TrackerTestBackend* self, const gchar* addr_s);
static gchar* _tracker_test_backend_build_relation (TrackerTestBackend* self, const gchar* predicate, gchar** objects, int objects_length1);
static void tracker_test_backend_finalize (TrackerTestBackend * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark tracker_test_backend_setup_error_quark (void) {
	return g_quark_from_static_string ("tracker_test_backend_setup_error-quark");
}


static void _g_object_unref0_ (gpointer var) {
#line 34 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 131 "backend.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 34 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 34 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_list_free (self);
#line 140 "backend.c"
}


TrackerTestBackend* tracker_test_backend_construct (GType object_type) {
	TrackerTestBackend* self = NULL;
#line 38 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	self = (TrackerTestBackend*) g_type_create_instance (object_type);
#line 40 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	tracker_test_backend_set_debug (self, FALSE);
#line 41 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
#line 41 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	self->priv->_contacts = NULL;
#line 38 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	return self;
#line 156 "backend.c"
}


TrackerTestBackend* tracker_test_backend_new (void) {
#line 38 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	return tracker_test_backend_construct (TRACKER_TEST_TYPE_BACKEND);
#line 163 "backend.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 47 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	return self ? g_object_ref (self) : NULL;
#line 170 "backend.c"
}


void tracker_test_backend_add_contact (TrackerTestBackend* self, GeeHashMap* c) {
	GeeHashMap* contact;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
#line 44 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_if_fail (self != NULL);
#line 44 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_if_fail (c != NULL);
#line 46 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp0_ = c;
#line 46 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp1_ = _tracker_test_backend_copy_hash_map (self, _tmp0_);
#line 46 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	contact = _tmp1_;
#line 47 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp2_ = _g_object_ref0 (contact);
#line 47 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	self->priv->_contacts = g_list_prepend (self->priv->_contacts, _tmp2_);
#line 44 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_g_object_unref0 (contact);
#line 195 "backend.c"
}


void tracker_test_backend_tear_down (TrackerTestBackend* self) {
#line 51 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_if_fail (self != NULL);
#line 53 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	tracker_test_backend_reset (self);
#line 54 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_g_object_unref0 (self->priv->_connection);
#line 54 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	self->priv->_connection = NULL;
#line 208 "backend.c"
}


void tracker_test_backend_reset (TrackerTestBackend* self) {
#line 57 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_if_fail (self != NULL);
#line 59 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
#line 59 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	self->priv->_contacts = NULL;
#line 219 "backend.c"
}


void tracker_test_backend_set_up (TrackerTestBackend* self) {
	GError * _inner_error_ = NULL;
#line 63 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_if_fail (self != NULL);
#line 227 "backend.c"
	{
#line 67 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tracker_test_backend_setup_connection (self, &_inner_error_);
#line 67 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 67 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			if (_inner_error_->domain == TRACKER_TEST_BACKEND_SETUP_ERROR) {
#line 235 "backend.c"
				goto __catch0_tracker_test_backend_setup_error;
			}
#line 67 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 67 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			g_clear_error (&_inner_error_);
#line 67 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			return;
#line 244 "backend.c"
		}
#line 68 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tracker_test_backend_add_contacts (self, &_inner_error_);
#line 68 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 68 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			if (_inner_error_->domain == TRACKER_TEST_BACKEND_SETUP_ERROR) {
#line 252 "backend.c"
				goto __catch0_tracker_test_backend_setup_error;
			}
#line 68 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 68 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			g_clear_error (&_inner_error_);
#line 68 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			return;
#line 261 "backend.c"
		}
	}
	goto __finally0;
	__catch0_tracker_test_backend_setup_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
#line 65 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		e = _inner_error_;
#line 65 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = NULL;
#line 72 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp0_ = e;
#line 72 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp1_ = _tmp0_->message;
#line 72 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		g_warning ("backend.vala:72: unable to create test data: %s\n", _tmp1_);
#line 65 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_error_free0 (e);
#line 282 "backend.c"
	}
	__finally0:
#line 65 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 65 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 65 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		g_clear_error (&_inner_error_);
#line 65 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		return;
#line 293 "backend.c"
	}
}


gboolean tracker_test_backend_update_contact (TrackerTestBackend* self, const gchar* contact_urn, const gchar* predicate, const gchar* literal_subject) {
	gboolean result = FALSE;
#line 79 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	static const char delete_query_t[] = "DELETE { %s %s ?a } WHERE " "{ ?p a nco:PersonContact " " ; %s ?a . FILTER(?p = %s ) } ";
#line 82 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	static const char update_query_t[] = "INSERT { %s %s '%s' } ";
#line 304 "backend.c"
	gchar* delete_query;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	gchar* update_query;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gboolean _tmp12_;
#line 76 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 76 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (contact_urn != NULL, FALSE);
#line 76 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (predicate != NULL, FALSE);
#line 76 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (literal_subject != NULL, FALSE);
#line 84 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp0_ = contact_urn;
#line 84 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp1_ = predicate;
#line 84 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp2_ = predicate;
#line 84 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp3_ = contact_urn;
#line 84 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp4_ = g_strdup_printf (delete_query_t, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 84 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	delete_query = _tmp4_;
#line 86 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp5_ = delete_query;
#line 86 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp6_ = _tracker_test_backend_do_update_query (self, _tmp5_);
#line 86 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (_tmp6_ == FALSE) {
#line 88 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		g_warning ("backend.vala:88: Couldn't delete the old triplet");
#line 89 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		result = FALSE;
#line 89 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_free0 (delete_query);
#line 89 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		return result;
#line 354 "backend.c"
	}
#line 92 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp7_ = contact_urn;
#line 92 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp8_ = predicate;
#line 92 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp9_ = literal_subject;
#line 92 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp10_ = g_strdup_printf (update_query_t, _tmp7_, _tmp8_, _tmp9_);
#line 92 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	update_query = _tmp10_;
#line 94 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp11_ = update_query;
#line 94 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp12_ = _tracker_test_backend_do_update_query (self, _tmp11_);
#line 94 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (_tmp12_ == FALSE) {
#line 96 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		g_warning ("backend.vala:96: Couldn't insert the triplet");
#line 97 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		result = FALSE;
#line 97 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_free0 (update_query);
#line 97 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_free0 (delete_query);
#line 97 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		return result;
#line 382 "backend.c"
	}
#line 100 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	result = TRUE;
#line 100 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_g_free0 (update_query);
#line 100 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_g_free0 (delete_query);
#line 100 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	return result;
#line 392 "backend.c"
}


gboolean tracker_test_backend_update_favourite (TrackerTestBackend* self, const gchar* contact_urn, gboolean is_favourite) {
	gboolean result = FALSE;
	gchar* q;
	gchar* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gboolean _tmp12_;
#line 103 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 103 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (contact_urn != NULL, FALSE);
#line 105 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp0_ = g_strdup ("");
#line 105 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	q = _tmp0_;
#line 107 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp1_ = is_favourite;
#line 107 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (_tmp1_) {
#line 420 "backend.c"
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 109 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp2_ = q;
#line 109 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp3_ = g_strconcat (_tmp2_, "INSERT { ", NULL);
#line 109 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_free0 (q);
#line 109 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		q = _tmp3_;
#line 431 "backend.c"
	} else {
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 113 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp4_ = q;
#line 113 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp5_ = g_strconcat (_tmp4_, "DELETE { ", NULL);
#line 113 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_free0 (q);
#line 113 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		q = _tmp5_;
#line 443 "backend.c"
	}
#line 115 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp6_ = q;
#line 115 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp7_ = contact_urn;
#line 115 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp8_ = g_strconcat (_tmp7_, " nao:hasTag nao:predefined-tag-favorite } ", NULL);
#line 115 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp9_ = _tmp8_;
#line 115 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp10_ = g_strconcat (_tmp6_, _tmp9_, NULL);
#line 115 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_g_free0 (q);
#line 115 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	q = _tmp10_;
#line 115 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_g_free0 (_tmp9_);
#line 117 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp11_ = q;
#line 117 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp12_ = _tracker_test_backend_do_update_query (self, _tmp11_);
#line 117 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (_tmp12_ == FALSE) {
#line 119 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		g_warning ("backend.vala:119: Couldn't change favourite status");
#line 120 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		result = FALSE;
#line 120 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_free0 (q);
#line 120 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		return result;
#line 475 "backend.c"
	}
#line 123 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	result = TRUE;
#line 123 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_g_free0 (q);
#line 123 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	return result;
#line 483 "backend.c"
}


gboolean tracker_test_backend_remove_contact (TrackerTestBackend* self, const gchar* tracker_id) {
	gboolean result = FALSE;
	gchar* delete_query;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp11_;
#line 126 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 126 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (tracker_id != NULL, FALSE);
#line 128 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp0_ = g_strdup ("DELETE { ?p a nco:PersonContact } ");
#line 128 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	delete_query = _tmp0_;
#line 129 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp1_ = delete_query;
#line 129 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp2_ = g_strconcat (_tmp1_, "WHERE { ?p a nco:PersonContact . FILTER(tracker:id(?p) ", NULL);
#line 129 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_g_free0 (delete_query);
#line 129 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	delete_query = _tmp2_;
#line 130 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp3_ = delete_query;
#line 130 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp4_ = tracker_id;
#line 130 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp5_ = g_strconcat ("= ", _tmp4_, NULL);
#line 130 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp6_ = _tmp5_;
#line 130 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp7_ = g_strconcat (_tmp6_, ") } ", NULL);
#line 130 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp8_ = _tmp7_;
#line 130 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp9_ = g_strconcat (_tmp3_, _tmp8_, NULL);
#line 130 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_g_free0 (delete_query);
#line 130 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	delete_query = _tmp9_;
#line 130 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_g_free0 (_tmp8_);
#line 130 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_g_free0 (_tmp6_);
#line 132 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp10_ = delete_query;
#line 132 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp11_ = _tracker_test_backend_do_update_query (self, _tmp10_);
#line 132 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (_tmp11_ == FALSE) {
#line 134 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		g_warning ("backend.vala:134: Couldn't delete the contact");
#line 135 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		result = FALSE;
#line 135 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_free0 (delete_query);
#line 135 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		return result;
#line 554 "backend.c"
	}
#line 138 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	result = TRUE;
#line 138 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_g_free0 (delete_query);
#line 138 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	return result;
#line 562 "backend.c"
}


gboolean tracker_test_backend_remove_triplet (TrackerTestBackend* self, const gchar* subject_urn, const gchar* pred, const gchar* object_urn) {
	gboolean result = FALSE;
	TrackerSparqlBuilder* builder;
	TrackerSparqlBuilder* _tmp0_;
	TrackerSparqlBuilder* _tmp1_;
	TrackerSparqlBuilder* _tmp2_;
	const gchar* _tmp3_;
	TrackerSparqlBuilder* _tmp4_;
	const gchar* _tmp5_;
	TrackerSparqlBuilder* _tmp6_;
	const gchar* _tmp7_;
	TrackerSparqlBuilder* _tmp8_;
	TrackerSparqlBuilder* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gboolean _tmp12_;
#line 141 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 141 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (subject_urn != NULL, FALSE);
#line 141 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (pred != NULL, FALSE);
#line 141 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (object_urn != NULL, FALSE);
#line 144 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp0_ = tracker_sparql_builder_new_update ();
#line 144 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	builder = _tmp0_;
#line 145 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp1_ = builder;
#line 145 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	tracker_sparql_builder_delete_open (_tmp1_, NULL);
#line 146 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp2_ = builder;
#line 146 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp3_ = subject_urn;
#line 146 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	tracker_sparql_builder_subject (_tmp2_, _tmp3_);
#line 147 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp4_ = builder;
#line 147 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp5_ = pred;
#line 147 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	tracker_sparql_builder_predicate (_tmp4_, _tmp5_);
#line 148 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp6_ = builder;
#line 148 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp7_ = object_urn;
#line 148 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	tracker_sparql_builder_object (_tmp6_, _tmp7_);
#line 149 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp8_ = builder;
#line 149 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	tracker_sparql_builder_delete_close (_tmp8_);
#line 151 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp9_ = builder;
#line 151 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp10_ = tracker_sparql_builder_get_result (_tmp9_);
#line 151 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp11_ = _tmp10_;
#line 151 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp12_ = _tracker_test_backend_do_update_query (self, _tmp11_);
#line 151 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (_tmp12_ == FALSE) {
#line 630 "backend.c"
		TrackerSparqlBuilder* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
#line 153 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp13_ = builder;
#line 153 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp14_ = tracker_sparql_builder_get_result (_tmp13_);
#line 153 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp15_ = _tmp14_;
#line 153 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		g_warning ("backend.vala:153: Couldn't delete triplet with query: %s\n", _tmp15_);
#line 155 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		result = FALSE;
#line 155 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_object_unref0 (builder);
#line 155 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		return result;
#line 648 "backend.c"
	}
#line 158 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	result = TRUE;
#line 158 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_g_object_unref0 (builder);
#line 158 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	return result;
#line 656 "backend.c"
}


gboolean tracker_test_backend_insert_triplet (TrackerTestBackend* self, const gchar* subject_iri, const gchar* pred, const gchar* object_iri, const gchar* pred_b, const gchar* obj_literal_b, const gchar* pred_c, const gchar* obj_literal_c) {
	gboolean result = FALSE;
	TrackerSparqlBuilder* builder;
	TrackerSparqlBuilder* _tmp0_;
	TrackerSparqlBuilder* _tmp1_;
	TrackerSparqlBuilder* _tmp2_;
	const gchar* _tmp3_;
	TrackerSparqlBuilder* _tmp4_;
	const gchar* _tmp5_;
	TrackerSparqlBuilder* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp13_;
	TrackerSparqlBuilder* _tmp18_;
	TrackerSparqlBuilder* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gboolean _tmp22_;
#line 161 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 161 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (subject_iri != NULL, FALSE);
#line 161 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (pred != NULL, FALSE);
#line 161 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (object_iri != NULL, FALSE);
#line 166 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp0_ = tracker_sparql_builder_new_update ();
#line 166 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	builder = _tmp0_;
#line 167 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp1_ = builder;
#line 167 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	tracker_sparql_builder_insert_open (_tmp1_, NULL);
#line 168 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp2_ = builder;
#line 168 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp3_ = subject_iri;
#line 168 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	tracker_sparql_builder_subject (_tmp2_, _tmp3_);
#line 169 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp4_ = builder;
#line 169 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp5_ = pred;
#line 169 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	tracker_sparql_builder_predicate (_tmp4_, _tmp5_);
#line 170 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp6_ = builder;
#line 170 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp7_ = object_iri;
#line 170 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	tracker_sparql_builder_object (_tmp6_, _tmp7_);
#line 172 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp8_ = pred_b;
#line 172 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (_tmp8_ != NULL) {
#line 716 "backend.c"
		TrackerSparqlBuilder* _tmp9_;
		const gchar* _tmp10_;
		TrackerSparqlBuilder* _tmp11_;
		const gchar* _tmp12_;
#line 174 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp9_ = builder;
#line 174 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp10_ = pred_b;
#line 174 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		tracker_sparql_builder_predicate (_tmp9_, _tmp10_);
#line 175 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp11_ = builder;
#line 175 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp12_ = obj_literal_b;
#line 175 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		tracker_sparql_builder_object_string (_tmp11_, _tmp12_);
#line 733 "backend.c"
	}
#line 178 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp13_ = pred_c;
#line 178 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (_tmp13_ != NULL) {
#line 739 "backend.c"
		TrackerSparqlBuilder* _tmp14_;
		const gchar* _tmp15_;
		TrackerSparqlBuilder* _tmp16_;
		const gchar* _tmp17_;
#line 180 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp14_ = builder;
#line 180 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp15_ = pred_c;
#line 180 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		tracker_sparql_builder_predicate (_tmp14_, _tmp15_);
#line 181 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp16_ = builder;
#line 181 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp17_ = obj_literal_c;
#line 181 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		tracker_sparql_builder_object_string (_tmp16_, _tmp17_);
#line 756 "backend.c"
	}
#line 184 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp18_ = builder;
#line 184 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	tracker_sparql_builder_insert_close (_tmp18_);
#line 186 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp19_ = builder;
#line 186 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp20_ = tracker_sparql_builder_get_result (_tmp19_);
#line 186 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp21_ = _tmp20_;
#line 186 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp22_ = _tracker_test_backend_do_update_query (self, _tmp21_);
#line 186 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (_tmp22_ == FALSE) {
#line 772 "backend.c"
		TrackerSparqlBuilder* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
#line 188 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp23_ = builder;
#line 188 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp24_ = tracker_sparql_builder_get_result (_tmp23_);
#line 188 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp25_ = _tmp24_;
#line 188 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		g_warning ("backend.vala:188: Couldn't insert triplet with query: %s\n", _tmp25_);
#line 190 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		result = FALSE;
#line 190 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_object_unref0 (builder);
#line 190 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		return result;
#line 790 "backend.c"
	}
#line 193 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	result = TRUE;
#line 193 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_g_object_unref0 (builder);
#line 193 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	return result;
#line 798 "backend.c"
}


static gboolean _tracker_test_backend_do_update_query (TrackerTestBackend* self, const gchar* query) {
	gboolean result = FALSE;
	gboolean ret;
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
#line 196 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 196 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (query != NULL, FALSE);
#line 198 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	ret = FALSE;
#line 200 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp0_ = self->priv->_debug;
#line 200 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (_tmp0_) {
#line 817 "backend.c"
		FILE* _tmp1_;
		const gchar* _tmp2_;
#line 202 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp1_ = stdout;
#line 202 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp2_ = query;
#line 202 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		fprintf (_tmp1_, "_do_update_query : %s\n", _tmp2_);
#line 826 "backend.c"
	}
	{
		TrackerSparqlConnection* _tmp3_;
		const gchar* _tmp4_;
#line 207 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp3_ = self->priv->_connection;
#line 207 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp4_ = query;
#line 207 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		tracker_sparql_connection_update (_tmp3_, _tmp4_, G_PRIORITY_DEFAULT, NULL, &_inner_error_);
#line 207 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 207 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 841 "backend.c"
				goto __catch1_tracker_sparql_error;
			}
#line 207 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 846 "backend.c"
				goto __catch1_g_io_error;
			}
#line 207 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			if (_inner_error_->domain == G_DBUS_ERROR) {
#line 851 "backend.c"
				goto __catch1_g_dbus_error;
			}
			goto __catch1_g_error;
		}
#line 208 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		ret = TRUE;
#line 858 "backend.c"
	}
	goto __finally1;
	__catch1_tracker_sparql_error:
	{
		GError* e1 = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
#line 205 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		e1 = _inner_error_;
#line 205 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = NULL;
#line 212 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp5_ = e1;
#line 212 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp6_ = _tmp5_->message;
#line 212 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		g_warning ("backend.vala:212: Problem getting connection : %s\n", _tmp6_);
#line 205 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_error_free0 (e1);
#line 878 "backend.c"
	}
	goto __finally1;
	__catch1_g_io_error:
	{
		GError* e2 = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
#line 205 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		e2 = _inner_error_;
#line 205 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = NULL;
#line 216 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp7_ = e2;
#line 216 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp8_ = _tmp7_->message;
#line 216 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		g_warning ("backend.vala:216: Problem saving data : %s\n", _tmp8_);
#line 205 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_error_free0 (e2);
#line 898 "backend.c"
	}
	goto __finally1;
	__catch1_g_dbus_error:
	{
		GError* e3 = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
#line 205 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		e3 = _inner_error_;
#line 205 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = NULL;
#line 220 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp9_ = e3;
#line 220 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp10_ = _tmp9_->message;
#line 220 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		g_warning ("backend.vala:220: Problem with the D-Bus connection : %s\n", _tmp10_);
#line 205 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_error_free0 (e3);
#line 918 "backend.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e4 = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
#line 205 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		e4 = _inner_error_;
#line 205 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = NULL;
#line 224 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp11_ = e4;
#line 224 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp12_ = _tmp11_->message;
#line 224 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		g_warning ("backend.vala:224: Problem in general: %s", _tmp12_);
#line 205 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_error_free0 (e4);
#line 938 "backend.c"
	}
	__finally1:
#line 205 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 205 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 205 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		g_clear_error (&_inner_error_);
#line 205 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		return FALSE;
#line 949 "backend.c"
	}
#line 227 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	result = ret;
#line 227 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	return result;
#line 955 "backend.c"
}


static GeeHashMap* _tracker_test_backend_copy_hash_map (TrackerTestBackend* self, GeeHashMap* orig) {
	GeeHashMap* result = NULL;
	GeeHashMap* copy;
	GeeHashMap* _tmp0_;
#line 230 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 230 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (orig != NULL, NULL);
#line 233 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 233 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	copy = _tmp0_;
#line 971 "backend.c"
	{
		GeeIterator* _k_it;
		GeeHashMap* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
#line 234 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp1_ = orig;
#line 234 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp2_ = gee_abstract_map_get_keys ((GeeMap*) _tmp1_);
#line 234 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp3_ = _tmp2_;
#line 234 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp4_ = _tmp3_;
#line 234 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 234 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp6_ = _tmp5_;
#line 234 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_object_unref0 (_tmp4_);
#line 234 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_k_it = _tmp6_;
#line 234 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		while (TRUE) {
#line 998 "backend.c"
			GeeIterator* _tmp7_;
			gboolean _tmp8_;
			gchar* k;
			GeeIterator* _tmp9_;
			gpointer _tmp10_;
			gchar* v;
			GeeHashMap* _tmp11_;
			const gchar* _tmp12_;
			gpointer _tmp13_;
			GeeHashMap* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
#line 234 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp7_ = _k_it;
#line 234 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp8_ = gee_iterator_next (_tmp7_);
#line 234 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			if (!_tmp8_) {
#line 234 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				break;
#line 1023 "backend.c"
			}
#line 234 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp9_ = _k_it;
#line 234 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp10_ = gee_iterator_get (_tmp9_);
#line 234 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			k = (gchar*) _tmp10_;
#line 236 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp11_ = orig;
#line 236 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp12_ = k;
#line 236 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, _tmp12_);
#line 236 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			v = (gchar*) _tmp13_;
#line 237 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp14_ = copy;
#line 237 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp15_ = k;
#line 237 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp16_ = g_strdup (_tmp15_);
#line 237 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp17_ = _tmp16_;
#line 237 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp18_ = v;
#line 237 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp19_ = g_strdup (_tmp18_);
#line 237 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp20_ = _tmp19_;
#line 237 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, _tmp17_, _tmp20_);
#line 237 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_g_free0 (_tmp20_);
#line 237 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_g_free0 (_tmp17_);
#line 234 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_g_free0 (v);
#line 234 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_g_free0 (k);
#line 1063 "backend.c"
		}
#line 234 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_object_unref0 (_k_it);
#line 1067 "backend.c"
	}
#line 239 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	result = copy;
#line 239 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	return result;
#line 1073 "backend.c"
}


static void _tracker_test_backend_setup_connection (TrackerTestBackend* self, GError** error) {
	GError * _inner_error_ = NULL;
#line 242 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_if_fail (self != NULL);
#line 1081 "backend.c"
	{
		TrackerSparqlConnection* _tmp0_;
		TrackerSparqlConnection* _tmp1_;
		TrackerSparqlConnection* _tmp2_;
#line 246 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp1_ = tracker_sparql_connection_get (NULL, &_inner_error_);
#line 246 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp0_ = _tmp1_;
#line 246 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 246 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 1094 "backend.c"
				goto __catch2_g_io_error;
			}
#line 246 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1099 "backend.c"
				goto __catch2_tracker_sparql_error;
			}
#line 246 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			if (_inner_error_->domain == G_DBUS_ERROR) {
#line 1104 "backend.c"
				goto __catch2_g_dbus_error;
			}
#line 246 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			if (_inner_error_->domain == G_SPAWN_ERROR) {
#line 1109 "backend.c"
				goto __catch2_g_spawn_error;
			}
#line 246 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 246 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			g_clear_error (&_inner_error_);
#line 246 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			return;
#line 1118 "backend.c"
		}
#line 246 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp2_ = _tmp0_;
#line 246 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp0_ = NULL;
#line 246 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_object_unref0 (self->priv->_connection);
#line 246 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		self->priv->_connection = _tmp2_;
#line 244 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_object_unref0 (_tmp0_);
#line 1130 "backend.c"
	}
	goto __finally2;
	__catch2_g_io_error:
	{
		GError* e1 = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		GError* _tmp5_;
#line 244 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		e1 = _inner_error_;
#line 244 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = NULL;
#line 250 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp3_ = e1;
#line 250 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp4_ = _tmp3_->message;
#line 250 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp5_ = g_error_new (TRACKER_TEST_BACKEND_SETUP_ERROR, TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED, "Could not connect to D-Bus service : %s\n", _tmp4_);
#line 250 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = _tmp5_;
#line 250 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_error_free0 (e1);
#line 1153 "backend.c"
		goto __finally2;
	}
	goto __finally2;
	__catch2_tracker_sparql_error:
	{
		GError* e2 = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		GError* _tmp8_;
#line 244 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		e2 = _inner_error_;
#line 244 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = NULL;
#line 255 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp6_ = e2;
#line 255 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp7_ = _tmp6_->message;
#line 255 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp8_ = g_error_new (TRACKER_TEST_BACKEND_SETUP_ERROR, TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED, "Error fetching SPARQL connection handler : %s\n", _tmp7_);
#line 255 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = _tmp8_;
#line 255 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_error_free0 (e2);
#line 1177 "backend.c"
		goto __finally2;
	}
	goto __finally2;
	__catch2_g_dbus_error:
	{
		GError* e3 = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		GError* _tmp11_;
#line 244 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		e3 = _inner_error_;
#line 244 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = NULL;
#line 260 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp9_ = e3;
#line 260 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp10_ = _tmp9_->message;
#line 260 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp11_ = g_error_new (TRACKER_TEST_BACKEND_SETUP_ERROR, TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED, "Error fetching SPARQL connection handler : %s\n", _tmp10_);
#line 260 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = _tmp11_;
#line 260 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_error_free0 (e3);
#line 1201 "backend.c"
		goto __finally2;
	}
	goto __finally2;
	__catch2_g_spawn_error:
	{
		GError* e4 = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		GError* _tmp14_;
#line 244 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		e4 = _inner_error_;
#line 244 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = NULL;
#line 265 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp12_ = e4;
#line 265 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp13_ = _tmp12_->message;
#line 265 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp14_ = g_error_new (TRACKER_TEST_BACKEND_SETUP_ERROR, TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED, "Error fetching SPARQL connection handler : %s\n", _tmp13_);
#line 265 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = _tmp14_;
#line 265 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_error_free0 (e4);
#line 1225 "backend.c"
		goto __finally2;
	}
	__finally2:
#line 244 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 244 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		if (_inner_error_->domain == TRACKER_TEST_BACKEND_SETUP_ERROR) {
#line 244 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			g_propagate_error (error, _inner_error_);
#line 244 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			return;
#line 1237 "backend.c"
		} else {
#line 244 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 244 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			g_clear_error (&_inner_error_);
#line 244 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			return;
#line 1245 "backend.c"
		}
	}
}


static void _tracker_test_backend_add_contacts (TrackerTestBackend* self, GError** error) {
	gchar* query;
	gchar* _tmp0_;
	GList* _tmp1_;
	GError * _inner_error_ = NULL;
#line 270 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_if_fail (self != NULL);
#line 272 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp0_ = g_strdup ("");
#line 272 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	query = _tmp0_;
#line 274 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	self->priv->_contacts = g_list_reverse (self->priv->_contacts);
#line 275 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp1_ = self->priv->_contacts;
#line 1266 "backend.c"
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
#line 275 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		c_collection = _tmp1_;
#line 275 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
#line 1274 "backend.c"
			GeeHashMap* _tmp2_;
			GeeHashMap* c = NULL;
#line 275 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp2_ = _g_object_ref0 ((GeeHashMap*) c_it->data);
#line 275 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			c = _tmp2_;
#line 1281 "backend.c"
			{
				const gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				GeeHashMap* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
#line 277 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp3_ = query;
#line 277 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp4_ = g_strconcat (_tmp3_, "\n", NULL);
#line 277 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp5_ = _tmp4_;
#line 277 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp6_ = c;
#line 277 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp7_ = _tracker_test_backend_get_insert_query (self, _tmp6_);
#line 277 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp8_ = _tmp7_;
#line 277 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp9_ = g_strconcat (_tmp5_, _tmp8_, NULL);
#line 277 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_g_free0 (query);
#line 277 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				query = _tmp9_;
#line 277 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_g_free0 (_tmp8_);
#line 277 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_g_free0 (_tmp5_);
#line 275 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_g_object_unref0 (c);
#line 1314 "backend.c"
			}
		}
	}
	{
		TrackerSparqlConnection* _tmp10_;
		const gchar* _tmp11_;
#line 282 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp10_ = self->priv->_connection;
#line 282 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp11_ = query;
#line 282 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		tracker_sparql_connection_update (_tmp10_, _tmp11_, G_PRIORITY_DEFAULT, NULL, &_inner_error_);
#line 282 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 282 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1331 "backend.c"
				goto __catch3_tracker_sparql_error;
			}
#line 282 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 1336 "backend.c"
				goto __catch3_g_io_error;
			}
#line 282 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			if (_inner_error_->domain == G_DBUS_ERROR) {
#line 1341 "backend.c"
				goto __catch3_g_dbus_error;
			}
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_tracker_sparql_error:
	{
		GError* e1 = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		GError* _tmp14_;
#line 280 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		e1 = _inner_error_;
#line 280 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = NULL;
#line 286 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp12_ = e1;
#line 286 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp13_ = _tmp12_->message;
#line 286 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp14_ = g_error_new (TRACKER_TEST_BACKEND_SETUP_ERROR, TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED, "Problem getting connection : %s\n", _tmp13_);
#line 286 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = _tmp14_;
#line 286 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_error_free0 (e1);
#line 1368 "backend.c"
		goto __finally3;
	}
	goto __finally3;
	__catch3_g_io_error:
	{
		GError* e2 = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		GError* _tmp17_;
#line 280 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		e2 = _inner_error_;
#line 280 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = NULL;
#line 291 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp15_ = e2;
#line 291 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp16_ = _tmp15_->message;
#line 291 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp17_ = g_error_new (TRACKER_TEST_BACKEND_SETUP_ERROR, TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED, "Error fetching SPARQL connection handler : %s\n", _tmp16_);
#line 291 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = _tmp17_;
#line 291 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_error_free0 (e2);
#line 1392 "backend.c"
		goto __finally3;
	}
	goto __finally3;
	__catch3_g_dbus_error:
	{
		GError* e3 = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		GError* _tmp20_;
#line 280 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		e3 = _inner_error_;
#line 280 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = NULL;
#line 296 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp18_ = e3;
#line 296 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp19_ = _tmp18_->message;
#line 296 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp20_ = g_error_new (TRACKER_TEST_BACKEND_SETUP_ERROR, TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED, "Could not connect to D-Bus service : %s\n", _tmp19_);
#line 296 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = _tmp20_;
#line 296 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_error_free0 (e3);
#line 1416 "backend.c"
		goto __finally3;
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e4 = NULL;
		GError* _tmp21_;
		const gchar* _tmp22_;
#line 280 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		e4 = _inner_error_;
#line 280 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = NULL;
#line 301 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp21_ = e4;
#line 301 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp22_ = _tmp21_->message;
#line 301 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		g_warning ("backend.vala:301: Problem in general: %s", _tmp22_);
#line 280 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_error_free0 (e4);
#line 1437 "backend.c"
	}
	__finally3:
#line 280 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 280 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		if (_inner_error_->domain == TRACKER_TEST_BACKEND_SETUP_ERROR) {
#line 280 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			g_propagate_error (error, _inner_error_);
#line 280 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_g_free0 (query);
#line 280 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			return;
#line 1450 "backend.c"
		} else {
#line 280 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_g_free0 (query);
#line 280 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 280 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			g_clear_error (&_inner_error_);
#line 280 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			return;
#line 1460 "backend.c"
		}
	}
#line 270 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_g_free0 (query);
#line 1465 "backend.c"
}


static gchar* _tracker_test_backend_get_insert_query (TrackerTestBackend* self, GeeHashMap* contact) {
	gchar* result = NULL;
#line 307 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	static const char q_photo_uri_t[] = " . <%s> a nfo:Image, " "nie:DataObject ; nie:url '%s' ; nie:title '%s' ";
#line 309 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	static const char im_addr_t[] = " . <%s> a nco:IMAddress, " "nie:InformationElement; nco:imProtocol " "'%s' ; nco:imID '%s';   " "nco:imNickname '%s'; " "nco:imPresence nco:presence-status-available " " . <%smyimaccount> a nco:IMAccount; " "nco:imDisplayName '%s'; nco:hasIMContact " "<%s>  ";
#line 317 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	static const char affl_t[] = " . <%smyaffiliation> a nco:Affiliation " " . <%smyaffiliation> nco:hasIMAddress " " <%s>  ";
#line 320 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	static const char af_t[] = " . <affl:001> a nco:Affiliation; " "nco:title '%s'; nco:department '%s'; nco:role '%s' ";
#line 322 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	static const char postal_t[] = " . <affl:001> a nco:Affiliation ; " "nco:hasPostalAddress <postal:001> . " " <postal:001> a nco:PostalAddress ; " "nco:pobox '%s'; " "nco:district '%s'; " "nco:county '%s'; " "nco:locality '%s'; " "nco:postalcode '%s'; " "nco:streetAddress '%s'; " "nco:addressLocation '%s'; " "nco:extendedAddress '%s'; " "nco:country '%s'; " "nco:region '%s' ";
#line 1481 "backend.c"
	gchar* urn_contact = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_ = NULL;
	gboolean _tmp2_;
	gchar* photo_uri;
	gchar* _tmp4_;
	gchar* q;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GeeHashMap* addresses;
	gchar** phones;
	gint phones_length1;
	gint _phones_size_;
	gchar** emails;
	gint emails_length1;
	gint _emails_size_;
	gchar** urls;
	gint urls_length1;
	gint _urls_size_;
	gchar* affiliation;
	gchar* _tmp10_;
	gchar* postal_address;
	gchar* _tmp11_;
	const gchar* _tmp109_;
	gboolean _tmp117_ = FALSE;
	GeeHashMap* _tmp118_;
	gboolean _tmp153_ = FALSE;
	gchar** _tmp154_;
	gint _tmp154__length1;
	gboolean _tmp167_ = FALSE;
	gchar** _tmp168_;
	gint _tmp168__length1;
	gboolean _tmp181_ = FALSE;
	gchar** _tmp182_;
	gint _tmp182__length1;
	const gchar* _tmp197_;
	const gchar* _tmp211_;
	const gchar* _tmp239_;
	gchar* _tmp240_;
	gboolean _tmp241_;
#line 305 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 305 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (contact != NULL, NULL);
#line 337 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp0_ = contact;
#line 337 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp2_ = gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, TRACKER_TEST_BACKEND_URN, &_tmp1_);
#line 337 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_g_free0 (urn_contact);
#line 337 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	urn_contact = _tmp1_;
#line 337 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (_tmp2_ == FALSE) {
#line 1539 "backend.c"
		gchar* _tmp3_;
#line 339 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp3_ = g_strdup ("_:x");
#line 339 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_free0 (urn_contact);
#line 339 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		urn_contact = _tmp3_;
#line 1547 "backend.c"
	}
#line 342 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp4_ = g_strdup ("");
#line 342 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	photo_uri = _tmp4_;
#line 343 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp5_ = urn_contact;
#line 343 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp6_ = g_strconcat ("INSERT { ", _tmp5_, NULL);
#line 343 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp7_ = _tmp6_;
#line 343 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp8_ = g_strconcat (_tmp7_, " a nco:PersonContact  ", NULL);
#line 343 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp9_ = _tmp8_;
#line 343 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_g_free0 (_tmp7_);
#line 343 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	q = _tmp9_;
#line 344 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	addresses = NULL;
#line 345 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	phones = NULL;
#line 345 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	phones_length1 = 0;
#line 345 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_phones_size_ = phones_length1;
#line 346 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	emails = NULL;
#line 346 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	emails_length1 = 0;
#line 346 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_emails_size_ = emails_length1;
#line 347 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	urls = NULL;
#line 347 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	urls_length1 = 0;
#line 347 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_urls_size_ = urls_length1;
#line 348 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp10_ = g_strdup ("");
#line 348 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	affiliation = _tmp10_;
#line 349 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp11_ = g_strdup ("");
#line 349 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	postal_address = _tmp11_;
#line 1595 "backend.c"
	{
		GeeIterator* _k_it;
		GeeHashMap* _tmp12_;
		GeeSet* _tmp13_;
		GeeSet* _tmp14_;
		GeeSet* _tmp15_;
		GeeIterator* _tmp16_;
		GeeIterator* _tmp17_;
#line 351 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp12_ = contact;
#line 351 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp13_ = gee_abstract_map_get_keys ((GeeMap*) _tmp12_);
#line 351 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp14_ = _tmp13_;
#line 351 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp15_ = _tmp14_;
#line 351 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp16_ = gee_iterable_iterator ((GeeIterable*) _tmp15_);
#line 351 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp17_ = _tmp16_;
#line 351 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_object_unref0 (_tmp15_);
#line 351 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_k_it = _tmp17_;
#line 351 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		while (TRUE) {
#line 1622 "backend.c"
			GeeIterator* _tmp18_;
			gboolean _tmp19_;
			gchar* k;
			GeeIterator* _tmp20_;
			gpointer _tmp21_;
			gchar* v;
			GeeHashMap* _tmp22_;
			const gchar* _tmp23_;
			gpointer _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp98_;
			gchar* _tmp99_;
			gchar* s;
			const gchar* _tmp100_;
			gchar* _tmp101_;
			gchar* _tmp102_;
			const gchar* _tmp103_;
			gchar* _tmp104_;
			gchar* _tmp105_;
			const gchar* _tmp106_;
			const gchar* _tmp107_;
			gchar* _tmp108_;
#line 351 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp18_ = _k_it;
#line 351 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp19_ = gee_iterator_next (_tmp18_);
#line 351 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			if (!_tmp19_) {
#line 351 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				break;
#line 1653 "backend.c"
			}
#line 351 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp20_ = _k_it;
#line 351 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp21_ = gee_iterator_get (_tmp20_);
#line 351 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			k = (gchar*) _tmp21_;
#line 353 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp22_ = contact;
#line 353 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp23_ = k;
#line 353 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp24_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp22_, _tmp23_);
#line 353 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			v = (gchar*) _tmp24_;
#line 354 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp25_ = k;
#line 354 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			if (g_strcmp0 (_tmp25_, TRF_ONTOLOGY_DEFS_NCO_PHOTO) == 0) {
#line 1673 "backend.c"
				const gchar* _tmp26_;
				gchar* _tmp27_;
				const gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
#line 356 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp26_ = v;
#line 356 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp27_ = g_strdup (_tmp26_);
#line 356 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_g_free0 (photo_uri);
#line 356 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				photo_uri = _tmp27_;
#line 357 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp28_ = v;
#line 357 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp29_ = g_strconcat ("<", _tmp28_, NULL);
#line 357 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp30_ = _tmp29_;
#line 357 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp31_ = g_strconcat (_tmp30_, ">", NULL);
#line 357 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_g_free0 (v);
#line 357 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				v = _tmp31_;
#line 357 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_g_free0 (_tmp30_);
#line 1702 "backend.c"
			} else {
				const gchar* _tmp32_;
#line 359 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp32_ = k;
#line 359 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				if (g_strcmp0 (_tmp32_, TRF_ONTOLOGY_DEFS_NCO_IMADDRESS) == 0) {
#line 1709 "backend.c"
					const gchar* _tmp33_;
					GeeHashMap* _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
#line 361 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp33_ = v;
#line 361 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp34_ = _tracker_test_backend_parse_addrs (self, _tmp33_);
#line 361 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_g_object_unref0 (addresses);
#line 361 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					addresses = _tmp34_;
#line 362 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp35_ = g_strdup ("");
#line 362 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_g_free0 (k);
#line 362 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					k = _tmp35_;
#line 363 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp36_ = g_strdup ("");
#line 363 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_g_free0 (v);
#line 363 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					v = _tmp36_;
#line 1734 "backend.c"
					{
						GeeIterator* _addr_it;
						GeeHashMap* _tmp37_;
						GeeSet* _tmp38_;
						GeeSet* _tmp39_;
						GeeSet* _tmp40_;
						GeeIterator* _tmp41_;
						GeeIterator* _tmp42_;
#line 364 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						_tmp37_ = addresses;
#line 364 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						_tmp38_ = gee_abstract_map_get_keys ((GeeMap*) _tmp37_);
#line 364 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						_tmp39_ = _tmp38_;
#line 364 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						_tmp40_ = _tmp39_;
#line 364 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						_tmp41_ = gee_iterable_iterator ((GeeIterable*) _tmp40_);
#line 364 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						_tmp42_ = _tmp41_;
#line 364 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						_g_object_unref0 (_tmp40_);
#line 364 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						_addr_it = _tmp42_;
#line 364 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						while (TRUE) {
#line 1761 "backend.c"
							GeeIterator* _tmp43_;
							gboolean _tmp44_;
							gchar* addr;
							GeeIterator* _tmp45_;
							gpointer _tmp46_;
							gchar* vtemp = NULL;
							gchar* _tmp47_;
							const gchar* _tmp48_;
							const gchar* _tmp49_;
							gchar* _tmp50_;
							gchar* _tmp51_;
							gchar* _tmp52_;
							gchar* _tmp53_;
							gchar* _tmp54_;
							const gchar* _tmp55_;
							const gchar* _tmp58_;
							const gchar* _tmp59_;
							gchar* _tmp60_;
#line 364 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_tmp43_ = _addr_it;
#line 364 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_tmp44_ = gee_iterator_next (_tmp43_);
#line 364 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							if (!_tmp44_) {
#line 364 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
								break;
#line 1788 "backend.c"
							}
#line 364 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_tmp45_ = _addr_it;
#line 364 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_tmp46_ = gee_iterator_get (_tmp45_);
#line 364 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							addr = (gchar*) _tmp46_;
#line 367 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_tmp47_ = g_strdup (" nco:hasAffiliation [ a nco:Affiliation ; ");
#line 367 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_g_free0 (vtemp);
#line 367 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							vtemp = _tmp47_;
#line 368 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_tmp48_ = vtemp;
#line 368 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_tmp49_ = addr;
#line 368 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_tmp50_ = g_strconcat ("nco:hasIMAddress <", _tmp49_, NULL);
#line 368 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_tmp51_ = _tmp50_;
#line 368 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_tmp52_ = g_strconcat (_tmp51_, "> ] ", NULL);
#line 368 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_tmp53_ = _tmp52_;
#line 368 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_tmp54_ = g_strconcat (_tmp48_, _tmp53_, NULL);
#line 368 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_g_free0 (vtemp);
#line 368 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							vtemp = _tmp54_;
#line 368 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_g_free0 (_tmp53_);
#line 368 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_g_free0 (_tmp51_);
#line 369 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_tmp55_ = v;
#line 369 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							if (g_strcmp0 (_tmp55_, "") != 0) {
#line 1828 "backend.c"
								const gchar* _tmp56_;
								gchar* _tmp57_;
#line 371 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
								_tmp56_ = v;
#line 371 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
								_tmp57_ = g_strconcat (_tmp56_, "; ", NULL);
#line 371 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
								_g_free0 (v);
#line 371 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
								v = _tmp57_;
#line 1839 "backend.c"
							}
#line 373 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_tmp58_ = v;
#line 373 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_tmp59_ = vtemp;
#line 373 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_tmp60_ = g_strconcat (_tmp58_, _tmp59_, NULL);
#line 373 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_g_free0 (v);
#line 373 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							v = _tmp60_;
#line 364 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_g_free0 (vtemp);
#line 364 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_g_free0 (addr);
#line 1855 "backend.c"
						}
#line 364 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						_g_object_unref0 (_addr_it);
#line 1859 "backend.c"
					}
				} else {
					const gchar* _tmp61_;
#line 376 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp61_ = k;
#line 376 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					if (g_strcmp0 (_tmp61_, TRF_ONTOLOGY_DEFS_NCO_PHONE_PROP) == 0) {
#line 1867 "backend.c"
						const gchar* _tmp62_;
						gchar** _tmp63_;
						gchar** _tmp64_;
						gchar* _tmp65_;
						gchar** _tmp66_;
						gint _tmp66__length1;
						gchar* _tmp67_;
#line 378 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						_tmp62_ = v;
#line 378 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						_tmp64_ = _tmp63_ = g_strsplit (_tmp62_, ",", 0);
#line 378 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						phones = (_vala_array_free (phones, phones_length1, (GDestroyNotify) g_free), NULL);
#line 378 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						phones = _tmp64_;
#line 378 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						phones_length1 = _vala_array_length (_tmp63_);
#line 378 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						_phones_size_ = phones_length1;
#line 379 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						_tmp65_ = g_strdup ("");
#line 379 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						_g_free0 (k);
#line 379 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						k = _tmp65_;
#line 380 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						_tmp66_ = phones;
#line 380 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						_tmp66__length1 = phones_length1;
#line 380 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						_tmp67_ = _tracker_test_backend_build_relation (self, TRF_ONTOLOGY_DEFS_NCO_HAS_AFFILIATION, _tmp66_, _tmp66__length1);
#line 380 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						_g_free0 (v);
#line 380 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						v = _tmp67_;
#line 1903 "backend.c"
					} else {
						const gchar* _tmp68_;
#line 383 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						_tmp68_ = k;
#line 383 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						if (g_strcmp0 (_tmp68_, TRF_ONTOLOGY_DEFS_NCO_EMAIL_PROP) == 0) {
#line 1910 "backend.c"
							const gchar* _tmp69_;
							gchar** _tmp70_;
							gchar** _tmp71_;
							gchar* _tmp72_;
							gchar** _tmp73_;
							gint _tmp73__length1;
							gchar* _tmp74_;
#line 385 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_tmp69_ = v;
#line 385 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_tmp71_ = _tmp70_ = g_strsplit (_tmp69_, ",", 0);
#line 385 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							emails = (_vala_array_free (emails, emails_length1, (GDestroyNotify) g_free), NULL);
#line 385 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							emails = _tmp71_;
#line 385 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							emails_length1 = _vala_array_length (_tmp70_);
#line 385 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_emails_size_ = emails_length1;
#line 386 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_tmp72_ = g_strdup ("");
#line 386 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_g_free0 (k);
#line 386 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							k = _tmp72_;
#line 387 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_tmp73_ = emails;
#line 387 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_tmp73__length1 = emails_length1;
#line 387 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_tmp74_ = _tracker_test_backend_build_relation (self, TRF_ONTOLOGY_DEFS_NCO_HAS_AFFILIATION, _tmp73_, _tmp73__length1);
#line 387 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_g_free0 (v);
#line 387 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							v = _tmp74_;
#line 1946 "backend.c"
						} else {
							const gchar* _tmp75_;
#line 390 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_tmp75_ = k;
#line 390 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							if (g_strcmp0 (_tmp75_, TRACKER_TEST_BACKEND_URLS) == 0) {
#line 1953 "backend.c"
								const gchar* _tmp76_;
								gchar** _tmp77_;
								gchar** _tmp78_;
								gchar* _tmp79_;
								gchar** _tmp80_;
								gint _tmp80__length1;
								gchar* _tmp81_;
#line 392 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
								_tmp76_ = v;
#line 392 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
								_tmp78_ = _tmp77_ = g_strsplit (_tmp76_, ",", 0);
#line 392 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
								urls = (_vala_array_free (urls, urls_length1, (GDestroyNotify) g_free), NULL);
#line 392 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
								urls = _tmp78_;
#line 392 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
								urls_length1 = _vala_array_length (_tmp77_);
#line 392 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
								_urls_size_ = urls_length1;
#line 393 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
								_tmp79_ = g_strdup ("");
#line 393 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
								_g_free0 (k);
#line 393 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
								k = _tmp79_;
#line 394 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
								_tmp80_ = urls;
#line 394 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
								_tmp80__length1 = urls_length1;
#line 394 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
								_tmp81_ = _tracker_test_backend_build_relation (self, TRF_ONTOLOGY_DEFS_NCO_HAS_AFFILIATION, _tmp80_, _tmp80__length1);
#line 394 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
								_g_free0 (v);
#line 394 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
								v = _tmp81_;
#line 1989 "backend.c"
							} else {
								const gchar* _tmp82_;
#line 397 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
								_tmp82_ = k;
#line 397 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
								if (g_strcmp0 (_tmp82_, TRF_ONTOLOGY_DEFS_NAO_TAG) == 0) {
#line 1996 "backend.c"
									gchar* _tmp83_;
#line 399 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
									_tmp83_ = g_strdup (TRF_ONTOLOGY_DEFS_NAO_FAVORITE);
#line 399 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
									_g_free0 (v);
#line 399 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
									v = _tmp83_;
#line 2004 "backend.c"
								} else {
									const gchar* _tmp84_;
#line 401 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
									_tmp84_ = k;
#line 401 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
									if (g_strcmp0 (_tmp84_, TRF_ONTOLOGY_DEFS_NCO_HAS_AFFILIATION) == 0) {
#line 2011 "backend.c"
										const gchar* _tmp85_;
										gchar* _tmp86_;
										gchar* _tmp87_;
#line 403 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
										_tmp85_ = v;
#line 403 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
										_tmp86_ = g_strdup (_tmp85_);
#line 403 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
										_g_free0 (affiliation);
#line 403 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
										affiliation = _tmp86_;
#line 404 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
										_tmp87_ = g_strdup ("<affl:001>");
#line 404 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
										_g_free0 (v);
#line 404 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
										v = _tmp87_;
#line 2029 "backend.c"
									} else {
										const gchar* _tmp88_;
#line 406 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
										_tmp88_ = k;
#line 406 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
										if (g_strcmp0 (_tmp88_, TRF_ONTOLOGY_DEFS_NCO_GENDER) == 0) {
#line 2036 "backend.c"
										} else {
											const gchar* _tmp89_;
#line 410 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
											_tmp89_ = k;
#line 410 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
											if (g_strcmp0 (_tmp89_, TRF_ONTOLOGY_DEFS_NCO_POSTAL_ADDRESS) == 0) {
#line 2043 "backend.c"
												const gchar* _tmp90_;
												gchar* _tmp91_;
												gchar* _tmp92_;
												gchar* _tmp93_;
#line 412 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
												_tmp90_ = v;
#line 412 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
												_tmp91_ = g_strdup (_tmp90_);
#line 412 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
												_g_free0 (postal_address);
#line 412 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
												postal_address = _tmp91_;
#line 413 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
												_tmp92_ = g_strdup (TRF_ONTOLOGY_DEFS_NCO_HAS_AFFILIATION);
#line 413 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
												_g_free0 (k);
#line 413 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
												k = _tmp92_;
#line 414 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
												_tmp93_ = g_strdup ("<affl:001>");
#line 414 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
												_g_free0 (v);
#line 414 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
												v = _tmp93_;
#line 2068 "backend.c"
											} else {
												const gchar* _tmp94_;
												gchar* _tmp95_;
												gchar* _tmp96_;
												gchar* _tmp97_;
#line 418 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
												_tmp94_ = v;
#line 418 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
												_tmp95_ = g_strconcat ("'", _tmp94_, NULL);
#line 418 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
												_tmp96_ = _tmp95_;
#line 418 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
												_tmp97_ = g_strconcat (_tmp96_, "'", NULL);
#line 418 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
												_g_free0 (v);
#line 418 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
												v = _tmp97_;
#line 418 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
												_g_free0 (_tmp96_);
#line 2088 "backend.c"
											}
										}
									}
								}
							}
						}
					}
				}
			}
#line 421 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp98_ = q;
#line 421 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp99_ = g_strconcat (_tmp98_, "; ", NULL);
#line 421 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_g_free0 (q);
#line 421 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			q = _tmp99_;
#line 422 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp100_ = k;
#line 422 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp101_ = g_strconcat (_tmp100_, " ", NULL);
#line 422 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp102_ = _tmp101_;
#line 422 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp103_ = v;
#line 422 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp104_ = g_strconcat (_tmp102_, _tmp103_, NULL);
#line 422 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp105_ = _tmp104_;
#line 422 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_g_free0 (_tmp102_);
#line 422 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			s = _tmp105_;
#line 423 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp106_ = q;
#line 423 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp107_ = s;
#line 423 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp108_ = g_strconcat (_tmp106_, _tmp107_, NULL);
#line 423 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_g_free0 (q);
#line 423 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			q = _tmp108_;
#line 351 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_g_free0 (s);
#line 351 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_g_free0 (v);
#line 351 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_g_free0 (k);
#line 2138 "backend.c"
		}
#line 351 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_object_unref0 (_k_it);
#line 2142 "backend.c"
	}
#line 426 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp109_ = photo_uri;
#line 426 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (g_strcmp0 (_tmp109_, "") != 0) {
#line 2148 "backend.c"
		const gchar* _tmp110_;
		const gchar* _tmp111_;
		const gchar* _tmp112_;
		const gchar* _tmp113_;
		gchar* _tmp114_;
		gchar* _tmp115_;
		gchar* _tmp116_;
#line 428 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp110_ = q;
#line 428 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp111_ = photo_uri;
#line 428 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp112_ = photo_uri;
#line 428 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp113_ = photo_uri;
#line 428 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp114_ = g_strdup_printf (q_photo_uri_t, _tmp111_, _tmp112_, _tmp113_);
#line 428 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp115_ = _tmp114_;
#line 428 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp116_ = g_strconcat (_tmp110_, _tmp115_, NULL);
#line 428 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_free0 (q);
#line 428 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		q = _tmp116_;
#line 428 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_free0 (_tmp115_);
#line 2176 "backend.c"
	}
#line 431 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp118_ = addresses;
#line 431 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (_tmp118_ != NULL) {
#line 2182 "backend.c"
		GeeHashMap* _tmp119_;
		gint _tmp120_;
		gint _tmp121_;
#line 431 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp119_ = addresses;
#line 431 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp120_ = gee_abstract_map_get_size ((GeeMap*) _tmp119_);
#line 431 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp121_ = _tmp120_;
#line 431 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp117_ = _tmp121_ > 0;
#line 2194 "backend.c"
	} else {
#line 431 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp117_ = FALSE;
#line 2198 "backend.c"
	}
#line 431 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (_tmp117_) {
#line 2202 "backend.c"
		{
			GeeIterator* _addr_it;
			GeeHashMap* _tmp122_;
			GeeSet* _tmp123_;
			GeeSet* _tmp124_;
			GeeSet* _tmp125_;
			GeeIterator* _tmp126_;
			GeeIterator* _tmp127_;
#line 433 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp122_ = addresses;
#line 433 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp123_ = gee_abstract_map_get_keys ((GeeMap*) _tmp122_);
#line 433 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp124_ = _tmp123_;
#line 433 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp125_ = _tmp124_;
#line 433 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp126_ = gee_iterable_iterator ((GeeIterable*) _tmp125_);
#line 433 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp127_ = _tmp126_;
#line 433 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_g_object_unref0 (_tmp125_);
#line 433 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_addr_it = _tmp127_;
#line 433 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			while (TRUE) {
#line 2229 "backend.c"
				GeeIterator* _tmp128_;
				gboolean _tmp129_;
				gchar* addr;
				GeeIterator* _tmp130_;
				gpointer _tmp131_;
				gchar* proto;
				GeeHashMap* _tmp132_;
				const gchar* _tmp133_;
				gpointer _tmp134_;
				gchar* q1;
				const gchar* _tmp135_;
				const gchar* _tmp136_;
				const gchar* _tmp137_;
				const gchar* _tmp138_;
				const gchar* _tmp139_;
				const gchar* _tmp140_;
				const gchar* _tmp141_;
				gchar* _tmp142_;
				gchar* q2;
				const gchar* _tmp143_;
				const gchar* _tmp144_;
				const gchar* _tmp145_;
				gchar* _tmp146_;
				const gchar* _tmp147_;
				const gchar* _tmp148_;
				const gchar* _tmp149_;
				gchar* _tmp150_;
				gchar* _tmp151_;
				gchar* _tmp152_;
#line 433 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp128_ = _addr_it;
#line 433 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp129_ = gee_iterator_next (_tmp128_);
#line 433 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				if (!_tmp129_) {
#line 433 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					break;
#line 2267 "backend.c"
				}
#line 433 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp130_ = _addr_it;
#line 433 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp131_ = gee_iterator_get (_tmp130_);
#line 433 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				addr = (gchar*) _tmp131_;
#line 435 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp132_ = addresses;
#line 435 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp133_ = addr;
#line 435 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp134_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp132_, _tmp133_);
#line 435 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				proto = (gchar*) _tmp134_;
#line 436 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp135_ = addr;
#line 436 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp136_ = proto;
#line 436 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp137_ = addr;
#line 436 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp138_ = addr;
#line 436 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp139_ = addr;
#line 436 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp140_ = addr;
#line 436 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp141_ = addr;
#line 436 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp142_ = g_strdup_printf (im_addr_t, _tmp135_, _tmp136_, _tmp137_, _tmp138_, _tmp139_, _tmp140_, _tmp141_);
#line 436 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				q1 = _tmp142_;
#line 439 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp143_ = addr;
#line 439 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp144_ = addr;
#line 439 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp145_ = addr;
#line 439 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp146_ = g_strdup_printf (affl_t, _tmp143_, _tmp144_, _tmp145_);
#line 439 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				q2 = _tmp146_;
#line 441 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp147_ = q;
#line 441 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp148_ = q1;
#line 441 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp149_ = q2;
#line 441 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp150_ = g_strdup_printf ("%s%s", _tmp148_, _tmp149_);
#line 441 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp151_ = _tmp150_;
#line 441 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp152_ = g_strconcat (_tmp147_, _tmp151_, NULL);
#line 441 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_g_free0 (q);
#line 441 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				q = _tmp152_;
#line 441 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_g_free0 (_tmp151_);
#line 433 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_g_free0 (q2);
#line 433 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_g_free0 (q1);
#line 433 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_g_free0 (proto);
#line 433 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_g_free0 (addr);
#line 2337 "backend.c"
			}
#line 433 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_g_object_unref0 (_addr_it);
#line 2341 "backend.c"
		}
	}
#line 445 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp154_ = phones;
#line 445 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp154__length1 = phones_length1;
#line 445 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (_tmp154_ != NULL) {
#line 2350 "backend.c"
		gchar** _tmp155_;
		gint _tmp155__length1;
#line 445 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp155_ = phones;
#line 445 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp155__length1 = phones_length1;
#line 445 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp153_ = _tmp155__length1 > 0;
#line 2359 "backend.c"
	} else {
#line 445 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp153_ = FALSE;
#line 2363 "backend.c"
	}
#line 445 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (_tmp153_) {
#line 2367 "backend.c"
		gchar** _tmp156_;
		gint _tmp156__length1;
#line 447 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp156_ = phones;
#line 447 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp156__length1 = phones_length1;
#line 2374 "backend.c"
		{
			gchar** p_collection = NULL;
			gint p_collection_length1 = 0;
			gint _p_collection_size_ = 0;
			gint p_it = 0;
#line 447 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			p_collection = _tmp156_;
#line 447 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			p_collection_length1 = _tmp156__length1;
#line 447 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			for (p_it = 0; p_it < _tmp156__length1; p_it = p_it + 1) {
#line 2386 "backend.c"
				gchar* _tmp157_;
				gchar* p = NULL;
#line 447 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp157_ = g_strdup (p_collection[p_it]);
#line 447 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				p = _tmp157_;
#line 2393 "backend.c"
				{
					gchar* phone_urn;
					const gchar* _tmp158_;
					gchar* _tmp159_;
					gchar* affl;
					const gchar* _tmp160_;
					gchar* _tmp161_;
					const gchar* _tmp162_;
					const gchar* _tmp163_;
					const gchar* _tmp164_;
					const gchar* _tmp165_;
					const gchar* _tmp166_;
#line 449 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp158_ = p;
#line 449 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp159_ = g_strdup_printf ("<phone:%s>", _tmp158_);
#line 449 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					phone_urn = _tmp159_;
#line 450 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp160_ = p;
#line 450 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp161_ = g_strdup_printf ("<%s>", _tmp160_);
#line 450 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					affl = _tmp161_;
#line 451 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp162_ = phone_urn;
#line 451 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp163_ = p;
#line 451 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					tracker_test_backend_insert_triplet (self, _tmp162_, "a", TRF_ONTOLOGY_DEFS_NCO_PHONE, TRF_ONTOLOGY_DEFS_NCO_PHONE_PROP, _tmp163_, NULL, NULL);
#line 453 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp164_ = affl;
#line 453 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					tracker_test_backend_insert_triplet (self, _tmp164_, "a", TRF_ONTOLOGY_DEFS_NCO_AFFILIATION, NULL, NULL, NULL, NULL);
#line 454 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp165_ = affl;
#line 454 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp166_ = phone_urn;
#line 454 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					tracker_test_backend_insert_triplet (self, _tmp165_, TRF_ONTOLOGY_DEFS_NCO_HAS_PHONE, _tmp166_, NULL, NULL, NULL, NULL);
#line 447 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_g_free0 (affl);
#line 447 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_g_free0 (phone_urn);
#line 447 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_g_free0 (p);
#line 2440 "backend.c"
				}
			}
		}
	}
#line 459 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp168_ = emails;
#line 459 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp168__length1 = emails_length1;
#line 459 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (_tmp168_ != NULL) {
#line 2451 "backend.c"
		gchar** _tmp169_;
		gint _tmp169__length1;
#line 459 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp169_ = emails;
#line 459 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp169__length1 = emails_length1;
#line 459 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp167_ = _tmp169__length1 > 0;
#line 2460 "backend.c"
	} else {
#line 459 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp167_ = FALSE;
#line 2464 "backend.c"
	}
#line 459 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (_tmp167_) {
#line 2468 "backend.c"
		gchar** _tmp170_;
		gint _tmp170__length1;
#line 461 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp170_ = emails;
#line 461 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp170__length1 = emails_length1;
#line 2475 "backend.c"
		{
			gchar** p_collection = NULL;
			gint p_collection_length1 = 0;
			gint _p_collection_size_ = 0;
			gint p_it = 0;
#line 461 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			p_collection = _tmp170_;
#line 461 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			p_collection_length1 = _tmp170__length1;
#line 461 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			for (p_it = 0; p_it < _tmp170__length1; p_it = p_it + 1) {
#line 2487 "backend.c"
				gchar* _tmp171_;
				gchar* p = NULL;
#line 461 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp171_ = g_strdup (p_collection[p_it]);
#line 461 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				p = _tmp171_;
#line 2494 "backend.c"
				{
					gchar* email_urn;
					const gchar* _tmp172_;
					gchar* _tmp173_;
					gchar* affl;
					const gchar* _tmp174_;
					gchar* _tmp175_;
					const gchar* _tmp176_;
					const gchar* _tmp177_;
					const gchar* _tmp178_;
					const gchar* _tmp179_;
					const gchar* _tmp180_;
#line 463 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp172_ = p;
#line 463 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp173_ = g_strdup_printf ("<email:%s>", _tmp172_);
#line 463 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					email_urn = _tmp173_;
#line 464 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp174_ = p;
#line 464 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp175_ = g_strdup_printf ("<%s>", _tmp174_);
#line 464 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					affl = _tmp175_;
#line 465 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp176_ = email_urn;
#line 465 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp177_ = p;
#line 465 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					tracker_test_backend_insert_triplet (self, _tmp176_, "a", TRF_ONTOLOGY_DEFS_NCO_EMAIL, TRF_ONTOLOGY_DEFS_NCO_EMAIL_PROP, _tmp177_, NULL, NULL);
#line 467 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp178_ = affl;
#line 467 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					tracker_test_backend_insert_triplet (self, _tmp178_, "a", TRF_ONTOLOGY_DEFS_NCO_AFFILIATION, NULL, NULL, NULL, NULL);
#line 468 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp179_ = affl;
#line 468 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp180_ = email_urn;
#line 468 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					tracker_test_backend_insert_triplet (self, _tmp179_, TRF_ONTOLOGY_DEFS_NCO_HAS_EMAIL, _tmp180_, NULL, NULL, NULL, NULL);
#line 461 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_g_free0 (affl);
#line 461 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_g_free0 (email_urn);
#line 461 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_g_free0 (p);
#line 2541 "backend.c"
				}
			}
		}
	}
#line 473 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp182_ = urls;
#line 473 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp182__length1 = urls_length1;
#line 473 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (_tmp182_ != NULL) {
#line 2552 "backend.c"
		gchar** _tmp183_;
		gint _tmp183__length1;
#line 473 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp183_ = urls;
#line 473 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp183__length1 = urls_length1;
#line 473 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp181_ = _tmp183__length1 > 0;
#line 2561 "backend.c"
	} else {
#line 473 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp181_ = FALSE;
#line 2565 "backend.c"
	}
#line 473 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (_tmp181_) {
#line 2569 "backend.c"
		gint i;
		gchar** _tmp184_;
		gint _tmp184__length1;
#line 475 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		i = 0;
#line 476 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp184_ = urls;
#line 476 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp184__length1 = urls_length1;
#line 2579 "backend.c"
		{
			gchar** p_collection = NULL;
			gint p_collection_length1 = 0;
			gint _p_collection_size_ = 0;
			gint p_it = 0;
#line 476 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			p_collection = _tmp184_;
#line 476 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			p_collection_length1 = _tmp184__length1;
#line 476 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			for (p_it = 0; p_it < _tmp184__length1; p_it = p_it + 1) {
#line 2591 "backend.c"
				gchar* _tmp185_;
				gchar* p = NULL;
#line 476 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp185_ = g_strdup (p_collection[p_it]);
#line 476 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				p = _tmp185_;
#line 2598 "backend.c"
				{
					gchar* website_type;
					gchar* _tmp186_;
					gchar* affl;
					const gchar* _tmp187_;
					gchar* _tmp188_;
					gint _tmp189_;
					const gchar* _tmp193_;
					const gchar* _tmp194_;
					const gchar* _tmp195_;
					gint _tmp196_;
#line 478 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp186_ = g_strdup ("");
#line 478 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					website_type = _tmp186_;
#line 479 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp187_ = p;
#line 479 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp188_ = g_strdup_printf ("<%s>", _tmp187_);
#line 479 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					affl = _tmp188_;
#line 480 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp189_ = i;
#line 480 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					switch (_tmp189_ % 3) {
#line 480 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						case 0:
#line 2626 "backend.c"
						{
							gchar* _tmp190_;
#line 483 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_tmp190_ = g_strdup (TRF_ONTOLOGY_DEFS_NCO_WEBSITE);
#line 483 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_g_free0 (website_type);
#line 483 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							website_type = _tmp190_;
#line 484 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							break;
#line 2637 "backend.c"
						}
#line 480 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						case 1:
#line 2641 "backend.c"
						{
							gchar* _tmp191_;
#line 486 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_tmp191_ = g_strdup (TRF_ONTOLOGY_DEFS_NCO_BLOG);
#line 486 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_g_free0 (website_type);
#line 486 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							website_type = _tmp191_;
#line 487 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							break;
#line 2652 "backend.c"
						}
#line 480 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						case 2:
#line 2656 "backend.c"
						{
							gchar* _tmp192_;
#line 489 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_tmp192_ = g_strdup ("nco:url");
#line 489 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							_g_free0 (website_type);
#line 489 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							website_type = _tmp192_;
#line 490 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
							break;
#line 2667 "backend.c"
						}
						default:
#line 480 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
						break;
#line 2672 "backend.c"
					}
#line 493 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp193_ = affl;
#line 493 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp194_ = website_type;
#line 493 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp195_ = p;
#line 493 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					tracker_test_backend_insert_triplet (self, _tmp193_, "a", TRF_ONTOLOGY_DEFS_NCO_AFFILIATION, _tmp194_, _tmp195_, NULL, NULL);
#line 495 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp196_ = i;
#line 495 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					i = _tmp196_ + 1;
#line 476 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_g_free0 (affl);
#line 476 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_g_free0 (website_type);
#line 476 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_g_free0 (p);
#line 2692 "backend.c"
				}
			}
		}
	}
#line 499 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp197_ = affiliation;
#line 499 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (g_strcmp0 (_tmp197_, "") != 0) {
#line 2701 "backend.c"
		gchar** role_info;
		const gchar* _tmp198_;
		gchar** _tmp199_;
		gchar** _tmp200_;
		gint role_info_length1;
		gint _role_info_size_;
		const gchar* _tmp201_;
		gchar** _tmp202_;
		gint _tmp202__length1;
		const gchar* _tmp203_;
		gchar** _tmp204_;
		gint _tmp204__length1;
		const gchar* _tmp205_;
		gchar** _tmp206_;
		gint _tmp206__length1;
		const gchar* _tmp207_;
		gchar* _tmp208_;
		gchar* _tmp209_;
		gchar* _tmp210_;
#line 501 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp198_ = affiliation;
#line 501 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp200_ = _tmp199_ = g_strsplit (_tmp198_, ",", 0);
#line 501 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		role_info = _tmp200_;
#line 501 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		role_info_length1 = _vala_array_length (_tmp199_);
#line 501 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_role_info_size_ = role_info_length1;
#line 502 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp201_ = q;
#line 502 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp202_ = role_info;
#line 502 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp202__length1 = role_info_length1;
#line 502 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp203_ = _tmp202_[0];
#line 502 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp204_ = role_info;
#line 502 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp204__length1 = role_info_length1;
#line 502 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp205_ = _tmp204_[1];
#line 502 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp206_ = role_info;
#line 502 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp206__length1 = role_info_length1;
#line 502 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp207_ = _tmp206_[2];
#line 502 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp208_ = g_strdup_printf (af_t, _tmp203_, _tmp205_, _tmp207_);
#line 502 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp209_ = _tmp208_;
#line 502 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp210_ = g_strconcat (_tmp201_, _tmp209_, NULL);
#line 502 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_free0 (q);
#line 502 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		q = _tmp210_;
#line 502 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_free0 (_tmp209_);
#line 499 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		role_info = (_vala_array_free (role_info, role_info_length1, (GDestroyNotify) g_free), NULL);
#line 2765 "backend.c"
	}
#line 505 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp211_ = postal_address;
#line 505 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (g_strcmp0 (_tmp211_, "") != 0) {
#line 2771 "backend.c"
		gchar** postal_info;
		const gchar* _tmp212_;
		gchar** _tmp213_;
		gchar** _tmp214_;
		gint postal_info_length1;
		gint _postal_info_size_;
		const gchar* _tmp215_;
		gchar** _tmp216_;
		gint _tmp216__length1;
		const gchar* _tmp217_;
		gchar** _tmp218_;
		gint _tmp218__length1;
		const gchar* _tmp219_;
		gchar** _tmp220_;
		gint _tmp220__length1;
		const gchar* _tmp221_;
		gchar** _tmp222_;
		gint _tmp222__length1;
		const gchar* _tmp223_;
		gchar** _tmp224_;
		gint _tmp224__length1;
		const gchar* _tmp225_;
		gchar** _tmp226_;
		gint _tmp226__length1;
		const gchar* _tmp227_;
		gchar** _tmp228_;
		gint _tmp228__length1;
		const gchar* _tmp229_;
		gchar** _tmp230_;
		gint _tmp230__length1;
		const gchar* _tmp231_;
		gchar** _tmp232_;
		gint _tmp232__length1;
		const gchar* _tmp233_;
		gchar** _tmp234_;
		gint _tmp234__length1;
		const gchar* _tmp235_;
		gchar* _tmp236_;
		gchar* _tmp237_;
		gchar* _tmp238_;
#line 507 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp212_ = postal_address;
#line 507 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp214_ = _tmp213_ = g_strsplit (_tmp212_, ":", 0);
#line 507 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		postal_info = _tmp214_;
#line 507 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		postal_info_length1 = _vala_array_length (_tmp213_);
#line 507 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_postal_info_size_ = postal_info_length1;
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp215_ = q;
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp216_ = postal_info;
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp216__length1 = postal_info_length1;
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp217_ = _tmp216_[0];
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp218_ = postal_info;
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp218__length1 = postal_info_length1;
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp219_ = _tmp218_[1];
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp220_ = postal_info;
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp220__length1 = postal_info_length1;
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp221_ = _tmp220_[2];
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp222_ = postal_info;
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp222__length1 = postal_info_length1;
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp223_ = _tmp222_[3];
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp224_ = postal_info;
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp224__length1 = postal_info_length1;
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp225_ = _tmp224_[4];
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp226_ = postal_info;
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp226__length1 = postal_info_length1;
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp227_ = _tmp226_[5];
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp228_ = postal_info;
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp228__length1 = postal_info_length1;
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp229_ = _tmp228_[6];
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp230_ = postal_info;
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp230__length1 = postal_info_length1;
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp231_ = _tmp230_[7];
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp232_ = postal_info;
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp232__length1 = postal_info_length1;
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp233_ = _tmp232_[8];
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp234_ = postal_info;
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp234__length1 = postal_info_length1;
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp235_ = _tmp234_[9];
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp236_ = g_strdup_printf (postal_t, _tmp217_, _tmp219_, _tmp221_, _tmp223_, _tmp225_, _tmp227_, _tmp229_, _tmp231_, _tmp233_, _tmp235_);
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp237_ = _tmp236_;
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp238_ = g_strconcat (_tmp215_, _tmp237_, NULL);
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_free0 (q);
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		q = _tmp238_;
#line 508 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_g_free0 (_tmp237_);
#line 505 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		postal_info = (_vala_array_free (postal_info, postal_info_length1, (GDestroyNotify) g_free), NULL);
#line 2898 "backend.c"
	}
#line 514 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp239_ = q;
#line 514 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp240_ = g_strconcat (_tmp239_, " . }", NULL);
#line 514 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_g_free0 (q);
#line 514 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	q = _tmp240_;
#line 516 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp241_ = self->priv->_debug;
#line 516 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (_tmp241_) {
#line 2912 "backend.c"
		FILE* _tmp242_;
		const gchar* _tmp243_;
#line 518 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp242_ = stdout;
#line 518 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		_tmp243_ = q;
#line 518 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		fprintf (_tmp242_, "_get_insert_query : %s\n", _tmp243_);
#line 2921 "backend.c"
	}
#line 521 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	result = q;
#line 521 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_g_free0 (postal_address);
#line 521 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_g_free0 (affiliation);
#line 521 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	urls = (_vala_array_free (urls, urls_length1, (GDestroyNotify) g_free), NULL);
#line 521 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	emails = (_vala_array_free (emails, emails_length1, (GDestroyNotify) g_free), NULL);
#line 521 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	phones = (_vala_array_free (phones, phones_length1, (GDestroyNotify) g_free), NULL);
#line 521 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_g_object_unref0 (addresses);
#line 521 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_g_free0 (photo_uri);
#line 521 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_g_free0 (urn_contact);
#line 521 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	return result;
#line 2943 "backend.c"
}


static GeeHashMap* _tracker_test_backend_parse_addrs (TrackerTestBackend* self, const gchar* addr_s) {
	GeeHashMap* result = NULL;
	GeeHashMap* ret;
	GeeHashMap* _tmp0_;
	gchar** im_addrs;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint im_addrs_length1;
	gint _im_addrs_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
#line 524 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 524 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (addr_s != NULL, NULL);
#line 526 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 526 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	ret = _tmp0_;
#line 527 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp1_ = addr_s;
#line 527 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ",", 0);
#line 527 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	im_addrs = _tmp3_;
#line 527 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	im_addrs_length1 = _vala_array_length (_tmp2_);
#line 527 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_im_addrs_size_ = im_addrs_length1;
#line 529 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp4_ = im_addrs;
#line 529 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp4__length1 = im_addrs_length1;
#line 2981 "backend.c"
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
#line 529 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		a_collection = _tmp4_;
#line 529 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		a_collection_length1 = _tmp4__length1;
#line 529 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		for (a_it = 0; a_it < _tmp4__length1; a_it = a_it + 1) {
#line 2993 "backend.c"
			gchar* _tmp5_;
			gchar* a = NULL;
#line 529 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp5_ = g_strdup (a_collection[a_it]);
#line 529 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			a = _tmp5_;
#line 3000 "backend.c"
			{
				gchar** info;
				const gchar* _tmp6_;
				gchar** _tmp7_;
				gchar** _tmp8_;
				gint info_length1;
				gint _info_size_;
				gchar* proto;
				gchar** _tmp9_;
				gint _tmp9__length1;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* addr;
				gchar** _tmp12_;
				gint _tmp12__length1;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				GeeHashMap* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
#line 531 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp6_ = a;
#line 531 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "#", 0);
#line 531 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				info = _tmp8_;
#line 531 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				info_length1 = _vala_array_length (_tmp7_);
#line 531 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_info_size_ = info_length1;
#line 532 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp9_ = info;
#line 532 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp9__length1 = info_length1;
#line 532 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp10_ = _tmp9_[0];
#line 532 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp11_ = g_strdup (_tmp10_);
#line 532 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				proto = _tmp11_;
#line 533 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp12_ = info;
#line 533 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp12__length1 = info_length1;
#line 533 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp13_ = _tmp12_[1];
#line 533 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp14_ = g_strdup (_tmp13_);
#line 533 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				addr = _tmp14_;
#line 535 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp15_ = ret;
#line 535 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp16_ = addr;
#line 535 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				addr = NULL;
#line 535 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp17_ = _tmp16_;
#line 535 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp18_ = proto;
#line 535 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				proto = NULL;
#line 535 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp19_ = _tmp18_;
#line 535 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _tmp17_, _tmp19_);
#line 535 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_g_free0 (_tmp19_);
#line 535 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_g_free0 (_tmp17_);
#line 529 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_g_free0 (addr);
#line 529 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_g_free0 (proto);
#line 529 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				info = (_vala_array_free (info, info_length1, (GDestroyNotify) g_free), NULL);
#line 529 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_g_free0 (a);
#line 3081 "backend.c"
			}
		}
	}
#line 538 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	result = ret;
#line 538 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	im_addrs = (_vala_array_free (im_addrs, im_addrs_length1, (GDestroyNotify) g_free), NULL);
#line 538 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	return result;
#line 3091 "backend.c"
}


static gchar* _tracker_test_backend_build_relation (TrackerTestBackend* self, const gchar* predicate, gchar** objects, int objects_length1) {
	gchar* result = NULL;
	gchar* ret;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
#line 541 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 541 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (predicate != NULL, NULL);
#line 543 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp0_ = g_strdup ("");
#line 543 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	ret = _tmp0_;
#line 545 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp1_ = objects;
#line 545 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp1__length1 = objects_length1;
#line 3113 "backend.c"
	{
		gchar** obj_collection = NULL;
		gint obj_collection_length1 = 0;
		gint _obj_collection_size_ = 0;
		gint obj_it = 0;
#line 545 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		obj_collection = _tmp1_;
#line 545 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		obj_collection_length1 = _tmp1__length1;
#line 545 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		for (obj_it = 0; obj_it < _tmp1__length1; obj_it = obj_it + 1) {
#line 3125 "backend.c"
			gchar* _tmp2_;
			gchar* obj = NULL;
#line 545 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			_tmp2_ = g_strdup (obj_collection[obj_it]);
#line 545 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			obj = _tmp2_;
#line 3132 "backend.c"
			{
				gchar* vtemp1 = NULL;
				const gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
#line 548 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp3_ = predicate;
#line 548 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp4_ = g_strconcat (" ", _tmp3_, NULL);
#line 548 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp5_ = _tmp4_;
#line 548 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp6_ = g_strconcat (_tmp5_, " <", NULL);
#line 548 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp7_ = _tmp6_;
#line 548 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp8_ = obj;
#line 548 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp9_ = g_strconcat (_tmp7_, _tmp8_, NULL);
#line 548 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp10_ = _tmp9_;
#line 548 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp11_ = g_strconcat (_tmp10_, "> ", NULL);
#line 548 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_g_free0 (vtemp1);
#line 548 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				vtemp1 = _tmp11_;
#line 548 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_g_free0 (_tmp10_);
#line 548 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_g_free0 (_tmp7_);
#line 548 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_g_free0 (_tmp5_);
#line 549 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp12_ = ret;
#line 549 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				if (g_strcmp0 (_tmp12_, "") != 0) {
#line 3180 "backend.c"
					const gchar* _tmp13_;
					gchar* _tmp14_;
#line 551 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp13_ = ret;
#line 551 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_tmp14_ = g_strconcat (_tmp13_, "; ", NULL);
#line 551 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					_g_free0 (ret);
#line 551 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
					ret = _tmp14_;
#line 3191 "backend.c"
				}
#line 553 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp15_ = ret;
#line 553 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp16_ = vtemp1;
#line 553 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_tmp17_ = g_strconcat (_tmp15_, _tmp16_, NULL);
#line 553 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_g_free0 (ret);
#line 553 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				ret = _tmp17_;
#line 545 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_g_free0 (vtemp1);
#line 545 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
				_g_free0 (obj);
#line 3207 "backend.c"
			}
		}
	}
#line 556 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	result = ret;
#line 556 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	return result;
#line 3215 "backend.c"
}


gboolean tracker_test_backend_get_debug (TrackerTestBackend* self) {
	gboolean result;
	gboolean _tmp0_;
#line 33 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 33 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp0_ = self->priv->_debug;
#line 33 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	result = _tmp0_;
#line 33 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	return result;
#line 3230 "backend.c"
}


void tracker_test_backend_set_debug (TrackerTestBackend* self, gboolean value) {
	gboolean _tmp0_;
#line 33 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_if_fail (self != NULL);
#line 33 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_tmp0_ = value;
#line 33 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	self->priv->_debug = _tmp0_;
#line 3242 "backend.c"
}


static void tracker_test_value_backend_init (GValue* value) {
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	value->data[0].v_pointer = NULL;
#line 3249 "backend.c"
}


static void tracker_test_value_backend_free_value (GValue* value) {
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (value->data[0].v_pointer) {
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		tracker_test_backend_unref (value->data[0].v_pointer);
#line 3258 "backend.c"
	}
}


static void tracker_test_value_backend_copy_value (const GValue* src_value, GValue* dest_value) {
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (src_value->data[0].v_pointer) {
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		dest_value->data[0].v_pointer = tracker_test_backend_ref (src_value->data[0].v_pointer);
#line 3268 "backend.c"
	} else {
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3272 "backend.c"
	}
}


static gpointer tracker_test_value_backend_peek_pointer (const GValue* value) {
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	return value->data[0].v_pointer;
#line 3280 "backend.c"
}


static gchar* tracker_test_value_backend_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (collect_values[0].v_pointer) {
#line 3287 "backend.c"
		TrackerTestBackend * object;
		object = collect_values[0].v_pointer;
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		if (object->parent_instance.g_class == NULL) {
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3294 "backend.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3298 "backend.c"
		}
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		value->data[0].v_pointer = tracker_test_backend_ref (object);
#line 3302 "backend.c"
	} else {
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		value->data[0].v_pointer = NULL;
#line 3306 "backend.c"
	}
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	return NULL;
#line 3310 "backend.c"
}


static gchar* tracker_test_value_backend_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerTestBackend ** object_p;
	object_p = collect_values[0].v_pointer;
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (!object_p) {
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3321 "backend.c"
	}
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (!value->data[0].v_pointer) {
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		*object_p = NULL;
#line 3327 "backend.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		*object_p = value->data[0].v_pointer;
#line 3331 "backend.c"
	} else {
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		*object_p = tracker_test_backend_ref (value->data[0].v_pointer);
#line 3335 "backend.c"
	}
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	return NULL;
#line 3339 "backend.c"
}


GParamSpec* tracker_test_param_spec_backend (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerTestParamSpecBackend* spec;
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_TEST_TYPE_BACKEND), NULL);
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	return G_PARAM_SPEC (spec);
#line 3353 "backend.c"
}


gpointer tracker_test_value_get_backend (const GValue* value) {
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TEST_TYPE_BACKEND), NULL);
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	return value->data[0].v_pointer;
#line 3362 "backend.c"
}


void tracker_test_value_set_backend (GValue* value, gpointer v_object) {
	TrackerTestBackend * old;
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TEST_TYPE_BACKEND));
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	old = value->data[0].v_pointer;
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (v_object) {
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TEST_TYPE_BACKEND));
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		value->data[0].v_pointer = v_object;
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		tracker_test_backend_ref (value->data[0].v_pointer);
#line 3382 "backend.c"
	} else {
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		value->data[0].v_pointer = NULL;
#line 3386 "backend.c"
	}
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (old) {
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		tracker_test_backend_unref (old);
#line 3392 "backend.c"
	}
}


void tracker_test_value_take_backend (GValue* value, gpointer v_object) {
	TrackerTestBackend * old;
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TEST_TYPE_BACKEND));
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	old = value->data[0].v_pointer;
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (v_object) {
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TEST_TYPE_BACKEND));
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		value->data[0].v_pointer = v_object;
#line 3411 "backend.c"
	} else {
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		value->data[0].v_pointer = NULL;
#line 3415 "backend.c"
	}
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (old) {
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		tracker_test_backend_unref (old);
#line 3421 "backend.c"
	}
}


static void tracker_test_backend_class_init (TrackerTestBackendClass * klass) {
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	tracker_test_backend_parent_class = g_type_class_peek_parent (klass);
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	((TrackerTestBackendClass *) klass)->finalize = tracker_test_backend_finalize;
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_type_class_add_private (klass, sizeof (TrackerTestBackendPrivate));
#line 3433 "backend.c"
}


static void tracker_test_backend_instance_init (TrackerTestBackend * self) {
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	self->priv = TRACKER_TEST_BACKEND_GET_PRIVATE (self);
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	self->ref_count = 1;
#line 3442 "backend.c"
}


static void tracker_test_backend_finalize (TrackerTestBackend * obj) {
	TrackerTestBackend * self;
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TEST_TYPE_BACKEND, TrackerTestBackend);
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_signal_handlers_destroy (self);
#line 34 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
#line 35 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	_g_object_unref0 (self->priv->_connection);
#line 3456 "backend.c"
}


GType tracker_test_backend_get_type (void) {
	static volatile gsize tracker_test_backend_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_test_backend_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_test_value_backend_init, tracker_test_value_backend_free_value, tracker_test_value_backend_copy_value, tracker_test_value_backend_peek_pointer, "p", tracker_test_value_backend_collect_value, "p", tracker_test_value_backend_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerTestBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_test_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerTestBackend), 0, (GInstanceInitFunc) tracker_test_backend_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_test_backend_type_id;
		tracker_test_backend_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerTestBackend", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_test_backend_type_id__volatile, tracker_test_backend_type_id);
	}
	return tracker_test_backend_type_id__volatile;
}


gpointer tracker_test_backend_ref (gpointer instance) {
	TrackerTestBackend * self;
	self = instance;
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	g_atomic_int_inc (&self->ref_count);
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	return instance;
#line 3481 "backend.c"
}


void tracker_test_backend_unref (gpointer instance) {
	TrackerTestBackend * self;
	self = instance;
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		TRACKER_TEST_BACKEND_GET_CLASS (self)->finalize (self);
#line 29 "/opt/gnome/source/folks/tests/lib/tracker/backend.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3494 "backend.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



