/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*- */
/* librvngabw
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Major Contributor(s):
 * Copyright (C) 2002-2003 William Lachance (wrlach@gmail.com)
 * Copyright (C) 2004 Fridrich Strba (fridrich.strba@bluewin.ch)
 *
 * For minor contributions see the git repository.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libwpd.sourceforge.net
 */

/* "This product is not manufactured, approved, or supported by
 * Corel Corporation or Corel Corporation Limited."
 */

#ifndef _TEXTRUNSTYLE_HXX_
#define _TEXTRUNSTYLE_HXX_

#include <map>

#include <librevenge/librevenge.h>

#include "FilterInternal.hxx"

#include "Style.hxx"

class ABWDocumentHandler;

namespace librvngabw
{
class ParagraphStyle final : public Style
{
public:
	ParagraphStyle(librevenge::RVNGPropertyList const &propList, const librevenge::RVNGString &sName);
	~ParagraphStyle() final;
	void write(ABWDocumentHandler *pHandler) const final;
	//! add the border properties to proPropList
	void appendBorderProperties(librevenge::RVNGPropertyList &propPropList) const;
private:
	//! the property list
	librevenge::RVNGPropertyList m_propList;
};


class SpanStyle final : public Style
{
public:
	SpanStyle(const char *psName, const librevenge::RVNGPropertyList &xPropList);
	void write(ABWDocumentHandler *pHandler) const final;
private:
	librevenge::RVNGPropertyList m_propList;
};

class ParagraphStyleManager final : public StyleManager
{
public:
	ParagraphStyleManager() : m_hashNameMap(), m_nameStyleMap(), m_displayStyleNameMap() {}
	~ParagraphStyleManager() final
	{
		clean();
	}

	/* create a new style if it does not exists. In all case, returns the name of the style and add
	   the border properties in propPropList

	Note: using S%i as new name*/
	librevenge::RVNGString findOrAdd(const librevenge::RVNGPropertyList &xPropList,
	                                 librevenge::RVNGPropertyList &propPropList);

	/* returns the style corresponding to a given name ( if it exists ) */
	std::shared_ptr<ParagraphStyle> const get(const librevenge::RVNGString &name) const;

	void clean() final;
	// write automatic/named style
	void write(ABWDocumentHandler *pHandler) const final;

protected:
	// hash key -> name
	std::map<librevenge::RVNGString, librevenge::RVNGString> m_hashNameMap;
	// style name -> paragraph style
	std::map<librevenge::RVNGString, std::shared_ptr<ParagraphStyle> > m_nameStyleMap;
	// display name -> style name
	std::map<librevenge::RVNGString, librevenge::RVNGString> m_displayStyleNameMap;
};

class SpanStyleManager final : public StyleManager
{
public:
	SpanStyleManager() : m_hashNameMap(), m_nameStyleMap(), 	m_displayStyleNameMap() {}
	~SpanStyleManager() final
	{
		clean();
	}

	/* create a new style if it does not exists. In all case, returns the name of the style

	Note: using Span%i as new name*/
	librevenge::RVNGString findOrAdd(const librevenge::RVNGPropertyList &xPropList);
	/* returns the style corresponding to a given name ( if it exists ) */
	std::shared_ptr<SpanStyle> const get(const librevenge::RVNGString &name) const;
	/** append the span in the element, ie. the stroke, pattern, bitmap, marker properties */
	static void addSpanProperties(librevenge::RVNGPropertyList const &style, librevenge::RVNGPropertyList &element);

	void clean() final;
	// write automatic/named style
	void write(ABWDocumentHandler *pHandler) const final;

protected:
	// hash key -> style name
	std::map<librevenge::RVNGString, librevenge::RVNGString> m_hashNameMap;
	// style name -> SpanStyle
	std::map<librevenge::RVNGString, std::shared_ptr<SpanStyle> > m_nameStyleMap;
	// display name -> style name
	std::map<librevenge::RVNGString, librevenge::RVNGString> m_displayStyleNameMap;
};
}
#endif

/* vim:set shiftwidth=4 softtabstop=4 noexpandtab: */
