; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s --mattr=+mve.fp,+fp64 -o - | FileCheck %s

target triple = "thumbv8.1m.main-none-none-eabi"

; Expected to transform
define arm_aapcs_vfpcc <4 x float> @simple_mul(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: simple_mul:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vcmul.f32 q2, q0, q1, #0
; CHECK-NEXT:    vcmla.f32 q2, q0, q1, #90
; CHECK-NEXT:    vmov q0, q2
; CHECK-NEXT:    bx lr
entry:
  %strided.vec = shufflevector <4 x float> %a, <4 x float> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec17 = shufflevector <4 x float> %a, <4 x float> poison, <2 x i32> <i32 1, i32 3>
  %strided.vec19 = shufflevector <4 x float> %b, <4 x float> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec20 = shufflevector <4 x float> %b, <4 x float> poison, <2 x i32> <i32 1, i32 3>
  %0 = fmul fast <2 x float> %strided.vec20, %strided.vec
  %1 = fmul fast <2 x float> %strided.vec19, %strided.vec17
  %2 = fadd fast <2 x float> %1, %0
  %3 = fmul fast <2 x float> %strided.vec19, %strided.vec
  %4 = fmul fast <2 x float> %strided.vec17, %strided.vec20
  %5 = fsub fast <2 x float> %3, %4
  %interleaved.vec = shufflevector <2 x float> %5, <2 x float> %2, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  ret <4 x float> %interleaved.vec
}

; Expected to not transform
define arm_aapcs_vfpcc <4 x float> @simple_mul_no_contract(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: simple_mul_no_contract:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-NEXT:    vmov.f32 s8, s5
; CHECK-NEXT:    vmov.f32 s12, s1
; CHECK-NEXT:    vmov.f32 s9, s7
; CHECK-NEXT:    vmov.f32 s13, s3
; CHECK-NEXT:    vmov.f32 s1, s2
; CHECK-NEXT:    vmul.f32 q4, q3, q2
; CHECK-NEXT:    vmov.f32 s5, s6
; CHECK-NEXT:    vmul.f32 q2, q2, q0
; CHECK-NEXT:    vmul.f32 q5, q1, q0
; CHECK-NEXT:    vfma.f32 q2, q1, q3
; CHECK-NEXT:    vsub.f32 q4, q5, q4
; CHECK-NEXT:    vmov.f32 s1, s8
; CHECK-NEXT:    vmov.f32 s0, s16
; CHECK-NEXT:    vmov.f32 s2, s17
; CHECK-NEXT:    vmov.f32 s3, s9
; CHECK-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-NEXT:    bx lr
entry:
  %strided.vec = shufflevector <4 x float> %a, <4 x float> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec17 = shufflevector <4 x float> %a, <4 x float> poison, <2 x i32> <i32 1, i32 3>
  %strided.vec19 = shufflevector <4 x float> %b, <4 x float> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec20 = shufflevector <4 x float> %b, <4 x float> poison, <2 x i32> <i32 1, i32 3>
  %0 = fmul fast <2 x float> %strided.vec20, %strided.vec
  %1 = fmul fast <2 x float> %strided.vec19, %strided.vec17
  %2 = fadd fast <2 x float> %1, %0
  %3 = fmul fast <2 x float> %strided.vec19, %strided.vec
  %4 = fmul fast <2 x float> %strided.vec17, %strided.vec20
  %5 = fsub <2 x float> %3, %4
  %interleaved.vec = shufflevector <2 x float> %5, <2 x float> %2, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  ret <4 x float> %interleaved.vec
}

; Expected to transform
define arm_aapcs_vfpcc <4 x float> @three_way_mul(<4 x float> %a, <4 x float> %b, <4 x float> %c) {
; CHECK-LABEL: three_way_mul:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vcmul.f32 q3, q1, q0, #0
; CHECK-NEXT:    vcmla.f32 q3, q1, q0, #90
; CHECK-NEXT:    vcmul.f32 q0, q2, q3, #0
; CHECK-NEXT:    vcmla.f32 q0, q2, q3, #90
; CHECK-NEXT:    bx lr
entry:
  %strided.vec = shufflevector <4 x float> %a, <4 x float> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec39 = shufflevector <4 x float> %a, <4 x float> poison, <2 x i32> <i32 1, i32 3>
  %strided.vec41 = shufflevector <4 x float> %b, <4 x float> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec42 = shufflevector <4 x float> %b, <4 x float> poison, <2 x i32> <i32 1, i32 3>
  %strided.vec44 = shufflevector <4 x float> %c, <4 x float> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec45 = shufflevector <4 x float> %c, <4 x float> poison, <2 x i32> <i32 1, i32 3>
  %0 = fmul fast <2 x float> %strided.vec41, %strided.vec
  %1 = fmul fast <2 x float> %strided.vec42, %strided.vec39
  %2 = fsub fast <2 x float> %0, %1
  %3 = fmul fast <2 x float> %2, %strided.vec45
  %4 = fmul fast <2 x float> %strided.vec42, %strided.vec
  %5 = fmul fast <2 x float> %strided.vec39, %strided.vec41
  %6 = fadd fast <2 x float> %4, %5
  %7 = fmul fast <2 x float> %6, %strided.vec44
  %8 = fadd fast <2 x float> %3, %7
  %9 = fmul fast <2 x float> %2, %strided.vec44
  %10 = fmul fast <2 x float> %6, %strided.vec45
  %11 = fsub fast <2 x float> %9, %10
  %interleaved.vec = shufflevector <2 x float> %11, <2 x float> %8, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  ret <4 x float> %interleaved.vec
}

; Expected to transform
define arm_aapcs_vfpcc <4 x float> @simple_add_90(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: simple_add_90:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vcadd.f32 q2, q1, q0, #90
; CHECK-NEXT:    vmov q0, q2
; CHECK-NEXT:    bx lr
entry:
  %strided.vec = shufflevector <4 x float> %a, <4 x float> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec17 = shufflevector <4 x float> %a, <4 x float> poison, <2 x i32> <i32 1, i32 3>
  %strided.vec19 = shufflevector <4 x float> %b, <4 x float> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec20 = shufflevector <4 x float> %b, <4 x float> poison, <2 x i32> <i32 1, i32 3>
  %0 = fsub fast <2 x float> %strided.vec19, %strided.vec17
  %1 = fadd fast <2 x float> %strided.vec20, %strided.vec
  %interleaved.vec = shufflevector <2 x float> %0, <2 x float> %1, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  ret <4 x float> %interleaved.vec
}

; Expected to not transform, fadd commutativity is not yet implemented
define arm_aapcs_vfpcc <4 x float> @simple_add_270_false(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: simple_add_270_false:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vcadd.f32 q2, q0, q1, #270
; CHECK-NEXT:    vmov q0, q2
; CHECK-NEXT:    bx lr
entry:
  %strided.vec = shufflevector <4 x float> %a, <4 x float> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec17 = shufflevector <4 x float> %a, <4 x float> poison, <2 x i32> <i32 1, i32 3>
  %strided.vec19 = shufflevector <4 x float> %b, <4 x float> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec20 = shufflevector <4 x float> %b, <4 x float> poison, <2 x i32> <i32 1, i32 3>
  %0 = fadd fast <2 x float> %strided.vec20, %strided.vec
  %1 = fsub fast <2 x float> %strided.vec17, %strided.vec19
  %interleaved.vec = shufflevector <2 x float> %0, <2 x float> %1, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  ret <4 x float> %interleaved.vec
}

; Expected to transform
define arm_aapcs_vfpcc <4 x float> @simple_add_270_true(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: simple_add_270_true:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vcadd.f32 q2, q0, q1, #270
; CHECK-NEXT:    vmov q0, q2
; CHECK-NEXT:    bx lr
entry:
  %strided.vec = shufflevector <4 x float> %a, <4 x float> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec17 = shufflevector <4 x float> %a, <4 x float> poison, <2 x i32> <i32 1, i32 3>
  %strided.vec19 = shufflevector <4 x float> %b, <4 x float> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec20 = shufflevector <4 x float> %b, <4 x float> poison, <2 x i32> <i32 1, i32 3>
  %0 = fadd fast <2 x float> %strided.vec, %strided.vec20
  %1 = fsub fast <2 x float> %strided.vec17, %strided.vec19
  %interleaved.vec = shufflevector <2 x float> %0, <2 x float> %1, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  ret <4 x float> %interleaved.vec
}

; Expected to not transform
define arm_aapcs_vfpcc <4 x float> @add_external_use(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: add_external_use:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s8, s4
; CHECK-NEXT:    vmov.f32 s12, s1
; CHECK-NEXT:    vmov.f32 s4, s5
; CHECK-NEXT:    vmov.f32 s9, s6
; CHECK-NEXT:    vmov.f32 s13, s3
; CHECK-NEXT:    vmov.f32 s5, s7
; CHECK-NEXT:    vadd.f32 q2, q3, q2
; CHECK-NEXT:    vmov.f32 s1, s2
; CHECK-NEXT:    vsub.f32 q1, q0, q1
; CHECK-NEXT:    vmov.f32 s1, s8
; CHECK-NEXT:    vmov.f32 s0, s4
; CHECK-NEXT:    vmov.f32 s2, s5
; CHECK-NEXT:    vmov.f32 s3, s9
; CHECK-NEXT:    bx lr
entry:
  %a.real = shufflevector <4 x float> %a, <4 x float> poison, <2 x i32> <i32 0, i32 2>
  %a.imag = shufflevector <4 x float> %a, <4 x float> poison, <2 x i32> <i32 1, i32 3>
  %b.real = shufflevector <4 x float> %b, <4 x float> poison, <2 x i32> <i32 0, i32 2>
  %b.imag = shufflevector <4 x float> %b, <4 x float> poison, <2 x i32> <i32 1, i32 3>
  %0 = fsub fast <2 x float> %a.real, %b.imag
  %1 = fadd fast <2 x float> %a.imag, %b.real
  %interleaved.vec = shufflevector <2 x float> %0, <2 x float> %1, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  %dup = shufflevector <2 x float> %0, <2 x float> poison, <4 x i32> <i32 0, i32 1, i32 0, i32 1>
  %interleaved.vec2 = shufflevector <4 x float> %interleaved.vec, <4 x float> %dup, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x float> %interleaved.vec2
}

define arm_aapcs_vfpcc <4 x float> @mul_mul_with_fneg(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: mul_mul_with_fneg:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vcmul.f32 q2, q1, q0, #270
; CHECK-NEXT:    vcmla.f32 q2, q1, q0, #180
; CHECK-NEXT:    vmov q0, q2
; CHECK-NEXT:    bx lr
entry:
  %a.real = shufflevector <4 x float> %a, <4 x float> poison, <2 x i32> <i32 0, i32 2>
  %a.imag = shufflevector <4 x float> %a, <4 x float> poison, <2 x i32> <i32 1, i32 3>
  %b.real = shufflevector <4 x float> %b, <4 x float> poison, <2 x i32> <i32 0, i32 2>
  %b.imag = shufflevector <4 x float> %b, <4 x float> poison, <2 x i32> <i32 1, i32 3>
  %0 = fneg fast <2 x float> %a.imag
  %1 = fmul fast <2 x float> %b.real, %0
  %2 = fmul fast <2 x float> %a.real, %b.imag
  %3 = fsub fast <2 x float> %1, %2
  %4 = fmul fast <2 x float> %b.imag, %a.imag
  %5 = fmul fast <2 x float> %a.real, %b.real
  %6 = fsub fast <2 x float> %4, %5
  %interleaved.vec = shufflevector <2 x float> %6, <2 x float> %3, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  ret <4 x float> %interleaved.vec
}

; Expected to not transform
define arm_aapcs_vfpcc <12 x float> @abp90c12(<12 x float> %a, <12 x float> %b, <12 x float> %c) {
; CHECK-LABEL: abp90c12:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    .pad #64
; CHECK-NEXT:    sub sp, #64
; CHECK-NEXT:    vldr s23, [sp, #140]
; CHECK-NEXT:    vmov.f32 s20, s13
; CHECK-NEXT:    vldr s22, [sp, #132]
; CHECK-NEXT:    vmov.f32 s25, s11
; CHECK-NEXT:    vmov.f32 s13, s10
; CHECK-NEXT:    vldr s19, [sp, #136]
; CHECK-NEXT:    vmov.f32 s11, s6
; CHECK-NEXT:    vldr s18, [sp, #128]
; CHECK-NEXT:    vmov.f32 s6, s5
; CHECK-NEXT:    vldr s31, [sp, #188]
; CHECK-NEXT:    vmov.f32 s10, s4
; CHECK-NEXT:    vldr s30, [sp, #180]
; CHECK-NEXT:    vmov.f32 s21, s15
; CHECK-NEXT:    vldr s29, [sp, #172]
; CHECK-NEXT:    vmov.f32 s5, s3
; CHECK-NEXT:    vldr s28, [sp, #164]
; CHECK-NEXT:    vmov.f32 s4, s1
; CHECK-NEXT:    vmov.f32 s24, s9
; CHECK-NEXT:    vmov.f32 s16, s12
; CHECK-NEXT:    vstrw.32 q6, [sp, #32] @ 16-byte Spill
; CHECK-NEXT:    vmov.f32 s12, s8
; CHECK-NEXT:    vldr s27, [sp, #184]
; CHECK-NEXT:    vmov.f32 s17, s14
; CHECK-NEXT:    vldr s26, [sp, #176]
; CHECK-NEXT:    vmov.f32 s9, s2
; CHECK-NEXT:    vldr s25, [sp, #168]
; CHECK-NEXT:    vmov.f32 s8, s0
; CHECK-NEXT:    vmul.f32 q0, q5, q1
; CHECK-NEXT:    vmul.f32 q1, q4, q1
; CHECK-NEXT:    vneg.f32 q0, q0
; CHECK-NEXT:    vldr s24, [sp, #160]
; CHECK-NEXT:    vfma.f32 q1, q5, q2
; CHECK-NEXT:    vstrw.32 q0, [sp, #16] @ 16-byte Spill
; CHECK-NEXT:    vstrw.32 q3, [sp, #48] @ 16-byte Spill
; CHECK-NEXT:    vsub.f32 q6, q6, q1
; CHECK-NEXT:    vldrw.u32 q1, [sp, #16] @ 16-byte Reload
; CHECK-NEXT:    vldr s13, [sp, #156]
; CHECK-NEXT:    vfma.f32 q1, q4, q2
; CHECK-NEXT:    vldr s12, [sp, #148]
; CHECK-NEXT:    vadd.f32 q1, q7, q1
; CHECK-NEXT:    vldrw.u32 q7, [sp, #32] @ 16-byte Reload
; CHECK-NEXT:    vldr s1, [sp, #152]
; CHECK-NEXT:    vstrw.32 q3, [sp] @ 16-byte Spill
; CHECK-NEXT:    vmul.f32 q2, q3, q7
; CHECK-NEXT:    vldr s0, [sp, #144]
; CHECK-NEXT:    vldrw.u32 q3, [sp, #48] @ 16-byte Reload
; CHECK-NEXT:    vneg.f32 q2, q2
; CHECK-NEXT:    vldr s21, [sp, #200]
; CHECK-NEXT:    vfma.f32 q2, q0, q3
; CHECK-NEXT:    vmul.f32 q0, q0, q7
; CHECK-NEXT:    vldrw.u32 q7, [sp] @ 16-byte Reload
; CHECK-NEXT:    vldr s20, [sp, #192]
; CHECK-NEXT:    vldr s17, [sp, #204]
; CHECK-NEXT:    vldr s16, [sp, #196]
; CHECK-NEXT:    vfma.f32 q0, q7, q3
; CHECK-NEXT:    vsub.f32 q3, q5, q0
; CHECK-NEXT:    vmov.f32 s1, s4
; CHECK-NEXT:    vadd.f32 q4, q4, q2
; CHECK-NEXT:    vmov.f32 s3, s5
; CHECK-NEXT:    vmov.f32 s5, s6
; CHECK-NEXT:    vmov.f32 s0, s24
; CHECK-NEXT:    vmov.f32 s2, s25
; CHECK-NEXT:    vmov.f32 s4, s26
; CHECK-NEXT:    vmov.f32 s6, s27
; CHECK-NEXT:    vmov.f32 s8, s12
; CHECK-NEXT:    vmov.f32 s9, s16
; CHECK-NEXT:    vmov.f32 s10, s13
; CHECK-NEXT:    vmov.f32 s11, s17
; CHECK-NEXT:    add sp, #64
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    bx lr
entry:
  %ar = shufflevector <12 x float> %a, <12 x float> poison, <6 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10>
  %ai = shufflevector <12 x float> %a, <12 x float> poison, <6 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11>
  %br = shufflevector <12 x float> %b, <12 x float> poison, <6 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10>
  %bi = shufflevector <12 x float> %b, <12 x float> poison, <6 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11>
  %cr = shufflevector <12 x float> %c, <12 x float> poison, <6 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10>
  %ci = shufflevector <12 x float> %c, <12 x float> poison, <6 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11>

  %i6 = fmul fast <6 x float> %br, %ar
  %i7 = fmul fast <6 x float> %bi, %ai
  %xr = fsub fast <6 x float> %i6, %i7
  %i9 = fmul fast <6 x float> %bi, %ar
  %i10 = fmul fast <6 x float> %br, %ai
  %xi = fadd fast <6 x float> %i9, %i10

  %zr = fsub fast <6 x float> %cr, %xi
  %zi = fadd fast <6 x float> %ci, %xr
  %interleaved.vec = shufflevector <6 x float> %zr, <6 x float> %zi, <12 x i32> <i32 0, i32 6, i32 1, i32 7, i32 2, i32 8, i32 3, i32 9, i32 4, i32 10, i32 5, i32 11>
  ret <12 x float> %interleaved.vec
}
