; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -mattr=-promote-alloca -mattr=+enable-flat-scratch < %s | FileCheck --check-prefix=GFX9 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1030 -mattr=-promote-alloca -mattr=+enable-flat-scratch < %s | FileCheck --check-prefix=GFX10 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=-promote-alloca -mattr=+enable-flat-scratch,+real-true16 < %s | FileCheck --check-prefixes=GFX11,GFX11-TRUE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=-promote-alloca -mattr=+enable-flat-scratch,-real-true16 < %s | FileCheck --check-prefixes=GFX11,GFX11-FAKE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1200 -mattr=-promote-alloca -mattr=+enable-flat-scratch,+real-true16 < %s | FileCheck --check-prefixes=GFX12,GFX12-TRUE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1200 -mattr=-promote-alloca -mattr=+enable-flat-scratch,-real-true16 < %s | FileCheck --check-prefixes=GFX12,GFX12-FAKE16 %s
; RUN: llc -mtriple=amdgcn--amdpal -mcpu=gfx900 -mattr=-promote-alloca -mattr=+enable-flat-scratch < %s | FileCheck --check-prefix=GFX9-PAL %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx942 -mattr=-promote-alloca < %s | FileCheck -check-prefixes=GFX942 %s
; RUN: llc -mtriple=amdgcn--amdpal -mcpu=gfx1010 -mattr=-promote-alloca -mattr=+enable-flat-scratch < %s | FileCheck --check-prefixes=GFX10-PAL,GFX1010-PAL %s
; RUN: llc -mtriple=amdgcn--amdpal -mcpu=gfx1030 -mattr=-promote-alloca -mattr=+enable-flat-scratch < %s | FileCheck --check-prefixes=GFX10-PAL,GFX1030-PAL %s
; RUN: llc -mtriple=amdgcn--amdpal -mcpu=gfx1100 -mattr=-promote-alloca -mattr=+enable-flat-scratch,+real-true16 < %s | FileCheck --check-prefixes=GFX11-PAL,GFX11-PAL-TRUE16 %s
; RUN: llc -mtriple=amdgcn--amdpal -mcpu=gfx1100 -mattr=-promote-alloca -mattr=+enable-flat-scratch,-real-true16 < %s | FileCheck --check-prefixes=GFX11-PAL,GFX11-PAL-FAKE16 %s
; RUN: llc -mtriple=amdgcn--amdpal -mcpu=gfx1200 -mattr=-promote-alloca -mattr=+enable-flat-scratch,+real-true16 < %s | FileCheck --check-prefixes=GFX12-PAL,GFX12-PAL-TRUE16 %s
; RUN: llc -mtriple=amdgcn--amdpal -mcpu=gfx1200 -mattr=-promote-alloca -mattr=+enable-flat-scratch,-real-true16 < %s | FileCheck --check-prefixes=GFX12-PAL,GFX12-PAL-FAKE16 %s

define amdgpu_kernel void @zero_init_kernel() {
; GFX9-LABEL: zero_init_kernel:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_mov_b32 s0, 0
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s8, s13
; GFX9-NEXT:    s_mov_b32 s1, s0
; GFX9-NEXT:    s_mov_b32 s2, s0
; GFX9-NEXT:    s_mov_b32 s3, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s9, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:48
; GFX9-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:32
; GFX9-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:16
; GFX9-NEXT:    scratch_store_dwordx4 off, v[0:3], s0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: zero_init_kernel:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_add_u32 s8, s8, s13
; GFX10-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s8
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s9
; GFX10-NEXT:    s_mov_b32 s0, 0
; GFX10-NEXT:    s_mov_b32 s1, s0
; GFX10-NEXT:    s_mov_b32 s2, s0
; GFX10-NEXT:    s_mov_b32 s3, s0
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    v_mov_b32_e32 v2, s2
; GFX10-NEXT:    v_mov_b32_e32 v3, s3
; GFX10-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:48
; GFX10-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:32
; GFX10-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:16
; GFX10-NEXT:    scratch_store_dwordx4 off, v[0:3], off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: zero_init_kernel:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_mov_b32 s1, s0
; GFX11-NEXT:    s_mov_b32 s2, s0
; GFX11-NEXT:    s_mov_b32 s3, s0
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_clause 0x3
; GFX11-NEXT:    scratch_store_b128 off, v[0:3], off offset:48
; GFX11-NEXT:    scratch_store_b128 off, v[0:3], off offset:32
; GFX11-NEXT:    scratch_store_b128 off, v[0:3], off offset:16
; GFX11-NEXT:    scratch_store_b128 off, v[0:3], off
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: zero_init_kernel:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_mov_b32 s1, s0
; GFX12-NEXT:    s_mov_b32 s2, s0
; GFX12-NEXT:    s_mov_b32 s3, s0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    s_clause 0x3
; GFX12-NEXT:    scratch_store_b128 off, v[0:3], off offset:48
; GFX12-NEXT:    scratch_store_b128 off, v[0:3], off offset:32
; GFX12-NEXT:    scratch_store_b128 off, v[0:3], off offset:16
; GFX12-NEXT:    scratch_store_b128 off, v[0:3], off
; GFX12-NEXT:    s_endpgm
;
; GFX9-PAL-LABEL: zero_init_kernel:
; GFX9-PAL:       ; %bb.0:
; GFX9-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX9-PAL-NEXT:    s_mov_b32 s12, s0
; GFX9-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX9-PAL-NEXT:    s_mov_b32 s0, 0
; GFX9-PAL-NEXT:    s_mov_b32 s1, s0
; GFX9-PAL-NEXT:    s_mov_b32 s2, s0
; GFX9-PAL-NEXT:    s_mov_b32 s3, s0
; GFX9-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX9-PAL-NEXT:    s_add_u32 flat_scratch_lo, s12, s11
; GFX9-PAL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-PAL-NEXT:    s_addc_u32 flat_scratch_hi, s13, 0
; GFX9-PAL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-PAL-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-PAL-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:48
; GFX9-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:32
; GFX9-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:16
; GFX9-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0
; GFX9-PAL-NEXT:    s_endpgm
;
; GFX942-LABEL: zero_init_kernel:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_mov_b32 s0, 0
; GFX942-NEXT:    s_mov_b32 s1, s0
; GFX942-NEXT:    s_mov_b32 s2, s0
; GFX942-NEXT:    s_mov_b32 s3, s0
; GFX942-NEXT:    v_mov_b64_e32 v[0:1], s[0:1]
; GFX942-NEXT:    v_mov_b64_e32 v[2:3], s[2:3]
; GFX942-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:48
; GFX942-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:32
; GFX942-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:16
; GFX942-NEXT:    scratch_store_dwordx4 off, v[0:3], off
; GFX942-NEXT:    s_endpgm
;
; GFX1010-PAL-LABEL: zero_init_kernel:
; GFX1010-PAL:       ; %bb.0:
; GFX1010-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX1010-PAL-NEXT:    s_mov_b32 s12, s0
; GFX1010-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX1010-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX1010-PAL-NEXT:    s_add_u32 s12, s12, s11
; GFX1010-PAL-NEXT:    s_addc_u32 s13, s13, 0
; GFX1010-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX1010-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX1010-PAL-NEXT:    s_mov_b32 s0, 0
; GFX1010-PAL-NEXT:    s_mov_b32 s1, s0
; GFX1010-PAL-NEXT:    s_mov_b32 s2, s0
; GFX1010-PAL-NEXT:    s_mov_b32 s3, s0
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v0, s0
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v1, s1
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v2, s2
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v3, s3
; GFX1010-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:48
; GFX1010-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:32
; GFX1010-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:16
; GFX1010-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0
; GFX1010-PAL-NEXT:    s_endpgm
;
; GFX1030-PAL-LABEL: zero_init_kernel:
; GFX1030-PAL:       ; %bb.0:
; GFX1030-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX1030-PAL-NEXT:    s_mov_b32 s12, s0
; GFX1030-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX1030-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX1030-PAL-NEXT:    s_add_u32 s12, s12, s11
; GFX1030-PAL-NEXT:    s_addc_u32 s13, s13, 0
; GFX1030-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX1030-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX1030-PAL-NEXT:    s_mov_b32 s0, 0
; GFX1030-PAL-NEXT:    s_mov_b32 s1, s0
; GFX1030-PAL-NEXT:    s_mov_b32 s2, s0
; GFX1030-PAL-NEXT:    s_mov_b32 s3, s0
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v0, s0
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v1, s1
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v2, s2
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v3, s3
; GFX1030-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:48
; GFX1030-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:32
; GFX1030-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:16
; GFX1030-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off
; GFX1030-PAL-NEXT:    s_endpgm
;
; GFX11-PAL-LABEL: zero_init_kernel:
; GFX11-PAL:       ; %bb.0:
; GFX11-PAL-NEXT:    s_mov_b32 s0, 0
; GFX11-PAL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-PAL-NEXT:    s_mov_b32 s1, s0
; GFX11-PAL-NEXT:    s_mov_b32 s2, s0
; GFX11-PAL-NEXT:    s_mov_b32 s3, s0
; GFX11-PAL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-PAL-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-PAL-NEXT:    s_clause 0x3
; GFX11-PAL-NEXT:    scratch_store_b128 off, v[0:3], off offset:48
; GFX11-PAL-NEXT:    scratch_store_b128 off, v[0:3], off offset:32
; GFX11-PAL-NEXT:    scratch_store_b128 off, v[0:3], off offset:16
; GFX11-PAL-NEXT:    scratch_store_b128 off, v[0:3], off
; GFX11-PAL-NEXT:    s_endpgm
;
; GFX12-PAL-LABEL: zero_init_kernel:
; GFX12-PAL:       ; %bb.0:
; GFX12-PAL-NEXT:    s_mov_b32 s0, 0
; GFX12-PAL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-PAL-NEXT:    s_mov_b32 s1, s0
; GFX12-PAL-NEXT:    s_mov_b32 s2, s0
; GFX12-PAL-NEXT:    s_mov_b32 s3, s0
; GFX12-PAL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-PAL-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-PAL-NEXT:    s_clause 0x3
; GFX12-PAL-NEXT:    scratch_store_b128 off, v[0:3], off offset:48
; GFX12-PAL-NEXT:    scratch_store_b128 off, v[0:3], off offset:32
; GFX12-PAL-NEXT:    scratch_store_b128 off, v[0:3], off offset:16
; GFX12-PAL-NEXT:    scratch_store_b128 off, v[0:3], off
; GFX12-PAL-NEXT:    s_endpgm
  %alloca = alloca [32 x i16], align 2, addrspace(5)
  call void @llvm.memset.p5.i64(ptr addrspace(5) align 2 dereferenceable(64) %alloca, i8 0, i64 64, i1 false)
  ret void
}

define void @zero_init_foo() {
; GFX9-LABEL: zero_init_foo:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s0, 0
; GFX9-NEXT:    s_mov_b32 s1, s0
; GFX9-NEXT:    s_mov_b32 s2, s0
; GFX9-NEXT:    s_mov_b32 s3, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:48
; GFX9-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:32
; GFX9-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:16
; GFX9-NEXT:    scratch_store_dwordx4 off, v[0:3], s32
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: zero_init_foo:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_mov_b32 s0, 0
; GFX10-NEXT:    s_mov_b32 s1, s0
; GFX10-NEXT:    s_mov_b32 s2, s0
; GFX10-NEXT:    s_mov_b32 s3, s0
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    v_mov_b32_e32 v2, s2
; GFX10-NEXT:    v_mov_b32_e32 v3, s3
; GFX10-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:48
; GFX10-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:32
; GFX10-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:16
; GFX10-NEXT:    scratch_store_dwordx4 off, v[0:3], s32
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: zero_init_foo:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_mov_b32 s1, s0
; GFX11-NEXT:    s_mov_b32 s2, s0
; GFX11-NEXT:    s_mov_b32 s3, s0
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_clause 0x3
; GFX11-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:48
; GFX11-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:32
; GFX11-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:16
; GFX11-NEXT:    scratch_store_b128 off, v[0:3], s32
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: zero_init_foo:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_mov_b32 s1, s0
; GFX12-NEXT:    s_mov_b32 s2, s0
; GFX12-NEXT:    s_mov_b32 s3, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    s_clause 0x3
; GFX12-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:48
; GFX12-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:32
; GFX12-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:16
; GFX12-NEXT:    scratch_store_b128 off, v[0:3], s32
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-PAL-LABEL: zero_init_foo:
; GFX9-PAL:       ; %bb.0:
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-PAL-NEXT:    s_mov_b32 s0, 0
; GFX9-PAL-NEXT:    s_mov_b32 s1, s0
; GFX9-PAL-NEXT:    s_mov_b32 s2, s0
; GFX9-PAL-NEXT:    s_mov_b32 s3, s0
; GFX9-PAL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-PAL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-PAL-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-PAL-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:48
; GFX9-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:32
; GFX9-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:16
; GFX9-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s32
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: zero_init_foo:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s0, 0
; GFX942-NEXT:    s_mov_b32 s1, s0
; GFX942-NEXT:    s_mov_b32 s2, s0
; GFX942-NEXT:    s_mov_b32 s3, s0
; GFX942-NEXT:    v_mov_b64_e32 v[0:1], s[0:1]
; GFX942-NEXT:    v_mov_b64_e32 v[2:3], s[2:3]
; GFX942-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:48
; GFX942-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:32
; GFX942-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:16
; GFX942-NEXT:    scratch_store_dwordx4 off, v[0:3], s32
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-PAL-LABEL: zero_init_foo:
; GFX10-PAL:       ; %bb.0:
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-PAL-NEXT:    s_mov_b32 s0, 0
; GFX10-PAL-NEXT:    s_mov_b32 s1, s0
; GFX10-PAL-NEXT:    s_mov_b32 s2, s0
; GFX10-PAL-NEXT:    s_mov_b32 s3, s0
; GFX10-PAL-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-PAL-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-PAL-NEXT:    v_mov_b32_e32 v2, s2
; GFX10-PAL-NEXT:    v_mov_b32_e32 v3, s3
; GFX10-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:48
; GFX10-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:32
; GFX10-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:16
; GFX10-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s32
; GFX10-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-PAL-LABEL: zero_init_foo:
; GFX11-PAL:       ; %bb.0:
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-PAL-NEXT:    s_mov_b32 s0, 0
; GFX11-PAL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-PAL-NEXT:    s_mov_b32 s1, s0
; GFX11-PAL-NEXT:    s_mov_b32 s2, s0
; GFX11-PAL-NEXT:    s_mov_b32 s3, s0
; GFX11-PAL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-PAL-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-PAL-NEXT:    s_clause 0x3
; GFX11-PAL-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:48
; GFX11-PAL-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:32
; GFX11-PAL-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:16
; GFX11-PAL-NEXT:    scratch_store_b128 off, v[0:3], s32
; GFX11-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-PAL-LABEL: zero_init_foo:
; GFX12-PAL:       ; %bb.0:
; GFX12-PAL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-PAL-NEXT:    s_wait_expcnt 0x0
; GFX12-PAL-NEXT:    s_wait_samplecnt 0x0
; GFX12-PAL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-PAL-NEXT:    s_wait_kmcnt 0x0
; GFX12-PAL-NEXT:    s_mov_b32 s0, 0
; GFX12-PAL-NEXT:    s_wait_alu 0xfffe
; GFX12-PAL-NEXT:    s_mov_b32 s1, s0
; GFX12-PAL-NEXT:    s_mov_b32 s2, s0
; GFX12-PAL-NEXT:    s_mov_b32 s3, s0
; GFX12-PAL-NEXT:    s_wait_alu 0xfffe
; GFX12-PAL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-PAL-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-PAL-NEXT:    s_clause 0x3
; GFX12-PAL-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:48
; GFX12-PAL-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:32
; GFX12-PAL-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:16
; GFX12-PAL-NEXT:    scratch_store_b128 off, v[0:3], s32
; GFX12-PAL-NEXT:    s_setpc_b64 s[30:31]
  %alloca = alloca [32 x i16], align 2, addrspace(5)
  call void @llvm.memset.p5.i64(ptr addrspace(5) align 2 dereferenceable(64) %alloca, i8 0, i64 64, i1 false)
  ret void
}

define amdgpu_kernel void @store_load_sindex_kernel(i32 %idx) {
; GFX9-LABEL: store_load_sindex_kernel:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s8, s13
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s9, 0
; GFX9-NEXT:    v_mov_b32_e32 v0, 15
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b32 s1, s0, 2
; GFX9-NEXT:    s_and_b32 s0, s0, 15
; GFX9-NEXT:    s_lshl_b32 s0, s0, 2
; GFX9-NEXT:    scratch_store_dword off, v0, s1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    scratch_load_dword v0, off, s0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: store_load_sindex_kernel:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s8, s8, s13
; GFX10-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s8
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s9
; GFX10-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v0, 15
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_and_b32 s1, s0, 15
; GFX10-NEXT:    s_lshl_b32 s0, s0, 2
; GFX10-NEXT:    s_lshl_b32 s1, s1, 2
; GFX10-NEXT:    scratch_store_dword off, v0, s0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, off, s1 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_load_sindex_kernel:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v0, 15
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_and_b32 s1, s0, 15
; GFX11-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-NEXT:    s_lshl_b32 s1, s1, 2
; GFX11-NEXT:    scratch_store_b32 off, v0, s0 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, off, s1 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: store_load_sindex_kernel:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v0, 15
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_and_b32 s1, s0, 15
; GFX12-NEXT:    s_lshl_b32 s0, s0, 2
; GFX12-NEXT:    s_lshl_b32 s1, s1, 2
; GFX12-NEXT:    scratch_store_b32 off, v0, s0 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, off, s1 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_endpgm
;
; GFX9-PAL-LABEL: store_load_sindex_kernel:
; GFX9-PAL:       ; %bb.0: ; %bb
; GFX9-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX9-PAL-NEXT:    s_mov_b32 s12, s0
; GFX9-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX9-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX9-PAL-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX9-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX9-PAL-NEXT:    s_add_u32 flat_scratch_lo, s12, s11
; GFX9-PAL-NEXT:    s_addc_u32 flat_scratch_hi, s13, 0
; GFX9-PAL-NEXT:    s_lshl_b32 s1, s0, 2
; GFX9-PAL-NEXT:    s_and_b32 s0, s0, 15
; GFX9-PAL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX9-PAL-NEXT:    scratch_store_dword off, v0, s1
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    scratch_load_dword v0, off, s0 glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_endpgm
;
; GFX942-LABEL: store_load_sindex_kernel:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX942-NEXT:    v_mov_b32_e32 v0, 15
; GFX942-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-NEXT:    s_lshl_b32 s1, s0, 2
; GFX942-NEXT:    s_and_b32 s0, s0, 15
; GFX942-NEXT:    s_lshl_b32 s0, s0, 2
; GFX942-NEXT:    scratch_store_dword off, v0, s1 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    scratch_load_dword v0, off, s0 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_endpgm
;
; GFX10-PAL-LABEL: store_load_sindex_kernel:
; GFX10-PAL:       ; %bb.0: ; %bb
; GFX10-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX10-PAL-NEXT:    s_mov_b32 s12, s0
; GFX10-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX10-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX10-PAL-NEXT:    s_add_u32 s12, s12, s11
; GFX10-PAL-NEXT:    s_addc_u32 s13, s13, 0
; GFX10-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX10-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX10-PAL-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX10-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX10-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-PAL-NEXT:    s_and_b32 s1, s0, 15
; GFX10-PAL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX10-PAL-NEXT:    s_lshl_b32 s1, s1, 2
; GFX10-PAL-NEXT:    scratch_store_dword off, v0, s0
; GFX10-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-PAL-NEXT:    scratch_load_dword v0, off, s1 glc dlc
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-PAL-NEXT:    s_endpgm
;
; GFX11-PAL-LABEL: store_load_sindex_kernel:
; GFX11-PAL:       ; %bb.0: ; %bb
; GFX11-PAL-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX11-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-PAL-NEXT:    s_and_b32 s1, s0, 15
; GFX11-PAL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-PAL-NEXT:    s_lshl_b32 s1, s1, 2
; GFX11-PAL-NEXT:    scratch_store_b32 off, v0, s0 dlc
; GFX11-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-PAL-NEXT:    scratch_load_b32 v0, off, s1 glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    s_endpgm
;
; GFX12-PAL-LABEL: store_load_sindex_kernel:
; GFX12-PAL:       ; %bb.0: ; %bb
; GFX12-PAL-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX12-PAL-NEXT:    s_wait_kmcnt 0x0
; GFX12-PAL-NEXT:    s_and_b32 s1, s0, 15
; GFX12-PAL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX12-PAL-NEXT:    s_lshl_b32 s1, s1, 2
; GFX12-PAL-NEXT:    scratch_store_b32 off, v0, s0 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    scratch_load_b32 v0, off, s1 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    s_endpgm
bb:
  %i = alloca [32 x float], align 4, addrspace(5)
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %idx
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = and i32 %idx, 15
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define amdgpu_ps void @store_load_sindex_foo(i32 inreg %idx) {
; GFX9-LABEL: store_load_sindex_foo:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s0, s3
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; GFX9-NEXT:    s_lshl_b32 s0, s2, 2
; GFX9-NEXT:    v_mov_b32_e32 v0, 15
; GFX9-NEXT:    scratch_store_dword off, v0, s0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_and_b32 s0, s2, 15
; GFX9-NEXT:    s_lshl_b32 s0, s0, 2
; GFX9-NEXT:    scratch_load_dword v0, off, s0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: store_load_sindex_foo:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s0, s0, s3
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; GFX10-NEXT:    v_mov_b32_e32 v0, 15
; GFX10-NEXT:    s_and_b32 s0, s2, 15
; GFX10-NEXT:    s_lshl_b32 s1, s2, 2
; GFX10-NEXT:    s_lshl_b32 s0, s0, 2
; GFX10-NEXT:    scratch_store_dword off, v0, s1
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, off, s0 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_load_sindex_foo:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    v_mov_b32_e32 v0, 15
; GFX11-NEXT:    s_and_b32 s1, s0, 15
; GFX11-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-NEXT:    s_lshl_b32 s1, s1, 2
; GFX11-NEXT:    scratch_store_b32 off, v0, s0 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, off, s1 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: store_load_sindex_foo:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    v_mov_b32_e32 v0, 15
; GFX12-NEXT:    s_and_b32 s1, s0, 15
; GFX12-NEXT:    s_lshl_b32 s0, s0, 2
; GFX12-NEXT:    s_lshl_b32 s1, s1, 2
; GFX12-NEXT:    scratch_store_b32 off, v0, s0 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, off, s1 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_endpgm
;
; GFX9-PAL-LABEL: store_load_sindex_foo:
; GFX9-PAL:       ; %bb.0: ; %bb
; GFX9-PAL-NEXT:    s_getpc_b64 s[2:3]
; GFX9-PAL-NEXT:    s_mov_b32 s2, s0
; GFX9-PAL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX9-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX9-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-PAL-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX9-PAL-NEXT:    s_add_u32 flat_scratch_lo, s2, s1
; GFX9-PAL-NEXT:    s_addc_u32 flat_scratch_hi, s3, 0
; GFX9-PAL-NEXT:    s_lshl_b32 s1, s0, 2
; GFX9-PAL-NEXT:    s_and_b32 s0, s0, 15
; GFX9-PAL-NEXT:    scratch_store_dword off, v0, s1
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX9-PAL-NEXT:    scratch_load_dword v0, off, s0 glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_endpgm
;
; GFX942-LABEL: store_load_sindex_foo:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_lshl_b32 s1, s0, 2
; GFX942-NEXT:    v_mov_b32_e32 v0, 15
; GFX942-NEXT:    s_and_b32 s0, s0, 15
; GFX942-NEXT:    scratch_store_dword off, v0, s1 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_lshl_b32 s0, s0, 2
; GFX942-NEXT:    scratch_load_dword v0, off, s0 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_endpgm
;
; GFX10-PAL-LABEL: store_load_sindex_foo:
; GFX10-PAL:       ; %bb.0: ; %bb
; GFX10-PAL-NEXT:    s_getpc_b64 s[2:3]
; GFX10-PAL-NEXT:    s_mov_b32 s2, s0
; GFX10-PAL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX10-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-PAL-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX10-PAL-NEXT:    s_add_u32 s2, s2, s1
; GFX10-PAL-NEXT:    s_addc_u32 s3, s3, 0
; GFX10-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s2
; GFX10-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s3
; GFX10-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX10-PAL-NEXT:    s_and_b32 s1, s0, 15
; GFX10-PAL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX10-PAL-NEXT:    s_lshl_b32 s1, s1, 2
; GFX10-PAL-NEXT:    scratch_store_dword off, v0, s0
; GFX10-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-PAL-NEXT:    scratch_load_dword v0, off, s1 glc dlc
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-PAL-NEXT:    s_endpgm
;
; GFX11-PAL-LABEL: store_load_sindex_foo:
; GFX11-PAL:       ; %bb.0: ; %bb
; GFX11-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX11-PAL-NEXT:    s_and_b32 s1, s0, 15
; GFX11-PAL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-PAL-NEXT:    s_lshl_b32 s1, s1, 2
; GFX11-PAL-NEXT:    scratch_store_b32 off, v0, s0 dlc
; GFX11-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-PAL-NEXT:    scratch_load_b32 v0, off, s1 glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    s_endpgm
;
; GFX12-PAL-LABEL: store_load_sindex_foo:
; GFX12-PAL:       ; %bb.0: ; %bb
; GFX12-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX12-PAL-NEXT:    s_and_b32 s1, s0, 15
; GFX12-PAL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX12-PAL-NEXT:    s_lshl_b32 s1, s1, 2
; GFX12-PAL-NEXT:    scratch_store_b32 off, v0, s0 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    scratch_load_b32 v0, off, s1 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    s_endpgm
bb:
  %i = alloca [32 x float], align 4, addrspace(5)
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %idx
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = and i32 %idx, 15
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define amdgpu_kernel void @store_load_vindex_kernel(i32 %n) {
; GFX9-LABEL: store_load_vindex_kernel:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s8, s13
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s9, 0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 15
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b32 s0, s0, 7
; GFX9-NEXT:    v_add_u32_e32 v2, s0, v0
; GFX9-NEXT:    scratch_store_dword v2, v1, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_sub_u32_e32 v0, s0, v0
; GFX9-NEXT:    scratch_load_dword v0, v0, off offset:124 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: store_load_vindex_kernel:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s8, s8, s13
; GFX10-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s8
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s9
; GFX10-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    v_mov_b32_e32 v2, 15
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_lshl_b32 s0, s0, 7
; GFX10-NEXT:    v_add_nc_u32_e32 v1, s0, v0
; GFX10-NEXT:    v_sub_nc_u32_e32 v0, s0, v0
; GFX10-NEXT:    scratch_store_dword v1, v2, off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, v0, off offset:124 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_load_vindex_kernel:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    v_mov_b32_e32 v2, 15
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_lshl_b32 s0, s0, 7
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    v_add_nc_u32_e32 v1, s0, v0
; GFX11-NEXT:    v_sub_nc_u32_e32 v0, s0, v0
; GFX11-NEXT:    scratch_store_b32 v1, v2, off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, v0, off offset:124 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: store_load_vindex_kernel:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b32 s0, s0, 7
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    v_sub_nc_u32_e32 v2, s0, v0
; GFX12-NEXT:    scratch_store_b32 v0, v1, s0 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, v2, off offset:124 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_endpgm
;
; GFX9-PAL-LABEL: store_load_vindex_kernel:
; GFX9-PAL:       ; %bb.0: ; %bb
; GFX9-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX9-PAL-NEXT:    s_mov_b32 s12, s0
; GFX9-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX9-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-PAL-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX9-PAL-NEXT:    v_mov_b32_e32 v1, 15
; GFX9-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX9-PAL-NEXT:    s_add_u32 flat_scratch_lo, s12, s11
; GFX9-PAL-NEXT:    s_addc_u32 flat_scratch_hi, s13, 0
; GFX9-PAL-NEXT:    s_lshl_b32 s0, s0, 7
; GFX9-PAL-NEXT:    v_add_u32_e32 v2, s0, v0
; GFX9-PAL-NEXT:    scratch_store_dword v2, v1, off
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    v_sub_u32_e32 v0, s0, v0
; GFX9-PAL-NEXT:    scratch_load_dword v0, v0, off offset:124 glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_endpgm
;
; GFX942-LABEL: store_load_vindex_kernel:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX942-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX942-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX942-NEXT:    v_mov_b32_e32 v1, 15
; GFX942-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-NEXT:    s_lshl_b32 s0, s0, 7
; GFX942-NEXT:    v_add_u32_e32 v2, s0, v0
; GFX942-NEXT:    scratch_store_dword v2, v1, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    v_sub_u32_e32 v0, s0, v0
; GFX942-NEXT:    scratch_load_dword v0, v0, off offset:124 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_endpgm
;
; GFX10-PAL-LABEL: store_load_vindex_kernel:
; GFX10-PAL:       ; %bb.0: ; %bb
; GFX10-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX10-PAL-NEXT:    s_mov_b32 s12, s0
; GFX10-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX10-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX10-PAL-NEXT:    s_add_u32 s12, s12, s11
; GFX10-PAL-NEXT:    s_addc_u32 s13, s13, 0
; GFX10-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX10-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX10-PAL-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX10-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-PAL-NEXT:    v_mov_b32_e32 v2, 15
; GFX10-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-PAL-NEXT:    s_lshl_b32 s0, s0, 7
; GFX10-PAL-NEXT:    v_add_nc_u32_e32 v1, s0, v0
; GFX10-PAL-NEXT:    v_sub_nc_u32_e32 v0, s0, v0
; GFX10-PAL-NEXT:    scratch_store_dword v1, v2, off
; GFX10-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-PAL-NEXT:    scratch_load_dword v0, v0, off offset:124 glc dlc
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-PAL-NEXT:    s_endpgm
;
; GFX11-PAL-LABEL: store_load_vindex_kernel:
; GFX11-PAL:       ; %bb.0: ; %bb
; GFX11-PAL-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-PAL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-PAL-NEXT:    v_mov_b32_e32 v2, 15
; GFX11-PAL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-PAL-NEXT:    s_lshl_b32 s0, s0, 7
; GFX11-PAL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-PAL-NEXT:    v_add_nc_u32_e32 v1, s0, v0
; GFX11-PAL-NEXT:    v_sub_nc_u32_e32 v0, s0, v0
; GFX11-PAL-NEXT:    scratch_store_b32 v1, v2, off dlc
; GFX11-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-PAL-NEXT:    scratch_load_b32 v0, v0, off offset:124 glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    s_endpgm
;
; GFX12-PAL-LABEL: store_load_vindex_kernel:
; GFX12-PAL:       ; %bb.0: ; %bb
; GFX12-PAL-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-PAL-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-PAL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-PAL-NEXT:    s_wait_kmcnt 0x0
; GFX12-PAL-NEXT:    s_lshl_b32 s0, s0, 7
; GFX12-PAL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX12-PAL-NEXT:    v_sub_nc_u32_e32 v2, s0, v0
; GFX12-PAL-NEXT:    scratch_store_b32 v0, v1, s0 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    scratch_load_b32 v0, v2, off offset:124 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    s_endpgm
bb:
  %i.alloca = alloca [2 x [32 x float]], align 4, addrspace(5)
  %i = getelementptr inbounds [2 x [32 x float]], ptr addrspace (5) %i.alloca, i32 0, i32 %n
  %i2 = tail call i32 @llvm.amdgcn.workitem.id.x()
  %i3 = zext i32 %i2 to i64
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i2
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = sub nsw i32 0, %i2
  %i9.1 = getelementptr [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i9.1, i32 0, i32 31
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define void @store_load_vindex_foo(i32 %idx) {
; GFX9-LABEL: store_load_vindex_foo:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s32
; GFX9-NEXT:    v_lshl_add_u32 v2, v0, 2, v1
; GFX9-NEXT:    v_mov_b32_e32 v3, 15
; GFX9-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX9-NEXT:    scratch_store_dword v2, v3, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshl_add_u32 v0, v0, 2, v1
; GFX9-NEXT:    scratch_load_dword v0, v0, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: store_load_vindex_foo:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v1, 15, v0
; GFX10-NEXT:    v_lshl_add_u32 v0, v0, 2, s32
; GFX10-NEXT:    v_mov_b32_e32 v2, 15
; GFX10-NEXT:    v_lshl_add_u32 v1, v1, 2, s32
; GFX10-NEXT:    scratch_store_dword v0, v2, off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, v1, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: store_load_vindex_foo:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_and_b32 v1, 15, v0
; GFX11-NEXT:    v_lshl_add_u32 v0, v0, 2, s32
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX11-NEXT:    scratch_store_b32 v0, v2, off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, v1, s32 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: store_load_vindex_foo:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_and_b32 v1, 15, v0
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b32 v0, v2, s32 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, v1, s32 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-PAL-LABEL: store_load_vindex_foo:
; GFX9-PAL:       ; %bb.0: ; %bb
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-PAL-NEXT:    v_mov_b32_e32 v1, s32
; GFX9-PAL-NEXT:    v_lshl_add_u32 v2, v0, 2, v1
; GFX9-PAL-NEXT:    v_mov_b32_e32 v3, 15
; GFX9-PAL-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX9-PAL-NEXT:    scratch_store_dword v2, v3, off
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    v_lshl_add_u32 v0, v0, 2, v1
; GFX9-PAL-NEXT:    scratch_load_dword v0, v0, off glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: store_load_vindex_foo:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v1, s32
; GFX942-NEXT:    v_lshl_add_u32 v1, v0, 2, v1
; GFX942-NEXT:    v_mov_b32_e32 v2, 15
; GFX942-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX942-NEXT:    scratch_store_dword v1, v2, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX942-NEXT:    scratch_load_dword v0, v0, s32 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-PAL-LABEL: store_load_vindex_foo:
; GFX10-PAL:       ; %bb.0: ; %bb
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-PAL-NEXT:    v_and_b32_e32 v1, 15, v0
; GFX10-PAL-NEXT:    v_lshl_add_u32 v0, v0, 2, s32
; GFX10-PAL-NEXT:    v_mov_b32_e32 v2, 15
; GFX10-PAL-NEXT:    v_lshl_add_u32 v1, v1, 2, s32
; GFX10-PAL-NEXT:    scratch_store_dword v0, v2, off
; GFX10-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-PAL-NEXT:    scratch_load_dword v0, v1, off glc dlc
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-PAL-LABEL: store_load_vindex_foo:
; GFX11-PAL:       ; %bb.0: ; %bb
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-PAL-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_and_b32 v1, 15, v0
; GFX11-PAL-NEXT:    v_lshl_add_u32 v0, v0, 2, s32
; GFX11-PAL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-PAL-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX11-PAL-NEXT:    scratch_store_b32 v0, v2, off dlc
; GFX11-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-PAL-NEXT:    scratch_load_b32 v0, v1, s32 glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-PAL-LABEL: store_load_vindex_foo:
; GFX12-PAL:       ; %bb.0: ; %bb
; GFX12-PAL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-PAL-NEXT:    s_wait_expcnt 0x0
; GFX12-PAL-NEXT:    s_wait_samplecnt 0x0
; GFX12-PAL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-PAL-NEXT:    s_wait_kmcnt 0x0
; GFX12-PAL-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_and_b32 v1, 15, v0
; GFX12-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-PAL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-PAL-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    scratch_store_b32 v0, v2, s32 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    scratch_load_b32 v0, v1, s32 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    s_setpc_b64 s[30:31]
bb:
  %i = alloca [32 x float], align 4, addrspace(5)
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %idx
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = and i32 %idx, 15
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define void @private_ptr_foo(ptr addrspace(5) nocapture %arg) {
; GFX9-LABEL: private_ptr_foo:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x41200000
; GFX9-NEXT:    scratch_store_dword v0, v1, off offset:4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: private_ptr_foo:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, 0x41200000
; GFX10-NEXT:    scratch_store_dword v0, v1, off offset:4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: private_ptr_foo:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v1, 0x41200000
; GFX11-NEXT:    scratch_store_b32 v0, v1, off offset:4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: private_ptr_foo:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v1, 0x41200000
; GFX12-NEXT:    scratch_store_b32 v0, v1, off offset:4
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-PAL-LABEL: private_ptr_foo:
; GFX9-PAL:       ; %bb.0:
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-PAL-NEXT:    v_mov_b32_e32 v1, 0x41200000
; GFX9-PAL-NEXT:    scratch_store_dword v0, v1, off offset:4
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: private_ptr_foo:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v1, 0x41200000
; GFX942-NEXT:    scratch_store_dword v0, v1, off offset:4
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-PAL-LABEL: private_ptr_foo:
; GFX10-PAL:       ; %bb.0:
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-PAL-NEXT:    v_mov_b32_e32 v1, 0x41200000
; GFX10-PAL-NEXT:    scratch_store_dword v0, v1, off offset:4
; GFX10-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-PAL-LABEL: private_ptr_foo:
; GFX11-PAL:       ; %bb.0:
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-PAL-NEXT:    v_mov_b32_e32 v1, 0x41200000
; GFX11-PAL-NEXT:    scratch_store_b32 v0, v1, off offset:4
; GFX11-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-PAL-LABEL: private_ptr_foo:
; GFX12-PAL:       ; %bb.0:
; GFX12-PAL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-PAL-NEXT:    s_wait_expcnt 0x0
; GFX12-PAL-NEXT:    s_wait_samplecnt 0x0
; GFX12-PAL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-PAL-NEXT:    s_wait_kmcnt 0x0
; GFX12-PAL-NEXT:    v_mov_b32_e32 v1, 0x41200000
; GFX12-PAL-NEXT:    scratch_store_b32 v0, v1, off offset:4
; GFX12-PAL-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr inbounds float, ptr addrspace(5) %arg, i32 1
  store float 1.000000e+01, ptr addrspace(5) %gep, align 4
  ret void
}

define amdgpu_kernel void @zero_init_small_offset_kernel() {
; GFX9-LABEL: zero_init_small_offset_kernel:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s8, s13
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s9, 0
; GFX9-NEXT:    s_mov_b32 s0, 0
; GFX9-NEXT:    scratch_load_dword v0, off, s0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_mov_b32 s1, s0
; GFX9-NEXT:    s_mov_b32 s2, s0
; GFX9-NEXT:    s_mov_b32 s3, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:256
; GFX9-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:272
; GFX9-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:288
; GFX9-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:304
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: zero_init_small_offset_kernel:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_add_u32 s8, s8, s13
; GFX10-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s8
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s9
; GFX10-NEXT:    scratch_load_dword v0, off, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_mov_b32 s0, 0
; GFX10-NEXT:    s_mov_b32 s1, s0
; GFX10-NEXT:    s_mov_b32 s2, s0
; GFX10-NEXT:    s_mov_b32 s3, s0
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    v_mov_b32_e32 v2, s2
; GFX10-NEXT:    v_mov_b32_e32 v3, s3
; GFX10-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:256
; GFX10-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:272
; GFX10-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:288
; GFX10-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:304
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: zero_init_small_offset_kernel:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    scratch_load_b32 v0, off, off glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_mov_b32 s1, s0
; GFX11-NEXT:    s_mov_b32 s2, s0
; GFX11-NEXT:    s_mov_b32 s3, s0
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_clause 0x3
; GFX11-NEXT:    scratch_store_b128 off, v[0:3], off offset:256
; GFX11-NEXT:    scratch_store_b128 off, v[0:3], off offset:272
; GFX11-NEXT:    scratch_store_b128 off, v[0:3], off offset:288
; GFX11-NEXT:    scratch_store_b128 off, v[0:3], off offset:304
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: zero_init_small_offset_kernel:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    scratch_load_b32 v0, off, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_mov_b32 s1, s0
; GFX12-NEXT:    s_mov_b32 s2, s0
; GFX12-NEXT:    s_mov_b32 s3, s0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    s_clause 0x3
; GFX12-NEXT:    scratch_store_b128 off, v[0:3], off offset:256
; GFX12-NEXT:    scratch_store_b128 off, v[0:3], off offset:272
; GFX12-NEXT:    scratch_store_b128 off, v[0:3], off offset:288
; GFX12-NEXT:    scratch_store_b128 off, v[0:3], off offset:304
; GFX12-NEXT:    s_endpgm
;
; GFX9-PAL-LABEL: zero_init_small_offset_kernel:
; GFX9-PAL:       ; %bb.0:
; GFX9-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX9-PAL-NEXT:    s_mov_b32 s12, s0
; GFX9-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX9-PAL-NEXT:    s_mov_b32 s0, 0
; GFX9-PAL-NEXT:    s_mov_b32 s1, s0
; GFX9-PAL-NEXT:    s_mov_b32 s2, s0
; GFX9-PAL-NEXT:    s_mov_b32 s3, s0
; GFX9-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX9-PAL-NEXT:    s_add_u32 flat_scratch_lo, s12, s11
; GFX9-PAL-NEXT:    s_addc_u32 flat_scratch_hi, s13, 0
; GFX9-PAL-NEXT:    scratch_load_dword v0, off, s0 glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-PAL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-PAL-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-PAL-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:256
; GFX9-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:272
; GFX9-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:288
; GFX9-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:304
; GFX9-PAL-NEXT:    s_endpgm
;
; GFX942-LABEL: zero_init_small_offset_kernel:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    scratch_load_dword v0, off, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_mov_b32 s0, 0
; GFX942-NEXT:    s_mov_b32 s1, s0
; GFX942-NEXT:    s_mov_b32 s2, s0
; GFX942-NEXT:    s_mov_b32 s3, s0
; GFX942-NEXT:    v_mov_b64_e32 v[0:1], s[0:1]
; GFX942-NEXT:    v_mov_b64_e32 v[2:3], s[2:3]
; GFX942-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:256
; GFX942-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:272
; GFX942-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:288
; GFX942-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:304
; GFX942-NEXT:    s_endpgm
;
; GFX1010-PAL-LABEL: zero_init_small_offset_kernel:
; GFX1010-PAL:       ; %bb.0:
; GFX1010-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX1010-PAL-NEXT:    s_mov_b32 s12, s0
; GFX1010-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX1010-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX1010-PAL-NEXT:    s_add_u32 s12, s12, s11
; GFX1010-PAL-NEXT:    s_addc_u32 s13, s13, 0
; GFX1010-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX1010-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX1010-PAL-NEXT:    s_mov_b32 s0, 0
; GFX1010-PAL-NEXT:    scratch_load_dword v0, off, s0 glc dlc
; GFX1010-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-PAL-NEXT:    s_mov_b32 s1, s0
; GFX1010-PAL-NEXT:    s_mov_b32 s2, s0
; GFX1010-PAL-NEXT:    s_mov_b32 s3, s0
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v0, s0
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v1, s1
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v2, s2
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v3, s3
; GFX1010-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:256
; GFX1010-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:272
; GFX1010-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:288
; GFX1010-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:304
; GFX1010-PAL-NEXT:    s_endpgm
;
; GFX1030-PAL-LABEL: zero_init_small_offset_kernel:
; GFX1030-PAL:       ; %bb.0:
; GFX1030-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX1030-PAL-NEXT:    s_mov_b32 s12, s0
; GFX1030-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX1030-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX1030-PAL-NEXT:    s_add_u32 s12, s12, s11
; GFX1030-PAL-NEXT:    s_addc_u32 s13, s13, 0
; GFX1030-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX1030-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX1030-PAL-NEXT:    scratch_load_dword v0, off, off glc dlc
; GFX1030-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-PAL-NEXT:    s_mov_b32 s0, 0
; GFX1030-PAL-NEXT:    s_mov_b32 s1, s0
; GFX1030-PAL-NEXT:    s_mov_b32 s2, s0
; GFX1030-PAL-NEXT:    s_mov_b32 s3, s0
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v0, s0
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v1, s1
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v2, s2
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v3, s3
; GFX1030-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:256
; GFX1030-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:272
; GFX1030-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:288
; GFX1030-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:304
; GFX1030-PAL-NEXT:    s_endpgm
;
; GFX11-PAL-LABEL: zero_init_small_offset_kernel:
; GFX11-PAL:       ; %bb.0:
; GFX11-PAL-NEXT:    scratch_load_b32 v0, off, off glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    s_mov_b32 s0, 0
; GFX11-PAL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-PAL-NEXT:    s_mov_b32 s1, s0
; GFX11-PAL-NEXT:    s_mov_b32 s2, s0
; GFX11-PAL-NEXT:    s_mov_b32 s3, s0
; GFX11-PAL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-PAL-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-PAL-NEXT:    s_clause 0x3
; GFX11-PAL-NEXT:    scratch_store_b128 off, v[0:3], off offset:256
; GFX11-PAL-NEXT:    scratch_store_b128 off, v[0:3], off offset:272
; GFX11-PAL-NEXT:    scratch_store_b128 off, v[0:3], off offset:288
; GFX11-PAL-NEXT:    scratch_store_b128 off, v[0:3], off offset:304
; GFX11-PAL-NEXT:    s_endpgm
;
; GFX12-PAL-LABEL: zero_init_small_offset_kernel:
; GFX12-PAL:       ; %bb.0:
; GFX12-PAL-NEXT:    scratch_load_b32 v0, off, off scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    s_mov_b32 s0, 0
; GFX12-PAL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-PAL-NEXT:    s_mov_b32 s1, s0
; GFX12-PAL-NEXT:    s_mov_b32 s2, s0
; GFX12-PAL-NEXT:    s_mov_b32 s3, s0
; GFX12-PAL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-PAL-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-PAL-NEXT:    s_clause 0x3
; GFX12-PAL-NEXT:    scratch_store_b128 off, v[0:3], off offset:256
; GFX12-PAL-NEXT:    scratch_store_b128 off, v[0:3], off offset:272
; GFX12-PAL-NEXT:    scratch_store_b128 off, v[0:3], off offset:288
; GFX12-PAL-NEXT:    scratch_store_b128 off, v[0:3], off offset:304
; GFX12-PAL-NEXT:    s_endpgm
  %padding = alloca [64 x i32], align 4, addrspace(5)
  %alloca = alloca [32 x i16], align 2, addrspace(5)
  %pad_gep = getelementptr inbounds [64 x i32], ptr addrspace(5) %padding, i32 0, i32 0
  %pad_load = load volatile i32, ptr addrspace(5) %pad_gep, align 4
  call void @llvm.memset.p5.i64(ptr addrspace(5) align 2 dereferenceable(64) %alloca, i8 0, i64 64, i1 false)
  ret void
}

define void @zero_init_small_offset_foo() {
; GFX9-LABEL: zero_init_small_offset_foo:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    scratch_load_dword v0, off, s32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_mov_b32 s0, 0
; GFX9-NEXT:    s_mov_b32 s1, s0
; GFX9-NEXT:    s_mov_b32 s2, s0
; GFX9-NEXT:    s_mov_b32 s3, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:256
; GFX9-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:272
; GFX9-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:288
; GFX9-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:304
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: zero_init_small_offset_foo:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    scratch_load_dword v0, off, s32 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_mov_b32 s0, 0
; GFX10-NEXT:    s_mov_b32 s1, s0
; GFX10-NEXT:    s_mov_b32 s2, s0
; GFX10-NEXT:    s_mov_b32 s3, s0
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    v_mov_b32_e32 v2, s2
; GFX10-NEXT:    v_mov_b32_e32 v3, s3
; GFX10-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:256
; GFX10-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:272
; GFX10-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:288
; GFX10-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:304
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: zero_init_small_offset_foo:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    scratch_load_b32 v0, off, s32 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_mov_b32 s1, s0
; GFX11-NEXT:    s_mov_b32 s2, s0
; GFX11-NEXT:    s_mov_b32 s3, s0
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_clause 0x3
; GFX11-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:256
; GFX11-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:272
; GFX11-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:288
; GFX11-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:304
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: zero_init_small_offset_foo:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, off, s32 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_mov_b32 s1, s0
; GFX12-NEXT:    s_mov_b32 s2, s0
; GFX12-NEXT:    s_mov_b32 s3, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    s_clause 0x3
; GFX12-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:256
; GFX12-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:272
; GFX12-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:288
; GFX12-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:304
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-PAL-LABEL: zero_init_small_offset_foo:
; GFX9-PAL:       ; %bb.0:
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-PAL-NEXT:    scratch_load_dword v0, off, s32 glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_mov_b32 s0, 0
; GFX9-PAL-NEXT:    s_mov_b32 s1, s0
; GFX9-PAL-NEXT:    s_mov_b32 s2, s0
; GFX9-PAL-NEXT:    s_mov_b32 s3, s0
; GFX9-PAL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-PAL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-PAL-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-PAL-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:256
; GFX9-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:272
; GFX9-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:288
; GFX9-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:304
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: zero_init_small_offset_foo:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    scratch_load_dword v0, off, s32 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_mov_b32 s0, 0
; GFX942-NEXT:    s_mov_b32 s1, s0
; GFX942-NEXT:    s_mov_b32 s2, s0
; GFX942-NEXT:    s_mov_b32 s3, s0
; GFX942-NEXT:    v_mov_b64_e32 v[0:1], s[0:1]
; GFX942-NEXT:    v_mov_b64_e32 v[2:3], s[2:3]
; GFX942-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:256
; GFX942-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:272
; GFX942-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:288
; GFX942-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:304
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-PAL-LABEL: zero_init_small_offset_foo:
; GFX10-PAL:       ; %bb.0:
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-PAL-NEXT:    scratch_load_dword v0, off, s32 glc dlc
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-PAL-NEXT:    s_mov_b32 s0, 0
; GFX10-PAL-NEXT:    s_mov_b32 s1, s0
; GFX10-PAL-NEXT:    s_mov_b32 s2, s0
; GFX10-PAL-NEXT:    s_mov_b32 s3, s0
; GFX10-PAL-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-PAL-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-PAL-NEXT:    v_mov_b32_e32 v2, s2
; GFX10-PAL-NEXT:    v_mov_b32_e32 v3, s3
; GFX10-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:256
; GFX10-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:272
; GFX10-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:288
; GFX10-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s32 offset:304
; GFX10-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-PAL-LABEL: zero_init_small_offset_foo:
; GFX11-PAL:       ; %bb.0:
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-PAL-NEXT:    scratch_load_b32 v0, off, s32 glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    s_mov_b32 s0, 0
; GFX11-PAL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-PAL-NEXT:    s_mov_b32 s1, s0
; GFX11-PAL-NEXT:    s_mov_b32 s2, s0
; GFX11-PAL-NEXT:    s_mov_b32 s3, s0
; GFX11-PAL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-PAL-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-PAL-NEXT:    s_clause 0x3
; GFX11-PAL-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:256
; GFX11-PAL-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:272
; GFX11-PAL-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:288
; GFX11-PAL-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:304
; GFX11-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-PAL-LABEL: zero_init_small_offset_foo:
; GFX12-PAL:       ; %bb.0:
; GFX12-PAL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-PAL-NEXT:    s_wait_expcnt 0x0
; GFX12-PAL-NEXT:    s_wait_samplecnt 0x0
; GFX12-PAL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-PAL-NEXT:    s_wait_kmcnt 0x0
; GFX12-PAL-NEXT:    scratch_load_b32 v0, off, s32 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    s_mov_b32 s0, 0
; GFX12-PAL-NEXT:    s_wait_alu 0xfffe
; GFX12-PAL-NEXT:    s_mov_b32 s1, s0
; GFX12-PAL-NEXT:    s_mov_b32 s2, s0
; GFX12-PAL-NEXT:    s_mov_b32 s3, s0
; GFX12-PAL-NEXT:    s_wait_alu 0xfffe
; GFX12-PAL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-PAL-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-PAL-NEXT:    s_clause 0x3
; GFX12-PAL-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:256
; GFX12-PAL-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:272
; GFX12-PAL-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:288
; GFX12-PAL-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:304
; GFX12-PAL-NEXT:    s_setpc_b64 s[30:31]
  %padding = alloca [64 x i32], align 4, addrspace(5)
  %alloca = alloca [32 x i16], align 2, addrspace(5)
  %pad_gep = getelementptr inbounds [64 x i32], ptr addrspace(5) %padding, i32 0, i32 0
  %pad_load = load volatile i32, ptr addrspace(5) %pad_gep, align 4
  call void @llvm.memset.p5.i64(ptr addrspace(5) align 2 dereferenceable(64) %alloca, i8 0, i64 64, i1 false)
  ret void
}

define amdgpu_kernel void @store_load_sindex_small_offset_kernel(i32 %idx) {
; GFX9-LABEL: store_load_sindex_small_offset_kernel:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s8, s13
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s9, 0
; GFX9-NEXT:    s_mov_b32 s1, 0
; GFX9-NEXT:    scratch_load_dword v0, off, s1 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b32 s1, s0, 2
; GFX9-NEXT:    s_and_b32 s0, s0, 15
; GFX9-NEXT:    v_mov_b32_e32 v0, 15
; GFX9-NEXT:    s_addk_i32 s1, 0x100
; GFX9-NEXT:    s_lshl_b32 s0, s0, 2
; GFX9-NEXT:    scratch_store_dword off, v0, s1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_addk_i32 s0, 0x100
; GFX9-NEXT:    scratch_load_dword v0, off, s0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: store_load_sindex_small_offset_kernel:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s8, s8, s13
; GFX10-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s8
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s9
; GFX10-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX10-NEXT:    scratch_load_dword v0, off, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, 15
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_and_b32 s1, s0, 15
; GFX10-NEXT:    s_lshl_b32 s0, s0, 2
; GFX10-NEXT:    s_lshl_b32 s1, s1, 2
; GFX10-NEXT:    s_addk_i32 s0, 0x100
; GFX10-NEXT:    s_addk_i32 s1, 0x100
; GFX10-NEXT:    scratch_store_dword off, v0, s0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, off, s1 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_load_sindex_small_offset_kernel:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-NEXT:    scratch_load_b32 v0, off, off glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v0, 15
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_and_b32 s1, s0, 15
; GFX11-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-NEXT:    s_lshl_b32 s1, s1, 2
; GFX11-NEXT:    s_addk_i32 s0, 0x100
; GFX11-NEXT:    s_addk_i32 s1, 0x100
; GFX11-NEXT:    scratch_store_b32 off, v0, s0 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, off, s1 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: store_load_sindex_small_offset_kernel:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-NEXT:    scratch_load_b32 v0, off, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, 15
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_and_b32 s1, s0, 15
; GFX12-NEXT:    s_lshl_b32 s0, s0, 2
; GFX12-NEXT:    s_lshl_b32 s1, s1, 2
; GFX12-NEXT:    s_addk_co_i32 s0, 0x100
; GFX12-NEXT:    s_addk_co_i32 s1, 0x100
; GFX12-NEXT:    scratch_store_b32 off, v0, s0 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, off, s1 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_endpgm
;
; GFX9-PAL-LABEL: store_load_sindex_small_offset_kernel:
; GFX9-PAL:       ; %bb.0: ; %bb
; GFX9-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX9-PAL-NEXT:    s_mov_b32 s12, s0
; GFX9-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX9-PAL-NEXT:    s_mov_b32 s1, 0
; GFX9-PAL-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX9-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX9-PAL-NEXT:    s_add_u32 flat_scratch_lo, s12, s11
; GFX9-PAL-NEXT:    s_addc_u32 flat_scratch_hi, s13, 0
; GFX9-PAL-NEXT:    scratch_load_dword v0, off, s1 glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_lshl_b32 s1, s0, 2
; GFX9-PAL-NEXT:    s_and_b32 s0, s0, 15
; GFX9-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX9-PAL-NEXT:    s_addk_i32 s1, 0x100
; GFX9-PAL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX9-PAL-NEXT:    scratch_store_dword off, v0, s1
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_addk_i32 s0, 0x100
; GFX9-PAL-NEXT:    scratch_load_dword v0, off, s0 glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_endpgm
;
; GFX942-LABEL: store_load_sindex_small_offset_kernel:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX942-NEXT:    scratch_load_dword v0, off, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v0, 15
; GFX942-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-NEXT:    s_lshl_b32 s1, s0, 2
; GFX942-NEXT:    s_and_b32 s0, s0, 15
; GFX942-NEXT:    s_addk_i32 s1, 0x100
; GFX942-NEXT:    s_lshl_b32 s0, s0, 2
; GFX942-NEXT:    scratch_store_dword off, v0, s1 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_addk_i32 s0, 0x100
; GFX942-NEXT:    scratch_load_dword v0, off, s0 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_endpgm
;
; GFX1010-PAL-LABEL: store_load_sindex_small_offset_kernel:
; GFX1010-PAL:       ; %bb.0: ; %bb
; GFX1010-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX1010-PAL-NEXT:    s_mov_b32 s12, s0
; GFX1010-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX1010-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX1010-PAL-NEXT:    s_add_u32 s12, s12, s11
; GFX1010-PAL-NEXT:    s_addc_u32 s13, s13, 0
; GFX1010-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX1010-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX1010-PAL-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX1010-PAL-NEXT:    s_mov_b32 s1, 0
; GFX1010-PAL-NEXT:    scratch_load_dword v0, off, s1 glc dlc
; GFX1010-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX1010-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-PAL-NEXT:    s_and_b32 s1, s0, 15
; GFX1010-PAL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX1010-PAL-NEXT:    s_lshl_b32 s1, s1, 2
; GFX1010-PAL-NEXT:    s_addk_i32 s0, 0x100
; GFX1010-PAL-NEXT:    s_addk_i32 s1, 0x100
; GFX1010-PAL-NEXT:    scratch_store_dword off, v0, s0
; GFX1010-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1010-PAL-NEXT:    scratch_load_dword v0, off, s1 glc dlc
; GFX1010-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-PAL-NEXT:    s_endpgm
;
; GFX1030-PAL-LABEL: store_load_sindex_small_offset_kernel:
; GFX1030-PAL:       ; %bb.0: ; %bb
; GFX1030-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX1030-PAL-NEXT:    s_mov_b32 s12, s0
; GFX1030-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX1030-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX1030-PAL-NEXT:    s_add_u32 s12, s12, s11
; GFX1030-PAL-NEXT:    s_addc_u32 s13, s13, 0
; GFX1030-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX1030-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX1030-PAL-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX1030-PAL-NEXT:    scratch_load_dword v0, off, off glc dlc
; GFX1030-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX1030-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-PAL-NEXT:    s_and_b32 s1, s0, 15
; GFX1030-PAL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX1030-PAL-NEXT:    s_lshl_b32 s1, s1, 2
; GFX1030-PAL-NEXT:    s_addk_i32 s0, 0x100
; GFX1030-PAL-NEXT:    s_addk_i32 s1, 0x100
; GFX1030-PAL-NEXT:    scratch_store_dword off, v0, s0
; GFX1030-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1030-PAL-NEXT:    scratch_load_dword v0, off, s1 glc dlc
; GFX1030-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-PAL-NEXT:    s_endpgm
;
; GFX11-PAL-LABEL: store_load_sindex_small_offset_kernel:
; GFX11-PAL:       ; %bb.0: ; %bb
; GFX11-PAL-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-PAL-NEXT:    scratch_load_b32 v0, off, off glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX11-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-PAL-NEXT:    s_and_b32 s1, s0, 15
; GFX11-PAL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-PAL-NEXT:    s_lshl_b32 s1, s1, 2
; GFX11-PAL-NEXT:    s_addk_i32 s0, 0x100
; GFX11-PAL-NEXT:    s_addk_i32 s1, 0x100
; GFX11-PAL-NEXT:    scratch_store_b32 off, v0, s0 dlc
; GFX11-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-PAL-NEXT:    scratch_load_b32 v0, off, s1 glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    s_endpgm
;
; GFX12-PAL-LABEL: store_load_sindex_small_offset_kernel:
; GFX12-PAL:       ; %bb.0: ; %bb
; GFX12-PAL-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-PAL-NEXT:    scratch_load_b32 v0, off, off scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX12-PAL-NEXT:    s_wait_kmcnt 0x0
; GFX12-PAL-NEXT:    s_and_b32 s1, s0, 15
; GFX12-PAL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX12-PAL-NEXT:    s_lshl_b32 s1, s1, 2
; GFX12-PAL-NEXT:    s_addk_co_i32 s0, 0x100
; GFX12-PAL-NEXT:    s_addk_co_i32 s1, 0x100
; GFX12-PAL-NEXT:    scratch_store_b32 off, v0, s0 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    scratch_load_b32 v0, off, s1 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    s_endpgm
bb:
  %padding = alloca [64 x i32], align 4, addrspace(5)
  %i = alloca [32 x float], align 4, addrspace(5)
  %pad_gep = getelementptr inbounds [64 x i32], ptr addrspace(5) %padding, i32 0, i32 0
  %pad_load = load volatile i32, ptr addrspace(5) %pad_gep, align 4
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %idx
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = and i32 %idx, 15
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define amdgpu_ps void @store_load_sindex_small_offset_foo(i32 inreg %idx) {
; GFX9-LABEL: store_load_sindex_small_offset_foo:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s0, s3
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; GFX9-NEXT:    s_mov_b32 s0, 0
; GFX9-NEXT:    scratch_load_dword v0, off, s0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_lshl_b32 s0, s2, 2
; GFX9-NEXT:    s_addk_i32 s0, 0x100
; GFX9-NEXT:    v_mov_b32_e32 v0, 15
; GFX9-NEXT:    scratch_store_dword off, v0, s0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_and_b32 s0, s2, 15
; GFX9-NEXT:    s_lshl_b32 s0, s0, 2
; GFX9-NEXT:    s_addk_i32 s0, 0x100
; GFX9-NEXT:    scratch_load_dword v0, off, s0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: store_load_sindex_small_offset_foo:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s0, s0, s3
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; GFX10-NEXT:    scratch_load_dword v0, off, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, 15
; GFX10-NEXT:    s_and_b32 s0, s2, 15
; GFX10-NEXT:    s_lshl_b32 s1, s2, 2
; GFX10-NEXT:    s_lshl_b32 s0, s0, 2
; GFX10-NEXT:    s_addk_i32 s1, 0x100
; GFX10-NEXT:    s_addk_i32 s0, 0x100
; GFX10-NEXT:    scratch_store_dword off, v0, s1
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, off, s0 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_load_sindex_small_offset_foo:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    scratch_load_b32 v0, off, off glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v0, 15
; GFX11-NEXT:    s_and_b32 s1, s0, 15
; GFX11-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-NEXT:    s_lshl_b32 s1, s1, 2
; GFX11-NEXT:    s_addk_i32 s0, 0x100
; GFX11-NEXT:    s_addk_i32 s1, 0x100
; GFX11-NEXT:    scratch_store_b32 off, v0, s0 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, off, s1 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: store_load_sindex_small_offset_foo:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    scratch_load_b32 v0, off, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, 15
; GFX12-NEXT:    s_and_b32 s1, s0, 15
; GFX12-NEXT:    s_lshl_b32 s0, s0, 2
; GFX12-NEXT:    s_lshl_b32 s1, s1, 2
; GFX12-NEXT:    s_addk_co_i32 s0, 0x100
; GFX12-NEXT:    s_addk_co_i32 s1, 0x100
; GFX12-NEXT:    scratch_store_b32 off, v0, s0 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, off, s1 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_endpgm
;
; GFX9-PAL-LABEL: store_load_sindex_small_offset_foo:
; GFX9-PAL:       ; %bb.0: ; %bb
; GFX9-PAL-NEXT:    s_getpc_b64 s[2:3]
; GFX9-PAL-NEXT:    s_mov_b32 s2, s0
; GFX9-PAL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX9-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-PAL-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX9-PAL-NEXT:    s_add_u32 flat_scratch_lo, s2, s1
; GFX9-PAL-NEXT:    s_addc_u32 flat_scratch_hi, s3, 0
; GFX9-PAL-NEXT:    s_mov_b32 s1, 0
; GFX9-PAL-NEXT:    scratch_load_dword v0, off, s1 glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_lshl_b32 s1, s0, 2
; GFX9-PAL-NEXT:    s_and_b32 s0, s0, 15
; GFX9-PAL-NEXT:    s_addk_i32 s1, 0x100
; GFX9-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX9-PAL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX9-PAL-NEXT:    scratch_store_dword off, v0, s1
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_addk_i32 s0, 0x100
; GFX9-PAL-NEXT:    scratch_load_dword v0, off, s0 glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_endpgm
;
; GFX942-LABEL: store_load_sindex_small_offset_foo:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    scratch_load_dword v0, off, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_lshl_b32 s1, s0, 2
; GFX942-NEXT:    s_and_b32 s0, s0, 15
; GFX942-NEXT:    s_addk_i32 s1, 0x100
; GFX942-NEXT:    v_mov_b32_e32 v0, 15
; GFX942-NEXT:    s_lshl_b32 s0, s0, 2
; GFX942-NEXT:    scratch_store_dword off, v0, s1 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_addk_i32 s0, 0x100
; GFX942-NEXT:    scratch_load_dword v0, off, s0 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_endpgm
;
; GFX1010-PAL-LABEL: store_load_sindex_small_offset_foo:
; GFX1010-PAL:       ; %bb.0: ; %bb
; GFX1010-PAL-NEXT:    s_getpc_b64 s[2:3]
; GFX1010-PAL-NEXT:    s_mov_b32 s2, s0
; GFX1010-PAL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX1010-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-PAL-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX1010-PAL-NEXT:    s_add_u32 s2, s2, s1
; GFX1010-PAL-NEXT:    s_addc_u32 s3, s3, 0
; GFX1010-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s2
; GFX1010-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s3
; GFX1010-PAL-NEXT:    s_mov_b32 s1, 0
; GFX1010-PAL-NEXT:    scratch_load_dword v0, off, s1 glc dlc
; GFX1010-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX1010-PAL-NEXT:    s_and_b32 s1, s0, 15
; GFX1010-PAL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX1010-PAL-NEXT:    s_lshl_b32 s1, s1, 2
; GFX1010-PAL-NEXT:    s_addk_i32 s0, 0x100
; GFX1010-PAL-NEXT:    s_addk_i32 s1, 0x100
; GFX1010-PAL-NEXT:    scratch_store_dword off, v0, s0
; GFX1010-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1010-PAL-NEXT:    scratch_load_dword v0, off, s1 glc dlc
; GFX1010-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-PAL-NEXT:    s_endpgm
;
; GFX1030-PAL-LABEL: store_load_sindex_small_offset_foo:
; GFX1030-PAL:       ; %bb.0: ; %bb
; GFX1030-PAL-NEXT:    s_getpc_b64 s[2:3]
; GFX1030-PAL-NEXT:    s_mov_b32 s2, s0
; GFX1030-PAL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX1030-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-PAL-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX1030-PAL-NEXT:    s_add_u32 s2, s2, s1
; GFX1030-PAL-NEXT:    s_addc_u32 s3, s3, 0
; GFX1030-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s2
; GFX1030-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s3
; GFX1030-PAL-NEXT:    scratch_load_dword v0, off, off glc dlc
; GFX1030-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX1030-PAL-NEXT:    s_and_b32 s1, s0, 15
; GFX1030-PAL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX1030-PAL-NEXT:    s_lshl_b32 s1, s1, 2
; GFX1030-PAL-NEXT:    s_addk_i32 s0, 0x100
; GFX1030-PAL-NEXT:    s_addk_i32 s1, 0x100
; GFX1030-PAL-NEXT:    scratch_store_dword off, v0, s0
; GFX1030-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1030-PAL-NEXT:    scratch_load_dword v0, off, s1 glc dlc
; GFX1030-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-PAL-NEXT:    s_endpgm
;
; GFX11-PAL-LABEL: store_load_sindex_small_offset_foo:
; GFX11-PAL:       ; %bb.0: ; %bb
; GFX11-PAL-NEXT:    scratch_load_b32 v0, off, off glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX11-PAL-NEXT:    s_and_b32 s1, s0, 15
; GFX11-PAL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-PAL-NEXT:    s_lshl_b32 s1, s1, 2
; GFX11-PAL-NEXT:    s_addk_i32 s0, 0x100
; GFX11-PAL-NEXT:    s_addk_i32 s1, 0x100
; GFX11-PAL-NEXT:    scratch_store_b32 off, v0, s0 dlc
; GFX11-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-PAL-NEXT:    scratch_load_b32 v0, off, s1 glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    s_endpgm
;
; GFX12-PAL-LABEL: store_load_sindex_small_offset_foo:
; GFX12-PAL:       ; %bb.0: ; %bb
; GFX12-PAL-NEXT:    scratch_load_b32 v0, off, off scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX12-PAL-NEXT:    s_and_b32 s1, s0, 15
; GFX12-PAL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX12-PAL-NEXT:    s_lshl_b32 s1, s1, 2
; GFX12-PAL-NEXT:    s_addk_co_i32 s0, 0x100
; GFX12-PAL-NEXT:    s_addk_co_i32 s1, 0x100
; GFX12-PAL-NEXT:    scratch_store_b32 off, v0, s0 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    scratch_load_b32 v0, off, s1 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    s_endpgm
bb:
  %padding = alloca [64 x i32], align 4, addrspace(5)
  %i = alloca [32 x float], align 4, addrspace(5)
  %pad_gep = getelementptr inbounds [64 x i32], ptr addrspace(5) %padding, i32 0, i32 0
  %pad_load = load volatile i32, ptr addrspace(5) %pad_gep, align 4
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %idx
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = and i32 %idx, 15
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define amdgpu_kernel void @store_load_vindex_small_offset_kernel(i32 %n) {
; GFX9-LABEL: store_load_vindex_small_offset_kernel:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s8, s13
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s9, 0
; GFX9-NEXT:    s_mov_b32 s1, 0
; GFX9-NEXT:    scratch_load_dword v1, off, s1 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b32 s0, s0, 7
; GFX9-NEXT:    v_add_u32_e32 v1, 0x100, v0
; GFX9-NEXT:    s_addk_i32 s0, 0x100
; GFX9-NEXT:    v_mov_b32_e32 v2, 15
; GFX9-NEXT:    scratch_store_dword v1, v2, off offset:128
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_sub_u32_e32 v0, s0, v0
; GFX9-NEXT:    scratch_load_dword v0, v0, off offset:124 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: store_load_vindex_small_offset_kernel:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s8, s8, s13
; GFX10-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s8
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s9
; GFX10-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    v_mov_b32_e32 v2, 15
; GFX10-NEXT:    scratch_load_dword v3, off, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_nc_u32_e32 v1, 0x100, v0
; GFX10-NEXT:    scratch_store_dword v1, v2, off offset:128
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_lshl_b32 s0, s0, 7
; GFX10-NEXT:    s_addk_i32 s0, 0x100
; GFX10-NEXT:    v_sub_nc_u32_e32 v0, s0, v0
; GFX10-NEXT:    scratch_load_dword v0, v0, off offset:124 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_load_vindex_small_offset_kernel:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-NEXT:    scratch_load_b32 v3, off, off glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    scratch_store_b32 v0, v1, off offset:384 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_lshl_b32 s0, s0, 7
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_addk_i32 s0, 0x100
; GFX11-NEXT:    v_sub_nc_u32_e32 v2, s0, v0
; GFX11-NEXT:    scratch_load_b32 v0, v2, off offset:124 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: store_load_vindex_small_offset_kernel:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-NEXT:    scratch_load_b32 v3, off, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    scratch_store_b32 v0, v1, off offset:384 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    s_lshl_b32 s0, s0, 7
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    s_addk_co_i32 s0, 0x100
; GFX12-NEXT:    v_sub_nc_u32_e32 v2, s0, v0
; GFX12-NEXT:    scratch_load_b32 v0, v2, off offset:124 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_endpgm
;
; GFX9-PAL-LABEL: store_load_vindex_small_offset_kernel:
; GFX9-PAL:       ; %bb.0: ; %bb
; GFX9-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX9-PAL-NEXT:    s_mov_b32 s12, s0
; GFX9-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX9-PAL-NEXT:    s_mov_b32 s1, 0
; GFX9-PAL-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX9-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-PAL-NEXT:    v_mov_b32_e32 v2, 15
; GFX9-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX9-PAL-NEXT:    s_add_u32 flat_scratch_lo, s12, s11
; GFX9-PAL-NEXT:    s_addc_u32 flat_scratch_hi, s13, 0
; GFX9-PAL-NEXT:    scratch_load_dword v1, off, s1 glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_lshl_b32 s0, s0, 7
; GFX9-PAL-NEXT:    v_add_u32_e32 v1, 0x100, v0
; GFX9-PAL-NEXT:    s_addk_i32 s0, 0x100
; GFX9-PAL-NEXT:    scratch_store_dword v1, v2, off offset:128
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    v_sub_u32_e32 v0, s0, v0
; GFX9-PAL-NEXT:    scratch_load_dword v0, v0, off offset:124 glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_endpgm
;
; GFX942-LABEL: store_load_vindex_small_offset_kernel:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX942-NEXT:    scratch_load_dword v1, off, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX942-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX942-NEXT:    v_mov_b32_e32 v1, 15
; GFX942-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-NEXT:    s_lshl_b32 s0, s0, 7
; GFX942-NEXT:    s_addk_i32 s0, 0x100
; GFX942-NEXT:    scratch_store_dword v0, v1, off offset:384 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    v_sub_u32_e32 v0, s0, v0
; GFX942-NEXT:    scratch_load_dword v0, v0, off offset:124 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_endpgm
;
; GFX1010-PAL-LABEL: store_load_vindex_small_offset_kernel:
; GFX1010-PAL:       ; %bb.0: ; %bb
; GFX1010-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX1010-PAL-NEXT:    s_mov_b32 s12, s0
; GFX1010-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX1010-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX1010-PAL-NEXT:    s_add_u32 s12, s12, s11
; GFX1010-PAL-NEXT:    s_addc_u32 s13, s13, 0
; GFX1010-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX1010-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX1010-PAL-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX1010-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v2, 15
; GFX1010-PAL-NEXT:    v_add_nc_u32_e32 v1, 0x100, v0
; GFX1010-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-PAL-NEXT:    s_lshl_b32 s0, s0, 7
; GFX1010-PAL-NEXT:    s_addk_i32 s0, 0x100
; GFX1010-PAL-NEXT:    v_sub_nc_u32_e32 v0, s0, v0
; GFX1010-PAL-NEXT:    s_mov_b32 s0, 0
; GFX1010-PAL-NEXT:    scratch_load_dword v3, off, s0 glc dlc
; GFX1010-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-PAL-NEXT:    scratch_store_dword v1, v2, off offset:128
; GFX1010-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1010-PAL-NEXT:    scratch_load_dword v0, v0, off offset:124 glc dlc
; GFX1010-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-PAL-NEXT:    s_endpgm
;
; GFX1030-PAL-LABEL: store_load_vindex_small_offset_kernel:
; GFX1030-PAL:       ; %bb.0: ; %bb
; GFX1030-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX1030-PAL-NEXT:    s_mov_b32 s12, s0
; GFX1030-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX1030-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX1030-PAL-NEXT:    s_add_u32 s12, s12, s11
; GFX1030-PAL-NEXT:    s_addc_u32 s13, s13, 0
; GFX1030-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX1030-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX1030-PAL-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX1030-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v2, 15
; GFX1030-PAL-NEXT:    scratch_load_dword v3, off, off glc dlc
; GFX1030-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-PAL-NEXT:    v_add_nc_u32_e32 v1, 0x100, v0
; GFX1030-PAL-NEXT:    scratch_store_dword v1, v2, off offset:128
; GFX1030-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1030-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-PAL-NEXT:    s_lshl_b32 s0, s0, 7
; GFX1030-PAL-NEXT:    s_addk_i32 s0, 0x100
; GFX1030-PAL-NEXT:    v_sub_nc_u32_e32 v0, s0, v0
; GFX1030-PAL-NEXT:    scratch_load_dword v0, v0, off offset:124 glc dlc
; GFX1030-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-PAL-NEXT:    s_endpgm
;
; GFX11-PAL-LABEL: store_load_vindex_small_offset_kernel:
; GFX11-PAL:       ; %bb.0: ; %bb
; GFX11-PAL-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-PAL-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-PAL-NEXT:    scratch_load_b32 v3, off, off glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-PAL-NEXT:    scratch_store_b32 v0, v1, off offset:384 dlc
; GFX11-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-PAL-NEXT:    s_lshl_b32 s0, s0, 7
; GFX11-PAL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-PAL-NEXT:    s_addk_i32 s0, 0x100
; GFX11-PAL-NEXT:    v_sub_nc_u32_e32 v2, s0, v0
; GFX11-PAL-NEXT:    scratch_load_b32 v0, v2, off offset:124 glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    s_endpgm
;
; GFX12-PAL-LABEL: store_load_vindex_small_offset_kernel:
; GFX12-PAL:       ; %bb.0: ; %bb
; GFX12-PAL-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-PAL-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-PAL-NEXT:    scratch_load_b32 v3, off, off scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-PAL-NEXT:    s_wait_kmcnt 0x0
; GFX12-PAL-NEXT:    scratch_store_b32 v0, v1, off offset:384 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    s_lshl_b32 s0, s0, 7
; GFX12-PAL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX12-PAL-NEXT:    s_addk_co_i32 s0, 0x100
; GFX12-PAL-NEXT:    v_sub_nc_u32_e32 v2, s0, v0
; GFX12-PAL-NEXT:    scratch_load_b32 v0, v2, off offset:124 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    s_endpgm
bb:
  %padding = alloca [64 x i32], align 4, addrspace(5)
  %i.alloca = alloca [2 x [32 x float]], align 4, addrspace(5)
  %i = getelementptr inbounds [2 x [32 x float]], ptr addrspace (5) %i.alloca, i32 0, i32 %n
  %i.1 = getelementptr inbounds [2 x [32 x float]], ptr addrspace (5) %i.alloca, i32 0, i32 1
  %pad_gep = getelementptr inbounds [64 x i32], ptr addrspace(5) %padding, i32 0, i32 0
  %pad_load = load volatile i32, ptr addrspace(5) %pad_gep, align 4
  %i2 = tail call i32 @llvm.amdgcn.workitem.id.x()
  %i3 = zext i32 %i2 to i64
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i.1, i32 0, i32 %i2
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = sub nsw i32 0, %i2
  %i9.1 = getelementptr [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i9.1, i32 0, i32 31
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define void @store_load_vindex_small_offset_foo(i32 %idx) {
; GFX9-LABEL: store_load_vindex_small_offset_foo:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    scratch_load_dword v1, off, s32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_add_i32 s0, s32, 0x100
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    v_lshl_add_u32 v2, v0, 2, v1
; GFX9-NEXT:    v_mov_b32_e32 v3, 15
; GFX9-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX9-NEXT:    scratch_store_dword v2, v3, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshl_add_u32 v0, v0, 2, v1
; GFX9-NEXT:    scratch_load_dword v0, v0, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: store_load_vindex_small_offset_foo:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v1, 15, v0
; GFX10-NEXT:    s_add_i32 s0, s32, 0x100
; GFX10-NEXT:    v_mov_b32_e32 v2, 15
; GFX10-NEXT:    v_lshl_add_u32 v0, v0, 2, s0
; GFX10-NEXT:    s_add_i32 s0, s32, 0x100
; GFX10-NEXT:    scratch_load_dword v3, off, s32 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshl_add_u32 v1, v1, 2, s0
; GFX10-NEXT:    scratch_store_dword v0, v2, off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, v1, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: store_load_vindex_small_offset_foo:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_and_b32 v1, 15, v0
; GFX11-NEXT:    s_add_i32 s0, s32, 0x100
; GFX11-NEXT:    scratch_load_b32 v3, off, s32 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshl_add_u32 v0, v0, 2, s0
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX11-NEXT:    scratch_store_b32 v0, v2, off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, v1, s32 offset:256 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: store_load_vindex_small_offset_foo:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_and_b32 v1, 15, v0
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-NEXT:    scratch_load_b32 v3, off, s32 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b32 v0, v2, s32 offset:256 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, v1, s32 offset:256 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-PAL-LABEL: store_load_vindex_small_offset_foo:
; GFX9-PAL:       ; %bb.0: ; %bb
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-PAL-NEXT:    scratch_load_dword v1, off, s32 glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_add_i32 s0, s32, 0x100
; GFX9-PAL-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-PAL-NEXT:    v_lshl_add_u32 v2, v0, 2, v1
; GFX9-PAL-NEXT:    v_mov_b32_e32 v3, 15
; GFX9-PAL-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX9-PAL-NEXT:    scratch_store_dword v2, v3, off
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    v_lshl_add_u32 v0, v0, 2, v1
; GFX9-PAL-NEXT:    scratch_load_dword v0, v0, off glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: store_load_vindex_small_offset_foo:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    scratch_load_dword v1, off, s32 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_add_i32 s0, s32, 0x100
; GFX942-NEXT:    v_mov_b32_e32 v1, s0
; GFX942-NEXT:    v_lshl_add_u32 v1, v0, 2, v1
; GFX942-NEXT:    v_mov_b32_e32 v2, 15
; GFX942-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX942-NEXT:    scratch_store_dword v1, v2, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX942-NEXT:    scratch_load_dword v0, v0, s32 offset:256 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-PAL-LABEL: store_load_vindex_small_offset_foo:
; GFX10-PAL:       ; %bb.0: ; %bb
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-PAL-NEXT:    v_and_b32_e32 v1, 15, v0
; GFX10-PAL-NEXT:    s_add_i32 s0, s32, 0x100
; GFX10-PAL-NEXT:    v_mov_b32_e32 v2, 15
; GFX10-PAL-NEXT:    v_lshl_add_u32 v0, v0, 2, s0
; GFX10-PAL-NEXT:    s_add_i32 s0, s32, 0x100
; GFX10-PAL-NEXT:    scratch_load_dword v3, off, s32 glc dlc
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-PAL-NEXT:    v_lshl_add_u32 v1, v1, 2, s0
; GFX10-PAL-NEXT:    scratch_store_dword v0, v2, off
; GFX10-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-PAL-NEXT:    scratch_load_dword v0, v1, off glc dlc
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-PAL-LABEL: store_load_vindex_small_offset_foo:
; GFX11-PAL:       ; %bb.0: ; %bb
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-PAL-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_and_b32 v1, 15, v0
; GFX11-PAL-NEXT:    s_add_i32 s0, s32, 0x100
; GFX11-PAL-NEXT:    scratch_load_b32 v3, off, s32 glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    v_lshl_add_u32 v0, v0, 2, s0
; GFX11-PAL-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX11-PAL-NEXT:    scratch_store_b32 v0, v2, off dlc
; GFX11-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-PAL-NEXT:    scratch_load_b32 v0, v1, s32 offset:256 glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-PAL-LABEL: store_load_vindex_small_offset_foo:
; GFX12-PAL:       ; %bb.0: ; %bb
; GFX12-PAL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-PAL-NEXT:    s_wait_expcnt 0x0
; GFX12-PAL-NEXT:    s_wait_samplecnt 0x0
; GFX12-PAL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-PAL-NEXT:    s_wait_kmcnt 0x0
; GFX12-PAL-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_and_b32 v1, 15, v0
; GFX12-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-PAL-NEXT:    scratch_load_b32 v3, off, s32 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    scratch_store_b32 v0, v2, s32 offset:256 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    scratch_load_b32 v0, v1, s32 offset:256 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    s_setpc_b64 s[30:31]
bb:
  %padding = alloca [64 x i32], align 4, addrspace(5)
  %i = alloca [32 x float], align 4, addrspace(5)
  %pad_gep = getelementptr inbounds [64 x i32], ptr addrspace(5) %padding, i32 0, i32 0
  %pad_load = load volatile i32, ptr addrspace(5) %pad_gep, align 4
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %idx
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = and i32 %idx, 15
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define amdgpu_kernel void @zero_init_large_offset_kernel() {
; GFX9-LABEL: zero_init_large_offset_kernel:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s8, s13
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s9, 0
; GFX9-NEXT:    s_mov_b32 s0, 0
; GFX9-NEXT:    scratch_load_dword v0, off, s0 offset:4 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_mov_b32 s1, s0
; GFX9-NEXT:    s_mov_b32 s2, s0
; GFX9-NEXT:    s_mov_b32 s3, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-NEXT:    s_movk_i32 s0, 0x4004
; GFX9-NEXT:    scratch_store_dwordx4 off, v[0:3], s0
; GFX9-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:16
; GFX9-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:32
; GFX9-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:48
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: zero_init_large_offset_kernel:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_add_u32 s8, s8, s13
; GFX10-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s8
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s9
; GFX10-NEXT:    scratch_load_dword v0, off, off offset:4 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_mov_b32 s0, 0
; GFX10-NEXT:    s_mov_b32 s1, s0
; GFX10-NEXT:    s_mov_b32 s2, s0
; GFX10-NEXT:    s_mov_b32 s3, s0
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    v_mov_b32_e32 v2, s2
; GFX10-NEXT:    v_mov_b32_e32 v3, s3
; GFX10-NEXT:    s_movk_i32 s0, 0x4004
; GFX10-NEXT:    scratch_store_dwordx4 off, v[0:3], s0
; GFX10-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:16
; GFX10-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:32
; GFX10-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:48
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: zero_init_large_offset_kernel:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    scratch_load_b32 v0, off, off offset:4 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_mov_b32 s1, s0
; GFX11-NEXT:    s_mov_b32 s2, s0
; GFX11-NEXT:    s_mov_b32 s3, s0
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_movk_i32 s0, 0x4004
; GFX11-NEXT:    s_clause 0x3
; GFX11-NEXT:    scratch_store_b128 off, v[0:3], s0
; GFX11-NEXT:    scratch_store_b128 off, v[0:3], s0 offset:16
; GFX11-NEXT:    scratch_store_b128 off, v[0:3], s0 offset:32
; GFX11-NEXT:    scratch_store_b128 off, v[0:3], s0 offset:48
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: zero_init_large_offset_kernel:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    scratch_load_b32 v0, off, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_mov_b32 s1, s0
; GFX12-NEXT:    s_mov_b32 s2, s0
; GFX12-NEXT:    s_mov_b32 s3, s0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    s_clause 0x3
; GFX12-NEXT:    scratch_store_b128 off, v[0:3], off offset:16384
; GFX12-NEXT:    scratch_store_b128 off, v[0:3], off offset:16400
; GFX12-NEXT:    scratch_store_b128 off, v[0:3], off offset:16416
; GFX12-NEXT:    scratch_store_b128 off, v[0:3], off offset:16432
; GFX12-NEXT:    s_endpgm
;
; GFX9-PAL-LABEL: zero_init_large_offset_kernel:
; GFX9-PAL:       ; %bb.0:
; GFX9-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX9-PAL-NEXT:    s_mov_b32 s12, s0
; GFX9-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX9-PAL-NEXT:    s_mov_b32 s0, 0
; GFX9-PAL-NEXT:    s_mov_b32 s1, s0
; GFX9-PAL-NEXT:    s_mov_b32 s2, s0
; GFX9-PAL-NEXT:    s_mov_b32 s3, s0
; GFX9-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX9-PAL-NEXT:    s_add_u32 flat_scratch_lo, s12, s11
; GFX9-PAL-NEXT:    s_addc_u32 flat_scratch_hi, s13, 0
; GFX9-PAL-NEXT:    scratch_load_dword v0, off, s0 offset:4 glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-PAL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-PAL-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-PAL-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-PAL-NEXT:    s_movk_i32 s0, 0x4004
; GFX9-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0
; GFX9-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:16
; GFX9-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:32
; GFX9-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:48
; GFX9-PAL-NEXT:    s_endpgm
;
; GFX942-LABEL: zero_init_large_offset_kernel:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    scratch_load_dword v0, off, off offset:4 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_mov_b32 s0, 0
; GFX942-NEXT:    s_mov_b32 s1, s0
; GFX942-NEXT:    s_mov_b32 s2, s0
; GFX942-NEXT:    s_mov_b32 s3, s0
; GFX942-NEXT:    v_mov_b64_e32 v[0:1], s[0:1]
; GFX942-NEXT:    v_mov_b64_e32 v[2:3], s[2:3]
; GFX942-NEXT:    s_movk_i32 s0, 0x4004
; GFX942-NEXT:    scratch_store_dwordx4 off, v[0:3], s0
; GFX942-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:16
; GFX942-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:32
; GFX942-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:48
; GFX942-NEXT:    s_endpgm
;
; GFX1010-PAL-LABEL: zero_init_large_offset_kernel:
; GFX1010-PAL:       ; %bb.0:
; GFX1010-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX1010-PAL-NEXT:    s_mov_b32 s12, s0
; GFX1010-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX1010-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX1010-PAL-NEXT:    s_add_u32 s12, s12, s11
; GFX1010-PAL-NEXT:    s_addc_u32 s13, s13, 0
; GFX1010-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX1010-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX1010-PAL-NEXT:    s_mov_b32 s0, 0
; GFX1010-PAL-NEXT:    scratch_load_dword v0, off, s0 offset:4 glc dlc
; GFX1010-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-PAL-NEXT:    s_mov_b32 s1, s0
; GFX1010-PAL-NEXT:    s_mov_b32 s2, s0
; GFX1010-PAL-NEXT:    s_mov_b32 s3, s0
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v0, s0
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v1, s1
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v2, s2
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v3, s3
; GFX1010-PAL-NEXT:    s_movk_i32 s0, 0x4004
; GFX1010-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0
; GFX1010-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:16
; GFX1010-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:32
; GFX1010-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:48
; GFX1010-PAL-NEXT:    s_endpgm
;
; GFX1030-PAL-LABEL: zero_init_large_offset_kernel:
; GFX1030-PAL:       ; %bb.0:
; GFX1030-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX1030-PAL-NEXT:    s_mov_b32 s12, s0
; GFX1030-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX1030-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX1030-PAL-NEXT:    s_add_u32 s12, s12, s11
; GFX1030-PAL-NEXT:    s_addc_u32 s13, s13, 0
; GFX1030-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX1030-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX1030-PAL-NEXT:    scratch_load_dword v0, off, off offset:4 glc dlc
; GFX1030-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-PAL-NEXT:    s_mov_b32 s0, 0
; GFX1030-PAL-NEXT:    s_mov_b32 s1, s0
; GFX1030-PAL-NEXT:    s_mov_b32 s2, s0
; GFX1030-PAL-NEXT:    s_mov_b32 s3, s0
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v0, s0
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v1, s1
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v2, s2
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v3, s3
; GFX1030-PAL-NEXT:    s_movk_i32 s0, 0x4004
; GFX1030-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0
; GFX1030-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:16
; GFX1030-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:32
; GFX1030-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:48
; GFX1030-PAL-NEXT:    s_endpgm
;
; GFX11-PAL-LABEL: zero_init_large_offset_kernel:
; GFX11-PAL:       ; %bb.0:
; GFX11-PAL-NEXT:    scratch_load_b32 v0, off, off offset:4 glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    s_mov_b32 s0, 0
; GFX11-PAL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-PAL-NEXT:    s_mov_b32 s1, s0
; GFX11-PAL-NEXT:    s_mov_b32 s2, s0
; GFX11-PAL-NEXT:    s_mov_b32 s3, s0
; GFX11-PAL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-PAL-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-PAL-NEXT:    s_movk_i32 s0, 0x4004
; GFX11-PAL-NEXT:    s_clause 0x3
; GFX11-PAL-NEXT:    scratch_store_b128 off, v[0:3], s0
; GFX11-PAL-NEXT:    scratch_store_b128 off, v[0:3], s0 offset:16
; GFX11-PAL-NEXT:    scratch_store_b128 off, v[0:3], s0 offset:32
; GFX11-PAL-NEXT:    scratch_store_b128 off, v[0:3], s0 offset:48
; GFX11-PAL-NEXT:    s_endpgm
;
; GFX12-PAL-LABEL: zero_init_large_offset_kernel:
; GFX12-PAL:       ; %bb.0:
; GFX12-PAL-NEXT:    scratch_load_b32 v0, off, off scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    s_mov_b32 s0, 0
; GFX12-PAL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-PAL-NEXT:    s_mov_b32 s1, s0
; GFX12-PAL-NEXT:    s_mov_b32 s2, s0
; GFX12-PAL-NEXT:    s_mov_b32 s3, s0
; GFX12-PAL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-PAL-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-PAL-NEXT:    s_clause 0x3
; GFX12-PAL-NEXT:    scratch_store_b128 off, v[0:3], off offset:16384
; GFX12-PAL-NEXT:    scratch_store_b128 off, v[0:3], off offset:16400
; GFX12-PAL-NEXT:    scratch_store_b128 off, v[0:3], off offset:16416
; GFX12-PAL-NEXT:    scratch_store_b128 off, v[0:3], off offset:16432
; GFX12-PAL-NEXT:    s_endpgm
  %padding = alloca [4096 x i32], align 4, addrspace(5)
  %alloca = alloca [32 x i16], align 2, addrspace(5)
  %pad_gep = getelementptr inbounds [4096 x i32], ptr addrspace(5) %padding, i32 0, i32 0
  %pad_load = load volatile i32, ptr addrspace(5) %pad_gep, align 4
  call void @llvm.memset.p5.i64(ptr addrspace(5) align 2 dereferenceable(64) %alloca, i8 0, i64 64, i1 false)
  ret void
}

define void @zero_init_large_offset_foo() {
; GFX9-LABEL: zero_init_large_offset_foo:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    scratch_load_dword v0, off, s32 offset:4 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_mov_b32 s0, 0
; GFX9-NEXT:    s_mov_b32 s1, s0
; GFX9-NEXT:    s_mov_b32 s2, s0
; GFX9-NEXT:    s_mov_b32 s3, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX9-NEXT:    scratch_store_dwordx4 off, v[0:3], s0
; GFX9-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX9-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:16
; GFX9-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX9-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:32
; GFX9-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX9-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:48
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: zero_init_large_offset_foo:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    scratch_load_dword v0, off, s32 offset:4 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_mov_b32 s0, 0
; GFX10-NEXT:    s_mov_b32 s1, s0
; GFX10-NEXT:    s_mov_b32 s2, s0
; GFX10-NEXT:    s_mov_b32 s3, s0
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    v_mov_b32_e32 v2, s2
; GFX10-NEXT:    v_mov_b32_e32 v3, s3
; GFX10-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX10-NEXT:    scratch_store_dwordx4 off, v[0:3], s0
; GFX10-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX10-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:16
; GFX10-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX10-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:32
; GFX10-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX10-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:48
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: zero_init_large_offset_foo:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    scratch_load_b32 v0, off, s32 offset:4 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_mov_b32 s1, s0
; GFX11-NEXT:    s_mov_b32 s2, s0
; GFX11-NEXT:    s_mov_b32 s3, s0
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX11-NEXT:    scratch_store_b128 off, v[0:3], s0
; GFX11-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX11-NEXT:    scratch_store_b128 off, v[0:3], s0 offset:16
; GFX11-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX11-NEXT:    scratch_store_b128 off, v[0:3], s0 offset:32
; GFX11-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX11-NEXT:    scratch_store_b128 off, v[0:3], s0 offset:48
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: zero_init_large_offset_foo:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, off, s32 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    s_mov_b32 s1, s0
; GFX12-NEXT:    s_mov_b32 s2, s0
; GFX12-NEXT:    s_mov_b32 s3, s0
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-NEXT:    s_clause 0x3
; GFX12-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:16384
; GFX12-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:16400
; GFX12-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:16416
; GFX12-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:16432
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-PAL-LABEL: zero_init_large_offset_foo:
; GFX9-PAL:       ; %bb.0:
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-PAL-NEXT:    scratch_load_dword v0, off, s32 offset:4 glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_mov_b32 s0, 0
; GFX9-PAL-NEXT:    s_mov_b32 s1, s0
; GFX9-PAL-NEXT:    s_mov_b32 s2, s0
; GFX9-PAL-NEXT:    s_mov_b32 s3, s0
; GFX9-PAL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-PAL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-PAL-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-PAL-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-PAL-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX9-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0
; GFX9-PAL-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX9-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:16
; GFX9-PAL-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX9-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:32
; GFX9-PAL-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX9-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:48
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: zero_init_large_offset_foo:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    scratch_load_dword v0, off, s32 offset:4 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_mov_b32 s0, 0
; GFX942-NEXT:    s_mov_b32 s1, s0
; GFX942-NEXT:    s_mov_b32 s2, s0
; GFX942-NEXT:    s_mov_b32 s3, s0
; GFX942-NEXT:    v_mov_b64_e32 v[0:1], s[0:1]
; GFX942-NEXT:    v_mov_b64_e32 v[2:3], s[2:3]
; GFX942-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX942-NEXT:    scratch_store_dwordx4 off, v[0:3], s0
; GFX942-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX942-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:16
; GFX942-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX942-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:32
; GFX942-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX942-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:48
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-PAL-LABEL: zero_init_large_offset_foo:
; GFX1010-PAL:       ; %bb.0:
; GFX1010-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-PAL-NEXT:    scratch_load_dword v0, off, s32 offset:4 glc dlc
; GFX1010-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-PAL-NEXT:    s_mov_b32 s0, 0
; GFX1010-PAL-NEXT:    s_mov_b32 s1, s0
; GFX1010-PAL-NEXT:    s_mov_b32 s2, s0
; GFX1010-PAL-NEXT:    s_mov_b32 s3, s0
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v0, s0
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v1, s1
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v2, s2
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v3, s3
; GFX1010-PAL-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX1010-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0
; GFX1010-PAL-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1010-PAL-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX1010-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:16
; GFX1010-PAL-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1010-PAL-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX1010-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:32
; GFX1010-PAL-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1010-PAL-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX1010-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:48
; GFX1010-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1030-PAL-LABEL: zero_init_large_offset_foo:
; GFX1030-PAL:       ; %bb.0:
; GFX1030-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1030-PAL-NEXT:    scratch_load_dword v0, off, s32 offset:4 glc dlc
; GFX1030-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-PAL-NEXT:    s_mov_b32 s0, 0
; GFX1030-PAL-NEXT:    s_mov_b32 s1, s0
; GFX1030-PAL-NEXT:    s_mov_b32 s2, s0
; GFX1030-PAL-NEXT:    s_mov_b32 s3, s0
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v0, s0
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v1, s1
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v2, s2
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v3, s3
; GFX1030-PAL-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX1030-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0
; GFX1030-PAL-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX1030-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:16
; GFX1030-PAL-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX1030-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:32
; GFX1030-PAL-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX1030-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:48
; GFX1030-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-PAL-LABEL: zero_init_large_offset_foo:
; GFX11-PAL:       ; %bb.0:
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-PAL-NEXT:    scratch_load_b32 v0, off, s32 offset:4 glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    s_mov_b32 s0, 0
; GFX11-PAL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-PAL-NEXT:    s_mov_b32 s1, s0
; GFX11-PAL-NEXT:    s_mov_b32 s2, s0
; GFX11-PAL-NEXT:    s_mov_b32 s3, s0
; GFX11-PAL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-PAL-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-PAL-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX11-PAL-NEXT:    scratch_store_b128 off, v[0:3], s0
; GFX11-PAL-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX11-PAL-NEXT:    scratch_store_b128 off, v[0:3], s0 offset:16
; GFX11-PAL-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX11-PAL-NEXT:    scratch_store_b128 off, v[0:3], s0 offset:32
; GFX11-PAL-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX11-PAL-NEXT:    scratch_store_b128 off, v[0:3], s0 offset:48
; GFX11-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-PAL-LABEL: zero_init_large_offset_foo:
; GFX12-PAL:       ; %bb.0:
; GFX12-PAL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-PAL-NEXT:    s_wait_expcnt 0x0
; GFX12-PAL-NEXT:    s_wait_samplecnt 0x0
; GFX12-PAL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-PAL-NEXT:    s_wait_kmcnt 0x0
; GFX12-PAL-NEXT:    scratch_load_b32 v0, off, s32 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    s_mov_b32 s0, 0
; GFX12-PAL-NEXT:    s_wait_alu 0xfffe
; GFX12-PAL-NEXT:    s_mov_b32 s1, s0
; GFX12-PAL-NEXT:    s_mov_b32 s2, s0
; GFX12-PAL-NEXT:    s_mov_b32 s3, s0
; GFX12-PAL-NEXT:    s_wait_alu 0xfffe
; GFX12-PAL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-PAL-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-PAL-NEXT:    s_clause 0x3
; GFX12-PAL-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:16384
; GFX12-PAL-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:16400
; GFX12-PAL-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:16416
; GFX12-PAL-NEXT:    scratch_store_b128 off, v[0:3], s32 offset:16432
; GFX12-PAL-NEXT:    s_setpc_b64 s[30:31]
  %padding = alloca [4096 x i32], align 4, addrspace(5)
  %alloca = alloca [32 x i16], align 2, addrspace(5)
  %pad_gep = getelementptr inbounds [4096 x i32], ptr addrspace(5) %padding, i32 0, i32 0
  %pad_load = load volatile i32, ptr addrspace(5) %pad_gep, align 4
  call void @llvm.memset.p5.i64(ptr addrspace(5) align 2 dereferenceable(64) %alloca, i8 0, i64 64, i1 false)
  ret void
}

define amdgpu_kernel void @store_load_sindex_large_offset_kernel(i32 %idx) {
; GFX9-LABEL: store_load_sindex_large_offset_kernel:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s8, s13
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s9, 0
; GFX9-NEXT:    s_mov_b32 s1, 0
; GFX9-NEXT:    scratch_load_dword v0, off, s1 offset:4 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b32 s1, s0, 2
; GFX9-NEXT:    s_and_b32 s0, s0, 15
; GFX9-NEXT:    v_mov_b32_e32 v0, 15
; GFX9-NEXT:    s_addk_i32 s1, 0x4004
; GFX9-NEXT:    s_lshl_b32 s0, s0, 2
; GFX9-NEXT:    scratch_store_dword off, v0, s1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_addk_i32 s0, 0x4004
; GFX9-NEXT:    scratch_load_dword v0, off, s0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: store_load_sindex_large_offset_kernel:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s8, s8, s13
; GFX10-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s8
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s9
; GFX10-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX10-NEXT:    scratch_load_dword v0, off, off offset:4 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, 15
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_and_b32 s1, s0, 15
; GFX10-NEXT:    s_lshl_b32 s0, s0, 2
; GFX10-NEXT:    s_lshl_b32 s1, s1, 2
; GFX10-NEXT:    s_addk_i32 s0, 0x4004
; GFX10-NEXT:    s_addk_i32 s1, 0x4004
; GFX10-NEXT:    scratch_store_dword off, v0, s0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, off, s1 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_load_sindex_large_offset_kernel:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-NEXT:    scratch_load_b32 v0, off, off offset:4 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v0, 15
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_and_b32 s1, s0, 15
; GFX11-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-NEXT:    s_lshl_b32 s1, s1, 2
; GFX11-NEXT:    s_addk_i32 s0, 0x4004
; GFX11-NEXT:    s_addk_i32 s1, 0x4004
; GFX11-NEXT:    scratch_store_b32 off, v0, s0 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, off, s1 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: store_load_sindex_large_offset_kernel:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-NEXT:    scratch_load_b32 v0, off, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, 15
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_and_b32 s1, s0, 15
; GFX12-NEXT:    s_lshl_b32 s0, s0, 2
; GFX12-NEXT:    s_lshl_b32 s1, s1, 2
; GFX12-NEXT:    s_addk_co_i32 s0, 0x4000
; GFX12-NEXT:    s_addk_co_i32 s1, 0x4000
; GFX12-NEXT:    scratch_store_b32 off, v0, s0 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, off, s1 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_endpgm
;
; GFX9-PAL-LABEL: store_load_sindex_large_offset_kernel:
; GFX9-PAL:       ; %bb.0: ; %bb
; GFX9-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX9-PAL-NEXT:    s_mov_b32 s12, s0
; GFX9-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX9-PAL-NEXT:    s_mov_b32 s1, 0
; GFX9-PAL-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX9-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX9-PAL-NEXT:    s_add_u32 flat_scratch_lo, s12, s11
; GFX9-PAL-NEXT:    s_addc_u32 flat_scratch_hi, s13, 0
; GFX9-PAL-NEXT:    scratch_load_dword v0, off, s1 offset:4 glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_lshl_b32 s1, s0, 2
; GFX9-PAL-NEXT:    s_and_b32 s0, s0, 15
; GFX9-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX9-PAL-NEXT:    s_addk_i32 s1, 0x4004
; GFX9-PAL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX9-PAL-NEXT:    scratch_store_dword off, v0, s1
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_addk_i32 s0, 0x4004
; GFX9-PAL-NEXT:    scratch_load_dword v0, off, s0 glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_endpgm
;
; GFX942-LABEL: store_load_sindex_large_offset_kernel:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX942-NEXT:    scratch_load_dword v0, off, off offset:4 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v0, 15
; GFX942-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-NEXT:    s_lshl_b32 s1, s0, 2
; GFX942-NEXT:    s_and_b32 s0, s0, 15
; GFX942-NEXT:    s_addk_i32 s1, 0x4004
; GFX942-NEXT:    s_lshl_b32 s0, s0, 2
; GFX942-NEXT:    scratch_store_dword off, v0, s1 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_addk_i32 s0, 0x4004
; GFX942-NEXT:    scratch_load_dword v0, off, s0 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_endpgm
;
; GFX1010-PAL-LABEL: store_load_sindex_large_offset_kernel:
; GFX1010-PAL:       ; %bb.0: ; %bb
; GFX1010-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX1010-PAL-NEXT:    s_mov_b32 s12, s0
; GFX1010-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX1010-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX1010-PAL-NEXT:    s_add_u32 s12, s12, s11
; GFX1010-PAL-NEXT:    s_addc_u32 s13, s13, 0
; GFX1010-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX1010-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX1010-PAL-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX1010-PAL-NEXT:    s_mov_b32 s1, 0
; GFX1010-PAL-NEXT:    scratch_load_dword v0, off, s1 offset:4 glc dlc
; GFX1010-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX1010-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-PAL-NEXT:    s_and_b32 s1, s0, 15
; GFX1010-PAL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX1010-PAL-NEXT:    s_lshl_b32 s1, s1, 2
; GFX1010-PAL-NEXT:    s_addk_i32 s0, 0x4004
; GFX1010-PAL-NEXT:    s_addk_i32 s1, 0x4004
; GFX1010-PAL-NEXT:    scratch_store_dword off, v0, s0
; GFX1010-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1010-PAL-NEXT:    scratch_load_dword v0, off, s1 glc dlc
; GFX1010-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-PAL-NEXT:    s_endpgm
;
; GFX1030-PAL-LABEL: store_load_sindex_large_offset_kernel:
; GFX1030-PAL:       ; %bb.0: ; %bb
; GFX1030-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX1030-PAL-NEXT:    s_mov_b32 s12, s0
; GFX1030-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX1030-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX1030-PAL-NEXT:    s_add_u32 s12, s12, s11
; GFX1030-PAL-NEXT:    s_addc_u32 s13, s13, 0
; GFX1030-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX1030-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX1030-PAL-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX1030-PAL-NEXT:    scratch_load_dword v0, off, off offset:4 glc dlc
; GFX1030-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX1030-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-PAL-NEXT:    s_and_b32 s1, s0, 15
; GFX1030-PAL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX1030-PAL-NEXT:    s_lshl_b32 s1, s1, 2
; GFX1030-PAL-NEXT:    s_addk_i32 s0, 0x4004
; GFX1030-PAL-NEXT:    s_addk_i32 s1, 0x4004
; GFX1030-PAL-NEXT:    scratch_store_dword off, v0, s0
; GFX1030-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1030-PAL-NEXT:    scratch_load_dword v0, off, s1 glc dlc
; GFX1030-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-PAL-NEXT:    s_endpgm
;
; GFX11-PAL-LABEL: store_load_sindex_large_offset_kernel:
; GFX11-PAL:       ; %bb.0: ; %bb
; GFX11-PAL-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-PAL-NEXT:    scratch_load_b32 v0, off, off offset:4 glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX11-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-PAL-NEXT:    s_and_b32 s1, s0, 15
; GFX11-PAL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-PAL-NEXT:    s_lshl_b32 s1, s1, 2
; GFX11-PAL-NEXT:    s_addk_i32 s0, 0x4004
; GFX11-PAL-NEXT:    s_addk_i32 s1, 0x4004
; GFX11-PAL-NEXT:    scratch_store_b32 off, v0, s0 dlc
; GFX11-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-PAL-NEXT:    scratch_load_b32 v0, off, s1 glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    s_endpgm
;
; GFX12-PAL-LABEL: store_load_sindex_large_offset_kernel:
; GFX12-PAL:       ; %bb.0: ; %bb
; GFX12-PAL-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-PAL-NEXT:    scratch_load_b32 v0, off, off scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX12-PAL-NEXT:    s_wait_kmcnt 0x0
; GFX12-PAL-NEXT:    s_and_b32 s1, s0, 15
; GFX12-PAL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX12-PAL-NEXT:    s_lshl_b32 s1, s1, 2
; GFX12-PAL-NEXT:    s_addk_co_i32 s0, 0x4000
; GFX12-PAL-NEXT:    s_addk_co_i32 s1, 0x4000
; GFX12-PAL-NEXT:    scratch_store_b32 off, v0, s0 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    scratch_load_b32 v0, off, s1 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    s_endpgm
bb:
  %padding = alloca [4096 x i32], align 4, addrspace(5)
  %i = alloca [32 x float], align 4, addrspace(5)
  %pad_gep = getelementptr inbounds [4096 x i32], ptr addrspace(5) %padding, i32 0, i32 0
  %pad_load = load volatile i32, ptr addrspace(5) %pad_gep, align 4
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %idx
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = and i32 %idx, 15
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define amdgpu_ps void @store_load_sindex_large_offset_foo(i32 inreg %idx) {
; GFX9-LABEL: store_load_sindex_large_offset_foo:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s0, s3
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; GFX9-NEXT:    s_mov_b32 s0, 0
; GFX9-NEXT:    scratch_load_dword v0, off, s0 offset:4 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_lshl_b32 s0, s2, 2
; GFX9-NEXT:    s_addk_i32 s0, 0x4004
; GFX9-NEXT:    v_mov_b32_e32 v0, 15
; GFX9-NEXT:    scratch_store_dword off, v0, s0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_and_b32 s0, s2, 15
; GFX9-NEXT:    s_lshl_b32 s0, s0, 2
; GFX9-NEXT:    s_addk_i32 s0, 0x4004
; GFX9-NEXT:    scratch_load_dword v0, off, s0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: store_load_sindex_large_offset_foo:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s0, s0, s3
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; GFX10-NEXT:    scratch_load_dword v0, off, off offset:4 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, 15
; GFX10-NEXT:    s_and_b32 s0, s2, 15
; GFX10-NEXT:    s_lshl_b32 s1, s2, 2
; GFX10-NEXT:    s_lshl_b32 s0, s0, 2
; GFX10-NEXT:    s_addk_i32 s1, 0x4004
; GFX10-NEXT:    s_addk_i32 s0, 0x4004
; GFX10-NEXT:    scratch_store_dword off, v0, s1
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, off, s0 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_load_sindex_large_offset_foo:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    scratch_load_b32 v0, off, off offset:4 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v0, 15
; GFX11-NEXT:    s_and_b32 s1, s0, 15
; GFX11-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-NEXT:    s_lshl_b32 s1, s1, 2
; GFX11-NEXT:    s_addk_i32 s0, 0x4004
; GFX11-NEXT:    s_addk_i32 s1, 0x4004
; GFX11-NEXT:    scratch_store_b32 off, v0, s0 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, off, s1 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: store_load_sindex_large_offset_foo:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    scratch_load_b32 v0, off, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, 15
; GFX12-NEXT:    s_and_b32 s1, s0, 15
; GFX12-NEXT:    s_lshl_b32 s0, s0, 2
; GFX12-NEXT:    s_lshl_b32 s1, s1, 2
; GFX12-NEXT:    s_addk_co_i32 s0, 0x4000
; GFX12-NEXT:    s_addk_co_i32 s1, 0x4000
; GFX12-NEXT:    scratch_store_b32 off, v0, s0 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, off, s1 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_endpgm
;
; GFX9-PAL-LABEL: store_load_sindex_large_offset_foo:
; GFX9-PAL:       ; %bb.0: ; %bb
; GFX9-PAL-NEXT:    s_getpc_b64 s[2:3]
; GFX9-PAL-NEXT:    s_mov_b32 s2, s0
; GFX9-PAL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX9-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-PAL-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX9-PAL-NEXT:    s_add_u32 flat_scratch_lo, s2, s1
; GFX9-PAL-NEXT:    s_addc_u32 flat_scratch_hi, s3, 0
; GFX9-PAL-NEXT:    s_mov_b32 s1, 0
; GFX9-PAL-NEXT:    scratch_load_dword v0, off, s1 offset:4 glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_lshl_b32 s1, s0, 2
; GFX9-PAL-NEXT:    s_and_b32 s0, s0, 15
; GFX9-PAL-NEXT:    s_addk_i32 s1, 0x4004
; GFX9-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX9-PAL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX9-PAL-NEXT:    scratch_store_dword off, v0, s1
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_addk_i32 s0, 0x4004
; GFX9-PAL-NEXT:    scratch_load_dword v0, off, s0 glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_endpgm
;
; GFX942-LABEL: store_load_sindex_large_offset_foo:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    scratch_load_dword v0, off, off offset:4 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_lshl_b32 s1, s0, 2
; GFX942-NEXT:    s_and_b32 s0, s0, 15
; GFX942-NEXT:    s_addk_i32 s1, 0x4004
; GFX942-NEXT:    v_mov_b32_e32 v0, 15
; GFX942-NEXT:    s_lshl_b32 s0, s0, 2
; GFX942-NEXT:    scratch_store_dword off, v0, s1 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_addk_i32 s0, 0x4004
; GFX942-NEXT:    scratch_load_dword v0, off, s0 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_endpgm
;
; GFX1010-PAL-LABEL: store_load_sindex_large_offset_foo:
; GFX1010-PAL:       ; %bb.0: ; %bb
; GFX1010-PAL-NEXT:    s_getpc_b64 s[2:3]
; GFX1010-PAL-NEXT:    s_mov_b32 s2, s0
; GFX1010-PAL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX1010-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-PAL-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX1010-PAL-NEXT:    s_add_u32 s2, s2, s1
; GFX1010-PAL-NEXT:    s_addc_u32 s3, s3, 0
; GFX1010-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s2
; GFX1010-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s3
; GFX1010-PAL-NEXT:    s_mov_b32 s1, 0
; GFX1010-PAL-NEXT:    scratch_load_dword v0, off, s1 offset:4 glc dlc
; GFX1010-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX1010-PAL-NEXT:    s_and_b32 s1, s0, 15
; GFX1010-PAL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX1010-PAL-NEXT:    s_lshl_b32 s1, s1, 2
; GFX1010-PAL-NEXT:    s_addk_i32 s0, 0x4004
; GFX1010-PAL-NEXT:    s_addk_i32 s1, 0x4004
; GFX1010-PAL-NEXT:    scratch_store_dword off, v0, s0
; GFX1010-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1010-PAL-NEXT:    scratch_load_dword v0, off, s1 glc dlc
; GFX1010-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-PAL-NEXT:    s_endpgm
;
; GFX1030-PAL-LABEL: store_load_sindex_large_offset_foo:
; GFX1030-PAL:       ; %bb.0: ; %bb
; GFX1030-PAL-NEXT:    s_getpc_b64 s[2:3]
; GFX1030-PAL-NEXT:    s_mov_b32 s2, s0
; GFX1030-PAL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX1030-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-PAL-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX1030-PAL-NEXT:    s_add_u32 s2, s2, s1
; GFX1030-PAL-NEXT:    s_addc_u32 s3, s3, 0
; GFX1030-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s2
; GFX1030-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s3
; GFX1030-PAL-NEXT:    scratch_load_dword v0, off, off offset:4 glc dlc
; GFX1030-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX1030-PAL-NEXT:    s_and_b32 s1, s0, 15
; GFX1030-PAL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX1030-PAL-NEXT:    s_lshl_b32 s1, s1, 2
; GFX1030-PAL-NEXT:    s_addk_i32 s0, 0x4004
; GFX1030-PAL-NEXT:    s_addk_i32 s1, 0x4004
; GFX1030-PAL-NEXT:    scratch_store_dword off, v0, s0
; GFX1030-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1030-PAL-NEXT:    scratch_load_dword v0, off, s1 glc dlc
; GFX1030-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-PAL-NEXT:    s_endpgm
;
; GFX11-PAL-LABEL: store_load_sindex_large_offset_foo:
; GFX11-PAL:       ; %bb.0: ; %bb
; GFX11-PAL-NEXT:    scratch_load_b32 v0, off, off offset:4 glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX11-PAL-NEXT:    s_and_b32 s1, s0, 15
; GFX11-PAL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-PAL-NEXT:    s_lshl_b32 s1, s1, 2
; GFX11-PAL-NEXT:    s_addk_i32 s0, 0x4004
; GFX11-PAL-NEXT:    s_addk_i32 s1, 0x4004
; GFX11-PAL-NEXT:    scratch_store_b32 off, v0, s0 dlc
; GFX11-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-PAL-NEXT:    scratch_load_b32 v0, off, s1 glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    s_endpgm
;
; GFX12-PAL-LABEL: store_load_sindex_large_offset_foo:
; GFX12-PAL:       ; %bb.0: ; %bb
; GFX12-PAL-NEXT:    scratch_load_b32 v0, off, off scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX12-PAL-NEXT:    s_and_b32 s1, s0, 15
; GFX12-PAL-NEXT:    s_lshl_b32 s0, s0, 2
; GFX12-PAL-NEXT:    s_lshl_b32 s1, s1, 2
; GFX12-PAL-NEXT:    s_addk_co_i32 s0, 0x4000
; GFX12-PAL-NEXT:    s_addk_co_i32 s1, 0x4000
; GFX12-PAL-NEXT:    scratch_store_b32 off, v0, s0 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    scratch_load_b32 v0, off, s1 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    s_endpgm
bb:
  %padding = alloca [4096 x i32], align 4, addrspace(5)
  %i = alloca [32 x float], align 4, addrspace(5)
  %pad_gep = getelementptr inbounds [4096 x i32], ptr addrspace(5) %padding, i32 0, i32 0
  %pad_load = load volatile i32, ptr addrspace(5) %pad_gep, align 4
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %idx
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = and i32 %idx, 15
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define amdgpu_kernel void @store_load_vindex_large_offset_kernel(i32 %n) {
; GFX9-LABEL: store_load_vindex_large_offset_kernel:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s8, s13
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s9, 0
; GFX9-NEXT:    s_mov_b32 s1, 0
; GFX9-NEXT:    scratch_load_dword v1, off, s1 offset:4 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b32 s0, s0, 7
; GFX9-NEXT:    v_add_u32_e32 v1, 0x4004, v0
; GFX9-NEXT:    s_addk_i32 s0, 0x4004
; GFX9-NEXT:    v_mov_b32_e32 v2, 15
; GFX9-NEXT:    scratch_store_dword v1, v2, off offset:128
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_sub_u32_e32 v0, s0, v0
; GFX9-NEXT:    scratch_load_dword v0, v0, off offset:124 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: store_load_vindex_large_offset_kernel:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s8, s8, s13
; GFX10-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s8
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s9
; GFX10-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    v_mov_b32_e32 v2, 15
; GFX10-NEXT:    scratch_load_dword v3, off, off offset:4 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_nc_u32_e32 v1, 0x4004, v0
; GFX10-NEXT:    scratch_store_dword v1, v2, off offset:128
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_lshl_b32 s0, s0, 7
; GFX10-NEXT:    s_addk_i32 s0, 0x4004
; GFX10-NEXT:    v_sub_nc_u32_e32 v0, s0, v0
; GFX10-NEXT:    scratch_load_dword v0, v0, off offset:124 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_load_vindex_large_offset_kernel:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-NEXT:    scratch_load_b32 v3, off, off offset:4 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_lshl_b32 s0, s0, 7
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_addk_i32 s0, 0x4004
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    v_sub_nc_u32_e32 v2, s0, v0
; GFX11-NEXT:    s_movk_i32 s0, 0x4004
; GFX11-NEXT:    scratch_store_b32 v0, v1, s0 offset:128 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, v2, off offset:124 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: store_load_vindex_large_offset_kernel:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-NEXT:    scratch_load_b32 v3, off, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    scratch_store_b32 v0, v1, off offset:16512 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    s_lshl_b32 s0, s0, 7
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    s_addk_co_i32 s0, 0x4000
; GFX12-NEXT:    v_sub_nc_u32_e32 v2, s0, v0
; GFX12-NEXT:    scratch_load_b32 v0, v2, off offset:124 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_endpgm
;
; GFX9-PAL-LABEL: store_load_vindex_large_offset_kernel:
; GFX9-PAL:       ; %bb.0: ; %bb
; GFX9-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX9-PAL-NEXT:    s_mov_b32 s12, s0
; GFX9-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX9-PAL-NEXT:    s_mov_b32 s1, 0
; GFX9-PAL-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX9-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-PAL-NEXT:    v_mov_b32_e32 v2, 15
; GFX9-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX9-PAL-NEXT:    s_add_u32 flat_scratch_lo, s12, s11
; GFX9-PAL-NEXT:    s_addc_u32 flat_scratch_hi, s13, 0
; GFX9-PAL-NEXT:    scratch_load_dword v1, off, s1 offset:4 glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_lshl_b32 s0, s0, 7
; GFX9-PAL-NEXT:    v_add_u32_e32 v1, 0x4004, v0
; GFX9-PAL-NEXT:    s_addk_i32 s0, 0x4004
; GFX9-PAL-NEXT:    scratch_store_dword v1, v2, off offset:128
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    v_sub_u32_e32 v0, s0, v0
; GFX9-PAL-NEXT:    scratch_load_dword v0, v0, off offset:124 glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_endpgm
;
; GFX942-LABEL: store_load_vindex_large_offset_kernel:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX942-NEXT:    scratch_load_dword v1, off, off offset:4 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX942-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX942-NEXT:    v_mov_b32_e32 v1, 15
; GFX942-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-NEXT:    s_lshl_b32 s0, s0, 7
; GFX942-NEXT:    s_addk_i32 s0, 0x4004
; GFX942-NEXT:    s_movk_i32 s1, 0x4004
; GFX942-NEXT:    scratch_store_dword v0, v1, s1 offset:128 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    v_sub_u32_e32 v0, s0, v0
; GFX942-NEXT:    scratch_load_dword v0, v0, off offset:124 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_endpgm
;
; GFX1010-PAL-LABEL: store_load_vindex_large_offset_kernel:
; GFX1010-PAL:       ; %bb.0: ; %bb
; GFX1010-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX1010-PAL-NEXT:    s_mov_b32 s12, s0
; GFX1010-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX1010-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX1010-PAL-NEXT:    s_add_u32 s12, s12, s11
; GFX1010-PAL-NEXT:    s_addc_u32 s13, s13, 0
; GFX1010-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX1010-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX1010-PAL-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX1010-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v2, 15
; GFX1010-PAL-NEXT:    v_add_nc_u32_e32 v1, 0x4004, v0
; GFX1010-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-PAL-NEXT:    s_lshl_b32 s0, s0, 7
; GFX1010-PAL-NEXT:    s_addk_i32 s0, 0x4004
; GFX1010-PAL-NEXT:    v_sub_nc_u32_e32 v0, s0, v0
; GFX1010-PAL-NEXT:    s_mov_b32 s0, 0
; GFX1010-PAL-NEXT:    scratch_load_dword v3, off, s0 offset:4 glc dlc
; GFX1010-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-PAL-NEXT:    scratch_store_dword v1, v2, off offset:128
; GFX1010-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1010-PAL-NEXT:    scratch_load_dword v0, v0, off offset:124 glc dlc
; GFX1010-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-PAL-NEXT:    s_endpgm
;
; GFX1030-PAL-LABEL: store_load_vindex_large_offset_kernel:
; GFX1030-PAL:       ; %bb.0: ; %bb
; GFX1030-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX1030-PAL-NEXT:    s_mov_b32 s12, s0
; GFX1030-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX1030-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX1030-PAL-NEXT:    s_add_u32 s12, s12, s11
; GFX1030-PAL-NEXT:    s_addc_u32 s13, s13, 0
; GFX1030-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX1030-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX1030-PAL-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX1030-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v2, 15
; GFX1030-PAL-NEXT:    scratch_load_dword v3, off, off offset:4 glc dlc
; GFX1030-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-PAL-NEXT:    v_add_nc_u32_e32 v1, 0x4004, v0
; GFX1030-PAL-NEXT:    scratch_store_dword v1, v2, off offset:128
; GFX1030-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1030-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-PAL-NEXT:    s_lshl_b32 s0, s0, 7
; GFX1030-PAL-NEXT:    s_addk_i32 s0, 0x4004
; GFX1030-PAL-NEXT:    v_sub_nc_u32_e32 v0, s0, v0
; GFX1030-PAL-NEXT:    scratch_load_dword v0, v0, off offset:124 glc dlc
; GFX1030-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-PAL-NEXT:    s_endpgm
;
; GFX11-PAL-LABEL: store_load_vindex_large_offset_kernel:
; GFX11-PAL:       ; %bb.0: ; %bb
; GFX11-PAL-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-PAL-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-PAL-NEXT:    scratch_load_b32 v3, off, off offset:4 glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-PAL-NEXT:    s_lshl_b32 s0, s0, 7
; GFX11-PAL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-PAL-NEXT:    s_addk_i32 s0, 0x4004
; GFX11-PAL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-PAL-NEXT:    v_sub_nc_u32_e32 v2, s0, v0
; GFX11-PAL-NEXT:    s_movk_i32 s0, 0x4004
; GFX11-PAL-NEXT:    scratch_store_b32 v0, v1, s0 offset:128 dlc
; GFX11-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-PAL-NEXT:    scratch_load_b32 v0, v2, off offset:124 glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    s_endpgm
;
; GFX12-PAL-LABEL: store_load_vindex_large_offset_kernel:
; GFX12-PAL:       ; %bb.0: ; %bb
; GFX12-PAL-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-PAL-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-PAL-NEXT:    scratch_load_b32 v3, off, off scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-PAL-NEXT:    s_wait_kmcnt 0x0
; GFX12-PAL-NEXT:    scratch_store_b32 v0, v1, off offset:16512 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    s_lshl_b32 s0, s0, 7
; GFX12-PAL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX12-PAL-NEXT:    s_addk_co_i32 s0, 0x4000
; GFX12-PAL-NEXT:    v_sub_nc_u32_e32 v2, s0, v0
; GFX12-PAL-NEXT:    scratch_load_b32 v0, v2, off offset:124 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    s_endpgm
bb:
  %padding = alloca [4096 x i32], align 4, addrspace(5)
  %i.alloca = alloca [2 x [32 x float]], align 4, addrspace(5)
  %i = getelementptr inbounds [2 x [32 x float]], ptr addrspace (5) %i.alloca, i32 0, i32 %n
  %i.1 = getelementptr inbounds [2 x [32 x float]], ptr addrspace (5) %i.alloca, i32 0, i32 1
  %pad_gep = getelementptr inbounds [4096 x i32], ptr addrspace(5) %padding, i32 0, i32 0
  %pad_load = load volatile i32, ptr addrspace(5) %pad_gep, align 4
  %i2 = tail call i32 @llvm.amdgcn.workitem.id.x()
  %i3 = zext i32 %i2 to i64
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i.1, i32 0, i32 %i2
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = sub nsw i32 0, %i2
  %i9.1 = getelementptr [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i9.1, i32 0, i32 31
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define void @store_load_vindex_large_offset_foo(i32 %idx) {
; GFX9-LABEL: store_load_vindex_large_offset_foo:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    scratch_load_dword v1, off, s32 offset:4 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    v_lshl_add_u32 v2, v0, 2, v1
; GFX9-NEXT:    v_mov_b32_e32 v3, 15
; GFX9-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX9-NEXT:    scratch_store_dword v2, v3, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshl_add_u32 v0, v0, 2, v1
; GFX9-NEXT:    scratch_load_dword v0, v0, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: store_load_vindex_large_offset_foo:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v1, 15, v0
; GFX10-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX10-NEXT:    v_mov_b32_e32 v2, 15
; GFX10-NEXT:    v_lshl_add_u32 v0, v0, 2, s0
; GFX10-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX10-NEXT:    scratch_load_dword v3, off, s32 offset:4 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshl_add_u32 v1, v1, 2, s0
; GFX10-NEXT:    scratch_store_dword v0, v2, off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, v1, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: store_load_vindex_large_offset_foo:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_and_b32 v1, 15, v0
; GFX11-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX11-NEXT:    scratch_load_b32 v3, off, s32 offset:4 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshl_add_u32 v0, v0, 2, s0
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX11-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX11-NEXT:    scratch_store_b32 v0, v2, off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, v1, s0 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: store_load_vindex_large_offset_foo:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_and_b32 v1, 15, v0
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-NEXT:    scratch_load_b32 v3, off, s32 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b32 v0, v2, s32 offset:16384 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, v1, s32 offset:16384 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-PAL-LABEL: store_load_vindex_large_offset_foo:
; GFX9-PAL:       ; %bb.0: ; %bb
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-PAL-NEXT:    scratch_load_dword v1, off, s32 offset:4 glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX9-PAL-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-PAL-NEXT:    v_lshl_add_u32 v2, v0, 2, v1
; GFX9-PAL-NEXT:    v_mov_b32_e32 v3, 15
; GFX9-PAL-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX9-PAL-NEXT:    scratch_store_dword v2, v3, off
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    v_lshl_add_u32 v0, v0, 2, v1
; GFX9-PAL-NEXT:    scratch_load_dword v0, v0, off glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: store_load_vindex_large_offset_foo:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    scratch_load_dword v1, off, s32 offset:4 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX942-NEXT:    v_mov_b32_e32 v1, s0
; GFX942-NEXT:    v_lshl_add_u32 v1, v0, 2, v1
; GFX942-NEXT:    v_mov_b32_e32 v2, 15
; GFX942-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX942-NEXT:    scratch_store_dword v1, v2, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX942-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX942-NEXT:    scratch_load_dword v0, v0, s0 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-PAL-LABEL: store_load_vindex_large_offset_foo:
; GFX10-PAL:       ; %bb.0: ; %bb
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-PAL-NEXT:    v_and_b32_e32 v1, 15, v0
; GFX10-PAL-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX10-PAL-NEXT:    v_mov_b32_e32 v2, 15
; GFX10-PAL-NEXT:    v_lshl_add_u32 v0, v0, 2, s0
; GFX10-PAL-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX10-PAL-NEXT:    scratch_load_dword v3, off, s32 offset:4 glc dlc
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-PAL-NEXT:    v_lshl_add_u32 v1, v1, 2, s0
; GFX10-PAL-NEXT:    scratch_store_dword v0, v2, off
; GFX10-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-PAL-NEXT:    scratch_load_dword v0, v1, off glc dlc
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-PAL-LABEL: store_load_vindex_large_offset_foo:
; GFX11-PAL:       ; %bb.0: ; %bb
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-PAL-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_and_b32 v1, 15, v0
; GFX11-PAL-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX11-PAL-NEXT:    scratch_load_b32 v3, off, s32 offset:4 glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    v_lshl_add_u32 v0, v0, 2, s0
; GFX11-PAL-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX11-PAL-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX11-PAL-NEXT:    scratch_store_b32 v0, v2, off dlc
; GFX11-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-PAL-NEXT:    scratch_load_b32 v0, v1, s0 glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-PAL-LABEL: store_load_vindex_large_offset_foo:
; GFX12-PAL:       ; %bb.0: ; %bb
; GFX12-PAL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-PAL-NEXT:    s_wait_expcnt 0x0
; GFX12-PAL-NEXT:    s_wait_samplecnt 0x0
; GFX12-PAL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-PAL-NEXT:    s_wait_kmcnt 0x0
; GFX12-PAL-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_and_b32 v1, 15, v0
; GFX12-PAL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-PAL-NEXT:    scratch_load_b32 v3, off, s32 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    scratch_store_b32 v0, v2, s32 offset:16384 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    scratch_load_b32 v0, v1, s32 offset:16384 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    s_setpc_b64 s[30:31]
bb:
  %padding = alloca [4096 x i32], align 4, addrspace(5)
  %i = alloca [32 x float], align 4, addrspace(5)
  %pad_gep = getelementptr inbounds [4096 x i32], ptr addrspace(5) %padding, i32 0, i32 0
  %pad_load = load volatile i32, ptr addrspace(5) %pad_gep, align 4
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %idx
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = and i32 %idx, 15
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define amdgpu_kernel void @store_load_large_imm_offset_kernel() {
; GFX9-LABEL: store_load_large_imm_offset_kernel:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s8, s13
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s9, 0
; GFX9-NEXT:    v_mov_b32_e32 v0, 13
; GFX9-NEXT:    s_mov_b32 s0, 0
; GFX9-NEXT:    scratch_store_dword off, v0, s0 offset:4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_movk_i32 s0, 0x3004
; GFX9-NEXT:    v_mov_b32_e32 v0, 15
; GFX9-NEXT:    scratch_store_dword off, v0, s0 offset:3712
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    scratch_load_dword v0, off, s0 offset:3712 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: store_load_large_imm_offset_kernel:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s8, s8, s13
; GFX10-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s8
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s9
; GFX10-NEXT:    v_mov_b32_e32 v0, 13
; GFX10-NEXT:    v_mov_b32_e32 v1, 15
; GFX10-NEXT:    s_movk_i32 s0, 0x3804
; GFX10-NEXT:    scratch_store_dword off, v0, off offset:4
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_store_dword off, v1, s0 offset:1664
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, off, s0 offset:1664 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_load_large_imm_offset_kernel:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    v_dual_mov_b32 v0, 13 :: v_dual_mov_b32 v1, 0x3000
; GFX11-NEXT:    v_mov_b32_e32 v2, 15
; GFX11-NEXT:    scratch_store_b32 off, v0, off offset:4 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_store_b32 v1, v2, off offset:3716 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, v1, off offset:3716 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: store_load_large_imm_offset_kernel:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    v_dual_mov_b32 v0, 13 :: v_dual_mov_b32 v1, 15
; GFX12-NEXT:    scratch_store_b32 off, v0, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b32 off, v1, off offset:16000 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, off, off offset:16000 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_endpgm
;
; GFX9-PAL-LABEL: store_load_large_imm_offset_kernel:
; GFX9-PAL:       ; %bb.0: ; %bb
; GFX9-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX9-PAL-NEXT:    s_mov_b32 s12, s0
; GFX9-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX9-PAL-NEXT:    v_mov_b32_e32 v0, 13
; GFX9-PAL-NEXT:    s_mov_b32 s0, 0
; GFX9-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX9-PAL-NEXT:    s_add_u32 flat_scratch_lo, s12, s11
; GFX9-PAL-NEXT:    s_addc_u32 flat_scratch_hi, s13, 0
; GFX9-PAL-NEXT:    scratch_store_dword off, v0, s0 offset:4
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_movk_i32 s0, 0x3004
; GFX9-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX9-PAL-NEXT:    scratch_store_dword off, v0, s0 offset:3712
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    scratch_load_dword v0, off, s0 offset:3712 glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_endpgm
;
; GFX942-LABEL: store_load_large_imm_offset_kernel:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    v_mov_b32_e32 v0, 13
; GFX942-NEXT:    scratch_store_dword off, v0, off offset:4 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v0, 0x3000
; GFX942-NEXT:    v_mov_b32_e32 v1, 15
; GFX942-NEXT:    scratch_store_dword v0, v1, off offset:3716 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    scratch_load_dword v0, v0, off offset:3716 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_endpgm
;
; GFX1010-PAL-LABEL: store_load_large_imm_offset_kernel:
; GFX1010-PAL:       ; %bb.0: ; %bb
; GFX1010-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX1010-PAL-NEXT:    s_mov_b32 s12, s0
; GFX1010-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX1010-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX1010-PAL-NEXT:    s_add_u32 s12, s12, s11
; GFX1010-PAL-NEXT:    s_addc_u32 s13, s13, 0
; GFX1010-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX1010-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v0, 13
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v1, 15
; GFX1010-PAL-NEXT:    s_mov_b32 s1, 0
; GFX1010-PAL-NEXT:    s_movk_i32 s0, 0x3804
; GFX1010-PAL-NEXT:    scratch_store_dword off, v0, s1 offset:4
; GFX1010-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1010-PAL-NEXT:    scratch_store_dword off, v1, s0 offset:1664
; GFX1010-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1010-PAL-NEXT:    scratch_load_dword v0, off, s0 offset:1664 glc dlc
; GFX1010-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-PAL-NEXT:    s_endpgm
;
; GFX1030-PAL-LABEL: store_load_large_imm_offset_kernel:
; GFX1030-PAL:       ; %bb.0: ; %bb
; GFX1030-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX1030-PAL-NEXT:    s_mov_b32 s12, s0
; GFX1030-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX1030-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX1030-PAL-NEXT:    s_add_u32 s12, s12, s11
; GFX1030-PAL-NEXT:    s_addc_u32 s13, s13, 0
; GFX1030-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX1030-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v0, 13
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v1, 15
; GFX1030-PAL-NEXT:    s_movk_i32 s0, 0x3804
; GFX1030-PAL-NEXT:    scratch_store_dword off, v0, off offset:4
; GFX1030-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1030-PAL-NEXT:    scratch_store_dword off, v1, s0 offset:1664
; GFX1030-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1030-PAL-NEXT:    scratch_load_dword v0, off, s0 offset:1664 glc dlc
; GFX1030-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-PAL-NEXT:    s_endpgm
;
; GFX11-PAL-LABEL: store_load_large_imm_offset_kernel:
; GFX11-PAL:       ; %bb.0: ; %bb
; GFX11-PAL-NEXT:    v_dual_mov_b32 v0, 13 :: v_dual_mov_b32 v1, 0x3000
; GFX11-PAL-NEXT:    v_mov_b32_e32 v2, 15
; GFX11-PAL-NEXT:    scratch_store_b32 off, v0, off offset:4 dlc
; GFX11-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-PAL-NEXT:    scratch_store_b32 v1, v2, off offset:3716 dlc
; GFX11-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-PAL-NEXT:    scratch_load_b32 v0, v1, off offset:3716 glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    s_endpgm
;
; GFX12-PAL-LABEL: store_load_large_imm_offset_kernel:
; GFX12-PAL:       ; %bb.0: ; %bb
; GFX12-PAL-NEXT:    v_dual_mov_b32 v0, 13 :: v_dual_mov_b32 v1, 15
; GFX12-PAL-NEXT:    scratch_store_b32 off, v0, off scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    scratch_store_b32 off, v1, off offset:16000 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    scratch_load_b32 v0, off, off offset:16000 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    s_endpgm
bb:
  %i = alloca [4096 x i32], align 4, addrspace(5)
  %i1 = getelementptr inbounds [4096 x i32], ptr addrspace(5) %i, i32 0, i32 0
  store volatile i32 13, ptr addrspace(5) %i1, align 4
  %i7 = getelementptr inbounds [4096 x i32], ptr addrspace(5) %i, i32 0, i32 4000
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i10 = getelementptr inbounds [4096 x i32], ptr addrspace(5) %i, i32 0, i32 4000
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define void @store_load_large_imm_offset_foo() {
; GFX9-LABEL: store_load_large_imm_offset_foo:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 13
; GFX9-NEXT:    scratch_store_dword off, v0, s32 offset:4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_add_i32 s0, s32, 0x3004
; GFX9-NEXT:    v_mov_b32_e32 v0, 15
; GFX9-NEXT:    scratch_store_dword off, v0, s0 offset:3712
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    scratch_load_dword v0, off, s0 offset:3712 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: store_load_large_imm_offset_foo:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, 13
; GFX10-NEXT:    v_mov_b32_e32 v1, 15
; GFX10-NEXT:    s_add_i32 s0, s32, 0x3804
; GFX10-NEXT:    scratch_store_dword off, v0, s32 offset:4
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_store_dword off, v1, s0 offset:1664
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, off, s0 offset:1664 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: store_load_large_imm_offset_foo:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v0, 13 :: v_dual_mov_b32 v1, 0x3000
; GFX11-NEXT:    v_mov_b32_e32 v2, 15
; GFX11-NEXT:    scratch_store_b32 off, v0, s32 offset:4 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_store_b32 v1, v2, s32 offset:3716 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, v1, s32 offset:3716 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: store_load_large_imm_offset_foo:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 13 :: v_dual_mov_b32 v1, 15
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b32 off, v0, s32 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b32 off, v1, s32 offset:16000 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, off, s32 offset:16000 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-PAL-LABEL: store_load_large_imm_offset_foo:
; GFX9-PAL:       ; %bb.0: ; %bb
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-PAL-NEXT:    v_mov_b32_e32 v0, 13
; GFX9-PAL-NEXT:    scratch_store_dword off, v0, s32 offset:4
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_add_i32 s0, s32, 0x3004
; GFX9-PAL-NEXT:    v_mov_b32_e32 v0, 15
; GFX9-PAL-NEXT:    scratch_store_dword off, v0, s0 offset:3712
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    scratch_load_dword v0, off, s0 offset:3712 glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: store_load_large_imm_offset_foo:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v0, 13
; GFX942-NEXT:    scratch_store_dword off, v0, s32 offset:4 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v0, 0x3000
; GFX942-NEXT:    v_mov_b32_e32 v1, 15
; GFX942-NEXT:    scratch_store_dword v0, v1, s32 offset:3716 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    scratch_load_dword v0, v0, s32 offset:3716 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-PAL-LABEL: store_load_large_imm_offset_foo:
; GFX10-PAL:       ; %bb.0: ; %bb
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-PAL-NEXT:    v_mov_b32_e32 v0, 13
; GFX10-PAL-NEXT:    v_mov_b32_e32 v1, 15
; GFX10-PAL-NEXT:    s_add_i32 s0, s32, 0x3804
; GFX10-PAL-NEXT:    scratch_store_dword off, v0, s32 offset:4
; GFX10-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-PAL-NEXT:    scratch_store_dword off, v1, s0 offset:1664
; GFX10-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-PAL-NEXT:    scratch_load_dword v0, off, s0 offset:1664 glc dlc
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-PAL-LABEL: store_load_large_imm_offset_foo:
; GFX11-PAL:       ; %bb.0: ; %bb
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-PAL-NEXT:    v_dual_mov_b32 v0, 13 :: v_dual_mov_b32 v1, 0x3000
; GFX11-PAL-NEXT:    v_mov_b32_e32 v2, 15
; GFX11-PAL-NEXT:    scratch_store_b32 off, v0, s32 offset:4 dlc
; GFX11-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-PAL-NEXT:    scratch_store_b32 v1, v2, s32 offset:3716 dlc
; GFX11-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-PAL-NEXT:    scratch_load_b32 v0, v1, s32 offset:3716 glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-PAL-LABEL: store_load_large_imm_offset_foo:
; GFX12-PAL:       ; %bb.0: ; %bb
; GFX12-PAL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-PAL-NEXT:    s_wait_expcnt 0x0
; GFX12-PAL-NEXT:    s_wait_samplecnt 0x0
; GFX12-PAL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-PAL-NEXT:    s_wait_kmcnt 0x0
; GFX12-PAL-NEXT:    v_dual_mov_b32 v0, 13 :: v_dual_mov_b32 v1, 15
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    scratch_store_b32 off, v0, s32 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    scratch_store_b32 off, v1, s32 offset:16000 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    scratch_load_b32 v0, off, s32 offset:16000 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    s_setpc_b64 s[30:31]
bb:
  %i = alloca [4096 x i32], align 4, addrspace(5)
  %i1 = getelementptr inbounds [4096 x i32], ptr addrspace(5) %i, i32 0, i32 0
  store volatile i32 13, ptr addrspace(5) %i1, align 4
  %i7 = getelementptr inbounds [4096 x i32], ptr addrspace(5) %i, i32 0, i32 4000
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i10 = getelementptr inbounds [4096 x i32], ptr addrspace(5) %i, i32 0, i32 4000
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define amdgpu_kernel void @store_load_vidx_sidx_offset(i32 %sidx) {
; GFX9-LABEL: store_load_vidx_sidx_offset:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s8, s13
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s9, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX9-NEXT:    v_lshl_add_u32 v0, v0, 2, v1
; GFX9-NEXT:    v_mov_b32_e32 v1, 15
; GFX9-NEXT:    scratch_store_dword v0, v1, off offset:1024
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    scratch_load_dword v0, v0, off offset:1024 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: store_load_vidx_sidx_offset:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s8, s8, s13
; GFX10-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s8
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s9
; GFX10-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 15
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX10-NEXT:    v_lshl_add_u32 v0, v0, 2, 0
; GFX10-NEXT:    scratch_store_dword v0, v1, off offset:1024
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, v0, off offset:1024 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: store_load_vidx_sidx_offset:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX11-NEXT:    v_lshl_add_u32 v0, v0, 2, 0
; GFX11-NEXT:    scratch_store_b32 v0, v1, off offset:1024 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, v0, off offset:1024 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: store_load_vidx_sidx_offset:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX12-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_add_lshl_u32 v0, s0, v0, 2
; GFX12-NEXT:    scratch_store_b32 v0, v1, off offset:1024 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, v0, off offset:1024 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_endpgm
;
; GFX9-PAL-LABEL: store_load_vidx_sidx_offset:
; GFX9-PAL:       ; %bb.0: ; %bb
; GFX9-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX9-PAL-NEXT:    s_mov_b32 s12, s0
; GFX9-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX9-PAL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-PAL-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX9-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX9-PAL-NEXT:    s_add_u32 flat_scratch_lo, s12, s11
; GFX9-PAL-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX9-PAL-NEXT:    s_addc_u32 flat_scratch_hi, s13, 0
; GFX9-PAL-NEXT:    v_lshl_add_u32 v0, v0, 2, v1
; GFX9-PAL-NEXT:    v_mov_b32_e32 v1, 15
; GFX9-PAL-NEXT:    scratch_store_dword v0, v1, off offset:1024
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    scratch_load_dword v0, v0, off offset:1024 glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_endpgm
;
; GFX942-LABEL: store_load_vidx_sidx_offset:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX942-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX942-NEXT:    v_mov_b32_e32 v1, 0
; GFX942-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX942-NEXT:    v_lshl_add_u32 v0, v0, 2, v1
; GFX942-NEXT:    v_mov_b32_e32 v1, 15
; GFX942-NEXT:    scratch_store_dword v0, v1, off offset:1024 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    scratch_load_dword v0, v0, off offset:1024 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_endpgm
;
; GFX10-PAL-LABEL: store_load_vidx_sidx_offset:
; GFX10-PAL:       ; %bb.0: ; %bb
; GFX10-PAL-NEXT:    s_getpc_b64 s[12:13]
; GFX10-PAL-NEXT:    s_mov_b32 s12, s0
; GFX10-PAL-NEXT:    s_load_dwordx2 s[12:13], s[12:13], 0x0
; GFX10-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-PAL-NEXT:    s_and_b32 s13, s13, 0xffff
; GFX10-PAL-NEXT:    s_add_u32 s12, s12, s11
; GFX10-PAL-NEXT:    s_addc_u32 s13, s13, 0
; GFX10-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX10-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX10-PAL-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX10-PAL-NEXT:    v_mov_b32_e32 v1, 15
; GFX10-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-PAL-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX10-PAL-NEXT:    v_lshl_add_u32 v0, v0, 2, 0
; GFX10-PAL-NEXT:    scratch_store_dword v0, v1, off offset:1024
; GFX10-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-PAL-NEXT:    scratch_load_dword v0, v0, off offset:1024 glc dlc
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-PAL-NEXT:    s_endpgm
;
; GFX11-PAL-LABEL: store_load_vidx_sidx_offset:
; GFX11-PAL:       ; %bb.0: ; %bb
; GFX11-PAL-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-PAL-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-PAL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-PAL-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX11-PAL-NEXT:    v_lshl_add_u32 v0, v0, 2, 0
; GFX11-PAL-NEXT:    scratch_store_b32 v0, v1, off offset:1024 dlc
; GFX11-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-PAL-NEXT:    scratch_load_b32 v0, v0, off offset:1024 glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    s_endpgm
;
; GFX12-PAL-LABEL: store_load_vidx_sidx_offset:
; GFX12-PAL:       ; %bb.0: ; %bb
; GFX12-PAL-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-PAL-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-PAL-NEXT:    s_wait_kmcnt 0x0
; GFX12-PAL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-PAL-NEXT:    v_add_lshl_u32 v0, s0, v0, 2
; GFX12-PAL-NEXT:    scratch_store_b32 v0, v1, off offset:1024 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    scratch_load_b32 v0, v0, off offset:1024 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    s_endpgm
bb:
  %alloca = alloca [32 x i32], align 4, addrspace(5)
  %vidx = tail call i32 @llvm.amdgcn.workitem.id.x()
  %add1 = add nsw i32 %sidx, %vidx
  %gep1 = getelementptr [32 x float], ptr addrspace(5) %alloca, i32 0, i32 %add1
  %gep = getelementptr inbounds [32 x float], ptr addrspace(5) %gep1, i32 0, i32 256
  store volatile i32 15, ptr addrspace(5) %gep, align 4
  %load = load volatile i32, ptr addrspace(5) %gep, align 4
  ret void
}

define void @store_load_i64_aligned(ptr addrspace(5) nocapture %arg) {
; GFX9-LABEL: store_load_i64_aligned:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 15
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    scratch_store_dwordx2 v0, v[1:2], off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    scratch_load_dwordx2 v[0:1], v0, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: store_load_i64_aligned:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, 15
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    scratch_store_dwordx2 v0, v[1:2], off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dwordx2 v[0:1], v0, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: store_load_i64_aligned:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_mov_b32 v2, 0
; GFX11-NEXT:    scratch_store_b64 v0, v[1:2], off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b64 v[0:1], v0, off glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: store_load_i64_aligned:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_mov_b32 v2, 0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b64 v0, v[1:2], off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b64 v[0:1], v0, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-PAL-LABEL: store_load_i64_aligned:
; GFX9-PAL:       ; %bb.0: ; %bb
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-PAL-NEXT:    v_mov_b32_e32 v1, 15
; GFX9-PAL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-PAL-NEXT:    scratch_store_dwordx2 v0, v[1:2], off
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    scratch_load_dwordx2 v[0:1], v0, off glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: store_load_i64_aligned:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v2, 15
; GFX942-NEXT:    v_mov_b32_e32 v3, 0
; GFX942-NEXT:    scratch_store_dwordx2 v0, v[2:3], off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    scratch_load_dwordx2 v[0:1], v0, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-PAL-LABEL: store_load_i64_aligned:
; GFX10-PAL:       ; %bb.0: ; %bb
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-PAL-NEXT:    v_mov_b32_e32 v1, 15
; GFX10-PAL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-PAL-NEXT:    scratch_store_dwordx2 v0, v[1:2], off
; GFX10-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-PAL-NEXT:    scratch_load_dwordx2 v[0:1], v0, off glc dlc
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-PAL-LABEL: store_load_i64_aligned:
; GFX11-PAL:       ; %bb.0: ; %bb
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-PAL-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_mov_b32 v2, 0
; GFX11-PAL-NEXT:    scratch_store_b64 v0, v[1:2], off dlc
; GFX11-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-PAL-NEXT:    scratch_load_b64 v[0:1], v0, off glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-PAL-LABEL: store_load_i64_aligned:
; GFX12-PAL:       ; %bb.0: ; %bb
; GFX12-PAL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-PAL-NEXT:    s_wait_expcnt 0x0
; GFX12-PAL-NEXT:    s_wait_samplecnt 0x0
; GFX12-PAL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-PAL-NEXT:    s_wait_kmcnt 0x0
; GFX12-PAL-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_mov_b32 v2, 0
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    scratch_store_b64 v0, v[1:2], off scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    scratch_load_b64 v[0:1], v0, off scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    s_setpc_b64 s[30:31]
bb:
  store volatile i64 15, ptr addrspace(5) %arg, align 8
  %load = load volatile i64, ptr addrspace(5) %arg, align 8
  ret void
}

define void @store_load_i64_unaligned(ptr addrspace(5) nocapture %arg) {
; GFX9-LABEL: store_load_i64_unaligned:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 15
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    scratch_store_dwordx2 v0, v[1:2], off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    scratch_load_dwordx2 v[0:1], v0, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: store_load_i64_unaligned:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, 15
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    scratch_store_dwordx2 v0, v[1:2], off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dwordx2 v[0:1], v0, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: store_load_i64_unaligned:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_mov_b32 v2, 0
; GFX11-NEXT:    scratch_store_b64 v0, v[1:2], off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b64 v[0:1], v0, off glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: store_load_i64_unaligned:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_mov_b32 v2, 0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b64 v0, v[1:2], off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b64 v[0:1], v0, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-PAL-LABEL: store_load_i64_unaligned:
; GFX9-PAL:       ; %bb.0: ; %bb
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-PAL-NEXT:    v_mov_b32_e32 v1, 15
; GFX9-PAL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-PAL-NEXT:    scratch_store_dwordx2 v0, v[1:2], off
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    scratch_load_dwordx2 v[0:1], v0, off glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: store_load_i64_unaligned:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v2, 15
; GFX942-NEXT:    v_mov_b32_e32 v3, 0
; GFX942-NEXT:    scratch_store_dwordx2 v0, v[2:3], off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    scratch_load_dwordx2 v[0:1], v0, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-PAL-LABEL: store_load_i64_unaligned:
; GFX10-PAL:       ; %bb.0: ; %bb
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-PAL-NEXT:    v_mov_b32_e32 v1, 15
; GFX10-PAL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-PAL-NEXT:    scratch_store_dwordx2 v0, v[1:2], off
; GFX10-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-PAL-NEXT:    scratch_load_dwordx2 v[0:1], v0, off glc dlc
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-PAL-LABEL: store_load_i64_unaligned:
; GFX11-PAL:       ; %bb.0: ; %bb
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-PAL-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_mov_b32 v2, 0
; GFX11-PAL-NEXT:    scratch_store_b64 v0, v[1:2], off dlc
; GFX11-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-PAL-NEXT:    scratch_load_b64 v[0:1], v0, off glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-PAL-LABEL: store_load_i64_unaligned:
; GFX12-PAL:       ; %bb.0: ; %bb
; GFX12-PAL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-PAL-NEXT:    s_wait_expcnt 0x0
; GFX12-PAL-NEXT:    s_wait_samplecnt 0x0
; GFX12-PAL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-PAL-NEXT:    s_wait_kmcnt 0x0
; GFX12-PAL-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_mov_b32 v2, 0
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    scratch_store_b64 v0, v[1:2], off scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    scratch_load_b64 v[0:1], v0, off scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    s_setpc_b64 s[30:31]
bb:
  store volatile i64 15, ptr addrspace(5) %arg, align 1
  %load = load volatile i64, ptr addrspace(5) %arg, align 1
  ret void
}

define void @store_load_v3i32_unaligned(ptr addrspace(5) nocapture %arg) {
; GFX9-LABEL: store_load_v3i32_unaligned:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 1
; GFX9-NEXT:    v_mov_b32_e32 v2, 2
; GFX9-NEXT:    v_mov_b32_e32 v3, 3
; GFX9-NEXT:    scratch_store_dwordx3 v0, v[1:3], off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    scratch_load_dwordx3 v[0:2], v0, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: store_load_v3i32_unaligned:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, 1
; GFX10-NEXT:    v_mov_b32_e32 v2, 2
; GFX10-NEXT:    v_mov_b32_e32 v3, 3
; GFX10-NEXT:    scratch_store_dwordx3 v0, v[1:3], off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dwordx3 v[0:2], v0, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: store_load_v3i32_unaligned:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_mov_b32 v2, 2
; GFX11-NEXT:    v_mov_b32_e32 v3, 3
; GFX11-NEXT:    scratch_store_b96 v0, v[1:3], off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b96 v[0:2], v0, off glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: store_load_v3i32_unaligned:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_mov_b32 v2, 2
; GFX12-NEXT:    v_mov_b32_e32 v3, 3
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b96 v0, v[1:3], off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b96 v[0:2], v0, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-PAL-LABEL: store_load_v3i32_unaligned:
; GFX9-PAL:       ; %bb.0: ; %bb
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-PAL-NEXT:    v_mov_b32_e32 v1, 1
; GFX9-PAL-NEXT:    v_mov_b32_e32 v2, 2
; GFX9-PAL-NEXT:    v_mov_b32_e32 v3, 3
; GFX9-PAL-NEXT:    scratch_store_dwordx3 v0, v[1:3], off
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    scratch_load_dwordx3 v[0:2], v0, off glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: store_load_v3i32_unaligned:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v2, 1
; GFX942-NEXT:    v_mov_b32_e32 v3, 2
; GFX942-NEXT:    v_mov_b32_e32 v4, 3
; GFX942-NEXT:    scratch_store_dwordx3 v0, v[2:4], off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    scratch_load_dwordx3 v[0:2], v0, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-PAL-LABEL: store_load_v3i32_unaligned:
; GFX10-PAL:       ; %bb.0: ; %bb
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-PAL-NEXT:    v_mov_b32_e32 v1, 1
; GFX10-PAL-NEXT:    v_mov_b32_e32 v2, 2
; GFX10-PAL-NEXT:    v_mov_b32_e32 v3, 3
; GFX10-PAL-NEXT:    scratch_store_dwordx3 v0, v[1:3], off
; GFX10-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-PAL-NEXT:    scratch_load_dwordx3 v[0:2], v0, off glc dlc
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-PAL-LABEL: store_load_v3i32_unaligned:
; GFX11-PAL:       ; %bb.0: ; %bb
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-PAL-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_mov_b32 v2, 2
; GFX11-PAL-NEXT:    v_mov_b32_e32 v3, 3
; GFX11-PAL-NEXT:    scratch_store_b96 v0, v[1:3], off dlc
; GFX11-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-PAL-NEXT:    scratch_load_b96 v[0:2], v0, off glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-PAL-LABEL: store_load_v3i32_unaligned:
; GFX12-PAL:       ; %bb.0: ; %bb
; GFX12-PAL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-PAL-NEXT:    s_wait_expcnt 0x0
; GFX12-PAL-NEXT:    s_wait_samplecnt 0x0
; GFX12-PAL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-PAL-NEXT:    s_wait_kmcnt 0x0
; GFX12-PAL-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_mov_b32 v2, 2
; GFX12-PAL-NEXT:    v_mov_b32_e32 v3, 3
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    scratch_store_b96 v0, v[1:3], off scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    scratch_load_b96 v[0:2], v0, off scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    s_setpc_b64 s[30:31]
bb:
  store volatile <3 x i32> <i32 1, i32 2, i32 3>, ptr addrspace(5) %arg, align 1
  %load = load volatile <3 x i32>, ptr addrspace(5) %arg, align 1
  ret void
}

define void @store_load_v4i32_unaligned(ptr addrspace(5) nocapture %arg) {
; GFX9-LABEL: store_load_v4i32_unaligned:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 1
; GFX9-NEXT:    v_mov_b32_e32 v2, 2
; GFX9-NEXT:    v_mov_b32_e32 v3, 3
; GFX9-NEXT:    v_mov_b32_e32 v4, 4
; GFX9-NEXT:    scratch_store_dwordx4 v0, v[1:4], off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    scratch_load_dwordx4 v[0:3], v0, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: store_load_v4i32_unaligned:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, 1
; GFX10-NEXT:    v_mov_b32_e32 v2, 2
; GFX10-NEXT:    v_mov_b32_e32 v3, 3
; GFX10-NEXT:    v_mov_b32_e32 v4, 4
; GFX10-NEXT:    scratch_store_dwordx4 v0, v[1:4], off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dwordx4 v[0:3], v0, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: store_load_v4i32_unaligned:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_mov_b32 v2, 2
; GFX11-NEXT:    v_dual_mov_b32 v3, 3 :: v_dual_mov_b32 v4, 4
; GFX11-NEXT:    scratch_store_b128 v0, v[1:4], off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b128 v[0:3], v0, off glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: store_load_v4i32_unaligned:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_mov_b32 v2, 2
; GFX12-NEXT:    v_dual_mov_b32 v3, 3 :: v_dual_mov_b32 v4, 4
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b128 v0, v[1:4], off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b128 v[0:3], v0, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-PAL-LABEL: store_load_v4i32_unaligned:
; GFX9-PAL:       ; %bb.0: ; %bb
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-PAL-NEXT:    v_mov_b32_e32 v1, 1
; GFX9-PAL-NEXT:    v_mov_b32_e32 v2, 2
; GFX9-PAL-NEXT:    v_mov_b32_e32 v3, 3
; GFX9-PAL-NEXT:    v_mov_b32_e32 v4, 4
; GFX9-PAL-NEXT:    scratch_store_dwordx4 v0, v[1:4], off
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    scratch_load_dwordx4 v[0:3], v0, off glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: store_load_v4i32_unaligned:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v2, 1
; GFX942-NEXT:    v_mov_b32_e32 v3, 2
; GFX942-NEXT:    v_mov_b32_e32 v4, 3
; GFX942-NEXT:    v_mov_b32_e32 v5, 4
; GFX942-NEXT:    scratch_store_dwordx4 v0, v[2:5], off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    scratch_load_dwordx4 v[0:3], v0, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-PAL-LABEL: store_load_v4i32_unaligned:
; GFX10-PAL:       ; %bb.0: ; %bb
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-PAL-NEXT:    v_mov_b32_e32 v1, 1
; GFX10-PAL-NEXT:    v_mov_b32_e32 v2, 2
; GFX10-PAL-NEXT:    v_mov_b32_e32 v3, 3
; GFX10-PAL-NEXT:    v_mov_b32_e32 v4, 4
; GFX10-PAL-NEXT:    scratch_store_dwordx4 v0, v[1:4], off
; GFX10-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-PAL-NEXT:    scratch_load_dwordx4 v[0:3], v0, off glc dlc
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-PAL-LABEL: store_load_v4i32_unaligned:
; GFX11-PAL:       ; %bb.0: ; %bb
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-PAL-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_mov_b32 v2, 2
; GFX11-PAL-NEXT:    v_dual_mov_b32 v3, 3 :: v_dual_mov_b32 v4, 4
; GFX11-PAL-NEXT:    scratch_store_b128 v0, v[1:4], off dlc
; GFX11-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-PAL-NEXT:    scratch_load_b128 v[0:3], v0, off glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-PAL-LABEL: store_load_v4i32_unaligned:
; GFX12-PAL:       ; %bb.0: ; %bb
; GFX12-PAL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-PAL-NEXT:    s_wait_expcnt 0x0
; GFX12-PAL-NEXT:    s_wait_samplecnt 0x0
; GFX12-PAL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-PAL-NEXT:    s_wait_kmcnt 0x0
; GFX12-PAL-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_mov_b32 v2, 2
; GFX12-PAL-NEXT:    v_dual_mov_b32 v3, 3 :: v_dual_mov_b32 v4, 4
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    scratch_store_b128 v0, v[1:4], off scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    scratch_load_b128 v[0:3], v0, off scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    s_setpc_b64 s[30:31]
bb:
  store volatile <4 x i32> <i32 1, i32 2, i32 3, i32 4>, ptr addrspace(5) %arg, align 1
  %load = load volatile <4 x i32>, ptr addrspace(5) %arg, align 1
  ret void
}

define void @store_load_i32_negative_unaligned(ptr addrspace(5) nocapture %arg) {
; GFX9-LABEL: store_load_i32_negative_unaligned:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v0, -1, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 1
; GFX9-NEXT:    scratch_store_byte v0, v1, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    scratch_load_ubyte v0, v0, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: store_load_i32_negative_unaligned:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, 1
; GFX10-NEXT:    scratch_store_byte v0, v1, off offset:-1
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_ubyte v0, v0, off offset:-1 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: store_load_i32_negative_unaligned:
; GFX11-TRUE16:       ; %bb.0: ; %bb
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v1.l, 1
; GFX11-TRUE16-NEXT:    scratch_store_b8 v0, v1, off offset:-1 dlc
; GFX11-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-TRUE16-NEXT:    scratch_load_d16_u8 v0, v0, off offset:-1 glc dlc
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: store_load_i32_negative_unaligned:
; GFX11-FAKE16:       ; %bb.0: ; %bb
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v1, 1
; GFX11-FAKE16-NEXT:    scratch_store_b8 v0, v1, off offset:-1 dlc
; GFX11-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-FAKE16-NEXT:    scratch_load_u8 v0, v0, off offset:-1 glc dlc
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: store_load_i32_negative_unaligned:
; GFX12-TRUE16:       ; %bb.0: ; %bb
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v1.l, 1
; GFX12-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-TRUE16-NEXT:    scratch_store_b8 v0, v1, off offset:-1 scope:SCOPE_SYS
; GFX12-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-TRUE16-NEXT:    scratch_load_d16_u8 v0, v0, off offset:-1 scope:SCOPE_SYS
; GFX12-TRUE16-NEXT:    s_wait_loadcnt 0x0
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: store_load_i32_negative_unaligned:
; GFX12-FAKE16:       ; %bb.0: ; %bb
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_mov_b32_e32 v1, 1
; GFX12-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-FAKE16-NEXT:    scratch_store_b8 v0, v1, off offset:-1 scope:SCOPE_SYS
; GFX12-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-FAKE16-NEXT:    scratch_load_u8 v0, v0, off offset:-1 scope:SCOPE_SYS
; GFX12-FAKE16-NEXT:    s_wait_loadcnt 0x0
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-PAL-LABEL: store_load_i32_negative_unaligned:
; GFX9-PAL:       ; %bb.0: ; %bb
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-PAL-NEXT:    v_add_u32_e32 v0, -1, v0
; GFX9-PAL-NEXT:    v_mov_b32_e32 v1, 1
; GFX9-PAL-NEXT:    scratch_store_byte v0, v1, off
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    scratch_load_ubyte v0, v0, off glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: store_load_i32_negative_unaligned:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_add_u32_e32 v0, -1, v0
; GFX942-NEXT:    v_mov_b32_e32 v1, 1
; GFX942-NEXT:    scratch_store_byte v0, v1, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    scratch_load_ubyte v0, v0, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-PAL-LABEL: store_load_i32_negative_unaligned:
; GFX1010-PAL:       ; %bb.0: ; %bb
; GFX1010-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-PAL-NEXT:    v_add_nc_u32_e32 v0, -1, v0
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v1, 1
; GFX1010-PAL-NEXT:    scratch_store_byte v0, v1, off
; GFX1010-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1010-PAL-NEXT:    scratch_load_ubyte v0, v0, off glc dlc
; GFX1010-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1030-PAL-LABEL: store_load_i32_negative_unaligned:
; GFX1030-PAL:       ; %bb.0: ; %bb
; GFX1030-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v1, 1
; GFX1030-PAL-NEXT:    scratch_store_byte v0, v1, off offset:-1
; GFX1030-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1030-PAL-NEXT:    scratch_load_ubyte v0, v0, off offset:-1 glc dlc
; GFX1030-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-PAL-TRUE16-LABEL: store_load_i32_negative_unaligned:
; GFX11-PAL-TRUE16:       ; %bb.0: ; %bb
; GFX11-PAL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-PAL-TRUE16-NEXT:    v_mov_b16_e32 v1.l, 1
; GFX11-PAL-TRUE16-NEXT:    scratch_store_b8 v0, v1, off offset:-1 dlc
; GFX11-PAL-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-PAL-TRUE16-NEXT:    scratch_load_d16_u8 v0, v0, off offset:-1 glc dlc
; GFX11-PAL-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-PAL-FAKE16-LABEL: store_load_i32_negative_unaligned:
; GFX11-PAL-FAKE16:       ; %bb.0: ; %bb
; GFX11-PAL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-PAL-FAKE16-NEXT:    v_mov_b32_e32 v1, 1
; GFX11-PAL-FAKE16-NEXT:    scratch_store_b8 v0, v1, off offset:-1 dlc
; GFX11-PAL-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-PAL-FAKE16-NEXT:    scratch_load_u8 v0, v0, off offset:-1 glc dlc
; GFX11-PAL-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-PAL-TRUE16-LABEL: store_load_i32_negative_unaligned:
; GFX12-PAL-TRUE16:       ; %bb.0: ; %bb
; GFX12-PAL-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-PAL-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-PAL-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-PAL-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-PAL-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-PAL-TRUE16-NEXT:    v_mov_b16_e32 v1.l, 1
; GFX12-PAL-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-TRUE16-NEXT:    scratch_store_b8 v0, v1, off offset:-1 scope:SCOPE_SYS
; GFX12-PAL-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-TRUE16-NEXT:    scratch_load_d16_u8 v0, v0, off offset:-1 scope:SCOPE_SYS
; GFX12-PAL-TRUE16-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-PAL-FAKE16-LABEL: store_load_i32_negative_unaligned:
; GFX12-PAL-FAKE16:       ; %bb.0: ; %bb
; GFX12-PAL-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-PAL-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-PAL-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-PAL-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-PAL-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-PAL-FAKE16-NEXT:    v_mov_b32_e32 v1, 1
; GFX12-PAL-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-FAKE16-NEXT:    scratch_store_b8 v0, v1, off offset:-1 scope:SCOPE_SYS
; GFX12-PAL-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-FAKE16-NEXT:    scratch_load_u8 v0, v0, off offset:-1 scope:SCOPE_SYS
; GFX12-PAL-FAKE16-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
bb:
  %ptr = getelementptr inbounds i8, ptr addrspace(5) %arg, i32 -1
  store volatile i8 1, ptr addrspace(5) %ptr, align 1
  %load = load volatile i8, ptr addrspace(5) %ptr, align 1
  ret void
}

define void @store_load_i32_large_negative_unaligned(ptr addrspace(5) nocapture %arg) {
; GFX9-LABEL: store_load_i32_large_negative_unaligned:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v0, 0xffffef7f, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 1
; GFX9-NEXT:    scratch_store_byte v0, v1, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    scratch_load_ubyte v0, v0, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: store_load_i32_large_negative_unaligned:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_nc_u32_e32 v0, 0xfffff000, v0
; GFX10-NEXT:    v_mov_b32_e32 v1, 1
; GFX10-NEXT:    scratch_store_byte v0, v1, off offset:-129
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_ubyte v0, v0, off offset:-129 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: store_load_i32_large_negative_unaligned:
; GFX11-TRUE16:       ; %bb.0: ; %bb
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v1, 0xfffff000, v0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, 1
; GFX11-TRUE16-NEXT:    scratch_store_b8 v1, v0, off offset:-129 dlc
; GFX11-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-TRUE16-NEXT:    scratch_load_d16_u8 v0, v1, off offset:-129 glc dlc
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: store_load_i32_large_negative_unaligned:
; GFX11-FAKE16:       ; %bb.0: ; %bb
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_add_nc_u32 v0, 0xfffff000, v0
; GFX11-FAKE16-NEXT:    scratch_store_b8 v0, v1, off offset:-129 dlc
; GFX11-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-FAKE16-NEXT:    scratch_load_u8 v0, v0, off offset:-129 glc dlc
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: store_load_i32_large_negative_unaligned:
; GFX12-TRUE16:       ; %bb.0: ; %bb
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v1.l, 1
; GFX12-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-TRUE16-NEXT:    scratch_store_b8 v0, v1, off offset:-4225 scope:SCOPE_SYS
; GFX12-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-TRUE16-NEXT:    scratch_load_d16_u8 v0, v0, off offset:-4225 scope:SCOPE_SYS
; GFX12-TRUE16-NEXT:    s_wait_loadcnt 0x0
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: store_load_i32_large_negative_unaligned:
; GFX12-FAKE16:       ; %bb.0: ; %bb
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_mov_b32_e32 v1, 1
; GFX12-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-FAKE16-NEXT:    scratch_store_b8 v0, v1, off offset:-4225 scope:SCOPE_SYS
; GFX12-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-FAKE16-NEXT:    scratch_load_u8 v0, v0, off offset:-4225 scope:SCOPE_SYS
; GFX12-FAKE16-NEXT:    s_wait_loadcnt 0x0
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-PAL-LABEL: store_load_i32_large_negative_unaligned:
; GFX9-PAL:       ; %bb.0: ; %bb
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-PAL-NEXT:    v_add_u32_e32 v0, 0xffffef7f, v0
; GFX9-PAL-NEXT:    v_mov_b32_e32 v1, 1
; GFX9-PAL-NEXT:    scratch_store_byte v0, v1, off
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    scratch_load_ubyte v0, v0, off glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: store_load_i32_large_negative_unaligned:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_add_u32_e32 v0, 0xffffef7f, v0
; GFX942-NEXT:    v_mov_b32_e32 v1, 1
; GFX942-NEXT:    scratch_store_byte v0, v1, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    scratch_load_ubyte v0, v0, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-PAL-LABEL: store_load_i32_large_negative_unaligned:
; GFX1010-PAL:       ; %bb.0: ; %bb
; GFX1010-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-PAL-NEXT:    v_add_nc_u32_e32 v0, 0xffffefff, v0
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v1, 1
; GFX1010-PAL-NEXT:    scratch_store_byte v0, v1, off offset:-128
; GFX1010-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1010-PAL-NEXT:    scratch_load_ubyte v0, v0, off offset:-128 glc dlc
; GFX1010-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1030-PAL-LABEL: store_load_i32_large_negative_unaligned:
; GFX1030-PAL:       ; %bb.0: ; %bb
; GFX1030-PAL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1030-PAL-NEXT:    v_add_nc_u32_e32 v0, 0xfffff000, v0
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v1, 1
; GFX1030-PAL-NEXT:    scratch_store_byte v0, v1, off offset:-129
; GFX1030-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1030-PAL-NEXT:    scratch_load_ubyte v0, v0, off offset:-129 glc dlc
; GFX1030-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-PAL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-PAL-TRUE16-LABEL: store_load_i32_large_negative_unaligned:
; GFX11-PAL-TRUE16:       ; %bb.0: ; %bb
; GFX11-PAL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-PAL-TRUE16-NEXT:    v_add_nc_u32_e32 v1, 0xfffff000, v0
; GFX11-PAL-TRUE16-NEXT:    v_mov_b16_e32 v0.l, 1
; GFX11-PAL-TRUE16-NEXT:    scratch_store_b8 v1, v0, off offset:-129 dlc
; GFX11-PAL-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-PAL-TRUE16-NEXT:    scratch_load_d16_u8 v0, v1, off offset:-129 glc dlc
; GFX11-PAL-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-PAL-FAKE16-LABEL: store_load_i32_large_negative_unaligned:
; GFX11-PAL-FAKE16:       ; %bb.0: ; %bb
; GFX11-PAL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-PAL-FAKE16-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_add_nc_u32 v0, 0xfffff000, v0
; GFX11-PAL-FAKE16-NEXT:    scratch_store_b8 v0, v1, off offset:-129 dlc
; GFX11-PAL-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-PAL-FAKE16-NEXT:    scratch_load_u8 v0, v0, off offset:-129 glc dlc
; GFX11-PAL-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-PAL-TRUE16-LABEL: store_load_i32_large_negative_unaligned:
; GFX12-PAL-TRUE16:       ; %bb.0: ; %bb
; GFX12-PAL-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-PAL-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-PAL-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-PAL-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-PAL-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-PAL-TRUE16-NEXT:    v_mov_b16_e32 v1.l, 1
; GFX12-PAL-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-TRUE16-NEXT:    scratch_store_b8 v0, v1, off offset:-4225 scope:SCOPE_SYS
; GFX12-PAL-TRUE16-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-TRUE16-NEXT:    scratch_load_d16_u8 v0, v0, off offset:-4225 scope:SCOPE_SYS
; GFX12-PAL-TRUE16-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-PAL-FAKE16-LABEL: store_load_i32_large_negative_unaligned:
; GFX12-PAL-FAKE16:       ; %bb.0: ; %bb
; GFX12-PAL-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-PAL-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-PAL-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-PAL-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-PAL-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-PAL-FAKE16-NEXT:    v_mov_b32_e32 v1, 1
; GFX12-PAL-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-FAKE16-NEXT:    scratch_store_b8 v0, v1, off offset:-4225 scope:SCOPE_SYS
; GFX12-PAL-FAKE16-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-FAKE16-NEXT:    scratch_load_u8 v0, v0, off offset:-4225 scope:SCOPE_SYS
; GFX12-PAL-FAKE16-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
bb:
  %ptr = getelementptr inbounds i8, ptr addrspace(5) %arg, i32 -4225
  store volatile i8 1, ptr addrspace(5) %ptr, align 1
  %load = load volatile i8, ptr addrspace(5) %ptr, align 1
  ret void
}

define amdgpu_ps void @large_offset() {
; GFX9-LABEL: large_offset:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s0, s2
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-NEXT:    s_mov_b32 s0, 0
; GFX9-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:3024
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    scratch_load_dwordx4 v[0:3], off, s0 offset:3024 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_mov_b32 s0, 16
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s0
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_movk_i32 s0, 0x810
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s0
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: large_offset:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s0, s0, s2
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_movk_i32 s0, 0x810
; GFX10-NEXT:    s_add_i32 s1, s0, 0x3c0
; GFX10-NEXT:    v_mov_b32_e32 v1, v0
; GFX10-NEXT:    v_mov_b32_e32 v2, v0
; GFX10-NEXT:    v_mov_b32_e32 v3, v0
; GFX10-NEXT:    scratch_store_dwordx4 off, v[0:3], s1
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dwordx4 v[0:3], off, s1 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_mov_b32 s1, 16
; GFX10-NEXT:    ;;#ASMSTART
; GFX10-NEXT:    ; use s1
; GFX10-NEXT:    ;;#ASMEND
; GFX10-NEXT:    ;;#ASMSTART
; GFX10-NEXT:    ; use s0
; GFX10-NEXT:    ;;#ASMEND
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: large_offset:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_mov_b32 s0, 16
; GFX11-NEXT:    s_movk_i32 s1, 0x810
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mov_b32_e32 v1, v0
; GFX11-NEXT:    v_mov_b32_e32 v2, v0
; GFX11-NEXT:    v_mov_b32_e32 v3, v0
; GFX11-NEXT:    scratch_store_b128 off, v[0:3], off offset:3024 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b128 v[0:3], off, off offset:3024 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ;;#ASMSTART
; GFX11-NEXT:    ; use s0
; GFX11-NEXT:    ;;#ASMEND
; GFX11-NEXT:    ;;#ASMSTART
; GFX11-NEXT:    ; use s1
; GFX11-NEXT:    ;;#ASMEND
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: large_offset:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_movk_i32 s1, 0x800
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_dual_mov_b32 v1, v0 :: v_dual_mov_b32 v2, v0
; GFX12-NEXT:    v_mov_b32_e32 v3, v0
; GFX12-NEXT:    scratch_store_b128 off, v[0:3], off offset:3008 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b128 v[0:3], off, off offset:3008 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    ;;#ASMSTART
; GFX12-NEXT:    ; use s0
; GFX12-NEXT:    ;;#ASMEND
; GFX12-NEXT:    ;;#ASMSTART
; GFX12-NEXT:    ; use s1
; GFX12-NEXT:    ;;#ASMEND
; GFX12-NEXT:    s_endpgm
;
; GFX9-PAL-LABEL: large_offset:
; GFX9-PAL:       ; %bb.0: ; %bb
; GFX9-PAL-NEXT:    s_getpc_b64 s[2:3]
; GFX9-PAL-NEXT:    s_mov_b32 s2, s0
; GFX9-PAL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX9-PAL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-PAL-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-PAL-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-PAL-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-PAL-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX9-PAL-NEXT:    s_add_u32 flat_scratch_lo, s2, s0
; GFX9-PAL-NEXT:    s_addc_u32 flat_scratch_hi, s3, 0
; GFX9-PAL-NEXT:    s_mov_b32 s0, 0
; GFX9-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s0 offset:3024
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    scratch_load_dwordx4 v[0:3], off, s0 offset:3024 glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_mov_b32 s0, 16
; GFX9-PAL-NEXT:    ;;#ASMSTART
; GFX9-PAL-NEXT:    ; use s0
; GFX9-PAL-NEXT:    ;;#ASMEND
; GFX9-PAL-NEXT:    s_movk_i32 s0, 0x810
; GFX9-PAL-NEXT:    ;;#ASMSTART
; GFX9-PAL-NEXT:    ; use s0
; GFX9-PAL-NEXT:    ;;#ASMEND
; GFX9-PAL-NEXT:    s_endpgm
;
; GFX942-LABEL: large_offset:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    v_mov_b32_e32 v0, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v0
; GFX942-NEXT:    v_mov_b32_e32 v2, v0
; GFX942-NEXT:    v_mov_b32_e32 v3, v0
; GFX942-NEXT:    scratch_store_dwordx4 off, v[0:3], off offset:3024 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    scratch_load_dwordx4 v[0:3], off, off offset:3024 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_mov_b32 s0, 16
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s0
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_movk_i32 s0, 0x810
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s0
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_endpgm
;
; GFX1010-PAL-LABEL: large_offset:
; GFX1010-PAL:       ; %bb.0: ; %bb
; GFX1010-PAL-NEXT:    s_getpc_b64 s[2:3]
; GFX1010-PAL-NEXT:    s_mov_b32 s2, s0
; GFX1010-PAL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX1010-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-PAL-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX1010-PAL-NEXT:    s_add_u32 s2, s2, s0
; GFX1010-PAL-NEXT:    s_addc_u32 s3, s3, 0
; GFX1010-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s2
; GFX1010-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s3
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v0, 0
; GFX1010-PAL-NEXT:    s_movk_i32 s0, 0x810
; GFX1010-PAL-NEXT:    s_add_i32 s1, s0, 0x3c0
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v1, v0
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v2, v0
; GFX1010-PAL-NEXT:    v_mov_b32_e32 v3, v0
; GFX1010-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s1
; GFX1010-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1010-PAL-NEXT:    scratch_load_dwordx4 v[0:3], off, s1 glc dlc
; GFX1010-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-PAL-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1010-PAL-NEXT:    s_mov_b32 s1, 16
; GFX1010-PAL-NEXT:    ;;#ASMSTART
; GFX1010-PAL-NEXT:    ; use s1
; GFX1010-PAL-NEXT:    ;;#ASMEND
; GFX1010-PAL-NEXT:    ;;#ASMSTART
; GFX1010-PAL-NEXT:    ; use s0
; GFX1010-PAL-NEXT:    ;;#ASMEND
; GFX1010-PAL-NEXT:    s_endpgm
;
; GFX1030-PAL-LABEL: large_offset:
; GFX1030-PAL:       ; %bb.0: ; %bb
; GFX1030-PAL-NEXT:    s_getpc_b64 s[2:3]
; GFX1030-PAL-NEXT:    s_mov_b32 s2, s0
; GFX1030-PAL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX1030-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-PAL-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX1030-PAL-NEXT:    s_add_u32 s2, s2, s0
; GFX1030-PAL-NEXT:    s_addc_u32 s3, s3, 0
; GFX1030-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s2
; GFX1030-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s3
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v0, 0
; GFX1030-PAL-NEXT:    s_movk_i32 s0, 0x810
; GFX1030-PAL-NEXT:    s_add_i32 s1, s0, 0x3c0
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v1, v0
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v2, v0
; GFX1030-PAL-NEXT:    v_mov_b32_e32 v3, v0
; GFX1030-PAL-NEXT:    scratch_store_dwordx4 off, v[0:3], s1
; GFX1030-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX1030-PAL-NEXT:    scratch_load_dwordx4 v[0:3], off, s1 glc dlc
; GFX1030-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-PAL-NEXT:    s_mov_b32 s1, 16
; GFX1030-PAL-NEXT:    ;;#ASMSTART
; GFX1030-PAL-NEXT:    ; use s1
; GFX1030-PAL-NEXT:    ;;#ASMEND
; GFX1030-PAL-NEXT:    ;;#ASMSTART
; GFX1030-PAL-NEXT:    ; use s0
; GFX1030-PAL-NEXT:    ;;#ASMEND
; GFX1030-PAL-NEXT:    s_endpgm
;
; GFX11-PAL-LABEL: large_offset:
; GFX11-PAL:       ; %bb.0: ; %bb
; GFX11-PAL-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-PAL-NEXT:    s_mov_b32 s0, 16
; GFX11-PAL-NEXT:    s_movk_i32 s1, 0x810
; GFX11-PAL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-PAL-NEXT:    v_mov_b32_e32 v1, v0
; GFX11-PAL-NEXT:    v_mov_b32_e32 v2, v0
; GFX11-PAL-NEXT:    v_mov_b32_e32 v3, v0
; GFX11-PAL-NEXT:    scratch_store_b128 off, v[0:3], off offset:3024 dlc
; GFX11-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-PAL-NEXT:    scratch_load_b128 v[0:3], off, off offset:3024 glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    ;;#ASMSTART
; GFX11-PAL-NEXT:    ; use s0
; GFX11-PAL-NEXT:    ;;#ASMEND
; GFX11-PAL-NEXT:    ;;#ASMSTART
; GFX11-PAL-NEXT:    ; use s1
; GFX11-PAL-NEXT:    ;;#ASMEND
; GFX11-PAL-NEXT:    s_endpgm
;
; GFX12-PAL-LABEL: large_offset:
; GFX12-PAL:       ; %bb.0: ; %bb
; GFX12-PAL-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-PAL-NEXT:    s_mov_b32 s0, 0
; GFX12-PAL-NEXT:    s_movk_i32 s1, 0x800
; GFX12-PAL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-PAL-NEXT:    v_dual_mov_b32 v1, v0 :: v_dual_mov_b32 v2, v0
; GFX12-PAL-NEXT:    v_mov_b32_e32 v3, v0
; GFX12-PAL-NEXT:    scratch_store_b128 off, v[0:3], off offset:3008 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    scratch_load_b128 v[0:3], off, off offset:3008 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    ;;#ASMSTART
; GFX12-PAL-NEXT:    ; use s0
; GFX12-PAL-NEXT:    ;;#ASMEND
; GFX12-PAL-NEXT:    ;;#ASMSTART
; GFX12-PAL-NEXT:    ; use s1
; GFX12-PAL-NEXT:    ;;#ASMEND
; GFX12-PAL-NEXT:    s_endpgm
bb:
  %alloca = alloca [128 x <4 x i32>], align 16, addrspace(5)
  %alloca2 = alloca [128 x <4 x i32>], align 16, addrspace(5)
  %gep = getelementptr inbounds [128 x <4 x i32>], ptr addrspace(5) %alloca2, i32 0, i32 60
  store volatile <4 x i32> zeroinitializer, ptr addrspace(5) %gep, align 16
  %load = load volatile <4 x i32>, ptr addrspace(5) %gep, align 16
  call void asm sideeffect "; use $0", "s"(ptr addrspace(5) %alloca) #0
  call void asm sideeffect "; use $0", "s"(ptr addrspace(5) %alloca2) #0
  ret void
}

define amdgpu_gs void @sgpr_base_large_offset(ptr addrspace(1) %out, ptr addrspace(5) inreg %sgpr_base) {
; GFX9-LABEL: sgpr_base_large_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s0, s5
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; GFX9-NEXT:    s_add_i32 s2, s2, 0xffe8
; GFX9-NEXT:    scratch_load_dword v2, off, s2
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: sgpr_base_large_offset:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_add_u32 s0, s0, s5
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; GFX10-NEXT:    s_add_i32 s2, s2, 0xffe8
; GFX10-NEXT:    scratch_load_dword v2, off, s2
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: sgpr_base_large_offset:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_add_i32 s0, s0, 0xffe8
; GFX11-NEXT:    scratch_load_b32 v2, off, s0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b32 v[0:1], v2, off
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: sgpr_base_large_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    scratch_load_b32 v2, off, s0 offset:65512
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_store_b32 v[0:1], v2, off
; GFX12-NEXT:    s_endpgm
;
; GFX9-PAL-LABEL: sgpr_base_large_offset:
; GFX9-PAL:       ; %bb.0: ; %entry
; GFX9-PAL-NEXT:    s_getpc_b64 s[2:3]
; GFX9-PAL-NEXT:    s_mov_b32 s2, s8
; GFX9-PAL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX9-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-PAL-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX9-PAL-NEXT:    s_add_u32 flat_scratch_lo, s2, s5
; GFX9-PAL-NEXT:    s_addc_u32 flat_scratch_hi, s3, 0
; GFX9-PAL-NEXT:    s_add_i32 s0, s0, 0xffe8
; GFX9-PAL-NEXT:    scratch_load_dword v2, off, s0
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-PAL-NEXT:    s_endpgm
;
; GFX942-LABEL: sgpr_base_large_offset:
; GFX942:       ; %bb.0: ; %entry
; GFX942-NEXT:    s_add_i32 s0, s0, 0xffe8
; GFX942-NEXT:    scratch_load_dword v2, off, s0
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    global_store_dword v[0:1], v2, off
; GFX942-NEXT:    s_endpgm
;
; GFX10-PAL-LABEL: sgpr_base_large_offset:
; GFX10-PAL:       ; %bb.0: ; %entry
; GFX10-PAL-NEXT:    s_getpc_b64 s[2:3]
; GFX10-PAL-NEXT:    s_mov_b32 s2, s8
; GFX10-PAL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX10-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-PAL-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX10-PAL-NEXT:    s_add_u32 s2, s2, s5
; GFX10-PAL-NEXT:    s_addc_u32 s3, s3, 0
; GFX10-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s2
; GFX10-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s3
; GFX10-PAL-NEXT:    s_add_i32 s0, s0, 0xffe8
; GFX10-PAL-NEXT:    scratch_load_dword v2, off, s0
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-PAL-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-PAL-NEXT:    s_endpgm
;
; GFX11-PAL-LABEL: sgpr_base_large_offset:
; GFX11-PAL:       ; %bb.0: ; %entry
; GFX11-PAL-NEXT:    s_add_i32 s0, s0, 0xffe8
; GFX11-PAL-NEXT:    scratch_load_b32 v2, off, s0
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    global_store_b32 v[0:1], v2, off
; GFX11-PAL-NEXT:    s_endpgm
;
; GFX12-PAL-LABEL: sgpr_base_large_offset:
; GFX12-PAL:       ; %bb.0: ; %entry
; GFX12-PAL-NEXT:    scratch_load_b32 v2, off, s0 offset:65512
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    global_store_b32 v[0:1], v2, off
; GFX12-PAL-NEXT:    s_endpgm
entry:
  %large_offset = getelementptr i8, ptr addrspace(5) %sgpr_base, i32 65512
  %load = load i32, ptr addrspace(5) %large_offset, align 4
  store i32 %load, ptr addrspace(1) %out
  ret void
}

define amdgpu_gs void @sgpr_base_large_offset_split(ptr addrspace(1) %out, ptr addrspace(5) inreg %sgpr_base) {
; GFX9-LABEL: sgpr_base_large_offset_split:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s0, s5
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; GFX9-NEXT:    s_and_b32 s0, s2, -4
; GFX9-NEXT:    s_add_i32 s0, s0, 0x100f000
; GFX9-NEXT:    scratch_load_dword v2, off, s0 offset:4072 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: sgpr_base_large_offset_split:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_add_u32 s0, s0, s5
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; GFX10-NEXT:    s_and_b32 s0, s2, -4
; GFX10-NEXT:    s_add_i32 s0, s0, 0x100f800
; GFX10-NEXT:    scratch_load_dword v2, off, s0 offset:2024 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: sgpr_base_large_offset_split:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    v_mov_b32_e32 v2, 0x100f000
; GFX11-NEXT:    s_and_b32 s0, s0, -4
; GFX11-NEXT:    scratch_load_b32 v2, v2, s0 offset:4072 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b32 v[0:1], v2, off
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: sgpr_base_large_offset_split:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    v_mov_b32_e32 v2, 0x1000000
; GFX12-NEXT:    s_and_b32 s0, s0, -4
; GFX12-NEXT:    scratch_load_b32 v2, v2, s0 offset:65512 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_store_b32 v[0:1], v2, off
; GFX12-NEXT:    s_endpgm
;
; GFX9-PAL-LABEL: sgpr_base_large_offset_split:
; GFX9-PAL:       ; %bb.0: ; %entry
; GFX9-PAL-NEXT:    s_getpc_b64 s[2:3]
; GFX9-PAL-NEXT:    s_mov_b32 s2, s8
; GFX9-PAL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX9-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-PAL-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX9-PAL-NEXT:    s_add_u32 flat_scratch_lo, s2, s5
; GFX9-PAL-NEXT:    s_addc_u32 flat_scratch_hi, s3, 0
; GFX9-PAL-NEXT:    s_and_b32 s0, s0, -4
; GFX9-PAL-NEXT:    s_add_i32 s0, s0, 0x100f000
; GFX9-PAL-NEXT:    scratch_load_dword v2, off, s0 offset:4072 glc
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-PAL-NEXT:    s_endpgm
;
; GFX942-LABEL: sgpr_base_large_offset_split:
; GFX942:       ; %bb.0: ; %entry
; GFX942-NEXT:    s_and_b32 s0, s0, -4
; GFX942-NEXT:    v_mov_b32_e32 v2, 0x100f000
; GFX942-NEXT:    scratch_load_dword v2, v2, s0 offset:4072 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    global_store_dword v[0:1], v2, off
; GFX942-NEXT:    s_endpgm
;
; GFX10-PAL-LABEL: sgpr_base_large_offset_split:
; GFX10-PAL:       ; %bb.0: ; %entry
; GFX10-PAL-NEXT:    s_getpc_b64 s[2:3]
; GFX10-PAL-NEXT:    s_mov_b32 s2, s8
; GFX10-PAL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX10-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-PAL-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX10-PAL-NEXT:    s_add_u32 s2, s2, s5
; GFX10-PAL-NEXT:    s_addc_u32 s3, s3, 0
; GFX10-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s2
; GFX10-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s3
; GFX10-PAL-NEXT:    s_and_b32 s0, s0, -4
; GFX10-PAL-NEXT:    s_add_i32 s0, s0, 0x100f800
; GFX10-PAL-NEXT:    scratch_load_dword v2, off, s0 offset:2024 glc dlc
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-PAL-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-PAL-NEXT:    s_endpgm
;
; GFX11-PAL-LABEL: sgpr_base_large_offset_split:
; GFX11-PAL:       ; %bb.0: ; %entry
; GFX11-PAL-NEXT:    v_mov_b32_e32 v2, 0x100f000
; GFX11-PAL-NEXT:    s_and_b32 s0, s0, -4
; GFX11-PAL-NEXT:    scratch_load_b32 v2, v2, s0 offset:4072 glc dlc
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    global_store_b32 v[0:1], v2, off
; GFX11-PAL-NEXT:    s_endpgm
;
; GFX12-PAL-LABEL: sgpr_base_large_offset_split:
; GFX12-PAL:       ; %bb.0: ; %entry
; GFX12-PAL-NEXT:    v_mov_b32_e32 v2, 0x1000000
; GFX12-PAL-NEXT:    s_and_b32 s0, s0, -4
; GFX12-PAL-NEXT:    scratch_load_b32 v2, v2, s0 offset:65512 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    global_store_b32 v[0:1], v2, off
; GFX12-PAL-NEXT:    s_endpgm
entry:
  ;%allignedBase = alloca [33554432 x i8], align 4, addrspace(5)
  %sgpr_base_i32 = ptrtoint ptr addrspace(5) %sgpr_base to i32
  %sgpr_base_i32_align4 = and i32 %sgpr_base_i32, 4294967292
  %sgpr_base_align4 = inttoptr i32 %sgpr_base_i32_align4 to ptr addrspace(5)
  %split_offset = getelementptr inbounds [33554432 x i8], ptr addrspace(5) %sgpr_base_align4, i32 0, i32 16842728
  %load = load volatile i32, ptr addrspace(5) %split_offset, align 4
  store i32 %load, ptr addrspace(1) %out
  ret void
}

define amdgpu_gs void @sgpr_base_plus_sgpr_plus_vgpr_plus_large_imm_offset(ptr addrspace(5) inreg %sgpr_base, i32 inreg %sidx, i32 %vidx) {
; GFX9-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_large_imm_offset:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s0, s5
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; GFX9-NEXT:    s_add_i32 s2, s2, s3
; GFX9-NEXT:    v_add_u32_e32 v0, s2, v0
; GFX9-NEXT:    v_add_u32_e32 v0, 0xffe8, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 15
; GFX9-NEXT:    scratch_store_dword v0, v1, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_large_imm_offset:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s0, s0, s5
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; GFX10-NEXT:    s_add_i32 s2, s2, s3
; GFX10-NEXT:    v_mov_b32_e32 v1, 15
; GFX10-NEXT:    v_add3_u32 v0, s2, v0, 0xffe8
; GFX10-NEXT:    scratch_store_dword v0, v1, off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_large_imm_offset:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_add_i32 s0, s0, s1
; GFX11-NEXT:    v_mov_b32_e32 v1, 15
; GFX11-NEXT:    v_add3_u32 v0, s0, v0, 0xffe8
; GFX11-NEXT:    scratch_store_b32 v0, v1, off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_large_imm_offset:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    v_mov_b32_e32 v1, 15
; GFX12-NEXT:    s_add_co_i32 s0, s0, s1
; GFX12-NEXT:    scratch_store_b32 v0, v1, s0 offset:65512 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    s_endpgm
;
; GFX9-PAL-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_large_imm_offset:
; GFX9-PAL:       ; %bb.0: ; %bb
; GFX9-PAL-NEXT:    s_getpc_b64 s[2:3]
; GFX9-PAL-NEXT:    s_mov_b32 s2, s8
; GFX9-PAL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX9-PAL-NEXT:    v_mov_b32_e32 v1, 15
; GFX9-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-PAL-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX9-PAL-NEXT:    s_add_u32 flat_scratch_lo, s2, s5
; GFX9-PAL-NEXT:    s_addc_u32 flat_scratch_hi, s3, 0
; GFX9-PAL-NEXT:    s_add_i32 s0, s0, s1
; GFX9-PAL-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX9-PAL-NEXT:    v_add_u32_e32 v0, 0xffe8, v0
; GFX9-PAL-NEXT:    scratch_store_dword v0, v1, off
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_endpgm
;
; GFX942-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_large_imm_offset:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_add_i32 s0, s0, s1
; GFX942-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX942-NEXT:    v_add_u32_e32 v0, 0xffe8, v0
; GFX942-NEXT:    v_mov_b32_e32 v1, 15
; GFX942-NEXT:    scratch_store_dword v0, v1, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_endpgm
;
; GFX10-PAL-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_large_imm_offset:
; GFX10-PAL:       ; %bb.0: ; %bb
; GFX10-PAL-NEXT:    s_getpc_b64 s[2:3]
; GFX10-PAL-NEXT:    s_mov_b32 s2, s8
; GFX10-PAL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX10-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-PAL-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX10-PAL-NEXT:    s_add_u32 s2, s2, s5
; GFX10-PAL-NEXT:    s_addc_u32 s3, s3, 0
; GFX10-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s2
; GFX10-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s3
; GFX10-PAL-NEXT:    s_add_i32 s0, s0, s1
; GFX10-PAL-NEXT:    v_mov_b32_e32 v1, 15
; GFX10-PAL-NEXT:    v_add3_u32 v0, s0, v0, 0xffe8
; GFX10-PAL-NEXT:    scratch_store_dword v0, v1, off
; GFX10-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-PAL-NEXT:    s_endpgm
;
; GFX11-PAL-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_large_imm_offset:
; GFX11-PAL:       ; %bb.0: ; %bb
; GFX11-PAL-NEXT:    s_add_i32 s0, s0, s1
; GFX11-PAL-NEXT:    v_mov_b32_e32 v1, 15
; GFX11-PAL-NEXT:    v_add3_u32 v0, s0, v0, 0xffe8
; GFX11-PAL-NEXT:    scratch_store_b32 v0, v1, off dlc
; GFX11-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-PAL-NEXT:    s_endpgm
;
; GFX12-PAL-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_large_imm_offset:
; GFX12-PAL:       ; %bb.0: ; %bb
; GFX12-PAL-NEXT:    v_mov_b32_e32 v1, 15
; GFX12-PAL-NEXT:    s_add_co_i32 s0, s0, s1
; GFX12-PAL-NEXT:    scratch_store_b32 v0, v1, s0 offset:65512 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    s_endpgm
bb:
  %add1 = add nsw i32 %sidx, %vidx
  %add2 = add nsw i32 %add1, 65512
  %gep = getelementptr inbounds [33554432 x i8], ptr addrspace(5) %sgpr_base, i32 0, i32 %add2
  store volatile i32 15, ptr addrspace(5) %gep, align 4
  ret void
}

define amdgpu_gs void @sgpr_base_plus_sgpr_plus_vgpr_plus_negative_imm_offset(ptr addrspace(5) inreg %sgpr_base, i32 inreg %sidx, i32 %vidx) {
; GFX9-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_negative_imm_offset:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s0, s5
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; GFX9-NEXT:    s_add_i32 s2, s2, s3
; GFX9-NEXT:    v_add_u32_e32 v0, s2, v0
; GFX9-NEXT:    v_add_u32_e32 v0, -16, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 15
; GFX9-NEXT:    scratch_store_dword v0, v1, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_negative_imm_offset:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s0, s0, s5
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; GFX10-NEXT:    v_add3_u32 v0, s2, s3, v0
; GFX10-NEXT:    v_mov_b32_e32 v1, 15
; GFX10-NEXT:    scratch_store_dword v0, v1, off offset:-16
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_negative_imm_offset:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    v_add3_u32 v0, s0, s1, v0
; GFX11-NEXT:    v_mov_b32_e32 v1, 15
; GFX11-NEXT:    scratch_store_b32 v0, v1, off offset:-16 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_negative_imm_offset:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    v_mov_b32_e32 v1, 15
; GFX12-NEXT:    s_add_co_i32 s0, s0, s1
; GFX12-NEXT:    scratch_store_b32 v0, v1, s0 offset:-16 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    s_endpgm
;
; GFX9-PAL-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_negative_imm_offset:
; GFX9-PAL:       ; %bb.0: ; %bb
; GFX9-PAL-NEXT:    s_getpc_b64 s[2:3]
; GFX9-PAL-NEXT:    s_mov_b32 s2, s8
; GFX9-PAL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX9-PAL-NEXT:    v_mov_b32_e32 v1, 15
; GFX9-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-PAL-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX9-PAL-NEXT:    s_add_u32 flat_scratch_lo, s2, s5
; GFX9-PAL-NEXT:    s_addc_u32 flat_scratch_hi, s3, 0
; GFX9-PAL-NEXT:    s_add_i32 s0, s0, s1
; GFX9-PAL-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX9-PAL-NEXT:    v_add_u32_e32 v0, -16, v0
; GFX9-PAL-NEXT:    scratch_store_dword v0, v1, off
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    s_endpgm
;
; GFX942-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_negative_imm_offset:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_add_i32 s0, s0, s1
; GFX942-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX942-NEXT:    v_add_u32_e32 v0, -16, v0
; GFX942-NEXT:    v_mov_b32_e32 v1, 15
; GFX942-NEXT:    scratch_store_dword v0, v1, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_endpgm
;
; GFX10-PAL-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_negative_imm_offset:
; GFX10-PAL:       ; %bb.0: ; %bb
; GFX10-PAL-NEXT:    s_getpc_b64 s[2:3]
; GFX10-PAL-NEXT:    s_mov_b32 s2, s8
; GFX10-PAL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX10-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-PAL-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX10-PAL-NEXT:    s_add_u32 s2, s2, s5
; GFX10-PAL-NEXT:    s_addc_u32 s3, s3, 0
; GFX10-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s2
; GFX10-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s3
; GFX10-PAL-NEXT:    v_add3_u32 v0, s0, s1, v0
; GFX10-PAL-NEXT:    v_mov_b32_e32 v1, 15
; GFX10-PAL-NEXT:    scratch_store_dword v0, v1, off offset:-16
; GFX10-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-PAL-NEXT:    s_endpgm
;
; GFX11-PAL-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_negative_imm_offset:
; GFX11-PAL:       ; %bb.0: ; %bb
; GFX11-PAL-NEXT:    v_add3_u32 v0, s0, s1, v0
; GFX11-PAL-NEXT:    v_mov_b32_e32 v1, 15
; GFX11-PAL-NEXT:    scratch_store_b32 v0, v1, off offset:-16 dlc
; GFX11-PAL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-PAL-NEXT:    s_endpgm
;
; GFX12-PAL-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_negative_imm_offset:
; GFX12-PAL:       ; %bb.0: ; %bb
; GFX12-PAL-NEXT:    v_mov_b32_e32 v1, 15
; GFX12-PAL-NEXT:    s_add_co_i32 s0, s0, s1
; GFX12-PAL-NEXT:    scratch_store_b32 v0, v1, s0 offset:-16 scope:SCOPE_SYS
; GFX12-PAL-NEXT:    s_wait_storecnt 0x0
; GFX12-PAL-NEXT:    s_endpgm
bb:
  %add1 = add nsw i32 %sidx, %vidx
  %add2 = add nsw i32 %add1, -16
  %gep = getelementptr inbounds [16 x i8], ptr addrspace(5) %sgpr_base, i32 0, i32 %add2
  store volatile i32 15, ptr addrspace(5) %gep, align 4
  ret void
}

define amdgpu_gs void @sgpr_base_negative_offset(ptr addrspace(1) %out, ptr addrspace(5) inreg %scevgep) {
; GFX9-LABEL: sgpr_base_negative_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s0, s5
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; GFX9-NEXT:    s_addk_i32 s2, 0xffe8
; GFX9-NEXT:    scratch_load_dword v2, off, s2
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: sgpr_base_negative_offset:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_add_u32 s0, s0, s5
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; GFX10-NEXT:    scratch_load_dword v2, off, s2 offset:-24
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: sgpr_base_negative_offset:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    scratch_load_b32 v2, off, s0 offset:-24
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b32 v[0:1], v2, off
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: sgpr_base_negative_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    scratch_load_b32 v2, off, s0 offset:-24
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_store_b32 v[0:1], v2, off
; GFX12-NEXT:    s_endpgm
;
; GFX9-PAL-LABEL: sgpr_base_negative_offset:
; GFX9-PAL:       ; %bb.0: ; %entry
; GFX9-PAL-NEXT:    s_getpc_b64 s[2:3]
; GFX9-PAL-NEXT:    s_mov_b32 s2, s8
; GFX9-PAL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX9-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-PAL-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX9-PAL-NEXT:    s_add_u32 flat_scratch_lo, s2, s5
; GFX9-PAL-NEXT:    s_addc_u32 flat_scratch_hi, s3, 0
; GFX9-PAL-NEXT:    s_addk_i32 s0, 0xffe8
; GFX9-PAL-NEXT:    scratch_load_dword v2, off, s0
; GFX9-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-PAL-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-PAL-NEXT:    s_endpgm
;
; GFX942-LABEL: sgpr_base_negative_offset:
; GFX942:       ; %bb.0: ; %entry
; GFX942-NEXT:    s_addk_i32 s0, 0xffe8
; GFX942-NEXT:    scratch_load_dword v2, off, s0
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    global_store_dword v[0:1], v2, off
; GFX942-NEXT:    s_endpgm
;
; GFX10-PAL-LABEL: sgpr_base_negative_offset:
; GFX10-PAL:       ; %bb.0: ; %entry
; GFX10-PAL-NEXT:    s_getpc_b64 s[2:3]
; GFX10-PAL-NEXT:    s_mov_b32 s2, s8
; GFX10-PAL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX10-PAL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-PAL-NEXT:    s_and_b32 s3, s3, 0xffff
; GFX10-PAL-NEXT:    s_add_u32 s2, s2, s5
; GFX10-PAL-NEXT:    s_addc_u32 s3, s3, 0
; GFX10-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s2
; GFX10-PAL-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s3
; GFX10-PAL-NEXT:    scratch_load_dword v2, off, s0 offset:-24
; GFX10-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-PAL-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-PAL-NEXT:    s_endpgm
;
; GFX11-PAL-LABEL: sgpr_base_negative_offset:
; GFX11-PAL:       ; %bb.0: ; %entry
; GFX11-PAL-NEXT:    scratch_load_b32 v2, off, s0 offset:-24
; GFX11-PAL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-PAL-NEXT:    global_store_b32 v[0:1], v2, off
; GFX11-PAL-NEXT:    s_endpgm
;
; GFX12-PAL-LABEL: sgpr_base_negative_offset:
; GFX12-PAL:       ; %bb.0: ; %entry
; GFX12-PAL-NEXT:    scratch_load_b32 v2, off, s0 offset:-24
; GFX12-PAL-NEXT:    s_wait_loadcnt 0x0
; GFX12-PAL-NEXT:    global_store_b32 v[0:1], v2, off
; GFX12-PAL-NEXT:    s_endpgm
entry:
  %scevgep28 = getelementptr i8, ptr addrspace(5) %scevgep, i32 -24
  %0 = load i32, ptr addrspace(5) %scevgep28, align 4
  store i32 %0, ptr addrspace(1) %out
  ret void
}

declare void @llvm.memset.p5.i64(ptr addrspace(5) nocapture writeonly, i8, i64, i1 immarg)
declare i32 @llvm.amdgcn.workitem.id.x()
