/*

Copyright (C) 2015-2018 Olaf Till <i7tiol@t-online.de>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef __OCT_PARALLEL_GNUTLS__

#define __OCT_PARALLEL_GNUTLS__

// to have Octaves config.h included before config.h of 'parallel'
#include <octave/oct.h>

#include "config.h"

#ifdef HAVE_LIBGNUTLS
#include <gnutls/gnutls.h>
#endif

#include <sys/stat.h>

#include <sys/types.h>

#include <fcntl.h>

#include <errno.h>

#include <stdio.h>

#include <unistd.h>

#include <stdint.h>

// We link against the gnulib num_processors() used by Octave. nproc.h
// used by Octave is not accessible. If the interface changes, this
// will stop working.
extern "C" {
enum nproc_query
{
  NPROC_ALL,                 /* total number of processors */
  NPROC_CURRENT,             /* processors available to the current process */
  NPROC_CURRENT_OVERRIDABLE  /* likewise, but overridable through the
                                OMP_NUM_THREADS environment variable */
};

/* Return the total number of processors.  The result is guaranteed to
   be at least 1.  */
extern unsigned long int num_processors (enum nproc_query query);
}


// Octave includes

#include <octave/oct.h>

#include <octave/file-stat.h>

#include <octave/file-ops.h>

#include <octave/parse.h>

#include <octave/ov-struct.h>


#define N_CONNECT_RETRIES 10

// parallel package includes

#include "parallel-gnutls-nonoctave.h"

#include "error-helpers.h"

#ifdef HAVE_LIBGNUTLS
#include "sensitive-data.h"
#endif

#include "gnulib-wrappers.h"

#include "p-pipes.h"

#include "p-streams.h"

#include "p-connection.h"

#include "p-sighandler.h"

#include "minimal-load-save.h"

#include "p-control.h"

#ifdef HAVE_LIBGNUTLS
void parallel_gnutls_set_mem_functions (void);
#endif

#endif // __OCT_PARALLEL_GNUTLS__
