
struct pyopencv_AKAZE_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_AKAZE_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".AKAZE",
    sizeof(pyopencv_AKAZE_t),
};

static void pyopencv_AKAZE_dealloc(PyObject* self)
{
    ((pyopencv_AKAZE_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::AKAZE>& r)
{
    pyopencv_AKAZE_t *m = PyObject_NEW(pyopencv_AKAZE_t, &pyopencv_AKAZE_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::AKAZE>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_AKAZE_Type))
    {
        failmsg("Expected cv::AKAZE for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_AKAZE_t*)src)->v.dynamicCast<cv::AKAZE>();
    return true;
}


struct pyopencv_AffineTransformer_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_AffineTransformer_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".AffineTransformer",
    sizeof(pyopencv_AffineTransformer_t),
};

static void pyopencv_AffineTransformer_dealloc(PyObject* self)
{
    ((pyopencv_AffineTransformer_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::AffineTransformer>& r)
{
    pyopencv_AffineTransformer_t *m = PyObject_NEW(pyopencv_AffineTransformer_t, &pyopencv_AffineTransformer_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::AffineTransformer>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_AffineTransformer_Type))
    {
        failmsg("Expected cv::AffineTransformer for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_AffineTransformer_t*)src)->v.dynamicCast<cv::AffineTransformer>();
    return true;
}


struct pyopencv_AgastFeatureDetector_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_AgastFeatureDetector_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".AgastFeatureDetector",
    sizeof(pyopencv_AgastFeatureDetector_t),
};

static void pyopencv_AgastFeatureDetector_dealloc(PyObject* self)
{
    ((pyopencv_AgastFeatureDetector_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::AgastFeatureDetector>& r)
{
    pyopencv_AgastFeatureDetector_t *m = PyObject_NEW(pyopencv_AgastFeatureDetector_t, &pyopencv_AgastFeatureDetector_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::AgastFeatureDetector>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_AgastFeatureDetector_Type))
    {
        failmsg("Expected cv::AgastFeatureDetector for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_AgastFeatureDetector_t*)src)->v.dynamicCast<cv::AgastFeatureDetector>();
    return true;
}


struct pyopencv_Algorithm_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_Algorithm_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".Algorithm",
    sizeof(pyopencv_Algorithm_t),
};

static void pyopencv_Algorithm_dealloc(PyObject* self)
{
    ((pyopencv_Algorithm_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::Algorithm>& r)
{
    pyopencv_Algorithm_t *m = PyObject_NEW(pyopencv_Algorithm_t, &pyopencv_Algorithm_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::Algorithm>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_Algorithm_Type))
    {
        failmsg("Expected cv::Algorithm for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_Algorithm_t*)src)->v.dynamicCast<cv::Algorithm>();
    return true;
}


struct pyopencv_AlignExposures_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_AlignExposures_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".AlignExposures",
    sizeof(pyopencv_AlignExposures_t),
};

static void pyopencv_AlignExposures_dealloc(PyObject* self)
{
    ((pyopencv_AlignExposures_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::AlignExposures>& r)
{
    pyopencv_AlignExposures_t *m = PyObject_NEW(pyopencv_AlignExposures_t, &pyopencv_AlignExposures_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::AlignExposures>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_AlignExposures_Type))
    {
        failmsg("Expected cv::AlignExposures for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_AlignExposures_t*)src)->v.dynamicCast<cv::AlignExposures>();
    return true;
}


struct pyopencv_AlignMTB_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_AlignMTB_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".AlignMTB",
    sizeof(pyopencv_AlignMTB_t),
};

static void pyopencv_AlignMTB_dealloc(PyObject* self)
{
    ((pyopencv_AlignMTB_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::AlignMTB>& r)
{
    pyopencv_AlignMTB_t *m = PyObject_NEW(pyopencv_AlignMTB_t, &pyopencv_AlignMTB_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::AlignMTB>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_AlignMTB_Type))
    {
        failmsg("Expected cv::AlignMTB for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_AlignMTB_t*)src)->v.dynamicCast<cv::AlignMTB>();
    return true;
}


struct pyopencv_BFMatcher_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_BFMatcher_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".BFMatcher",
    sizeof(pyopencv_BFMatcher_t),
};

static void pyopencv_BFMatcher_dealloc(PyObject* self)
{
    ((pyopencv_BFMatcher_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::BFMatcher>& r)
{
    pyopencv_BFMatcher_t *m = PyObject_NEW(pyopencv_BFMatcher_t, &pyopencv_BFMatcher_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::BFMatcher>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_BFMatcher_Type))
    {
        failmsg("Expected cv::BFMatcher for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_BFMatcher_t*)src)->v.dynamicCast<cv::BFMatcher>();
    return true;
}


struct pyopencv_BOWImgDescriptorExtractor_t
{
    PyObject_HEAD
    Ptr<cv::BOWImgDescriptorExtractor> v;
};

static PyTypeObject pyopencv_BOWImgDescriptorExtractor_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".BOWImgDescriptorExtractor",
    sizeof(pyopencv_BOWImgDescriptorExtractor_t),
};

static void pyopencv_BOWImgDescriptorExtractor_dealloc(PyObject* self)
{
    ((pyopencv_BOWImgDescriptorExtractor_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::BOWImgDescriptorExtractor>& r)
{
    pyopencv_BOWImgDescriptorExtractor_t *m = PyObject_NEW(pyopencv_BOWImgDescriptorExtractor_t, &pyopencv_BOWImgDescriptorExtractor_Type);
    new (&(m->v)) Ptr<cv::BOWImgDescriptorExtractor>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::BOWImgDescriptorExtractor>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_BOWImgDescriptorExtractor_Type))
    {
        failmsg("Expected cv::BOWImgDescriptorExtractor for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_BOWImgDescriptorExtractor_t*)src)->v.dynamicCast<cv::BOWImgDescriptorExtractor>();
    return true;
}


struct pyopencv_BOWKMeansTrainer_t
{
    PyObject_HEAD
    Ptr<cv::BOWKMeansTrainer> v;
};

static PyTypeObject pyopencv_BOWKMeansTrainer_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".BOWKMeansTrainer",
    sizeof(pyopencv_BOWKMeansTrainer_t),
};

static void pyopencv_BOWKMeansTrainer_dealloc(PyObject* self)
{
    ((pyopencv_BOWKMeansTrainer_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::BOWKMeansTrainer>& r)
{
    pyopencv_BOWKMeansTrainer_t *m = PyObject_NEW(pyopencv_BOWKMeansTrainer_t, &pyopencv_BOWKMeansTrainer_Type);
    new (&(m->v)) Ptr<cv::BOWKMeansTrainer>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::BOWKMeansTrainer>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_BOWKMeansTrainer_Type))
    {
        failmsg("Expected cv::BOWKMeansTrainer for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_BOWKMeansTrainer_t*)src)->v.dynamicCast<cv::BOWKMeansTrainer>();
    return true;
}


struct pyopencv_BOWTrainer_t
{
    PyObject_HEAD
    Ptr<cv::BOWTrainer> v;
};

static PyTypeObject pyopencv_BOWTrainer_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".BOWTrainer",
    sizeof(pyopencv_BOWTrainer_t),
};

static void pyopencv_BOWTrainer_dealloc(PyObject* self)
{
    ((pyopencv_BOWTrainer_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::BOWTrainer>& r)
{
    pyopencv_BOWTrainer_t *m = PyObject_NEW(pyopencv_BOWTrainer_t, &pyopencv_BOWTrainer_Type);
    new (&(m->v)) Ptr<cv::BOWTrainer>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::BOWTrainer>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_BOWTrainer_Type))
    {
        failmsg("Expected cv::BOWTrainer for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_BOWTrainer_t*)src)->v.dynamicCast<cv::BOWTrainer>();
    return true;
}


struct pyopencv_BRISK_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_BRISK_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".BRISK",
    sizeof(pyopencv_BRISK_t),
};

static void pyopencv_BRISK_dealloc(PyObject* self)
{
    ((pyopencv_BRISK_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::BRISK>& r)
{
    pyopencv_BRISK_t *m = PyObject_NEW(pyopencv_BRISK_t, &pyopencv_BRISK_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::BRISK>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_BRISK_Type))
    {
        failmsg("Expected cv::BRISK for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_BRISK_t*)src)->v.dynamicCast<cv::BRISK>();
    return true;
}


struct pyopencv_BackgroundSubtractor_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_BackgroundSubtractor_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".BackgroundSubtractor",
    sizeof(pyopencv_BackgroundSubtractor_t),
};

static void pyopencv_BackgroundSubtractor_dealloc(PyObject* self)
{
    ((pyopencv_BackgroundSubtractor_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::BackgroundSubtractor>& r)
{
    pyopencv_BackgroundSubtractor_t *m = PyObject_NEW(pyopencv_BackgroundSubtractor_t, &pyopencv_BackgroundSubtractor_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::BackgroundSubtractor>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_BackgroundSubtractor_Type))
    {
        failmsg("Expected cv::BackgroundSubtractor for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_BackgroundSubtractor_t*)src)->v.dynamicCast<cv::BackgroundSubtractor>();
    return true;
}


struct pyopencv_BackgroundSubtractorKNN_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_BackgroundSubtractorKNN_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".BackgroundSubtractorKNN",
    sizeof(pyopencv_BackgroundSubtractorKNN_t),
};

static void pyopencv_BackgroundSubtractorKNN_dealloc(PyObject* self)
{
    ((pyopencv_BackgroundSubtractorKNN_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::BackgroundSubtractorKNN>& r)
{
    pyopencv_BackgroundSubtractorKNN_t *m = PyObject_NEW(pyopencv_BackgroundSubtractorKNN_t, &pyopencv_BackgroundSubtractorKNN_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::BackgroundSubtractorKNN>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_BackgroundSubtractorKNN_Type))
    {
        failmsg("Expected cv::BackgroundSubtractorKNN for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_BackgroundSubtractorKNN_t*)src)->v.dynamicCast<cv::BackgroundSubtractorKNN>();
    return true;
}


struct pyopencv_BackgroundSubtractorMOG2_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_BackgroundSubtractorMOG2_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".BackgroundSubtractorMOG2",
    sizeof(pyopencv_BackgroundSubtractorMOG2_t),
};

static void pyopencv_BackgroundSubtractorMOG2_dealloc(PyObject* self)
{
    ((pyopencv_BackgroundSubtractorMOG2_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::BackgroundSubtractorMOG2>& r)
{
    pyopencv_BackgroundSubtractorMOG2_t *m = PyObject_NEW(pyopencv_BackgroundSubtractorMOG2_t, &pyopencv_BackgroundSubtractorMOG2_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::BackgroundSubtractorMOG2>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_BackgroundSubtractorMOG2_Type))
    {
        failmsg("Expected cv::BackgroundSubtractorMOG2 for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_BackgroundSubtractorMOG2_t*)src)->v.dynamicCast<cv::BackgroundSubtractorMOG2>();
    return true;
}


struct pyopencv_BaseCascadeClassifier_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_BaseCascadeClassifier_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".BaseCascadeClassifier",
    sizeof(pyopencv_BaseCascadeClassifier_t),
};

static void pyopencv_BaseCascadeClassifier_dealloc(PyObject* self)
{
    ((pyopencv_BaseCascadeClassifier_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::BaseCascadeClassifier>& r)
{
    pyopencv_BaseCascadeClassifier_t *m = PyObject_NEW(pyopencv_BaseCascadeClassifier_t, &pyopencv_BaseCascadeClassifier_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::BaseCascadeClassifier>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_BaseCascadeClassifier_Type))
    {
        failmsg("Expected cv::BaseCascadeClassifier for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_BaseCascadeClassifier_t*)src)->v.dynamicCast<cv::BaseCascadeClassifier>();
    return true;
}


struct pyopencv_CLAHE_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_CLAHE_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".CLAHE",
    sizeof(pyopencv_CLAHE_t),
};

static void pyopencv_CLAHE_dealloc(PyObject* self)
{
    ((pyopencv_CLAHE_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::CLAHE>& r)
{
    pyopencv_CLAHE_t *m = PyObject_NEW(pyopencv_CLAHE_t, &pyopencv_CLAHE_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::CLAHE>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_CLAHE_Type))
    {
        failmsg("Expected cv::CLAHE for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_CLAHE_t*)src)->v.dynamicCast<cv::CLAHE>();
    return true;
}


struct pyopencv_CalibrateCRF_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_CalibrateCRF_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".CalibrateCRF",
    sizeof(pyopencv_CalibrateCRF_t),
};

static void pyopencv_CalibrateCRF_dealloc(PyObject* self)
{
    ((pyopencv_CalibrateCRF_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::CalibrateCRF>& r)
{
    pyopencv_CalibrateCRF_t *m = PyObject_NEW(pyopencv_CalibrateCRF_t, &pyopencv_CalibrateCRF_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::CalibrateCRF>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_CalibrateCRF_Type))
    {
        failmsg("Expected cv::CalibrateCRF for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_CalibrateCRF_t*)src)->v.dynamicCast<cv::CalibrateCRF>();
    return true;
}


struct pyopencv_CalibrateDebevec_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_CalibrateDebevec_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".CalibrateDebevec",
    sizeof(pyopencv_CalibrateDebevec_t),
};

static void pyopencv_CalibrateDebevec_dealloc(PyObject* self)
{
    ((pyopencv_CalibrateDebevec_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::CalibrateDebevec>& r)
{
    pyopencv_CalibrateDebevec_t *m = PyObject_NEW(pyopencv_CalibrateDebevec_t, &pyopencv_CalibrateDebevec_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::CalibrateDebevec>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_CalibrateDebevec_Type))
    {
        failmsg("Expected cv::CalibrateDebevec for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_CalibrateDebevec_t*)src)->v.dynamicCast<cv::CalibrateDebevec>();
    return true;
}


struct pyopencv_CalibrateRobertson_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_CalibrateRobertson_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".CalibrateRobertson",
    sizeof(pyopencv_CalibrateRobertson_t),
};

static void pyopencv_CalibrateRobertson_dealloc(PyObject* self)
{
    ((pyopencv_CalibrateRobertson_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::CalibrateRobertson>& r)
{
    pyopencv_CalibrateRobertson_t *m = PyObject_NEW(pyopencv_CalibrateRobertson_t, &pyopencv_CalibrateRobertson_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::CalibrateRobertson>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_CalibrateRobertson_Type))
    {
        failmsg("Expected cv::CalibrateRobertson for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_CalibrateRobertson_t*)src)->v.dynamicCast<cv::CalibrateRobertson>();
    return true;
}


struct pyopencv_CascadeClassifier_t
{
    PyObject_HEAD
    Ptr<cv::CascadeClassifier> v;
};

static PyTypeObject pyopencv_CascadeClassifier_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".CascadeClassifier",
    sizeof(pyopencv_CascadeClassifier_t),
};

static void pyopencv_CascadeClassifier_dealloc(PyObject* self)
{
    ((pyopencv_CascadeClassifier_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::CascadeClassifier>& r)
{
    pyopencv_CascadeClassifier_t *m = PyObject_NEW(pyopencv_CascadeClassifier_t, &pyopencv_CascadeClassifier_Type);
    new (&(m->v)) Ptr<cv::CascadeClassifier>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::CascadeClassifier>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_CascadeClassifier_Type))
    {
        failmsg("Expected cv::CascadeClassifier for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_CascadeClassifier_t*)src)->v.dynamicCast<cv::CascadeClassifier>();
    return true;
}


struct pyopencv_ChiHistogramCostExtractor_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ChiHistogramCostExtractor_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ChiHistogramCostExtractor",
    sizeof(pyopencv_ChiHistogramCostExtractor_t),
};

static void pyopencv_ChiHistogramCostExtractor_dealloc(PyObject* self)
{
    ((pyopencv_ChiHistogramCostExtractor_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ChiHistogramCostExtractor>& r)
{
    pyopencv_ChiHistogramCostExtractor_t *m = PyObject_NEW(pyopencv_ChiHistogramCostExtractor_t, &pyopencv_ChiHistogramCostExtractor_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ChiHistogramCostExtractor>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ChiHistogramCostExtractor_Type))
    {
        failmsg("Expected cv::ChiHistogramCostExtractor for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ChiHistogramCostExtractor_t*)src)->v.dynamicCast<cv::ChiHistogramCostExtractor>();
    return true;
}


struct pyopencv_CirclesGridFinderParameters_t
{
    PyObject_HEAD
    cv::CirclesGridFinderParameters v;
};

static PyTypeObject pyopencv_CirclesGridFinderParameters_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".CirclesGridFinderParameters",
    sizeof(pyopencv_CirclesGridFinderParameters_t),
};

static void pyopencv_CirclesGridFinderParameters_dealloc(PyObject* self)
{
    ((pyopencv_CirclesGridFinderParameters_t*)self)->v.cv::CirclesGridFinderParameters::~CirclesGridFinderParameters();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const cv::CirclesGridFinderParameters& r)
{
    pyopencv_CirclesGridFinderParameters_t *m = PyObject_NEW(pyopencv_CirclesGridFinderParameters_t, &pyopencv_CirclesGridFinderParameters_Type);
    new (&m->v) cv::CirclesGridFinderParameters(r); //Copy constructor
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, cv::CirclesGridFinderParameters& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_CirclesGridFinderParameters_Type))
    {
        failmsg("Expected cv::CirclesGridFinderParameters for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_CirclesGridFinderParameters_t*)src)->v;
    return true;
}

struct pyopencv_CirclesGridFinderParameters2_t
{
    PyObject_HEAD
    cv::CirclesGridFinderParameters2 v;
};

static PyTypeObject pyopencv_CirclesGridFinderParameters2_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".CirclesGridFinderParameters2",
    sizeof(pyopencv_CirclesGridFinderParameters2_t),
};

static void pyopencv_CirclesGridFinderParameters2_dealloc(PyObject* self)
{
    ((pyopencv_CirclesGridFinderParameters2_t*)self)->v.cv::CirclesGridFinderParameters2::~CirclesGridFinderParameters2();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const cv::CirclesGridFinderParameters2& r)
{
    pyopencv_CirclesGridFinderParameters2_t *m = PyObject_NEW(pyopencv_CirclesGridFinderParameters2_t, &pyopencv_CirclesGridFinderParameters2_Type);
    new (&m->v) cv::CirclesGridFinderParameters2(r); //Copy constructor
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, cv::CirclesGridFinderParameters2& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_CirclesGridFinderParameters2_Type))
    {
        failmsg("Expected cv::CirclesGridFinderParameters2 for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_CirclesGridFinderParameters2_t*)src)->v;
    return true;
}

struct pyopencv_DMatch_t
{
    PyObject_HEAD
    cv::DMatch v;
};

static PyTypeObject pyopencv_DMatch_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".DMatch",
    sizeof(pyopencv_DMatch_t),
};

static void pyopencv_DMatch_dealloc(PyObject* self)
{
    ((pyopencv_DMatch_t*)self)->v.cv::DMatch::~DMatch();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const cv::DMatch& r)
{
    pyopencv_DMatch_t *m = PyObject_NEW(pyopencv_DMatch_t, &pyopencv_DMatch_Type);
    new (&m->v) cv::DMatch(r); //Copy constructor
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, cv::DMatch& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_DMatch_Type))
    {
        failmsg("Expected cv::DMatch for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_DMatch_t*)src)->v;
    return true;
}

struct pyopencv_DenseOpticalFlow_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_DenseOpticalFlow_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".DenseOpticalFlow",
    sizeof(pyopencv_DenseOpticalFlow_t),
};

static void pyopencv_DenseOpticalFlow_dealloc(PyObject* self)
{
    ((pyopencv_DenseOpticalFlow_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::DenseOpticalFlow>& r)
{
    pyopencv_DenseOpticalFlow_t *m = PyObject_NEW(pyopencv_DenseOpticalFlow_t, &pyopencv_DenseOpticalFlow_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::DenseOpticalFlow>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_DenseOpticalFlow_Type))
    {
        failmsg("Expected cv::DenseOpticalFlow for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_DenseOpticalFlow_t*)src)->v.dynamicCast<cv::DenseOpticalFlow>();
    return true;
}


struct pyopencv_DescriptorMatcher_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_DescriptorMatcher_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".DescriptorMatcher",
    sizeof(pyopencv_DescriptorMatcher_t),
};

static void pyopencv_DescriptorMatcher_dealloc(PyObject* self)
{
    ((pyopencv_DescriptorMatcher_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::DescriptorMatcher>& r)
{
    pyopencv_DescriptorMatcher_t *m = PyObject_NEW(pyopencv_DescriptorMatcher_t, &pyopencv_DescriptorMatcher_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::DescriptorMatcher>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_DescriptorMatcher_Type))
    {
        failmsg("Expected cv::DescriptorMatcher for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_DescriptorMatcher_t*)src)->v.dynamicCast<cv::DescriptorMatcher>();
    return true;
}


struct pyopencv_DualTVL1OpticalFlow_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_DualTVL1OpticalFlow_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".DualTVL1OpticalFlow",
    sizeof(pyopencv_DualTVL1OpticalFlow_t),
};

static void pyopencv_DualTVL1OpticalFlow_dealloc(PyObject* self)
{
    ((pyopencv_DualTVL1OpticalFlow_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::DualTVL1OpticalFlow>& r)
{
    pyopencv_DualTVL1OpticalFlow_t *m = PyObject_NEW(pyopencv_DualTVL1OpticalFlow_t, &pyopencv_DualTVL1OpticalFlow_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::DualTVL1OpticalFlow>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_DualTVL1OpticalFlow_Type))
    {
        failmsg("Expected cv::DualTVL1OpticalFlow for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_DualTVL1OpticalFlow_t*)src)->v.dynamicCast<cv::DualTVL1OpticalFlow>();
    return true;
}


struct pyopencv_EMDHistogramCostExtractor_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_EMDHistogramCostExtractor_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".EMDHistogramCostExtractor",
    sizeof(pyopencv_EMDHistogramCostExtractor_t),
};

static void pyopencv_EMDHistogramCostExtractor_dealloc(PyObject* self)
{
    ((pyopencv_EMDHistogramCostExtractor_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::EMDHistogramCostExtractor>& r)
{
    pyopencv_EMDHistogramCostExtractor_t *m = PyObject_NEW(pyopencv_EMDHistogramCostExtractor_t, &pyopencv_EMDHistogramCostExtractor_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::EMDHistogramCostExtractor>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_EMDHistogramCostExtractor_Type))
    {
        failmsg("Expected cv::EMDHistogramCostExtractor for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_EMDHistogramCostExtractor_t*)src)->v.dynamicCast<cv::EMDHistogramCostExtractor>();
    return true;
}


struct pyopencv_EMDL1HistogramCostExtractor_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_EMDL1HistogramCostExtractor_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".EMDL1HistogramCostExtractor",
    sizeof(pyopencv_EMDL1HistogramCostExtractor_t),
};

static void pyopencv_EMDL1HistogramCostExtractor_dealloc(PyObject* self)
{
    ((pyopencv_EMDL1HistogramCostExtractor_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::EMDL1HistogramCostExtractor>& r)
{
    pyopencv_EMDL1HistogramCostExtractor_t *m = PyObject_NEW(pyopencv_EMDL1HistogramCostExtractor_t, &pyopencv_EMDL1HistogramCostExtractor_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::EMDL1HistogramCostExtractor>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_EMDL1HistogramCostExtractor_Type))
    {
        failmsg("Expected cv::EMDL1HistogramCostExtractor for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_EMDL1HistogramCostExtractor_t*)src)->v.dynamicCast<cv::EMDL1HistogramCostExtractor>();
    return true;
}


struct pyopencv_FarnebackOpticalFlow_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_FarnebackOpticalFlow_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".FarnebackOpticalFlow",
    sizeof(pyopencv_FarnebackOpticalFlow_t),
};

static void pyopencv_FarnebackOpticalFlow_dealloc(PyObject* self)
{
    ((pyopencv_FarnebackOpticalFlow_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::FarnebackOpticalFlow>& r)
{
    pyopencv_FarnebackOpticalFlow_t *m = PyObject_NEW(pyopencv_FarnebackOpticalFlow_t, &pyopencv_FarnebackOpticalFlow_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::FarnebackOpticalFlow>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_FarnebackOpticalFlow_Type))
    {
        failmsg("Expected cv::FarnebackOpticalFlow for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_FarnebackOpticalFlow_t*)src)->v.dynamicCast<cv::FarnebackOpticalFlow>();
    return true;
}


struct pyopencv_FastFeatureDetector_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_FastFeatureDetector_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".FastFeatureDetector",
    sizeof(pyopencv_FastFeatureDetector_t),
};

static void pyopencv_FastFeatureDetector_dealloc(PyObject* self)
{
    ((pyopencv_FastFeatureDetector_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::FastFeatureDetector>& r)
{
    pyopencv_FastFeatureDetector_t *m = PyObject_NEW(pyopencv_FastFeatureDetector_t, &pyopencv_FastFeatureDetector_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::FastFeatureDetector>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_FastFeatureDetector_Type))
    {
        failmsg("Expected cv::FastFeatureDetector for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_FastFeatureDetector_t*)src)->v.dynamicCast<cv::FastFeatureDetector>();
    return true;
}


struct pyopencv_Feature2D_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_Feature2D_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".Feature2D",
    sizeof(pyopencv_Feature2D_t),
};

static void pyopencv_Feature2D_dealloc(PyObject* self)
{
    ((pyopencv_Feature2D_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::Feature2D>& r)
{
    pyopencv_Feature2D_t *m = PyObject_NEW(pyopencv_Feature2D_t, &pyopencv_Feature2D_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::Feature2D>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_Feature2D_Type))
    {
        failmsg("Expected cv::Feature2D for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_Feature2D_t*)src)->v.dynamicCast<cv::Feature2D>();
    return true;
}


struct pyopencv_FileNode_t
{
    PyObject_HEAD
    cv::FileNode v;
};

static PyTypeObject pyopencv_FileNode_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".FileNode",
    sizeof(pyopencv_FileNode_t),
};

static void pyopencv_FileNode_dealloc(PyObject* self)
{
    ((pyopencv_FileNode_t*)self)->v.cv::FileNode::~FileNode();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const cv::FileNode& r)
{
    pyopencv_FileNode_t *m = PyObject_NEW(pyopencv_FileNode_t, &pyopencv_FileNode_Type);
    new (&m->v) cv::FileNode(r); //Copy constructor
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, cv::FileNode& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_FileNode_Type))
    {
        failmsg("Expected cv::FileNode for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_FileNode_t*)src)->v;
    return true;
}

struct pyopencv_FileStorage_t
{
    PyObject_HEAD
    Ptr<cv::FileStorage> v;
};

static PyTypeObject pyopencv_FileStorage_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".FileStorage",
    sizeof(pyopencv_FileStorage_t),
};

static void pyopencv_FileStorage_dealloc(PyObject* self)
{
    ((pyopencv_FileStorage_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::FileStorage>& r)
{
    pyopencv_FileStorage_t *m = PyObject_NEW(pyopencv_FileStorage_t, &pyopencv_FileStorage_Type);
    new (&(m->v)) Ptr<cv::FileStorage>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::FileStorage>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_FileStorage_Type))
    {
        failmsg("Expected cv::FileStorage for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_FileStorage_t*)src)->v.dynamicCast<cv::FileStorage>();
    return true;
}


struct pyopencv_FlannBasedMatcher_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_FlannBasedMatcher_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".FlannBasedMatcher",
    sizeof(pyopencv_FlannBasedMatcher_t),
};

static void pyopencv_FlannBasedMatcher_dealloc(PyObject* self)
{
    ((pyopencv_FlannBasedMatcher_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::FlannBasedMatcher>& r)
{
    pyopencv_FlannBasedMatcher_t *m = PyObject_NEW(pyopencv_FlannBasedMatcher_t, &pyopencv_FlannBasedMatcher_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::FlannBasedMatcher>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_FlannBasedMatcher_Type))
    {
        failmsg("Expected cv::FlannBasedMatcher for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_FlannBasedMatcher_t*)src)->v.dynamicCast<cv::FlannBasedMatcher>();
    return true;
}


struct pyopencv_GFTTDetector_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_GFTTDetector_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".GFTTDetector",
    sizeof(pyopencv_GFTTDetector_t),
};

static void pyopencv_GFTTDetector_dealloc(PyObject* self)
{
    ((pyopencv_GFTTDetector_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::GFTTDetector>& r)
{
    pyopencv_GFTTDetector_t *m = PyObject_NEW(pyopencv_GFTTDetector_t, &pyopencv_GFTTDetector_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::GFTTDetector>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_GFTTDetector_Type))
    {
        failmsg("Expected cv::GFTTDetector for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_GFTTDetector_t*)src)->v.dynamicCast<cv::GFTTDetector>();
    return true;
}


struct pyopencv_HOGDescriptor_t
{
    PyObject_HEAD
    Ptr<cv::HOGDescriptor> v;
};

static PyTypeObject pyopencv_HOGDescriptor_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".HOGDescriptor",
    sizeof(pyopencv_HOGDescriptor_t),
};

static void pyopencv_HOGDescriptor_dealloc(PyObject* self)
{
    ((pyopencv_HOGDescriptor_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::HOGDescriptor>& r)
{
    pyopencv_HOGDescriptor_t *m = PyObject_NEW(pyopencv_HOGDescriptor_t, &pyopencv_HOGDescriptor_Type);
    new (&(m->v)) Ptr<cv::HOGDescriptor>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::HOGDescriptor>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_HOGDescriptor_Type))
    {
        failmsg("Expected cv::HOGDescriptor for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_HOGDescriptor_t*)src)->v.dynamicCast<cv::HOGDescriptor>();
    return true;
}


struct pyopencv_HausdorffDistanceExtractor_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_HausdorffDistanceExtractor_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".HausdorffDistanceExtractor",
    sizeof(pyopencv_HausdorffDistanceExtractor_t),
};

static void pyopencv_HausdorffDistanceExtractor_dealloc(PyObject* self)
{
    ((pyopencv_HausdorffDistanceExtractor_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::HausdorffDistanceExtractor>& r)
{
    pyopencv_HausdorffDistanceExtractor_t *m = PyObject_NEW(pyopencv_HausdorffDistanceExtractor_t, &pyopencv_HausdorffDistanceExtractor_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::HausdorffDistanceExtractor>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_HausdorffDistanceExtractor_Type))
    {
        failmsg("Expected cv::HausdorffDistanceExtractor for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_HausdorffDistanceExtractor_t*)src)->v.dynamicCast<cv::HausdorffDistanceExtractor>();
    return true;
}


struct pyopencv_HistogramCostExtractor_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_HistogramCostExtractor_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".HistogramCostExtractor",
    sizeof(pyopencv_HistogramCostExtractor_t),
};

static void pyopencv_HistogramCostExtractor_dealloc(PyObject* self)
{
    ((pyopencv_HistogramCostExtractor_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::HistogramCostExtractor>& r)
{
    pyopencv_HistogramCostExtractor_t *m = PyObject_NEW(pyopencv_HistogramCostExtractor_t, &pyopencv_HistogramCostExtractor_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::HistogramCostExtractor>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_HistogramCostExtractor_Type))
    {
        failmsg("Expected cv::HistogramCostExtractor for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_HistogramCostExtractor_t*)src)->v.dynamicCast<cv::HistogramCostExtractor>();
    return true;
}


struct pyopencv_KAZE_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_KAZE_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".KAZE",
    sizeof(pyopencv_KAZE_t),
};

static void pyopencv_KAZE_dealloc(PyObject* self)
{
    ((pyopencv_KAZE_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::KAZE>& r)
{
    pyopencv_KAZE_t *m = PyObject_NEW(pyopencv_KAZE_t, &pyopencv_KAZE_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::KAZE>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_KAZE_Type))
    {
        failmsg("Expected cv::KAZE for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_KAZE_t*)src)->v.dynamicCast<cv::KAZE>();
    return true;
}


struct pyopencv_KalmanFilter_t
{
    PyObject_HEAD
    Ptr<cv::KalmanFilter> v;
};

static PyTypeObject pyopencv_KalmanFilter_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".KalmanFilter",
    sizeof(pyopencv_KalmanFilter_t),
};

static void pyopencv_KalmanFilter_dealloc(PyObject* self)
{
    ((pyopencv_KalmanFilter_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::KalmanFilter>& r)
{
    pyopencv_KalmanFilter_t *m = PyObject_NEW(pyopencv_KalmanFilter_t, &pyopencv_KalmanFilter_Type);
    new (&(m->v)) Ptr<cv::KalmanFilter>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::KalmanFilter>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_KalmanFilter_Type))
    {
        failmsg("Expected cv::KalmanFilter for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_KalmanFilter_t*)src)->v.dynamicCast<cv::KalmanFilter>();
    return true;
}


struct pyopencv_KeyPoint_t
{
    PyObject_HEAD
    cv::KeyPoint v;
};

static PyTypeObject pyopencv_KeyPoint_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".KeyPoint",
    sizeof(pyopencv_KeyPoint_t),
};

static void pyopencv_KeyPoint_dealloc(PyObject* self)
{
    ((pyopencv_KeyPoint_t*)self)->v.cv::KeyPoint::~KeyPoint();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const cv::KeyPoint& r)
{
    pyopencv_KeyPoint_t *m = PyObject_NEW(pyopencv_KeyPoint_t, &pyopencv_KeyPoint_Type);
    new (&m->v) cv::KeyPoint(r); //Copy constructor
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, cv::KeyPoint& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_KeyPoint_Type))
    {
        failmsg("Expected cv::KeyPoint for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_KeyPoint_t*)src)->v;
    return true;
}

struct pyopencv_LineSegmentDetector_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_LineSegmentDetector_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".LineSegmentDetector",
    sizeof(pyopencv_LineSegmentDetector_t),
};

static void pyopencv_LineSegmentDetector_dealloc(PyObject* self)
{
    ((pyopencv_LineSegmentDetector_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::LineSegmentDetector>& r)
{
    pyopencv_LineSegmentDetector_t *m = PyObject_NEW(pyopencv_LineSegmentDetector_t, &pyopencv_LineSegmentDetector_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::LineSegmentDetector>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_LineSegmentDetector_Type))
    {
        failmsg("Expected cv::LineSegmentDetector for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_LineSegmentDetector_t*)src)->v.dynamicCast<cv::LineSegmentDetector>();
    return true;
}


struct pyopencv_MSER_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_MSER_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".MSER",
    sizeof(pyopencv_MSER_t),
};

static void pyopencv_MSER_dealloc(PyObject* self)
{
    ((pyopencv_MSER_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::MSER>& r)
{
    pyopencv_MSER_t *m = PyObject_NEW(pyopencv_MSER_t, &pyopencv_MSER_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::MSER>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_MSER_Type))
    {
        failmsg("Expected cv::MSER for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_MSER_t*)src)->v.dynamicCast<cv::MSER>();
    return true;
}


struct pyopencv_MergeDebevec_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_MergeDebevec_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".MergeDebevec",
    sizeof(pyopencv_MergeDebevec_t),
};

static void pyopencv_MergeDebevec_dealloc(PyObject* self)
{
    ((pyopencv_MergeDebevec_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::MergeDebevec>& r)
{
    pyopencv_MergeDebevec_t *m = PyObject_NEW(pyopencv_MergeDebevec_t, &pyopencv_MergeDebevec_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::MergeDebevec>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_MergeDebevec_Type))
    {
        failmsg("Expected cv::MergeDebevec for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_MergeDebevec_t*)src)->v.dynamicCast<cv::MergeDebevec>();
    return true;
}


struct pyopencv_MergeExposures_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_MergeExposures_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".MergeExposures",
    sizeof(pyopencv_MergeExposures_t),
};

static void pyopencv_MergeExposures_dealloc(PyObject* self)
{
    ((pyopencv_MergeExposures_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::MergeExposures>& r)
{
    pyopencv_MergeExposures_t *m = PyObject_NEW(pyopencv_MergeExposures_t, &pyopencv_MergeExposures_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::MergeExposures>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_MergeExposures_Type))
    {
        failmsg("Expected cv::MergeExposures for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_MergeExposures_t*)src)->v.dynamicCast<cv::MergeExposures>();
    return true;
}


struct pyopencv_MergeMertens_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_MergeMertens_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".MergeMertens",
    sizeof(pyopencv_MergeMertens_t),
};

static void pyopencv_MergeMertens_dealloc(PyObject* self)
{
    ((pyopencv_MergeMertens_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::MergeMertens>& r)
{
    pyopencv_MergeMertens_t *m = PyObject_NEW(pyopencv_MergeMertens_t, &pyopencv_MergeMertens_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::MergeMertens>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_MergeMertens_Type))
    {
        failmsg("Expected cv::MergeMertens for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_MergeMertens_t*)src)->v.dynamicCast<cv::MergeMertens>();
    return true;
}


struct pyopencv_MergeRobertson_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_MergeRobertson_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".MergeRobertson",
    sizeof(pyopencv_MergeRobertson_t),
};

static void pyopencv_MergeRobertson_dealloc(PyObject* self)
{
    ((pyopencv_MergeRobertson_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::MergeRobertson>& r)
{
    pyopencv_MergeRobertson_t *m = PyObject_NEW(pyopencv_MergeRobertson_t, &pyopencv_MergeRobertson_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::MergeRobertson>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_MergeRobertson_Type))
    {
        failmsg("Expected cv::MergeRobertson for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_MergeRobertson_t*)src)->v.dynamicCast<cv::MergeRobertson>();
    return true;
}


template<> bool pyopencv_to(PyObject* src, cv::Moments& dst, const char* name);

struct pyopencv_MultiTracker_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_MultiTracker_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".MultiTracker",
    sizeof(pyopencv_MultiTracker_t),
};

static void pyopencv_MultiTracker_dealloc(PyObject* self)
{
    ((pyopencv_MultiTracker_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::MultiTracker>& r)
{
    pyopencv_MultiTracker_t *m = PyObject_NEW(pyopencv_MultiTracker_t, &pyopencv_MultiTracker_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::MultiTracker>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_MultiTracker_Type))
    {
        failmsg("Expected cv::MultiTracker for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_MultiTracker_t*)src)->v.dynamicCast<cv::MultiTracker>();
    return true;
}


struct pyopencv_NormHistogramCostExtractor_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_NormHistogramCostExtractor_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".NormHistogramCostExtractor",
    sizeof(pyopencv_NormHistogramCostExtractor_t),
};

static void pyopencv_NormHistogramCostExtractor_dealloc(PyObject* self)
{
    ((pyopencv_NormHistogramCostExtractor_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::NormHistogramCostExtractor>& r)
{
    pyopencv_NormHistogramCostExtractor_t *m = PyObject_NEW(pyopencv_NormHistogramCostExtractor_t, &pyopencv_NormHistogramCostExtractor_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::NormHistogramCostExtractor>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_NormHistogramCostExtractor_Type))
    {
        failmsg("Expected cv::NormHistogramCostExtractor for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_NormHistogramCostExtractor_t*)src)->v.dynamicCast<cv::NormHistogramCostExtractor>();
    return true;
}


struct pyopencv_ORB_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ORB_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ORB",
    sizeof(pyopencv_ORB_t),
};

static void pyopencv_ORB_dealloc(PyObject* self)
{
    ((pyopencv_ORB_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ORB>& r)
{
    pyopencv_ORB_t *m = PyObject_NEW(pyopencv_ORB_t, &pyopencv_ORB_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ORB>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ORB_Type))
    {
        failmsg("Expected cv::ORB for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ORB_t*)src)->v.dynamicCast<cv::ORB>();
    return true;
}


struct pyopencv_ShapeContextDistanceExtractor_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ShapeContextDistanceExtractor_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ShapeContextDistanceExtractor",
    sizeof(pyopencv_ShapeContextDistanceExtractor_t),
};

static void pyopencv_ShapeContextDistanceExtractor_dealloc(PyObject* self)
{
    ((pyopencv_ShapeContextDistanceExtractor_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ShapeContextDistanceExtractor>& r)
{
    pyopencv_ShapeContextDistanceExtractor_t *m = PyObject_NEW(pyopencv_ShapeContextDistanceExtractor_t, &pyopencv_ShapeContextDistanceExtractor_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ShapeContextDistanceExtractor>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ShapeContextDistanceExtractor_Type))
    {
        failmsg("Expected cv::ShapeContextDistanceExtractor for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ShapeContextDistanceExtractor_t*)src)->v.dynamicCast<cv::ShapeContextDistanceExtractor>();
    return true;
}


struct pyopencv_ShapeDistanceExtractor_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ShapeDistanceExtractor_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ShapeDistanceExtractor",
    sizeof(pyopencv_ShapeDistanceExtractor_t),
};

static void pyopencv_ShapeDistanceExtractor_dealloc(PyObject* self)
{
    ((pyopencv_ShapeDistanceExtractor_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ShapeDistanceExtractor>& r)
{
    pyopencv_ShapeDistanceExtractor_t *m = PyObject_NEW(pyopencv_ShapeDistanceExtractor_t, &pyopencv_ShapeDistanceExtractor_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ShapeDistanceExtractor>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ShapeDistanceExtractor_Type))
    {
        failmsg("Expected cv::ShapeDistanceExtractor for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ShapeDistanceExtractor_t*)src)->v.dynamicCast<cv::ShapeDistanceExtractor>();
    return true;
}


struct pyopencv_ShapeTransformer_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ShapeTransformer_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ShapeTransformer",
    sizeof(pyopencv_ShapeTransformer_t),
};

static void pyopencv_ShapeTransformer_dealloc(PyObject* self)
{
    ((pyopencv_ShapeTransformer_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ShapeTransformer>& r)
{
    pyopencv_ShapeTransformer_t *m = PyObject_NEW(pyopencv_ShapeTransformer_t, &pyopencv_ShapeTransformer_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ShapeTransformer>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ShapeTransformer_Type))
    {
        failmsg("Expected cv::ShapeTransformer for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ShapeTransformer_t*)src)->v.dynamicCast<cv::ShapeTransformer>();
    return true;
}


struct pyopencv_SimpleBlobDetector_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_SimpleBlobDetector_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".SimpleBlobDetector",
    sizeof(pyopencv_SimpleBlobDetector_t),
};

static void pyopencv_SimpleBlobDetector_dealloc(PyObject* self)
{
    ((pyopencv_SimpleBlobDetector_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::SimpleBlobDetector>& r)
{
    pyopencv_SimpleBlobDetector_t *m = PyObject_NEW(pyopencv_SimpleBlobDetector_t, &pyopencv_SimpleBlobDetector_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::SimpleBlobDetector>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_SimpleBlobDetector_Type))
    {
        failmsg("Expected cv::SimpleBlobDetector for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_SimpleBlobDetector_t*)src)->v.dynamicCast<cv::SimpleBlobDetector>();
    return true;
}


struct pyopencv_SimpleBlobDetector_Params_t
{
    PyObject_HEAD
    cv::SimpleBlobDetector::Params v;
};

static PyTypeObject pyopencv_SimpleBlobDetector_Params_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".SimpleBlobDetector_Params",
    sizeof(pyopencv_SimpleBlobDetector_Params_t),
};

static void pyopencv_SimpleBlobDetector_Params_dealloc(PyObject* self)
{
    ((pyopencv_SimpleBlobDetector_Params_t*)self)->v.cv::SimpleBlobDetector::Params::~Params();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const cv::SimpleBlobDetector::Params& r)
{
    pyopencv_SimpleBlobDetector_Params_t *m = PyObject_NEW(pyopencv_SimpleBlobDetector_Params_t, &pyopencv_SimpleBlobDetector_Params_Type);
    new (&m->v) cv::SimpleBlobDetector::Params(r); //Copy constructor
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, cv::SimpleBlobDetector::Params& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_SimpleBlobDetector_Params_Type))
    {
        failmsg("Expected cv::SimpleBlobDetector::Params for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_SimpleBlobDetector_Params_t*)src)->v;
    return true;
}

struct pyopencv_SparseOpticalFlow_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_SparseOpticalFlow_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".SparseOpticalFlow",
    sizeof(pyopencv_SparseOpticalFlow_t),
};

static void pyopencv_SparseOpticalFlow_dealloc(PyObject* self)
{
    ((pyopencv_SparseOpticalFlow_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::SparseOpticalFlow>& r)
{
    pyopencv_SparseOpticalFlow_t *m = PyObject_NEW(pyopencv_SparseOpticalFlow_t, &pyopencv_SparseOpticalFlow_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::SparseOpticalFlow>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_SparseOpticalFlow_Type))
    {
        failmsg("Expected cv::SparseOpticalFlow for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_SparseOpticalFlow_t*)src)->v.dynamicCast<cv::SparseOpticalFlow>();
    return true;
}


struct pyopencv_SparsePyrLKOpticalFlow_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_SparsePyrLKOpticalFlow_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".SparsePyrLKOpticalFlow",
    sizeof(pyopencv_SparsePyrLKOpticalFlow_t),
};

static void pyopencv_SparsePyrLKOpticalFlow_dealloc(PyObject* self)
{
    ((pyopencv_SparsePyrLKOpticalFlow_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::SparsePyrLKOpticalFlow>& r)
{
    pyopencv_SparsePyrLKOpticalFlow_t *m = PyObject_NEW(pyopencv_SparsePyrLKOpticalFlow_t, &pyopencv_SparsePyrLKOpticalFlow_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::SparsePyrLKOpticalFlow>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_SparsePyrLKOpticalFlow_Type))
    {
        failmsg("Expected cv::SparsePyrLKOpticalFlow for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_SparsePyrLKOpticalFlow_t*)src)->v.dynamicCast<cv::SparsePyrLKOpticalFlow>();
    return true;
}


struct pyopencv_StereoBM_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_StereoBM_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".StereoBM",
    sizeof(pyopencv_StereoBM_t),
};

static void pyopencv_StereoBM_dealloc(PyObject* self)
{
    ((pyopencv_StereoBM_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::StereoBM>& r)
{
    pyopencv_StereoBM_t *m = PyObject_NEW(pyopencv_StereoBM_t, &pyopencv_StereoBM_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::StereoBM>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_StereoBM_Type))
    {
        failmsg("Expected cv::StereoBM for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_StereoBM_t*)src)->v.dynamicCast<cv::StereoBM>();
    return true;
}


struct pyopencv_StereoMatcher_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_StereoMatcher_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".StereoMatcher",
    sizeof(pyopencv_StereoMatcher_t),
};

static void pyopencv_StereoMatcher_dealloc(PyObject* self)
{
    ((pyopencv_StereoMatcher_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::StereoMatcher>& r)
{
    pyopencv_StereoMatcher_t *m = PyObject_NEW(pyopencv_StereoMatcher_t, &pyopencv_StereoMatcher_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::StereoMatcher>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_StereoMatcher_Type))
    {
        failmsg("Expected cv::StereoMatcher for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_StereoMatcher_t*)src)->v.dynamicCast<cv::StereoMatcher>();
    return true;
}


struct pyopencv_StereoSGBM_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_StereoSGBM_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".StereoSGBM",
    sizeof(pyopencv_StereoSGBM_t),
};

static void pyopencv_StereoSGBM_dealloc(PyObject* self)
{
    ((pyopencv_StereoSGBM_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::StereoSGBM>& r)
{
    pyopencv_StereoSGBM_t *m = PyObject_NEW(pyopencv_StereoSGBM_t, &pyopencv_StereoSGBM_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::StereoSGBM>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_StereoSGBM_Type))
    {
        failmsg("Expected cv::StereoSGBM for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_StereoSGBM_t*)src)->v.dynamicCast<cv::StereoSGBM>();
    return true;
}


struct pyopencv_Stitcher_t
{
    PyObject_HEAD
    Ptr<cv::Stitcher> v;
};

static PyTypeObject pyopencv_Stitcher_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".Stitcher",
    sizeof(pyopencv_Stitcher_t),
};

static void pyopencv_Stitcher_dealloc(PyObject* self)
{
    ((pyopencv_Stitcher_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::Stitcher>& r)
{
    pyopencv_Stitcher_t *m = PyObject_NEW(pyopencv_Stitcher_t, &pyopencv_Stitcher_Type);
    new (&(m->v)) Ptr<cv::Stitcher>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::Stitcher>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_Stitcher_Type))
    {
        failmsg("Expected cv::Stitcher for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_Stitcher_t*)src)->v.dynamicCast<cv::Stitcher>();
    return true;
}


struct pyopencv_Subdiv2D_t
{
    PyObject_HEAD
    Ptr<cv::Subdiv2D> v;
};

static PyTypeObject pyopencv_Subdiv2D_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".Subdiv2D",
    sizeof(pyopencv_Subdiv2D_t),
};

static void pyopencv_Subdiv2D_dealloc(PyObject* self)
{
    ((pyopencv_Subdiv2D_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::Subdiv2D>& r)
{
    pyopencv_Subdiv2D_t *m = PyObject_NEW(pyopencv_Subdiv2D_t, &pyopencv_Subdiv2D_Type);
    new (&(m->v)) Ptr<cv::Subdiv2D>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::Subdiv2D>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_Subdiv2D_Type))
    {
        failmsg("Expected cv::Subdiv2D for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_Subdiv2D_t*)src)->v.dynamicCast<cv::Subdiv2D>();
    return true;
}


struct pyopencv_ThinPlateSplineShapeTransformer_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ThinPlateSplineShapeTransformer_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ThinPlateSplineShapeTransformer",
    sizeof(pyopencv_ThinPlateSplineShapeTransformer_t),
};

static void pyopencv_ThinPlateSplineShapeTransformer_dealloc(PyObject* self)
{
    ((pyopencv_ThinPlateSplineShapeTransformer_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ThinPlateSplineShapeTransformer>& r)
{
    pyopencv_ThinPlateSplineShapeTransformer_t *m = PyObject_NEW(pyopencv_ThinPlateSplineShapeTransformer_t, &pyopencv_ThinPlateSplineShapeTransformer_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ThinPlateSplineShapeTransformer>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ThinPlateSplineShapeTransformer_Type))
    {
        failmsg("Expected cv::ThinPlateSplineShapeTransformer for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ThinPlateSplineShapeTransformer_t*)src)->v.dynamicCast<cv::ThinPlateSplineShapeTransformer>();
    return true;
}


struct pyopencv_TickMeter_t
{
    PyObject_HEAD
    Ptr<cv::TickMeter> v;
};

static PyTypeObject pyopencv_TickMeter_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".TickMeter",
    sizeof(pyopencv_TickMeter_t),
};

static void pyopencv_TickMeter_dealloc(PyObject* self)
{
    ((pyopencv_TickMeter_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::TickMeter>& r)
{
    pyopencv_TickMeter_t *m = PyObject_NEW(pyopencv_TickMeter_t, &pyopencv_TickMeter_Type);
    new (&(m->v)) Ptr<cv::TickMeter>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::TickMeter>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_TickMeter_Type))
    {
        failmsg("Expected cv::TickMeter for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_TickMeter_t*)src)->v.dynamicCast<cv::TickMeter>();
    return true;
}


struct pyopencv_Tonemap_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_Tonemap_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".Tonemap",
    sizeof(pyopencv_Tonemap_t),
};

static void pyopencv_Tonemap_dealloc(PyObject* self)
{
    ((pyopencv_Tonemap_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::Tonemap>& r)
{
    pyopencv_Tonemap_t *m = PyObject_NEW(pyopencv_Tonemap_t, &pyopencv_Tonemap_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::Tonemap>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_Tonemap_Type))
    {
        failmsg("Expected cv::Tonemap for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_Tonemap_t*)src)->v.dynamicCast<cv::Tonemap>();
    return true;
}


struct pyopencv_TonemapDrago_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_TonemapDrago_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".TonemapDrago",
    sizeof(pyopencv_TonemapDrago_t),
};

static void pyopencv_TonemapDrago_dealloc(PyObject* self)
{
    ((pyopencv_TonemapDrago_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::TonemapDrago>& r)
{
    pyopencv_TonemapDrago_t *m = PyObject_NEW(pyopencv_TonemapDrago_t, &pyopencv_TonemapDrago_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::TonemapDrago>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_TonemapDrago_Type))
    {
        failmsg("Expected cv::TonemapDrago for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_TonemapDrago_t*)src)->v.dynamicCast<cv::TonemapDrago>();
    return true;
}


struct pyopencv_TonemapDurand_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_TonemapDurand_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".TonemapDurand",
    sizeof(pyopencv_TonemapDurand_t),
};

static void pyopencv_TonemapDurand_dealloc(PyObject* self)
{
    ((pyopencv_TonemapDurand_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::TonemapDurand>& r)
{
    pyopencv_TonemapDurand_t *m = PyObject_NEW(pyopencv_TonemapDurand_t, &pyopencv_TonemapDurand_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::TonemapDurand>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_TonemapDurand_Type))
    {
        failmsg("Expected cv::TonemapDurand for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_TonemapDurand_t*)src)->v.dynamicCast<cv::TonemapDurand>();
    return true;
}


struct pyopencv_TonemapMantiuk_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_TonemapMantiuk_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".TonemapMantiuk",
    sizeof(pyopencv_TonemapMantiuk_t),
};

static void pyopencv_TonemapMantiuk_dealloc(PyObject* self)
{
    ((pyopencv_TonemapMantiuk_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::TonemapMantiuk>& r)
{
    pyopencv_TonemapMantiuk_t *m = PyObject_NEW(pyopencv_TonemapMantiuk_t, &pyopencv_TonemapMantiuk_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::TonemapMantiuk>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_TonemapMantiuk_Type))
    {
        failmsg("Expected cv::TonemapMantiuk for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_TonemapMantiuk_t*)src)->v.dynamicCast<cv::TonemapMantiuk>();
    return true;
}


struct pyopencv_TonemapReinhard_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_TonemapReinhard_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".TonemapReinhard",
    sizeof(pyopencv_TonemapReinhard_t),
};

static void pyopencv_TonemapReinhard_dealloc(PyObject* self)
{
    ((pyopencv_TonemapReinhard_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::TonemapReinhard>& r)
{
    pyopencv_TonemapReinhard_t *m = PyObject_NEW(pyopencv_TonemapReinhard_t, &pyopencv_TonemapReinhard_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::TonemapReinhard>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_TonemapReinhard_Type))
    {
        failmsg("Expected cv::TonemapReinhard for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_TonemapReinhard_t*)src)->v.dynamicCast<cv::TonemapReinhard>();
    return true;
}


struct pyopencv_Tracker_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_Tracker_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".Tracker",
    sizeof(pyopencv_Tracker_t),
};

static void pyopencv_Tracker_dealloc(PyObject* self)
{
    ((pyopencv_Tracker_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::Tracker>& r)
{
    pyopencv_Tracker_t *m = PyObject_NEW(pyopencv_Tracker_t, &pyopencv_Tracker_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::Tracker>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_Tracker_Type))
    {
        failmsg("Expected cv::Tracker for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_Tracker_t*)src)->v.dynamicCast<cv::Tracker>();
    return true;
}


struct pyopencv_TrackerBoosting_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_TrackerBoosting_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".TrackerBoosting",
    sizeof(pyopencv_TrackerBoosting_t),
};

static void pyopencv_TrackerBoosting_dealloc(PyObject* self)
{
    ((pyopencv_TrackerBoosting_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::TrackerBoosting>& r)
{
    pyopencv_TrackerBoosting_t *m = PyObject_NEW(pyopencv_TrackerBoosting_t, &pyopencv_TrackerBoosting_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::TrackerBoosting>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_TrackerBoosting_Type))
    {
        failmsg("Expected cv::TrackerBoosting for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_TrackerBoosting_t*)src)->v.dynamicCast<cv::TrackerBoosting>();
    return true;
}


struct pyopencv_TrackerCSRT_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_TrackerCSRT_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".TrackerCSRT",
    sizeof(pyopencv_TrackerCSRT_t),
};

static void pyopencv_TrackerCSRT_dealloc(PyObject* self)
{
    ((pyopencv_TrackerCSRT_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::TrackerCSRT>& r)
{
    pyopencv_TrackerCSRT_t *m = PyObject_NEW(pyopencv_TrackerCSRT_t, &pyopencv_TrackerCSRT_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::TrackerCSRT>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_TrackerCSRT_Type))
    {
        failmsg("Expected cv::TrackerCSRT for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_TrackerCSRT_t*)src)->v.dynamicCast<cv::TrackerCSRT>();
    return true;
}


struct pyopencv_TrackerGOTURN_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_TrackerGOTURN_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".TrackerGOTURN",
    sizeof(pyopencv_TrackerGOTURN_t),
};

static void pyopencv_TrackerGOTURN_dealloc(PyObject* self)
{
    ((pyopencv_TrackerGOTURN_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::TrackerGOTURN>& r)
{
    pyopencv_TrackerGOTURN_t *m = PyObject_NEW(pyopencv_TrackerGOTURN_t, &pyopencv_TrackerGOTURN_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::TrackerGOTURN>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_TrackerGOTURN_Type))
    {
        failmsg("Expected cv::TrackerGOTURN for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_TrackerGOTURN_t*)src)->v.dynamicCast<cv::TrackerGOTURN>();
    return true;
}


struct pyopencv_TrackerKCF_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_TrackerKCF_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".TrackerKCF",
    sizeof(pyopencv_TrackerKCF_t),
};

static void pyopencv_TrackerKCF_dealloc(PyObject* self)
{
    ((pyopencv_TrackerKCF_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::TrackerKCF>& r)
{
    pyopencv_TrackerKCF_t *m = PyObject_NEW(pyopencv_TrackerKCF_t, &pyopencv_TrackerKCF_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::TrackerKCF>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_TrackerKCF_Type))
    {
        failmsg("Expected cv::TrackerKCF for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_TrackerKCF_t*)src)->v.dynamicCast<cv::TrackerKCF>();
    return true;
}


struct pyopencv_TrackerMIL_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_TrackerMIL_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".TrackerMIL",
    sizeof(pyopencv_TrackerMIL_t),
};

static void pyopencv_TrackerMIL_dealloc(PyObject* self)
{
    ((pyopencv_TrackerMIL_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::TrackerMIL>& r)
{
    pyopencv_TrackerMIL_t *m = PyObject_NEW(pyopencv_TrackerMIL_t, &pyopencv_TrackerMIL_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::TrackerMIL>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_TrackerMIL_Type))
    {
        failmsg("Expected cv::TrackerMIL for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_TrackerMIL_t*)src)->v.dynamicCast<cv::TrackerMIL>();
    return true;
}


struct pyopencv_TrackerMOSSE_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_TrackerMOSSE_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".TrackerMOSSE",
    sizeof(pyopencv_TrackerMOSSE_t),
};

static void pyopencv_TrackerMOSSE_dealloc(PyObject* self)
{
    ((pyopencv_TrackerMOSSE_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::TrackerMOSSE>& r)
{
    pyopencv_TrackerMOSSE_t *m = PyObject_NEW(pyopencv_TrackerMOSSE_t, &pyopencv_TrackerMOSSE_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::TrackerMOSSE>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_TrackerMOSSE_Type))
    {
        failmsg("Expected cv::TrackerMOSSE for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_TrackerMOSSE_t*)src)->v.dynamicCast<cv::TrackerMOSSE>();
    return true;
}


struct pyopencv_TrackerMedianFlow_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_TrackerMedianFlow_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".TrackerMedianFlow",
    sizeof(pyopencv_TrackerMedianFlow_t),
};

static void pyopencv_TrackerMedianFlow_dealloc(PyObject* self)
{
    ((pyopencv_TrackerMedianFlow_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::TrackerMedianFlow>& r)
{
    pyopencv_TrackerMedianFlow_t *m = PyObject_NEW(pyopencv_TrackerMedianFlow_t, &pyopencv_TrackerMedianFlow_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::TrackerMedianFlow>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_TrackerMedianFlow_Type))
    {
        failmsg("Expected cv::TrackerMedianFlow for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_TrackerMedianFlow_t*)src)->v.dynamicCast<cv::TrackerMedianFlow>();
    return true;
}


struct pyopencv_TrackerTLD_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_TrackerTLD_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".TrackerTLD",
    sizeof(pyopencv_TrackerTLD_t),
};

static void pyopencv_TrackerTLD_dealloc(PyObject* self)
{
    ((pyopencv_TrackerTLD_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::TrackerTLD>& r)
{
    pyopencv_TrackerTLD_t *m = PyObject_NEW(pyopencv_TrackerTLD_t, &pyopencv_TrackerTLD_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::TrackerTLD>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_TrackerTLD_Type))
    {
        failmsg("Expected cv::TrackerTLD for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_TrackerTLD_t*)src)->v.dynamicCast<cv::TrackerTLD>();
    return true;
}


struct pyopencv_VideoCapture_t
{
    PyObject_HEAD
    Ptr<cv::VideoCapture> v;
};

static PyTypeObject pyopencv_VideoCapture_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".VideoCapture",
    sizeof(pyopencv_VideoCapture_t),
};

static void pyopencv_VideoCapture_dealloc(PyObject* self)
{
    ((pyopencv_VideoCapture_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::VideoCapture>& r)
{
    pyopencv_VideoCapture_t *m = PyObject_NEW(pyopencv_VideoCapture_t, &pyopencv_VideoCapture_Type);
    new (&(m->v)) Ptr<cv::VideoCapture>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::VideoCapture>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_VideoCapture_Type))
    {
        failmsg("Expected cv::VideoCapture for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_VideoCapture_t*)src)->v.dynamicCast<cv::VideoCapture>();
    return true;
}


struct pyopencv_VideoWriter_t
{
    PyObject_HEAD
    Ptr<cv::VideoWriter> v;
};

static PyTypeObject pyopencv_VideoWriter_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".VideoWriter",
    sizeof(pyopencv_VideoWriter_t),
};

static void pyopencv_VideoWriter_dealloc(PyObject* self)
{
    ((pyopencv_VideoWriter_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::VideoWriter>& r)
{
    pyopencv_VideoWriter_t *m = PyObject_NEW(pyopencv_VideoWriter_t, &pyopencv_VideoWriter_Type);
    new (&(m->v)) Ptr<cv::VideoWriter>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::VideoWriter>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_VideoWriter_Type))
    {
        failmsg("Expected cv::VideoWriter for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_VideoWriter_t*)src)->v.dynamicCast<cv::VideoWriter>();
    return true;
}


struct pyopencv_aruco_Board_t
{
    PyObject_HEAD
    Ptr<cv::aruco::Board> v;
};

static PyTypeObject pyopencv_aruco_Board_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".aruco_Board",
    sizeof(pyopencv_aruco_Board_t),
};

static void pyopencv_aruco_Board_dealloc(PyObject* self)
{
    ((pyopencv_aruco_Board_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::aruco::Board>& r)
{
    pyopencv_aruco_Board_t *m = PyObject_NEW(pyopencv_aruco_Board_t, &pyopencv_aruco_Board_Type);
    new (&(m->v)) Ptr<cv::aruco::Board>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::aruco::Board>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_aruco_Board_Type))
    {
        failmsg("Expected cv::aruco::Board for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_aruco_Board_t*)src)->v.dynamicCast<cv::aruco::Board>();
    return true;
}


struct pyopencv_aruco_CharucoBoard_t
{
    PyObject_HEAD
    Ptr<cv::aruco::CharucoBoard> v;
};

static PyTypeObject pyopencv_aruco_CharucoBoard_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".aruco_CharucoBoard",
    sizeof(pyopencv_aruco_CharucoBoard_t),
};

static void pyopencv_aruco_CharucoBoard_dealloc(PyObject* self)
{
    ((pyopencv_aruco_CharucoBoard_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::aruco::CharucoBoard>& r)
{
    pyopencv_aruco_CharucoBoard_t *m = PyObject_NEW(pyopencv_aruco_CharucoBoard_t, &pyopencv_aruco_CharucoBoard_Type);
    new (&(m->v)) Ptr<cv::aruco::CharucoBoard>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::aruco::CharucoBoard>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_aruco_CharucoBoard_Type))
    {
        failmsg("Expected cv::aruco::CharucoBoard for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_aruco_CharucoBoard_t*)src)->v.dynamicCast<cv::aruco::CharucoBoard>();
    return true;
}


struct pyopencv_aruco_DetectorParameters_t
{
    PyObject_HEAD
    Ptr<cv::aruco::DetectorParameters> v;
};

static PyTypeObject pyopencv_aruco_DetectorParameters_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".aruco_DetectorParameters",
    sizeof(pyopencv_aruco_DetectorParameters_t),
};

static void pyopencv_aruco_DetectorParameters_dealloc(PyObject* self)
{
    ((pyopencv_aruco_DetectorParameters_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::aruco::DetectorParameters>& r)
{
    pyopencv_aruco_DetectorParameters_t *m = PyObject_NEW(pyopencv_aruco_DetectorParameters_t, &pyopencv_aruco_DetectorParameters_Type);
    new (&(m->v)) Ptr<cv::aruco::DetectorParameters>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::aruco::DetectorParameters>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_aruco_DetectorParameters_Type))
    {
        failmsg("Expected cv::aruco::DetectorParameters for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_aruco_DetectorParameters_t*)src)->v.dynamicCast<cv::aruco::DetectorParameters>();
    return true;
}


struct pyopencv_aruco_Dictionary_t
{
    PyObject_HEAD
    Ptr<cv::aruco::Dictionary> v;
};

static PyTypeObject pyopencv_aruco_Dictionary_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".aruco_Dictionary",
    sizeof(pyopencv_aruco_Dictionary_t),
};

static void pyopencv_aruco_Dictionary_dealloc(PyObject* self)
{
    ((pyopencv_aruco_Dictionary_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::aruco::Dictionary>& r)
{
    pyopencv_aruco_Dictionary_t *m = PyObject_NEW(pyopencv_aruco_Dictionary_t, &pyopencv_aruco_Dictionary_Type);
    new (&(m->v)) Ptr<cv::aruco::Dictionary>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::aruco::Dictionary>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_aruco_Dictionary_Type))
    {
        failmsg("Expected cv::aruco::Dictionary for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_aruco_Dictionary_t*)src)->v.dynamicCast<cv::aruco::Dictionary>();
    return true;
}


struct pyopencv_aruco_GridBoard_t
{
    PyObject_HEAD
    Ptr<cv::aruco::GridBoard> v;
};

static PyTypeObject pyopencv_aruco_GridBoard_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".aruco_GridBoard",
    sizeof(pyopencv_aruco_GridBoard_t),
};

static void pyopencv_aruco_GridBoard_dealloc(PyObject* self)
{
    ((pyopencv_aruco_GridBoard_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::aruco::GridBoard>& r)
{
    pyopencv_aruco_GridBoard_t *m = PyObject_NEW(pyopencv_aruco_GridBoard_t, &pyopencv_aruco_GridBoard_Type);
    new (&(m->v)) Ptr<cv::aruco::GridBoard>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::aruco::GridBoard>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_aruco_GridBoard_Type))
    {
        failmsg("Expected cv::aruco::GridBoard for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_aruco_GridBoard_t*)src)->v.dynamicCast<cv::aruco::GridBoard>();
    return true;
}


struct pyopencv_bgsegm_BackgroundSubtractorCNT_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_bgsegm_BackgroundSubtractorCNT_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".bgsegm_BackgroundSubtractorCNT",
    sizeof(pyopencv_bgsegm_BackgroundSubtractorCNT_t),
};

static void pyopencv_bgsegm_BackgroundSubtractorCNT_dealloc(PyObject* self)
{
    ((pyopencv_bgsegm_BackgroundSubtractorCNT_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::bgsegm::BackgroundSubtractorCNT>& r)
{
    pyopencv_bgsegm_BackgroundSubtractorCNT_t *m = PyObject_NEW(pyopencv_bgsegm_BackgroundSubtractorCNT_t, &pyopencv_bgsegm_BackgroundSubtractorCNT_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::bgsegm::BackgroundSubtractorCNT>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_bgsegm_BackgroundSubtractorCNT_Type))
    {
        failmsg("Expected cv::bgsegm::BackgroundSubtractorCNT for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_bgsegm_BackgroundSubtractorCNT_t*)src)->v.dynamicCast<cv::bgsegm::BackgroundSubtractorCNT>();
    return true;
}


struct pyopencv_bgsegm_BackgroundSubtractorGMG_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_bgsegm_BackgroundSubtractorGMG_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".bgsegm_BackgroundSubtractorGMG",
    sizeof(pyopencv_bgsegm_BackgroundSubtractorGMG_t),
};

static void pyopencv_bgsegm_BackgroundSubtractorGMG_dealloc(PyObject* self)
{
    ((pyopencv_bgsegm_BackgroundSubtractorGMG_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::bgsegm::BackgroundSubtractorGMG>& r)
{
    pyopencv_bgsegm_BackgroundSubtractorGMG_t *m = PyObject_NEW(pyopencv_bgsegm_BackgroundSubtractorGMG_t, &pyopencv_bgsegm_BackgroundSubtractorGMG_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::bgsegm::BackgroundSubtractorGMG>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_bgsegm_BackgroundSubtractorGMG_Type))
    {
        failmsg("Expected cv::bgsegm::BackgroundSubtractorGMG for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_bgsegm_BackgroundSubtractorGMG_t*)src)->v.dynamicCast<cv::bgsegm::BackgroundSubtractorGMG>();
    return true;
}


struct pyopencv_bgsegm_BackgroundSubtractorGSOC_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_bgsegm_BackgroundSubtractorGSOC_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".bgsegm_BackgroundSubtractorGSOC",
    sizeof(pyopencv_bgsegm_BackgroundSubtractorGSOC_t),
};

static void pyopencv_bgsegm_BackgroundSubtractorGSOC_dealloc(PyObject* self)
{
    ((pyopencv_bgsegm_BackgroundSubtractorGSOC_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::bgsegm::BackgroundSubtractorGSOC>& r)
{
    pyopencv_bgsegm_BackgroundSubtractorGSOC_t *m = PyObject_NEW(pyopencv_bgsegm_BackgroundSubtractorGSOC_t, &pyopencv_bgsegm_BackgroundSubtractorGSOC_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::bgsegm::BackgroundSubtractorGSOC>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_bgsegm_BackgroundSubtractorGSOC_Type))
    {
        failmsg("Expected cv::bgsegm::BackgroundSubtractorGSOC for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_bgsegm_BackgroundSubtractorGSOC_t*)src)->v.dynamicCast<cv::bgsegm::BackgroundSubtractorGSOC>();
    return true;
}


struct pyopencv_bgsegm_BackgroundSubtractorLSBP_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_bgsegm_BackgroundSubtractorLSBP_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".bgsegm_BackgroundSubtractorLSBP",
    sizeof(pyopencv_bgsegm_BackgroundSubtractorLSBP_t),
};

static void pyopencv_bgsegm_BackgroundSubtractorLSBP_dealloc(PyObject* self)
{
    ((pyopencv_bgsegm_BackgroundSubtractorLSBP_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::bgsegm::BackgroundSubtractorLSBP>& r)
{
    pyopencv_bgsegm_BackgroundSubtractorLSBP_t *m = PyObject_NEW(pyopencv_bgsegm_BackgroundSubtractorLSBP_t, &pyopencv_bgsegm_BackgroundSubtractorLSBP_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::bgsegm::BackgroundSubtractorLSBP>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_bgsegm_BackgroundSubtractorLSBP_Type))
    {
        failmsg("Expected cv::bgsegm::BackgroundSubtractorLSBP for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_bgsegm_BackgroundSubtractorLSBP_t*)src)->v.dynamicCast<cv::bgsegm::BackgroundSubtractorLSBP>();
    return true;
}


struct pyopencv_bgsegm_BackgroundSubtractorLSBPDesc_t
{
    PyObject_HEAD
    Ptr<cv::bgsegm::BackgroundSubtractorLSBPDesc> v;
};

static PyTypeObject pyopencv_bgsegm_BackgroundSubtractorLSBPDesc_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".bgsegm_BackgroundSubtractorLSBPDesc",
    sizeof(pyopencv_bgsegm_BackgroundSubtractorLSBPDesc_t),
};

static void pyopencv_bgsegm_BackgroundSubtractorLSBPDesc_dealloc(PyObject* self)
{
    ((pyopencv_bgsegm_BackgroundSubtractorLSBPDesc_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::bgsegm::BackgroundSubtractorLSBPDesc>& r)
{
    pyopencv_bgsegm_BackgroundSubtractorLSBPDesc_t *m = PyObject_NEW(pyopencv_bgsegm_BackgroundSubtractorLSBPDesc_t, &pyopencv_bgsegm_BackgroundSubtractorLSBPDesc_Type);
    new (&(m->v)) Ptr<cv::bgsegm::BackgroundSubtractorLSBPDesc>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::bgsegm::BackgroundSubtractorLSBPDesc>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_bgsegm_BackgroundSubtractorLSBPDesc_Type))
    {
        failmsg("Expected cv::bgsegm::BackgroundSubtractorLSBPDesc for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_bgsegm_BackgroundSubtractorLSBPDesc_t*)src)->v.dynamicCast<cv::bgsegm::BackgroundSubtractorLSBPDesc>();
    return true;
}


struct pyopencv_bgsegm_BackgroundSubtractorMOG_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_bgsegm_BackgroundSubtractorMOG_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".bgsegm_BackgroundSubtractorMOG",
    sizeof(pyopencv_bgsegm_BackgroundSubtractorMOG_t),
};

static void pyopencv_bgsegm_BackgroundSubtractorMOG_dealloc(PyObject* self)
{
    ((pyopencv_bgsegm_BackgroundSubtractorMOG_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::bgsegm::BackgroundSubtractorMOG>& r)
{
    pyopencv_bgsegm_BackgroundSubtractorMOG_t *m = PyObject_NEW(pyopencv_bgsegm_BackgroundSubtractorMOG_t, &pyopencv_bgsegm_BackgroundSubtractorMOG_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::bgsegm::BackgroundSubtractorMOG>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_bgsegm_BackgroundSubtractorMOG_Type))
    {
        failmsg("Expected cv::bgsegm::BackgroundSubtractorMOG for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_bgsegm_BackgroundSubtractorMOG_t*)src)->v.dynamicCast<cv::bgsegm::BackgroundSubtractorMOG>();
    return true;
}


struct pyopencv_bgsegm_SyntheticSequenceGenerator_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_bgsegm_SyntheticSequenceGenerator_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".bgsegm_SyntheticSequenceGenerator",
    sizeof(pyopencv_bgsegm_SyntheticSequenceGenerator_t),
};

static void pyopencv_bgsegm_SyntheticSequenceGenerator_dealloc(PyObject* self)
{
    ((pyopencv_bgsegm_SyntheticSequenceGenerator_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::bgsegm::SyntheticSequenceGenerator>& r)
{
    pyopencv_bgsegm_SyntheticSequenceGenerator_t *m = PyObject_NEW(pyopencv_bgsegm_SyntheticSequenceGenerator_t, &pyopencv_bgsegm_SyntheticSequenceGenerator_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::bgsegm::SyntheticSequenceGenerator>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_bgsegm_SyntheticSequenceGenerator_Type))
    {
        failmsg("Expected cv::bgsegm::SyntheticSequenceGenerator for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_bgsegm_SyntheticSequenceGenerator_t*)src)->v.dynamicCast<cv::bgsegm::SyntheticSequenceGenerator>();
    return true;
}


struct pyopencv_bioinspired_Retina_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_bioinspired_Retina_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".bioinspired_Retina",
    sizeof(pyopencv_bioinspired_Retina_t),
};

static void pyopencv_bioinspired_Retina_dealloc(PyObject* self)
{
    ((pyopencv_bioinspired_Retina_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::bioinspired::Retina>& r)
{
    pyopencv_bioinspired_Retina_t *m = PyObject_NEW(pyopencv_bioinspired_Retina_t, &pyopencv_bioinspired_Retina_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::bioinspired::Retina>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_bioinspired_Retina_Type))
    {
        failmsg("Expected cv::bioinspired::Retina for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_bioinspired_Retina_t*)src)->v.dynamicCast<cv::bioinspired::Retina>();
    return true;
}


struct pyopencv_bioinspired_RetinaFastToneMapping_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_bioinspired_RetinaFastToneMapping_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".bioinspired_RetinaFastToneMapping",
    sizeof(pyopencv_bioinspired_RetinaFastToneMapping_t),
};

static void pyopencv_bioinspired_RetinaFastToneMapping_dealloc(PyObject* self)
{
    ((pyopencv_bioinspired_RetinaFastToneMapping_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::bioinspired::RetinaFastToneMapping>& r)
{
    pyopencv_bioinspired_RetinaFastToneMapping_t *m = PyObject_NEW(pyopencv_bioinspired_RetinaFastToneMapping_t, &pyopencv_bioinspired_RetinaFastToneMapping_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::bioinspired::RetinaFastToneMapping>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_bioinspired_RetinaFastToneMapping_Type))
    {
        failmsg("Expected cv::bioinspired::RetinaFastToneMapping for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_bioinspired_RetinaFastToneMapping_t*)src)->v.dynamicCast<cv::bioinspired::RetinaFastToneMapping>();
    return true;
}


struct pyopencv_bioinspired_TransientAreasSegmentationModule_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_bioinspired_TransientAreasSegmentationModule_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".bioinspired_TransientAreasSegmentationModule",
    sizeof(pyopencv_bioinspired_TransientAreasSegmentationModule_t),
};

static void pyopencv_bioinspired_TransientAreasSegmentationModule_dealloc(PyObject* self)
{
    ((pyopencv_bioinspired_TransientAreasSegmentationModule_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::bioinspired::TransientAreasSegmentationModule>& r)
{
    pyopencv_bioinspired_TransientAreasSegmentationModule_t *m = PyObject_NEW(pyopencv_bioinspired_TransientAreasSegmentationModule_t, &pyopencv_bioinspired_TransientAreasSegmentationModule_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::bioinspired::TransientAreasSegmentationModule>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_bioinspired_TransientAreasSegmentationModule_Type))
    {
        failmsg("Expected cv::bioinspired::TransientAreasSegmentationModule for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_bioinspired_TransientAreasSegmentationModule_t*)src)->v.dynamicCast<cv::bioinspired::TransientAreasSegmentationModule>();
    return true;
}


struct pyopencv_dpm_DPMDetector_t
{
    PyObject_HEAD
    Ptr<cv::dpm::DPMDetector> v;
};

static PyTypeObject pyopencv_dpm_DPMDetector_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".dpm_DPMDetector",
    sizeof(pyopencv_dpm_DPMDetector_t),
};

static void pyopencv_dpm_DPMDetector_dealloc(PyObject* self)
{
    ((pyopencv_dpm_DPMDetector_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::dpm::DPMDetector>& r)
{
    pyopencv_dpm_DPMDetector_t *m = PyObject_NEW(pyopencv_dpm_DPMDetector_t, &pyopencv_dpm_DPMDetector_Type);
    new (&(m->v)) Ptr<cv::dpm::DPMDetector>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::dpm::DPMDetector>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_dpm_DPMDetector_Type))
    {
        failmsg("Expected cv::dpm::DPMDetector for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_dpm_DPMDetector_t*)src)->v.dynamicCast<cv::dpm::DPMDetector>();
    return true;
}


struct pyopencv_dpm_DPMDetector_ObjectDetection_t
{
    PyObject_HEAD
    Ptr<cv::dpm::DPMDetector::ObjectDetection> v;
};

static PyTypeObject pyopencv_dpm_DPMDetector_ObjectDetection_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".dpm_DPMDetector_ObjectDetection",
    sizeof(pyopencv_dpm_DPMDetector_ObjectDetection_t),
};

static void pyopencv_dpm_DPMDetector_ObjectDetection_dealloc(PyObject* self)
{
    ((pyopencv_dpm_DPMDetector_ObjectDetection_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::dpm::DPMDetector::ObjectDetection>& r)
{
    pyopencv_dpm_DPMDetector_ObjectDetection_t *m = PyObject_NEW(pyopencv_dpm_DPMDetector_ObjectDetection_t, &pyopencv_dpm_DPMDetector_ObjectDetection_Type);
    new (&(m->v)) Ptr<cv::dpm::DPMDetector::ObjectDetection>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::dpm::DPMDetector::ObjectDetection>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_dpm_DPMDetector_ObjectDetection_Type))
    {
        failmsg("Expected cv::dpm::DPMDetector::ObjectDetection for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_dpm_DPMDetector_ObjectDetection_t*)src)->v.dynamicCast<cv::dpm::DPMDetector::ObjectDetection>();
    return true;
}


struct pyopencv_face_BIF_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_face_BIF_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".face_BIF",
    sizeof(pyopencv_face_BIF_t),
};

static void pyopencv_face_BIF_dealloc(PyObject* self)
{
    ((pyopencv_face_BIF_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::face::BIF>& r)
{
    pyopencv_face_BIF_t *m = PyObject_NEW(pyopencv_face_BIF_t, &pyopencv_face_BIF_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::face::BIF>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_face_BIF_Type))
    {
        failmsg("Expected cv::face::BIF for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_face_BIF_t*)src)->v.dynamicCast<cv::face::BIF>();
    return true;
}


struct pyopencv_face_BasicFaceRecognizer_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_face_BasicFaceRecognizer_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".face_BasicFaceRecognizer",
    sizeof(pyopencv_face_BasicFaceRecognizer_t),
};

static void pyopencv_face_BasicFaceRecognizer_dealloc(PyObject* self)
{
    ((pyopencv_face_BasicFaceRecognizer_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::face::BasicFaceRecognizer>& r)
{
    pyopencv_face_BasicFaceRecognizer_t *m = PyObject_NEW(pyopencv_face_BasicFaceRecognizer_t, &pyopencv_face_BasicFaceRecognizer_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::face::BasicFaceRecognizer>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_face_BasicFaceRecognizer_Type))
    {
        failmsg("Expected cv::face::BasicFaceRecognizer for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_face_BasicFaceRecognizer_t*)src)->v.dynamicCast<cv::face::BasicFaceRecognizer>();
    return true;
}


struct pyopencv_face_EigenFaceRecognizer_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_face_EigenFaceRecognizer_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".face_EigenFaceRecognizer",
    sizeof(pyopencv_face_EigenFaceRecognizer_t),
};

static void pyopencv_face_EigenFaceRecognizer_dealloc(PyObject* self)
{
    ((pyopencv_face_EigenFaceRecognizer_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::face::EigenFaceRecognizer>& r)
{
    pyopencv_face_EigenFaceRecognizer_t *m = PyObject_NEW(pyopencv_face_EigenFaceRecognizer_t, &pyopencv_face_EigenFaceRecognizer_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::face::EigenFaceRecognizer>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_face_EigenFaceRecognizer_Type))
    {
        failmsg("Expected cv::face::EigenFaceRecognizer for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_face_EigenFaceRecognizer_t*)src)->v.dynamicCast<cv::face::EigenFaceRecognizer>();
    return true;
}


struct pyopencv_face_FaceRecognizer_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_face_FaceRecognizer_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".face_FaceRecognizer",
    sizeof(pyopencv_face_FaceRecognizer_t),
};

static void pyopencv_face_FaceRecognizer_dealloc(PyObject* self)
{
    ((pyopencv_face_FaceRecognizer_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::face::FaceRecognizer>& r)
{
    pyopencv_face_FaceRecognizer_t *m = PyObject_NEW(pyopencv_face_FaceRecognizer_t, &pyopencv_face_FaceRecognizer_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::face::FaceRecognizer>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_face_FaceRecognizer_Type))
    {
        failmsg("Expected cv::face::FaceRecognizer for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_face_FaceRecognizer_t*)src)->v.dynamicCast<cv::face::FaceRecognizer>();
    return true;
}


struct pyopencv_face_Facemark_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_face_Facemark_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".face_Facemark",
    sizeof(pyopencv_face_Facemark_t),
};

static void pyopencv_face_Facemark_dealloc(PyObject* self)
{
    ((pyopencv_face_Facemark_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::face::Facemark>& r)
{
    pyopencv_face_Facemark_t *m = PyObject_NEW(pyopencv_face_Facemark_t, &pyopencv_face_Facemark_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::face::Facemark>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_face_Facemark_Type))
    {
        failmsg("Expected cv::face::Facemark for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_face_Facemark_t*)src)->v.dynamicCast<cv::face::Facemark>();
    return true;
}


struct pyopencv_face_FacemarkAAM_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_face_FacemarkAAM_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".face_FacemarkAAM",
    sizeof(pyopencv_face_FacemarkAAM_t),
};

static void pyopencv_face_FacemarkAAM_dealloc(PyObject* self)
{
    ((pyopencv_face_FacemarkAAM_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::face::FacemarkAAM>& r)
{
    pyopencv_face_FacemarkAAM_t *m = PyObject_NEW(pyopencv_face_FacemarkAAM_t, &pyopencv_face_FacemarkAAM_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::face::FacemarkAAM>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_face_FacemarkAAM_Type))
    {
        failmsg("Expected cv::face::FacemarkAAM for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_face_FacemarkAAM_t*)src)->v.dynamicCast<cv::face::FacemarkAAM>();
    return true;
}


struct pyopencv_face_FacemarkKazemi_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_face_FacemarkKazemi_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".face_FacemarkKazemi",
    sizeof(pyopencv_face_FacemarkKazemi_t),
};

static void pyopencv_face_FacemarkKazemi_dealloc(PyObject* self)
{
    ((pyopencv_face_FacemarkKazemi_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::face::FacemarkKazemi>& r)
{
    pyopencv_face_FacemarkKazemi_t *m = PyObject_NEW(pyopencv_face_FacemarkKazemi_t, &pyopencv_face_FacemarkKazemi_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::face::FacemarkKazemi>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_face_FacemarkKazemi_Type))
    {
        failmsg("Expected cv::face::FacemarkKazemi for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_face_FacemarkKazemi_t*)src)->v.dynamicCast<cv::face::FacemarkKazemi>();
    return true;
}


struct pyopencv_face_FacemarkLBF_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_face_FacemarkLBF_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".face_FacemarkLBF",
    sizeof(pyopencv_face_FacemarkLBF_t),
};

static void pyopencv_face_FacemarkLBF_dealloc(PyObject* self)
{
    ((pyopencv_face_FacemarkLBF_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::face::FacemarkLBF>& r)
{
    pyopencv_face_FacemarkLBF_t *m = PyObject_NEW(pyopencv_face_FacemarkLBF_t, &pyopencv_face_FacemarkLBF_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::face::FacemarkLBF>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_face_FacemarkLBF_Type))
    {
        failmsg("Expected cv::face::FacemarkLBF for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_face_FacemarkLBF_t*)src)->v.dynamicCast<cv::face::FacemarkLBF>();
    return true;
}


struct pyopencv_face_FisherFaceRecognizer_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_face_FisherFaceRecognizer_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".face_FisherFaceRecognizer",
    sizeof(pyopencv_face_FisherFaceRecognizer_t),
};

static void pyopencv_face_FisherFaceRecognizer_dealloc(PyObject* self)
{
    ((pyopencv_face_FisherFaceRecognizer_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::face::FisherFaceRecognizer>& r)
{
    pyopencv_face_FisherFaceRecognizer_t *m = PyObject_NEW(pyopencv_face_FisherFaceRecognizer_t, &pyopencv_face_FisherFaceRecognizer_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::face::FisherFaceRecognizer>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_face_FisherFaceRecognizer_Type))
    {
        failmsg("Expected cv::face::FisherFaceRecognizer for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_face_FisherFaceRecognizer_t*)src)->v.dynamicCast<cv::face::FisherFaceRecognizer>();
    return true;
}


struct pyopencv_face_LBPHFaceRecognizer_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_face_LBPHFaceRecognizer_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".face_LBPHFaceRecognizer",
    sizeof(pyopencv_face_LBPHFaceRecognizer_t),
};

static void pyopencv_face_LBPHFaceRecognizer_dealloc(PyObject* self)
{
    ((pyopencv_face_LBPHFaceRecognizer_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::face::LBPHFaceRecognizer>& r)
{
    pyopencv_face_LBPHFaceRecognizer_t *m = PyObject_NEW(pyopencv_face_LBPHFaceRecognizer_t, &pyopencv_face_LBPHFaceRecognizer_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::face::LBPHFaceRecognizer>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_face_LBPHFaceRecognizer_Type))
    {
        failmsg("Expected cv::face::LBPHFaceRecognizer for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_face_LBPHFaceRecognizer_t*)src)->v.dynamicCast<cv::face::LBPHFaceRecognizer>();
    return true;
}


struct pyopencv_face_PredictCollector_t
{
    PyObject_HEAD
    Ptr<cv::face::PredictCollector> v;
};

static PyTypeObject pyopencv_face_PredictCollector_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".face_PredictCollector",
    sizeof(pyopencv_face_PredictCollector_t),
};

static void pyopencv_face_PredictCollector_dealloc(PyObject* self)
{
    ((pyopencv_face_PredictCollector_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::face::PredictCollector>& r)
{
    pyopencv_face_PredictCollector_t *m = PyObject_NEW(pyopencv_face_PredictCollector_t, &pyopencv_face_PredictCollector_Type);
    new (&(m->v)) Ptr<cv::face::PredictCollector>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::face::PredictCollector>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_face_PredictCollector_Type))
    {
        failmsg("Expected cv::face::PredictCollector for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_face_PredictCollector_t*)src)->v.dynamicCast<cv::face::PredictCollector>();
    return true;
}


struct pyopencv_face_StandardCollector_t
{
    PyObject_HEAD
    Ptr<cv::face::StandardCollector> v;
};

static PyTypeObject pyopencv_face_StandardCollector_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".face_StandardCollector",
    sizeof(pyopencv_face_StandardCollector_t),
};

static void pyopencv_face_StandardCollector_dealloc(PyObject* self)
{
    ((pyopencv_face_StandardCollector_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::face::StandardCollector>& r)
{
    pyopencv_face_StandardCollector_t *m = PyObject_NEW(pyopencv_face_StandardCollector_t, &pyopencv_face_StandardCollector_Type);
    new (&(m->v)) Ptr<cv::face::StandardCollector>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::face::StandardCollector>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_face_StandardCollector_Type))
    {
        failmsg("Expected cv::face::StandardCollector for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_face_StandardCollector_t*)src)->v.dynamicCast<cv::face::StandardCollector>();
    return true;
}


struct pyopencv_flann_Index_t
{
    PyObject_HEAD
    Ptr<cv::flann::Index> v;
};

static PyTypeObject pyopencv_flann_Index_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".flann_Index",
    sizeof(pyopencv_flann_Index_t),
};

static void pyopencv_flann_Index_dealloc(PyObject* self)
{
    ((pyopencv_flann_Index_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::flann::Index>& r)
{
    pyopencv_flann_Index_t *m = PyObject_NEW(pyopencv_flann_Index_t, &pyopencv_flann_Index_Type);
    new (&(m->v)) Ptr<cv::flann::Index>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::flann::Index>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_flann_Index_Type))
    {
        failmsg("Expected cv::flann::Index for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_flann_Index_t*)src)->v.dynamicCast<cv::flann::Index>();
    return true;
}


struct pyopencv_freetype_FreeType2_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_freetype_FreeType2_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".freetype_FreeType2",
    sizeof(pyopencv_freetype_FreeType2_t),
};

static void pyopencv_freetype_FreeType2_dealloc(PyObject* self)
{
    ((pyopencv_freetype_FreeType2_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::freetype::FreeType2>& r)
{
    pyopencv_freetype_FreeType2_t *m = PyObject_NEW(pyopencv_freetype_FreeType2_t, &pyopencv_freetype_FreeType2_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::freetype::FreeType2>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_freetype_FreeType2_Type))
    {
        failmsg("Expected cv::freetype::FreeType2 for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_freetype_FreeType2_t*)src)->v.dynamicCast<cv::freetype::FreeType2>();
    return true;
}


struct pyopencv_hdf_HDF5_t
{
    PyObject_HEAD
    Ptr<cv::hdf::HDF5> v;
};

static PyTypeObject pyopencv_hdf_HDF5_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".hdf_HDF5",
    sizeof(pyopencv_hdf_HDF5_t),
};

static void pyopencv_hdf_HDF5_dealloc(PyObject* self)
{
    ((pyopencv_hdf_HDF5_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::hdf::HDF5>& r)
{
    pyopencv_hdf_HDF5_t *m = PyObject_NEW(pyopencv_hdf_HDF5_t, &pyopencv_hdf_HDF5_Type);
    new (&(m->v)) Ptr<cv::hdf::HDF5>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::hdf::HDF5>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_hdf_HDF5_Type))
    {
        failmsg("Expected cv::hdf::HDF5 for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_hdf_HDF5_t*)src)->v.dynamicCast<cv::hdf::HDF5>();
    return true;
}


struct pyopencv_hfs_HfsSegment_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_hfs_HfsSegment_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".hfs_HfsSegment",
    sizeof(pyopencv_hfs_HfsSegment_t),
};

static void pyopencv_hfs_HfsSegment_dealloc(PyObject* self)
{
    ((pyopencv_hfs_HfsSegment_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::hfs::HfsSegment>& r)
{
    pyopencv_hfs_HfsSegment_t *m = PyObject_NEW(pyopencv_hfs_HfsSegment_t, &pyopencv_hfs_HfsSegment_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::hfs::HfsSegment>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_hfs_HfsSegment_Type))
    {
        failmsg("Expected cv::hfs::HfsSegment for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_hfs_HfsSegment_t*)src)->v.dynamicCast<cv::hfs::HfsSegment>();
    return true;
}


struct pyopencv_img_hash_AverageHash_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_img_hash_AverageHash_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".img_hash_AverageHash",
    sizeof(pyopencv_img_hash_AverageHash_t),
};

static void pyopencv_img_hash_AverageHash_dealloc(PyObject* self)
{
    ((pyopencv_img_hash_AverageHash_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::img_hash::AverageHash>& r)
{
    pyopencv_img_hash_AverageHash_t *m = PyObject_NEW(pyopencv_img_hash_AverageHash_t, &pyopencv_img_hash_AverageHash_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::img_hash::AverageHash>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_img_hash_AverageHash_Type))
    {
        failmsg("Expected cv::img_hash::AverageHash for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_img_hash_AverageHash_t*)src)->v.dynamicCast<cv::img_hash::AverageHash>();
    return true;
}


struct pyopencv_img_hash_BlockMeanHash_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_img_hash_BlockMeanHash_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".img_hash_BlockMeanHash",
    sizeof(pyopencv_img_hash_BlockMeanHash_t),
};

static void pyopencv_img_hash_BlockMeanHash_dealloc(PyObject* self)
{
    ((pyopencv_img_hash_BlockMeanHash_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::img_hash::BlockMeanHash>& r)
{
    pyopencv_img_hash_BlockMeanHash_t *m = PyObject_NEW(pyopencv_img_hash_BlockMeanHash_t, &pyopencv_img_hash_BlockMeanHash_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::img_hash::BlockMeanHash>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_img_hash_BlockMeanHash_Type))
    {
        failmsg("Expected cv::img_hash::BlockMeanHash for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_img_hash_BlockMeanHash_t*)src)->v.dynamicCast<cv::img_hash::BlockMeanHash>();
    return true;
}


struct pyopencv_img_hash_ColorMomentHash_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_img_hash_ColorMomentHash_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".img_hash_ColorMomentHash",
    sizeof(pyopencv_img_hash_ColorMomentHash_t),
};

static void pyopencv_img_hash_ColorMomentHash_dealloc(PyObject* self)
{
    ((pyopencv_img_hash_ColorMomentHash_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::img_hash::ColorMomentHash>& r)
{
    pyopencv_img_hash_ColorMomentHash_t *m = PyObject_NEW(pyopencv_img_hash_ColorMomentHash_t, &pyopencv_img_hash_ColorMomentHash_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::img_hash::ColorMomentHash>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_img_hash_ColorMomentHash_Type))
    {
        failmsg("Expected cv::img_hash::ColorMomentHash for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_img_hash_ColorMomentHash_t*)src)->v.dynamicCast<cv::img_hash::ColorMomentHash>();
    return true;
}


struct pyopencv_img_hash_ImgHashBase_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_img_hash_ImgHashBase_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".img_hash_ImgHashBase",
    sizeof(pyopencv_img_hash_ImgHashBase_t),
};

static void pyopencv_img_hash_ImgHashBase_dealloc(PyObject* self)
{
    ((pyopencv_img_hash_ImgHashBase_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::img_hash::ImgHashBase>& r)
{
    pyopencv_img_hash_ImgHashBase_t *m = PyObject_NEW(pyopencv_img_hash_ImgHashBase_t, &pyopencv_img_hash_ImgHashBase_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::img_hash::ImgHashBase>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_img_hash_ImgHashBase_Type))
    {
        failmsg("Expected cv::img_hash::ImgHashBase for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_img_hash_ImgHashBase_t*)src)->v.dynamicCast<cv::img_hash::ImgHashBase>();
    return true;
}


struct pyopencv_img_hash_MarrHildrethHash_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_img_hash_MarrHildrethHash_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".img_hash_MarrHildrethHash",
    sizeof(pyopencv_img_hash_MarrHildrethHash_t),
};

static void pyopencv_img_hash_MarrHildrethHash_dealloc(PyObject* self)
{
    ((pyopencv_img_hash_MarrHildrethHash_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::img_hash::MarrHildrethHash>& r)
{
    pyopencv_img_hash_MarrHildrethHash_t *m = PyObject_NEW(pyopencv_img_hash_MarrHildrethHash_t, &pyopencv_img_hash_MarrHildrethHash_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::img_hash::MarrHildrethHash>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_img_hash_MarrHildrethHash_Type))
    {
        failmsg("Expected cv::img_hash::MarrHildrethHash for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_img_hash_MarrHildrethHash_t*)src)->v.dynamicCast<cv::img_hash::MarrHildrethHash>();
    return true;
}


struct pyopencv_img_hash_PHash_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_img_hash_PHash_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".img_hash_PHash",
    sizeof(pyopencv_img_hash_PHash_t),
};

static void pyopencv_img_hash_PHash_dealloc(PyObject* self)
{
    ((pyopencv_img_hash_PHash_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::img_hash::PHash>& r)
{
    pyopencv_img_hash_PHash_t *m = PyObject_NEW(pyopencv_img_hash_PHash_t, &pyopencv_img_hash_PHash_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::img_hash::PHash>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_img_hash_PHash_Type))
    {
        failmsg("Expected cv::img_hash::PHash for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_img_hash_PHash_t*)src)->v.dynamicCast<cv::img_hash::PHash>();
    return true;
}


struct pyopencv_img_hash_RadialVarianceHash_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_img_hash_RadialVarianceHash_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".img_hash_RadialVarianceHash",
    sizeof(pyopencv_img_hash_RadialVarianceHash_t),
};

static void pyopencv_img_hash_RadialVarianceHash_dealloc(PyObject* self)
{
    ((pyopencv_img_hash_RadialVarianceHash_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::img_hash::RadialVarianceHash>& r)
{
    pyopencv_img_hash_RadialVarianceHash_t *m = PyObject_NEW(pyopencv_img_hash_RadialVarianceHash_t, &pyopencv_img_hash_RadialVarianceHash_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::img_hash::RadialVarianceHash>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_img_hash_RadialVarianceHash_Type))
    {
        failmsg("Expected cv::img_hash::RadialVarianceHash for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_img_hash_RadialVarianceHash_t*)src)->v.dynamicCast<cv::img_hash::RadialVarianceHash>();
    return true;
}


struct pyopencv_linemod_Detector_t
{
    PyObject_HEAD
    Ptr<cv::linemod::Detector> v;
};

static PyTypeObject pyopencv_linemod_Detector_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".linemod_Detector",
    sizeof(pyopencv_linemod_Detector_t),
};

static void pyopencv_linemod_Detector_dealloc(PyObject* self)
{
    ((pyopencv_linemod_Detector_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::linemod::Detector>& r)
{
    pyopencv_linemod_Detector_t *m = PyObject_NEW(pyopencv_linemod_Detector_t, &pyopencv_linemod_Detector_Type);
    new (&(m->v)) Ptr<cv::linemod::Detector>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::linemod::Detector>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_linemod_Detector_Type))
    {
        failmsg("Expected cv::linemod::Detector for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_linemod_Detector_t*)src)->v.dynamicCast<cv::linemod::Detector>();
    return true;
}


struct pyopencv_linemod_Feature_t
{
    PyObject_HEAD
    cv::linemod::Feature v;
};

static PyTypeObject pyopencv_linemod_Feature_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".linemod_Feature",
    sizeof(pyopencv_linemod_Feature_t),
};

static void pyopencv_linemod_Feature_dealloc(PyObject* self)
{
    ((pyopencv_linemod_Feature_t*)self)->v.cv::linemod::Feature::~Feature();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const cv::linemod::Feature& r)
{
    pyopencv_linemod_Feature_t *m = PyObject_NEW(pyopencv_linemod_Feature_t, &pyopencv_linemod_Feature_Type);
    new (&m->v) cv::linemod::Feature(r); //Copy constructor
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, cv::linemod::Feature& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_linemod_Feature_Type))
    {
        failmsg("Expected cv::linemod::Feature for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_linemod_Feature_t*)src)->v;
    return true;
}

struct pyopencv_linemod_Match_t
{
    PyObject_HEAD
    cv::linemod::Match v;
};

static PyTypeObject pyopencv_linemod_Match_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".linemod_Match",
    sizeof(pyopencv_linemod_Match_t),
};

static void pyopencv_linemod_Match_dealloc(PyObject* self)
{
    ((pyopencv_linemod_Match_t*)self)->v.cv::linemod::Match::~Match();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const cv::linemod::Match& r)
{
    pyopencv_linemod_Match_t *m = PyObject_NEW(pyopencv_linemod_Match_t, &pyopencv_linemod_Match_Type);
    new (&m->v) cv::linemod::Match(r); //Copy constructor
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, cv::linemod::Match& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_linemod_Match_Type))
    {
        failmsg("Expected cv::linemod::Match for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_linemod_Match_t*)src)->v;
    return true;
}

struct pyopencv_linemod_Modality_t
{
    PyObject_HEAD
    Ptr<cv::linemod::Modality> v;
};

static PyTypeObject pyopencv_linemod_Modality_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".linemod_Modality",
    sizeof(pyopencv_linemod_Modality_t),
};

static void pyopencv_linemod_Modality_dealloc(PyObject* self)
{
    ((pyopencv_linemod_Modality_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::linemod::Modality>& r)
{
    pyopencv_linemod_Modality_t *m = PyObject_NEW(pyopencv_linemod_Modality_t, &pyopencv_linemod_Modality_Type);
    new (&(m->v)) Ptr<cv::linemod::Modality>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::linemod::Modality>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_linemod_Modality_Type))
    {
        failmsg("Expected cv::linemod::Modality for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_linemod_Modality_t*)src)->v.dynamicCast<cv::linemod::Modality>();
    return true;
}


struct pyopencv_linemod_QuantizedPyramid_t
{
    PyObject_HEAD
    Ptr<cv::linemod::QuantizedPyramid> v;
};

static PyTypeObject pyopencv_linemod_QuantizedPyramid_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".linemod_QuantizedPyramid",
    sizeof(pyopencv_linemod_QuantizedPyramid_t),
};

static void pyopencv_linemod_QuantizedPyramid_dealloc(PyObject* self)
{
    ((pyopencv_linemod_QuantizedPyramid_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::linemod::QuantizedPyramid>& r)
{
    pyopencv_linemod_QuantizedPyramid_t *m = PyObject_NEW(pyopencv_linemod_QuantizedPyramid_t, &pyopencv_linemod_QuantizedPyramid_Type);
    new (&(m->v)) Ptr<cv::linemod::QuantizedPyramid>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::linemod::QuantizedPyramid>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_linemod_QuantizedPyramid_Type))
    {
        failmsg("Expected cv::linemod::QuantizedPyramid for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_linemod_QuantizedPyramid_t*)src)->v.dynamicCast<cv::linemod::QuantizedPyramid>();
    return true;
}


struct pyopencv_linemod_Template_t
{
    PyObject_HEAD
    cv::linemod::Template v;
};

static PyTypeObject pyopencv_linemod_Template_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".linemod_Template",
    sizeof(pyopencv_linemod_Template_t),
};

static void pyopencv_linemod_Template_dealloc(PyObject* self)
{
    ((pyopencv_linemod_Template_t*)self)->v.cv::linemod::Template::~Template();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const cv::linemod::Template& r)
{
    pyopencv_linemod_Template_t *m = PyObject_NEW(pyopencv_linemod_Template_t, &pyopencv_linemod_Template_Type);
    new (&m->v) cv::linemod::Template(r); //Copy constructor
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, cv::linemod::Template& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_linemod_Template_Type))
    {
        failmsg("Expected cv::linemod::Template for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_linemod_Template_t*)src)->v;
    return true;
}

struct pyopencv_ml_ANN_MLP_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ml_ANN_MLP_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ml_ANN_MLP",
    sizeof(pyopencv_ml_ANN_MLP_t),
};

static void pyopencv_ml_ANN_MLP_dealloc(PyObject* self)
{
    ((pyopencv_ml_ANN_MLP_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ml::ANN_MLP>& r)
{
    pyopencv_ml_ANN_MLP_t *m = PyObject_NEW(pyopencv_ml_ANN_MLP_t, &pyopencv_ml_ANN_MLP_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ml::ANN_MLP>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ml_ANN_MLP_Type))
    {
        failmsg("Expected cv::ml::ANN_MLP for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ml_ANN_MLP_t*)src)->v.dynamicCast<cv::ml::ANN_MLP>();
    return true;
}


struct pyopencv_ml_ANN_MLP_ANNEAL_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ml_ANN_MLP_ANNEAL_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ml_ANN_MLP_ANNEAL",
    sizeof(pyopencv_ml_ANN_MLP_ANNEAL_t),
};

static void pyopencv_ml_ANN_MLP_ANNEAL_dealloc(PyObject* self)
{
    ((pyopencv_ml_ANN_MLP_ANNEAL_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ml::ANN_MLP_ANNEAL>& r)
{
    pyopencv_ml_ANN_MLP_ANNEAL_t *m = PyObject_NEW(pyopencv_ml_ANN_MLP_ANNEAL_t, &pyopencv_ml_ANN_MLP_ANNEAL_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ml::ANN_MLP_ANNEAL>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ml_ANN_MLP_ANNEAL_Type))
    {
        failmsg("Expected cv::ml::ANN_MLP_ANNEAL for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ml_ANN_MLP_ANNEAL_t*)src)->v.dynamicCast<cv::ml::ANN_MLP_ANNEAL>();
    return true;
}


struct pyopencv_ml_Boost_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ml_Boost_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ml_Boost",
    sizeof(pyopencv_ml_Boost_t),
};

static void pyopencv_ml_Boost_dealloc(PyObject* self)
{
    ((pyopencv_ml_Boost_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ml::Boost>& r)
{
    pyopencv_ml_Boost_t *m = PyObject_NEW(pyopencv_ml_Boost_t, &pyopencv_ml_Boost_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ml::Boost>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ml_Boost_Type))
    {
        failmsg("Expected cv::ml::Boost for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ml_Boost_t*)src)->v.dynamicCast<cv::ml::Boost>();
    return true;
}


struct pyopencv_ml_DTrees_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ml_DTrees_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ml_DTrees",
    sizeof(pyopencv_ml_DTrees_t),
};

static void pyopencv_ml_DTrees_dealloc(PyObject* self)
{
    ((pyopencv_ml_DTrees_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ml::DTrees>& r)
{
    pyopencv_ml_DTrees_t *m = PyObject_NEW(pyopencv_ml_DTrees_t, &pyopencv_ml_DTrees_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ml::DTrees>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ml_DTrees_Type))
    {
        failmsg("Expected cv::ml::DTrees for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ml_DTrees_t*)src)->v.dynamicCast<cv::ml::DTrees>();
    return true;
}


struct pyopencv_ml_EM_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ml_EM_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ml_EM",
    sizeof(pyopencv_ml_EM_t),
};

static void pyopencv_ml_EM_dealloc(PyObject* self)
{
    ((pyopencv_ml_EM_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ml::EM>& r)
{
    pyopencv_ml_EM_t *m = PyObject_NEW(pyopencv_ml_EM_t, &pyopencv_ml_EM_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ml::EM>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ml_EM_Type))
    {
        failmsg("Expected cv::ml::EM for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ml_EM_t*)src)->v.dynamicCast<cv::ml::EM>();
    return true;
}


struct pyopencv_ml_KNearest_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ml_KNearest_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ml_KNearest",
    sizeof(pyopencv_ml_KNearest_t),
};

static void pyopencv_ml_KNearest_dealloc(PyObject* self)
{
    ((pyopencv_ml_KNearest_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ml::KNearest>& r)
{
    pyopencv_ml_KNearest_t *m = PyObject_NEW(pyopencv_ml_KNearest_t, &pyopencv_ml_KNearest_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ml::KNearest>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ml_KNearest_Type))
    {
        failmsg("Expected cv::ml::KNearest for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ml_KNearest_t*)src)->v.dynamicCast<cv::ml::KNearest>();
    return true;
}


struct pyopencv_ml_LogisticRegression_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ml_LogisticRegression_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ml_LogisticRegression",
    sizeof(pyopencv_ml_LogisticRegression_t),
};

static void pyopencv_ml_LogisticRegression_dealloc(PyObject* self)
{
    ((pyopencv_ml_LogisticRegression_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ml::LogisticRegression>& r)
{
    pyopencv_ml_LogisticRegression_t *m = PyObject_NEW(pyopencv_ml_LogisticRegression_t, &pyopencv_ml_LogisticRegression_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ml::LogisticRegression>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ml_LogisticRegression_Type))
    {
        failmsg("Expected cv::ml::LogisticRegression for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ml_LogisticRegression_t*)src)->v.dynamicCast<cv::ml::LogisticRegression>();
    return true;
}


struct pyopencv_ml_NormalBayesClassifier_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ml_NormalBayesClassifier_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ml_NormalBayesClassifier",
    sizeof(pyopencv_ml_NormalBayesClassifier_t),
};

static void pyopencv_ml_NormalBayesClassifier_dealloc(PyObject* self)
{
    ((pyopencv_ml_NormalBayesClassifier_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ml::NormalBayesClassifier>& r)
{
    pyopencv_ml_NormalBayesClassifier_t *m = PyObject_NEW(pyopencv_ml_NormalBayesClassifier_t, &pyopencv_ml_NormalBayesClassifier_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ml::NormalBayesClassifier>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ml_NormalBayesClassifier_Type))
    {
        failmsg("Expected cv::ml::NormalBayesClassifier for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ml_NormalBayesClassifier_t*)src)->v.dynamicCast<cv::ml::NormalBayesClassifier>();
    return true;
}


struct pyopencv_ml_ParamGrid_t
{
    PyObject_HEAD
    Ptr<cv::ml::ParamGrid> v;
};

static PyTypeObject pyopencv_ml_ParamGrid_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ml_ParamGrid",
    sizeof(pyopencv_ml_ParamGrid_t),
};

static void pyopencv_ml_ParamGrid_dealloc(PyObject* self)
{
    ((pyopencv_ml_ParamGrid_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ml::ParamGrid>& r)
{
    pyopencv_ml_ParamGrid_t *m = PyObject_NEW(pyopencv_ml_ParamGrid_t, &pyopencv_ml_ParamGrid_Type);
    new (&(m->v)) Ptr<cv::ml::ParamGrid>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ml::ParamGrid>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ml_ParamGrid_Type))
    {
        failmsg("Expected cv::ml::ParamGrid for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ml_ParamGrid_t*)src)->v.dynamicCast<cv::ml::ParamGrid>();
    return true;
}


struct pyopencv_ml_RTrees_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ml_RTrees_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ml_RTrees",
    sizeof(pyopencv_ml_RTrees_t),
};

static void pyopencv_ml_RTrees_dealloc(PyObject* self)
{
    ((pyopencv_ml_RTrees_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ml::RTrees>& r)
{
    pyopencv_ml_RTrees_t *m = PyObject_NEW(pyopencv_ml_RTrees_t, &pyopencv_ml_RTrees_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ml::RTrees>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ml_RTrees_Type))
    {
        failmsg("Expected cv::ml::RTrees for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ml_RTrees_t*)src)->v.dynamicCast<cv::ml::RTrees>();
    return true;
}


struct pyopencv_ml_SVM_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ml_SVM_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ml_SVM",
    sizeof(pyopencv_ml_SVM_t),
};

static void pyopencv_ml_SVM_dealloc(PyObject* self)
{
    ((pyopencv_ml_SVM_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ml::SVM>& r)
{
    pyopencv_ml_SVM_t *m = PyObject_NEW(pyopencv_ml_SVM_t, &pyopencv_ml_SVM_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ml::SVM>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ml_SVM_Type))
    {
        failmsg("Expected cv::ml::SVM for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ml_SVM_t*)src)->v.dynamicCast<cv::ml::SVM>();
    return true;
}


struct pyopencv_ml_SVMSGD_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ml_SVMSGD_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ml_SVMSGD",
    sizeof(pyopencv_ml_SVMSGD_t),
};

static void pyopencv_ml_SVMSGD_dealloc(PyObject* self)
{
    ((pyopencv_ml_SVMSGD_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ml::SVMSGD>& r)
{
    pyopencv_ml_SVMSGD_t *m = PyObject_NEW(pyopencv_ml_SVMSGD_t, &pyopencv_ml_SVMSGD_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ml::SVMSGD>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ml_SVMSGD_Type))
    {
        failmsg("Expected cv::ml::SVMSGD for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ml_SVMSGD_t*)src)->v.dynamicCast<cv::ml::SVMSGD>();
    return true;
}


struct pyopencv_ml_StatModel_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ml_StatModel_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ml_StatModel",
    sizeof(pyopencv_ml_StatModel_t),
};

static void pyopencv_ml_StatModel_dealloc(PyObject* self)
{
    ((pyopencv_ml_StatModel_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ml::StatModel>& r)
{
    pyopencv_ml_StatModel_t *m = PyObject_NEW(pyopencv_ml_StatModel_t, &pyopencv_ml_StatModel_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ml::StatModel>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ml_StatModel_Type))
    {
        failmsg("Expected cv::ml::StatModel for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ml_StatModel_t*)src)->v.dynamicCast<cv::ml::StatModel>();
    return true;
}


struct pyopencv_ml_TrainData_t
{
    PyObject_HEAD
    Ptr<cv::ml::TrainData> v;
};

static PyTypeObject pyopencv_ml_TrainData_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ml_TrainData",
    sizeof(pyopencv_ml_TrainData_t),
};

static void pyopencv_ml_TrainData_dealloc(PyObject* self)
{
    ((pyopencv_ml_TrainData_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ml::TrainData>& r)
{
    pyopencv_ml_TrainData_t *m = PyObject_NEW(pyopencv_ml_TrainData_t, &pyopencv_ml_TrainData_Type);
    new (&(m->v)) Ptr<cv::ml::TrainData>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ml::TrainData>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ml_TrainData_Type))
    {
        failmsg("Expected cv::ml::TrainData for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ml_TrainData_t*)src)->v.dynamicCast<cv::ml::TrainData>();
    return true;
}


struct pyopencv_optflow_DISOpticalFlow_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_optflow_DISOpticalFlow_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".optflow_DISOpticalFlow",
    sizeof(pyopencv_optflow_DISOpticalFlow_t),
};

static void pyopencv_optflow_DISOpticalFlow_dealloc(PyObject* self)
{
    ((pyopencv_optflow_DISOpticalFlow_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::optflow::DISOpticalFlow>& r)
{
    pyopencv_optflow_DISOpticalFlow_t *m = PyObject_NEW(pyopencv_optflow_DISOpticalFlow_t, &pyopencv_optflow_DISOpticalFlow_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::optflow::DISOpticalFlow>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_optflow_DISOpticalFlow_Type))
    {
        failmsg("Expected cv::optflow::DISOpticalFlow for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_optflow_DISOpticalFlow_t*)src)->v.dynamicCast<cv::optflow::DISOpticalFlow>();
    return true;
}


struct pyopencv_optflow_GPCDetails_t
{
    PyObject_HEAD
    Ptr<cv::optflow::GPCDetails> v;
};

static PyTypeObject pyopencv_optflow_GPCDetails_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".optflow_GPCDetails",
    sizeof(pyopencv_optflow_GPCDetails_t),
};

static void pyopencv_optflow_GPCDetails_dealloc(PyObject* self)
{
    ((pyopencv_optflow_GPCDetails_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::optflow::GPCDetails>& r)
{
    pyopencv_optflow_GPCDetails_t *m = PyObject_NEW(pyopencv_optflow_GPCDetails_t, &pyopencv_optflow_GPCDetails_Type);
    new (&(m->v)) Ptr<cv::optflow::GPCDetails>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::optflow::GPCDetails>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_optflow_GPCDetails_Type))
    {
        failmsg("Expected cv::optflow::GPCDetails for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_optflow_GPCDetails_t*)src)->v.dynamicCast<cv::optflow::GPCDetails>();
    return true;
}


struct pyopencv_optflow_GPCPatchDescriptor_t
{
    PyObject_HEAD
    Ptr<cv::optflow::GPCPatchDescriptor> v;
};

static PyTypeObject pyopencv_optflow_GPCPatchDescriptor_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".optflow_GPCPatchDescriptor",
    sizeof(pyopencv_optflow_GPCPatchDescriptor_t),
};

static void pyopencv_optflow_GPCPatchDescriptor_dealloc(PyObject* self)
{
    ((pyopencv_optflow_GPCPatchDescriptor_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::optflow::GPCPatchDescriptor>& r)
{
    pyopencv_optflow_GPCPatchDescriptor_t *m = PyObject_NEW(pyopencv_optflow_GPCPatchDescriptor_t, &pyopencv_optflow_GPCPatchDescriptor_Type);
    new (&(m->v)) Ptr<cv::optflow::GPCPatchDescriptor>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::optflow::GPCPatchDescriptor>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_optflow_GPCPatchDescriptor_Type))
    {
        failmsg("Expected cv::optflow::GPCPatchDescriptor for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_optflow_GPCPatchDescriptor_t*)src)->v.dynamicCast<cv::optflow::GPCPatchDescriptor>();
    return true;
}


struct pyopencv_optflow_GPCPatchSample_t
{
    PyObject_HEAD
    Ptr<cv::optflow::GPCPatchSample> v;
};

static PyTypeObject pyopencv_optflow_GPCPatchSample_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".optflow_GPCPatchSample",
    sizeof(pyopencv_optflow_GPCPatchSample_t),
};

static void pyopencv_optflow_GPCPatchSample_dealloc(PyObject* self)
{
    ((pyopencv_optflow_GPCPatchSample_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::optflow::GPCPatchSample>& r)
{
    pyopencv_optflow_GPCPatchSample_t *m = PyObject_NEW(pyopencv_optflow_GPCPatchSample_t, &pyopencv_optflow_GPCPatchSample_Type);
    new (&(m->v)) Ptr<cv::optflow::GPCPatchSample>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::optflow::GPCPatchSample>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_optflow_GPCPatchSample_Type))
    {
        failmsg("Expected cv::optflow::GPCPatchSample for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_optflow_GPCPatchSample_t*)src)->v.dynamicCast<cv::optflow::GPCPatchSample>();
    return true;
}


struct pyopencv_optflow_GPCTrainingSamples_t
{
    PyObject_HEAD
    Ptr<cv::optflow::GPCTrainingSamples> v;
};

static PyTypeObject pyopencv_optflow_GPCTrainingSamples_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".optflow_GPCTrainingSamples",
    sizeof(pyopencv_optflow_GPCTrainingSamples_t),
};

static void pyopencv_optflow_GPCTrainingSamples_dealloc(PyObject* self)
{
    ((pyopencv_optflow_GPCTrainingSamples_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::optflow::GPCTrainingSamples>& r)
{
    pyopencv_optflow_GPCTrainingSamples_t *m = PyObject_NEW(pyopencv_optflow_GPCTrainingSamples_t, &pyopencv_optflow_GPCTrainingSamples_Type);
    new (&(m->v)) Ptr<cv::optflow::GPCTrainingSamples>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::optflow::GPCTrainingSamples>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_optflow_GPCTrainingSamples_Type))
    {
        failmsg("Expected cv::optflow::GPCTrainingSamples for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_optflow_GPCTrainingSamples_t*)src)->v.dynamicCast<cv::optflow::GPCTrainingSamples>();
    return true;
}


struct pyopencv_optflow_GPCTree_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_optflow_GPCTree_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".optflow_GPCTree",
    sizeof(pyopencv_optflow_GPCTree_t),
};

static void pyopencv_optflow_GPCTree_dealloc(PyObject* self)
{
    ((pyopencv_optflow_GPCTree_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::optflow::GPCTree>& r)
{
    pyopencv_optflow_GPCTree_t *m = PyObject_NEW(pyopencv_optflow_GPCTree_t, &pyopencv_optflow_GPCTree_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::optflow::GPCTree>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_optflow_GPCTree_Type))
    {
        failmsg("Expected cv::optflow::GPCTree for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_optflow_GPCTree_t*)src)->v.dynamicCast<cv::optflow::GPCTree>();
    return true;
}


struct pyopencv_optflow_OpticalFlowPCAFlow_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_optflow_OpticalFlowPCAFlow_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".optflow_OpticalFlowPCAFlow",
    sizeof(pyopencv_optflow_OpticalFlowPCAFlow_t),
};

static void pyopencv_optflow_OpticalFlowPCAFlow_dealloc(PyObject* self)
{
    ((pyopencv_optflow_OpticalFlowPCAFlow_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::optflow::OpticalFlowPCAFlow>& r)
{
    pyopencv_optflow_OpticalFlowPCAFlow_t *m = PyObject_NEW(pyopencv_optflow_OpticalFlowPCAFlow_t, &pyopencv_optflow_OpticalFlowPCAFlow_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::optflow::OpticalFlowPCAFlow>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_optflow_OpticalFlowPCAFlow_Type))
    {
        failmsg("Expected cv::optflow::OpticalFlowPCAFlow for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_optflow_OpticalFlowPCAFlow_t*)src)->v.dynamicCast<cv::optflow::OpticalFlowPCAFlow>();
    return true;
}


struct pyopencv_optflow_PCAPrior_t
{
    PyObject_HEAD
    Ptr<cv::optflow::PCAPrior> v;
};

static PyTypeObject pyopencv_optflow_PCAPrior_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".optflow_PCAPrior",
    sizeof(pyopencv_optflow_PCAPrior_t),
};

static void pyopencv_optflow_PCAPrior_dealloc(PyObject* self)
{
    ((pyopencv_optflow_PCAPrior_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::optflow::PCAPrior>& r)
{
    pyopencv_optflow_PCAPrior_t *m = PyObject_NEW(pyopencv_optflow_PCAPrior_t, &pyopencv_optflow_PCAPrior_Type);
    new (&(m->v)) Ptr<cv::optflow::PCAPrior>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::optflow::PCAPrior>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_optflow_PCAPrior_Type))
    {
        failmsg("Expected cv::optflow::PCAPrior for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_optflow_PCAPrior_t*)src)->v.dynamicCast<cv::optflow::PCAPrior>();
    return true;
}


struct pyopencv_optflow_VariationalRefinement_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_optflow_VariationalRefinement_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".optflow_VariationalRefinement",
    sizeof(pyopencv_optflow_VariationalRefinement_t),
};

static void pyopencv_optflow_VariationalRefinement_dealloc(PyObject* self)
{
    ((pyopencv_optflow_VariationalRefinement_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::optflow::VariationalRefinement>& r)
{
    pyopencv_optflow_VariationalRefinement_t *m = PyObject_NEW(pyopencv_optflow_VariationalRefinement_t, &pyopencv_optflow_VariationalRefinement_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::optflow::VariationalRefinement>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_optflow_VariationalRefinement_Type))
    {
        failmsg("Expected cv::optflow::VariationalRefinement for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_optflow_VariationalRefinement_t*)src)->v.dynamicCast<cv::optflow::VariationalRefinement>();
    return true;
}


struct pyopencv_phase_unwrapping_HistogramPhaseUnwrapping_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_phase_unwrapping_HistogramPhaseUnwrapping_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".phase_unwrapping_HistogramPhaseUnwrapping",
    sizeof(pyopencv_phase_unwrapping_HistogramPhaseUnwrapping_t),
};

static void pyopencv_phase_unwrapping_HistogramPhaseUnwrapping_dealloc(PyObject* self)
{
    ((pyopencv_phase_unwrapping_HistogramPhaseUnwrapping_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::phase_unwrapping::HistogramPhaseUnwrapping>& r)
{
    pyopencv_phase_unwrapping_HistogramPhaseUnwrapping_t *m = PyObject_NEW(pyopencv_phase_unwrapping_HistogramPhaseUnwrapping_t, &pyopencv_phase_unwrapping_HistogramPhaseUnwrapping_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::phase_unwrapping::HistogramPhaseUnwrapping>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_phase_unwrapping_HistogramPhaseUnwrapping_Type))
    {
        failmsg("Expected cv::phase_unwrapping::HistogramPhaseUnwrapping for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_phase_unwrapping_HistogramPhaseUnwrapping_t*)src)->v.dynamicCast<cv::phase_unwrapping::HistogramPhaseUnwrapping>();
    return true;
}


struct pyopencv_phase_unwrapping_PhaseUnwrapping_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_phase_unwrapping_PhaseUnwrapping_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".phase_unwrapping_PhaseUnwrapping",
    sizeof(pyopencv_phase_unwrapping_PhaseUnwrapping_t),
};

static void pyopencv_phase_unwrapping_PhaseUnwrapping_dealloc(PyObject* self)
{
    ((pyopencv_phase_unwrapping_PhaseUnwrapping_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::phase_unwrapping::PhaseUnwrapping>& r)
{
    pyopencv_phase_unwrapping_PhaseUnwrapping_t *m = PyObject_NEW(pyopencv_phase_unwrapping_PhaseUnwrapping_t, &pyopencv_phase_unwrapping_PhaseUnwrapping_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::phase_unwrapping::PhaseUnwrapping>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_phase_unwrapping_PhaseUnwrapping_Type))
    {
        failmsg("Expected cv::phase_unwrapping::PhaseUnwrapping for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_phase_unwrapping_PhaseUnwrapping_t*)src)->v.dynamicCast<cv::phase_unwrapping::PhaseUnwrapping>();
    return true;
}


struct pyopencv_plot_Plot2d_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_plot_Plot2d_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".plot_Plot2d",
    sizeof(pyopencv_plot_Plot2d_t),
};

static void pyopencv_plot_Plot2d_dealloc(PyObject* self)
{
    ((pyopencv_plot_Plot2d_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::plot::Plot2d>& r)
{
    pyopencv_plot_Plot2d_t *m = PyObject_NEW(pyopencv_plot_Plot2d_t, &pyopencv_plot_Plot2d_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::plot::Plot2d>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_plot_Plot2d_Type))
    {
        failmsg("Expected cv::plot::Plot2d for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_plot_Plot2d_t*)src)->v.dynamicCast<cv::plot::Plot2d>();
    return true;
}


struct pyopencv_ppf_match_3d_ICP_t
{
    PyObject_HEAD
    Ptr<cv::ppf_match_3d::ICP> v;
};

static PyTypeObject pyopencv_ppf_match_3d_ICP_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ppf_match_3d_ICP",
    sizeof(pyopencv_ppf_match_3d_ICP_t),
};

static void pyopencv_ppf_match_3d_ICP_dealloc(PyObject* self)
{
    ((pyopencv_ppf_match_3d_ICP_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ppf_match_3d::ICP>& r)
{
    pyopencv_ppf_match_3d_ICP_t *m = PyObject_NEW(pyopencv_ppf_match_3d_ICP_t, &pyopencv_ppf_match_3d_ICP_Type);
    new (&(m->v)) Ptr<cv::ppf_match_3d::ICP>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ppf_match_3d::ICP>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ppf_match_3d_ICP_Type))
    {
        failmsg("Expected cv::ppf_match_3d::ICP for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ppf_match_3d_ICP_t*)src)->v.dynamicCast<cv::ppf_match_3d::ICP>();
    return true;
}


struct pyopencv_ppf_match_3d_PPF3DDetector_t
{
    PyObject_HEAD
    Ptr<cv::ppf_match_3d::PPF3DDetector> v;
};

static PyTypeObject pyopencv_ppf_match_3d_PPF3DDetector_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ppf_match_3d_PPF3DDetector",
    sizeof(pyopencv_ppf_match_3d_PPF3DDetector_t),
};

static void pyopencv_ppf_match_3d_PPF3DDetector_dealloc(PyObject* self)
{
    ((pyopencv_ppf_match_3d_PPF3DDetector_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ppf_match_3d::PPF3DDetector>& r)
{
    pyopencv_ppf_match_3d_PPF3DDetector_t *m = PyObject_NEW(pyopencv_ppf_match_3d_PPF3DDetector_t, &pyopencv_ppf_match_3d_PPF3DDetector_Type);
    new (&(m->v)) Ptr<cv::ppf_match_3d::PPF3DDetector>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ppf_match_3d::PPF3DDetector>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ppf_match_3d_PPF3DDetector_Type))
    {
        failmsg("Expected cv::ppf_match_3d::PPF3DDetector for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ppf_match_3d_PPF3DDetector_t*)src)->v.dynamicCast<cv::ppf_match_3d::PPF3DDetector>();
    return true;
}


struct pyopencv_ppf_match_3d_PoseCluster3D_t
{
    PyObject_HEAD
    Ptr<cv::ppf_match_3d::PoseCluster3D> v;
};

static PyTypeObject pyopencv_ppf_match_3d_PoseCluster3D_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ppf_match_3d_PoseCluster3D",
    sizeof(pyopencv_ppf_match_3d_PoseCluster3D_t),
};

static void pyopencv_ppf_match_3d_PoseCluster3D_dealloc(PyObject* self)
{
    ((pyopencv_ppf_match_3d_PoseCluster3D_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ppf_match_3d::PoseCluster3D>& r)
{
    pyopencv_ppf_match_3d_PoseCluster3D_t *m = PyObject_NEW(pyopencv_ppf_match_3d_PoseCluster3D_t, &pyopencv_ppf_match_3d_PoseCluster3D_Type);
    new (&(m->v)) Ptr<cv::ppf_match_3d::PoseCluster3D>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ppf_match_3d::PoseCluster3D>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ppf_match_3d_PoseCluster3D_Type))
    {
        failmsg("Expected cv::ppf_match_3d::PoseCluster3D for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ppf_match_3d_PoseCluster3D_t*)src)->v.dynamicCast<cv::ppf_match_3d::PoseCluster3D>();
    return true;
}


struct pyopencv_reg_Map_t
{
    PyObject_HEAD
    Ptr<cv::reg::Map> v;
};

static PyTypeObject pyopencv_reg_Map_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".reg_Map",
    sizeof(pyopencv_reg_Map_t),
};

static void pyopencv_reg_Map_dealloc(PyObject* self)
{
    ((pyopencv_reg_Map_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::reg::Map>& r)
{
    pyopencv_reg_Map_t *m = PyObject_NEW(pyopencv_reg_Map_t, &pyopencv_reg_Map_Type);
    new (&(m->v)) Ptr<cv::reg::Map>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::reg::Map>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_reg_Map_Type))
    {
        failmsg("Expected cv::reg::Map for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_reg_Map_t*)src)->v.dynamicCast<cv::reg::Map>();
    return true;
}


struct pyopencv_reg_MapAffine_t
{
    PyObject_HEAD
    Ptr<cv::reg::MapAffine> v;
};

static PyTypeObject pyopencv_reg_MapAffine_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".reg_MapAffine",
    sizeof(pyopencv_reg_MapAffine_t),
};

static void pyopencv_reg_MapAffine_dealloc(PyObject* self)
{
    ((pyopencv_reg_MapAffine_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::reg::MapAffine>& r)
{
    pyopencv_reg_MapAffine_t *m = PyObject_NEW(pyopencv_reg_MapAffine_t, &pyopencv_reg_MapAffine_Type);
    new (&(m->v)) Ptr<cv::reg::MapAffine>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::reg::MapAffine>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_reg_MapAffine_Type))
    {
        failmsg("Expected cv::reg::MapAffine for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_reg_MapAffine_t*)src)->v.dynamicCast<cv::reg::MapAffine>();
    return true;
}


struct pyopencv_reg_MapProjec_t
{
    PyObject_HEAD
    Ptr<cv::reg::MapProjec> v;
};

static PyTypeObject pyopencv_reg_MapProjec_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".reg_MapProjec",
    sizeof(pyopencv_reg_MapProjec_t),
};

static void pyopencv_reg_MapProjec_dealloc(PyObject* self)
{
    ((pyopencv_reg_MapProjec_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::reg::MapProjec>& r)
{
    pyopencv_reg_MapProjec_t *m = PyObject_NEW(pyopencv_reg_MapProjec_t, &pyopencv_reg_MapProjec_Type);
    new (&(m->v)) Ptr<cv::reg::MapProjec>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::reg::MapProjec>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_reg_MapProjec_Type))
    {
        failmsg("Expected cv::reg::MapProjec for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_reg_MapProjec_t*)src)->v.dynamicCast<cv::reg::MapProjec>();
    return true;
}


struct pyopencv_reg_MapShift_t
{
    PyObject_HEAD
    Ptr<cv::reg::MapShift> v;
};

static PyTypeObject pyopencv_reg_MapShift_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".reg_MapShift",
    sizeof(pyopencv_reg_MapShift_t),
};

static void pyopencv_reg_MapShift_dealloc(PyObject* self)
{
    ((pyopencv_reg_MapShift_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::reg::MapShift>& r)
{
    pyopencv_reg_MapShift_t *m = PyObject_NEW(pyopencv_reg_MapShift_t, &pyopencv_reg_MapShift_Type);
    new (&(m->v)) Ptr<cv::reg::MapShift>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::reg::MapShift>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_reg_MapShift_Type))
    {
        failmsg("Expected cv::reg::MapShift for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_reg_MapShift_t*)src)->v.dynamicCast<cv::reg::MapShift>();
    return true;
}


struct pyopencv_reg_MapTypeCaster_t
{
    PyObject_HEAD
    Ptr<cv::reg::MapTypeCaster> v;
};

static PyTypeObject pyopencv_reg_MapTypeCaster_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".reg_MapTypeCaster",
    sizeof(pyopencv_reg_MapTypeCaster_t),
};

static void pyopencv_reg_MapTypeCaster_dealloc(PyObject* self)
{
    ((pyopencv_reg_MapTypeCaster_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::reg::MapTypeCaster>& r)
{
    pyopencv_reg_MapTypeCaster_t *m = PyObject_NEW(pyopencv_reg_MapTypeCaster_t, &pyopencv_reg_MapTypeCaster_Type);
    new (&(m->v)) Ptr<cv::reg::MapTypeCaster>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::reg::MapTypeCaster>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_reg_MapTypeCaster_Type))
    {
        failmsg("Expected cv::reg::MapTypeCaster for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_reg_MapTypeCaster_t*)src)->v.dynamicCast<cv::reg::MapTypeCaster>();
    return true;
}


struct pyopencv_reg_Mapper_t
{
    PyObject_HEAD
    Ptr<cv::reg::Mapper> v;
};

static PyTypeObject pyopencv_reg_Mapper_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".reg_Mapper",
    sizeof(pyopencv_reg_Mapper_t),
};

static void pyopencv_reg_Mapper_dealloc(PyObject* self)
{
    ((pyopencv_reg_Mapper_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::reg::Mapper>& r)
{
    pyopencv_reg_Mapper_t *m = PyObject_NEW(pyopencv_reg_Mapper_t, &pyopencv_reg_Mapper_Type);
    new (&(m->v)) Ptr<cv::reg::Mapper>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::reg::Mapper>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_reg_Mapper_Type))
    {
        failmsg("Expected cv::reg::Mapper for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_reg_Mapper_t*)src)->v.dynamicCast<cv::reg::Mapper>();
    return true;
}


struct pyopencv_reg_MapperGradAffine_t
{
    PyObject_HEAD
    Ptr<cv::reg::MapperGradAffine> v;
};

static PyTypeObject pyopencv_reg_MapperGradAffine_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".reg_MapperGradAffine",
    sizeof(pyopencv_reg_MapperGradAffine_t),
};

static void pyopencv_reg_MapperGradAffine_dealloc(PyObject* self)
{
    ((pyopencv_reg_MapperGradAffine_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::reg::MapperGradAffine>& r)
{
    pyopencv_reg_MapperGradAffine_t *m = PyObject_NEW(pyopencv_reg_MapperGradAffine_t, &pyopencv_reg_MapperGradAffine_Type);
    new (&(m->v)) Ptr<cv::reg::MapperGradAffine>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::reg::MapperGradAffine>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_reg_MapperGradAffine_Type))
    {
        failmsg("Expected cv::reg::MapperGradAffine for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_reg_MapperGradAffine_t*)src)->v.dynamicCast<cv::reg::MapperGradAffine>();
    return true;
}


struct pyopencv_reg_MapperGradEuclid_t
{
    PyObject_HEAD
    Ptr<cv::reg::MapperGradEuclid> v;
};

static PyTypeObject pyopencv_reg_MapperGradEuclid_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".reg_MapperGradEuclid",
    sizeof(pyopencv_reg_MapperGradEuclid_t),
};

static void pyopencv_reg_MapperGradEuclid_dealloc(PyObject* self)
{
    ((pyopencv_reg_MapperGradEuclid_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::reg::MapperGradEuclid>& r)
{
    pyopencv_reg_MapperGradEuclid_t *m = PyObject_NEW(pyopencv_reg_MapperGradEuclid_t, &pyopencv_reg_MapperGradEuclid_Type);
    new (&(m->v)) Ptr<cv::reg::MapperGradEuclid>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::reg::MapperGradEuclid>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_reg_MapperGradEuclid_Type))
    {
        failmsg("Expected cv::reg::MapperGradEuclid for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_reg_MapperGradEuclid_t*)src)->v.dynamicCast<cv::reg::MapperGradEuclid>();
    return true;
}


struct pyopencv_reg_MapperGradProj_t
{
    PyObject_HEAD
    Ptr<cv::reg::MapperGradProj> v;
};

static PyTypeObject pyopencv_reg_MapperGradProj_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".reg_MapperGradProj",
    sizeof(pyopencv_reg_MapperGradProj_t),
};

static void pyopencv_reg_MapperGradProj_dealloc(PyObject* self)
{
    ((pyopencv_reg_MapperGradProj_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::reg::MapperGradProj>& r)
{
    pyopencv_reg_MapperGradProj_t *m = PyObject_NEW(pyopencv_reg_MapperGradProj_t, &pyopencv_reg_MapperGradProj_Type);
    new (&(m->v)) Ptr<cv::reg::MapperGradProj>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::reg::MapperGradProj>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_reg_MapperGradProj_Type))
    {
        failmsg("Expected cv::reg::MapperGradProj for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_reg_MapperGradProj_t*)src)->v.dynamicCast<cv::reg::MapperGradProj>();
    return true;
}


struct pyopencv_reg_MapperGradShift_t
{
    PyObject_HEAD
    Ptr<cv::reg::MapperGradShift> v;
};

static PyTypeObject pyopencv_reg_MapperGradShift_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".reg_MapperGradShift",
    sizeof(pyopencv_reg_MapperGradShift_t),
};

static void pyopencv_reg_MapperGradShift_dealloc(PyObject* self)
{
    ((pyopencv_reg_MapperGradShift_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::reg::MapperGradShift>& r)
{
    pyopencv_reg_MapperGradShift_t *m = PyObject_NEW(pyopencv_reg_MapperGradShift_t, &pyopencv_reg_MapperGradShift_Type);
    new (&(m->v)) Ptr<cv::reg::MapperGradShift>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::reg::MapperGradShift>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_reg_MapperGradShift_Type))
    {
        failmsg("Expected cv::reg::MapperGradShift for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_reg_MapperGradShift_t*)src)->v.dynamicCast<cv::reg::MapperGradShift>();
    return true;
}


struct pyopencv_reg_MapperGradSimilar_t
{
    PyObject_HEAD
    Ptr<cv::reg::MapperGradSimilar> v;
};

static PyTypeObject pyopencv_reg_MapperGradSimilar_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".reg_MapperGradSimilar",
    sizeof(pyopencv_reg_MapperGradSimilar_t),
};

static void pyopencv_reg_MapperGradSimilar_dealloc(PyObject* self)
{
    ((pyopencv_reg_MapperGradSimilar_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::reg::MapperGradSimilar>& r)
{
    pyopencv_reg_MapperGradSimilar_t *m = PyObject_NEW(pyopencv_reg_MapperGradSimilar_t, &pyopencv_reg_MapperGradSimilar_Type);
    new (&(m->v)) Ptr<cv::reg::MapperGradSimilar>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::reg::MapperGradSimilar>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_reg_MapperGradSimilar_Type))
    {
        failmsg("Expected cv::reg::MapperGradSimilar for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_reg_MapperGradSimilar_t*)src)->v.dynamicCast<cv::reg::MapperGradSimilar>();
    return true;
}


struct pyopencv_reg_MapperPyramid_t
{
    PyObject_HEAD
    Ptr<cv::reg::MapperPyramid> v;
};

static PyTypeObject pyopencv_reg_MapperPyramid_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".reg_MapperPyramid",
    sizeof(pyopencv_reg_MapperPyramid_t),
};

static void pyopencv_reg_MapperPyramid_dealloc(PyObject* self)
{
    ((pyopencv_reg_MapperPyramid_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::reg::MapperPyramid>& r)
{
    pyopencv_reg_MapperPyramid_t *m = PyObject_NEW(pyopencv_reg_MapperPyramid_t, &pyopencv_reg_MapperPyramid_Type);
    new (&(m->v)) Ptr<cv::reg::MapperPyramid>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::reg::MapperPyramid>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_reg_MapperPyramid_Type))
    {
        failmsg("Expected cv::reg::MapperPyramid for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_reg_MapperPyramid_t*)src)->v.dynamicCast<cv::reg::MapperPyramid>();
    return true;
}


struct pyopencv_rgbd_DepthCleaner_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_rgbd_DepthCleaner_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".rgbd_DepthCleaner",
    sizeof(pyopencv_rgbd_DepthCleaner_t),
};

static void pyopencv_rgbd_DepthCleaner_dealloc(PyObject* self)
{
    ((pyopencv_rgbd_DepthCleaner_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::rgbd::DepthCleaner>& r)
{
    pyopencv_rgbd_DepthCleaner_t *m = PyObject_NEW(pyopencv_rgbd_DepthCleaner_t, &pyopencv_rgbd_DepthCleaner_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::rgbd::DepthCleaner>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_rgbd_DepthCleaner_Type))
    {
        failmsg("Expected cv::rgbd::DepthCleaner for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_rgbd_DepthCleaner_t*)src)->v.dynamicCast<cv::rgbd::DepthCleaner>();
    return true;
}


struct pyopencv_rgbd_ICPOdometry_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_rgbd_ICPOdometry_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".rgbd_ICPOdometry",
    sizeof(pyopencv_rgbd_ICPOdometry_t),
};

static void pyopencv_rgbd_ICPOdometry_dealloc(PyObject* self)
{
    ((pyopencv_rgbd_ICPOdometry_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::rgbd::ICPOdometry>& r)
{
    pyopencv_rgbd_ICPOdometry_t *m = PyObject_NEW(pyopencv_rgbd_ICPOdometry_t, &pyopencv_rgbd_ICPOdometry_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::rgbd::ICPOdometry>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_rgbd_ICPOdometry_Type))
    {
        failmsg("Expected cv::rgbd::ICPOdometry for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_rgbd_ICPOdometry_t*)src)->v.dynamicCast<cv::rgbd::ICPOdometry>();
    return true;
}


struct pyopencv_rgbd_Odometry_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_rgbd_Odometry_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".rgbd_Odometry",
    sizeof(pyopencv_rgbd_Odometry_t),
};

static void pyopencv_rgbd_Odometry_dealloc(PyObject* self)
{
    ((pyopencv_rgbd_Odometry_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::rgbd::Odometry>& r)
{
    pyopencv_rgbd_Odometry_t *m = PyObject_NEW(pyopencv_rgbd_Odometry_t, &pyopencv_rgbd_Odometry_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::rgbd::Odometry>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_rgbd_Odometry_Type))
    {
        failmsg("Expected cv::rgbd::Odometry for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_rgbd_Odometry_t*)src)->v.dynamicCast<cv::rgbd::Odometry>();
    return true;
}


struct pyopencv_rgbd_OdometryFrame_t
{
    PyObject_HEAD
    Ptr<cv::rgbd::OdometryFrame> v;
};

static PyTypeObject pyopencv_rgbd_OdometryFrame_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".rgbd_OdometryFrame",
    sizeof(pyopencv_rgbd_OdometryFrame_t),
};

static void pyopencv_rgbd_OdometryFrame_dealloc(PyObject* self)
{
    ((pyopencv_rgbd_OdometryFrame_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::rgbd::OdometryFrame>& r)
{
    pyopencv_rgbd_OdometryFrame_t *m = PyObject_NEW(pyopencv_rgbd_OdometryFrame_t, &pyopencv_rgbd_OdometryFrame_Type);
    new (&(m->v)) Ptr<cv::rgbd::OdometryFrame>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::rgbd::OdometryFrame>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_rgbd_OdometryFrame_Type))
    {
        failmsg("Expected cv::rgbd::OdometryFrame for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_rgbd_OdometryFrame_t*)src)->v.dynamicCast<cv::rgbd::OdometryFrame>();
    return true;
}


struct pyopencv_rgbd_RgbdFrame_t
{
    PyObject_HEAD
    Ptr<cv::rgbd::RgbdFrame> v;
};

static PyTypeObject pyopencv_rgbd_RgbdFrame_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".rgbd_RgbdFrame",
    sizeof(pyopencv_rgbd_RgbdFrame_t),
};

static void pyopencv_rgbd_RgbdFrame_dealloc(PyObject* self)
{
    ((pyopencv_rgbd_RgbdFrame_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::rgbd::RgbdFrame>& r)
{
    pyopencv_rgbd_RgbdFrame_t *m = PyObject_NEW(pyopencv_rgbd_RgbdFrame_t, &pyopencv_rgbd_RgbdFrame_Type);
    new (&(m->v)) Ptr<cv::rgbd::RgbdFrame>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::rgbd::RgbdFrame>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_rgbd_RgbdFrame_Type))
    {
        failmsg("Expected cv::rgbd::RgbdFrame for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_rgbd_RgbdFrame_t*)src)->v.dynamicCast<cv::rgbd::RgbdFrame>();
    return true;
}


struct pyopencv_rgbd_RgbdICPOdometry_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_rgbd_RgbdICPOdometry_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".rgbd_RgbdICPOdometry",
    sizeof(pyopencv_rgbd_RgbdICPOdometry_t),
};

static void pyopencv_rgbd_RgbdICPOdometry_dealloc(PyObject* self)
{
    ((pyopencv_rgbd_RgbdICPOdometry_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::rgbd::RgbdICPOdometry>& r)
{
    pyopencv_rgbd_RgbdICPOdometry_t *m = PyObject_NEW(pyopencv_rgbd_RgbdICPOdometry_t, &pyopencv_rgbd_RgbdICPOdometry_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::rgbd::RgbdICPOdometry>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_rgbd_RgbdICPOdometry_Type))
    {
        failmsg("Expected cv::rgbd::RgbdICPOdometry for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_rgbd_RgbdICPOdometry_t*)src)->v.dynamicCast<cv::rgbd::RgbdICPOdometry>();
    return true;
}


struct pyopencv_rgbd_RgbdNormals_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_rgbd_RgbdNormals_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".rgbd_RgbdNormals",
    sizeof(pyopencv_rgbd_RgbdNormals_t),
};

static void pyopencv_rgbd_RgbdNormals_dealloc(PyObject* self)
{
    ((pyopencv_rgbd_RgbdNormals_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::rgbd::RgbdNormals>& r)
{
    pyopencv_rgbd_RgbdNormals_t *m = PyObject_NEW(pyopencv_rgbd_RgbdNormals_t, &pyopencv_rgbd_RgbdNormals_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::rgbd::RgbdNormals>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_rgbd_RgbdNormals_Type))
    {
        failmsg("Expected cv::rgbd::RgbdNormals for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_rgbd_RgbdNormals_t*)src)->v.dynamicCast<cv::rgbd::RgbdNormals>();
    return true;
}


struct pyopencv_rgbd_RgbdOdometry_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_rgbd_RgbdOdometry_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".rgbd_RgbdOdometry",
    sizeof(pyopencv_rgbd_RgbdOdometry_t),
};

static void pyopencv_rgbd_RgbdOdometry_dealloc(PyObject* self)
{
    ((pyopencv_rgbd_RgbdOdometry_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::rgbd::RgbdOdometry>& r)
{
    pyopencv_rgbd_RgbdOdometry_t *m = PyObject_NEW(pyopencv_rgbd_RgbdOdometry_t, &pyopencv_rgbd_RgbdOdometry_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::rgbd::RgbdOdometry>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_rgbd_RgbdOdometry_Type))
    {
        failmsg("Expected cv::rgbd::RgbdOdometry for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_rgbd_RgbdOdometry_t*)src)->v.dynamicCast<cv::rgbd::RgbdOdometry>();
    return true;
}


struct pyopencv_rgbd_RgbdPlane_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_rgbd_RgbdPlane_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".rgbd_RgbdPlane",
    sizeof(pyopencv_rgbd_RgbdPlane_t),
};

static void pyopencv_rgbd_RgbdPlane_dealloc(PyObject* self)
{
    ((pyopencv_rgbd_RgbdPlane_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::rgbd::RgbdPlane>& r)
{
    pyopencv_rgbd_RgbdPlane_t *m = PyObject_NEW(pyopencv_rgbd_RgbdPlane_t, &pyopencv_rgbd_RgbdPlane_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::rgbd::RgbdPlane>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_rgbd_RgbdPlane_Type))
    {
        failmsg("Expected cv::rgbd::RgbdPlane for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_rgbd_RgbdPlane_t*)src)->v.dynamicCast<cv::rgbd::RgbdPlane>();
    return true;
}


struct pyopencv_saliency_MotionSaliency_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_saliency_MotionSaliency_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".saliency_MotionSaliency",
    sizeof(pyopencv_saliency_MotionSaliency_t),
};

static void pyopencv_saliency_MotionSaliency_dealloc(PyObject* self)
{
    ((pyopencv_saliency_MotionSaliency_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::saliency::MotionSaliency>& r)
{
    pyopencv_saliency_MotionSaliency_t *m = PyObject_NEW(pyopencv_saliency_MotionSaliency_t, &pyopencv_saliency_MotionSaliency_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::saliency::MotionSaliency>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_saliency_MotionSaliency_Type))
    {
        failmsg("Expected cv::saliency::MotionSaliency for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_saliency_MotionSaliency_t*)src)->v.dynamicCast<cv::saliency::MotionSaliency>();
    return true;
}


struct pyopencv_saliency_MotionSaliencyBinWangApr2014_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_saliency_MotionSaliencyBinWangApr2014_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".saliency_MotionSaliencyBinWangApr2014",
    sizeof(pyopencv_saliency_MotionSaliencyBinWangApr2014_t),
};

static void pyopencv_saliency_MotionSaliencyBinWangApr2014_dealloc(PyObject* self)
{
    ((pyopencv_saliency_MotionSaliencyBinWangApr2014_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::saliency::MotionSaliencyBinWangApr2014>& r)
{
    pyopencv_saliency_MotionSaliencyBinWangApr2014_t *m = PyObject_NEW(pyopencv_saliency_MotionSaliencyBinWangApr2014_t, &pyopencv_saliency_MotionSaliencyBinWangApr2014_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::saliency::MotionSaliencyBinWangApr2014>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_saliency_MotionSaliencyBinWangApr2014_Type))
    {
        failmsg("Expected cv::saliency::MotionSaliencyBinWangApr2014 for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_saliency_MotionSaliencyBinWangApr2014_t*)src)->v.dynamicCast<cv::saliency::MotionSaliencyBinWangApr2014>();
    return true;
}


struct pyopencv_saliency_Objectness_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_saliency_Objectness_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".saliency_Objectness",
    sizeof(pyopencv_saliency_Objectness_t),
};

static void pyopencv_saliency_Objectness_dealloc(PyObject* self)
{
    ((pyopencv_saliency_Objectness_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::saliency::Objectness>& r)
{
    pyopencv_saliency_Objectness_t *m = PyObject_NEW(pyopencv_saliency_Objectness_t, &pyopencv_saliency_Objectness_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::saliency::Objectness>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_saliency_Objectness_Type))
    {
        failmsg("Expected cv::saliency::Objectness for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_saliency_Objectness_t*)src)->v.dynamicCast<cv::saliency::Objectness>();
    return true;
}


struct pyopencv_saliency_ObjectnessBING_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_saliency_ObjectnessBING_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".saliency_ObjectnessBING",
    sizeof(pyopencv_saliency_ObjectnessBING_t),
};

static void pyopencv_saliency_ObjectnessBING_dealloc(PyObject* self)
{
    ((pyopencv_saliency_ObjectnessBING_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::saliency::ObjectnessBING>& r)
{
    pyopencv_saliency_ObjectnessBING_t *m = PyObject_NEW(pyopencv_saliency_ObjectnessBING_t, &pyopencv_saliency_ObjectnessBING_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::saliency::ObjectnessBING>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_saliency_ObjectnessBING_Type))
    {
        failmsg("Expected cv::saliency::ObjectnessBING for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_saliency_ObjectnessBING_t*)src)->v.dynamicCast<cv::saliency::ObjectnessBING>();
    return true;
}


struct pyopencv_saliency_Saliency_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_saliency_Saliency_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".saliency_Saliency",
    sizeof(pyopencv_saliency_Saliency_t),
};

static void pyopencv_saliency_Saliency_dealloc(PyObject* self)
{
    ((pyopencv_saliency_Saliency_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::saliency::Saliency>& r)
{
    pyopencv_saliency_Saliency_t *m = PyObject_NEW(pyopencv_saliency_Saliency_t, &pyopencv_saliency_Saliency_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::saliency::Saliency>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_saliency_Saliency_Type))
    {
        failmsg("Expected cv::saliency::Saliency for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_saliency_Saliency_t*)src)->v.dynamicCast<cv::saliency::Saliency>();
    return true;
}


struct pyopencv_saliency_StaticSaliency_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_saliency_StaticSaliency_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".saliency_StaticSaliency",
    sizeof(pyopencv_saliency_StaticSaliency_t),
};

static void pyopencv_saliency_StaticSaliency_dealloc(PyObject* self)
{
    ((pyopencv_saliency_StaticSaliency_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::saliency::StaticSaliency>& r)
{
    pyopencv_saliency_StaticSaliency_t *m = PyObject_NEW(pyopencv_saliency_StaticSaliency_t, &pyopencv_saliency_StaticSaliency_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::saliency::StaticSaliency>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_saliency_StaticSaliency_Type))
    {
        failmsg("Expected cv::saliency::StaticSaliency for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_saliency_StaticSaliency_t*)src)->v.dynamicCast<cv::saliency::StaticSaliency>();
    return true;
}


struct pyopencv_saliency_StaticSaliencyFineGrained_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_saliency_StaticSaliencyFineGrained_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".saliency_StaticSaliencyFineGrained",
    sizeof(pyopencv_saliency_StaticSaliencyFineGrained_t),
};

static void pyopencv_saliency_StaticSaliencyFineGrained_dealloc(PyObject* self)
{
    ((pyopencv_saliency_StaticSaliencyFineGrained_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::saliency::StaticSaliencyFineGrained>& r)
{
    pyopencv_saliency_StaticSaliencyFineGrained_t *m = PyObject_NEW(pyopencv_saliency_StaticSaliencyFineGrained_t, &pyopencv_saliency_StaticSaliencyFineGrained_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::saliency::StaticSaliencyFineGrained>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_saliency_StaticSaliencyFineGrained_Type))
    {
        failmsg("Expected cv::saliency::StaticSaliencyFineGrained for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_saliency_StaticSaliencyFineGrained_t*)src)->v.dynamicCast<cv::saliency::StaticSaliencyFineGrained>();
    return true;
}


struct pyopencv_saliency_StaticSaliencySpectralResidual_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_saliency_StaticSaliencySpectralResidual_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".saliency_StaticSaliencySpectralResidual",
    sizeof(pyopencv_saliency_StaticSaliencySpectralResidual_t),
};

static void pyopencv_saliency_StaticSaliencySpectralResidual_dealloc(PyObject* self)
{
    ((pyopencv_saliency_StaticSaliencySpectralResidual_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::saliency::StaticSaliencySpectralResidual>& r)
{
    pyopencv_saliency_StaticSaliencySpectralResidual_t *m = PyObject_NEW(pyopencv_saliency_StaticSaliencySpectralResidual_t, &pyopencv_saliency_StaticSaliencySpectralResidual_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::saliency::StaticSaliencySpectralResidual>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_saliency_StaticSaliencySpectralResidual_Type))
    {
        failmsg("Expected cv::saliency::StaticSaliencySpectralResidual for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_saliency_StaticSaliencySpectralResidual_t*)src)->v.dynamicCast<cv::saliency::StaticSaliencySpectralResidual>();
    return true;
}


struct pyopencv_structured_light_GrayCodePattern_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_structured_light_GrayCodePattern_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".structured_light_GrayCodePattern",
    sizeof(pyopencv_structured_light_GrayCodePattern_t),
};

static void pyopencv_structured_light_GrayCodePattern_dealloc(PyObject* self)
{
    ((pyopencv_structured_light_GrayCodePattern_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::structured_light::GrayCodePattern>& r)
{
    pyopencv_structured_light_GrayCodePattern_t *m = PyObject_NEW(pyopencv_structured_light_GrayCodePattern_t, &pyopencv_structured_light_GrayCodePattern_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::structured_light::GrayCodePattern>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_structured_light_GrayCodePattern_Type))
    {
        failmsg("Expected cv::structured_light::GrayCodePattern for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_structured_light_GrayCodePattern_t*)src)->v.dynamicCast<cv::structured_light::GrayCodePattern>();
    return true;
}


struct pyopencv_structured_light_SinusoidalPattern_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_structured_light_SinusoidalPattern_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".structured_light_SinusoidalPattern",
    sizeof(pyopencv_structured_light_SinusoidalPattern_t),
};

static void pyopencv_structured_light_SinusoidalPattern_dealloc(PyObject* self)
{
    ((pyopencv_structured_light_SinusoidalPattern_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::structured_light::SinusoidalPattern>& r)
{
    pyopencv_structured_light_SinusoidalPattern_t *m = PyObject_NEW(pyopencv_structured_light_SinusoidalPattern_t, &pyopencv_structured_light_SinusoidalPattern_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::structured_light::SinusoidalPattern>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_structured_light_SinusoidalPattern_Type))
    {
        failmsg("Expected cv::structured_light::SinusoidalPattern for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_structured_light_SinusoidalPattern_t*)src)->v.dynamicCast<cv::structured_light::SinusoidalPattern>();
    return true;
}


struct pyopencv_structured_light_SinusoidalPattern_Params_t
{
    PyObject_HEAD
    Ptr<cv::structured_light::SinusoidalPattern::Params> v;
};

static PyTypeObject pyopencv_structured_light_SinusoidalPattern_Params_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".structured_light_SinusoidalPattern_Params",
    sizeof(pyopencv_structured_light_SinusoidalPattern_Params_t),
};

static void pyopencv_structured_light_SinusoidalPattern_Params_dealloc(PyObject* self)
{
    ((pyopencv_structured_light_SinusoidalPattern_Params_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::structured_light::SinusoidalPattern::Params>& r)
{
    pyopencv_structured_light_SinusoidalPattern_Params_t *m = PyObject_NEW(pyopencv_structured_light_SinusoidalPattern_Params_t, &pyopencv_structured_light_SinusoidalPattern_Params_Type);
    new (&(m->v)) Ptr<cv::structured_light::SinusoidalPattern::Params>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::structured_light::SinusoidalPattern::Params>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_structured_light_SinusoidalPattern_Params_Type))
    {
        failmsg("Expected cv::structured_light::SinusoidalPattern::Params for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_structured_light_SinusoidalPattern_Params_t*)src)->v.dynamicCast<cv::structured_light::SinusoidalPattern::Params>();
    return true;
}


struct pyopencv_structured_light_StructuredLightPattern_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_structured_light_StructuredLightPattern_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".structured_light_StructuredLightPattern",
    sizeof(pyopencv_structured_light_StructuredLightPattern_t),
};

static void pyopencv_structured_light_StructuredLightPattern_dealloc(PyObject* self)
{
    ((pyopencv_structured_light_StructuredLightPattern_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::structured_light::StructuredLightPattern>& r)
{
    pyopencv_structured_light_StructuredLightPattern_t *m = PyObject_NEW(pyopencv_structured_light_StructuredLightPattern_t, &pyopencv_structured_light_StructuredLightPattern_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::structured_light::StructuredLightPattern>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_structured_light_StructuredLightPattern_Type))
    {
        failmsg("Expected cv::structured_light::StructuredLightPattern for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_structured_light_StructuredLightPattern_t*)src)->v.dynamicCast<cv::structured_light::StructuredLightPattern>();
    return true;
}


struct pyopencv_ximgproc_AdaptiveManifoldFilter_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ximgproc_AdaptiveManifoldFilter_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ximgproc_AdaptiveManifoldFilter",
    sizeof(pyopencv_ximgproc_AdaptiveManifoldFilter_t),
};

static void pyopencv_ximgproc_AdaptiveManifoldFilter_dealloc(PyObject* self)
{
    ((pyopencv_ximgproc_AdaptiveManifoldFilter_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ximgproc::AdaptiveManifoldFilter>& r)
{
    pyopencv_ximgproc_AdaptiveManifoldFilter_t *m = PyObject_NEW(pyopencv_ximgproc_AdaptiveManifoldFilter_t, &pyopencv_ximgproc_AdaptiveManifoldFilter_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ximgproc::AdaptiveManifoldFilter>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ximgproc_AdaptiveManifoldFilter_Type))
    {
        failmsg("Expected cv::ximgproc::AdaptiveManifoldFilter for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ximgproc_AdaptiveManifoldFilter_t*)src)->v.dynamicCast<cv::ximgproc::AdaptiveManifoldFilter>();
    return true;
}


struct pyopencv_ximgproc_ContourFitting_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ximgproc_ContourFitting_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ximgproc_ContourFitting",
    sizeof(pyopencv_ximgproc_ContourFitting_t),
};

static void pyopencv_ximgproc_ContourFitting_dealloc(PyObject* self)
{
    ((pyopencv_ximgproc_ContourFitting_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ximgproc::ContourFitting>& r)
{
    pyopencv_ximgproc_ContourFitting_t *m = PyObject_NEW(pyopencv_ximgproc_ContourFitting_t, &pyopencv_ximgproc_ContourFitting_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ximgproc::ContourFitting>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ximgproc_ContourFitting_Type))
    {
        failmsg("Expected cv::ximgproc::ContourFitting for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ximgproc_ContourFitting_t*)src)->v.dynamicCast<cv::ximgproc::ContourFitting>();
    return true;
}


struct pyopencv_ximgproc_DTFilter_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ximgproc_DTFilter_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ximgproc_DTFilter",
    sizeof(pyopencv_ximgproc_DTFilter_t),
};

static void pyopencv_ximgproc_DTFilter_dealloc(PyObject* self)
{
    ((pyopencv_ximgproc_DTFilter_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ximgproc::DTFilter>& r)
{
    pyopencv_ximgproc_DTFilter_t *m = PyObject_NEW(pyopencv_ximgproc_DTFilter_t, &pyopencv_ximgproc_DTFilter_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ximgproc::DTFilter>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ximgproc_DTFilter_Type))
    {
        failmsg("Expected cv::ximgproc::DTFilter for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ximgproc_DTFilter_t*)src)->v.dynamicCast<cv::ximgproc::DTFilter>();
    return true;
}


struct pyopencv_ximgproc_DisparityFilter_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ximgproc_DisparityFilter_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ximgproc_DisparityFilter",
    sizeof(pyopencv_ximgproc_DisparityFilter_t),
};

static void pyopencv_ximgproc_DisparityFilter_dealloc(PyObject* self)
{
    ((pyopencv_ximgproc_DisparityFilter_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ximgproc::DisparityFilter>& r)
{
    pyopencv_ximgproc_DisparityFilter_t *m = PyObject_NEW(pyopencv_ximgproc_DisparityFilter_t, &pyopencv_ximgproc_DisparityFilter_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ximgproc::DisparityFilter>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ximgproc_DisparityFilter_Type))
    {
        failmsg("Expected cv::ximgproc::DisparityFilter for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ximgproc_DisparityFilter_t*)src)->v.dynamicCast<cv::ximgproc::DisparityFilter>();
    return true;
}


struct pyopencv_ximgproc_DisparityWLSFilter_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ximgproc_DisparityWLSFilter_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ximgproc_DisparityWLSFilter",
    sizeof(pyopencv_ximgproc_DisparityWLSFilter_t),
};

static void pyopencv_ximgproc_DisparityWLSFilter_dealloc(PyObject* self)
{
    ((pyopencv_ximgproc_DisparityWLSFilter_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ximgproc::DisparityWLSFilter>& r)
{
    pyopencv_ximgproc_DisparityWLSFilter_t *m = PyObject_NEW(pyopencv_ximgproc_DisparityWLSFilter_t, &pyopencv_ximgproc_DisparityWLSFilter_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ximgproc::DisparityWLSFilter>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ximgproc_DisparityWLSFilter_Type))
    {
        failmsg("Expected cv::ximgproc::DisparityWLSFilter for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ximgproc_DisparityWLSFilter_t*)src)->v.dynamicCast<cv::ximgproc::DisparityWLSFilter>();
    return true;
}


struct pyopencv_ximgproc_EdgeAwareInterpolator_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ximgproc_EdgeAwareInterpolator_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ximgproc_EdgeAwareInterpolator",
    sizeof(pyopencv_ximgproc_EdgeAwareInterpolator_t),
};

static void pyopencv_ximgproc_EdgeAwareInterpolator_dealloc(PyObject* self)
{
    ((pyopencv_ximgproc_EdgeAwareInterpolator_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ximgproc::EdgeAwareInterpolator>& r)
{
    pyopencv_ximgproc_EdgeAwareInterpolator_t *m = PyObject_NEW(pyopencv_ximgproc_EdgeAwareInterpolator_t, &pyopencv_ximgproc_EdgeAwareInterpolator_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ximgproc::EdgeAwareInterpolator>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ximgproc_EdgeAwareInterpolator_Type))
    {
        failmsg("Expected cv::ximgproc::EdgeAwareInterpolator for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ximgproc_EdgeAwareInterpolator_t*)src)->v.dynamicCast<cv::ximgproc::EdgeAwareInterpolator>();
    return true;
}


struct pyopencv_ximgproc_EdgeBoxes_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ximgproc_EdgeBoxes_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ximgproc_EdgeBoxes",
    sizeof(pyopencv_ximgproc_EdgeBoxes_t),
};

static void pyopencv_ximgproc_EdgeBoxes_dealloc(PyObject* self)
{
    ((pyopencv_ximgproc_EdgeBoxes_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ximgproc::EdgeBoxes>& r)
{
    pyopencv_ximgproc_EdgeBoxes_t *m = PyObject_NEW(pyopencv_ximgproc_EdgeBoxes_t, &pyopencv_ximgproc_EdgeBoxes_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ximgproc::EdgeBoxes>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ximgproc_EdgeBoxes_Type))
    {
        failmsg("Expected cv::ximgproc::EdgeBoxes for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ximgproc_EdgeBoxes_t*)src)->v.dynamicCast<cv::ximgproc::EdgeBoxes>();
    return true;
}


struct pyopencv_ximgproc_FastGlobalSmootherFilter_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ximgproc_FastGlobalSmootherFilter_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ximgproc_FastGlobalSmootherFilter",
    sizeof(pyopencv_ximgproc_FastGlobalSmootherFilter_t),
};

static void pyopencv_ximgproc_FastGlobalSmootherFilter_dealloc(PyObject* self)
{
    ((pyopencv_ximgproc_FastGlobalSmootherFilter_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ximgproc::FastGlobalSmootherFilter>& r)
{
    pyopencv_ximgproc_FastGlobalSmootherFilter_t *m = PyObject_NEW(pyopencv_ximgproc_FastGlobalSmootherFilter_t, &pyopencv_ximgproc_FastGlobalSmootherFilter_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ximgproc::FastGlobalSmootherFilter>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ximgproc_FastGlobalSmootherFilter_Type))
    {
        failmsg("Expected cv::ximgproc::FastGlobalSmootherFilter for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ximgproc_FastGlobalSmootherFilter_t*)src)->v.dynamicCast<cv::ximgproc::FastGlobalSmootherFilter>();
    return true;
}


struct pyopencv_ximgproc_FastLineDetector_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ximgproc_FastLineDetector_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ximgproc_FastLineDetector",
    sizeof(pyopencv_ximgproc_FastLineDetector_t),
};

static void pyopencv_ximgproc_FastLineDetector_dealloc(PyObject* self)
{
    ((pyopencv_ximgproc_FastLineDetector_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ximgproc::FastLineDetector>& r)
{
    pyopencv_ximgproc_FastLineDetector_t *m = PyObject_NEW(pyopencv_ximgproc_FastLineDetector_t, &pyopencv_ximgproc_FastLineDetector_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ximgproc::FastLineDetector>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ximgproc_FastLineDetector_Type))
    {
        failmsg("Expected cv::ximgproc::FastLineDetector for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ximgproc_FastLineDetector_t*)src)->v.dynamicCast<cv::ximgproc::FastLineDetector>();
    return true;
}


struct pyopencv_ximgproc_GuidedFilter_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ximgproc_GuidedFilter_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ximgproc_GuidedFilter",
    sizeof(pyopencv_ximgproc_GuidedFilter_t),
};

static void pyopencv_ximgproc_GuidedFilter_dealloc(PyObject* self)
{
    ((pyopencv_ximgproc_GuidedFilter_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ximgproc::GuidedFilter>& r)
{
    pyopencv_ximgproc_GuidedFilter_t *m = PyObject_NEW(pyopencv_ximgproc_GuidedFilter_t, &pyopencv_ximgproc_GuidedFilter_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ximgproc::GuidedFilter>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ximgproc_GuidedFilter_Type))
    {
        failmsg("Expected cv::ximgproc::GuidedFilter for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ximgproc_GuidedFilter_t*)src)->v.dynamicCast<cv::ximgproc::GuidedFilter>();
    return true;
}


struct pyopencv_ximgproc_RFFeatureGetter_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ximgproc_RFFeatureGetter_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ximgproc_RFFeatureGetter",
    sizeof(pyopencv_ximgproc_RFFeatureGetter_t),
};

static void pyopencv_ximgproc_RFFeatureGetter_dealloc(PyObject* self)
{
    ((pyopencv_ximgproc_RFFeatureGetter_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ximgproc::RFFeatureGetter>& r)
{
    pyopencv_ximgproc_RFFeatureGetter_t *m = PyObject_NEW(pyopencv_ximgproc_RFFeatureGetter_t, &pyopencv_ximgproc_RFFeatureGetter_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ximgproc::RFFeatureGetter>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ximgproc_RFFeatureGetter_Type))
    {
        failmsg("Expected cv::ximgproc::RFFeatureGetter for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ximgproc_RFFeatureGetter_t*)src)->v.dynamicCast<cv::ximgproc::RFFeatureGetter>();
    return true;
}


struct pyopencv_ximgproc_RidgeDetectionFilter_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ximgproc_RidgeDetectionFilter_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ximgproc_RidgeDetectionFilter",
    sizeof(pyopencv_ximgproc_RidgeDetectionFilter_t),
};

static void pyopencv_ximgproc_RidgeDetectionFilter_dealloc(PyObject* self)
{
    ((pyopencv_ximgproc_RidgeDetectionFilter_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ximgproc::RidgeDetectionFilter>& r)
{
    pyopencv_ximgproc_RidgeDetectionFilter_t *m = PyObject_NEW(pyopencv_ximgproc_RidgeDetectionFilter_t, &pyopencv_ximgproc_RidgeDetectionFilter_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ximgproc::RidgeDetectionFilter>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ximgproc_RidgeDetectionFilter_Type))
    {
        failmsg("Expected cv::ximgproc::RidgeDetectionFilter for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ximgproc_RidgeDetectionFilter_t*)src)->v.dynamicCast<cv::ximgproc::RidgeDetectionFilter>();
    return true;
}


struct pyopencv_ximgproc_SparseMatchInterpolator_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ximgproc_SparseMatchInterpolator_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ximgproc_SparseMatchInterpolator",
    sizeof(pyopencv_ximgproc_SparseMatchInterpolator_t),
};

static void pyopencv_ximgproc_SparseMatchInterpolator_dealloc(PyObject* self)
{
    ((pyopencv_ximgproc_SparseMatchInterpolator_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ximgproc::SparseMatchInterpolator>& r)
{
    pyopencv_ximgproc_SparseMatchInterpolator_t *m = PyObject_NEW(pyopencv_ximgproc_SparseMatchInterpolator_t, &pyopencv_ximgproc_SparseMatchInterpolator_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ximgproc::SparseMatchInterpolator>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ximgproc_SparseMatchInterpolator_Type))
    {
        failmsg("Expected cv::ximgproc::SparseMatchInterpolator for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ximgproc_SparseMatchInterpolator_t*)src)->v.dynamicCast<cv::ximgproc::SparseMatchInterpolator>();
    return true;
}


struct pyopencv_ximgproc_StructuredEdgeDetection_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ximgproc_StructuredEdgeDetection_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ximgproc_StructuredEdgeDetection",
    sizeof(pyopencv_ximgproc_StructuredEdgeDetection_t),
};

static void pyopencv_ximgproc_StructuredEdgeDetection_dealloc(PyObject* self)
{
    ((pyopencv_ximgproc_StructuredEdgeDetection_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ximgproc::StructuredEdgeDetection>& r)
{
    pyopencv_ximgproc_StructuredEdgeDetection_t *m = PyObject_NEW(pyopencv_ximgproc_StructuredEdgeDetection_t, &pyopencv_ximgproc_StructuredEdgeDetection_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ximgproc::StructuredEdgeDetection>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ximgproc_StructuredEdgeDetection_Type))
    {
        failmsg("Expected cv::ximgproc::StructuredEdgeDetection for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ximgproc_StructuredEdgeDetection_t*)src)->v.dynamicCast<cv::ximgproc::StructuredEdgeDetection>();
    return true;
}


struct pyopencv_ximgproc_SuperpixelLSC_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ximgproc_SuperpixelLSC_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ximgproc_SuperpixelLSC",
    sizeof(pyopencv_ximgproc_SuperpixelLSC_t),
};

static void pyopencv_ximgproc_SuperpixelLSC_dealloc(PyObject* self)
{
    ((pyopencv_ximgproc_SuperpixelLSC_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ximgproc::SuperpixelLSC>& r)
{
    pyopencv_ximgproc_SuperpixelLSC_t *m = PyObject_NEW(pyopencv_ximgproc_SuperpixelLSC_t, &pyopencv_ximgproc_SuperpixelLSC_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ximgproc::SuperpixelLSC>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ximgproc_SuperpixelLSC_Type))
    {
        failmsg("Expected cv::ximgproc::SuperpixelLSC for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ximgproc_SuperpixelLSC_t*)src)->v.dynamicCast<cv::ximgproc::SuperpixelLSC>();
    return true;
}


struct pyopencv_ximgproc_SuperpixelSEEDS_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ximgproc_SuperpixelSEEDS_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ximgproc_SuperpixelSEEDS",
    sizeof(pyopencv_ximgproc_SuperpixelSEEDS_t),
};

static void pyopencv_ximgproc_SuperpixelSEEDS_dealloc(PyObject* self)
{
    ((pyopencv_ximgproc_SuperpixelSEEDS_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ximgproc::SuperpixelSEEDS>& r)
{
    pyopencv_ximgproc_SuperpixelSEEDS_t *m = PyObject_NEW(pyopencv_ximgproc_SuperpixelSEEDS_t, &pyopencv_ximgproc_SuperpixelSEEDS_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ximgproc::SuperpixelSEEDS>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ximgproc_SuperpixelSEEDS_Type))
    {
        failmsg("Expected cv::ximgproc::SuperpixelSEEDS for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ximgproc_SuperpixelSEEDS_t*)src)->v.dynamicCast<cv::ximgproc::SuperpixelSEEDS>();
    return true;
}


struct pyopencv_ximgproc_SuperpixelSLIC_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ximgproc_SuperpixelSLIC_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ximgproc_SuperpixelSLIC",
    sizeof(pyopencv_ximgproc_SuperpixelSLIC_t),
};

static void pyopencv_ximgproc_SuperpixelSLIC_dealloc(PyObject* self)
{
    ((pyopencv_ximgproc_SuperpixelSLIC_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ximgproc::SuperpixelSLIC>& r)
{
    pyopencv_ximgproc_SuperpixelSLIC_t *m = PyObject_NEW(pyopencv_ximgproc_SuperpixelSLIC_t, &pyopencv_ximgproc_SuperpixelSLIC_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ximgproc::SuperpixelSLIC>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ximgproc_SuperpixelSLIC_Type))
    {
        failmsg("Expected cv::ximgproc::SuperpixelSLIC for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ximgproc_SuperpixelSLIC_t*)src)->v.dynamicCast<cv::ximgproc::SuperpixelSLIC>();
    return true;
}


struct pyopencv_ximgproc_segmentation_GraphSegmentation_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ximgproc_segmentation_GraphSegmentation_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ximgproc_segmentation_GraphSegmentation",
    sizeof(pyopencv_ximgproc_segmentation_GraphSegmentation_t),
};

static void pyopencv_ximgproc_segmentation_GraphSegmentation_dealloc(PyObject* self)
{
    ((pyopencv_ximgproc_segmentation_GraphSegmentation_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ximgproc::segmentation::GraphSegmentation>& r)
{
    pyopencv_ximgproc_segmentation_GraphSegmentation_t *m = PyObject_NEW(pyopencv_ximgproc_segmentation_GraphSegmentation_t, &pyopencv_ximgproc_segmentation_GraphSegmentation_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ximgproc::segmentation::GraphSegmentation>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ximgproc_segmentation_GraphSegmentation_Type))
    {
        failmsg("Expected cv::ximgproc::segmentation::GraphSegmentation for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ximgproc_segmentation_GraphSegmentation_t*)src)->v.dynamicCast<cv::ximgproc::segmentation::GraphSegmentation>();
    return true;
}


struct pyopencv_ximgproc_segmentation_SelectiveSearchSegmentation_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ximgproc_segmentation_SelectiveSearchSegmentation_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ximgproc_segmentation_SelectiveSearchSegmentation",
    sizeof(pyopencv_ximgproc_segmentation_SelectiveSearchSegmentation_t),
};

static void pyopencv_ximgproc_segmentation_SelectiveSearchSegmentation_dealloc(PyObject* self)
{
    ((pyopencv_ximgproc_segmentation_SelectiveSearchSegmentation_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentation>& r)
{
    pyopencv_ximgproc_segmentation_SelectiveSearchSegmentation_t *m = PyObject_NEW(pyopencv_ximgproc_segmentation_SelectiveSearchSegmentation_t, &pyopencv_ximgproc_segmentation_SelectiveSearchSegmentation_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentation>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ximgproc_segmentation_SelectiveSearchSegmentation_Type))
    {
        failmsg("Expected cv::ximgproc::segmentation::SelectiveSearchSegmentation for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ximgproc_segmentation_SelectiveSearchSegmentation_t*)src)->v.dynamicCast<cv::ximgproc::segmentation::SelectiveSearchSegmentation>();
    return true;
}


struct pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategy_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategy_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ximgproc_segmentation_SelectiveSearchSegmentationStrategy",
    sizeof(pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategy_t),
};

static void pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategy_dealloc(PyObject* self)
{
    ((pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategy_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy>& r)
{
    pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategy_t *m = PyObject_NEW(pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategy_t, &pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategy_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategy_Type))
    {
        failmsg("Expected cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategy_t*)src)->v.dynamicCast<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategy>();
    return true;
}


struct pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyColor_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyColor_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ximgproc_segmentation_SelectiveSearchSegmentationStrategyColor",
    sizeof(pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyColor_t),
};

static void pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyColor_dealloc(PyObject* self)
{
    ((pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyColor_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyColor>& r)
{
    pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyColor_t *m = PyObject_NEW(pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyColor_t, &pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyColor_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyColor>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyColor_Type))
    {
        failmsg("Expected cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyColor for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyColor_t*)src)->v.dynamicCast<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyColor>();
    return true;
}


struct pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyFill_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyFill_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ximgproc_segmentation_SelectiveSearchSegmentationStrategyFill",
    sizeof(pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyFill_t),
};

static void pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyFill_dealloc(PyObject* self)
{
    ((pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyFill_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyFill>& r)
{
    pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyFill_t *m = PyObject_NEW(pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyFill_t, &pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyFill_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyFill>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyFill_Type))
    {
        failmsg("Expected cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyFill for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyFill_t*)src)->v.dynamicCast<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyFill>();
    return true;
}


struct pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyMultiple_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyMultiple_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ximgproc_segmentation_SelectiveSearchSegmentationStrategyMultiple",
    sizeof(pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyMultiple_t),
};

static void pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyMultiple_dealloc(PyObject* self)
{
    ((pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyMultiple_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyMultiple>& r)
{
    pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyMultiple_t *m = PyObject_NEW(pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyMultiple_t, &pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyMultiple_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyMultiple>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyMultiple_Type))
    {
        failmsg("Expected cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyMultiple for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyMultiple_t*)src)->v.dynamicCast<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyMultiple>();
    return true;
}


struct pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategySize_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategySize_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ximgproc_segmentation_SelectiveSearchSegmentationStrategySize",
    sizeof(pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategySize_t),
};

static void pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategySize_dealloc(PyObject* self)
{
    ((pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategySize_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategySize>& r)
{
    pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategySize_t *m = PyObject_NEW(pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategySize_t, &pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategySize_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategySize>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategySize_Type))
    {
        failmsg("Expected cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategySize for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategySize_t*)src)->v.dynamicCast<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategySize>();
    return true;
}


struct pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyTexture_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyTexture_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".ximgproc_segmentation_SelectiveSearchSegmentationStrategyTexture",
    sizeof(pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyTexture_t),
};

static void pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyTexture_dealloc(PyObject* self)
{
    ((pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyTexture_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyTexture>& r)
{
    pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyTexture_t *m = PyObject_NEW(pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyTexture_t, &pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyTexture_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyTexture>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyTexture_Type))
    {
        failmsg("Expected cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyTexture for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_ximgproc_segmentation_SelectiveSearchSegmentationStrategyTexture_t*)src)->v.dynamicCast<cv::ximgproc::segmentation::SelectiveSearchSegmentationStrategyTexture>();
    return true;
}


struct pyopencv_xphoto_GrayworldWB_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_xphoto_GrayworldWB_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".xphoto_GrayworldWB",
    sizeof(pyopencv_xphoto_GrayworldWB_t),
};

static void pyopencv_xphoto_GrayworldWB_dealloc(PyObject* self)
{
    ((pyopencv_xphoto_GrayworldWB_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::xphoto::GrayworldWB>& r)
{
    pyopencv_xphoto_GrayworldWB_t *m = PyObject_NEW(pyopencv_xphoto_GrayworldWB_t, &pyopencv_xphoto_GrayworldWB_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::xphoto::GrayworldWB>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_xphoto_GrayworldWB_Type))
    {
        failmsg("Expected cv::xphoto::GrayworldWB for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_xphoto_GrayworldWB_t*)src)->v.dynamicCast<cv::xphoto::GrayworldWB>();
    return true;
}


struct pyopencv_xphoto_LearningBasedWB_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_xphoto_LearningBasedWB_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".xphoto_LearningBasedWB",
    sizeof(pyopencv_xphoto_LearningBasedWB_t),
};

static void pyopencv_xphoto_LearningBasedWB_dealloc(PyObject* self)
{
    ((pyopencv_xphoto_LearningBasedWB_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::xphoto::LearningBasedWB>& r)
{
    pyopencv_xphoto_LearningBasedWB_t *m = PyObject_NEW(pyopencv_xphoto_LearningBasedWB_t, &pyopencv_xphoto_LearningBasedWB_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::xphoto::LearningBasedWB>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_xphoto_LearningBasedWB_Type))
    {
        failmsg("Expected cv::xphoto::LearningBasedWB for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_xphoto_LearningBasedWB_t*)src)->v.dynamicCast<cv::xphoto::LearningBasedWB>();
    return true;
}


struct pyopencv_xphoto_SimpleWB_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_xphoto_SimpleWB_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".xphoto_SimpleWB",
    sizeof(pyopencv_xphoto_SimpleWB_t),
};

static void pyopencv_xphoto_SimpleWB_dealloc(PyObject* self)
{
    ((pyopencv_xphoto_SimpleWB_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::xphoto::SimpleWB>& r)
{
    pyopencv_xphoto_SimpleWB_t *m = PyObject_NEW(pyopencv_xphoto_SimpleWB_t, &pyopencv_xphoto_SimpleWB_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::xphoto::SimpleWB>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_xphoto_SimpleWB_Type))
    {
        failmsg("Expected cv::xphoto::SimpleWB for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_xphoto_SimpleWB_t*)src)->v.dynamicCast<cv::xphoto::SimpleWB>();
    return true;
}


struct pyopencv_xphoto_WhiteBalancer_t
{
    PyObject_HEAD
    Ptr<cv::Algorithm> v;
};

static PyTypeObject pyopencv_xphoto_WhiteBalancer_Type =
{
    CV_PYTHON_TYPE_HEAD_INIT()
    MODULESTR".xphoto_WhiteBalancer",
    sizeof(pyopencv_xphoto_WhiteBalancer_t),
};

static void pyopencv_xphoto_WhiteBalancer_dealloc(PyObject* self)
{
    ((pyopencv_xphoto_WhiteBalancer_t*)self)->v.release();
    PyObject_Del(self);
}

template<> PyObject* pyopencv_from(const Ptr<cv::xphoto::WhiteBalancer>& r)
{
    pyopencv_xphoto_WhiteBalancer_t *m = PyObject_NEW(pyopencv_xphoto_WhiteBalancer_t, &pyopencv_xphoto_WhiteBalancer_Type);
    new (&(m->v)) Ptr<cv::Algorithm>(); // init Ptr with placement new
    m->v = r;
    return (PyObject*)m;
}

template<> bool pyopencv_to(PyObject* src, Ptr<cv::xphoto::WhiteBalancer>& dst, const char* name)
{
    if( src == NULL || src == Py_None )
        return true;
    if(!PyObject_TypeCheck(src, &pyopencv_xphoto_WhiteBalancer_Type))
    {
        failmsg("Expected cv::xphoto::WhiteBalancer for argument '%s'", name);
        return false;
    }
    dst = ((pyopencv_xphoto_WhiteBalancer_t*)src)->v.dynamicCast<cv::xphoto::WhiteBalancer>();
    return true;
}


static PyObject* pyopencv_Algorithm_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<Algorithm %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_Algorithm_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_Algorithm_clear(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::Algorithm* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_Algorithm_Type))
        _self_ = ((pyopencv_Algorithm_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'Algorithm' or its derivative)");

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->clear());
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_Algorithm_empty(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::Algorithm* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_Algorithm_Type))
        _self_ = ((pyopencv_Algorithm_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'Algorithm' or its derivative)");
    bool retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->empty());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Algorithm_getDefaultName(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::Algorithm* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_Algorithm_Type))
        _self_ = ((pyopencv_Algorithm_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'Algorithm' or its derivative)");
    String retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDefaultName());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Algorithm_read(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::Algorithm* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_Algorithm_Type))
        _self_ = ((pyopencv_Algorithm_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'Algorithm' or its derivative)");
    PyObject* pyobj_fn = NULL;
    FileNode fn;

    const char* keywords[] = { "fn", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:Algorithm.read", (char**)keywords, &pyobj_fn) &&
        pyopencv_to(pyobj_fn, fn, ArgInfo("fn", 0)) )
    {
        ERRWRAP2(_self_->read(fn));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_Algorithm_save(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::Algorithm* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_Algorithm_Type))
        _self_ = ((pyopencv_Algorithm_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'Algorithm' or its derivative)");
    PyObject* pyobj_filename = NULL;
    String filename;

    const char* keywords[] = { "filename", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:Algorithm.save", (char**)keywords, &pyobj_filename) &&
        pyopencv_to(pyobj_filename, filename, ArgInfo("filename", 0)) )
    {
        ERRWRAP2(_self_->save(filename));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_Algorithm_write(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::Algorithm* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_Algorithm_Type))
        _self_ = ((pyopencv_Algorithm_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'Algorithm' or its derivative)");
    PyObject* pyobj_fs = NULL;
    Ptr<FileStorage> fs;
    PyObject* pyobj_name = NULL;
    String name;

    const char* keywords[] = { "fs", "name", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:Algorithm.write", (char**)keywords, &pyobj_fs, &pyobj_name) &&
        pyopencv_to(pyobj_fs, fs, ArgInfo("fs", 0)) &&
        pyopencv_to(pyobj_name, name, ArgInfo("name", 0)) )
    {
        ERRWRAP2(_self_->write(fs, name));
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_Algorithm_methods[] =
{
    {"clear", (PyCFunction)pyopencv_cv_Algorithm_clear, METH_VARARGS | METH_KEYWORDS, "clear() -> None\n.   @brief Clears the algorithm state"},
    {"empty", (PyCFunction)pyopencv_cv_Algorithm_empty, METH_VARARGS | METH_KEYWORDS, "empty() -> retval\n.   @brief Returns true if the Algorithm is empty (e.g. in the very beginning or after unsuccessful read"},
    {"getDefaultName", (PyCFunction)pyopencv_cv_Algorithm_getDefaultName, METH_VARARGS | METH_KEYWORDS, "getDefaultName() -> retval\n.   Returns the algorithm string identifier.\n.   This string is used as top level xml/yml node tag when the object is saved to a file or string."},
    {"read", (PyCFunction)pyopencv_cv_Algorithm_read, METH_VARARGS | METH_KEYWORDS, "read(fn) -> None\n.   @brief Reads algorithm parameters from a file storage"},
    {"save", (PyCFunction)pyopencv_cv_Algorithm_save, METH_VARARGS | METH_KEYWORDS, "save(filename) -> None\n.   Saves the algorithm to a file.\n.   In order to make this method work, the derived class must implement Algorithm::write(FileStorage& fs)."},
    {"write", (PyCFunction)pyopencv_cv_Algorithm_write, METH_VARARGS | METH_KEYWORDS, "write(fs[, name]) -> None\n.   @brief simplified API for language bindings\n.   * @overload"},

    {NULL,          NULL}
};

static void pyopencv_Algorithm_specials(void)
{
    pyopencv_Algorithm_Type.tp_base = NULL;
    pyopencv_Algorithm_Type.tp_dealloc = pyopencv_Algorithm_dealloc;
    pyopencv_Algorithm_Type.tp_repr = pyopencv_Algorithm_repr;
    pyopencv_Algorithm_Type.tp_getset = pyopencv_Algorithm_getseters;
    pyopencv_Algorithm_Type.tp_init = (initproc)0;
    pyopencv_Algorithm_Type.tp_methods = pyopencv_Algorithm_methods;
}

static PyObject* pyopencv_FileStorage_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<FileStorage %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_FileStorage_getseters[] =
{
    {NULL}  /* Sentinel */
};

static int pyopencv_cv_FileStorage_FileStorage(pyopencv_FileStorage_t* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    {

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        new (&(self->v)) Ptr<cv::FileStorage>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::FileStorage()));
        return 0;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_filename = NULL;
    String filename;
    int flags=0;
    PyObject* pyobj_encoding = NULL;
    String encoding;

    const char* keywords[] = { "filename", "flags", "encoding", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "Oi|O:FileStorage", (char**)keywords, &pyobj_filename, &flags, &pyobj_encoding) &&
        pyopencv_to(pyobj_filename, filename, ArgInfo("filename", 0)) &&
        pyopencv_to(pyobj_encoding, encoding, ArgInfo("encoding", 0)) )
    {
        new (&(self->v)) Ptr<cv::FileStorage>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::FileStorage(filename, flags, encoding)));
        return 0;
    }
    }

    return -1;
}

static PyObject* pyopencv_cv_FileStorage_getFirstTopLevelNode(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::FileStorage* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_FileStorage_Type))
        _self_ = ((pyopencv_FileStorage_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'FileStorage' or its derivative)");
    FileNode retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getFirstTopLevelNode());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileStorage_getFormat(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::FileStorage* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_FileStorage_Type))
        _self_ = ((pyopencv_FileStorage_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'FileStorage' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getFormat());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileStorage_getNode(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::FileStorage* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_FileStorage_Type))
        _self_ = ((pyopencv_FileStorage_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'FileStorage' or its derivative)");
    char* nodename=(char*)"";
    FileNode retval;

    const char* keywords[] = { "nodename", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "s:FileStorage.getNode", (char**)keywords, &nodename) )
    {
        ERRWRAP2(retval = _self_->operator[](nodename));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileStorage_isOpened(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::FileStorage* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_FileStorage_Type))
        _self_ = ((pyopencv_FileStorage_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'FileStorage' or its derivative)");
    bool retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->isOpened());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileStorage_open(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::FileStorage* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_FileStorage_Type))
        _self_ = ((pyopencv_FileStorage_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'FileStorage' or its derivative)");
    PyObject* pyobj_filename = NULL;
    String filename;
    int flags=0;
    PyObject* pyobj_encoding = NULL;
    String encoding;
    bool retval;

    const char* keywords[] = { "filename", "flags", "encoding", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "Oi|O:FileStorage.open", (char**)keywords, &pyobj_filename, &flags, &pyobj_encoding) &&
        pyopencv_to(pyobj_filename, filename, ArgInfo("filename", 0)) &&
        pyopencv_to(pyobj_encoding, encoding, ArgInfo("encoding", 0)) )
    {
        ERRWRAP2(retval = _self_->open(filename, flags, encoding));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileStorage_release(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::FileStorage* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_FileStorage_Type))
        _self_ = ((pyopencv_FileStorage_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'FileStorage' or its derivative)");

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->release());
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileStorage_releaseAndGetString(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::FileStorage* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_FileStorage_Type))
        _self_ = ((pyopencv_FileStorage_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'FileStorage' or its derivative)");
    String retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->releaseAndGetString());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileStorage_root(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::FileStorage* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_FileStorage_Type))
        _self_ = ((pyopencv_FileStorage_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'FileStorage' or its derivative)");
    int streamidx=0;
    FileNode retval;

    const char* keywords[] = { "streamidx", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "|i:FileStorage.root", (char**)keywords, &streamidx) )
    {
        ERRWRAP2(retval = _self_->root(streamidx));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileStorage_write(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::FileStorage* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_FileStorage_Type))
        _self_ = ((pyopencv_FileStorage_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'FileStorage' or its derivative)");
    {
    PyObject* pyobj_name = NULL;
    String name;
    double val=0;

    const char* keywords[] = { "name", "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "Od:FileStorage.write", (char**)keywords, &pyobj_name, &val) &&
        pyopencv_to(pyobj_name, name, ArgInfo("name", 0)) )
    {
        ERRWRAP2(_self_->write(name, val));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_name = NULL;
    String name;
    PyObject* pyobj_val = NULL;
    String val;

    const char* keywords[] = { "name", "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:FileStorage.write", (char**)keywords, &pyobj_name, &pyobj_val) &&
        pyopencv_to(pyobj_name, name, ArgInfo("name", 0)) &&
        pyopencv_to(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->write(name, val));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_name = NULL;
    String name;
    PyObject* pyobj_val = NULL;
    Mat val;

    const char* keywords[] = { "name", "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:FileStorage.write", (char**)keywords, &pyobj_name, &pyobj_val) &&
        pyopencv_to(pyobj_name, name, ArgInfo("name", 0)) &&
        pyopencv_to(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->write(name, val));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_name = NULL;
    String name;
    PyObject* pyobj_val = NULL;
    UMat val;

    const char* keywords[] = { "name", "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:FileStorage.write", (char**)keywords, &pyobj_name, &pyobj_val) &&
        pyopencv_to(pyobj_name, name, ArgInfo("name", 0)) &&
        pyopencv_to(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->write(name, val));
        Py_RETURN_NONE;
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileStorage_writeComment(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::FileStorage* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_FileStorage_Type))
        _self_ = ((pyopencv_FileStorage_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'FileStorage' or its derivative)");
    PyObject* pyobj_comment = NULL;
    String comment;
    bool append=false;

    const char* keywords[] = { "comment", "append", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|b:FileStorage.writeComment", (char**)keywords, &pyobj_comment, &append) &&
        pyopencv_to(pyobj_comment, comment, ArgInfo("comment", 0)) )
    {
        ERRWRAP2(_self_->writeComment(comment, append));
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_FileStorage_methods[] =
{
    {"getFirstTopLevelNode", (PyCFunction)pyopencv_cv_FileStorage_getFirstTopLevelNode, METH_VARARGS | METH_KEYWORDS, "getFirstTopLevelNode() -> retval\n.   @brief Returns the first element of the top-level mapping.\n.   @returns The first element of the top-level mapping."},
    {"getFormat", (PyCFunction)pyopencv_cv_FileStorage_getFormat, METH_VARARGS | METH_KEYWORDS, "getFormat() -> retval\n.   @brief Returns the current format.\n.   * @returns The current format, see FileStorage::Mode"},
    {"getNode", (PyCFunction)pyopencv_cv_FileStorage_getNode, METH_VARARGS | METH_KEYWORDS, "getNode(nodename) -> retval\n.   @overload"},
    {"isOpened", (PyCFunction)pyopencv_cv_FileStorage_isOpened, METH_VARARGS | METH_KEYWORDS, "isOpened() -> retval\n.   @brief Checks whether the file is opened.\n.   \n.   @returns true if the object is associated with the current file and false otherwise. It is a\n.   good practice to call this method after you tried to open a file."},
    {"open", (PyCFunction)pyopencv_cv_FileStorage_open, METH_VARARGS | METH_KEYWORDS, "open(filename, flags[, encoding]) -> retval\n.   @brief Opens a file.\n.   \n.   See description of parameters in FileStorage::FileStorage. The method calls FileStorage::release\n.   before opening the file.\n.   @param filename Name of the file to open or the text string to read the data from.\n.   Extension of the file (.xml, .yml/.yaml or .json) determines its format (XML, YAML or JSON\n.   respectively). Also you can append .gz to work with compressed files, for example myHugeMatrix.xml.gz. If both\n.   FileStorage::WRITE and FileStorage::MEMORY flags are specified, source is used just to specify\n.   the output file format (e.g. mydata.xml, .yml etc.). A file name can also contain parameters.\n.   You can use this format, \"*?base64\" (e.g. \"file.json?base64\" (case sensitive)), as an alternative to\n.   FileStorage::BASE64 flag.\n.   @param flags Mode of operation. One of FileStorage::Mode\n.   @param encoding Encoding of the file. Note that UTF-16 XML encoding is not supported currently and\n.   you should use 8-bit encoding instead of it."},
    {"release", (PyCFunction)pyopencv_cv_FileStorage_release, METH_VARARGS | METH_KEYWORDS, "release() -> None\n.   @brief Closes the file and releases all the memory buffers.\n.   \n.   Call this method after all I/O operations with the storage are finished."},
    {"releaseAndGetString", (PyCFunction)pyopencv_cv_FileStorage_releaseAndGetString, METH_VARARGS | METH_KEYWORDS, "releaseAndGetString() -> retval\n.   @brief Closes the file and releases all the memory buffers.\n.   \n.   Call this method after all I/O operations with the storage are finished. If the storage was\n.   opened for writing data and FileStorage::WRITE was specified"},
    {"root", (PyCFunction)pyopencv_cv_FileStorage_root, METH_VARARGS | METH_KEYWORDS, "root([, streamidx]) -> retval\n.   @brief Returns the top-level mapping\n.   @param streamidx Zero-based index of the stream. In most cases there is only one stream in the file.\n.   However, YAML supports multiple streams and so there can be several.\n.   @returns The top-level mapping."},
    {"write", (PyCFunction)pyopencv_cv_FileStorage_write, METH_VARARGS | METH_KEYWORDS, "write(name, val) -> None\n.   * @brief Simplified writing API to use with bindings.\n.   * @param name Name of the written object\n.   * @param val Value of the written object"},
    {"writeComment", (PyCFunction)pyopencv_cv_FileStorage_writeComment, METH_VARARGS | METH_KEYWORDS, "writeComment(comment[, append]) -> None\n.   @brief Writes a comment.\n.   \n.   The function writes a comment into file storage. The comments are skipped when the storage is read.\n.   @param comment The written comment, single-line or multi-line\n.   @param append If true, the function tries to put the comment at the end of current line.\n.   Else if the comment is multi-line, or if it does not fit at the end of the current\n.   line, the comment starts a new line."},

    {NULL,          NULL}
};

static void pyopencv_FileStorage_specials(void)
{
    pyopencv_FileStorage_Type.tp_base = NULL;
    pyopencv_FileStorage_Type.tp_dealloc = pyopencv_FileStorage_dealloc;
    pyopencv_FileStorage_Type.tp_repr = pyopencv_FileStorage_repr;
    pyopencv_FileStorage_Type.tp_getset = pyopencv_FileStorage_getseters;
    pyopencv_FileStorage_Type.tp_init = (initproc)pyopencv_cv_FileStorage_FileStorage;
    pyopencv_FileStorage_Type.tp_methods = pyopencv_FileStorage_methods;
}

static PyObject* pyopencv_FileNode_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<FileNode %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_FileNode_getseters[] =
{
    {NULL}  /* Sentinel */
};

static int pyopencv_cv_FileNode_FileNode(pyopencv_FileNode_t* self, PyObject* args, PyObject* kw)
{
    using namespace cv;


    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::FileNode());
        return 0;
    }

    return -1;
}

static PyObject* pyopencv_cv_FileNode_at(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::FileNode* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_FileNode_Type))
        _self_ = &((pyopencv_FileNode_t*)self)->v;
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    int i=0;
    FileNode retval;

    const char* keywords[] = { "i", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:FileNode.at", (char**)keywords, &i) )
    {
        ERRWRAP2(retval = _self_->operator[](i));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_empty(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::FileNode* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_FileNode_Type))
        _self_ = &((pyopencv_FileNode_t*)self)->v;
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    bool retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->empty());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_getNode(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::FileNode* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_FileNode_Type))
        _self_ = &((pyopencv_FileNode_t*)self)->v;
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    char* nodename=(char*)"";
    FileNode retval;

    const char* keywords[] = { "nodename", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "s:FileNode.getNode", (char**)keywords, &nodename) )
    {
        ERRWRAP2(retval = _self_->operator[](nodename));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_isInt(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::FileNode* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_FileNode_Type))
        _self_ = &((pyopencv_FileNode_t*)self)->v;
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    bool retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->isInt());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_isMap(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::FileNode* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_FileNode_Type))
        _self_ = &((pyopencv_FileNode_t*)self)->v;
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    bool retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->isMap());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_isNamed(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::FileNode* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_FileNode_Type))
        _self_ = &((pyopencv_FileNode_t*)self)->v;
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    bool retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->isNamed());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_isNone(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::FileNode* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_FileNode_Type))
        _self_ = &((pyopencv_FileNode_t*)self)->v;
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    bool retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->isNone());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_isReal(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::FileNode* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_FileNode_Type))
        _self_ = &((pyopencv_FileNode_t*)self)->v;
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    bool retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->isReal());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_isSeq(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::FileNode* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_FileNode_Type))
        _self_ = &((pyopencv_FileNode_t*)self)->v;
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    bool retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->isSeq());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_isString(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::FileNode* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_FileNode_Type))
        _self_ = &((pyopencv_FileNode_t*)self)->v;
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    bool retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->isString());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_mat(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::FileNode* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_FileNode_Type))
        _self_ = &((pyopencv_FileNode_t*)self)->v;
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->mat());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_name(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::FileNode* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_FileNode_Type))
        _self_ = &((pyopencv_FileNode_t*)self)->v;
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    String retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->name());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_real(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::FileNode* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_FileNode_Type))
        _self_ = &((pyopencv_FileNode_t*)self)->v;
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->real());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_size(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::FileNode* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_FileNode_Type))
        _self_ = &((pyopencv_FileNode_t*)self)->v;
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    size_t retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->size());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_string(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::FileNode* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_FileNode_Type))
        _self_ = &((pyopencv_FileNode_t*)self)->v;
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    String retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->string());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_type(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::FileNode* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_FileNode_Type))
        _self_ = &((pyopencv_FileNode_t*)self)->v;
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->type());
        return pyopencv_from(retval);
    }

    return NULL;
}



static PyMethodDef pyopencv_FileNode_methods[] =
{
    {"at", (PyCFunction)pyopencv_cv_FileNode_at, METH_VARARGS | METH_KEYWORDS, "at(i) -> retval\n.   @overload\n.   @param i Index of an element in the sequence node."},
    {"empty", (PyCFunction)pyopencv_cv_FileNode_empty, METH_VARARGS | METH_KEYWORDS, "empty() -> retval\n."},
    {"getNode", (PyCFunction)pyopencv_cv_FileNode_getNode, METH_VARARGS | METH_KEYWORDS, "getNode(nodename) -> retval\n.   @overload\n.   @param nodename Name of an element in the mapping node."},
    {"isInt", (PyCFunction)pyopencv_cv_FileNode_isInt, METH_VARARGS | METH_KEYWORDS, "isInt() -> retval\n."},
    {"isMap", (PyCFunction)pyopencv_cv_FileNode_isMap, METH_VARARGS | METH_KEYWORDS, "isMap() -> retval\n."},
    {"isNamed", (PyCFunction)pyopencv_cv_FileNode_isNamed, METH_VARARGS | METH_KEYWORDS, "isNamed() -> retval\n."},
    {"isNone", (PyCFunction)pyopencv_cv_FileNode_isNone, METH_VARARGS | METH_KEYWORDS, "isNone() -> retval\n."},
    {"isReal", (PyCFunction)pyopencv_cv_FileNode_isReal, METH_VARARGS | METH_KEYWORDS, "isReal() -> retval\n."},
    {"isSeq", (PyCFunction)pyopencv_cv_FileNode_isSeq, METH_VARARGS | METH_KEYWORDS, "isSeq() -> retval\n."},
    {"isString", (PyCFunction)pyopencv_cv_FileNode_isString, METH_VARARGS | METH_KEYWORDS, "isString() -> retval\n."},
    {"mat", (PyCFunction)pyopencv_cv_FileNode_mat, METH_VARARGS | METH_KEYWORDS, "mat() -> retval\n."},
    {"name", (PyCFunction)pyopencv_cv_FileNode_name, METH_VARARGS | METH_KEYWORDS, "name() -> retval\n."},
    {"real", (PyCFunction)pyopencv_cv_FileNode_real, METH_VARARGS | METH_KEYWORDS, "real() -> retval\n.   @brief Reads node elements to the buffer with the specified format.\n.   \n.   Usually it is more convenient to use operator `>>` instead of this method.\n.   @param fmt Specification of each array element. See @ref format_spec \"format specification\"\n.   @param vec Pointer to the destination array.\n.   @param len Number of elements to read. If it is greater than number of remaining elements then all\n.   of them will be read."},
    {"size", (PyCFunction)pyopencv_cv_FileNode_size, METH_VARARGS | METH_KEYWORDS, "size() -> retval\n."},
    {"string", (PyCFunction)pyopencv_cv_FileNode_string, METH_VARARGS | METH_KEYWORDS, "string() -> retval\n."},
    {"type", (PyCFunction)pyopencv_cv_FileNode_type, METH_VARARGS | METH_KEYWORDS, "type() -> retval\n.   @brief Returns type of the node.\n.   @returns Type of the node. See FileNode::Type"},

    {NULL,          NULL}
};

static void pyopencv_FileNode_specials(void)
{
    pyopencv_FileNode_Type.tp_base = NULL;
    pyopencv_FileNode_Type.tp_dealloc = pyopencv_FileNode_dealloc;
    pyopencv_FileNode_Type.tp_repr = pyopencv_FileNode_repr;
    pyopencv_FileNode_Type.tp_getset = pyopencv_FileNode_getseters;
    pyopencv_FileNode_Type.tp_init = (initproc)pyopencv_cv_FileNode_FileNode;
    pyopencv_FileNode_Type.tp_methods = pyopencv_FileNode_methods;
}

static PyObject* pyopencv_KeyPoint_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<KeyPoint %p>", self);
    return PyString_FromString(str);
}


static PyObject* pyopencv_KeyPoint_get_angle(pyopencv_KeyPoint_t* p, void *closure)
{
    return pyopencv_from(p->v.angle);
}

static int pyopencv_KeyPoint_set_angle(pyopencv_KeyPoint_t* p, PyObject *value, void *closure)
{
    if (value == NULL)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the angle attribute");
        return -1;
    }
    return pyopencv_to(value, p->v.angle) ? 0 : -1;
}

static PyObject* pyopencv_KeyPoint_get_class_id(pyopencv_KeyPoint_t* p, void *closure)
{
    return pyopencv_from(p->v.class_id);
}

static int pyopencv_KeyPoint_set_class_id(pyopencv_KeyPoint_t* p, PyObject *value, void *closure)
{
    if (value == NULL)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the class_id attribute");
        return -1;
    }
    return pyopencv_to(value, p->v.class_id) ? 0 : -1;
}

static PyObject* pyopencv_KeyPoint_get_octave(pyopencv_KeyPoint_t* p, void *closure)
{
    return pyopencv_from(p->v.octave);
}

static int pyopencv_KeyPoint_set_octave(pyopencv_KeyPoint_t* p, PyObject *value, void *closure)
{
    if (value == NULL)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the octave attribute");
        return -1;
    }
    return pyopencv_to(value, p->v.octave) ? 0 : -1;
}

static PyObject* pyopencv_KeyPoint_get_pt(pyopencv_KeyPoint_t* p, void *closure)
{
    return pyopencv_from(p->v.pt);
}

static int pyopencv_KeyPoint_set_pt(pyopencv_KeyPoint_t* p, PyObject *value, void *closure)
{
    if (value == NULL)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the pt attribute");
        return -1;
    }
    return pyopencv_to(value, p->v.pt) ? 0 : -1;
}

static PyObject* pyopencv_KeyPoint_get_response(pyopencv_KeyPoint_t* p, void *closure)
{
    return pyopencv_from(p->v.response);
}

static int pyopencv_KeyPoint_set_response(pyopencv_KeyPoint_t* p, PyObject *value, void *closure)
{
    if (value == NULL)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the response attribute");
        return -1;
    }
    return pyopencv_to(value, p->v.response) ? 0 : -1;
}

static PyObject* pyopencv_KeyPoint_get_size(pyopencv_KeyPoint_t* p, void *closure)
{
    return pyopencv_from(p->v.size);
}

static int pyopencv_KeyPoint_set_size(pyopencv_KeyPoint_t* p, PyObject *value, void *closure)
{
    if (value == NULL)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the size attribute");
        return -1;
    }
    return pyopencv_to(value, p->v.size) ? 0 : -1;
}


static PyGetSetDef pyopencv_KeyPoint_getseters[] =
{
    {(char*)"angle", (getter)pyopencv_KeyPoint_get_angle, (setter)pyopencv_KeyPoint_set_angle, (char*)"angle", NULL},
    {(char*)"class_id", (getter)pyopencv_KeyPoint_get_class_id, (setter)pyopencv_KeyPoint_set_class_id, (char*)"class_id", NULL},
    {(char*)"octave", (getter)pyopencv_KeyPoint_get_octave, (setter)pyopencv_KeyPoint_set_octave, (char*)"octave", NULL},
    {(char*)"pt", (getter)pyopencv_KeyPoint_get_pt, (setter)pyopencv_KeyPoint_set_pt, (char*)"pt", NULL},
    {(char*)"response", (getter)pyopencv_KeyPoint_get_response, (setter)pyopencv_KeyPoint_set_response, (char*)"response", NULL},
    {(char*)"size", (getter)pyopencv_KeyPoint_get_size, (setter)pyopencv_KeyPoint_set_size, (char*)"size", NULL},
    {NULL}  /* Sentinel */
};

static int pyopencv_cv_KeyPoint_KeyPoint(pyopencv_KeyPoint_t* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    {

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::KeyPoint());
        return 0;
    }
    }
    PyErr_Clear();

    {
    float x=0.f;
    float y=0.f;
    float _size=0.f;
    float _angle=-1;
    float _response=0;
    int _octave=0;
    int _class_id=-1;

    const char* keywords[] = { "x", "y", "_size", "_angle", "_response", "_octave", "_class_id", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "fff|ffii:KeyPoint", (char**)keywords, &x, &y, &_size, &_angle, &_response, &_octave, &_class_id) )
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::KeyPoint(x, y, _size, _angle, _response, _octave, _class_id));
        return 0;
    }
    }

    return -1;
}

static PyObject* pyopencv_cv_KeyPoint_convert_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    {
    PyObject* pyobj_keypoints = NULL;
    vector_KeyPoint keypoints;
    vector_Point2f points2f;
    PyObject* pyobj_keypointIndexes = NULL;
    vector_int keypointIndexes=std::vector<int>();

    const char* keywords[] = { "keypoints", "keypointIndexes", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:KeyPoint.convert", (char**)keywords, &pyobj_keypoints, &pyobj_keypointIndexes) &&
        pyopencv_to(pyobj_keypoints, keypoints, ArgInfo("keypoints", 0)) &&
        pyopencv_to(pyobj_keypointIndexes, keypointIndexes, ArgInfo("keypointIndexes", 0)) )
    {
        ERRWRAP2(cv::KeyPoint::convert(keypoints, points2f, keypointIndexes));
        return pyopencv_from(points2f);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_points2f = NULL;
    vector_Point2f points2f;
    vector_KeyPoint keypoints;
    float size=1;
    float response=1;
    int octave=0;
    int class_id=-1;

    const char* keywords[] = { "points2f", "size", "response", "octave", "class_id", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|ffii:KeyPoint.convert", (char**)keywords, &pyobj_points2f, &size, &response, &octave, &class_id) &&
        pyopencv_to(pyobj_points2f, points2f, ArgInfo("points2f", 0)) )
    {
        ERRWRAP2(cv::KeyPoint::convert(points2f, keypoints, size, response, octave, class_id));
        return pyopencv_from(keypoints);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_KeyPoint_overlap_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_kp1 = NULL;
    KeyPoint kp1;
    PyObject* pyobj_kp2 = NULL;
    KeyPoint kp2;
    float retval;

    const char* keywords[] = { "kp1", "kp2", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:KeyPoint.overlap", (char**)keywords, &pyobj_kp1, &pyobj_kp2) &&
        pyopencv_to(pyobj_kp1, kp1, ArgInfo("kp1", 0)) &&
        pyopencv_to(pyobj_kp2, kp2, ArgInfo("kp2", 0)) )
    {
        ERRWRAP2(retval = cv::KeyPoint::overlap(kp1, kp2));
        return pyopencv_from(retval);
    }

    return NULL;
}



static PyMethodDef pyopencv_KeyPoint_methods[] =
{
    {"convert", (PyCFunction)pyopencv_cv_KeyPoint_convert_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "convert(keypoints[, keypointIndexes]) -> points2f\n.   This method converts vector of keypoints to vector of points or the reverse, where each keypoint is\n.   assigned the same size and the same orientation.\n.   \n.   @param keypoints Keypoints obtained from any feature detection algorithm like SIFT/SURF/ORB\n.   @param points2f Array of (x,y) coordinates of each keypoint\n.   @param keypointIndexes Array of indexes of keypoints to be converted to points. (Acts like a mask to\n.   convert only specified keypoints)\n\n\n\nconvert(points2f[, size[, response[, octave[, class_id]]]]) -> keypoints\n.   @overload\n.   @param points2f Array of (x,y) coordinates of each keypoint\n.   @param keypoints Keypoints obtained from any feature detection algorithm like SIFT/SURF/ORB\n.   @param size keypoint diameter\n.   @param response keypoint detector response on the keypoint (that is, strength of the keypoint)\n.   @param octave pyramid octave in which the keypoint has been detected\n.   @param class_id object id"},
    {"overlap", (PyCFunction)pyopencv_cv_KeyPoint_overlap_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "overlap(kp1, kp2) -> retval\n.   This method computes overlap for pair of keypoints. Overlap is the ratio between area of keypoint\n.   regions' intersection and area of keypoint regions' union (considering keypoint region as circle).\n.   If they don't overlap, we get zero. If they coincide at same location with same size, we get 1.\n.   @param kp1 First keypoint\n.   @param kp2 Second keypoint"},

    {NULL,          NULL}
};

static void pyopencv_KeyPoint_specials(void)
{
    pyopencv_KeyPoint_Type.tp_base = NULL;
    pyopencv_KeyPoint_Type.tp_dealloc = pyopencv_KeyPoint_dealloc;
    pyopencv_KeyPoint_Type.tp_repr = pyopencv_KeyPoint_repr;
    pyopencv_KeyPoint_Type.tp_getset = pyopencv_KeyPoint_getseters;
    pyopencv_KeyPoint_Type.tp_init = (initproc)pyopencv_cv_KeyPoint_KeyPoint;
    pyopencv_KeyPoint_Type.tp_methods = pyopencv_KeyPoint_methods;
}

static PyObject* pyopencv_DMatch_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<DMatch %p>", self);
    return PyString_FromString(str);
}


static PyObject* pyopencv_DMatch_get_distance(pyopencv_DMatch_t* p, void *closure)
{
    return pyopencv_from(p->v.distance);
}

static int pyopencv_DMatch_set_distance(pyopencv_DMatch_t* p, PyObject *value, void *closure)
{
    if (value == NULL)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the distance attribute");
        return -1;
    }
    return pyopencv_to(value, p->v.distance) ? 0 : -1;
}

static PyObject* pyopencv_DMatch_get_imgIdx(pyopencv_DMatch_t* p, void *closure)
{
    return pyopencv_from(p->v.imgIdx);
}

static int pyopencv_DMatch_set_imgIdx(pyopencv_DMatch_t* p, PyObject *value, void *closure)
{
    if (value == NULL)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the imgIdx attribute");
        return -1;
    }
    return pyopencv_to(value, p->v.imgIdx) ? 0 : -1;
}

static PyObject* pyopencv_DMatch_get_queryIdx(pyopencv_DMatch_t* p, void *closure)
{
    return pyopencv_from(p->v.queryIdx);
}

static int pyopencv_DMatch_set_queryIdx(pyopencv_DMatch_t* p, PyObject *value, void *closure)
{
    if (value == NULL)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the queryIdx attribute");
        return -1;
    }
    return pyopencv_to(value, p->v.queryIdx) ? 0 : -1;
}

static PyObject* pyopencv_DMatch_get_trainIdx(pyopencv_DMatch_t* p, void *closure)
{
    return pyopencv_from(p->v.trainIdx);
}

static int pyopencv_DMatch_set_trainIdx(pyopencv_DMatch_t* p, PyObject *value, void *closure)
{
    if (value == NULL)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the trainIdx attribute");
        return -1;
    }
    return pyopencv_to(value, p->v.trainIdx) ? 0 : -1;
}


static PyGetSetDef pyopencv_DMatch_getseters[] =
{
    {(char*)"distance", (getter)pyopencv_DMatch_get_distance, (setter)pyopencv_DMatch_set_distance, (char*)"distance", NULL},
    {(char*)"imgIdx", (getter)pyopencv_DMatch_get_imgIdx, (setter)pyopencv_DMatch_set_imgIdx, (char*)"imgIdx", NULL},
    {(char*)"queryIdx", (getter)pyopencv_DMatch_get_queryIdx, (setter)pyopencv_DMatch_set_queryIdx, (char*)"queryIdx", NULL},
    {(char*)"trainIdx", (getter)pyopencv_DMatch_get_trainIdx, (setter)pyopencv_DMatch_set_trainIdx, (char*)"trainIdx", NULL},
    {NULL}  /* Sentinel */
};

static int pyopencv_cv_DMatch_DMatch(pyopencv_DMatch_t* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    {

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::DMatch());
        return 0;
    }
    }
    PyErr_Clear();

    {
    int _queryIdx=0;
    int _trainIdx=0;
    float _distance=0.f;

    const char* keywords[] = { "_queryIdx", "_trainIdx", "_distance", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "iif:DMatch", (char**)keywords, &_queryIdx, &_trainIdx, &_distance) )
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::DMatch(_queryIdx, _trainIdx, _distance));
        return 0;
    }
    }
    PyErr_Clear();

    {
    int _queryIdx=0;
    int _trainIdx=0;
    int _imgIdx=0;
    float _distance=0.f;

    const char* keywords[] = { "_queryIdx", "_trainIdx", "_imgIdx", "_distance", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "iiif:DMatch", (char**)keywords, &_queryIdx, &_trainIdx, &_imgIdx, &_distance) )
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::DMatch(_queryIdx, _trainIdx, _imgIdx, _distance));
        return 0;
    }
    }

    return -1;
}



static PyMethodDef pyopencv_DMatch_methods[] =
{

    {NULL,          NULL}
};

static void pyopencv_DMatch_specials(void)
{
    pyopencv_DMatch_Type.tp_base = NULL;
    pyopencv_DMatch_Type.tp_dealloc = pyopencv_DMatch_dealloc;
    pyopencv_DMatch_Type.tp_repr = pyopencv_DMatch_repr;
    pyopencv_DMatch_Type.tp_getset = pyopencv_DMatch_getseters;
    pyopencv_DMatch_Type.tp_init = (initproc)pyopencv_cv_DMatch_DMatch;
    pyopencv_DMatch_Type.tp_methods = pyopencv_DMatch_methods;
}
static bool pyopencv_to(PyObject* src, cv::Moments& dst, const char* name)
{
    PyObject* tmp;
    bool ok;

    if( PyMapping_HasKeyString(src, (char*)"m00") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"m00");
        ok = tmp && pyopencv_to(tmp, dst.m00);
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"m10") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"m10");
        ok = tmp && pyopencv_to(tmp, dst.m10);
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"m01") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"m01");
        ok = tmp && pyopencv_to(tmp, dst.m01);
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"m20") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"m20");
        ok = tmp && pyopencv_to(tmp, dst.m20);
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"m11") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"m11");
        ok = tmp && pyopencv_to(tmp, dst.m11);
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"m02") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"m02");
        ok = tmp && pyopencv_to(tmp, dst.m02);
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"m30") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"m30");
        ok = tmp && pyopencv_to(tmp, dst.m30);
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"m21") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"m21");
        ok = tmp && pyopencv_to(tmp, dst.m21);
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"m12") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"m12");
        ok = tmp && pyopencv_to(tmp, dst.m12);
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"m03") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"m03");
        ok = tmp && pyopencv_to(tmp, dst.m03);
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"mu20") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"mu20");
        ok = tmp && pyopencv_to(tmp, dst.mu20);
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"mu11") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"mu11");
        ok = tmp && pyopencv_to(tmp, dst.mu11);
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"mu02") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"mu02");
        ok = tmp && pyopencv_to(tmp, dst.mu02);
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"mu30") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"mu30");
        ok = tmp && pyopencv_to(tmp, dst.mu30);
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"mu21") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"mu21");
        ok = tmp && pyopencv_to(tmp, dst.mu21);
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"mu12") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"mu12");
        ok = tmp && pyopencv_to(tmp, dst.mu12);
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"mu03") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"mu03");
        ok = tmp && pyopencv_to(tmp, dst.mu03);
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"nu20") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"nu20");
        ok = tmp && pyopencv_to(tmp, dst.nu20);
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"nu11") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"nu11");
        ok = tmp && pyopencv_to(tmp, dst.nu11);
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"nu02") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"nu02");
        ok = tmp && pyopencv_to(tmp, dst.nu02);
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"nu30") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"nu30");
        ok = tmp && pyopencv_to(tmp, dst.nu30);
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"nu21") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"nu21");
        ok = tmp && pyopencv_to(tmp, dst.nu21);
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"nu12") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"nu12");
        ok = tmp && pyopencv_to(tmp, dst.nu12);
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"nu03") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"nu03");
        ok = tmp && pyopencv_to(tmp, dst.nu03);
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    return true;
}

static PyObject* pyopencv_TickMeter_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<TickMeter %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_TickMeter_getseters[] =
{
    {NULL}  /* Sentinel */
};

static int pyopencv_cv_TickMeter_TickMeter(pyopencv_TickMeter_t* self, PyObject* args, PyObject* kw)
{
    using namespace cv;


    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        new (&(self->v)) Ptr<cv::TickMeter>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::TickMeter()));
        return 0;
    }

    return -1;
}

static PyObject* pyopencv_cv_TickMeter_getCounter(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TickMeter* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TickMeter_Type))
        _self_ = ((pyopencv_TickMeter_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TickMeter' or its derivative)");
    int64 retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getCounter());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TickMeter_getTimeMicro(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TickMeter* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TickMeter_Type))
        _self_ = ((pyopencv_TickMeter_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TickMeter' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTimeMicro());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TickMeter_getTimeMilli(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TickMeter* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TickMeter_Type))
        _self_ = ((pyopencv_TickMeter_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TickMeter' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTimeMilli());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TickMeter_getTimeSec(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TickMeter* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TickMeter_Type))
        _self_ = ((pyopencv_TickMeter_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TickMeter' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTimeSec());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TickMeter_getTimeTicks(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TickMeter* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TickMeter_Type))
        _self_ = ((pyopencv_TickMeter_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TickMeter' or its derivative)");
    int64 retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTimeTicks());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TickMeter_reset(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TickMeter* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TickMeter_Type))
        _self_ = ((pyopencv_TickMeter_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TickMeter' or its derivative)");

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->reset());
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_TickMeter_start(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TickMeter* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TickMeter_Type))
        _self_ = ((pyopencv_TickMeter_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TickMeter' or its derivative)");

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->start());
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_TickMeter_stop(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TickMeter* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TickMeter_Type))
        _self_ = ((pyopencv_TickMeter_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TickMeter' or its derivative)");

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->stop());
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_TickMeter_methods[] =
{
    {"getCounter", (PyCFunction)pyopencv_cv_TickMeter_getCounter, METH_VARARGS | METH_KEYWORDS, "getCounter() -> retval\n.   returns internal counter value."},
    {"getTimeMicro", (PyCFunction)pyopencv_cv_TickMeter_getTimeMicro, METH_VARARGS | METH_KEYWORDS, "getTimeMicro() -> retval\n.   returns passed time in microseconds."},
    {"getTimeMilli", (PyCFunction)pyopencv_cv_TickMeter_getTimeMilli, METH_VARARGS | METH_KEYWORDS, "getTimeMilli() -> retval\n.   returns passed time in milliseconds."},
    {"getTimeSec", (PyCFunction)pyopencv_cv_TickMeter_getTimeSec, METH_VARARGS | METH_KEYWORDS, "getTimeSec() -> retval\n.   returns passed time in seconds."},
    {"getTimeTicks", (PyCFunction)pyopencv_cv_TickMeter_getTimeTicks, METH_VARARGS | METH_KEYWORDS, "getTimeTicks() -> retval\n.   returns counted ticks."},
    {"reset", (PyCFunction)pyopencv_cv_TickMeter_reset, METH_VARARGS | METH_KEYWORDS, "reset() -> None\n.   resets internal values."},
    {"start", (PyCFunction)pyopencv_cv_TickMeter_start, METH_VARARGS | METH_KEYWORDS, "start() -> None\n.   starts counting ticks."},
    {"stop", (PyCFunction)pyopencv_cv_TickMeter_stop, METH_VARARGS | METH_KEYWORDS, "stop() -> None\n.   stops counting ticks."},

    {NULL,          NULL}
};

static void pyopencv_TickMeter_specials(void)
{
    pyopencv_TickMeter_Type.tp_base = NULL;
    pyopencv_TickMeter_Type.tp_dealloc = pyopencv_TickMeter_dealloc;
    pyopencv_TickMeter_Type.tp_repr = pyopencv_TickMeter_repr;
    pyopencv_TickMeter_Type.tp_getset = pyopencv_TickMeter_getseters;
    pyopencv_TickMeter_Type.tp_init = (initproc)pyopencv_cv_TickMeter_TickMeter;
    pyopencv_TickMeter_Type.tp_methods = pyopencv_TickMeter_methods;
}

static PyObject* pyopencv_flann_Index_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<flann_Index %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_flann_Index_getseters[] =
{
    {NULL}  /* Sentinel */
};

static int pyopencv_cv_flann_flann_Index_Index(pyopencv_flann_Index_t* self, PyObject* args, PyObject* kw)
{
    using namespace cv::flann;

    {

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        new (&(self->v)) Ptr<cv::flann::Index>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::flann::Index()));
        return 0;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_features = NULL;
    Mat features;
    PyObject* pyobj_params = NULL;
    IndexParams params;
    PyObject* pyobj_distType = NULL;
    cvflann_flann_distance_t distType=cvflann::FLANN_DIST_L2;

    const char* keywords[] = { "features", "params", "distType", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|O:Index", (char**)keywords, &pyobj_features, &pyobj_params, &pyobj_distType) &&
        pyopencv_to(pyobj_features, features, ArgInfo("features", 0)) &&
        pyopencv_to(pyobj_params, params, ArgInfo("params", 0)) &&
        pyopencv_to(pyobj_distType, distType, ArgInfo("distType", 0)) )
    {
        new (&(self->v)) Ptr<cv::flann::Index>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::flann::Index(features, params, distType)));
        return 0;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_features = NULL;
    UMat features;
    PyObject* pyobj_params = NULL;
    IndexParams params;
    PyObject* pyobj_distType = NULL;
    cvflann_flann_distance_t distType=cvflann::FLANN_DIST_L2;

    const char* keywords[] = { "features", "params", "distType", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|O:Index", (char**)keywords, &pyobj_features, &pyobj_params, &pyobj_distType) &&
        pyopencv_to(pyobj_features, features, ArgInfo("features", 0)) &&
        pyopencv_to(pyobj_params, params, ArgInfo("params", 0)) &&
        pyopencv_to(pyobj_distType, distType, ArgInfo("distType", 0)) )
    {
        new (&(self->v)) Ptr<cv::flann::Index>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::flann::Index(features, params, distType)));
        return 0;
    }
    }

    return -1;
}

static PyObject* pyopencv_cv_flann_flann_Index_build(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::flann;

    cv::flann::Index* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_flann_Index_Type))
        _self_ = ((pyopencv_flann_Index_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'flann_Index' or its derivative)");
    {
    PyObject* pyobj_features = NULL;
    Mat features;
    PyObject* pyobj_params = NULL;
    IndexParams params;
    PyObject* pyobj_distType = NULL;
    cvflann_flann_distance_t distType=cvflann::FLANN_DIST_L2;

    const char* keywords[] = { "features", "params", "distType", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|O:flann_Index.build", (char**)keywords, &pyobj_features, &pyobj_params, &pyobj_distType) &&
        pyopencv_to(pyobj_features, features, ArgInfo("features", 0)) &&
        pyopencv_to(pyobj_params, params, ArgInfo("params", 0)) &&
        pyopencv_to(pyobj_distType, distType, ArgInfo("distType", 0)) )
    {
        ERRWRAP2(_self_->build(features, params, distType));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_features = NULL;
    UMat features;
    PyObject* pyobj_params = NULL;
    IndexParams params;
    PyObject* pyobj_distType = NULL;
    cvflann_flann_distance_t distType=cvflann::FLANN_DIST_L2;

    const char* keywords[] = { "features", "params", "distType", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|O:flann_Index.build", (char**)keywords, &pyobj_features, &pyobj_params, &pyobj_distType) &&
        pyopencv_to(pyobj_features, features, ArgInfo("features", 0)) &&
        pyopencv_to(pyobj_params, params, ArgInfo("params", 0)) &&
        pyopencv_to(pyobj_distType, distType, ArgInfo("distType", 0)) )
    {
        ERRWRAP2(_self_->build(features, params, distType));
        Py_RETURN_NONE;
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_flann_flann_Index_getAlgorithm(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::flann;

    cv::flann::Index* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_flann_Index_Type))
        _self_ = ((pyopencv_flann_Index_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'flann_Index' or its derivative)");
    cvflann::flann_algorithm_t retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getAlgorithm());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_flann_flann_Index_getDistance(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::flann;

    cv::flann::Index* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_flann_Index_Type))
        _self_ = ((pyopencv_flann_Index_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'flann_Index' or its derivative)");
    cvflann::flann_distance_t retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDistance());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_flann_flann_Index_knnSearch(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::flann;

    cv::flann::Index* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_flann_Index_Type))
        _self_ = ((pyopencv_flann_Index_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'flann_Index' or its derivative)");
    {
    PyObject* pyobj_query = NULL;
    Mat query;
    PyObject* pyobj_indices = NULL;
    Mat indices;
    PyObject* pyobj_dists = NULL;
    Mat dists;
    int knn=0;
    PyObject* pyobj_params = NULL;
    SearchParams params;

    const char* keywords[] = { "query", "knn", "indices", "dists", "params", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "Oi|OOO:flann_Index.knnSearch", (char**)keywords, &pyobj_query, &knn, &pyobj_indices, &pyobj_dists, &pyobj_params) &&
        pyopencv_to(pyobj_query, query, ArgInfo("query", 0)) &&
        pyopencv_to(pyobj_indices, indices, ArgInfo("indices", 1)) &&
        pyopencv_to(pyobj_dists, dists, ArgInfo("dists", 1)) &&
        pyopencv_to(pyobj_params, params, ArgInfo("params", 0)) )
    {
        ERRWRAP2(_self_->knnSearch(query, indices, dists, knn, params));
        return Py_BuildValue("(NN)", pyopencv_from(indices), pyopencv_from(dists));
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_query = NULL;
    UMat query;
    PyObject* pyobj_indices = NULL;
    UMat indices;
    PyObject* pyobj_dists = NULL;
    UMat dists;
    int knn=0;
    PyObject* pyobj_params = NULL;
    SearchParams params;

    const char* keywords[] = { "query", "knn", "indices", "dists", "params", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "Oi|OOO:flann_Index.knnSearch", (char**)keywords, &pyobj_query, &knn, &pyobj_indices, &pyobj_dists, &pyobj_params) &&
        pyopencv_to(pyobj_query, query, ArgInfo("query", 0)) &&
        pyopencv_to(pyobj_indices, indices, ArgInfo("indices", 1)) &&
        pyopencv_to(pyobj_dists, dists, ArgInfo("dists", 1)) &&
        pyopencv_to(pyobj_params, params, ArgInfo("params", 0)) )
    {
        ERRWRAP2(_self_->knnSearch(query, indices, dists, knn, params));
        return Py_BuildValue("(NN)", pyopencv_from(indices), pyopencv_from(dists));
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_flann_flann_Index_load(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::flann;

    cv::flann::Index* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_flann_Index_Type))
        _self_ = ((pyopencv_flann_Index_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'flann_Index' or its derivative)");
    {
    PyObject* pyobj_features = NULL;
    Mat features;
    PyObject* pyobj_filename = NULL;
    String filename;
    bool retval;

    const char* keywords[] = { "features", "filename", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:flann_Index.load", (char**)keywords, &pyobj_features, &pyobj_filename) &&
        pyopencv_to(pyobj_features, features, ArgInfo("features", 0)) &&
        pyopencv_to(pyobj_filename, filename, ArgInfo("filename", 0)) )
    {
        ERRWRAP2(retval = _self_->load(features, filename));
        return pyopencv_from(retval);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_features = NULL;
    UMat features;
    PyObject* pyobj_filename = NULL;
    String filename;
    bool retval;

    const char* keywords[] = { "features", "filename", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:flann_Index.load", (char**)keywords, &pyobj_features, &pyobj_filename) &&
        pyopencv_to(pyobj_features, features, ArgInfo("features", 0)) &&
        pyopencv_to(pyobj_filename, filename, ArgInfo("filename", 0)) )
    {
        ERRWRAP2(retval = _self_->load(features, filename));
        return pyopencv_from(retval);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_flann_flann_Index_radiusSearch(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::flann;

    cv::flann::Index* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_flann_Index_Type))
        _self_ = ((pyopencv_flann_Index_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'flann_Index' or its derivative)");
    {
    PyObject* pyobj_query = NULL;
    Mat query;
    PyObject* pyobj_indices = NULL;
    Mat indices;
    PyObject* pyobj_dists = NULL;
    Mat dists;
    double radius=0;
    int maxResults=0;
    PyObject* pyobj_params = NULL;
    SearchParams params;
    int retval;

    const char* keywords[] = { "query", "radius", "maxResults", "indices", "dists", "params", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "Odi|OOO:flann_Index.radiusSearch", (char**)keywords, &pyobj_query, &radius, &maxResults, &pyobj_indices, &pyobj_dists, &pyobj_params) &&
        pyopencv_to(pyobj_query, query, ArgInfo("query", 0)) &&
        pyopencv_to(pyobj_indices, indices, ArgInfo("indices", 1)) &&
        pyopencv_to(pyobj_dists, dists, ArgInfo("dists", 1)) &&
        pyopencv_to(pyobj_params, params, ArgInfo("params", 0)) )
    {
        ERRWRAP2(retval = _self_->radiusSearch(query, indices, dists, radius, maxResults, params));
        return Py_BuildValue("(NNN)", pyopencv_from(retval), pyopencv_from(indices), pyopencv_from(dists));
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_query = NULL;
    UMat query;
    PyObject* pyobj_indices = NULL;
    UMat indices;
    PyObject* pyobj_dists = NULL;
    UMat dists;
    double radius=0;
    int maxResults=0;
    PyObject* pyobj_params = NULL;
    SearchParams params;
    int retval;

    const char* keywords[] = { "query", "radius", "maxResults", "indices", "dists", "params", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "Odi|OOO:flann_Index.radiusSearch", (char**)keywords, &pyobj_query, &radius, &maxResults, &pyobj_indices, &pyobj_dists, &pyobj_params) &&
        pyopencv_to(pyobj_query, query, ArgInfo("query", 0)) &&
        pyopencv_to(pyobj_indices, indices, ArgInfo("indices", 1)) &&
        pyopencv_to(pyobj_dists, dists, ArgInfo("dists", 1)) &&
        pyopencv_to(pyobj_params, params, ArgInfo("params", 0)) )
    {
        ERRWRAP2(retval = _self_->radiusSearch(query, indices, dists, radius, maxResults, params));
        return Py_BuildValue("(NNN)", pyopencv_from(retval), pyopencv_from(indices), pyopencv_from(dists));
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_flann_flann_Index_release(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::flann;

    cv::flann::Index* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_flann_Index_Type))
        _self_ = ((pyopencv_flann_Index_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'flann_Index' or its derivative)");

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->release());
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_flann_flann_Index_save(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::flann;

    cv::flann::Index* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_flann_Index_Type))
        _self_ = ((pyopencv_flann_Index_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'flann_Index' or its derivative)");
    PyObject* pyobj_filename = NULL;
    String filename;

    const char* keywords[] = { "filename", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:flann_Index.save", (char**)keywords, &pyobj_filename) &&
        pyopencv_to(pyobj_filename, filename, ArgInfo("filename", 0)) )
    {
        ERRWRAP2(_self_->save(filename));
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_flann_Index_methods[] =
{
    {"build", (PyCFunction)pyopencv_cv_flann_flann_Index_build, METH_VARARGS | METH_KEYWORDS, "build(features, params[, distType]) -> None\n."},
    {"getAlgorithm", (PyCFunction)pyopencv_cv_flann_flann_Index_getAlgorithm, METH_VARARGS | METH_KEYWORDS, "getAlgorithm() -> retval\n."},
    {"getDistance", (PyCFunction)pyopencv_cv_flann_flann_Index_getDistance, METH_VARARGS | METH_KEYWORDS, "getDistance() -> retval\n."},
    {"knnSearch", (PyCFunction)pyopencv_cv_flann_flann_Index_knnSearch, METH_VARARGS | METH_KEYWORDS, "knnSearch(query, knn[, indices[, dists[, params]]]) -> indices, dists\n."},
    {"load", (PyCFunction)pyopencv_cv_flann_flann_Index_load, METH_VARARGS | METH_KEYWORDS, "load(features, filename) -> retval\n."},
    {"radiusSearch", (PyCFunction)pyopencv_cv_flann_flann_Index_radiusSearch, METH_VARARGS | METH_KEYWORDS, "radiusSearch(query, radius, maxResults[, indices[, dists[, params]]]) -> retval, indices, dists\n."},
    {"release", (PyCFunction)pyopencv_cv_flann_flann_Index_release, METH_VARARGS | METH_KEYWORDS, "release() -> None\n."},
    {"save", (PyCFunction)pyopencv_cv_flann_flann_Index_save, METH_VARARGS | METH_KEYWORDS, "save(filename) -> None\n."},

    {NULL,          NULL}
};

static void pyopencv_flann_Index_specials(void)
{
    pyopencv_flann_Index_Type.tp_base = NULL;
    pyopencv_flann_Index_Type.tp_dealloc = pyopencv_flann_Index_dealloc;
    pyopencv_flann_Index_Type.tp_repr = pyopencv_flann_Index_repr;
    pyopencv_flann_Index_Type.tp_getset = pyopencv_flann_Index_getseters;
    pyopencv_flann_Index_Type.tp_init = (initproc)pyopencv_cv_flann_flann_Index_Index;
    pyopencv_flann_Index_Type.tp_methods = pyopencv_flann_Index_methods;
}

static PyObject* pyopencv_hdf_HDF5_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<hdf_HDF5 %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_hdf_HDF5_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_hdf_hdf_HDF5_atdelete(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::hdf;

    cv::hdf::HDF5* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_hdf_HDF5_Type))
        _self_ = ((pyopencv_hdf_HDF5_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'hdf_HDF5' or its derivative)");
    PyObject* pyobj_atlabel = NULL;
    String atlabel;

    const char* keywords[] = { "atlabel", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:hdf_HDF5.atdelete", (char**)keywords, &pyobj_atlabel) &&
        pyopencv_to(pyobj_atlabel, atlabel, ArgInfo("atlabel", 0)) )
    {
        ERRWRAP2(_self_->atdelete(atlabel));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_hdf_hdf_HDF5_atexists(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::hdf;

    cv::hdf::HDF5* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_hdf_HDF5_Type))
        _self_ = ((pyopencv_hdf_HDF5_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'hdf_HDF5' or its derivative)");
    PyObject* pyobj_atlabel = NULL;
    String atlabel;
    bool retval;

    const char* keywords[] = { "atlabel", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:hdf_HDF5.atexists", (char**)keywords, &pyobj_atlabel) &&
        pyopencv_to(pyobj_atlabel, atlabel, ArgInfo("atlabel", 0)) )
    {
        ERRWRAP2(retval = _self_->atexists(atlabel));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_hdf_hdf_HDF5_atread(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::hdf;

    cv::hdf::HDF5* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_hdf_HDF5_Type))
        _self_ = ((pyopencv_hdf_HDF5_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'hdf_HDF5' or its derivative)");
    {
    int value=0;
    PyObject* pyobj_atlabel = NULL;
    String atlabel;

    const char* keywords[] = { "value", "atlabel", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "iO:hdf_HDF5.atread", (char**)keywords, &value, &pyobj_atlabel) &&
        pyopencv_to(pyobj_atlabel, atlabel, ArgInfo("atlabel", 0)) )
    {
        ERRWRAP2(_self_->atread(&value, atlabel));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    double value=0;
    PyObject* pyobj_atlabel = NULL;
    String atlabel;

    const char* keywords[] = { "value", "atlabel", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "dO:hdf_HDF5.atread", (char**)keywords, &value, &pyobj_atlabel) &&
        pyopencv_to(pyobj_atlabel, atlabel, ArgInfo("atlabel", 0)) )
    {
        ERRWRAP2(_self_->atread(&value, atlabel));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_value = NULL;
    String value;
    PyObject* pyobj_atlabel = NULL;
    String atlabel;

    const char* keywords[] = { "value", "atlabel", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:hdf_HDF5.atread", (char**)keywords, &pyobj_value, &pyobj_atlabel) &&
        pyopencv_to(pyobj_value, value, ArgInfo("value", 0)) &&
        pyopencv_to(pyobj_atlabel, atlabel, ArgInfo("atlabel", 0)) )
    {
        ERRWRAP2(_self_->atread(&value, atlabel));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_value = NULL;
    Mat value;
    PyObject* pyobj_atlabel = NULL;
    String atlabel;

    const char* keywords[] = { "atlabel", "value", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:hdf_HDF5.atread", (char**)keywords, &pyobj_atlabel, &pyobj_value) &&
        pyopencv_to(pyobj_value, value, ArgInfo("value", 1)) &&
        pyopencv_to(pyobj_atlabel, atlabel, ArgInfo("atlabel", 0)) )
    {
        ERRWRAP2(_self_->atread(value, atlabel));
        return pyopencv_from(value);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_value = NULL;
    UMat value;
    PyObject* pyobj_atlabel = NULL;
    String atlabel;

    const char* keywords[] = { "atlabel", "value", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:hdf_HDF5.atread", (char**)keywords, &pyobj_atlabel, &pyobj_value) &&
        pyopencv_to(pyobj_value, value, ArgInfo("value", 1)) &&
        pyopencv_to(pyobj_atlabel, atlabel, ArgInfo("atlabel", 0)) )
    {
        ERRWRAP2(_self_->atread(value, atlabel));
        return pyopencv_from(value);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_hdf_hdf_HDF5_atwrite(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::hdf;

    cv::hdf::HDF5* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_hdf_HDF5_Type))
        _self_ = ((pyopencv_hdf_HDF5_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'hdf_HDF5' or its derivative)");
    {
    int value=0;
    PyObject* pyobj_atlabel = NULL;
    String atlabel;

    const char* keywords[] = { "value", "atlabel", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "iO:hdf_HDF5.atwrite", (char**)keywords, &value, &pyobj_atlabel) &&
        pyopencv_to(pyobj_atlabel, atlabel, ArgInfo("atlabel", 0)) )
    {
        ERRWRAP2(_self_->atwrite(value, atlabel));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    double value=0;
    PyObject* pyobj_atlabel = NULL;
    String atlabel;

    const char* keywords[] = { "value", "atlabel", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "dO:hdf_HDF5.atwrite", (char**)keywords, &value, &pyobj_atlabel) &&
        pyopencv_to(pyobj_atlabel, atlabel, ArgInfo("atlabel", 0)) )
    {
        ERRWRAP2(_self_->atwrite(value, atlabel));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_value = NULL;
    String value;
    PyObject* pyobj_atlabel = NULL;
    String atlabel;

    const char* keywords[] = { "value", "atlabel", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:hdf_HDF5.atwrite", (char**)keywords, &pyobj_value, &pyobj_atlabel) &&
        pyopencv_to(pyobj_value, value, ArgInfo("value", 0)) &&
        pyopencv_to(pyobj_atlabel, atlabel, ArgInfo("atlabel", 0)) )
    {
        ERRWRAP2(_self_->atwrite(value, atlabel));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_value = NULL;
    Mat value;
    PyObject* pyobj_atlabel = NULL;
    String atlabel;

    const char* keywords[] = { "value", "atlabel", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:hdf_HDF5.atwrite", (char**)keywords, &pyobj_value, &pyobj_atlabel) &&
        pyopencv_to(pyobj_value, value, ArgInfo("value", 0)) &&
        pyopencv_to(pyobj_atlabel, atlabel, ArgInfo("atlabel", 0)) )
    {
        ERRWRAP2(_self_->atwrite(value, atlabel));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_value = NULL;
    UMat value;
    PyObject* pyobj_atlabel = NULL;
    String atlabel;

    const char* keywords[] = { "value", "atlabel", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:hdf_HDF5.atwrite", (char**)keywords, &pyobj_value, &pyobj_atlabel) &&
        pyopencv_to(pyobj_value, value, ArgInfo("value", 0)) &&
        pyopencv_to(pyobj_atlabel, atlabel, ArgInfo("atlabel", 0)) )
    {
        ERRWRAP2(_self_->atwrite(value, atlabel));
        Py_RETURN_NONE;
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_hdf_hdf_HDF5_close(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::hdf;

    cv::hdf::HDF5* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_hdf_HDF5_Type))
        _self_ = ((pyopencv_hdf_HDF5_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'hdf_HDF5' or its derivative)");

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->close());
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_hdf_hdf_HDF5_dscreate(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::hdf;

    cv::hdf::HDF5* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_hdf_HDF5_Type))
        _self_ = ((pyopencv_hdf_HDF5_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'hdf_HDF5' or its derivative)");
    {
    int rows=0;
    int cols=0;
    int type=0;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;

    const char* keywords[] = { "rows", "cols", "type", "dslabel", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "iiiO:hdf_HDF5.dscreate", (char**)keywords, &rows, &cols, &type, &pyobj_dslabel) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) )
    {
        ERRWRAP2(_self_->dscreate(rows, cols, type, dslabel));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    int rows=0;
    int cols=0;
    int type=0;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;
    int compresslevel=0;

    const char* keywords[] = { "rows", "cols", "type", "dslabel", "compresslevel", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "iiiOi:hdf_HDF5.dscreate", (char**)keywords, &rows, &cols, &type, &pyobj_dslabel, &compresslevel) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) )
    {
        ERRWRAP2(_self_->dscreate(rows, cols, type, dslabel, compresslevel));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    int rows=0;
    int cols=0;
    int type=0;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;
    int compresslevel=0;
    PyObject* pyobj_dims_chunks = NULL;
    vector_int dims_chunks;

    const char* keywords[] = { "rows", "cols", "type", "dslabel", "compresslevel", "dims_chunks", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "iiiOiO:hdf_HDF5.dscreate", (char**)keywords, &rows, &cols, &type, &pyobj_dslabel, &compresslevel, &pyobj_dims_chunks) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) &&
        pyopencv_to(pyobj_dims_chunks, dims_chunks, ArgInfo("dims_chunks", 0)) )
    {
        ERRWRAP2(_self_->dscreate(rows, cols, type, dslabel, compresslevel, dims_chunks));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    int rows=0;
    int cols=0;
    int type=0;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;
    int compresslevel=0;
    int dims_chunks=0;

    const char* keywords[] = { "rows", "cols", "type", "dslabel", "compresslevel", "dims_chunks", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "iiiOii:hdf_HDF5.dscreate", (char**)keywords, &rows, &cols, &type, &pyobj_dslabel, &compresslevel, &dims_chunks) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) )
    {
        ERRWRAP2(_self_->dscreate(rows, cols, type, dslabel, compresslevel, &dims_chunks));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    int n_dims=0;
    int sizes=0;
    int type=0;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;

    const char* keywords[] = { "n_dims", "sizes", "type", "dslabel", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "iiiO:hdf_HDF5.dscreate", (char**)keywords, &n_dims, &sizes, &type, &pyobj_dslabel) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) )
    {
        ERRWRAP2(_self_->dscreate(n_dims, &sizes, type, dslabel));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    int n_dims=0;
    int sizes=0;
    int type=0;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;
    int compresslevel=0;

    const char* keywords[] = { "n_dims", "sizes", "type", "dslabel", "compresslevel", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "iiiOi:hdf_HDF5.dscreate", (char**)keywords, &n_dims, &sizes, &type, &pyobj_dslabel, &compresslevel) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) )
    {
        ERRWRAP2(_self_->dscreate(n_dims, &sizes, type, dslabel, compresslevel));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_sizes = NULL;
    vector_int sizes;
    int type=0;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;
    int compresslevel=HDF5::H5_NONE;
    PyObject* pyobj_dims_chunks = NULL;
    vector_int dims_chunks=vector<int>();

    const char* keywords[] = { "sizes", "type", "dslabel", "compresslevel", "dims_chunks", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OiO|iO:hdf_HDF5.dscreate", (char**)keywords, &pyobj_sizes, &type, &pyobj_dslabel, &compresslevel, &pyobj_dims_chunks) &&
        pyopencv_to(pyobj_sizes, sizes, ArgInfo("sizes", 0)) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) &&
        pyopencv_to(pyobj_dims_chunks, dims_chunks, ArgInfo("dims_chunks", 0)) )
    {
        ERRWRAP2(_self_->dscreate(sizes, type, dslabel, compresslevel, dims_chunks));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    int n_dims=0;
    int sizes=0;
    int type=0;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;
    int compresslevel=0;
    int dims_chunks=0;

    const char* keywords[] = { "n_dims", "sizes", "type", "dslabel", "compresslevel", "dims_chunks", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "iiiOii:hdf_HDF5.dscreate", (char**)keywords, &n_dims, &sizes, &type, &pyobj_dslabel, &compresslevel, &dims_chunks) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) )
    {
        ERRWRAP2(_self_->dscreate(n_dims, &sizes, type, dslabel, compresslevel, &dims_chunks));
        Py_RETURN_NONE;
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_hdf_hdf_HDF5_dsgetsize(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::hdf;

    cv::hdf::HDF5* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_hdf_HDF5_Type))
        _self_ = ((pyopencv_hdf_HDF5_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'hdf_HDF5' or its derivative)");
    PyObject* pyobj_dslabel = NULL;
    String dslabel;
    int dims_flag=HDF5::H5_GETDIMS;
    vector<int> retval;

    const char* keywords[] = { "dslabel", "dims_flag", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|i:hdf_HDF5.dsgetsize", (char**)keywords, &pyobj_dslabel, &dims_flag) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) )
    {
        ERRWRAP2(retval = _self_->dsgetsize(dslabel, dims_flag));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_hdf_hdf_HDF5_dsgettype(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::hdf;

    cv::hdf::HDF5* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_hdf_HDF5_Type))
        _self_ = ((pyopencv_hdf_HDF5_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'hdf_HDF5' or its derivative)");
    PyObject* pyobj_dslabel = NULL;
    String dslabel;
    int retval;

    const char* keywords[] = { "dslabel", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:hdf_HDF5.dsgettype", (char**)keywords, &pyobj_dslabel) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) )
    {
        ERRWRAP2(retval = _self_->dsgettype(dslabel));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_hdf_hdf_HDF5_dsinsert(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::hdf;

    cv::hdf::HDF5* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_hdf_HDF5_Type))
        _self_ = ((pyopencv_hdf_HDF5_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'hdf_HDF5' or its derivative)");
    {
    PyObject* pyobj_Array = NULL;
    Mat Array;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;

    const char* keywords[] = { "Array", "dslabel", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:hdf_HDF5.dsinsert", (char**)keywords, &pyobj_Array, &pyobj_dslabel) &&
        pyopencv_to(pyobj_Array, Array, ArgInfo("Array", 0)) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) )
    {
        ERRWRAP2(_self_->dsinsert(Array, dslabel));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_Array = NULL;
    UMat Array;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;

    const char* keywords[] = { "Array", "dslabel", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:hdf_HDF5.dsinsert", (char**)keywords, &pyobj_Array, &pyobj_dslabel) &&
        pyopencv_to(pyobj_Array, Array, ArgInfo("Array", 0)) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) )
    {
        ERRWRAP2(_self_->dsinsert(Array, dslabel));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_Array = NULL;
    Mat Array;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;
    int dims_offset=0;

    const char* keywords[] = { "Array", "dslabel", "dims_offset", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOi:hdf_HDF5.dsinsert", (char**)keywords, &pyobj_Array, &pyobj_dslabel, &dims_offset) &&
        pyopencv_to(pyobj_Array, Array, ArgInfo("Array", 0)) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) )
    {
        ERRWRAP2(_self_->dsinsert(Array, dslabel, &dims_offset));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_Array = NULL;
    UMat Array;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;
    int dims_offset=0;

    const char* keywords[] = { "Array", "dslabel", "dims_offset", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOi:hdf_HDF5.dsinsert", (char**)keywords, &pyobj_Array, &pyobj_dslabel, &dims_offset) &&
        pyopencv_to(pyobj_Array, Array, ArgInfo("Array", 0)) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) )
    {
        ERRWRAP2(_self_->dsinsert(Array, dslabel, &dims_offset));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_Array = NULL;
    Mat Array;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;
    PyObject* pyobj_dims_offset = NULL;
    vector_int dims_offset;
    PyObject* pyobj_dims_counts = NULL;
    vector_int dims_counts=vector<int>();

    const char* keywords[] = { "Array", "dslabel", "dims_offset", "dims_counts", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOO|O:hdf_HDF5.dsinsert", (char**)keywords, &pyobj_Array, &pyobj_dslabel, &pyobj_dims_offset, &pyobj_dims_counts) &&
        pyopencv_to(pyobj_Array, Array, ArgInfo("Array", 0)) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) &&
        pyopencv_to(pyobj_dims_offset, dims_offset, ArgInfo("dims_offset", 0)) &&
        pyopencv_to(pyobj_dims_counts, dims_counts, ArgInfo("dims_counts", 0)) )
    {
        ERRWRAP2(_self_->dsinsert(Array, dslabel, dims_offset, dims_counts));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_Array = NULL;
    UMat Array;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;
    PyObject* pyobj_dims_offset = NULL;
    vector_int dims_offset;
    PyObject* pyobj_dims_counts = NULL;
    vector_int dims_counts=vector<int>();

    const char* keywords[] = { "Array", "dslabel", "dims_offset", "dims_counts", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOO|O:hdf_HDF5.dsinsert", (char**)keywords, &pyobj_Array, &pyobj_dslabel, &pyobj_dims_offset, &pyobj_dims_counts) &&
        pyopencv_to(pyobj_Array, Array, ArgInfo("Array", 0)) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) &&
        pyopencv_to(pyobj_dims_offset, dims_offset, ArgInfo("dims_offset", 0)) &&
        pyopencv_to(pyobj_dims_counts, dims_counts, ArgInfo("dims_counts", 0)) )
    {
        ERRWRAP2(_self_->dsinsert(Array, dslabel, dims_offset, dims_counts));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_Array = NULL;
    Mat Array;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;
    int dims_offset=0;
    int dims_counts=0;

    const char* keywords[] = { "Array", "dslabel", "dims_offset", "dims_counts", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOii:hdf_HDF5.dsinsert", (char**)keywords, &pyobj_Array, &pyobj_dslabel, &dims_offset, &dims_counts) &&
        pyopencv_to(pyobj_Array, Array, ArgInfo("Array", 0)) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) )
    {
        ERRWRAP2(_self_->dsinsert(Array, dslabel, &dims_offset, &dims_counts));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_Array = NULL;
    UMat Array;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;
    int dims_offset=0;
    int dims_counts=0;

    const char* keywords[] = { "Array", "dslabel", "dims_offset", "dims_counts", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOii:hdf_HDF5.dsinsert", (char**)keywords, &pyobj_Array, &pyobj_dslabel, &dims_offset, &dims_counts) &&
        pyopencv_to(pyobj_Array, Array, ArgInfo("Array", 0)) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) )
    {
        ERRWRAP2(_self_->dsinsert(Array, dslabel, &dims_offset, &dims_counts));
        Py_RETURN_NONE;
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_hdf_hdf_HDF5_dsread(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::hdf;

    cv::hdf::HDF5* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_hdf_HDF5_Type))
        _self_ = ((pyopencv_hdf_HDF5_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'hdf_HDF5' or its derivative)");
    {
    PyObject* pyobj_Array = NULL;
    Mat Array;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;

    const char* keywords[] = { "dslabel", "Array", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:hdf_HDF5.dsread", (char**)keywords, &pyobj_dslabel, &pyobj_Array) &&
        pyopencv_to(pyobj_Array, Array, ArgInfo("Array", 1)) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) )
    {
        ERRWRAP2(_self_->dsread(Array, dslabel));
        return pyopencv_from(Array);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_Array = NULL;
    UMat Array;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;

    const char* keywords[] = { "dslabel", "Array", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:hdf_HDF5.dsread", (char**)keywords, &pyobj_dslabel, &pyobj_Array) &&
        pyopencv_to(pyobj_Array, Array, ArgInfo("Array", 1)) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) )
    {
        ERRWRAP2(_self_->dsread(Array, dslabel));
        return pyopencv_from(Array);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_Array = NULL;
    Mat Array;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;
    int dims_offset=0;

    const char* keywords[] = { "dslabel", "dims_offset", "Array", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "Oi|O:hdf_HDF5.dsread", (char**)keywords, &pyobj_dslabel, &dims_offset, &pyobj_Array) &&
        pyopencv_to(pyobj_Array, Array, ArgInfo("Array", 1)) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) )
    {
        ERRWRAP2(_self_->dsread(Array, dslabel, &dims_offset));
        return pyopencv_from(Array);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_Array = NULL;
    UMat Array;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;
    int dims_offset=0;

    const char* keywords[] = { "dslabel", "dims_offset", "Array", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "Oi|O:hdf_HDF5.dsread", (char**)keywords, &pyobj_dslabel, &dims_offset, &pyobj_Array) &&
        pyopencv_to(pyobj_Array, Array, ArgInfo("Array", 1)) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) )
    {
        ERRWRAP2(_self_->dsread(Array, dslabel, &dims_offset));
        return pyopencv_from(Array);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_Array = NULL;
    Mat Array;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;
    PyObject* pyobj_dims_offset = NULL;
    vector_int dims_offset;
    PyObject* pyobj_dims_counts = NULL;
    vector_int dims_counts=vector<int>();

    const char* keywords[] = { "dslabel", "dims_offset", "Array", "dims_counts", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|OO:hdf_HDF5.dsread", (char**)keywords, &pyobj_dslabel, &pyobj_dims_offset, &pyobj_Array, &pyobj_dims_counts) &&
        pyopencv_to(pyobj_Array, Array, ArgInfo("Array", 1)) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) &&
        pyopencv_to(pyobj_dims_offset, dims_offset, ArgInfo("dims_offset", 0)) &&
        pyopencv_to(pyobj_dims_counts, dims_counts, ArgInfo("dims_counts", 0)) )
    {
        ERRWRAP2(_self_->dsread(Array, dslabel, dims_offset, dims_counts));
        return pyopencv_from(Array);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_Array = NULL;
    UMat Array;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;
    PyObject* pyobj_dims_offset = NULL;
    vector_int dims_offset;
    PyObject* pyobj_dims_counts = NULL;
    vector_int dims_counts=vector<int>();

    const char* keywords[] = { "dslabel", "dims_offset", "Array", "dims_counts", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|OO:hdf_HDF5.dsread", (char**)keywords, &pyobj_dslabel, &pyobj_dims_offset, &pyobj_Array, &pyobj_dims_counts) &&
        pyopencv_to(pyobj_Array, Array, ArgInfo("Array", 1)) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) &&
        pyopencv_to(pyobj_dims_offset, dims_offset, ArgInfo("dims_offset", 0)) &&
        pyopencv_to(pyobj_dims_counts, dims_counts, ArgInfo("dims_counts", 0)) )
    {
        ERRWRAP2(_self_->dsread(Array, dslabel, dims_offset, dims_counts));
        return pyopencv_from(Array);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_Array = NULL;
    Mat Array;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;
    int dims_offset=0;
    int dims_counts=0;

    const char* keywords[] = { "dslabel", "dims_offset", "dims_counts", "Array", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "Oii|O:hdf_HDF5.dsread", (char**)keywords, &pyobj_dslabel, &dims_offset, &dims_counts, &pyobj_Array) &&
        pyopencv_to(pyobj_Array, Array, ArgInfo("Array", 1)) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) )
    {
        ERRWRAP2(_self_->dsread(Array, dslabel, &dims_offset, &dims_counts));
        return pyopencv_from(Array);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_Array = NULL;
    UMat Array;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;
    int dims_offset=0;
    int dims_counts=0;

    const char* keywords[] = { "dslabel", "dims_offset", "dims_counts", "Array", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "Oii|O:hdf_HDF5.dsread", (char**)keywords, &pyobj_dslabel, &dims_offset, &dims_counts, &pyobj_Array) &&
        pyopencv_to(pyobj_Array, Array, ArgInfo("Array", 1)) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) )
    {
        ERRWRAP2(_self_->dsread(Array, dslabel, &dims_offset, &dims_counts));
        return pyopencv_from(Array);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_hdf_hdf_HDF5_dswrite(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::hdf;

    cv::hdf::HDF5* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_hdf_HDF5_Type))
        _self_ = ((pyopencv_hdf_HDF5_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'hdf_HDF5' or its derivative)");
    {
    PyObject* pyobj_Array = NULL;
    Mat Array;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;

    const char* keywords[] = { "Array", "dslabel", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:hdf_HDF5.dswrite", (char**)keywords, &pyobj_Array, &pyobj_dslabel) &&
        pyopencv_to(pyobj_Array, Array, ArgInfo("Array", 0)) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) )
    {
        ERRWRAP2(_self_->dswrite(Array, dslabel));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_Array = NULL;
    UMat Array;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;

    const char* keywords[] = { "Array", "dslabel", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:hdf_HDF5.dswrite", (char**)keywords, &pyobj_Array, &pyobj_dslabel) &&
        pyopencv_to(pyobj_Array, Array, ArgInfo("Array", 0)) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) )
    {
        ERRWRAP2(_self_->dswrite(Array, dslabel));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_Array = NULL;
    Mat Array;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;
    int dims_offset=0;

    const char* keywords[] = { "Array", "dslabel", "dims_offset", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOi:hdf_HDF5.dswrite", (char**)keywords, &pyobj_Array, &pyobj_dslabel, &dims_offset) &&
        pyopencv_to(pyobj_Array, Array, ArgInfo("Array", 0)) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) )
    {
        ERRWRAP2(_self_->dswrite(Array, dslabel, &dims_offset));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_Array = NULL;
    UMat Array;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;
    int dims_offset=0;

    const char* keywords[] = { "Array", "dslabel", "dims_offset", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOi:hdf_HDF5.dswrite", (char**)keywords, &pyobj_Array, &pyobj_dslabel, &dims_offset) &&
        pyopencv_to(pyobj_Array, Array, ArgInfo("Array", 0)) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) )
    {
        ERRWRAP2(_self_->dswrite(Array, dslabel, &dims_offset));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_Array = NULL;
    Mat Array;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;
    PyObject* pyobj_dims_offset = NULL;
    vector_int dims_offset;
    PyObject* pyobj_dims_counts = NULL;
    vector_int dims_counts=vector<int>();

    const char* keywords[] = { "Array", "dslabel", "dims_offset", "dims_counts", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOO|O:hdf_HDF5.dswrite", (char**)keywords, &pyobj_Array, &pyobj_dslabel, &pyobj_dims_offset, &pyobj_dims_counts) &&
        pyopencv_to(pyobj_Array, Array, ArgInfo("Array", 0)) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) &&
        pyopencv_to(pyobj_dims_offset, dims_offset, ArgInfo("dims_offset", 0)) &&
        pyopencv_to(pyobj_dims_counts, dims_counts, ArgInfo("dims_counts", 0)) )
    {
        ERRWRAP2(_self_->dswrite(Array, dslabel, dims_offset, dims_counts));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_Array = NULL;
    UMat Array;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;
    PyObject* pyobj_dims_offset = NULL;
    vector_int dims_offset;
    PyObject* pyobj_dims_counts = NULL;
    vector_int dims_counts=vector<int>();

    const char* keywords[] = { "Array", "dslabel", "dims_offset", "dims_counts", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOO|O:hdf_HDF5.dswrite", (char**)keywords, &pyobj_Array, &pyobj_dslabel, &pyobj_dims_offset, &pyobj_dims_counts) &&
        pyopencv_to(pyobj_Array, Array, ArgInfo("Array", 0)) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) &&
        pyopencv_to(pyobj_dims_offset, dims_offset, ArgInfo("dims_offset", 0)) &&
        pyopencv_to(pyobj_dims_counts, dims_counts, ArgInfo("dims_counts", 0)) )
    {
        ERRWRAP2(_self_->dswrite(Array, dslabel, dims_offset, dims_counts));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_Array = NULL;
    Mat Array;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;
    int dims_offset=0;
    int dims_counts=0;

    const char* keywords[] = { "Array", "dslabel", "dims_offset", "dims_counts", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOii:hdf_HDF5.dswrite", (char**)keywords, &pyobj_Array, &pyobj_dslabel, &dims_offset, &dims_counts) &&
        pyopencv_to(pyobj_Array, Array, ArgInfo("Array", 0)) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) )
    {
        ERRWRAP2(_self_->dswrite(Array, dslabel, &dims_offset, &dims_counts));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_Array = NULL;
    UMat Array;
    PyObject* pyobj_dslabel = NULL;
    String dslabel;
    int dims_offset=0;
    int dims_counts=0;

    const char* keywords[] = { "Array", "dslabel", "dims_offset", "dims_counts", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOii:hdf_HDF5.dswrite", (char**)keywords, &pyobj_Array, &pyobj_dslabel, &dims_offset, &dims_counts) &&
        pyopencv_to(pyobj_Array, Array, ArgInfo("Array", 0)) &&
        pyopencv_to(pyobj_dslabel, dslabel, ArgInfo("dslabel", 0)) )
    {
        ERRWRAP2(_self_->dswrite(Array, dslabel, &dims_offset, &dims_counts));
        Py_RETURN_NONE;
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_hdf_hdf_HDF5_grcreate(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::hdf;

    cv::hdf::HDF5* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_hdf_HDF5_Type))
        _self_ = ((pyopencv_hdf_HDF5_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'hdf_HDF5' or its derivative)");
    PyObject* pyobj_grlabel = NULL;
    String grlabel;

    const char* keywords[] = { "grlabel", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:hdf_HDF5.grcreate", (char**)keywords, &pyobj_grlabel) &&
        pyopencv_to(pyobj_grlabel, grlabel, ArgInfo("grlabel", 0)) )
    {
        ERRWRAP2(_self_->grcreate(grlabel));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_hdf_hdf_HDF5_hlexists(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::hdf;

    cv::hdf::HDF5* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_hdf_HDF5_Type))
        _self_ = ((pyopencv_hdf_HDF5_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'hdf_HDF5' or its derivative)");
    PyObject* pyobj_label = NULL;
    String label;
    bool retval;

    const char* keywords[] = { "label", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:hdf_HDF5.hlexists", (char**)keywords, &pyobj_label) &&
        pyopencv_to(pyobj_label, label, ArgInfo("label", 0)) )
    {
        ERRWRAP2(retval = _self_->hlexists(label));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_hdf_hdf_HDF5_kpgetsize(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::hdf;

    cv::hdf::HDF5* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_hdf_HDF5_Type))
        _self_ = ((pyopencv_hdf_HDF5_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'hdf_HDF5' or its derivative)");
    PyObject* pyobj_kplabel = NULL;
    String kplabel;
    int dims_flag=HDF5::H5_GETDIMS;
    int retval;

    const char* keywords[] = { "kplabel", "dims_flag", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|i:hdf_HDF5.kpgetsize", (char**)keywords, &pyobj_kplabel, &dims_flag) &&
        pyopencv_to(pyobj_kplabel, kplabel, ArgInfo("kplabel", 0)) )
    {
        ERRWRAP2(retval = _self_->kpgetsize(kplabel, dims_flag));
        return pyopencv_from(retval);
    }

    return NULL;
}



static PyMethodDef pyopencv_hdf_HDF5_methods[] =
{
    {"atdelete", (PyCFunction)pyopencv_cv_hdf_hdf_HDF5_atdelete, METH_VARARGS | METH_KEYWORDS, "atdelete(atlabel) -> None\n.   * Delete an attribute from the root group.\n.   *\n.   * @param atlabel the attribute to be deleted.\n.   *\n.   * @note CV_Error() is called if the given attribute does not exist. Use atexists()\n.   * to check whether it exists or not beforehand.\n.   *\n.   * @sa atexists, atwrite, atread"},
    {"atexists", (PyCFunction)pyopencv_cv_hdf_hdf_HDF5_atexists, METH_VARARGS | METH_KEYWORDS, "atexists(atlabel) -> retval\n.   * Check whether a given attribute exits or not in the root group.\n.   *\n.   * @param atlabel the attribute name to be checked.\n.   * @return true if the attribute exists, false otherwise.\n.   *\n.   * @sa atdelete, atwrite, atread"},
    {"atread", (PyCFunction)pyopencv_cv_hdf_hdf_HDF5_atread, METH_VARARGS | METH_KEYWORDS, "atread(value, atlabel) -> None\n.   * Read an attribute from the root group.\n.   *\n.   * @param value address where the attribute is read into\n.   * @param atlabel attribute name\n.   *\n.   * The following example demonstrates how to read an attribute of type cv::String:\n.   *\n.   *  @snippet samples/read_write_attributes.cpp snippets_read_str\n.   *\n.   * @note The attribute MUST exist, otherwise CV_Error() is called. Use atexists()\n.   * to check if it exists beforehand.\n.   *\n.   * @sa atexists, atdelete, atwrite\n\n\n\natread(atlabel[, value]) -> value\n.   * Read an attribute from the root group.\n.   *\n.   * @param value attribute value. Currently, only n-d continuous multi-channel arrays are supported.\n.   * @param atlabel attribute name.\n.   *\n.   * @note The attribute MUST exist, otherwise CV_Error() is called. Use atexists()\n.   * to check if it exists beforehand.\n.   *\n.   * @sa atexists, atdelete, atwrite"},
    {"atwrite", (PyCFunction)pyopencv_cv_hdf_hdf_HDF5_atwrite, METH_VARARGS | METH_KEYWORDS, "atwrite(value, atlabel) -> None\n.   * Write an attribute inside the root group.\n.   *\n.   * @param value attribute value.\n.   * @param atlabel attribute name.\n.   *\n.   * The following example demonstrates how to write an attribute of type cv::String:\n.   *\n.   *  @snippet samples/read_write_attributes.cpp snippets_write_str\n.   *\n.   * @note CV_Error() is called if the given attribute already exists. Use atexists()\n.   * to check whether it exists or not beforehand. And use atdelete() to delete\n.   * it if it already exists.\n.   *\n.   * @sa atexists, atdelete, atread"},
    {"close", (PyCFunction)pyopencv_cv_hdf_hdf_HDF5_close, METH_VARARGS | METH_KEYWORDS, "close() -> None\n.   @brief Close and release hdf5 object."},
    {"dscreate", (PyCFunction)pyopencv_cv_hdf_hdf_HDF5_dscreate, METH_VARARGS | METH_KEYWORDS, "dscreate(rows, cols, type, dslabel) -> None\n.   @overload\n\n\n\ndscreate(rows, cols, type, dslabel, compresslevel) -> None\n.   @overload\n\n\n\ndscreate(rows, cols, type, dslabel, compresslevel, dims_chunks) -> None\n.   @overload\n\n\n\ndscreate(n_dims, sizes, type, dslabel) -> None\n.   \n\n\n\ndscreate(n_dims, sizes, type, dslabel, compresslevel) -> None\n.   \n\n\n\ndscreate(sizes, type, dslabel[, compresslevel[, dims_chunks]]) -> None\n.   \n\n\n\ndscreate(n_dims, sizes, type, dslabel, compresslevel, dims_chunks) -> None\n.   @brief Create and allocate storage for n-dimensional dataset, single or multichannel type.\n.   @param n_dims declare number of dimensions\n.   @param sizes array containing sizes for each dimensions\n.   @param type type to be used, e.g., CV_8UC3, CV_32FC1, etc.\n.   @param dslabel specify the hdf5 dataset label. Existing dataset label will cause an error.\n.   @param compresslevel specify the compression level 0-9 to be used, H5_NONE is the default value and means no compression.\n.   The value 0 also means no compression.\n.   A value 9 indicating the best compression ration. Note\n.   that a higher compression level indicates a higher computational cost. It relies\n.   on GNU gzip for compression.\n.   @param dims_chunks each array member specifies chunking sizes to be used for block I/O,\n.   by default NULL means none at all.\n.   @note If the dataset already exists, an exception will be thrown. Existence of the dataset can be checked\n.   using hlexists().\n.   \n.   - See example below that creates a 6 dimensional storage space:\n.   @code{.cpp}\n.   // open / autocreate hdf5 file\n.   cv::Ptr<cv::hdf::HDF5> h5io = cv::hdf::open( \"mytest.h5\" );\n.   // create space for 6 dimensional CV_64FC2 matrix\n.   if ( ! h5io->hlexists( \"nddata\" ) )\n.   int n_dims = 5;\n.   int dsdims[n_dims] = { 100, 100, 20, 10, 5, 5 };\n.   h5io->dscreate( n_dims, sizes, CV_64FC2, \"nddata\" );\n.   else\n.   printf(\"DS already created, skipping\\n\" );\n.   // release\n.   h5io->close();\n.   @endcode\n.   \n.   @note Activating compression requires internal chunking. Chunking can significantly improve access\n.   speed both at read and write time, especially for windowed access logic that shifts offset inside dataset.\n.   If no custom chunking is specified, the default one will be invoked by the size of **whole** dataset\n.   as single big chunk of data.\n.   \n.   - See example of level 0 compression (shallow) using chunking against the first\n.   dimension, thus storage will consists of 100 chunks of data:\n.   @code{.cpp}\n.   // open / autocreate hdf5 file\n.   cv::Ptr<cv::hdf::HDF5> h5io = cv::hdf::open( \"mytest.h5\" );\n.   // create space for 6 dimensional CV_64FC2 matrix\n.   if ( ! h5io->hlexists( \"nddata\" ) )\n.   int n_dims = 5;\n.   int dsdims[n_dims] = { 100, 100, 20, 10, 5, 5 };\n.   int chunks[n_dims] = {   1, 100, 20, 10, 5, 5 };\n.   h5io->dscreate( n_dims, dsdims, CV_64FC2, \"nddata\", 0, chunks );\n.   else\n.   printf(\"DS already created, skipping\\n\" );\n.   // release\n.   h5io->close();\n.   @endcode\n.   \n.   @note A value of H5_UNLIMITED inside the **sizes** array means **unlimited** data on that dimension, thus it is\n.   possible to expand anytime such dataset on those unlimited directions. Presence of H5_UNLIMITED on any dimension\n.   **requires** to define custom chunking. No default chunking will be defined in unlimited scenario since the default size\n.   on that dimension will be zero, and will grow once dataset is written. Writing into dataset that has H5_UNLIMITED on\n.   some of its dimension requires dsinsert() instead of dswrite() that allows growth on unlimited dimension instead of\n.   dswrite() that allows to write only in predefined data space.\n.   \n.   - Example below shows a 3 dimensional dataset using no compression with all unlimited sizes and one unit chunking:\n.   @code{.cpp}\n.   // open / autocreate hdf5 file\n.   cv::Ptr<cv::hdf::HDF5> h5io = cv::hdf::open( \"mytest.h5\" );\n.   int n_dims = 3;\n.   int chunks[n_dims] = { 1, 1, 1 };\n.   int dsdims[n_dims] = { cv::hdf::HDF5::H5_UNLIMITED, cv::hdf::HDF5::H5_UNLIMITED, cv::hdf::HDF5::H5_UNLIMITED };\n.   h5io->dscreate( n_dims, dsdims, CV_64FC2, \"nddata\", cv::hdf::HDF5::H5_NONE, chunks );\n.   // release\n.   h5io->close();\n.   @endcode"},
    {"dsgetsize", (PyCFunction)pyopencv_cv_hdf_hdf_HDF5_dsgetsize, METH_VARARGS | METH_KEYWORDS, "dsgetsize(dslabel[, dims_flag]) -> retval\n.   @brief Fetch dataset sizes\n.   @param dslabel specify the hdf5 dataset label to be measured.\n.   @param dims_flag will fetch dataset dimensions on H5_GETDIMS, dataset maximum dimensions on H5_GETMAXDIMS,\n.   and chunk sizes on H5_GETCHUNKDIMS.\n.   \n.   Returns vector object containing sizes of dataset on each dimensions.\n.   \n.   @note Resulting vector size will match the amount of dataset dimensions. By default H5_GETDIMS will return\n.   actual dataset dimensions. Using H5_GETMAXDIM flag will get maximum allowed dimension which normally match\n.   actual dataset dimension but can hold H5_UNLIMITED value if dataset was prepared in **unlimited** mode on\n.   some of its dimension. It can be useful to check existing dataset dimensions before overwrite it as whole or subset.\n.   Trying to write with oversized source data into dataset target will thrown exception. The H5_GETCHUNKDIMS will\n.   return the dimension of chunk if dataset was created with chunking options otherwise returned vector size\n.   will be zero."},
    {"dsgettype", (PyCFunction)pyopencv_cv_hdf_hdf_HDF5_dsgettype, METH_VARARGS | METH_KEYWORDS, "dsgettype(dslabel) -> retval\n.   @brief Fetch dataset type\n.   @param dslabel specify the hdf5 dataset label to be checked.\n.   \n.   Returns the stored matrix type. This is an identifier compatible with the CvMat type system,\n.   like e.g. CV_16SC5 (16-bit signed 5-channel array), and so on.\n.   \n.   @note Result can be parsed with CV_MAT_CN() to obtain amount of channels and CV_MAT_DEPTH() to obtain native cvdata type.\n.   It is thread safe."},
    {"dsinsert", (PyCFunction)pyopencv_cv_hdf_hdf_HDF5_dsinsert, METH_VARARGS | METH_KEYWORDS, "dsinsert(Array, dslabel) -> None\n.   \n\n\n\ndsinsert(Array, dslabel, dims_offset) -> None\n.   \n\n\n\ndsinsert(Array, dslabel, dims_offset[, dims_counts]) -> None\n.   \n\n\n\ndsinsert(Array, dslabel, dims_offset, dims_counts) -> None\n.   @brief Insert or overwrite a Mat object into specified dataset and auto expand dataset size if **unlimited** property allows.\n.   @param Array specify Mat data array to be written.\n.   @param dslabel specify the target hdf5 dataset label.\n.   @param dims_offset each array member specify the offset location\n.   over dataset's each dimensions from where InputArray will be (over)written into dataset.\n.   @param dims_counts each array member specify the amount of data over dataset's\n.   each dimensions from InputArray that will be written into dataset.\n.   \n.   Writes Mat object into targeted dataset and **autoexpand** dataset dimension if allowed.\n.   \n.   @note Unlike dswrite(), datasets are **not** created **automatically**. Only Mat is supported and it must be **continuous**.\n.   If dsinsert() happens over outer regions of dataset dimensions and on that dimension of dataset is in **unlimited** mode then\n.   dataset is expanded, otherwise exception is thrown. To create datasets with **unlimited** property on specific or more\n.   dimensions see dscreate() and the optional H5_UNLIMITED flag at creation time. It is not thread safe over same dataset\n.   but multiple datasets can be merged inside a single hdf5 file.\n.   \n.   - Example below creates **unlimited** rows x 100 cols and expands rows 5 times with dsinsert() using single 100x100 CV_64FC2\n.   over the dataset. Final size will have 5x100 rows and 100 cols, reflecting H matrix five times over row's span. Chunks size is\n.   100x100 just optimized against the H matrix size having compression disabled. If routine is called multiple times dataset will be\n.   just overwritten:\n.   @code{.cpp}\n.   // dual channel hilbert matrix\n.   cv::Mat H(50, 100, CV_64FC2);\n.   for(int i = 0; i < H.rows; i++)\n.   for(int j = 0; j < H.cols; j++)\n.   {\n.   H.at<cv::Vec2d>(i,j)[0] =  1./(i+j+1);\n.   H.at<cv::Vec2d>(i,j)[1] = -1./(i+j+1);\n.   count++;\n.   }\n.   // open / autocreate hdf5 file\n.   cv::Ptr<cv::hdf::HDF5> h5io = cv::hdf::open( \"mytest.h5\" );\n.   // optimise dataset by chunks\n.   int chunks[2] = { 100, 100 };\n.   // create Unlimited x 100 CV_64FC2 space\n.   h5io->dscreate( cv::hdf::HDF5::H5_UNLIMITED, 100, CV_64FC2, \"hilbert\", cv::hdf::HDF5::H5_NONE, chunks );\n.   // write into first half\n.   int offset[2] = { 0, 0 };\n.   for ( int t = 0; t < 5; t++ )\n.   {\n.   offset[0] += 100 * t;\n.   h5io->dsinsert( H, \"hilbert\", offset );\n.   }\n.   // release\n.   h5io->close();\n.   @endcode"},
    {"dsread", (PyCFunction)pyopencv_cv_hdf_hdf_HDF5_dsread, METH_VARARGS | METH_KEYWORDS, "dsread(dslabel[, Array]) -> Array\n.   \n\n\n\ndsread(dslabel, dims_offset[, Array]) -> Array\n.   \n\n\n\ndsread(dslabel, dims_offset[, Array[, dims_counts]]) -> Array\n.   \n\n\n\ndsread(dslabel, dims_offset, dims_counts[, Array]) -> Array\n.   @brief Read specific dataset from hdf5 file into Mat object.\n.   @param Array Mat container where data reads will be returned.\n.   @param dslabel specify the source hdf5 dataset label.\n.   @param dims_offset each array member specify the offset location over\n.   each dimensions from where dataset starts to read into OutputArray.\n.   @param dims_counts each array member specify the amount over dataset's each\n.   dimensions of dataset to read into OutputArray.\n.   \n.   Reads out Mat object reflecting the stored dataset.\n.   \n.   @note If hdf5 file does not exist an exception will be thrown. Use hlexists() to check dataset presence.\n.   It is thread safe.\n.   \n.   - Example below reads a dataset:\n.   @code{.cpp}\n.   // open hdf5 file\n.   cv::Ptr<cv::hdf::HDF5> h5io = cv::hdf::open( \"mytest.h5\" );\n.   // blank Mat container\n.   cv::Mat H;\n.   // read hibert dataset\n.   h5io->read( H, \"hilbert\" );\n.   // release\n.   h5io->close();\n.   @endcode\n.   \n.   - Example below perform read of 3x5 submatrix from second row and third element.\n.   @code{.cpp}\n.   // open hdf5 file\n.   cv::Ptr<cv::hdf::HDF5> h5io = cv::hdf::open( \"mytest.h5\" );\n.   // blank Mat container\n.   cv::Mat H;\n.   int offset[2] = { 1, 2 };\n.   int counts[2] = { 3, 5 };\n.   // read hibert dataset\n.   h5io->read( H, \"hilbert\", offset, counts );\n.   // release\n.   h5io->close();\n.   @endcode"},
    {"dswrite", (PyCFunction)pyopencv_cv_hdf_hdf_HDF5_dswrite, METH_VARARGS | METH_KEYWORDS, "dswrite(Array, dslabel) -> None\n.   \n\n\n\ndswrite(Array, dslabel, dims_offset) -> None\n.   \n\n\n\ndswrite(Array, dslabel, dims_offset[, dims_counts]) -> None\n.   \n\n\n\ndswrite(Array, dslabel, dims_offset, dims_counts) -> None\n.   @brief Write or overwrite a Mat object into specified dataset of hdf5 file.\n.   @param Array specify Mat data array to be written.\n.   @param dslabel specify the target hdf5 dataset label.\n.   @param dims_offset each array member specify the offset location\n.   over dataset's each dimensions from where InputArray will be (over)written into dataset.\n.   @param dims_counts each array member specifies the amount of data over dataset's\n.   each dimensions from InputArray that will be written into dataset.\n.   \n.   Writes Mat object into targeted dataset.\n.   \n.   @note If dataset is not created and does not exist it will be created **automatically**. Only Mat is supported and\n.   it must be **continuous**. It is thread safe but it is recommended that writes to happen over separate non-overlapping\n.   regions. Multiple datasets can be written inside a single hdf5 file.\n.   \n.   - Example below writes a 100x100 CV_64FC2 matrix into a dataset. No dataset pre-creation required. If routine\n.   is called multiple times dataset will be just overwritten:\n.   @code{.cpp}\n.   // dual channel hilbert matrix\n.   cv::Mat H(100, 100, CV_64FC2);\n.   for(int i = 0; i < H.rows; i++)\n.   for(int j = 0; j < H.cols; j++)\n.   {\n.   H.at<cv::Vec2d>(i,j)[0] =  1./(i+j+1);\n.   H.at<cv::Vec2d>(i,j)[1] = -1./(i+j+1);\n.   count++;\n.   }\n.   // open / autocreate hdf5 file\n.   cv::Ptr<cv::hdf::HDF5> h5io = cv::hdf::open( \"mytest.h5\" );\n.   // write / overwrite dataset\n.   h5io->dswrite( H, \"hilbert\" );\n.   // release\n.   h5io->close();\n.   @endcode\n.   \n.   - Example below writes a smaller 50x100 matrix into 100x100 compressed space optimised by two 50x100 chunks.\n.   Matrix is written twice into first half (0->50) and second half (50->100) of data space using offset.\n.   @code{.cpp}\n.   // dual channel hilbert matrix\n.   cv::Mat H(50, 100, CV_64FC2);\n.   for(int i = 0; i < H.rows; i++)\n.   for(int j = 0; j < H.cols; j++)\n.   {\n.   H.at<cv::Vec2d>(i,j)[0] =  1./(i+j+1);\n.   H.at<cv::Vec2d>(i,j)[1] = -1./(i+j+1);\n.   count++;\n.   }\n.   // open / autocreate hdf5 file\n.   cv::Ptr<cv::hdf::HDF5> h5io = cv::hdf::open( \"mytest.h5\" );\n.   // optimise dataset by two chunks\n.   int chunks[2] = { 50, 100 };\n.   // create 100x100 CV_64FC2 compressed space\n.   h5io->dscreate( 100, 100, CV_64FC2, \"hilbert\", 9, chunks );\n.   // write into first half\n.   int offset1[2] = { 0, 0 };\n.   h5io->dswrite( H, \"hilbert\", offset1 );\n.   // write into second half\n.   int offset2[2] = { 50, 0 };\n.   h5io->dswrite( H, \"hilbert\", offset2 );\n.   // release\n.   h5io->close();\n.   @endcode"},
    {"grcreate", (PyCFunction)pyopencv_cv_hdf_hdf_HDF5_grcreate, METH_VARARGS | METH_KEYWORDS, "grcreate(grlabel) -> None\n.   @brief Create a group.\n.   @param grlabel specify the hdf5 group label.\n.   \n.   Create a hdf5 group with default properties. The group is closed automatically after creation.\n.   \n.   @note Groups are useful for better organising multiple datasets. It is possible to create subgroups within any group.\n.   Existence of a particular group can be checked using hlexists(). In case of subgroups, a label would be e.g: 'Group1/SubGroup1'\n.   where SubGroup1 is within the root group Group1. Before creating a subgroup, its parent group MUST be created.\n.   \n.   - In this example, Group1 will have one subgroup called SubGroup1:\n.   \n.   @snippet samples/create_groups.cpp create_group\n.   \n.   The corresponding result visualized using the HDFView tool is\n.   \n.   ![Visualization of groups using the HDFView tool](pics/create_groups.png)\n.   \n.   @note When a dataset is created with dscreate() or kpcreate(), it can be created within a group by specifying the\n.   full path within the label. In our example, it would be: 'Group1/SubGroup1/MyDataSet'. It is not thread safe."},
    {"hlexists", (PyCFunction)pyopencv_cv_hdf_hdf_HDF5_hlexists, METH_VARARGS | METH_KEYWORDS, "hlexists(label) -> retval\n.   @brief Check if label exists or not.\n.   @param label specify the hdf5 dataset label.\n.   \n.   Returns **true** if dataset exists, and **false** otherwise.\n.   \n.   @note Checks if dataset, group or other object type (hdf5 link) exists under the label name. It is thread safe."},
    {"kpgetsize", (PyCFunction)pyopencv_cv_hdf_hdf_HDF5_kpgetsize, METH_VARARGS | METH_KEYWORDS, "kpgetsize(kplabel[, dims_flag]) -> retval\n.   @brief Fetch keypoint dataset size\n.   @param kplabel specify the hdf5 dataset label to be measured.\n.   @param dims_flag will fetch dataset dimensions on H5_GETDIMS, and dataset maximum dimensions on H5_GETMAXDIMS.\n.   \n.   Returns size of keypoints dataset.\n.   \n.   @note Resulting size will match the amount of keypoints. By default H5_GETDIMS will return actual dataset dimension.\n.   Using H5_GETMAXDIM flag will get maximum allowed dimension which normally match actual dataset dimension but can hold\n.   H5_UNLIMITED value if dataset was prepared in **unlimited** mode. It can be useful to check existing dataset dimension\n.   before overwrite it as whole or subset. Trying to write with oversized source data into dataset target will thrown\n.   exception. The H5_GETCHUNKDIMS will return the dimension of chunk if dataset was created with chunking options otherwise\n.   returned vector size will be zero."},

    {NULL,          NULL}
};

static void pyopencv_hdf_HDF5_specials(void)
{
    pyopencv_hdf_HDF5_Type.tp_base = NULL;
    pyopencv_hdf_HDF5_Type.tp_dealloc = pyopencv_hdf_HDF5_dealloc;
    pyopencv_hdf_HDF5_Type.tp_repr = pyopencv_hdf_HDF5_repr;
    pyopencv_hdf_HDF5_Type.tp_getset = pyopencv_hdf_HDF5_getseters;
    pyopencv_hdf_HDF5_Type.tp_init = (initproc)0;
    pyopencv_hdf_HDF5_Type.tp_methods = pyopencv_hdf_HDF5_methods;
}

static PyObject* pyopencv_CLAHE_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<CLAHE %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_CLAHE_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_CLAHE_apply(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::CLAHE* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_CLAHE_Type))
        _self_ = dynamic_cast<cv::CLAHE*>(((pyopencv_CLAHE_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'CLAHE' or its derivative)");
    {
    PyObject* pyobj_src = NULL;
    Mat src;
    PyObject* pyobj_dst = NULL;
    Mat dst;

    const char* keywords[] = { "src", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:CLAHE.apply", (char**)keywords, &pyobj_src, &pyobj_dst) &&
        pyopencv_to(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to(pyobj_dst, dst, ArgInfo("dst", 1)) )
    {
        ERRWRAP2(_self_->apply(src, dst));
        return pyopencv_from(dst);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_src = NULL;
    UMat src;
    PyObject* pyobj_dst = NULL;
    UMat dst;

    const char* keywords[] = { "src", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:CLAHE.apply", (char**)keywords, &pyobj_src, &pyobj_dst) &&
        pyopencv_to(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to(pyobj_dst, dst, ArgInfo("dst", 1)) )
    {
        ERRWRAP2(_self_->apply(src, dst));
        return pyopencv_from(dst);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_CLAHE_collectGarbage(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::CLAHE* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_CLAHE_Type))
        _self_ = dynamic_cast<cv::CLAHE*>(((pyopencv_CLAHE_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'CLAHE' or its derivative)");

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->collectGarbage());
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_CLAHE_getClipLimit(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::CLAHE* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_CLAHE_Type))
        _self_ = dynamic_cast<cv::CLAHE*>(((pyopencv_CLAHE_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'CLAHE' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getClipLimit());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_CLAHE_getTilesGridSize(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::CLAHE* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_CLAHE_Type))
        _self_ = dynamic_cast<cv::CLAHE*>(((pyopencv_CLAHE_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'CLAHE' or its derivative)");
    Size retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTilesGridSize());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_CLAHE_setClipLimit(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::CLAHE* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_CLAHE_Type))
        _self_ = dynamic_cast<cv::CLAHE*>(((pyopencv_CLAHE_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'CLAHE' or its derivative)");
    double clipLimit=0;

    const char* keywords[] = { "clipLimit", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:CLAHE.setClipLimit", (char**)keywords, &clipLimit) )
    {
        ERRWRAP2(_self_->setClipLimit(clipLimit));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_CLAHE_setTilesGridSize(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::CLAHE* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_CLAHE_Type))
        _self_ = dynamic_cast<cv::CLAHE*>(((pyopencv_CLAHE_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'CLAHE' or its derivative)");
    PyObject* pyobj_tileGridSize = NULL;
    Size tileGridSize;

    const char* keywords[] = { "tileGridSize", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:CLAHE.setTilesGridSize", (char**)keywords, &pyobj_tileGridSize) &&
        pyopencv_to(pyobj_tileGridSize, tileGridSize, ArgInfo("tileGridSize", 0)) )
    {
        ERRWRAP2(_self_->setTilesGridSize(tileGridSize));
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_CLAHE_methods[] =
{
    {"apply", (PyCFunction)pyopencv_cv_CLAHE_apply, METH_VARARGS | METH_KEYWORDS, "apply(src[, dst]) -> dst\n.   @brief Equalizes the histogram of a grayscale image using Contrast Limited Adaptive Histogram Equalization.\n.   \n.   @param src Source image with CV_8UC1 type.\n.   @param dst Destination image."},
    {"collectGarbage", (PyCFunction)pyopencv_cv_CLAHE_collectGarbage, METH_VARARGS | METH_KEYWORDS, "collectGarbage() -> None\n."},
    {"getClipLimit", (PyCFunction)pyopencv_cv_CLAHE_getClipLimit, METH_VARARGS | METH_KEYWORDS, "getClipLimit() -> retval\n."},
    {"getTilesGridSize", (PyCFunction)pyopencv_cv_CLAHE_getTilesGridSize, METH_VARARGS | METH_KEYWORDS, "getTilesGridSize() -> retval\n."},
    {"setClipLimit", (PyCFunction)pyopencv_cv_CLAHE_setClipLimit, METH_VARARGS | METH_KEYWORDS, "setClipLimit(clipLimit) -> None\n.   @brief Sets threshold for contrast limiting.\n.   \n.   @param clipLimit threshold value."},
    {"setTilesGridSize", (PyCFunction)pyopencv_cv_CLAHE_setTilesGridSize, METH_VARARGS | METH_KEYWORDS, "setTilesGridSize(tileGridSize) -> None\n.   @brief Sets size of grid for histogram equalization. Input image will be divided into\n.   equally sized rectangular tiles.\n.   \n.   @param tileGridSize defines the number of tiles in row and column."},

    {NULL,          NULL}
};

static void pyopencv_CLAHE_specials(void)
{
    pyopencv_CLAHE_Type.tp_base = &pyopencv_Algorithm_Type;
    pyopencv_CLAHE_Type.tp_dealloc = pyopencv_CLAHE_dealloc;
    pyopencv_CLAHE_Type.tp_repr = pyopencv_CLAHE_repr;
    pyopencv_CLAHE_Type.tp_getset = pyopencv_CLAHE_getseters;
    pyopencv_CLAHE_Type.tp_init = (initproc)0;
    pyopencv_CLAHE_Type.tp_methods = pyopencv_CLAHE_methods;
}

static PyObject* pyopencv_Subdiv2D_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<Subdiv2D %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_Subdiv2D_getseters[] =
{
    {NULL}  /* Sentinel */
};

static int pyopencv_cv_Subdiv2D_Subdiv2D(pyopencv_Subdiv2D_t* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    {

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        new (&(self->v)) Ptr<cv::Subdiv2D>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::Subdiv2D()));
        return 0;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_rect = NULL;
    Rect rect;

    const char* keywords[] = { "rect", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:Subdiv2D", (char**)keywords, &pyobj_rect) &&
        pyopencv_to(pyobj_rect, rect, ArgInfo("rect", 0)) )
    {
        new (&(self->v)) Ptr<cv::Subdiv2D>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::Subdiv2D(rect)));
        return 0;
    }
    }

    return -1;
}

static PyObject* pyopencv_cv_Subdiv2D_edgeDst(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::Subdiv2D* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_Subdiv2D_Type))
        _self_ = ((pyopencv_Subdiv2D_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    int edge=0;
    Point2f dstpt;
    int retval;

    const char* keywords[] = { "edge", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:Subdiv2D.edgeDst", (char**)keywords, &edge) )
    {
        ERRWRAP2(retval = _self_->edgeDst(edge, &dstpt));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(dstpt));
    }

    return NULL;
}

static PyObject* pyopencv_cv_Subdiv2D_edgeOrg(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::Subdiv2D* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_Subdiv2D_Type))
        _self_ = ((pyopencv_Subdiv2D_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    int edge=0;
    Point2f orgpt;
    int retval;

    const char* keywords[] = { "edge", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:Subdiv2D.edgeOrg", (char**)keywords, &edge) )
    {
        ERRWRAP2(retval = _self_->edgeOrg(edge, &orgpt));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(orgpt));
    }

    return NULL;
}

static PyObject* pyopencv_cv_Subdiv2D_findNearest(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::Subdiv2D* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_Subdiv2D_Type))
        _self_ = ((pyopencv_Subdiv2D_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    PyObject* pyobj_pt = NULL;
    Point2f pt;
    Point2f nearestPt;
    int retval;

    const char* keywords[] = { "pt", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:Subdiv2D.findNearest", (char**)keywords, &pyobj_pt) &&
        pyopencv_to(pyobj_pt, pt, ArgInfo("pt", 0)) )
    {
        ERRWRAP2(retval = _self_->findNearest(pt, &nearestPt));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(nearestPt));
    }

    return NULL;
}

static PyObject* pyopencv_cv_Subdiv2D_getEdge(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::Subdiv2D* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_Subdiv2D_Type))
        _self_ = ((pyopencv_Subdiv2D_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    int edge=0;
    int nextEdgeType=0;
    int retval;

    const char* keywords[] = { "edge", "nextEdgeType", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "ii:Subdiv2D.getEdge", (char**)keywords, &edge, &nextEdgeType) )
    {
        ERRWRAP2(retval = _self_->getEdge(edge, nextEdgeType));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Subdiv2D_getEdgeList(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::Subdiv2D* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_Subdiv2D_Type))
        _self_ = ((pyopencv_Subdiv2D_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    vector_Vec4f edgeList;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->getEdgeList(edgeList));
        return pyopencv_from(edgeList);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Subdiv2D_getLeadingEdgeList(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::Subdiv2D* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_Subdiv2D_Type))
        _self_ = ((pyopencv_Subdiv2D_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    vector_int leadingEdgeList;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->getLeadingEdgeList(leadingEdgeList));
        return pyopencv_from(leadingEdgeList);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Subdiv2D_getTriangleList(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::Subdiv2D* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_Subdiv2D_Type))
        _self_ = ((pyopencv_Subdiv2D_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    vector_Vec6f triangleList;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->getTriangleList(triangleList));
        return pyopencv_from(triangleList);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Subdiv2D_getVertex(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::Subdiv2D* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_Subdiv2D_Type))
        _self_ = ((pyopencv_Subdiv2D_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    int vertex=0;
    int firstEdge;
    Point2f retval;

    const char* keywords[] = { "vertex", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:Subdiv2D.getVertex", (char**)keywords, &vertex) )
    {
        ERRWRAP2(retval = _self_->getVertex(vertex, &firstEdge));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(firstEdge));
    }

    return NULL;
}

static PyObject* pyopencv_cv_Subdiv2D_getVoronoiFacetList(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::Subdiv2D* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_Subdiv2D_Type))
        _self_ = ((pyopencv_Subdiv2D_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    PyObject* pyobj_idx = NULL;
    vector_int idx;
    vector_vector_Point2f facetList;
    vector_Point2f facetCenters;

    const char* keywords[] = { "idx", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:Subdiv2D.getVoronoiFacetList", (char**)keywords, &pyobj_idx) &&
        pyopencv_to(pyobj_idx, idx, ArgInfo("idx", 0)) )
    {
        ERRWRAP2(_self_->getVoronoiFacetList(idx, facetList, facetCenters));
        return Py_BuildValue("(NN)", pyopencv_from(facetList), pyopencv_from(facetCenters));
    }

    return NULL;
}

static PyObject* pyopencv_cv_Subdiv2D_initDelaunay(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::Subdiv2D* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_Subdiv2D_Type))
        _self_ = ((pyopencv_Subdiv2D_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    PyObject* pyobj_rect = NULL;
    Rect rect;

    const char* keywords[] = { "rect", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:Subdiv2D.initDelaunay", (char**)keywords, &pyobj_rect) &&
        pyopencv_to(pyobj_rect, rect, ArgInfo("rect", 0)) )
    {
        ERRWRAP2(_self_->initDelaunay(rect));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_Subdiv2D_insert(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::Subdiv2D* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_Subdiv2D_Type))
        _self_ = ((pyopencv_Subdiv2D_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    {
    PyObject* pyobj_pt = NULL;
    Point2f pt;
    int retval;

    const char* keywords[] = { "pt", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:Subdiv2D.insert", (char**)keywords, &pyobj_pt) &&
        pyopencv_to(pyobj_pt, pt, ArgInfo("pt", 0)) )
    {
        ERRWRAP2(retval = _self_->insert(pt));
        return pyopencv_from(retval);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_ptvec = NULL;
    vector_Point2f ptvec;

    const char* keywords[] = { "ptvec", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:Subdiv2D.insert", (char**)keywords, &pyobj_ptvec) &&
        pyopencv_to(pyobj_ptvec, ptvec, ArgInfo("ptvec", 0)) )
    {
        ERRWRAP2(_self_->insert(ptvec));
        Py_RETURN_NONE;
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_Subdiv2D_locate(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::Subdiv2D* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_Subdiv2D_Type))
        _self_ = ((pyopencv_Subdiv2D_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    PyObject* pyobj_pt = NULL;
    Point2f pt;
    int edge;
    int vertex;
    int retval;

    const char* keywords[] = { "pt", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:Subdiv2D.locate", (char**)keywords, &pyobj_pt) &&
        pyopencv_to(pyobj_pt, pt, ArgInfo("pt", 0)) )
    {
        ERRWRAP2(retval = _self_->locate(pt, edge, vertex));
        return Py_BuildValue("(NNN)", pyopencv_from(retval), pyopencv_from(edge), pyopencv_from(vertex));
    }

    return NULL;
}

static PyObject* pyopencv_cv_Subdiv2D_nextEdge(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::Subdiv2D* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_Subdiv2D_Type))
        _self_ = ((pyopencv_Subdiv2D_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    int edge=0;
    int retval;

    const char* keywords[] = { "edge", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:Subdiv2D.nextEdge", (char**)keywords, &edge) )
    {
        ERRWRAP2(retval = _self_->nextEdge(edge));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Subdiv2D_rotateEdge(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::Subdiv2D* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_Subdiv2D_Type))
        _self_ = ((pyopencv_Subdiv2D_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    int edge=0;
    int rotate=0;
    int retval;

    const char* keywords[] = { "edge", "rotate", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "ii:Subdiv2D.rotateEdge", (char**)keywords, &edge, &rotate) )
    {
        ERRWRAP2(retval = _self_->rotateEdge(edge, rotate));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Subdiv2D_symEdge(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::Subdiv2D* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_Subdiv2D_Type))
        _self_ = ((pyopencv_Subdiv2D_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    int edge=0;
    int retval;

    const char* keywords[] = { "edge", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:Subdiv2D.symEdge", (char**)keywords, &edge) )
    {
        ERRWRAP2(retval = _self_->symEdge(edge));
        return pyopencv_from(retval);
    }

    return NULL;
}



static PyMethodDef pyopencv_Subdiv2D_methods[] =
{
    {"edgeDst", (PyCFunction)pyopencv_cv_Subdiv2D_edgeDst, METH_VARARGS | METH_KEYWORDS, "edgeDst(edge) -> retval, dstpt\n.   @brief Returns the edge destination.\n.   \n.   @param edge Subdivision edge ID.\n.   @param dstpt Output vertex location.\n.   \n.   @returns vertex ID."},
    {"edgeOrg", (PyCFunction)pyopencv_cv_Subdiv2D_edgeOrg, METH_VARARGS | METH_KEYWORDS, "edgeOrg(edge) -> retval, orgpt\n.   @brief Returns the edge origin.\n.   \n.   @param edge Subdivision edge ID.\n.   @param orgpt Output vertex location.\n.   \n.   @returns vertex ID."},
    {"findNearest", (PyCFunction)pyopencv_cv_Subdiv2D_findNearest, METH_VARARGS | METH_KEYWORDS, "findNearest(pt) -> retval, nearestPt\n.   @brief Finds the subdivision vertex closest to the given point.\n.   \n.   @param pt Input point.\n.   @param nearestPt Output subdivision vertex point.\n.   \n.   The function is another function that locates the input point within the subdivision. It finds the\n.   subdivision vertex that is the closest to the input point. It is not necessarily one of vertices\n.   of the facet containing the input point, though the facet (located using locate() ) is used as a\n.   starting point.\n.   \n.   @returns vertex ID."},
    {"getEdge", (PyCFunction)pyopencv_cv_Subdiv2D_getEdge, METH_VARARGS | METH_KEYWORDS, "getEdge(edge, nextEdgeType) -> retval\n.   @brief Returns one of the edges related to the given edge.\n.   \n.   @param edge Subdivision edge ID.\n.   @param nextEdgeType Parameter specifying which of the related edges to return.\n.   The following values are possible:\n.   -   NEXT_AROUND_ORG next around the edge origin ( eOnext on the picture below if e is the input edge)\n.   -   NEXT_AROUND_DST next around the edge vertex ( eDnext )\n.   -   PREV_AROUND_ORG previous around the edge origin (reversed eRnext )\n.   -   PREV_AROUND_DST previous around the edge destination (reversed eLnext )\n.   -   NEXT_AROUND_LEFT next around the left facet ( eLnext )\n.   -   NEXT_AROUND_RIGHT next around the right facet ( eRnext )\n.   -   PREV_AROUND_LEFT previous around the left facet (reversed eOnext )\n.   -   PREV_AROUND_RIGHT previous around the right facet (reversed eDnext )\n.   \n.   ![sample output](pics/quadedge.png)\n.   \n.   @returns edge ID related to the input edge."},
    {"getEdgeList", (PyCFunction)pyopencv_cv_Subdiv2D_getEdgeList, METH_VARARGS | METH_KEYWORDS, "getEdgeList() -> edgeList\n.   @brief Returns a list of all edges.\n.   \n.   @param edgeList Output vector.\n.   \n.   The function gives each edge as a 4 numbers vector, where each two are one of the edge\n.   vertices. i.e. org_x = v[0], org_y = v[1], dst_x = v[2], dst_y = v[3]."},
    {"getLeadingEdgeList", (PyCFunction)pyopencv_cv_Subdiv2D_getLeadingEdgeList, METH_VARARGS | METH_KEYWORDS, "getLeadingEdgeList() -> leadingEdgeList\n.   @brief Returns a list of the leading edge ID connected to each triangle.\n.   \n.   @param leadingEdgeList Output vector.\n.   \n.   The function gives one edge ID for each triangle."},
    {"getTriangleList", (PyCFunction)pyopencv_cv_Subdiv2D_getTriangleList, METH_VARARGS | METH_KEYWORDS, "getTriangleList() -> triangleList\n.   @brief Returns a list of all triangles.\n.   \n.   @param triangleList Output vector.\n.   \n.   The function gives each triangle as a 6 numbers vector, where each two are one of the triangle\n.   vertices. i.e. p1_x = v[0], p1_y = v[1], p2_x = v[2], p2_y = v[3], p3_x = v[4], p3_y = v[5]."},
    {"getVertex", (PyCFunction)pyopencv_cv_Subdiv2D_getVertex, METH_VARARGS | METH_KEYWORDS, "getVertex(vertex) -> retval, firstEdge\n.   @brief Returns vertex location from vertex ID.\n.   \n.   @param vertex vertex ID.\n.   @param firstEdge Optional. The first edge ID which is connected to the vertex.\n.   @returns vertex (x,y)"},
    {"getVoronoiFacetList", (PyCFunction)pyopencv_cv_Subdiv2D_getVoronoiFacetList, METH_VARARGS | METH_KEYWORDS, "getVoronoiFacetList(idx) -> facetList, facetCenters\n.   @brief Returns a list of all Voroni facets.\n.   \n.   @param idx Vector of vertices IDs to consider. For all vertices you can pass empty vector.\n.   @param facetList Output vector of the Voroni facets.\n.   @param facetCenters Output vector of the Voroni facets center points."},
    {"initDelaunay", (PyCFunction)pyopencv_cv_Subdiv2D_initDelaunay, METH_VARARGS | METH_KEYWORDS, "initDelaunay(rect) -> None\n.   @brief Creates a new empty Delaunay subdivision\n.   \n.   @param rect Rectangle that includes all of the 2D points that are to be added to the subdivision."},
    {"insert", (PyCFunction)pyopencv_cv_Subdiv2D_insert, METH_VARARGS | METH_KEYWORDS, "insert(pt) -> retval\n.   @brief Insert a single point into a Delaunay triangulation.\n.   \n.   @param pt Point to insert.\n.   \n.   The function inserts a single point into a subdivision and modifies the subdivision topology\n.   appropriately. If a point with the same coordinates exists already, no new point is added.\n.   @returns the ID of the point.\n.   \n.   @note If the point is outside of the triangulation specified rect a runtime error is raised.\n\n\n\ninsert(ptvec) -> None\n.   @brief Insert multiple points into a Delaunay triangulation.\n.   \n.   @param ptvec Points to insert.\n.   \n.   The function inserts a vector of points into a subdivision and modifies the subdivision topology\n.   appropriately."},
    {"locate", (PyCFunction)pyopencv_cv_Subdiv2D_locate, METH_VARARGS | METH_KEYWORDS, "locate(pt) -> retval, edge, vertex\n.   @brief Returns the location of a point within a Delaunay triangulation.\n.   \n.   @param pt Point to locate.\n.   @param edge Output edge that the point belongs to or is located to the right of it.\n.   @param vertex Optional output vertex the input point coincides with.\n.   \n.   The function locates the input point within the subdivision and gives one of the triangle edges\n.   or vertices.\n.   \n.   @returns an integer which specify one of the following five cases for point location:\n.   -  The point falls into some facet. The function returns #PTLOC_INSIDE and edge will contain one of\n.   edges of the facet.\n.   -  The point falls onto the edge. The function returns #PTLOC_ON_EDGE and edge will contain this edge.\n.   -  The point coincides with one of the subdivision vertices. The function returns #PTLOC_VERTEX and\n.   vertex will contain a pointer to the vertex.\n.   -  The point is outside the subdivision reference rectangle. The function returns #PTLOC_OUTSIDE_RECT\n.   and no pointers are filled.\n.   -  One of input arguments is invalid. A runtime error is raised or, if silent or \"parent\" error\n.   processing mode is selected, #PTLOC_ERROR is returned."},
    {"nextEdge", (PyCFunction)pyopencv_cv_Subdiv2D_nextEdge, METH_VARARGS | METH_KEYWORDS, "nextEdge(edge) -> retval\n.   @brief Returns next edge around the edge origin.\n.   \n.   @param edge Subdivision edge ID.\n.   \n.   @returns an integer which is next edge ID around the edge origin: eOnext on the\n.   picture above if e is the input edge)."},
    {"rotateEdge", (PyCFunction)pyopencv_cv_Subdiv2D_rotateEdge, METH_VARARGS | METH_KEYWORDS, "rotateEdge(edge, rotate) -> retval\n.   @brief Returns another edge of the same quad-edge.\n.   \n.   @param edge Subdivision edge ID.\n.   @param rotate Parameter specifying which of the edges of the same quad-edge as the input\n.   one to return. The following values are possible:\n.   -   0 - the input edge ( e on the picture below if e is the input edge)\n.   -   1 - the rotated edge ( eRot )\n.   -   2 - the reversed edge (reversed e (in green))\n.   -   3 - the reversed rotated edge (reversed eRot (in green))\n.   \n.   @returns one of the edges ID of the same quad-edge as the input edge."},
    {"symEdge", (PyCFunction)pyopencv_cv_Subdiv2D_symEdge, METH_VARARGS | METH_KEYWORDS, "symEdge(edge) -> retval\n."},

    {NULL,          NULL}
};

static void pyopencv_Subdiv2D_specials(void)
{
    pyopencv_Subdiv2D_Type.tp_base = NULL;
    pyopencv_Subdiv2D_Type.tp_dealloc = pyopencv_Subdiv2D_dealloc;
    pyopencv_Subdiv2D_Type.tp_repr = pyopencv_Subdiv2D_repr;
    pyopencv_Subdiv2D_Type.tp_getset = pyopencv_Subdiv2D_getseters;
    pyopencv_Subdiv2D_Type.tp_init = (initproc)pyopencv_cv_Subdiv2D_Subdiv2D;
    pyopencv_Subdiv2D_Type.tp_methods = pyopencv_Subdiv2D_methods;
}

static PyObject* pyopencv_LineSegmentDetector_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<LineSegmentDetector %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_LineSegmentDetector_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_LineSegmentDetector_compareSegments(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::LineSegmentDetector* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_LineSegmentDetector_Type))
        _self_ = dynamic_cast<cv::LineSegmentDetector*>(((pyopencv_LineSegmentDetector_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'LineSegmentDetector' or its derivative)");
    {
    PyObject* pyobj_size = NULL;
    Size size;
    PyObject* pyobj_lines1 = NULL;
    Mat lines1;
    PyObject* pyobj_lines2 = NULL;
    Mat lines2;
    PyObject* pyobj__image = NULL;
    Mat _image;
    int retval;

    const char* keywords[] = { "size", "lines1", "lines2", "_image", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOO|O:LineSegmentDetector.compareSegments", (char**)keywords, &pyobj_size, &pyobj_lines1, &pyobj_lines2, &pyobj__image) &&
        pyopencv_to(pyobj_size, size, ArgInfo("size", 0)) &&
        pyopencv_to(pyobj_lines1, lines1, ArgInfo("lines1", 0)) &&
        pyopencv_to(pyobj_lines2, lines2, ArgInfo("lines2", 0)) &&
        pyopencv_to(pyobj__image, _image, ArgInfo("_image", 1)) )
    {
        ERRWRAP2(retval = _self_->compareSegments(size, lines1, lines2, _image));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(_image));
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_size = NULL;
    Size size;
    PyObject* pyobj_lines1 = NULL;
    UMat lines1;
    PyObject* pyobj_lines2 = NULL;
    UMat lines2;
    PyObject* pyobj__image = NULL;
    UMat _image;
    int retval;

    const char* keywords[] = { "size", "lines1", "lines2", "_image", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOO|O:LineSegmentDetector.compareSegments", (char**)keywords, &pyobj_size, &pyobj_lines1, &pyobj_lines2, &pyobj__image) &&
        pyopencv_to(pyobj_size, size, ArgInfo("size", 0)) &&
        pyopencv_to(pyobj_lines1, lines1, ArgInfo("lines1", 0)) &&
        pyopencv_to(pyobj_lines2, lines2, ArgInfo("lines2", 0)) &&
        pyopencv_to(pyobj__image, _image, ArgInfo("_image", 1)) )
    {
        ERRWRAP2(retval = _self_->compareSegments(size, lines1, lines2, _image));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(_image));
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_LineSegmentDetector_detect(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::LineSegmentDetector* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_LineSegmentDetector_Type))
        _self_ = dynamic_cast<cv::LineSegmentDetector*>(((pyopencv_LineSegmentDetector_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'LineSegmentDetector' or its derivative)");
    {
    PyObject* pyobj__image = NULL;
    Mat _image;
    PyObject* pyobj__lines = NULL;
    Mat _lines;
    PyObject* pyobj_width = NULL;
    Mat width;
    PyObject* pyobj_prec = NULL;
    Mat prec;
    PyObject* pyobj_nfa = NULL;
    Mat nfa;

    const char* keywords[] = { "_image", "_lines", "width", "prec", "nfa", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|OOOO:LineSegmentDetector.detect", (char**)keywords, &pyobj__image, &pyobj__lines, &pyobj_width, &pyobj_prec, &pyobj_nfa) &&
        pyopencv_to(pyobj__image, _image, ArgInfo("_image", 0)) &&
        pyopencv_to(pyobj__lines, _lines, ArgInfo("_lines", 1)) &&
        pyopencv_to(pyobj_width, width, ArgInfo("width", 1)) &&
        pyopencv_to(pyobj_prec, prec, ArgInfo("prec", 1)) &&
        pyopencv_to(pyobj_nfa, nfa, ArgInfo("nfa", 1)) )
    {
        ERRWRAP2(_self_->detect(_image, _lines, width, prec, nfa));
        return Py_BuildValue("(NNNN)", pyopencv_from(_lines), pyopencv_from(width), pyopencv_from(prec), pyopencv_from(nfa));
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj__image = NULL;
    UMat _image;
    PyObject* pyobj__lines = NULL;
    UMat _lines;
    PyObject* pyobj_width = NULL;
    UMat width;
    PyObject* pyobj_prec = NULL;
    UMat prec;
    PyObject* pyobj_nfa = NULL;
    UMat nfa;

    const char* keywords[] = { "_image", "_lines", "width", "prec", "nfa", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|OOOO:LineSegmentDetector.detect", (char**)keywords, &pyobj__image, &pyobj__lines, &pyobj_width, &pyobj_prec, &pyobj_nfa) &&
        pyopencv_to(pyobj__image, _image, ArgInfo("_image", 0)) &&
        pyopencv_to(pyobj__lines, _lines, ArgInfo("_lines", 1)) &&
        pyopencv_to(pyobj_width, width, ArgInfo("width", 1)) &&
        pyopencv_to(pyobj_prec, prec, ArgInfo("prec", 1)) &&
        pyopencv_to(pyobj_nfa, nfa, ArgInfo("nfa", 1)) )
    {
        ERRWRAP2(_self_->detect(_image, _lines, width, prec, nfa));
        return Py_BuildValue("(NNNN)", pyopencv_from(_lines), pyopencv_from(width), pyopencv_from(prec), pyopencv_from(nfa));
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_LineSegmentDetector_drawSegments(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::LineSegmentDetector* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_LineSegmentDetector_Type))
        _self_ = dynamic_cast<cv::LineSegmentDetector*>(((pyopencv_LineSegmentDetector_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'LineSegmentDetector' or its derivative)");
    {
    PyObject* pyobj__image = NULL;
    Mat _image;
    PyObject* pyobj_lines = NULL;
    Mat lines;

    const char* keywords[] = { "_image", "lines", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:LineSegmentDetector.drawSegments", (char**)keywords, &pyobj__image, &pyobj_lines) &&
        pyopencv_to(pyobj__image, _image, ArgInfo("_image", 1)) &&
        pyopencv_to(pyobj_lines, lines, ArgInfo("lines", 0)) )
    {
        ERRWRAP2(_self_->drawSegments(_image, lines));
        return pyopencv_from(_image);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj__image = NULL;
    UMat _image;
    PyObject* pyobj_lines = NULL;
    UMat lines;

    const char* keywords[] = { "_image", "lines", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:LineSegmentDetector.drawSegments", (char**)keywords, &pyobj__image, &pyobj_lines) &&
        pyopencv_to(pyobj__image, _image, ArgInfo("_image", 1)) &&
        pyopencv_to(pyobj_lines, lines, ArgInfo("lines", 0)) )
    {
        ERRWRAP2(_self_->drawSegments(_image, lines));
        return pyopencv_from(_image);
    }
    }

    return NULL;
}



static PyMethodDef pyopencv_LineSegmentDetector_methods[] =
{
    {"compareSegments", (PyCFunction)pyopencv_cv_LineSegmentDetector_compareSegments, METH_VARARGS | METH_KEYWORDS, "compareSegments(size, lines1, lines2[, _image]) -> retval, _image\n.   @brief Draws two groups of lines in blue and red, counting the non overlapping (mismatching) pixels.\n.   \n.   @param size The size of the image, where lines1 and lines2 were found.\n.   @param lines1 The first group of lines that needs to be drawn. It is visualized in blue color.\n.   @param lines2 The second group of lines. They visualized in red color.\n.   @param _image Optional image, where the lines will be drawn. The image should be color(3-channel)\n.   in order for lines1 and lines2 to be drawn in the above mentioned colors."},
    {"detect", (PyCFunction)pyopencv_cv_LineSegmentDetector_detect, METH_VARARGS | METH_KEYWORDS, "detect(_image[, _lines[, width[, prec[, nfa]]]]) -> _lines, width, prec, nfa\n.   @brief Finds lines in the input image.\n.   \n.   This is the output of the default parameters of the algorithm on the above shown image.\n.   \n.   ![image](pics/building_lsd.png)\n.   \n.   @param _image A grayscale (CV_8UC1) input image. If only a roi needs to be selected, use:\n.   `lsd_ptr-\\>detect(image(roi), lines, ...); lines += Scalar(roi.x, roi.y, roi.x, roi.y);`\n.   @param _lines A vector of Vec4i or Vec4f elements specifying the beginning and ending point of a line. Where\n.   Vec4i/Vec4f is (x1, y1, x2, y2), point 1 is the start, point 2 - end. Returned lines are strictly\n.   oriented depending on the gradient.\n.   @param width Vector of widths of the regions, where the lines are found. E.g. Width of line.\n.   @param prec Vector of precisions with which the lines are found.\n.   @param nfa Vector containing number of false alarms in the line region, with precision of 10%. The\n.   bigger the value, logarithmically better the detection.\n.   - -1 corresponds to 10 mean false alarms\n.   - 0 corresponds to 1 mean false alarm\n.   - 1 corresponds to 0.1 mean false alarms\n.   This vector will be calculated only when the objects type is #LSD_REFINE_ADV."},
    {"drawSegments", (PyCFunction)pyopencv_cv_LineSegmentDetector_drawSegments, METH_VARARGS | METH_KEYWORDS, "drawSegments(_image, lines) -> _image\n.   @brief Draws the line segments on a given image.\n.   @param _image The image, where the lines will be drawn. Should be bigger or equal to the image,\n.   where the lines were found.\n.   @param lines A vector of the lines that needed to be drawn."},

    {NULL,          NULL}
};

static void pyopencv_LineSegmentDetector_specials(void)
{
    pyopencv_LineSegmentDetector_Type.tp_base = &pyopencv_Algorithm_Type;
    pyopencv_LineSegmentDetector_Type.tp_dealloc = pyopencv_LineSegmentDetector_dealloc;
    pyopencv_LineSegmentDetector_Type.tp_repr = pyopencv_LineSegmentDetector_repr;
    pyopencv_LineSegmentDetector_Type.tp_getset = pyopencv_LineSegmentDetector_getseters;
    pyopencv_LineSegmentDetector_Type.tp_init = (initproc)0;
    pyopencv_LineSegmentDetector_Type.tp_methods = pyopencv_LineSegmentDetector_methods;
}

static PyObject* pyopencv_ml_ParamGrid_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<ml_ParamGrid %p>", self);
    return PyString_FromString(str);
}


static PyObject* pyopencv_ml_ParamGrid_get_logStep(pyopencv_ml_ParamGrid_t* p, void *closure)
{
    return pyopencv_from(p->v->logStep);
}

static int pyopencv_ml_ParamGrid_set_logStep(pyopencv_ml_ParamGrid_t* p, PyObject *value, void *closure)
{
    if (value == NULL)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the logStep attribute");
        return -1;
    }
    return pyopencv_to(value, p->v->logStep) ? 0 : -1;
}

static PyObject* pyopencv_ml_ParamGrid_get_maxVal(pyopencv_ml_ParamGrid_t* p, void *closure)
{
    return pyopencv_from(p->v->maxVal);
}

static int pyopencv_ml_ParamGrid_set_maxVal(pyopencv_ml_ParamGrid_t* p, PyObject *value, void *closure)
{
    if (value == NULL)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the maxVal attribute");
        return -1;
    }
    return pyopencv_to(value, p->v->maxVal) ? 0 : -1;
}

static PyObject* pyopencv_ml_ParamGrid_get_minVal(pyopencv_ml_ParamGrid_t* p, void *closure)
{
    return pyopencv_from(p->v->minVal);
}

static int pyopencv_ml_ParamGrid_set_minVal(pyopencv_ml_ParamGrid_t* p, PyObject *value, void *closure)
{
    if (value == NULL)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the minVal attribute");
        return -1;
    }
    return pyopencv_to(value, p->v->minVal) ? 0 : -1;
}


static PyGetSetDef pyopencv_ml_ParamGrid_getseters[] =
{
    {(char*)"logStep", (getter)pyopencv_ml_ParamGrid_get_logStep, (setter)pyopencv_ml_ParamGrid_set_logStep, (char*)"logStep", NULL},
    {(char*)"maxVal", (getter)pyopencv_ml_ParamGrid_get_maxVal, (setter)pyopencv_ml_ParamGrid_set_maxVal, (char*)"maxVal", NULL},
    {(char*)"minVal", (getter)pyopencv_ml_ParamGrid_get_minVal, (setter)pyopencv_ml_ParamGrid_set_minVal, (char*)"minVal", NULL},
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_ml_ml_ParamGrid_create_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    double minVal=0.;
    double maxVal=0.;
    double logstep=1.;
    Ptr<ParamGrid> retval;

    const char* keywords[] = { "minVal", "maxVal", "logstep", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "|ddd:ml_ParamGrid.create", (char**)keywords, &minVal, &maxVal, &logstep) )
    {
        ERRWRAP2(retval = cv::ml::ParamGrid::create(minVal, maxVal, logstep));
        return pyopencv_from(retval);
    }

    return NULL;
}



static PyMethodDef pyopencv_ml_ParamGrid_methods[] =
{
    {"create", (PyCFunction)pyopencv_cv_ml_ml_ParamGrid_create_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "create([, minVal[, maxVal[, logstep]]]) -> retval\n.   @brief Creates a ParamGrid Ptr that can be given to the %SVM::trainAuto method\n.   \n.   @param minVal minimum value of the parameter grid\n.   @param maxVal maximum value of the parameter grid\n.   @param logstep Logarithmic step for iterating the statmodel parameter"},

    {NULL,          NULL}
};

static void pyopencv_ml_ParamGrid_specials(void)
{
    pyopencv_ml_ParamGrid_Type.tp_base = NULL;
    pyopencv_ml_ParamGrid_Type.tp_dealloc = pyopencv_ml_ParamGrid_dealloc;
    pyopencv_ml_ParamGrid_Type.tp_repr = pyopencv_ml_ParamGrid_repr;
    pyopencv_ml_ParamGrid_Type.tp_getset = pyopencv_ml_ParamGrid_getseters;
    pyopencv_ml_ParamGrid_Type.tp_init = (initproc)0;
    pyopencv_ml_ParamGrid_Type.tp_methods = pyopencv_ml_ParamGrid_methods;
}

static PyObject* pyopencv_ml_TrainData_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<ml_TrainData %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_ml_TrainData_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_ml_ml_TrainData_create_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    {
    PyObject* pyobj_samples = NULL;
    Mat samples;
    int layout=0;
    PyObject* pyobj_responses = NULL;
    Mat responses;
    PyObject* pyobj_varIdx = NULL;
    Mat varIdx;
    PyObject* pyobj_sampleIdx = NULL;
    Mat sampleIdx;
    PyObject* pyobj_sampleWeights = NULL;
    Mat sampleWeights;
    PyObject* pyobj_varType = NULL;
    Mat varType;
    Ptr<TrainData> retval;

    const char* keywords[] = { "samples", "layout", "responses", "varIdx", "sampleIdx", "sampleWeights", "varType", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OiO|OOOO:ml_TrainData.create", (char**)keywords, &pyobj_samples, &layout, &pyobj_responses, &pyobj_varIdx, &pyobj_sampleIdx, &pyobj_sampleWeights, &pyobj_varType) &&
        pyopencv_to(pyobj_samples, samples, ArgInfo("samples", 0)) &&
        pyopencv_to(pyobj_responses, responses, ArgInfo("responses", 0)) &&
        pyopencv_to(pyobj_varIdx, varIdx, ArgInfo("varIdx", 0)) &&
        pyopencv_to(pyobj_sampleIdx, sampleIdx, ArgInfo("sampleIdx", 0)) &&
        pyopencv_to(pyobj_sampleWeights, sampleWeights, ArgInfo("sampleWeights", 0)) &&
        pyopencv_to(pyobj_varType, varType, ArgInfo("varType", 0)) )
    {
        ERRWRAP2(retval = cv::ml::TrainData::create(samples, layout, responses, varIdx, sampleIdx, sampleWeights, varType));
        return pyopencv_from(retval);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_samples = NULL;
    UMat samples;
    int layout=0;
    PyObject* pyobj_responses = NULL;
    UMat responses;
    PyObject* pyobj_varIdx = NULL;
    UMat varIdx;
    PyObject* pyobj_sampleIdx = NULL;
    UMat sampleIdx;
    PyObject* pyobj_sampleWeights = NULL;
    UMat sampleWeights;
    PyObject* pyobj_varType = NULL;
    UMat varType;
    Ptr<TrainData> retval;

    const char* keywords[] = { "samples", "layout", "responses", "varIdx", "sampleIdx", "sampleWeights", "varType", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OiO|OOOO:ml_TrainData.create", (char**)keywords, &pyobj_samples, &layout, &pyobj_responses, &pyobj_varIdx, &pyobj_sampleIdx, &pyobj_sampleWeights, &pyobj_varType) &&
        pyopencv_to(pyobj_samples, samples, ArgInfo("samples", 0)) &&
        pyopencv_to(pyobj_responses, responses, ArgInfo("responses", 0)) &&
        pyopencv_to(pyobj_varIdx, varIdx, ArgInfo("varIdx", 0)) &&
        pyopencv_to(pyobj_sampleIdx, sampleIdx, ArgInfo("sampleIdx", 0)) &&
        pyopencv_to(pyobj_sampleWeights, sampleWeights, ArgInfo("sampleWeights", 0)) &&
        pyopencv_to(pyobj_varType, varType, ArgInfo("varType", 0)) )
    {
        ERRWRAP2(retval = cv::ml::TrainData::create(samples, layout, responses, varIdx, sampleIdx, sampleWeights, varType));
        return pyopencv_from(retval);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getCatCount(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    int vi=0;
    int retval;

    const char* keywords[] = { "vi", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:ml_TrainData.getCatCount", (char**)keywords, &vi) )
    {
        ERRWRAP2(retval = _self_->getCatCount(vi));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getCatMap(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getCatMap());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getCatOfs(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getCatOfs());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getClassLabels(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getClassLabels());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getDefaultSubstValues(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDefaultSubstValues());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getLayout(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getLayout());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getMissing(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMissing());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getNAllVars(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getNAllVars());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getNSamples(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getNSamples());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getNTestSamples(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getNTestSamples());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getNTrainSamples(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getNTrainSamples());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getNVars(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getNVars());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getNames(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    PyObject* pyobj_names = NULL;
    vector_String names;

    const char* keywords[] = { "names", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:ml_TrainData.getNames", (char**)keywords, &pyobj_names) &&
        pyopencv_to(pyobj_names, names, ArgInfo("names", 0)) )
    {
        ERRWRAP2(_self_->getNames(names));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getNormCatResponses(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getNormCatResponses());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getResponseType(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getResponseType());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getResponses(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getResponses());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getSample(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    {
    PyObject* pyobj_varIdx = NULL;
    Mat varIdx;
    int sidx=0;
    float buf=0.f;

    const char* keywords[] = { "varIdx", "sidx", "buf", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "Oif:ml_TrainData.getSample", (char**)keywords, &pyobj_varIdx, &sidx, &buf) &&
        pyopencv_to(pyobj_varIdx, varIdx, ArgInfo("varIdx", 0)) )
    {
        ERRWRAP2(_self_->getSample(varIdx, sidx, &buf));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_varIdx = NULL;
    UMat varIdx;
    int sidx=0;
    float buf=0.f;

    const char* keywords[] = { "varIdx", "sidx", "buf", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "Oif:ml_TrainData.getSample", (char**)keywords, &pyobj_varIdx, &sidx, &buf) &&
        pyopencv_to(pyobj_varIdx, varIdx, ArgInfo("varIdx", 0)) )
    {
        ERRWRAP2(_self_->getSample(varIdx, sidx, &buf));
        Py_RETURN_NONE;
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getSampleWeights(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getSampleWeights());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getSamples(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getSamples());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getSubVector_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    {
    PyObject* pyobj_vec = NULL;
    Mat vec;
    PyObject* pyobj_idx = NULL;
    Mat idx;
    Mat retval;

    const char* keywords[] = { "vec", "idx", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:ml_TrainData.getSubVector", (char**)keywords, &pyobj_vec, &pyobj_idx) &&
        pyopencv_to(pyobj_vec, vec, ArgInfo("vec", 0)) &&
        pyopencv_to(pyobj_idx, idx, ArgInfo("idx", 0)) )
    {
        ERRWRAP2(retval = cv::ml::TrainData::getSubVector(vec, idx));
        return pyopencv_from(retval);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_vec = NULL;
    Mat vec;
    PyObject* pyobj_idx = NULL;
    Mat idx;
    Mat retval;

    const char* keywords[] = { "vec", "idx", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:ml_TrainData.getSubVector", (char**)keywords, &pyobj_vec, &pyobj_idx) &&
        pyopencv_to(pyobj_vec, vec, ArgInfo("vec", 0)) &&
        pyopencv_to(pyobj_idx, idx, ArgInfo("idx", 0)) )
    {
        ERRWRAP2(retval = cv::ml::TrainData::getSubVector(vec, idx));
        return pyopencv_from(retval);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getTestNormCatResponses(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTestNormCatResponses());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getTestResponses(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTestResponses());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getTestSampleIdx(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTestSampleIdx());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getTestSampleWeights(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTestSampleWeights());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getTestSamples(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTestSamples());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getTrainNormCatResponses(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTrainNormCatResponses());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getTrainResponses(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTrainResponses());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getTrainSampleIdx(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTrainSampleIdx());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getTrainSampleWeights(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTrainSampleWeights());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getTrainSamples(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    int layout=ROW_SAMPLE;
    bool compressSamples=true;
    bool compressVars=true;
    Mat retval;

    const char* keywords[] = { "layout", "compressSamples", "compressVars", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "|ibb:ml_TrainData.getTrainSamples", (char**)keywords, &layout, &compressSamples, &compressVars) )
    {
        ERRWRAP2(retval = _self_->getTrainSamples(layout, compressSamples, compressVars));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getValues(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    {
    int vi=0;
    PyObject* pyobj_sidx = NULL;
    Mat sidx;
    float values=0.f;

    const char* keywords[] = { "vi", "sidx", "values", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "iOf:ml_TrainData.getValues", (char**)keywords, &vi, &pyobj_sidx, &values) &&
        pyopencv_to(pyobj_sidx, sidx, ArgInfo("sidx", 0)) )
    {
        ERRWRAP2(_self_->getValues(vi, sidx, &values));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    int vi=0;
    PyObject* pyobj_sidx = NULL;
    UMat sidx;
    float values=0.f;

    const char* keywords[] = { "vi", "sidx", "values", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "iOf:ml_TrainData.getValues", (char**)keywords, &vi, &pyobj_sidx, &values) &&
        pyopencv_to(pyobj_sidx, sidx, ArgInfo("sidx", 0)) )
    {
        ERRWRAP2(_self_->getValues(vi, sidx, &values));
        Py_RETURN_NONE;
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getVarIdx(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getVarIdx());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getVarSymbolFlags(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getVarSymbolFlags());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_getVarType(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getVarType());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_setTrainTestSplit(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    int count=0;
    bool shuffle=true;

    const char* keywords[] = { "count", "shuffle", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i|b:ml_TrainData.setTrainTestSplit", (char**)keywords, &count, &shuffle) )
    {
        ERRWRAP2(_self_->setTrainTestSplit(count, shuffle));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_setTrainTestSplitRatio(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");
    double ratio=0;
    bool shuffle=true;

    const char* keywords[] = { "ratio", "shuffle", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d|b:ml_TrainData.setTrainTestSplitRatio", (char**)keywords, &ratio, &shuffle) )
    {
        ERRWRAP2(_self_->setTrainTestSplitRatio(ratio, shuffle));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_TrainData_shuffleTrainTest(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::TrainData* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_TrainData_Type))
        _self_ = ((pyopencv_ml_TrainData_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_TrainData' or its derivative)");

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->shuffleTrainTest());
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_ml_TrainData_methods[] =
{
    {"create", (PyCFunction)pyopencv_cv_ml_ml_TrainData_create_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "create(samples, layout, responses[, varIdx[, sampleIdx[, sampleWeights[, varType]]]]) -> retval\n.   @brief Creates training data from in-memory arrays.\n.   \n.   @param samples matrix of samples. It should have CV_32F type.\n.   @param layout see ml::SampleTypes.\n.   @param responses matrix of responses. If the responses are scalar, they should be stored as a\n.   single row or as a single column. The matrix should have type CV_32F or CV_32S (in the\n.   former case the responses are considered as ordered by default; in the latter case - as\n.   categorical)\n.   @param varIdx vector specifying which variables to use for training. It can be an integer vector\n.   (CV_32S) containing 0-based variable indices or byte vector (CV_8U) containing a mask of\n.   active variables.\n.   @param sampleIdx vector specifying which samples to use for training. It can be an integer\n.   vector (CV_32S) containing 0-based sample indices or byte vector (CV_8U) containing a mask\n.   of training samples.\n.   @param sampleWeights optional vector with weights for each sample. It should have CV_32F type.\n.   @param varType optional vector of type CV_8U and size `<number_of_variables_in_samples> +\n.   <number_of_variables_in_responses>`, containing types of each input and output variable. See\n.   ml::VariableTypes."},
    {"getCatCount", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getCatCount, METH_VARARGS | METH_KEYWORDS, "getCatCount(vi) -> retval\n."},
    {"getCatMap", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getCatMap, METH_VARARGS | METH_KEYWORDS, "getCatMap() -> retval\n."},
    {"getCatOfs", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getCatOfs, METH_VARARGS | METH_KEYWORDS, "getCatOfs() -> retval\n."},
    {"getClassLabels", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getClassLabels, METH_VARARGS | METH_KEYWORDS, "getClassLabels() -> retval\n.   @brief Returns the vector of class labels\n.   \n.   The function returns vector of unique labels occurred in the responses."},
    {"getDefaultSubstValues", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getDefaultSubstValues, METH_VARARGS | METH_KEYWORDS, "getDefaultSubstValues() -> retval\n."},
    {"getLayout", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getLayout, METH_VARARGS | METH_KEYWORDS, "getLayout() -> retval\n."},
    {"getMissing", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getMissing, METH_VARARGS | METH_KEYWORDS, "getMissing() -> retval\n."},
    {"getNAllVars", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getNAllVars, METH_VARARGS | METH_KEYWORDS, "getNAllVars() -> retval\n."},
    {"getNSamples", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getNSamples, METH_VARARGS | METH_KEYWORDS, "getNSamples() -> retval\n."},
    {"getNTestSamples", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getNTestSamples, METH_VARARGS | METH_KEYWORDS, "getNTestSamples() -> retval\n."},
    {"getNTrainSamples", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getNTrainSamples, METH_VARARGS | METH_KEYWORDS, "getNTrainSamples() -> retval\n."},
    {"getNVars", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getNVars, METH_VARARGS | METH_KEYWORDS, "getNVars() -> retval\n."},
    {"getNames", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getNames, METH_VARARGS | METH_KEYWORDS, "getNames(names) -> None\n.   @brief Returns vector of symbolic names captured in loadFromCSV()"},
    {"getNormCatResponses", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getNormCatResponses, METH_VARARGS | METH_KEYWORDS, "getNormCatResponses() -> retval\n."},
    {"getResponseType", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getResponseType, METH_VARARGS | METH_KEYWORDS, "getResponseType() -> retval\n."},
    {"getResponses", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getResponses, METH_VARARGS | METH_KEYWORDS, "getResponses() -> retval\n."},
    {"getSample", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getSample, METH_VARARGS | METH_KEYWORDS, "getSample(varIdx, sidx, buf) -> None\n."},
    {"getSampleWeights", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getSampleWeights, METH_VARARGS | METH_KEYWORDS, "getSampleWeights() -> retval\n."},
    {"getSamples", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getSamples, METH_VARARGS | METH_KEYWORDS, "getSamples() -> retval\n."},
    {"getSubVector", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getSubVector_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "getSubVector(vec, idx) -> retval\n."},
    {"getTestNormCatResponses", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getTestNormCatResponses, METH_VARARGS | METH_KEYWORDS, "getTestNormCatResponses() -> retval\n."},
    {"getTestResponses", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getTestResponses, METH_VARARGS | METH_KEYWORDS, "getTestResponses() -> retval\n."},
    {"getTestSampleIdx", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getTestSampleIdx, METH_VARARGS | METH_KEYWORDS, "getTestSampleIdx() -> retval\n."},
    {"getTestSampleWeights", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getTestSampleWeights, METH_VARARGS | METH_KEYWORDS, "getTestSampleWeights() -> retval\n."},
    {"getTestSamples", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getTestSamples, METH_VARARGS | METH_KEYWORDS, "getTestSamples() -> retval\n.   @brief Returns matrix of test samples"},
    {"getTrainNormCatResponses", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getTrainNormCatResponses, METH_VARARGS | METH_KEYWORDS, "getTrainNormCatResponses() -> retval\n.   @brief Returns the vector of normalized categorical responses\n.   \n.   The function returns vector of responses. Each response is integer from `0` to `<number of\n.   classes>-1`. The actual label value can be retrieved then from the class label vector, see\n.   TrainData::getClassLabels."},
    {"getTrainResponses", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getTrainResponses, METH_VARARGS | METH_KEYWORDS, "getTrainResponses() -> retval\n.   @brief Returns the vector of responses\n.   \n.   The function returns ordered or the original categorical responses. Usually it's used in\n.   regression algorithms."},
    {"getTrainSampleIdx", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getTrainSampleIdx, METH_VARARGS | METH_KEYWORDS, "getTrainSampleIdx() -> retval\n."},
    {"getTrainSampleWeights", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getTrainSampleWeights, METH_VARARGS | METH_KEYWORDS, "getTrainSampleWeights() -> retval\n."},
    {"getTrainSamples", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getTrainSamples, METH_VARARGS | METH_KEYWORDS, "getTrainSamples([, layout[, compressSamples[, compressVars]]]) -> retval\n.   @brief Returns matrix of train samples\n.   \n.   @param layout The requested layout. If it's different from the initial one, the matrix is\n.   transposed. See ml::SampleTypes.\n.   @param compressSamples if true, the function returns only the training samples (specified by\n.   sampleIdx)\n.   @param compressVars if true, the function returns the shorter training samples, containing only\n.   the active variables.\n.   \n.   In current implementation the function tries to avoid physical data copying and returns the\n.   matrix stored inside TrainData (unless the transposition or compression is needed)."},
    {"getValues", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getValues, METH_VARARGS | METH_KEYWORDS, "getValues(vi, sidx, values) -> None\n."},
    {"getVarIdx", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getVarIdx, METH_VARARGS | METH_KEYWORDS, "getVarIdx() -> retval\n."},
    {"getVarSymbolFlags", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getVarSymbolFlags, METH_VARARGS | METH_KEYWORDS, "getVarSymbolFlags() -> retval\n."},
    {"getVarType", (PyCFunction)pyopencv_cv_ml_ml_TrainData_getVarType, METH_VARARGS | METH_KEYWORDS, "getVarType() -> retval\n."},
    {"setTrainTestSplit", (PyCFunction)pyopencv_cv_ml_ml_TrainData_setTrainTestSplit, METH_VARARGS | METH_KEYWORDS, "setTrainTestSplit(count[, shuffle]) -> None\n.   @brief Splits the training data into the training and test parts\n.   @sa TrainData::setTrainTestSplitRatio"},
    {"setTrainTestSplitRatio", (PyCFunction)pyopencv_cv_ml_ml_TrainData_setTrainTestSplitRatio, METH_VARARGS | METH_KEYWORDS, "setTrainTestSplitRatio(ratio[, shuffle]) -> None\n.   @brief Splits the training data into the training and test parts\n.   \n.   The function selects a subset of specified relative size and then returns it as the training\n.   set. If the function is not called, all the data is used for training. Please, note that for\n.   each of TrainData::getTrain\\* there is corresponding TrainData::getTest\\*, so that the test\n.   subset can be retrieved and processed as well.\n.   @sa TrainData::setTrainTestSplit"},
    {"shuffleTrainTest", (PyCFunction)pyopencv_cv_ml_ml_TrainData_shuffleTrainTest, METH_VARARGS | METH_KEYWORDS, "shuffleTrainTest() -> None\n."},

    {NULL,          NULL}
};

static void pyopencv_ml_TrainData_specials(void)
{
    pyopencv_ml_TrainData_Type.tp_base = NULL;
    pyopencv_ml_TrainData_Type.tp_dealloc = pyopencv_ml_TrainData_dealloc;
    pyopencv_ml_TrainData_Type.tp_repr = pyopencv_ml_TrainData_repr;
    pyopencv_ml_TrainData_Type.tp_getset = pyopencv_ml_TrainData_getseters;
    pyopencv_ml_TrainData_Type.tp_init = (initproc)0;
    pyopencv_ml_TrainData_Type.tp_methods = pyopencv_ml_TrainData_methods;
}

static PyObject* pyopencv_ml_StatModel_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<ml_StatModel %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_ml_StatModel_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_ml_ml_StatModel_calcError(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::StatModel* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_StatModel_Type))
        _self_ = dynamic_cast<cv::ml::StatModel*>(((pyopencv_ml_StatModel_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_StatModel' or its derivative)");
    {
    PyObject* pyobj_data = NULL;
    Ptr<TrainData> data;
    bool test=0;
    PyObject* pyobj_resp = NULL;
    Mat resp;
    float retval;

    const char* keywords[] = { "data", "test", "resp", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "Ob|O:ml_StatModel.calcError", (char**)keywords, &pyobj_data, &test, &pyobj_resp) &&
        pyopencv_to(pyobj_data, data, ArgInfo("data", 0)) &&
        pyopencv_to(pyobj_resp, resp, ArgInfo("resp", 1)) )
    {
        ERRWRAP2(retval = _self_->calcError(data, test, resp));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(resp));
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_data = NULL;
    Ptr<TrainData> data;
    bool test=0;
    PyObject* pyobj_resp = NULL;
    UMat resp;
    float retval;

    const char* keywords[] = { "data", "test", "resp", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "Ob|O:ml_StatModel.calcError", (char**)keywords, &pyobj_data, &test, &pyobj_resp) &&
        pyopencv_to(pyobj_data, data, ArgInfo("data", 0)) &&
        pyopencv_to(pyobj_resp, resp, ArgInfo("resp", 1)) )
    {
        ERRWRAP2(retval = _self_->calcError(data, test, resp));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(resp));
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_StatModel_empty(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::StatModel* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_StatModel_Type))
        _self_ = dynamic_cast<cv::ml::StatModel*>(((pyopencv_ml_StatModel_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_StatModel' or its derivative)");
    bool retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->empty());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_StatModel_getVarCount(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::StatModel* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_StatModel_Type))
        _self_ = dynamic_cast<cv::ml::StatModel*>(((pyopencv_ml_StatModel_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_StatModel' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getVarCount());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_StatModel_isClassifier(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::StatModel* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_StatModel_Type))
        _self_ = dynamic_cast<cv::ml::StatModel*>(((pyopencv_ml_StatModel_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_StatModel' or its derivative)");
    bool retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->isClassifier());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_StatModel_isTrained(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::StatModel* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_StatModel_Type))
        _self_ = dynamic_cast<cv::ml::StatModel*>(((pyopencv_ml_StatModel_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_StatModel' or its derivative)");
    bool retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->isTrained());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_StatModel_predict(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::StatModel* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_StatModel_Type))
        _self_ = dynamic_cast<cv::ml::StatModel*>(((pyopencv_ml_StatModel_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_StatModel' or its derivative)");
    {
    PyObject* pyobj_samples = NULL;
    Mat samples;
    PyObject* pyobj_results = NULL;
    Mat results;
    int flags=0;
    float retval;

    const char* keywords[] = { "samples", "results", "flags", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|Oi:ml_StatModel.predict", (char**)keywords, &pyobj_samples, &pyobj_results, &flags) &&
        pyopencv_to(pyobj_samples, samples, ArgInfo("samples", 0)) &&
        pyopencv_to(pyobj_results, results, ArgInfo("results", 1)) )
    {
        ERRWRAP2(retval = _self_->predict(samples, results, flags));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(results));
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_samples = NULL;
    UMat samples;
    PyObject* pyobj_results = NULL;
    UMat results;
    int flags=0;
    float retval;

    const char* keywords[] = { "samples", "results", "flags", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|Oi:ml_StatModel.predict", (char**)keywords, &pyobj_samples, &pyobj_results, &flags) &&
        pyopencv_to(pyobj_samples, samples, ArgInfo("samples", 0)) &&
        pyopencv_to(pyobj_results, results, ArgInfo("results", 1)) )
    {
        ERRWRAP2(retval = _self_->predict(samples, results, flags));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(results));
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_StatModel_train(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::StatModel* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_StatModel_Type))
        _self_ = dynamic_cast<cv::ml::StatModel*>(((pyopencv_ml_StatModel_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_StatModel' or its derivative)");
    {
    PyObject* pyobj_trainData = NULL;
    Ptr<TrainData> trainData;
    int flags=0;
    bool retval;

    const char* keywords[] = { "trainData", "flags", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|i:ml_StatModel.train", (char**)keywords, &pyobj_trainData, &flags) &&
        pyopencv_to(pyobj_trainData, trainData, ArgInfo("trainData", 0)) )
    {
        ERRWRAP2(retval = _self_->train(trainData, flags));
        return pyopencv_from(retval);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_samples = NULL;
    Mat samples;
    int layout=0;
    PyObject* pyobj_responses = NULL;
    Mat responses;
    bool retval;

    const char* keywords[] = { "samples", "layout", "responses", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OiO:ml_StatModel.train", (char**)keywords, &pyobj_samples, &layout, &pyobj_responses) &&
        pyopencv_to(pyobj_samples, samples, ArgInfo("samples", 0)) &&
        pyopencv_to(pyobj_responses, responses, ArgInfo("responses", 0)) )
    {
        ERRWRAP2(retval = _self_->train(samples, layout, responses));
        return pyopencv_from(retval);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_samples = NULL;
    UMat samples;
    int layout=0;
    PyObject* pyobj_responses = NULL;
    UMat responses;
    bool retval;

    const char* keywords[] = { "samples", "layout", "responses", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OiO:ml_StatModel.train", (char**)keywords, &pyobj_samples, &layout, &pyobj_responses) &&
        pyopencv_to(pyobj_samples, samples, ArgInfo("samples", 0)) &&
        pyopencv_to(pyobj_responses, responses, ArgInfo("responses", 0)) )
    {
        ERRWRAP2(retval = _self_->train(samples, layout, responses));
        return pyopencv_from(retval);
    }
    }

    return NULL;
}



static PyMethodDef pyopencv_ml_StatModel_methods[] =
{
    {"calcError", (PyCFunction)pyopencv_cv_ml_ml_StatModel_calcError, METH_VARARGS | METH_KEYWORDS, "calcError(data, test[, resp]) -> retval, resp\n.   @brief Computes error on the training or test dataset\n.   \n.   @param data the training data\n.   @param test if true, the error is computed over the test subset of the data, otherwise it's\n.   computed over the training subset of the data. Please note that if you loaded a completely\n.   different dataset to evaluate already trained classifier, you will probably want not to set\n.   the test subset at all with TrainData::setTrainTestSplitRatio and specify test=false, so\n.   that the error is computed for the whole new set. Yes, this sounds a bit confusing.\n.   @param resp the optional output responses.\n.   \n.   The method uses StatModel::predict to compute the error. For regression models the error is\n.   computed as RMS, for classifiers - as a percent of missclassified samples (0%-100%)."},
    {"empty", (PyCFunction)pyopencv_cv_ml_ml_StatModel_empty, METH_VARARGS | METH_KEYWORDS, "empty() -> retval\n."},
    {"getVarCount", (PyCFunction)pyopencv_cv_ml_ml_StatModel_getVarCount, METH_VARARGS | METH_KEYWORDS, "getVarCount() -> retval\n.   @brief Returns the number of variables in training samples"},
    {"isClassifier", (PyCFunction)pyopencv_cv_ml_ml_StatModel_isClassifier, METH_VARARGS | METH_KEYWORDS, "isClassifier() -> retval\n.   @brief Returns true if the model is classifier"},
    {"isTrained", (PyCFunction)pyopencv_cv_ml_ml_StatModel_isTrained, METH_VARARGS | METH_KEYWORDS, "isTrained() -> retval\n.   @brief Returns true if the model is trained"},
    {"predict", (PyCFunction)pyopencv_cv_ml_ml_StatModel_predict, METH_VARARGS | METH_KEYWORDS, "predict(samples[, results[, flags]]) -> retval, results\n.   @brief Predicts response(s) for the provided sample(s)\n.   \n.   @param samples The input samples, floating-point matrix\n.   @param results The optional output matrix of results.\n.   @param flags The optional flags, model-dependent. See cv::ml::StatModel::Flags."},
    {"train", (PyCFunction)pyopencv_cv_ml_ml_StatModel_train, METH_VARARGS | METH_KEYWORDS, "train(trainData[, flags]) -> retval\n.   @brief Trains the statistical model\n.   \n.   @param trainData training data that can be loaded from file using TrainData::loadFromCSV or\n.   created with TrainData::create.\n.   @param flags optional flags, depending on the model. Some of the models can be updated with the\n.   new training samples, not completely overwritten (such as NormalBayesClassifier or ANN_MLP).\n\n\n\ntrain(samples, layout, responses) -> retval\n.   @brief Trains the statistical model\n.   \n.   @param samples training samples\n.   @param layout See ml::SampleTypes.\n.   @param responses vector of responses associated with the training samples."},

    {NULL,          NULL}
};

static void pyopencv_ml_StatModel_specials(void)
{
    pyopencv_ml_StatModel_Type.tp_base = &pyopencv_Algorithm_Type;
    pyopencv_ml_StatModel_Type.tp_dealloc = pyopencv_ml_StatModel_dealloc;
    pyopencv_ml_StatModel_Type.tp_repr = pyopencv_ml_StatModel_repr;
    pyopencv_ml_StatModel_Type.tp_getset = pyopencv_ml_StatModel_getseters;
    pyopencv_ml_StatModel_Type.tp_init = (initproc)0;
    pyopencv_ml_StatModel_Type.tp_methods = pyopencv_ml_StatModel_methods;
}

static PyObject* pyopencv_ml_NormalBayesClassifier_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<ml_NormalBayesClassifier %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_ml_NormalBayesClassifier_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_ml_ml_NormalBayesClassifier_create_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    Ptr<NormalBayesClassifier> retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = cv::ml::NormalBayesClassifier::create());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_NormalBayesClassifier_load_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    PyObject* pyobj_filepath = NULL;
    String filepath;
    PyObject* pyobj_nodeName = NULL;
    String nodeName;
    Ptr<NormalBayesClassifier> retval;

    const char* keywords[] = { "filepath", "nodeName", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:ml_NormalBayesClassifier.load", (char**)keywords, &pyobj_filepath, &pyobj_nodeName) &&
        pyopencv_to(pyobj_filepath, filepath, ArgInfo("filepath", 0)) &&
        pyopencv_to(pyobj_nodeName, nodeName, ArgInfo("nodeName", 0)) )
    {
        ERRWRAP2(retval = cv::ml::NormalBayesClassifier::load(filepath, nodeName));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_NormalBayesClassifier_predictProb(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::NormalBayesClassifier* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_NormalBayesClassifier_Type))
        _self_ = dynamic_cast<cv::ml::NormalBayesClassifier*>(((pyopencv_ml_NormalBayesClassifier_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_NormalBayesClassifier' or its derivative)");
    {
    PyObject* pyobj_inputs = NULL;
    Mat inputs;
    PyObject* pyobj_outputs = NULL;
    Mat outputs;
    PyObject* pyobj_outputProbs = NULL;
    Mat outputProbs;
    int flags=0;
    float retval;

    const char* keywords[] = { "inputs", "outputs", "outputProbs", "flags", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|OOi:ml_NormalBayesClassifier.predictProb", (char**)keywords, &pyobj_inputs, &pyobj_outputs, &pyobj_outputProbs, &flags) &&
        pyopencv_to(pyobj_inputs, inputs, ArgInfo("inputs", 0)) &&
        pyopencv_to(pyobj_outputs, outputs, ArgInfo("outputs", 1)) &&
        pyopencv_to(pyobj_outputProbs, outputProbs, ArgInfo("outputProbs", 1)) )
    {
        ERRWRAP2(retval = _self_->predictProb(inputs, outputs, outputProbs, flags));
        return Py_BuildValue("(NNN)", pyopencv_from(retval), pyopencv_from(outputs), pyopencv_from(outputProbs));
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_inputs = NULL;
    UMat inputs;
    PyObject* pyobj_outputs = NULL;
    UMat outputs;
    PyObject* pyobj_outputProbs = NULL;
    UMat outputProbs;
    int flags=0;
    float retval;

    const char* keywords[] = { "inputs", "outputs", "outputProbs", "flags", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|OOi:ml_NormalBayesClassifier.predictProb", (char**)keywords, &pyobj_inputs, &pyobj_outputs, &pyobj_outputProbs, &flags) &&
        pyopencv_to(pyobj_inputs, inputs, ArgInfo("inputs", 0)) &&
        pyopencv_to(pyobj_outputs, outputs, ArgInfo("outputs", 1)) &&
        pyopencv_to(pyobj_outputProbs, outputProbs, ArgInfo("outputProbs", 1)) )
    {
        ERRWRAP2(retval = _self_->predictProb(inputs, outputs, outputProbs, flags));
        return Py_BuildValue("(NNN)", pyopencv_from(retval), pyopencv_from(outputs), pyopencv_from(outputProbs));
    }
    }

    return NULL;
}



static PyMethodDef pyopencv_ml_NormalBayesClassifier_methods[] =
{
    {"create", (PyCFunction)pyopencv_cv_ml_ml_NormalBayesClassifier_create_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "create() -> retval\n.   Creates empty model\n.   Use StatModel::train to train the model after creation."},
    {"load", (PyCFunction)pyopencv_cv_ml_ml_NormalBayesClassifier_load_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "load(filepath[, nodeName]) -> retval\n.   @brief Loads and creates a serialized NormalBayesClassifier from a file\n.   *\n.   * Use NormalBayesClassifier::save to serialize and store an NormalBayesClassifier to disk.\n.   * Load the NormalBayesClassifier from this file again, by calling this function with the path to the file.\n.   * Optionally specify the node for the file containing the classifier\n.   *\n.   * @param filepath path to serialized NormalBayesClassifier\n.   * @param nodeName name of node containing the classifier"},
    {"predictProb", (PyCFunction)pyopencv_cv_ml_ml_NormalBayesClassifier_predictProb, METH_VARARGS | METH_KEYWORDS, "predictProb(inputs[, outputs[, outputProbs[, flags]]]) -> retval, outputs, outputProbs\n.   @brief Predicts the response for sample(s).\n.   \n.   The method estimates the most probable classes for input vectors. Input vectors (one or more)\n.   are stored as rows of the matrix inputs. In case of multiple input vectors, there should be one\n.   output vector outputs. The predicted class for a single input vector is returned by the method.\n.   The vector outputProbs contains the output probabilities corresponding to each element of\n.   result."},

    {NULL,          NULL}
};

static void pyopencv_ml_NormalBayesClassifier_specials(void)
{
    pyopencv_ml_NormalBayesClassifier_Type.tp_base = &pyopencv_ml_StatModel_Type;
    pyopencv_ml_NormalBayesClassifier_Type.tp_dealloc = pyopencv_ml_NormalBayesClassifier_dealloc;
    pyopencv_ml_NormalBayesClassifier_Type.tp_repr = pyopencv_ml_NormalBayesClassifier_repr;
    pyopencv_ml_NormalBayesClassifier_Type.tp_getset = pyopencv_ml_NormalBayesClassifier_getseters;
    pyopencv_ml_NormalBayesClassifier_Type.tp_init = (initproc)0;
    pyopencv_ml_NormalBayesClassifier_Type.tp_methods = pyopencv_ml_NormalBayesClassifier_methods;
}

static PyObject* pyopencv_ml_KNearest_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<ml_KNearest %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_ml_KNearest_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_ml_ml_KNearest_create_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    Ptr<KNearest> retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = cv::ml::KNearest::create());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_KNearest_findNearest(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::KNearest* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_KNearest_Type))
        _self_ = dynamic_cast<cv::ml::KNearest*>(((pyopencv_ml_KNearest_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_KNearest' or its derivative)");
    {
    PyObject* pyobj_samples = NULL;
    Mat samples;
    int k=0;
    PyObject* pyobj_results = NULL;
    Mat results;
    PyObject* pyobj_neighborResponses = NULL;
    Mat neighborResponses;
    PyObject* pyobj_dist = NULL;
    Mat dist;
    float retval;

    const char* keywords[] = { "samples", "k", "results", "neighborResponses", "dist", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "Oi|OOO:ml_KNearest.findNearest", (char**)keywords, &pyobj_samples, &k, &pyobj_results, &pyobj_neighborResponses, &pyobj_dist) &&
        pyopencv_to(pyobj_samples, samples, ArgInfo("samples", 0)) &&
        pyopencv_to(pyobj_results, results, ArgInfo("results", 1)) &&
        pyopencv_to(pyobj_neighborResponses, neighborResponses, ArgInfo("neighborResponses", 1)) &&
        pyopencv_to(pyobj_dist, dist, ArgInfo("dist", 1)) )
    {
        ERRWRAP2(retval = _self_->findNearest(samples, k, results, neighborResponses, dist));
        return Py_BuildValue("(NNNN)", pyopencv_from(retval), pyopencv_from(results), pyopencv_from(neighborResponses), pyopencv_from(dist));
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_samples = NULL;
    UMat samples;
    int k=0;
    PyObject* pyobj_results = NULL;
    UMat results;
    PyObject* pyobj_neighborResponses = NULL;
    UMat neighborResponses;
    PyObject* pyobj_dist = NULL;
    UMat dist;
    float retval;

    const char* keywords[] = { "samples", "k", "results", "neighborResponses", "dist", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "Oi|OOO:ml_KNearest.findNearest", (char**)keywords, &pyobj_samples, &k, &pyobj_results, &pyobj_neighborResponses, &pyobj_dist) &&
        pyopencv_to(pyobj_samples, samples, ArgInfo("samples", 0)) &&
        pyopencv_to(pyobj_results, results, ArgInfo("results", 1)) &&
        pyopencv_to(pyobj_neighborResponses, neighborResponses, ArgInfo("neighborResponses", 1)) &&
        pyopencv_to(pyobj_dist, dist, ArgInfo("dist", 1)) )
    {
        ERRWRAP2(retval = _self_->findNearest(samples, k, results, neighborResponses, dist));
        return Py_BuildValue("(NNNN)", pyopencv_from(retval), pyopencv_from(results), pyopencv_from(neighborResponses), pyopencv_from(dist));
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_KNearest_getAlgorithmType(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::KNearest* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_KNearest_Type))
        _self_ = dynamic_cast<cv::ml::KNearest*>(((pyopencv_ml_KNearest_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_KNearest' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getAlgorithmType());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_KNearest_getDefaultK(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::KNearest* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_KNearest_Type))
        _self_ = dynamic_cast<cv::ml::KNearest*>(((pyopencv_ml_KNearest_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_KNearest' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDefaultK());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_KNearest_getEmax(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::KNearest* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_KNearest_Type))
        _self_ = dynamic_cast<cv::ml::KNearest*>(((pyopencv_ml_KNearest_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_KNearest' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getEmax());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_KNearest_getIsClassifier(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::KNearest* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_KNearest_Type))
        _self_ = dynamic_cast<cv::ml::KNearest*>(((pyopencv_ml_KNearest_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_KNearest' or its derivative)");
    bool retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getIsClassifier());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_KNearest_setAlgorithmType(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::KNearest* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_KNearest_Type))
        _self_ = dynamic_cast<cv::ml::KNearest*>(((pyopencv_ml_KNearest_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_KNearest' or its derivative)");
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:ml_KNearest.setAlgorithmType", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setAlgorithmType(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_KNearest_setDefaultK(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::KNearest* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_KNearest_Type))
        _self_ = dynamic_cast<cv::ml::KNearest*>(((pyopencv_ml_KNearest_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_KNearest' or its derivative)");
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:ml_KNearest.setDefaultK", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setDefaultK(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_KNearest_setEmax(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::KNearest* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_KNearest_Type))
        _self_ = dynamic_cast<cv::ml::KNearest*>(((pyopencv_ml_KNearest_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_KNearest' or its derivative)");
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:ml_KNearest.setEmax", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setEmax(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_KNearest_setIsClassifier(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::KNearest* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_KNearest_Type))
        _self_ = dynamic_cast<cv::ml::KNearest*>(((pyopencv_ml_KNearest_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_KNearest' or its derivative)");
    bool val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "b:ml_KNearest.setIsClassifier", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setIsClassifier(val));
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_ml_KNearest_methods[] =
{
    {"create", (PyCFunction)pyopencv_cv_ml_ml_KNearest_create_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "create() -> retval\n.   @brief Creates the empty model\n.   \n.   The static method creates empty %KNearest classifier. It should be then trained using StatModel::train method."},
    {"findNearest", (PyCFunction)pyopencv_cv_ml_ml_KNearest_findNearest, METH_VARARGS | METH_KEYWORDS, "findNearest(samples, k[, results[, neighborResponses[, dist]]]) -> retval, results, neighborResponses, dist\n.   @brief Finds the neighbors and predicts responses for input vectors.\n.   \n.   @param samples Input samples stored by rows. It is a single-precision floating-point matrix of\n.   `<number_of_samples> * k` size.\n.   @param k Number of used nearest neighbors. Should be greater than 1.\n.   @param results Vector with results of prediction (regression or classification) for each input\n.   sample. It is a single-precision floating-point vector with `<number_of_samples>` elements.\n.   @param neighborResponses Optional output values for corresponding neighbors. It is a single-\n.   precision floating-point matrix of `<number_of_samples> * k` size.\n.   @param dist Optional output distances from the input vectors to the corresponding neighbors. It\n.   is a single-precision floating-point matrix of `<number_of_samples> * k` size.\n.   \n.   For each input vector (a row of the matrix samples), the method finds the k nearest neighbors.\n.   In case of regression, the predicted result is a mean value of the particular vector's neighbor\n.   responses. In case of classification, the class is determined by voting.\n.   \n.   For each input vector, the neighbors are sorted by their distances to the vector.\n.   \n.   In case of C++ interface you can use output pointers to empty matrices and the function will\n.   allocate memory itself.\n.   \n.   If only a single input vector is passed, all output matrices are optional and the predicted\n.   value is returned by the method.\n.   \n.   The function is parallelized with the TBB library."},
    {"getAlgorithmType", (PyCFunction)pyopencv_cv_ml_ml_KNearest_getAlgorithmType, METH_VARARGS | METH_KEYWORDS, "getAlgorithmType() -> retval\n.   @see setAlgorithmType"},
    {"getDefaultK", (PyCFunction)pyopencv_cv_ml_ml_KNearest_getDefaultK, METH_VARARGS | METH_KEYWORDS, "getDefaultK() -> retval\n.   @see setDefaultK"},
    {"getEmax", (PyCFunction)pyopencv_cv_ml_ml_KNearest_getEmax, METH_VARARGS | METH_KEYWORDS, "getEmax() -> retval\n.   @see setEmax"},
    {"getIsClassifier", (PyCFunction)pyopencv_cv_ml_ml_KNearest_getIsClassifier, METH_VARARGS | METH_KEYWORDS, "getIsClassifier() -> retval\n.   @see setIsClassifier"},
    {"setAlgorithmType", (PyCFunction)pyopencv_cv_ml_ml_KNearest_setAlgorithmType, METH_VARARGS | METH_KEYWORDS, "setAlgorithmType(val) -> None\n.   @copybrief getAlgorithmType @see getAlgorithmType"},
    {"setDefaultK", (PyCFunction)pyopencv_cv_ml_ml_KNearest_setDefaultK, METH_VARARGS | METH_KEYWORDS, "setDefaultK(val) -> None\n.   @copybrief getDefaultK @see getDefaultK"},
    {"setEmax", (PyCFunction)pyopencv_cv_ml_ml_KNearest_setEmax, METH_VARARGS | METH_KEYWORDS, "setEmax(val) -> None\n.   @copybrief getEmax @see getEmax"},
    {"setIsClassifier", (PyCFunction)pyopencv_cv_ml_ml_KNearest_setIsClassifier, METH_VARARGS | METH_KEYWORDS, "setIsClassifier(val) -> None\n.   @copybrief getIsClassifier @see getIsClassifier"},

    {NULL,          NULL}
};

static void pyopencv_ml_KNearest_specials(void)
{
    pyopencv_ml_KNearest_Type.tp_base = &pyopencv_ml_StatModel_Type;
    pyopencv_ml_KNearest_Type.tp_dealloc = pyopencv_ml_KNearest_dealloc;
    pyopencv_ml_KNearest_Type.tp_repr = pyopencv_ml_KNearest_repr;
    pyopencv_ml_KNearest_Type.tp_getset = pyopencv_ml_KNearest_getseters;
    pyopencv_ml_KNearest_Type.tp_init = (initproc)0;
    pyopencv_ml_KNearest_Type.tp_methods = pyopencv_ml_KNearest_methods;
}

static PyObject* pyopencv_ml_SVM_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<ml_SVM %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_ml_SVM_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_ml_ml_SVM_create_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    Ptr<SVM> retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = cv::ml::SVM::create());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVM_getC(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVM_Type))
        _self_ = dynamic_cast<cv::ml::SVM*>(((pyopencv_ml_SVM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVM' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getC());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVM_getClassWeights(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVM_Type))
        _self_ = dynamic_cast<cv::ml::SVM*>(((pyopencv_ml_SVM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVM' or its derivative)");
    cv::Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getClassWeights());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVM_getCoef0(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVM_Type))
        _self_ = dynamic_cast<cv::ml::SVM*>(((pyopencv_ml_SVM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVM' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getCoef0());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVM_getDecisionFunction(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVM_Type))
        _self_ = dynamic_cast<cv::ml::SVM*>(((pyopencv_ml_SVM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVM' or its derivative)");
    {
    int i=0;
    PyObject* pyobj_alpha = NULL;
    Mat alpha;
    PyObject* pyobj_svidx = NULL;
    Mat svidx;
    double retval;

    const char* keywords[] = { "i", "alpha", "svidx", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i|OO:ml_SVM.getDecisionFunction", (char**)keywords, &i, &pyobj_alpha, &pyobj_svidx) &&
        pyopencv_to(pyobj_alpha, alpha, ArgInfo("alpha", 1)) &&
        pyopencv_to(pyobj_svidx, svidx, ArgInfo("svidx", 1)) )
    {
        ERRWRAP2(retval = _self_->getDecisionFunction(i, alpha, svidx));
        return Py_BuildValue("(NNN)", pyopencv_from(retval), pyopencv_from(alpha), pyopencv_from(svidx));
    }
    }
    PyErr_Clear();

    {
    int i=0;
    PyObject* pyobj_alpha = NULL;
    UMat alpha;
    PyObject* pyobj_svidx = NULL;
    UMat svidx;
    double retval;

    const char* keywords[] = { "i", "alpha", "svidx", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i|OO:ml_SVM.getDecisionFunction", (char**)keywords, &i, &pyobj_alpha, &pyobj_svidx) &&
        pyopencv_to(pyobj_alpha, alpha, ArgInfo("alpha", 1)) &&
        pyopencv_to(pyobj_svidx, svidx, ArgInfo("svidx", 1)) )
    {
        ERRWRAP2(retval = _self_->getDecisionFunction(i, alpha, svidx));
        return Py_BuildValue("(NNN)", pyopencv_from(retval), pyopencv_from(alpha), pyopencv_from(svidx));
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVM_getDefaultGridPtr_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    int param_id=0;
    Ptr<ParamGrid> retval;

    const char* keywords[] = { "param_id", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:ml_SVM.getDefaultGridPtr", (char**)keywords, &param_id) )
    {
        ERRWRAP2(retval = cv::ml::SVM::getDefaultGridPtr(param_id));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVM_getDegree(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVM_Type))
        _self_ = dynamic_cast<cv::ml::SVM*>(((pyopencv_ml_SVM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVM' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDegree());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVM_getGamma(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVM_Type))
        _self_ = dynamic_cast<cv::ml::SVM*>(((pyopencv_ml_SVM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVM' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getGamma());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVM_getKernelType(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVM_Type))
        _self_ = dynamic_cast<cv::ml::SVM*>(((pyopencv_ml_SVM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVM' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getKernelType());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVM_getNu(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVM_Type))
        _self_ = dynamic_cast<cv::ml::SVM*>(((pyopencv_ml_SVM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVM' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getNu());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVM_getP(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVM_Type))
        _self_ = dynamic_cast<cv::ml::SVM*>(((pyopencv_ml_SVM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVM' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getP());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVM_getSupportVectors(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVM_Type))
        _self_ = dynamic_cast<cv::ml::SVM*>(((pyopencv_ml_SVM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVM' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getSupportVectors());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVM_getTermCriteria(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVM_Type))
        _self_ = dynamic_cast<cv::ml::SVM*>(((pyopencv_ml_SVM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVM' or its derivative)");
    cv::TermCriteria retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTermCriteria());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVM_getType(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVM_Type))
        _self_ = dynamic_cast<cv::ml::SVM*>(((pyopencv_ml_SVM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVM' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getType());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVM_getUncompressedSupportVectors(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVM_Type))
        _self_ = dynamic_cast<cv::ml::SVM*>(((pyopencv_ml_SVM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVM' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getUncompressedSupportVectors());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVM_load_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    PyObject* pyobj_filepath = NULL;
    String filepath;
    Ptr<SVM> retval;

    const char* keywords[] = { "filepath", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:ml_SVM.load", (char**)keywords, &pyobj_filepath) &&
        pyopencv_to(pyobj_filepath, filepath, ArgInfo("filepath", 0)) )
    {
        ERRWRAP2(retval = cv::ml::SVM::load(filepath));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVM_setC(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVM_Type))
        _self_ = dynamic_cast<cv::ml::SVM*>(((pyopencv_ml_SVM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVM' or its derivative)");
    double val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:ml_SVM.setC", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setC(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVM_setClassWeights(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVM_Type))
        _self_ = dynamic_cast<cv::ml::SVM*>(((pyopencv_ml_SVM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVM' or its derivative)");
    {
    PyObject* pyobj_val = NULL;
    Mat val;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:ml_SVM.setClassWeights", (char**)keywords, &pyobj_val) &&
        pyopencv_to(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->setClassWeights(val));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_val = NULL;
    Mat val;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:ml_SVM.setClassWeights", (char**)keywords, &pyobj_val) &&
        pyopencv_to(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->setClassWeights(val));
        Py_RETURN_NONE;
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVM_setCoef0(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVM_Type))
        _self_ = dynamic_cast<cv::ml::SVM*>(((pyopencv_ml_SVM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVM' or its derivative)");
    double val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:ml_SVM.setCoef0", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setCoef0(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVM_setDegree(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVM_Type))
        _self_ = dynamic_cast<cv::ml::SVM*>(((pyopencv_ml_SVM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVM' or its derivative)");
    double val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:ml_SVM.setDegree", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setDegree(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVM_setGamma(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVM_Type))
        _self_ = dynamic_cast<cv::ml::SVM*>(((pyopencv_ml_SVM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVM' or its derivative)");
    double val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:ml_SVM.setGamma", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setGamma(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVM_setKernel(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVM_Type))
        _self_ = dynamic_cast<cv::ml::SVM*>(((pyopencv_ml_SVM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVM' or its derivative)");
    int kernelType=0;

    const char* keywords[] = { "kernelType", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:ml_SVM.setKernel", (char**)keywords, &kernelType) )
    {
        ERRWRAP2(_self_->setKernel(kernelType));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVM_setNu(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVM_Type))
        _self_ = dynamic_cast<cv::ml::SVM*>(((pyopencv_ml_SVM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVM' or its derivative)");
    double val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:ml_SVM.setNu", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setNu(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVM_setP(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVM_Type))
        _self_ = dynamic_cast<cv::ml::SVM*>(((pyopencv_ml_SVM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVM' or its derivative)");
    double val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:ml_SVM.setP", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setP(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVM_setTermCriteria(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVM_Type))
        _self_ = dynamic_cast<cv::ml::SVM*>(((pyopencv_ml_SVM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVM' or its derivative)");
    PyObject* pyobj_val = NULL;
    TermCriteria val;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:ml_SVM.setTermCriteria", (char**)keywords, &pyobj_val) &&
        pyopencv_to(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->setTermCriteria(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVM_setType(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVM_Type))
        _self_ = dynamic_cast<cv::ml::SVM*>(((pyopencv_ml_SVM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVM' or its derivative)");
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:ml_SVM.setType", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setType(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVM_trainAuto(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVM_Type))
        _self_ = dynamic_cast<cv::ml::SVM*>(((pyopencv_ml_SVM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVM' or its derivative)");
    {
    PyObject* pyobj_samples = NULL;
    Mat samples;
    int layout=0;
    PyObject* pyobj_responses = NULL;
    Mat responses;
    int kFold=10;
    PyObject* pyobj_Cgrid = NULL;
    Ptr<ParamGrid> Cgrid=SVM::getDefaultGridPtr(SVM::C);
    PyObject* pyobj_gammaGrid = NULL;
    Ptr<ParamGrid> gammaGrid=SVM::getDefaultGridPtr(SVM::GAMMA);
    PyObject* pyobj_pGrid = NULL;
    Ptr<ParamGrid> pGrid=SVM::getDefaultGridPtr(SVM::P);
    PyObject* pyobj_nuGrid = NULL;
    Ptr<ParamGrid> nuGrid=SVM::getDefaultGridPtr(SVM::NU);
    PyObject* pyobj_coeffGrid = NULL;
    Ptr<ParamGrid> coeffGrid=SVM::getDefaultGridPtr(SVM::COEF);
    PyObject* pyobj_degreeGrid = NULL;
    Ptr<ParamGrid> degreeGrid=SVM::getDefaultGridPtr(SVM::DEGREE);
    bool balanced=false;
    bool retval;

    const char* keywords[] = { "samples", "layout", "responses", "kFold", "Cgrid", "gammaGrid", "pGrid", "nuGrid", "coeffGrid", "degreeGrid", "balanced", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OiO|iOOOOOOb:ml_SVM.trainAuto", (char**)keywords, &pyobj_samples, &layout, &pyobj_responses, &kFold, &pyobj_Cgrid, &pyobj_gammaGrid, &pyobj_pGrid, &pyobj_nuGrid, &pyobj_coeffGrid, &pyobj_degreeGrid, &balanced) &&
        pyopencv_to(pyobj_samples, samples, ArgInfo("samples", 0)) &&
        pyopencv_to(pyobj_responses, responses, ArgInfo("responses", 0)) &&
        pyopencv_to(pyobj_Cgrid, Cgrid, ArgInfo("Cgrid", 0)) &&
        pyopencv_to(pyobj_gammaGrid, gammaGrid, ArgInfo("gammaGrid", 0)) &&
        pyopencv_to(pyobj_pGrid, pGrid, ArgInfo("pGrid", 0)) &&
        pyopencv_to(pyobj_nuGrid, nuGrid, ArgInfo("nuGrid", 0)) &&
        pyopencv_to(pyobj_coeffGrid, coeffGrid, ArgInfo("coeffGrid", 0)) &&
        pyopencv_to(pyobj_degreeGrid, degreeGrid, ArgInfo("degreeGrid", 0)) )
    {
        ERRWRAP2(retval = _self_->trainAuto(samples, layout, responses, kFold, Cgrid, gammaGrid, pGrid, nuGrid, coeffGrid, degreeGrid, balanced));
        return pyopencv_from(retval);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_samples = NULL;
    UMat samples;
    int layout=0;
    PyObject* pyobj_responses = NULL;
    UMat responses;
    int kFold=10;
    PyObject* pyobj_Cgrid = NULL;
    Ptr<ParamGrid> Cgrid=SVM::getDefaultGridPtr(SVM::C);
    PyObject* pyobj_gammaGrid = NULL;
    Ptr<ParamGrid> gammaGrid=SVM::getDefaultGridPtr(SVM::GAMMA);
    PyObject* pyobj_pGrid = NULL;
    Ptr<ParamGrid> pGrid=SVM::getDefaultGridPtr(SVM::P);
    PyObject* pyobj_nuGrid = NULL;
    Ptr<ParamGrid> nuGrid=SVM::getDefaultGridPtr(SVM::NU);
    PyObject* pyobj_coeffGrid = NULL;
    Ptr<ParamGrid> coeffGrid=SVM::getDefaultGridPtr(SVM::COEF);
    PyObject* pyobj_degreeGrid = NULL;
    Ptr<ParamGrid> degreeGrid=SVM::getDefaultGridPtr(SVM::DEGREE);
    bool balanced=false;
    bool retval;

    const char* keywords[] = { "samples", "layout", "responses", "kFold", "Cgrid", "gammaGrid", "pGrid", "nuGrid", "coeffGrid", "degreeGrid", "balanced", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OiO|iOOOOOOb:ml_SVM.trainAuto", (char**)keywords, &pyobj_samples, &layout, &pyobj_responses, &kFold, &pyobj_Cgrid, &pyobj_gammaGrid, &pyobj_pGrid, &pyobj_nuGrid, &pyobj_coeffGrid, &pyobj_degreeGrid, &balanced) &&
        pyopencv_to(pyobj_samples, samples, ArgInfo("samples", 0)) &&
        pyopencv_to(pyobj_responses, responses, ArgInfo("responses", 0)) &&
        pyopencv_to(pyobj_Cgrid, Cgrid, ArgInfo("Cgrid", 0)) &&
        pyopencv_to(pyobj_gammaGrid, gammaGrid, ArgInfo("gammaGrid", 0)) &&
        pyopencv_to(pyobj_pGrid, pGrid, ArgInfo("pGrid", 0)) &&
        pyopencv_to(pyobj_nuGrid, nuGrid, ArgInfo("nuGrid", 0)) &&
        pyopencv_to(pyobj_coeffGrid, coeffGrid, ArgInfo("coeffGrid", 0)) &&
        pyopencv_to(pyobj_degreeGrid, degreeGrid, ArgInfo("degreeGrid", 0)) )
    {
        ERRWRAP2(retval = _self_->trainAuto(samples, layout, responses, kFold, Cgrid, gammaGrid, pGrid, nuGrid, coeffGrid, degreeGrid, balanced));
        return pyopencv_from(retval);
    }
    }

    return NULL;
}



static PyMethodDef pyopencv_ml_SVM_methods[] =
{
    {"create", (PyCFunction)pyopencv_cv_ml_ml_SVM_create_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "create() -> retval\n.   Creates empty model.\n.   Use StatModel::train to train the model. Since %SVM has several parameters, you may want to\n.   find the best parameters for your problem, it can be done with SVM::trainAuto."},
    {"getC", (PyCFunction)pyopencv_cv_ml_ml_SVM_getC, METH_VARARGS | METH_KEYWORDS, "getC() -> retval\n.   @see setC"},
    {"getClassWeights", (PyCFunction)pyopencv_cv_ml_ml_SVM_getClassWeights, METH_VARARGS | METH_KEYWORDS, "getClassWeights() -> retval\n.   @see setClassWeights"},
    {"getCoef0", (PyCFunction)pyopencv_cv_ml_ml_SVM_getCoef0, METH_VARARGS | METH_KEYWORDS, "getCoef0() -> retval\n.   @see setCoef0"},
    {"getDecisionFunction", (PyCFunction)pyopencv_cv_ml_ml_SVM_getDecisionFunction, METH_VARARGS | METH_KEYWORDS, "getDecisionFunction(i[, alpha[, svidx]]) -> retval, alpha, svidx\n.   @brief Retrieves the decision function\n.   \n.   @param i the index of the decision function. If the problem solved is regression, 1-class or\n.   2-class classification, then there will be just one decision function and the index should\n.   always be 0. Otherwise, in the case of N-class classification, there will be \\f$N(N-1)/2\\f$\n.   decision functions.\n.   @param alpha the optional output vector for weights, corresponding to different support vectors.\n.   In the case of linear %SVM all the alpha's will be 1's.\n.   @param svidx the optional output vector of indices of support vectors within the matrix of\n.   support vectors (which can be retrieved by SVM::getSupportVectors). In the case of linear\n.   %SVM each decision function consists of a single \"compressed\" support vector.\n.   \n.   The method returns rho parameter of the decision function, a scalar subtracted from the weighted\n.   sum of kernel responses."},
    {"getDefaultGridPtr", (PyCFunction)pyopencv_cv_ml_ml_SVM_getDefaultGridPtr_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "getDefaultGridPtr(param_id) -> retval\n.   @brief Generates a grid for %SVM parameters.\n.   \n.   @param param_id %SVM parameters IDs that must be one of the SVM::ParamTypes. The grid is\n.   generated for the parameter with this ID.\n.   \n.   The function generates a grid pointer for the specified parameter of the %SVM algorithm.\n.   The grid may be passed to the function SVM::trainAuto."},
    {"getDegree", (PyCFunction)pyopencv_cv_ml_ml_SVM_getDegree, METH_VARARGS | METH_KEYWORDS, "getDegree() -> retval\n.   @see setDegree"},
    {"getGamma", (PyCFunction)pyopencv_cv_ml_ml_SVM_getGamma, METH_VARARGS | METH_KEYWORDS, "getGamma() -> retval\n.   @see setGamma"},
    {"getKernelType", (PyCFunction)pyopencv_cv_ml_ml_SVM_getKernelType, METH_VARARGS | METH_KEYWORDS, "getKernelType() -> retval\n.   Type of a %SVM kernel.\n.   See SVM::KernelTypes. Default value is SVM::RBF."},
    {"getNu", (PyCFunction)pyopencv_cv_ml_ml_SVM_getNu, METH_VARARGS | METH_KEYWORDS, "getNu() -> retval\n.   @see setNu"},
    {"getP", (PyCFunction)pyopencv_cv_ml_ml_SVM_getP, METH_VARARGS | METH_KEYWORDS, "getP() -> retval\n.   @see setP"},
    {"getSupportVectors", (PyCFunction)pyopencv_cv_ml_ml_SVM_getSupportVectors, METH_VARARGS | METH_KEYWORDS, "getSupportVectors() -> retval\n.   @brief Retrieves all the support vectors\n.   \n.   The method returns all the support vectors as a floating-point matrix, where support vectors are\n.   stored as matrix rows."},
    {"getTermCriteria", (PyCFunction)pyopencv_cv_ml_ml_SVM_getTermCriteria, METH_VARARGS | METH_KEYWORDS, "getTermCriteria() -> retval\n.   @see setTermCriteria"},
    {"getType", (PyCFunction)pyopencv_cv_ml_ml_SVM_getType, METH_VARARGS | METH_KEYWORDS, "getType() -> retval\n.   @see setType"},
    {"getUncompressedSupportVectors", (PyCFunction)pyopencv_cv_ml_ml_SVM_getUncompressedSupportVectors, METH_VARARGS | METH_KEYWORDS, "getUncompressedSupportVectors() -> retval\n.   @brief Retrieves all the uncompressed support vectors of a linear %SVM\n.   \n.   The method returns all the uncompressed support vectors of a linear %SVM that the compressed\n.   support vector, used for prediction, was derived from. They are returned in a floating-point\n.   matrix, where the support vectors are stored as matrix rows."},
    {"load", (PyCFunction)pyopencv_cv_ml_ml_SVM_load_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "load(filepath) -> retval\n.   @brief Loads and creates a serialized svm from a file\n.   *\n.   * Use SVM::save to serialize and store an SVM to disk.\n.   * Load the SVM from this file again, by calling this function with the path to the file.\n.   *\n.   * @param filepath path to serialized svm"},
    {"setC", (PyCFunction)pyopencv_cv_ml_ml_SVM_setC, METH_VARARGS | METH_KEYWORDS, "setC(val) -> None\n.   @copybrief getC @see getC"},
    {"setClassWeights", (PyCFunction)pyopencv_cv_ml_ml_SVM_setClassWeights, METH_VARARGS | METH_KEYWORDS, "setClassWeights(val) -> None\n.   @copybrief getClassWeights @see getClassWeights"},
    {"setCoef0", (PyCFunction)pyopencv_cv_ml_ml_SVM_setCoef0, METH_VARARGS | METH_KEYWORDS, "setCoef0(val) -> None\n.   @copybrief getCoef0 @see getCoef0"},
    {"setDegree", (PyCFunction)pyopencv_cv_ml_ml_SVM_setDegree, METH_VARARGS | METH_KEYWORDS, "setDegree(val) -> None\n.   @copybrief getDegree @see getDegree"},
    {"setGamma", (PyCFunction)pyopencv_cv_ml_ml_SVM_setGamma, METH_VARARGS | METH_KEYWORDS, "setGamma(val) -> None\n.   @copybrief getGamma @see getGamma"},
    {"setKernel", (PyCFunction)pyopencv_cv_ml_ml_SVM_setKernel, METH_VARARGS | METH_KEYWORDS, "setKernel(kernelType) -> None\n.   Initialize with one of predefined kernels.\n.   See SVM::KernelTypes."},
    {"setNu", (PyCFunction)pyopencv_cv_ml_ml_SVM_setNu, METH_VARARGS | METH_KEYWORDS, "setNu(val) -> None\n.   @copybrief getNu @see getNu"},
    {"setP", (PyCFunction)pyopencv_cv_ml_ml_SVM_setP, METH_VARARGS | METH_KEYWORDS, "setP(val) -> None\n.   @copybrief getP @see getP"},
    {"setTermCriteria", (PyCFunction)pyopencv_cv_ml_ml_SVM_setTermCriteria, METH_VARARGS | METH_KEYWORDS, "setTermCriteria(val) -> None\n.   @copybrief getTermCriteria @see getTermCriteria"},
    {"setType", (PyCFunction)pyopencv_cv_ml_ml_SVM_setType, METH_VARARGS | METH_KEYWORDS, "setType(val) -> None\n.   @copybrief getType @see getType"},
    {"trainAuto", (PyCFunction)pyopencv_cv_ml_ml_SVM_trainAuto, METH_VARARGS | METH_KEYWORDS, "trainAuto(samples, layout, responses[, kFold[, Cgrid[, gammaGrid[, pGrid[, nuGrid[, coeffGrid[, degreeGrid[, balanced]]]]]]]]) -> retval\n.   @brief Trains an %SVM with optimal parameters\n.   \n.   @param samples training samples\n.   @param layout See ml::SampleTypes.\n.   @param responses vector of responses associated with the training samples.\n.   @param kFold Cross-validation parameter. The training set is divided into kFold subsets. One\n.   subset is used to test the model, the others form the train set. So, the %SVM algorithm is\n.   @param Cgrid grid for C\n.   @param gammaGrid grid for gamma\n.   @param pGrid grid for p\n.   @param nuGrid grid for nu\n.   @param coeffGrid grid for coeff\n.   @param degreeGrid grid for degree\n.   @param balanced If true and the problem is 2-class classification then the method creates more\n.   balanced cross-validation subsets that is proportions between classes in subsets are close\n.   to such proportion in the whole train dataset.\n.   \n.   The method trains the %SVM model automatically by choosing the optimal parameters C, gamma, p,\n.   nu, coef0, degree. Parameters are considered optimal when the cross-validation\n.   estimate of the test set error is minimal.\n.   \n.   This function only makes use of SVM::getDefaultGrid for parameter optimization and thus only\n.   offers rudimentary parameter options.\n.   \n.   This function works for the classification (SVM::C_SVC or SVM::NU_SVC) as well as for the\n.   regression (SVM::EPS_SVR or SVM::NU_SVR). If it is SVM::ONE_CLASS, no optimization is made and\n.   the usual %SVM with parameters specified in params is executed."},

    {NULL,          NULL}
};

static void pyopencv_ml_SVM_specials(void)
{
    pyopencv_ml_SVM_Type.tp_base = &pyopencv_ml_StatModel_Type;
    pyopencv_ml_SVM_Type.tp_dealloc = pyopencv_ml_SVM_dealloc;
    pyopencv_ml_SVM_Type.tp_repr = pyopencv_ml_SVM_repr;
    pyopencv_ml_SVM_Type.tp_getset = pyopencv_ml_SVM_getseters;
    pyopencv_ml_SVM_Type.tp_init = (initproc)0;
    pyopencv_ml_SVM_Type.tp_methods = pyopencv_ml_SVM_methods;
}

static PyObject* pyopencv_ml_EM_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<ml_EM %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_ml_EM_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_ml_ml_EM_create_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    Ptr<EM> retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = cv::ml::EM::create());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_EM_getClustersNumber(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::EM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_EM_Type))
        _self_ = dynamic_cast<cv::ml::EM*>(((pyopencv_ml_EM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_EM' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getClustersNumber());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_EM_getCovarianceMatrixType(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::EM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_EM_Type))
        _self_ = dynamic_cast<cv::ml::EM*>(((pyopencv_ml_EM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_EM' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getCovarianceMatrixType());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_EM_getCovs(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::EM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_EM_Type))
        _self_ = dynamic_cast<cv::ml::EM*>(((pyopencv_ml_EM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_EM' or its derivative)");
    {
    PyObject* pyobj_covs = NULL;
    vector_Mat covs;

    const char* keywords[] = { "covs", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "|O:ml_EM.getCovs", (char**)keywords, &pyobj_covs) &&
        pyopencv_to(pyobj_covs, covs, ArgInfo("covs", 1)) )
    {
        ERRWRAP2(_self_->getCovs(covs));
        return pyopencv_from(covs);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_covs = NULL;
    vector_Mat covs;

    const char* keywords[] = { "covs", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "|O:ml_EM.getCovs", (char**)keywords, &pyobj_covs) &&
        pyopencv_to(pyobj_covs, covs, ArgInfo("covs", 1)) )
    {
        ERRWRAP2(_self_->getCovs(covs));
        return pyopencv_from(covs);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_EM_getMeans(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::EM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_EM_Type))
        _self_ = dynamic_cast<cv::ml::EM*>(((pyopencv_ml_EM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_EM' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMeans());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_EM_getTermCriteria(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::EM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_EM_Type))
        _self_ = dynamic_cast<cv::ml::EM*>(((pyopencv_ml_EM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_EM' or its derivative)");
    TermCriteria retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTermCriteria());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_EM_getWeights(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::EM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_EM_Type))
        _self_ = dynamic_cast<cv::ml::EM*>(((pyopencv_ml_EM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_EM' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getWeights());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_EM_load_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    PyObject* pyobj_filepath = NULL;
    String filepath;
    PyObject* pyobj_nodeName = NULL;
    String nodeName;
    Ptr<EM> retval;

    const char* keywords[] = { "filepath", "nodeName", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:ml_EM.load", (char**)keywords, &pyobj_filepath, &pyobj_nodeName) &&
        pyopencv_to(pyobj_filepath, filepath, ArgInfo("filepath", 0)) &&
        pyopencv_to(pyobj_nodeName, nodeName, ArgInfo("nodeName", 0)) )
    {
        ERRWRAP2(retval = cv::ml::EM::load(filepath, nodeName));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_EM_predict(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::EM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_EM_Type))
        _self_ = dynamic_cast<cv::ml::EM*>(((pyopencv_ml_EM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_EM' or its derivative)");
    {
    PyObject* pyobj_samples = NULL;
    Mat samples;
    PyObject* pyobj_results = NULL;
    Mat results;
    int flags=0;
    float retval;

    const char* keywords[] = { "samples", "results", "flags", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|Oi:ml_EM.predict", (char**)keywords, &pyobj_samples, &pyobj_results, &flags) &&
        pyopencv_to(pyobj_samples, samples, ArgInfo("samples", 0)) &&
        pyopencv_to(pyobj_results, results, ArgInfo("results", 1)) )
    {
        ERRWRAP2(retval = _self_->predict(samples, results, flags));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(results));
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_samples = NULL;
    UMat samples;
    PyObject* pyobj_results = NULL;
    UMat results;
    int flags=0;
    float retval;

    const char* keywords[] = { "samples", "results", "flags", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|Oi:ml_EM.predict", (char**)keywords, &pyobj_samples, &pyobj_results, &flags) &&
        pyopencv_to(pyobj_samples, samples, ArgInfo("samples", 0)) &&
        pyopencv_to(pyobj_results, results, ArgInfo("results", 1)) )
    {
        ERRWRAP2(retval = _self_->predict(samples, results, flags));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(results));
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_EM_predict2(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::EM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_EM_Type))
        _self_ = dynamic_cast<cv::ml::EM*>(((pyopencv_ml_EM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_EM' or its derivative)");
    {
    PyObject* pyobj_sample = NULL;
    Mat sample;
    PyObject* pyobj_probs = NULL;
    Mat probs;
    Vec2d retval;

    const char* keywords[] = { "sample", "probs", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:ml_EM.predict2", (char**)keywords, &pyobj_sample, &pyobj_probs) &&
        pyopencv_to(pyobj_sample, sample, ArgInfo("sample", 0)) &&
        pyopencv_to(pyobj_probs, probs, ArgInfo("probs", 1)) )
    {
        ERRWRAP2(retval = _self_->predict2(sample, probs));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(probs));
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_sample = NULL;
    UMat sample;
    PyObject* pyobj_probs = NULL;
    UMat probs;
    Vec2d retval;

    const char* keywords[] = { "sample", "probs", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:ml_EM.predict2", (char**)keywords, &pyobj_sample, &pyobj_probs) &&
        pyopencv_to(pyobj_sample, sample, ArgInfo("sample", 0)) &&
        pyopencv_to(pyobj_probs, probs, ArgInfo("probs", 1)) )
    {
        ERRWRAP2(retval = _self_->predict2(sample, probs));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(probs));
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_EM_setClustersNumber(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::EM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_EM_Type))
        _self_ = dynamic_cast<cv::ml::EM*>(((pyopencv_ml_EM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_EM' or its derivative)");
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:ml_EM.setClustersNumber", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setClustersNumber(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_EM_setCovarianceMatrixType(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::EM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_EM_Type))
        _self_ = dynamic_cast<cv::ml::EM*>(((pyopencv_ml_EM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_EM' or its derivative)");
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:ml_EM.setCovarianceMatrixType", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setCovarianceMatrixType(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_EM_setTermCriteria(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::EM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_EM_Type))
        _self_ = dynamic_cast<cv::ml::EM*>(((pyopencv_ml_EM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_EM' or its derivative)");
    PyObject* pyobj_val = NULL;
    TermCriteria val;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:ml_EM.setTermCriteria", (char**)keywords, &pyobj_val) &&
        pyopencv_to(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->setTermCriteria(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_EM_trainE(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::EM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_EM_Type))
        _self_ = dynamic_cast<cv::ml::EM*>(((pyopencv_ml_EM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_EM' or its derivative)");
    {
    PyObject* pyobj_samples = NULL;
    Mat samples;
    PyObject* pyobj_means0 = NULL;
    Mat means0;
    PyObject* pyobj_covs0 = NULL;
    Mat covs0;
    PyObject* pyobj_weights0 = NULL;
    Mat weights0;
    PyObject* pyobj_logLikelihoods = NULL;
    Mat logLikelihoods;
    PyObject* pyobj_labels = NULL;
    Mat labels;
    PyObject* pyobj_probs = NULL;
    Mat probs;
    bool retval;

    const char* keywords[] = { "samples", "means0", "covs0", "weights0", "logLikelihoods", "labels", "probs", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|OOOOO:ml_EM.trainE", (char**)keywords, &pyobj_samples, &pyobj_means0, &pyobj_covs0, &pyobj_weights0, &pyobj_logLikelihoods, &pyobj_labels, &pyobj_probs) &&
        pyopencv_to(pyobj_samples, samples, ArgInfo("samples", 0)) &&
        pyopencv_to(pyobj_means0, means0, ArgInfo("means0", 0)) &&
        pyopencv_to(pyobj_covs0, covs0, ArgInfo("covs0", 0)) &&
        pyopencv_to(pyobj_weights0, weights0, ArgInfo("weights0", 0)) &&
        pyopencv_to(pyobj_logLikelihoods, logLikelihoods, ArgInfo("logLikelihoods", 1)) &&
        pyopencv_to(pyobj_labels, labels, ArgInfo("labels", 1)) &&
        pyopencv_to(pyobj_probs, probs, ArgInfo("probs", 1)) )
    {
        ERRWRAP2(retval = _self_->trainE(samples, means0, covs0, weights0, logLikelihoods, labels, probs));
        return Py_BuildValue("(NNNN)", pyopencv_from(retval), pyopencv_from(logLikelihoods), pyopencv_from(labels), pyopencv_from(probs));
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_samples = NULL;
    UMat samples;
    PyObject* pyobj_means0 = NULL;
    UMat means0;
    PyObject* pyobj_covs0 = NULL;
    UMat covs0;
    PyObject* pyobj_weights0 = NULL;
    UMat weights0;
    PyObject* pyobj_logLikelihoods = NULL;
    UMat logLikelihoods;
    PyObject* pyobj_labels = NULL;
    UMat labels;
    PyObject* pyobj_probs = NULL;
    UMat probs;
    bool retval;

    const char* keywords[] = { "samples", "means0", "covs0", "weights0", "logLikelihoods", "labels", "probs", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|OOOOO:ml_EM.trainE", (char**)keywords, &pyobj_samples, &pyobj_means0, &pyobj_covs0, &pyobj_weights0, &pyobj_logLikelihoods, &pyobj_labels, &pyobj_probs) &&
        pyopencv_to(pyobj_samples, samples, ArgInfo("samples", 0)) &&
        pyopencv_to(pyobj_means0, means0, ArgInfo("means0", 0)) &&
        pyopencv_to(pyobj_covs0, covs0, ArgInfo("covs0", 0)) &&
        pyopencv_to(pyobj_weights0, weights0, ArgInfo("weights0", 0)) &&
        pyopencv_to(pyobj_logLikelihoods, logLikelihoods, ArgInfo("logLikelihoods", 1)) &&
        pyopencv_to(pyobj_labels, labels, ArgInfo("labels", 1)) &&
        pyopencv_to(pyobj_probs, probs, ArgInfo("probs", 1)) )
    {
        ERRWRAP2(retval = _self_->trainE(samples, means0, covs0, weights0, logLikelihoods, labels, probs));
        return Py_BuildValue("(NNNN)", pyopencv_from(retval), pyopencv_from(logLikelihoods), pyopencv_from(labels), pyopencv_from(probs));
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_EM_trainEM(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::EM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_EM_Type))
        _self_ = dynamic_cast<cv::ml::EM*>(((pyopencv_ml_EM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_EM' or its derivative)");
    {
    PyObject* pyobj_samples = NULL;
    Mat samples;
    PyObject* pyobj_logLikelihoods = NULL;
    Mat logLikelihoods;
    PyObject* pyobj_labels = NULL;
    Mat labels;
    PyObject* pyobj_probs = NULL;
    Mat probs;
    bool retval;

    const char* keywords[] = { "samples", "logLikelihoods", "labels", "probs", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|OOO:ml_EM.trainEM", (char**)keywords, &pyobj_samples, &pyobj_logLikelihoods, &pyobj_labels, &pyobj_probs) &&
        pyopencv_to(pyobj_samples, samples, ArgInfo("samples", 0)) &&
        pyopencv_to(pyobj_logLikelihoods, logLikelihoods, ArgInfo("logLikelihoods", 1)) &&
        pyopencv_to(pyobj_labels, labels, ArgInfo("labels", 1)) &&
        pyopencv_to(pyobj_probs, probs, ArgInfo("probs", 1)) )
    {
        ERRWRAP2(retval = _self_->trainEM(samples, logLikelihoods, labels, probs));
        return Py_BuildValue("(NNNN)", pyopencv_from(retval), pyopencv_from(logLikelihoods), pyopencv_from(labels), pyopencv_from(probs));
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_samples = NULL;
    UMat samples;
    PyObject* pyobj_logLikelihoods = NULL;
    UMat logLikelihoods;
    PyObject* pyobj_labels = NULL;
    UMat labels;
    PyObject* pyobj_probs = NULL;
    UMat probs;
    bool retval;

    const char* keywords[] = { "samples", "logLikelihoods", "labels", "probs", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|OOO:ml_EM.trainEM", (char**)keywords, &pyobj_samples, &pyobj_logLikelihoods, &pyobj_labels, &pyobj_probs) &&
        pyopencv_to(pyobj_samples, samples, ArgInfo("samples", 0)) &&
        pyopencv_to(pyobj_logLikelihoods, logLikelihoods, ArgInfo("logLikelihoods", 1)) &&
        pyopencv_to(pyobj_labels, labels, ArgInfo("labels", 1)) &&
        pyopencv_to(pyobj_probs, probs, ArgInfo("probs", 1)) )
    {
        ERRWRAP2(retval = _self_->trainEM(samples, logLikelihoods, labels, probs));
        return Py_BuildValue("(NNNN)", pyopencv_from(retval), pyopencv_from(logLikelihoods), pyopencv_from(labels), pyopencv_from(probs));
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_EM_trainM(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::EM* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_EM_Type))
        _self_ = dynamic_cast<cv::ml::EM*>(((pyopencv_ml_EM_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_EM' or its derivative)");
    {
    PyObject* pyobj_samples = NULL;
    Mat samples;
    PyObject* pyobj_probs0 = NULL;
    Mat probs0;
    PyObject* pyobj_logLikelihoods = NULL;
    Mat logLikelihoods;
    PyObject* pyobj_labels = NULL;
    Mat labels;
    PyObject* pyobj_probs = NULL;
    Mat probs;
    bool retval;

    const char* keywords[] = { "samples", "probs0", "logLikelihoods", "labels", "probs", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|OOO:ml_EM.trainM", (char**)keywords, &pyobj_samples, &pyobj_probs0, &pyobj_logLikelihoods, &pyobj_labels, &pyobj_probs) &&
        pyopencv_to(pyobj_samples, samples, ArgInfo("samples", 0)) &&
        pyopencv_to(pyobj_probs0, probs0, ArgInfo("probs0", 0)) &&
        pyopencv_to(pyobj_logLikelihoods, logLikelihoods, ArgInfo("logLikelihoods", 1)) &&
        pyopencv_to(pyobj_labels, labels, ArgInfo("labels", 1)) &&
        pyopencv_to(pyobj_probs, probs, ArgInfo("probs", 1)) )
    {
        ERRWRAP2(retval = _self_->trainM(samples, probs0, logLikelihoods, labels, probs));
        return Py_BuildValue("(NNNN)", pyopencv_from(retval), pyopencv_from(logLikelihoods), pyopencv_from(labels), pyopencv_from(probs));
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_samples = NULL;
    UMat samples;
    PyObject* pyobj_probs0 = NULL;
    UMat probs0;
    PyObject* pyobj_logLikelihoods = NULL;
    UMat logLikelihoods;
    PyObject* pyobj_labels = NULL;
    UMat labels;
    PyObject* pyobj_probs = NULL;
    UMat probs;
    bool retval;

    const char* keywords[] = { "samples", "probs0", "logLikelihoods", "labels", "probs", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|OOO:ml_EM.trainM", (char**)keywords, &pyobj_samples, &pyobj_probs0, &pyobj_logLikelihoods, &pyobj_labels, &pyobj_probs) &&
        pyopencv_to(pyobj_samples, samples, ArgInfo("samples", 0)) &&
        pyopencv_to(pyobj_probs0, probs0, ArgInfo("probs0", 0)) &&
        pyopencv_to(pyobj_logLikelihoods, logLikelihoods, ArgInfo("logLikelihoods", 1)) &&
        pyopencv_to(pyobj_labels, labels, ArgInfo("labels", 1)) &&
        pyopencv_to(pyobj_probs, probs, ArgInfo("probs", 1)) )
    {
        ERRWRAP2(retval = _self_->trainM(samples, probs0, logLikelihoods, labels, probs));
        return Py_BuildValue("(NNNN)", pyopencv_from(retval), pyopencv_from(logLikelihoods), pyopencv_from(labels), pyopencv_from(probs));
    }
    }

    return NULL;
}



static PyMethodDef pyopencv_ml_EM_methods[] =
{
    {"create", (PyCFunction)pyopencv_cv_ml_ml_EM_create_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "create() -> retval\n.   Creates empty %EM model.\n.   The model should be trained then using StatModel::train(traindata, flags) method. Alternatively, you\n.   can use one of the EM::train\\* methods or load it from file using Algorithm::load\\<EM\\>(filename)."},
    {"getClustersNumber", (PyCFunction)pyopencv_cv_ml_ml_EM_getClustersNumber, METH_VARARGS | METH_KEYWORDS, "getClustersNumber() -> retval\n.   @see setClustersNumber"},
    {"getCovarianceMatrixType", (PyCFunction)pyopencv_cv_ml_ml_EM_getCovarianceMatrixType, METH_VARARGS | METH_KEYWORDS, "getCovarianceMatrixType() -> retval\n.   @see setCovarianceMatrixType"},
    {"getCovs", (PyCFunction)pyopencv_cv_ml_ml_EM_getCovs, METH_VARARGS | METH_KEYWORDS, "getCovs([, covs]) -> covs\n.   @brief Returns covariation matrices\n.   \n.   Returns vector of covariation matrices. Number of matrices is the number of gaussian mixtures,\n.   each matrix is a square floating-point matrix NxN, where N is the space dimensionality."},
    {"getMeans", (PyCFunction)pyopencv_cv_ml_ml_EM_getMeans, METH_VARARGS | METH_KEYWORDS, "getMeans() -> retval\n.   @brief Returns the cluster centers (means of the Gaussian mixture)\n.   \n.   Returns matrix with the number of rows equal to the number of mixtures and number of columns\n.   equal to the space dimensionality."},
    {"getTermCriteria", (PyCFunction)pyopencv_cv_ml_ml_EM_getTermCriteria, METH_VARARGS | METH_KEYWORDS, "getTermCriteria() -> retval\n.   @see setTermCriteria"},
    {"getWeights", (PyCFunction)pyopencv_cv_ml_ml_EM_getWeights, METH_VARARGS | METH_KEYWORDS, "getWeights() -> retval\n.   @brief Returns weights of the mixtures\n.   \n.   Returns vector with the number of elements equal to the number of mixtures."},
    {"load", (PyCFunction)pyopencv_cv_ml_ml_EM_load_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "load(filepath[, nodeName]) -> retval\n.   @brief Loads and creates a serialized EM from a file\n.   *\n.   * Use EM::save to serialize and store an EM to disk.\n.   * Load the EM from this file again, by calling this function with the path to the file.\n.   * Optionally specify the node for the file containing the classifier\n.   *\n.   * @param filepath path to serialized EM\n.   * @param nodeName name of node containing the classifier"},
    {"predict", (PyCFunction)pyopencv_cv_ml_ml_EM_predict, METH_VARARGS | METH_KEYWORDS, "predict(samples[, results[, flags]]) -> retval, results\n.   @brief Returns posterior probabilities for the provided samples\n.   \n.   @param samples The input samples, floating-point matrix\n.   @param results The optional output \\f$ nSamples \\times nClusters\\f$ matrix of results. It contains\n.   posterior probabilities for each sample from the input\n.   @param flags This parameter will be ignored"},
    {"predict2", (PyCFunction)pyopencv_cv_ml_ml_EM_predict2, METH_VARARGS | METH_KEYWORDS, "predict2(sample[, probs]) -> retval, probs\n.   @brief Returns a likelihood logarithm value and an index of the most probable mixture component\n.   for the given sample.\n.   \n.   @param sample A sample for classification. It should be a one-channel matrix of\n.   \\f$1 \\times dims\\f$ or \\f$dims \\times 1\\f$ size.\n.   @param probs Optional output matrix that contains posterior probabilities of each component\n.   given the sample. It has \\f$1 \\times nclusters\\f$ size and CV_64FC1 type.\n.   \n.   The method returns a two-element double vector. Zero element is a likelihood logarithm value for\n.   the sample. First element is an index of the most probable mixture component for the given\n.   sample."},
    {"setClustersNumber", (PyCFunction)pyopencv_cv_ml_ml_EM_setClustersNumber, METH_VARARGS | METH_KEYWORDS, "setClustersNumber(val) -> None\n.   @copybrief getClustersNumber @see getClustersNumber"},
    {"setCovarianceMatrixType", (PyCFunction)pyopencv_cv_ml_ml_EM_setCovarianceMatrixType, METH_VARARGS | METH_KEYWORDS, "setCovarianceMatrixType(val) -> None\n.   @copybrief getCovarianceMatrixType @see getCovarianceMatrixType"},
    {"setTermCriteria", (PyCFunction)pyopencv_cv_ml_ml_EM_setTermCriteria, METH_VARARGS | METH_KEYWORDS, "setTermCriteria(val) -> None\n.   @copybrief getTermCriteria @see getTermCriteria"},
    {"trainE", (PyCFunction)pyopencv_cv_ml_ml_EM_trainE, METH_VARARGS | METH_KEYWORDS, "trainE(samples, means0[, covs0[, weights0[, logLikelihoods[, labels[, probs]]]]]) -> retval, logLikelihoods, labels, probs\n.   @brief Estimate the Gaussian mixture parameters from a samples set.\n.   \n.   This variation starts with Expectation step. You need to provide initial means \\f$a_k\\f$ of\n.   mixture components. Optionally you can pass initial weights \\f$\\pi_k\\f$ and covariance matrices\n.   \\f$S_k\\f$ of mixture components.\n.   \n.   @param samples Samples from which the Gaussian mixture model will be estimated. It should be a\n.   one-channel matrix, each row of which is a sample. If the matrix does not have CV_64F type\n.   it will be converted to the inner matrix of such type for the further computing.\n.   @param means0 Initial means \\f$a_k\\f$ of mixture components. It is a one-channel matrix of\n.   \\f$nclusters \\times dims\\f$ size. If the matrix does not have CV_64F type it will be\n.   converted to the inner matrix of such type for the further computing.\n.   @param covs0 The vector of initial covariance matrices \\f$S_k\\f$ of mixture components. Each of\n.   covariance matrices is a one-channel matrix of \\f$dims \\times dims\\f$ size. If the matrices\n.   do not have CV_64F type they will be converted to the inner matrices of such type for the\n.   further computing.\n.   @param weights0 Initial weights \\f$\\pi_k\\f$ of mixture components. It should be a one-channel\n.   floating-point matrix with \\f$1 \\times nclusters\\f$ or \\f$nclusters \\times 1\\f$ size.\n.   @param logLikelihoods The optional output matrix that contains a likelihood logarithm value for\n.   each sample. It has \\f$nsamples \\times 1\\f$ size and CV_64FC1 type.\n.   @param labels The optional output \"class label\" for each sample:\n.   \\f$\\texttt{labels}_i=\\texttt{arg max}_k(p_{i,k}), i=1..N\\f$ (indices of the most probable\n.   mixture component for each sample). It has \\f$nsamples \\times 1\\f$ size and CV_32SC1 type.\n.   @param probs The optional output matrix that contains posterior probabilities of each Gaussian\n.   mixture component given the each sample. It has \\f$nsamples \\times nclusters\\f$ size and\n.   CV_64FC1 type."},
    {"trainEM", (PyCFunction)pyopencv_cv_ml_ml_EM_trainEM, METH_VARARGS | METH_KEYWORDS, "trainEM(samples[, logLikelihoods[, labels[, probs]]]) -> retval, logLikelihoods, labels, probs\n.   @brief Estimate the Gaussian mixture parameters from a samples set.\n.   \n.   This variation starts with Expectation step. Initial values of the model parameters will be\n.   estimated by the k-means algorithm.\n.   \n.   Unlike many of the ML models, %EM is an unsupervised learning algorithm and it does not take\n.   responses (class labels or function values) as input. Instead, it computes the *Maximum\n.   Likelihood Estimate* of the Gaussian mixture parameters from an input sample set, stores all the\n.   parameters inside the structure: \\f$p_{i,k}\\f$ in probs, \\f$a_k\\f$ in means , \\f$S_k\\f$ in\n.   covs[k], \\f$\\pi_k\\f$ in weights , and optionally computes the output \"class label\" for each\n.   sample: \\f$\\texttt{labels}_i=\\texttt{arg max}_k(p_{i,k}), i=1..N\\f$ (indices of the most\n.   probable mixture component for each sample).\n.   \n.   The trained model can be used further for prediction, just like any other classifier. The\n.   trained model is similar to the NormalBayesClassifier.\n.   \n.   @param samples Samples from which the Gaussian mixture model will be estimated. It should be a\n.   one-channel matrix, each row of which is a sample. If the matrix does not have CV_64F type\n.   it will be converted to the inner matrix of such type for the further computing.\n.   @param logLikelihoods The optional output matrix that contains a likelihood logarithm value for\n.   each sample. It has \\f$nsamples \\times 1\\f$ size and CV_64FC1 type.\n.   @param labels The optional output \"class label\" for each sample:\n.   \\f$\\texttt{labels}_i=\\texttt{arg max}_k(p_{i,k}), i=1..N\\f$ (indices of the most probable\n.   mixture component for each sample). It has \\f$nsamples \\times 1\\f$ size and CV_32SC1 type.\n.   @param probs The optional output matrix that contains posterior probabilities of each Gaussian\n.   mixture component given the each sample. It has \\f$nsamples \\times nclusters\\f$ size and\n.   CV_64FC1 type."},
    {"trainM", (PyCFunction)pyopencv_cv_ml_ml_EM_trainM, METH_VARARGS | METH_KEYWORDS, "trainM(samples, probs0[, logLikelihoods[, labels[, probs]]]) -> retval, logLikelihoods, labels, probs\n.   @brief Estimate the Gaussian mixture parameters from a samples set.\n.   \n.   This variation starts with Maximization step. You need to provide initial probabilities\n.   \\f$p_{i,k}\\f$ to use this option.\n.   \n.   @param samples Samples from which the Gaussian mixture model will be estimated. It should be a\n.   one-channel matrix, each row of which is a sample. If the matrix does not have CV_64F type\n.   it will be converted to the inner matrix of such type for the further computing.\n.   @param probs0\n.   @param logLikelihoods The optional output matrix that contains a likelihood logarithm value for\n.   each sample. It has \\f$nsamples \\times 1\\f$ size and CV_64FC1 type.\n.   @param labels The optional output \"class label\" for each sample:\n.   \\f$\\texttt{labels}_i=\\texttt{arg max}_k(p_{i,k}), i=1..N\\f$ (indices of the most probable\n.   mixture component for each sample). It has \\f$nsamples \\times 1\\f$ size and CV_32SC1 type.\n.   @param probs The optional output matrix that contains posterior probabilities of each Gaussian\n.   mixture component given the each sample. It has \\f$nsamples \\times nclusters\\f$ size and\n.   CV_64FC1 type."},

    {NULL,          NULL}
};

static void pyopencv_ml_EM_specials(void)
{
    pyopencv_ml_EM_Type.tp_base = &pyopencv_ml_StatModel_Type;
    pyopencv_ml_EM_Type.tp_dealloc = pyopencv_ml_EM_dealloc;
    pyopencv_ml_EM_Type.tp_repr = pyopencv_ml_EM_repr;
    pyopencv_ml_EM_Type.tp_getset = pyopencv_ml_EM_getseters;
    pyopencv_ml_EM_Type.tp_init = (initproc)0;
    pyopencv_ml_EM_Type.tp_methods = pyopencv_ml_EM_methods;
}

static PyObject* pyopencv_ml_DTrees_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<ml_DTrees %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_ml_DTrees_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_ml_ml_DTrees_create_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    Ptr<DTrees> retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = cv::ml::DTrees::create());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_DTrees_getCVFolds(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::DTrees* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_DTrees_Type))
        _self_ = dynamic_cast<cv::ml::DTrees*>(((pyopencv_ml_DTrees_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_DTrees' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getCVFolds());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_DTrees_getMaxCategories(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::DTrees* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_DTrees_Type))
        _self_ = dynamic_cast<cv::ml::DTrees*>(((pyopencv_ml_DTrees_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_DTrees' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMaxCategories());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_DTrees_getMaxDepth(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::DTrees* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_DTrees_Type))
        _self_ = dynamic_cast<cv::ml::DTrees*>(((pyopencv_ml_DTrees_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_DTrees' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMaxDepth());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_DTrees_getMinSampleCount(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::DTrees* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_DTrees_Type))
        _self_ = dynamic_cast<cv::ml::DTrees*>(((pyopencv_ml_DTrees_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_DTrees' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMinSampleCount());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_DTrees_getPriors(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::DTrees* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_DTrees_Type))
        _self_ = dynamic_cast<cv::ml::DTrees*>(((pyopencv_ml_DTrees_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_DTrees' or its derivative)");
    cv::Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getPriors());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_DTrees_getRegressionAccuracy(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::DTrees* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_DTrees_Type))
        _self_ = dynamic_cast<cv::ml::DTrees*>(((pyopencv_ml_DTrees_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_DTrees' or its derivative)");
    float retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getRegressionAccuracy());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_DTrees_getTruncatePrunedTree(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::DTrees* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_DTrees_Type))
        _self_ = dynamic_cast<cv::ml::DTrees*>(((pyopencv_ml_DTrees_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_DTrees' or its derivative)");
    bool retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTruncatePrunedTree());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_DTrees_getUse1SERule(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::DTrees* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_DTrees_Type))
        _self_ = dynamic_cast<cv::ml::DTrees*>(((pyopencv_ml_DTrees_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_DTrees' or its derivative)");
    bool retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getUse1SERule());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_DTrees_getUseSurrogates(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::DTrees* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_DTrees_Type))
        _self_ = dynamic_cast<cv::ml::DTrees*>(((pyopencv_ml_DTrees_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_DTrees' or its derivative)");
    bool retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getUseSurrogates());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_DTrees_load_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    PyObject* pyobj_filepath = NULL;
    String filepath;
    PyObject* pyobj_nodeName = NULL;
    String nodeName;
    Ptr<DTrees> retval;

    const char* keywords[] = { "filepath", "nodeName", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:ml_DTrees.load", (char**)keywords, &pyobj_filepath, &pyobj_nodeName) &&
        pyopencv_to(pyobj_filepath, filepath, ArgInfo("filepath", 0)) &&
        pyopencv_to(pyobj_nodeName, nodeName, ArgInfo("nodeName", 0)) )
    {
        ERRWRAP2(retval = cv::ml::DTrees::load(filepath, nodeName));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_DTrees_setCVFolds(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::DTrees* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_DTrees_Type))
        _self_ = dynamic_cast<cv::ml::DTrees*>(((pyopencv_ml_DTrees_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_DTrees' or its derivative)");
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:ml_DTrees.setCVFolds", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setCVFolds(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_DTrees_setMaxCategories(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::DTrees* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_DTrees_Type))
        _self_ = dynamic_cast<cv::ml::DTrees*>(((pyopencv_ml_DTrees_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_DTrees' or its derivative)");
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:ml_DTrees.setMaxCategories", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setMaxCategories(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_DTrees_setMaxDepth(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::DTrees* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_DTrees_Type))
        _self_ = dynamic_cast<cv::ml::DTrees*>(((pyopencv_ml_DTrees_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_DTrees' or its derivative)");
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:ml_DTrees.setMaxDepth", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setMaxDepth(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_DTrees_setMinSampleCount(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::DTrees* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_DTrees_Type))
        _self_ = dynamic_cast<cv::ml::DTrees*>(((pyopencv_ml_DTrees_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_DTrees' or its derivative)");
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:ml_DTrees.setMinSampleCount", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setMinSampleCount(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_DTrees_setPriors(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::DTrees* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_DTrees_Type))
        _self_ = dynamic_cast<cv::ml::DTrees*>(((pyopencv_ml_DTrees_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_DTrees' or its derivative)");
    {
    PyObject* pyobj_val = NULL;
    Mat val;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:ml_DTrees.setPriors", (char**)keywords, &pyobj_val) &&
        pyopencv_to(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->setPriors(val));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_val = NULL;
    Mat val;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:ml_DTrees.setPriors", (char**)keywords, &pyobj_val) &&
        pyopencv_to(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->setPriors(val));
        Py_RETURN_NONE;
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_DTrees_setRegressionAccuracy(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::DTrees* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_DTrees_Type))
        _self_ = dynamic_cast<cv::ml::DTrees*>(((pyopencv_ml_DTrees_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_DTrees' or its derivative)");
    float val=0.f;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "f:ml_DTrees.setRegressionAccuracy", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setRegressionAccuracy(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_DTrees_setTruncatePrunedTree(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::DTrees* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_DTrees_Type))
        _self_ = dynamic_cast<cv::ml::DTrees*>(((pyopencv_ml_DTrees_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_DTrees' or its derivative)");
    bool val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "b:ml_DTrees.setTruncatePrunedTree", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setTruncatePrunedTree(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_DTrees_setUse1SERule(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::DTrees* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_DTrees_Type))
        _self_ = dynamic_cast<cv::ml::DTrees*>(((pyopencv_ml_DTrees_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_DTrees' or its derivative)");
    bool val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "b:ml_DTrees.setUse1SERule", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setUse1SERule(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_DTrees_setUseSurrogates(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::DTrees* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_DTrees_Type))
        _self_ = dynamic_cast<cv::ml::DTrees*>(((pyopencv_ml_DTrees_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_DTrees' or its derivative)");
    bool val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "b:ml_DTrees.setUseSurrogates", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setUseSurrogates(val));
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_ml_DTrees_methods[] =
{
    {"create", (PyCFunction)pyopencv_cv_ml_ml_DTrees_create_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "create() -> retval\n.   @brief Creates the empty model\n.   \n.   The static method creates empty decision tree with the specified parameters. It should be then\n.   trained using train method (see StatModel::train). Alternatively, you can load the model from\n.   file using Algorithm::load\\<DTrees\\>(filename)."},
    {"getCVFolds", (PyCFunction)pyopencv_cv_ml_ml_DTrees_getCVFolds, METH_VARARGS | METH_KEYWORDS, "getCVFolds() -> retval\n.   @see setCVFolds"},
    {"getMaxCategories", (PyCFunction)pyopencv_cv_ml_ml_DTrees_getMaxCategories, METH_VARARGS | METH_KEYWORDS, "getMaxCategories() -> retval\n.   @see setMaxCategories"},
    {"getMaxDepth", (PyCFunction)pyopencv_cv_ml_ml_DTrees_getMaxDepth, METH_VARARGS | METH_KEYWORDS, "getMaxDepth() -> retval\n.   @see setMaxDepth"},
    {"getMinSampleCount", (PyCFunction)pyopencv_cv_ml_ml_DTrees_getMinSampleCount, METH_VARARGS | METH_KEYWORDS, "getMinSampleCount() -> retval\n.   @see setMinSampleCount"},
    {"getPriors", (PyCFunction)pyopencv_cv_ml_ml_DTrees_getPriors, METH_VARARGS | METH_KEYWORDS, "getPriors() -> retval\n.   @see setPriors"},
    {"getRegressionAccuracy", (PyCFunction)pyopencv_cv_ml_ml_DTrees_getRegressionAccuracy, METH_VARARGS | METH_KEYWORDS, "getRegressionAccuracy() -> retval\n.   @see setRegressionAccuracy"},
    {"getTruncatePrunedTree", (PyCFunction)pyopencv_cv_ml_ml_DTrees_getTruncatePrunedTree, METH_VARARGS | METH_KEYWORDS, "getTruncatePrunedTree() -> retval\n.   @see setTruncatePrunedTree"},
    {"getUse1SERule", (PyCFunction)pyopencv_cv_ml_ml_DTrees_getUse1SERule, METH_VARARGS | METH_KEYWORDS, "getUse1SERule() -> retval\n.   @see setUse1SERule"},
    {"getUseSurrogates", (PyCFunction)pyopencv_cv_ml_ml_DTrees_getUseSurrogates, METH_VARARGS | METH_KEYWORDS, "getUseSurrogates() -> retval\n.   @see setUseSurrogates"},
    {"load", (PyCFunction)pyopencv_cv_ml_ml_DTrees_load_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "load(filepath[, nodeName]) -> retval\n.   @brief Loads and creates a serialized DTrees from a file\n.   *\n.   * Use DTree::save to serialize and store an DTree to disk.\n.   * Load the DTree from this file again, by calling this function with the path to the file.\n.   * Optionally specify the node for the file containing the classifier\n.   *\n.   * @param filepath path to serialized DTree\n.   * @param nodeName name of node containing the classifier"},
    {"setCVFolds", (PyCFunction)pyopencv_cv_ml_ml_DTrees_setCVFolds, METH_VARARGS | METH_KEYWORDS, "setCVFolds(val) -> None\n.   @copybrief getCVFolds @see getCVFolds"},
    {"setMaxCategories", (PyCFunction)pyopencv_cv_ml_ml_DTrees_setMaxCategories, METH_VARARGS | METH_KEYWORDS, "setMaxCategories(val) -> None\n.   @copybrief getMaxCategories @see getMaxCategories"},
    {"setMaxDepth", (PyCFunction)pyopencv_cv_ml_ml_DTrees_setMaxDepth, METH_VARARGS | METH_KEYWORDS, "setMaxDepth(val) -> None\n.   @copybrief getMaxDepth @see getMaxDepth"},
    {"setMinSampleCount", (PyCFunction)pyopencv_cv_ml_ml_DTrees_setMinSampleCount, METH_VARARGS | METH_KEYWORDS, "setMinSampleCount(val) -> None\n.   @copybrief getMinSampleCount @see getMinSampleCount"},
    {"setPriors", (PyCFunction)pyopencv_cv_ml_ml_DTrees_setPriors, METH_VARARGS | METH_KEYWORDS, "setPriors(val) -> None\n.   @copybrief getPriors @see getPriors"},
    {"setRegressionAccuracy", (PyCFunction)pyopencv_cv_ml_ml_DTrees_setRegressionAccuracy, METH_VARARGS | METH_KEYWORDS, "setRegressionAccuracy(val) -> None\n.   @copybrief getRegressionAccuracy @see getRegressionAccuracy"},
    {"setTruncatePrunedTree", (PyCFunction)pyopencv_cv_ml_ml_DTrees_setTruncatePrunedTree, METH_VARARGS | METH_KEYWORDS, "setTruncatePrunedTree(val) -> None\n.   @copybrief getTruncatePrunedTree @see getTruncatePrunedTree"},
    {"setUse1SERule", (PyCFunction)pyopencv_cv_ml_ml_DTrees_setUse1SERule, METH_VARARGS | METH_KEYWORDS, "setUse1SERule(val) -> None\n.   @copybrief getUse1SERule @see getUse1SERule"},
    {"setUseSurrogates", (PyCFunction)pyopencv_cv_ml_ml_DTrees_setUseSurrogates, METH_VARARGS | METH_KEYWORDS, "setUseSurrogates(val) -> None\n.   @copybrief getUseSurrogates @see getUseSurrogates"},

    {NULL,          NULL}
};

static void pyopencv_ml_DTrees_specials(void)
{
    pyopencv_ml_DTrees_Type.tp_base = &pyopencv_ml_StatModel_Type;
    pyopencv_ml_DTrees_Type.tp_dealloc = pyopencv_ml_DTrees_dealloc;
    pyopencv_ml_DTrees_Type.tp_repr = pyopencv_ml_DTrees_repr;
    pyopencv_ml_DTrees_Type.tp_getset = pyopencv_ml_DTrees_getseters;
    pyopencv_ml_DTrees_Type.tp_init = (initproc)0;
    pyopencv_ml_DTrees_Type.tp_methods = pyopencv_ml_DTrees_methods;
}

static PyObject* pyopencv_ml_RTrees_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<ml_RTrees %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_ml_RTrees_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_ml_ml_RTrees_create_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    Ptr<RTrees> retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = cv::ml::RTrees::create());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_RTrees_getActiveVarCount(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::RTrees* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_RTrees_Type))
        _self_ = dynamic_cast<cv::ml::RTrees*>(((pyopencv_ml_RTrees_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_RTrees' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getActiveVarCount());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_RTrees_getCalculateVarImportance(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::RTrees* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_RTrees_Type))
        _self_ = dynamic_cast<cv::ml::RTrees*>(((pyopencv_ml_RTrees_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_RTrees' or its derivative)");
    bool retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getCalculateVarImportance());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_RTrees_getTermCriteria(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::RTrees* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_RTrees_Type))
        _self_ = dynamic_cast<cv::ml::RTrees*>(((pyopencv_ml_RTrees_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_RTrees' or its derivative)");
    TermCriteria retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTermCriteria());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_RTrees_getVarImportance(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::RTrees* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_RTrees_Type))
        _self_ = dynamic_cast<cv::ml::RTrees*>(((pyopencv_ml_RTrees_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_RTrees' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getVarImportance());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_RTrees_getVotes(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::RTrees* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_RTrees_Type))
        _self_ = dynamic_cast<cv::ml::RTrees*>(((pyopencv_ml_RTrees_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_RTrees' or its derivative)");
    {
    PyObject* pyobj_samples = NULL;
    Mat samples;
    PyObject* pyobj_results = NULL;
    Mat results;
    int flags=0;

    const char* keywords[] = { "samples", "flags", "results", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "Oi|O:ml_RTrees.getVotes", (char**)keywords, &pyobj_samples, &flags, &pyobj_results) &&
        pyopencv_to(pyobj_samples, samples, ArgInfo("samples", 0)) &&
        pyopencv_to(pyobj_results, results, ArgInfo("results", 1)) )
    {
        ERRWRAP2(_self_->getVotes(samples, results, flags));
        return pyopencv_from(results);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_samples = NULL;
    UMat samples;
    PyObject* pyobj_results = NULL;
    UMat results;
    int flags=0;

    const char* keywords[] = { "samples", "flags", "results", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "Oi|O:ml_RTrees.getVotes", (char**)keywords, &pyobj_samples, &flags, &pyobj_results) &&
        pyopencv_to(pyobj_samples, samples, ArgInfo("samples", 0)) &&
        pyopencv_to(pyobj_results, results, ArgInfo("results", 1)) )
    {
        ERRWRAP2(_self_->getVotes(samples, results, flags));
        return pyopencv_from(results);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_RTrees_load_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    PyObject* pyobj_filepath = NULL;
    String filepath;
    PyObject* pyobj_nodeName = NULL;
    String nodeName;
    Ptr<RTrees> retval;

    const char* keywords[] = { "filepath", "nodeName", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:ml_RTrees.load", (char**)keywords, &pyobj_filepath, &pyobj_nodeName) &&
        pyopencv_to(pyobj_filepath, filepath, ArgInfo("filepath", 0)) &&
        pyopencv_to(pyobj_nodeName, nodeName, ArgInfo("nodeName", 0)) )
    {
        ERRWRAP2(retval = cv::ml::RTrees::load(filepath, nodeName));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_RTrees_setActiveVarCount(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::RTrees* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_RTrees_Type))
        _self_ = dynamic_cast<cv::ml::RTrees*>(((pyopencv_ml_RTrees_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_RTrees' or its derivative)");
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:ml_RTrees.setActiveVarCount", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setActiveVarCount(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_RTrees_setCalculateVarImportance(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::RTrees* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_RTrees_Type))
        _self_ = dynamic_cast<cv::ml::RTrees*>(((pyopencv_ml_RTrees_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_RTrees' or its derivative)");
    bool val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "b:ml_RTrees.setCalculateVarImportance", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setCalculateVarImportance(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_RTrees_setTermCriteria(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::RTrees* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_RTrees_Type))
        _self_ = dynamic_cast<cv::ml::RTrees*>(((pyopencv_ml_RTrees_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_RTrees' or its derivative)");
    PyObject* pyobj_val = NULL;
    TermCriteria val;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:ml_RTrees.setTermCriteria", (char**)keywords, &pyobj_val) &&
        pyopencv_to(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->setTermCriteria(val));
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_ml_RTrees_methods[] =
{
    {"create", (PyCFunction)pyopencv_cv_ml_ml_RTrees_create_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "create() -> retval\n.   Creates the empty model.\n.   Use StatModel::train to train the model, StatModel::train to create and train the model,\n.   Algorithm::load to load the pre-trained model."},
    {"getActiveVarCount", (PyCFunction)pyopencv_cv_ml_ml_RTrees_getActiveVarCount, METH_VARARGS | METH_KEYWORDS, "getActiveVarCount() -> retval\n.   @see setActiveVarCount"},
    {"getCalculateVarImportance", (PyCFunction)pyopencv_cv_ml_ml_RTrees_getCalculateVarImportance, METH_VARARGS | METH_KEYWORDS, "getCalculateVarImportance() -> retval\n.   @see setCalculateVarImportance"},
    {"getTermCriteria", (PyCFunction)pyopencv_cv_ml_ml_RTrees_getTermCriteria, METH_VARARGS | METH_KEYWORDS, "getTermCriteria() -> retval\n.   @see setTermCriteria"},
    {"getVarImportance", (PyCFunction)pyopencv_cv_ml_ml_RTrees_getVarImportance, METH_VARARGS | METH_KEYWORDS, "getVarImportance() -> retval\n.   Returns the variable importance array.\n.   The method returns the variable importance vector, computed at the training stage when\n.   CalculateVarImportance is set to true. If this flag was set to false, the empty matrix is\n.   returned."},
    {"getVotes", (PyCFunction)pyopencv_cv_ml_ml_RTrees_getVotes, METH_VARARGS | METH_KEYWORDS, "getVotes(samples, flags[, results]) -> results\n.   Returns the result of each individual tree in the forest.\n.   In case the model is a regression problem, the method will return each of the trees'\n.   results for each of the sample cases. If the model is a classifier, it will return\n.   a Mat with samples + 1 rows, where the first row gives the class number and the\n.   following rows return the votes each class had for each sample.\n.   @param samples Array containing the samples for which votes will be calculated.\n.   @param results Array where the result of the calculation will be written.\n.   @param flags Flags for defining the type of RTrees."},
    {"load", (PyCFunction)pyopencv_cv_ml_ml_RTrees_load_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "load(filepath[, nodeName]) -> retval\n.   @brief Loads and creates a serialized RTree from a file\n.   *\n.   * Use RTree::save to serialize and store an RTree to disk.\n.   * Load the RTree from this file again, by calling this function with the path to the file.\n.   * Optionally specify the node for the file containing the classifier\n.   *\n.   * @param filepath path to serialized RTree\n.   * @param nodeName name of node containing the classifier"},
    {"setActiveVarCount", (PyCFunction)pyopencv_cv_ml_ml_RTrees_setActiveVarCount, METH_VARARGS | METH_KEYWORDS, "setActiveVarCount(val) -> None\n.   @copybrief getActiveVarCount @see getActiveVarCount"},
    {"setCalculateVarImportance", (PyCFunction)pyopencv_cv_ml_ml_RTrees_setCalculateVarImportance, METH_VARARGS | METH_KEYWORDS, "setCalculateVarImportance(val) -> None\n.   @copybrief getCalculateVarImportance @see getCalculateVarImportance"},
    {"setTermCriteria", (PyCFunction)pyopencv_cv_ml_ml_RTrees_setTermCriteria, METH_VARARGS | METH_KEYWORDS, "setTermCriteria(val) -> None\n.   @copybrief getTermCriteria @see getTermCriteria"},

    {NULL,          NULL}
};

static void pyopencv_ml_RTrees_specials(void)
{
    pyopencv_ml_RTrees_Type.tp_base = &pyopencv_ml_DTrees_Type;
    pyopencv_ml_RTrees_Type.tp_dealloc = pyopencv_ml_RTrees_dealloc;
    pyopencv_ml_RTrees_Type.tp_repr = pyopencv_ml_RTrees_repr;
    pyopencv_ml_RTrees_Type.tp_getset = pyopencv_ml_RTrees_getseters;
    pyopencv_ml_RTrees_Type.tp_init = (initproc)0;
    pyopencv_ml_RTrees_Type.tp_methods = pyopencv_ml_RTrees_methods;
}

static PyObject* pyopencv_ml_Boost_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<ml_Boost %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_ml_Boost_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_ml_ml_Boost_create_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    Ptr<Boost> retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = cv::ml::Boost::create());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_Boost_getBoostType(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::Boost* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_Boost_Type))
        _self_ = dynamic_cast<cv::ml::Boost*>(((pyopencv_ml_Boost_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_Boost' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getBoostType());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_Boost_getWeakCount(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::Boost* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_Boost_Type))
        _self_ = dynamic_cast<cv::ml::Boost*>(((pyopencv_ml_Boost_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_Boost' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getWeakCount());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_Boost_getWeightTrimRate(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::Boost* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_Boost_Type))
        _self_ = dynamic_cast<cv::ml::Boost*>(((pyopencv_ml_Boost_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_Boost' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getWeightTrimRate());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_Boost_load_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    PyObject* pyobj_filepath = NULL;
    String filepath;
    PyObject* pyobj_nodeName = NULL;
    String nodeName;
    Ptr<Boost> retval;

    const char* keywords[] = { "filepath", "nodeName", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:ml_Boost.load", (char**)keywords, &pyobj_filepath, &pyobj_nodeName) &&
        pyopencv_to(pyobj_filepath, filepath, ArgInfo("filepath", 0)) &&
        pyopencv_to(pyobj_nodeName, nodeName, ArgInfo("nodeName", 0)) )
    {
        ERRWRAP2(retval = cv::ml::Boost::load(filepath, nodeName));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_Boost_setBoostType(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::Boost* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_Boost_Type))
        _self_ = dynamic_cast<cv::ml::Boost*>(((pyopencv_ml_Boost_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_Boost' or its derivative)");
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:ml_Boost.setBoostType", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setBoostType(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_Boost_setWeakCount(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::Boost* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_Boost_Type))
        _self_ = dynamic_cast<cv::ml::Boost*>(((pyopencv_ml_Boost_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_Boost' or its derivative)");
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:ml_Boost.setWeakCount", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setWeakCount(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_Boost_setWeightTrimRate(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::Boost* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_Boost_Type))
        _self_ = dynamic_cast<cv::ml::Boost*>(((pyopencv_ml_Boost_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_Boost' or its derivative)");
    double val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:ml_Boost.setWeightTrimRate", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setWeightTrimRate(val));
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_ml_Boost_methods[] =
{
    {"create", (PyCFunction)pyopencv_cv_ml_ml_Boost_create_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "create() -> retval\n.   Creates the empty model.\n.   Use StatModel::train to train the model, Algorithm::load\\<Boost\\>(filename) to load the pre-trained model."},
    {"getBoostType", (PyCFunction)pyopencv_cv_ml_ml_Boost_getBoostType, METH_VARARGS | METH_KEYWORDS, "getBoostType() -> retval\n.   @see setBoostType"},
    {"getWeakCount", (PyCFunction)pyopencv_cv_ml_ml_Boost_getWeakCount, METH_VARARGS | METH_KEYWORDS, "getWeakCount() -> retval\n.   @see setWeakCount"},
    {"getWeightTrimRate", (PyCFunction)pyopencv_cv_ml_ml_Boost_getWeightTrimRate, METH_VARARGS | METH_KEYWORDS, "getWeightTrimRate() -> retval\n.   @see setWeightTrimRate"},
    {"load", (PyCFunction)pyopencv_cv_ml_ml_Boost_load_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "load(filepath[, nodeName]) -> retval\n.   @brief Loads and creates a serialized Boost from a file\n.   *\n.   * Use Boost::save to serialize and store an RTree to disk.\n.   * Load the Boost from this file again, by calling this function with the path to the file.\n.   * Optionally specify the node for the file containing the classifier\n.   *\n.   * @param filepath path to serialized Boost\n.   * @param nodeName name of node containing the classifier"},
    {"setBoostType", (PyCFunction)pyopencv_cv_ml_ml_Boost_setBoostType, METH_VARARGS | METH_KEYWORDS, "setBoostType(val) -> None\n.   @copybrief getBoostType @see getBoostType"},
    {"setWeakCount", (PyCFunction)pyopencv_cv_ml_ml_Boost_setWeakCount, METH_VARARGS | METH_KEYWORDS, "setWeakCount(val) -> None\n.   @copybrief getWeakCount @see getWeakCount"},
    {"setWeightTrimRate", (PyCFunction)pyopencv_cv_ml_ml_Boost_setWeightTrimRate, METH_VARARGS | METH_KEYWORDS, "setWeightTrimRate(val) -> None\n.   @copybrief getWeightTrimRate @see getWeightTrimRate"},

    {NULL,          NULL}
};

static void pyopencv_ml_Boost_specials(void)
{
    pyopencv_ml_Boost_Type.tp_base = &pyopencv_ml_DTrees_Type;
    pyopencv_ml_Boost_Type.tp_dealloc = pyopencv_ml_Boost_dealloc;
    pyopencv_ml_Boost_Type.tp_repr = pyopencv_ml_Boost_repr;
    pyopencv_ml_Boost_Type.tp_getset = pyopencv_ml_Boost_getseters;
    pyopencv_ml_Boost_Type.tp_init = (initproc)0;
    pyopencv_ml_Boost_Type.tp_methods = pyopencv_ml_Boost_methods;
}

static PyObject* pyopencv_ml_ANN_MLP_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<ml_ANN_MLP %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_ml_ANN_MLP_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_create_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    Ptr<ANN_MLP> retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = cv::ml::ANN_MLP::create());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_getAnnealCoolingRatio(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getAnnealCoolingRatio());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_getAnnealFinalT(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getAnnealFinalT());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_getAnnealInitialT(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getAnnealInitialT());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_getAnnealItePerStep(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getAnnealItePerStep());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_getBackpropMomentumScale(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getBackpropMomentumScale());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_getBackpropWeightScale(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getBackpropWeightScale());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_getLayerSizes(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    cv::Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getLayerSizes());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_getRpropDW0(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getRpropDW0());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_getRpropDWMax(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getRpropDWMax());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_getRpropDWMin(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getRpropDWMin());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_getRpropDWMinus(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getRpropDWMinus());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_getRpropDWPlus(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getRpropDWPlus());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_getTermCriteria(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    TermCriteria retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTermCriteria());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_getTrainMethod(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTrainMethod());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_getWeights(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    int layerIdx=0;
    Mat retval;

    const char* keywords[] = { "layerIdx", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:ml_ANN_MLP.getWeights", (char**)keywords, &layerIdx) )
    {
        ERRWRAP2(retval = _self_->getWeights(layerIdx));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_load_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    PyObject* pyobj_filepath = NULL;
    String filepath;
    Ptr<ANN_MLP> retval;

    const char* keywords[] = { "filepath", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:ml_ANN_MLP.load", (char**)keywords, &pyobj_filepath) &&
        pyopencv_to(pyobj_filepath, filepath, ArgInfo("filepath", 0)) )
    {
        ERRWRAP2(retval = cv::ml::ANN_MLP::load(filepath));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_setActivationFunction(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    int type=0;
    double param1=0;
    double param2=0;

    const char* keywords[] = { "type", "param1", "param2", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i|dd:ml_ANN_MLP.setActivationFunction", (char**)keywords, &type, &param1, &param2) )
    {
        ERRWRAP2(_self_->setActivationFunction(type, param1, param2));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_setAnnealCoolingRatio(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    double val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:ml_ANN_MLP.setAnnealCoolingRatio", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setAnnealCoolingRatio(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_setAnnealFinalT(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    double val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:ml_ANN_MLP.setAnnealFinalT", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setAnnealFinalT(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_setAnnealInitialT(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    double val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:ml_ANN_MLP.setAnnealInitialT", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setAnnealInitialT(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_setAnnealItePerStep(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:ml_ANN_MLP.setAnnealItePerStep", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setAnnealItePerStep(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_setBackpropMomentumScale(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    double val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:ml_ANN_MLP.setBackpropMomentumScale", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setBackpropMomentumScale(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_setBackpropWeightScale(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    double val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:ml_ANN_MLP.setBackpropWeightScale", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setBackpropWeightScale(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_setLayerSizes(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    {
    PyObject* pyobj__layer_sizes = NULL;
    Mat _layer_sizes;

    const char* keywords[] = { "_layer_sizes", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:ml_ANN_MLP.setLayerSizes", (char**)keywords, &pyobj__layer_sizes) &&
        pyopencv_to(pyobj__layer_sizes, _layer_sizes, ArgInfo("_layer_sizes", 0)) )
    {
        ERRWRAP2(_self_->setLayerSizes(_layer_sizes));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj__layer_sizes = NULL;
    UMat _layer_sizes;

    const char* keywords[] = { "_layer_sizes", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:ml_ANN_MLP.setLayerSizes", (char**)keywords, &pyobj__layer_sizes) &&
        pyopencv_to(pyobj__layer_sizes, _layer_sizes, ArgInfo("_layer_sizes", 0)) )
    {
        ERRWRAP2(_self_->setLayerSizes(_layer_sizes));
        Py_RETURN_NONE;
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_setRpropDW0(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    double val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:ml_ANN_MLP.setRpropDW0", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setRpropDW0(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_setRpropDWMax(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    double val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:ml_ANN_MLP.setRpropDWMax", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setRpropDWMax(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_setRpropDWMin(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    double val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:ml_ANN_MLP.setRpropDWMin", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setRpropDWMin(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_setRpropDWMinus(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    double val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:ml_ANN_MLP.setRpropDWMinus", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setRpropDWMinus(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_setRpropDWPlus(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    double val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:ml_ANN_MLP.setRpropDWPlus", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setRpropDWPlus(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_setTermCriteria(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    PyObject* pyobj_val = NULL;
    TermCriteria val;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:ml_ANN_MLP.setTermCriteria", (char**)keywords, &pyobj_val) &&
        pyopencv_to(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->setTermCriteria(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_setTrainMethod(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP*>(((pyopencv_ml_ANN_MLP_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP' or its derivative)");
    int method=0;
    double param1=0;
    double param2=0;

    const char* keywords[] = { "method", "param1", "param2", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i|dd:ml_ANN_MLP.setTrainMethod", (char**)keywords, &method, &param1, &param2) )
    {
        ERRWRAP2(_self_->setTrainMethod(method, param1, param2));
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_ml_ANN_MLP_methods[] =
{
    {"create", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_create_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "create() -> retval\n.   @brief Creates empty model\n.   \n.   Use StatModel::train to train the model, Algorithm::load\\<ANN_MLP\\>(filename) to load the pre-trained model.\n.   Note that the train method has optional flags: ANN_MLP::TrainFlags."},
    {"getAnnealCoolingRatio", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_getAnnealCoolingRatio, METH_VARARGS | METH_KEYWORDS, "getAnnealCoolingRatio() -> retval\n.   @see setAnnealCoolingRatio"},
    {"getAnnealFinalT", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_getAnnealFinalT, METH_VARARGS | METH_KEYWORDS, "getAnnealFinalT() -> retval\n.   @see setAnnealFinalT"},
    {"getAnnealInitialT", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_getAnnealInitialT, METH_VARARGS | METH_KEYWORDS, "getAnnealInitialT() -> retval\n.   @see setAnnealInitialT"},
    {"getAnnealItePerStep", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_getAnnealItePerStep, METH_VARARGS | METH_KEYWORDS, "getAnnealItePerStep() -> retval\n.   @see setAnnealItePerStep"},
    {"getBackpropMomentumScale", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_getBackpropMomentumScale, METH_VARARGS | METH_KEYWORDS, "getBackpropMomentumScale() -> retval\n.   @see setBackpropMomentumScale"},
    {"getBackpropWeightScale", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_getBackpropWeightScale, METH_VARARGS | METH_KEYWORDS, "getBackpropWeightScale() -> retval\n.   @see setBackpropWeightScale"},
    {"getLayerSizes", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_getLayerSizes, METH_VARARGS | METH_KEYWORDS, "getLayerSizes() -> retval\n.   Integer vector specifying the number of neurons in each layer including the input and output layers.\n.   The very first element specifies the number of elements in the input layer.\n.   The last element - number of elements in the output layer.\n.   @sa setLayerSizes"},
    {"getRpropDW0", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_getRpropDW0, METH_VARARGS | METH_KEYWORDS, "getRpropDW0() -> retval\n.   @see setRpropDW0"},
    {"getRpropDWMax", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_getRpropDWMax, METH_VARARGS | METH_KEYWORDS, "getRpropDWMax() -> retval\n.   @see setRpropDWMax"},
    {"getRpropDWMin", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_getRpropDWMin, METH_VARARGS | METH_KEYWORDS, "getRpropDWMin() -> retval\n.   @see setRpropDWMin"},
    {"getRpropDWMinus", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_getRpropDWMinus, METH_VARARGS | METH_KEYWORDS, "getRpropDWMinus() -> retval\n.   @see setRpropDWMinus"},
    {"getRpropDWPlus", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_getRpropDWPlus, METH_VARARGS | METH_KEYWORDS, "getRpropDWPlus() -> retval\n.   @see setRpropDWPlus"},
    {"getTermCriteria", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_getTermCriteria, METH_VARARGS | METH_KEYWORDS, "getTermCriteria() -> retval\n.   @see setTermCriteria"},
    {"getTrainMethod", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_getTrainMethod, METH_VARARGS | METH_KEYWORDS, "getTrainMethod() -> retval\n.   Returns current training method"},
    {"getWeights", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_getWeights, METH_VARARGS | METH_KEYWORDS, "getWeights(layerIdx) -> retval\n."},
    {"load", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_load_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "load(filepath) -> retval\n.   @brief Loads and creates a serialized ANN from a file\n.   *\n.   * Use ANN::save to serialize and store an ANN to disk.\n.   * Load the ANN from this file again, by calling this function with the path to the file.\n.   *\n.   * @param filepath path to serialized ANN"},
    {"setActivationFunction", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_setActivationFunction, METH_VARARGS | METH_KEYWORDS, "setActivationFunction(type[, param1[, param2]]) -> None\n.   Initialize the activation function for each neuron.\n.   Currently the default and the only fully supported activation function is ANN_MLP::SIGMOID_SYM.\n.   @param type The type of activation function. See ANN_MLP::ActivationFunctions.\n.   @param param1 The first parameter of the activation function, \\f$\\alpha\\f$. Default value is 0.\n.   @param param2 The second parameter of the activation function, \\f$\\beta\\f$. Default value is 0."},
    {"setAnnealCoolingRatio", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_setAnnealCoolingRatio, METH_VARARGS | METH_KEYWORDS, "setAnnealCoolingRatio(val) -> None\n.   @copybrief getAnnealCoolingRatio @see getAnnealCoolingRatio"},
    {"setAnnealFinalT", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_setAnnealFinalT, METH_VARARGS | METH_KEYWORDS, "setAnnealFinalT(val) -> None\n.   @copybrief getAnnealFinalT @see getAnnealFinalT"},
    {"setAnnealInitialT", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_setAnnealInitialT, METH_VARARGS | METH_KEYWORDS, "setAnnealInitialT(val) -> None\n.   @copybrief getAnnealInitialT @see getAnnealInitialT"},
    {"setAnnealItePerStep", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_setAnnealItePerStep, METH_VARARGS | METH_KEYWORDS, "setAnnealItePerStep(val) -> None\n.   @copybrief getAnnealItePerStep @see getAnnealItePerStep"},
    {"setBackpropMomentumScale", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_setBackpropMomentumScale, METH_VARARGS | METH_KEYWORDS, "setBackpropMomentumScale(val) -> None\n.   @copybrief getBackpropMomentumScale @see getBackpropMomentumScale"},
    {"setBackpropWeightScale", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_setBackpropWeightScale, METH_VARARGS | METH_KEYWORDS, "setBackpropWeightScale(val) -> None\n.   @copybrief getBackpropWeightScale @see getBackpropWeightScale"},
    {"setLayerSizes", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_setLayerSizes, METH_VARARGS | METH_KEYWORDS, "setLayerSizes(_layer_sizes) -> None\n.   Integer vector specifying the number of neurons in each layer including the input and output layers.\n.   The very first element specifies the number of elements in the input layer.\n.   The last element - number of elements in the output layer. Default value is empty Mat.\n.   @sa getLayerSizes"},
    {"setRpropDW0", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_setRpropDW0, METH_VARARGS | METH_KEYWORDS, "setRpropDW0(val) -> None\n.   @copybrief getRpropDW0 @see getRpropDW0"},
    {"setRpropDWMax", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_setRpropDWMax, METH_VARARGS | METH_KEYWORDS, "setRpropDWMax(val) -> None\n.   @copybrief getRpropDWMax @see getRpropDWMax"},
    {"setRpropDWMin", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_setRpropDWMin, METH_VARARGS | METH_KEYWORDS, "setRpropDWMin(val) -> None\n.   @copybrief getRpropDWMin @see getRpropDWMin"},
    {"setRpropDWMinus", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_setRpropDWMinus, METH_VARARGS | METH_KEYWORDS, "setRpropDWMinus(val) -> None\n.   @copybrief getRpropDWMinus @see getRpropDWMinus"},
    {"setRpropDWPlus", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_setRpropDWPlus, METH_VARARGS | METH_KEYWORDS, "setRpropDWPlus(val) -> None\n.   @copybrief getRpropDWPlus @see getRpropDWPlus"},
    {"setTermCriteria", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_setTermCriteria, METH_VARARGS | METH_KEYWORDS, "setTermCriteria(val) -> None\n.   @copybrief getTermCriteria @see getTermCriteria"},
    {"setTrainMethod", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_setTrainMethod, METH_VARARGS | METH_KEYWORDS, "setTrainMethod(method[, param1[, param2]]) -> None\n.   Sets training method and common parameters.\n.   @param method Default value is ANN_MLP::RPROP. See ANN_MLP::TrainingMethods.\n.   @param param1 passed to setRpropDW0 for ANN_MLP::RPROP and to setBackpropWeightScale for ANN_MLP::BACKPROP and to initialT for ANN_MLP::ANNEAL.\n.   @param param2 passed to setRpropDWMin for ANN_MLP::RPROP and to setBackpropMomentumScale for ANN_MLP::BACKPROP and to finalT for ANN_MLP::ANNEAL."},

    {NULL,          NULL}
};

static void pyopencv_ml_ANN_MLP_specials(void)
{
    pyopencv_ml_ANN_MLP_Type.tp_base = &pyopencv_ml_StatModel_Type;
    pyopencv_ml_ANN_MLP_Type.tp_dealloc = pyopencv_ml_ANN_MLP_dealloc;
    pyopencv_ml_ANN_MLP_Type.tp_repr = pyopencv_ml_ANN_MLP_repr;
    pyopencv_ml_ANN_MLP_Type.tp_getset = pyopencv_ml_ANN_MLP_getseters;
    pyopencv_ml_ANN_MLP_Type.tp_init = (initproc)0;
    pyopencv_ml_ANN_MLP_Type.tp_methods = pyopencv_ml_ANN_MLP_methods;
}

static PyObject* pyopencv_ml_LogisticRegression_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<ml_LogisticRegression %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_ml_LogisticRegression_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_ml_ml_LogisticRegression_create_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    Ptr<LogisticRegression> retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = cv::ml::LogisticRegression::create());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_LogisticRegression_getIterations(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::LogisticRegression* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_LogisticRegression_Type))
        _self_ = dynamic_cast<cv::ml::LogisticRegression*>(((pyopencv_ml_LogisticRegression_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_LogisticRegression' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getIterations());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_LogisticRegression_getLearningRate(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::LogisticRegression* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_LogisticRegression_Type))
        _self_ = dynamic_cast<cv::ml::LogisticRegression*>(((pyopencv_ml_LogisticRegression_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_LogisticRegression' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getLearningRate());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_LogisticRegression_getMiniBatchSize(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::LogisticRegression* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_LogisticRegression_Type))
        _self_ = dynamic_cast<cv::ml::LogisticRegression*>(((pyopencv_ml_LogisticRegression_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_LogisticRegression' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMiniBatchSize());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_LogisticRegression_getRegularization(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::LogisticRegression* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_LogisticRegression_Type))
        _self_ = dynamic_cast<cv::ml::LogisticRegression*>(((pyopencv_ml_LogisticRegression_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_LogisticRegression' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getRegularization());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_LogisticRegression_getTermCriteria(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::LogisticRegression* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_LogisticRegression_Type))
        _self_ = dynamic_cast<cv::ml::LogisticRegression*>(((pyopencv_ml_LogisticRegression_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_LogisticRegression' or its derivative)");
    TermCriteria retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTermCriteria());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_LogisticRegression_getTrainMethod(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::LogisticRegression* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_LogisticRegression_Type))
        _self_ = dynamic_cast<cv::ml::LogisticRegression*>(((pyopencv_ml_LogisticRegression_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_LogisticRegression' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTrainMethod());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_LogisticRegression_get_learnt_thetas(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::LogisticRegression* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_LogisticRegression_Type))
        _self_ = dynamic_cast<cv::ml::LogisticRegression*>(((pyopencv_ml_LogisticRegression_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_LogisticRegression' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->get_learnt_thetas());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_LogisticRegression_load_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    PyObject* pyobj_filepath = NULL;
    String filepath;
    PyObject* pyobj_nodeName = NULL;
    String nodeName;
    Ptr<LogisticRegression> retval;

    const char* keywords[] = { "filepath", "nodeName", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:ml_LogisticRegression.load", (char**)keywords, &pyobj_filepath, &pyobj_nodeName) &&
        pyopencv_to(pyobj_filepath, filepath, ArgInfo("filepath", 0)) &&
        pyopencv_to(pyobj_nodeName, nodeName, ArgInfo("nodeName", 0)) )
    {
        ERRWRAP2(retval = cv::ml::LogisticRegression::load(filepath, nodeName));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_LogisticRegression_predict(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::LogisticRegression* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_LogisticRegression_Type))
        _self_ = dynamic_cast<cv::ml::LogisticRegression*>(((pyopencv_ml_LogisticRegression_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_LogisticRegression' or its derivative)");
    {
    PyObject* pyobj_samples = NULL;
    Mat samples;
    PyObject* pyobj_results = NULL;
    Mat results;
    int flags=0;
    float retval;

    const char* keywords[] = { "samples", "results", "flags", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|Oi:ml_LogisticRegression.predict", (char**)keywords, &pyobj_samples, &pyobj_results, &flags) &&
        pyopencv_to(pyobj_samples, samples, ArgInfo("samples", 0)) &&
        pyopencv_to(pyobj_results, results, ArgInfo("results", 1)) )
    {
        ERRWRAP2(retval = _self_->predict(samples, results, flags));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(results));
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_samples = NULL;
    UMat samples;
    PyObject* pyobj_results = NULL;
    UMat results;
    int flags=0;
    float retval;

    const char* keywords[] = { "samples", "results", "flags", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|Oi:ml_LogisticRegression.predict", (char**)keywords, &pyobj_samples, &pyobj_results, &flags) &&
        pyopencv_to(pyobj_samples, samples, ArgInfo("samples", 0)) &&
        pyopencv_to(pyobj_results, results, ArgInfo("results", 1)) )
    {
        ERRWRAP2(retval = _self_->predict(samples, results, flags));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(results));
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_LogisticRegression_setIterations(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::LogisticRegression* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_LogisticRegression_Type))
        _self_ = dynamic_cast<cv::ml::LogisticRegression*>(((pyopencv_ml_LogisticRegression_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_LogisticRegression' or its derivative)");
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:ml_LogisticRegression.setIterations", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setIterations(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_LogisticRegression_setLearningRate(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::LogisticRegression* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_LogisticRegression_Type))
        _self_ = dynamic_cast<cv::ml::LogisticRegression*>(((pyopencv_ml_LogisticRegression_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_LogisticRegression' or its derivative)");
    double val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:ml_LogisticRegression.setLearningRate", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setLearningRate(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_LogisticRegression_setMiniBatchSize(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::LogisticRegression* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_LogisticRegression_Type))
        _self_ = dynamic_cast<cv::ml::LogisticRegression*>(((pyopencv_ml_LogisticRegression_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_LogisticRegression' or its derivative)");
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:ml_LogisticRegression.setMiniBatchSize", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setMiniBatchSize(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_LogisticRegression_setRegularization(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::LogisticRegression* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_LogisticRegression_Type))
        _self_ = dynamic_cast<cv::ml::LogisticRegression*>(((pyopencv_ml_LogisticRegression_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_LogisticRegression' or its derivative)");
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:ml_LogisticRegression.setRegularization", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setRegularization(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_LogisticRegression_setTermCriteria(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::LogisticRegression* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_LogisticRegression_Type))
        _self_ = dynamic_cast<cv::ml::LogisticRegression*>(((pyopencv_ml_LogisticRegression_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_LogisticRegression' or its derivative)");
    PyObject* pyobj_val = NULL;
    TermCriteria val;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:ml_LogisticRegression.setTermCriteria", (char**)keywords, &pyobj_val) &&
        pyopencv_to(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->setTermCriteria(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_LogisticRegression_setTrainMethod(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::LogisticRegression* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_LogisticRegression_Type))
        _self_ = dynamic_cast<cv::ml::LogisticRegression*>(((pyopencv_ml_LogisticRegression_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_LogisticRegression' or its derivative)");
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:ml_LogisticRegression.setTrainMethod", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setTrainMethod(val));
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_ml_LogisticRegression_methods[] =
{
    {"create", (PyCFunction)pyopencv_cv_ml_ml_LogisticRegression_create_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "create() -> retval\n.   @brief Creates empty model.\n.   \n.   Creates Logistic Regression model with parameters given."},
    {"getIterations", (PyCFunction)pyopencv_cv_ml_ml_LogisticRegression_getIterations, METH_VARARGS | METH_KEYWORDS, "getIterations() -> retval\n.   @see setIterations"},
    {"getLearningRate", (PyCFunction)pyopencv_cv_ml_ml_LogisticRegression_getLearningRate, METH_VARARGS | METH_KEYWORDS, "getLearningRate() -> retval\n.   @see setLearningRate"},
    {"getMiniBatchSize", (PyCFunction)pyopencv_cv_ml_ml_LogisticRegression_getMiniBatchSize, METH_VARARGS | METH_KEYWORDS, "getMiniBatchSize() -> retval\n.   @see setMiniBatchSize"},
    {"getRegularization", (PyCFunction)pyopencv_cv_ml_ml_LogisticRegression_getRegularization, METH_VARARGS | METH_KEYWORDS, "getRegularization() -> retval\n.   @see setRegularization"},
    {"getTermCriteria", (PyCFunction)pyopencv_cv_ml_ml_LogisticRegression_getTermCriteria, METH_VARARGS | METH_KEYWORDS, "getTermCriteria() -> retval\n.   @see setTermCriteria"},
    {"getTrainMethod", (PyCFunction)pyopencv_cv_ml_ml_LogisticRegression_getTrainMethod, METH_VARARGS | METH_KEYWORDS, "getTrainMethod() -> retval\n.   @see setTrainMethod"},
    {"get_learnt_thetas", (PyCFunction)pyopencv_cv_ml_ml_LogisticRegression_get_learnt_thetas, METH_VARARGS | METH_KEYWORDS, "get_learnt_thetas() -> retval\n.   @brief This function returns the trained parameters arranged across rows.\n.   \n.   For a two class classifcation problem, it returns a row matrix. It returns learnt parameters of\n.   the Logistic Regression as a matrix of type CV_32F."},
    {"load", (PyCFunction)pyopencv_cv_ml_ml_LogisticRegression_load_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "load(filepath[, nodeName]) -> retval\n.   @brief Loads and creates a serialized LogisticRegression from a file\n.   *\n.   * Use LogisticRegression::save to serialize and store an LogisticRegression to disk.\n.   * Load the LogisticRegression from this file again, by calling this function with the path to the file.\n.   * Optionally specify the node for the file containing the classifier\n.   *\n.   * @param filepath path to serialized LogisticRegression\n.   * @param nodeName name of node containing the classifier"},
    {"predict", (PyCFunction)pyopencv_cv_ml_ml_LogisticRegression_predict, METH_VARARGS | METH_KEYWORDS, "predict(samples[, results[, flags]]) -> retval, results\n.   @brief Predicts responses for input samples and returns a float type.\n.   \n.   @param samples The input data for the prediction algorithm. Matrix [m x n], where each row\n.   contains variables (features) of one object being classified. Should have data type CV_32F.\n.   @param results Predicted labels as a column matrix of type CV_32S.\n.   @param flags Not used."},
    {"setIterations", (PyCFunction)pyopencv_cv_ml_ml_LogisticRegression_setIterations, METH_VARARGS | METH_KEYWORDS, "setIterations(val) -> None\n.   @copybrief getIterations @see getIterations"},
    {"setLearningRate", (PyCFunction)pyopencv_cv_ml_ml_LogisticRegression_setLearningRate, METH_VARARGS | METH_KEYWORDS, "setLearningRate(val) -> None\n.   @copybrief getLearningRate @see getLearningRate"},
    {"setMiniBatchSize", (PyCFunction)pyopencv_cv_ml_ml_LogisticRegression_setMiniBatchSize, METH_VARARGS | METH_KEYWORDS, "setMiniBatchSize(val) -> None\n.   @copybrief getMiniBatchSize @see getMiniBatchSize"},
    {"setRegularization", (PyCFunction)pyopencv_cv_ml_ml_LogisticRegression_setRegularization, METH_VARARGS | METH_KEYWORDS, "setRegularization(val) -> None\n.   @copybrief getRegularization @see getRegularization"},
    {"setTermCriteria", (PyCFunction)pyopencv_cv_ml_ml_LogisticRegression_setTermCriteria, METH_VARARGS | METH_KEYWORDS, "setTermCriteria(val) -> None\n.   @copybrief getTermCriteria @see getTermCriteria"},
    {"setTrainMethod", (PyCFunction)pyopencv_cv_ml_ml_LogisticRegression_setTrainMethod, METH_VARARGS | METH_KEYWORDS, "setTrainMethod(val) -> None\n.   @copybrief getTrainMethod @see getTrainMethod"},

    {NULL,          NULL}
};

static void pyopencv_ml_LogisticRegression_specials(void)
{
    pyopencv_ml_LogisticRegression_Type.tp_base = &pyopencv_ml_StatModel_Type;
    pyopencv_ml_LogisticRegression_Type.tp_dealloc = pyopencv_ml_LogisticRegression_dealloc;
    pyopencv_ml_LogisticRegression_Type.tp_repr = pyopencv_ml_LogisticRegression_repr;
    pyopencv_ml_LogisticRegression_Type.tp_getset = pyopencv_ml_LogisticRegression_getseters;
    pyopencv_ml_LogisticRegression_Type.tp_init = (initproc)0;
    pyopencv_ml_LogisticRegression_Type.tp_methods = pyopencv_ml_LogisticRegression_methods;
}

static PyObject* pyopencv_ml_SVMSGD_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<ml_SVMSGD %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_ml_SVMSGD_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_ml_ml_SVMSGD_create_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    Ptr<SVMSGD> retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = cv::ml::SVMSGD::create());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVMSGD_getInitialStepSize(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVMSGD* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVMSGD_Type))
        _self_ = dynamic_cast<cv::ml::SVMSGD*>(((pyopencv_ml_SVMSGD_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVMSGD' or its derivative)");
    float retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getInitialStepSize());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVMSGD_getMarginRegularization(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVMSGD* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVMSGD_Type))
        _self_ = dynamic_cast<cv::ml::SVMSGD*>(((pyopencv_ml_SVMSGD_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVMSGD' or its derivative)");
    float retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMarginRegularization());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVMSGD_getMarginType(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVMSGD* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVMSGD_Type))
        _self_ = dynamic_cast<cv::ml::SVMSGD*>(((pyopencv_ml_SVMSGD_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVMSGD' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMarginType());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVMSGD_getShift(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVMSGD* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVMSGD_Type))
        _self_ = dynamic_cast<cv::ml::SVMSGD*>(((pyopencv_ml_SVMSGD_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVMSGD' or its derivative)");
    float retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getShift());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVMSGD_getStepDecreasingPower(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVMSGD* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVMSGD_Type))
        _self_ = dynamic_cast<cv::ml::SVMSGD*>(((pyopencv_ml_SVMSGD_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVMSGD' or its derivative)");
    float retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getStepDecreasingPower());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVMSGD_getSvmsgdType(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVMSGD* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVMSGD_Type))
        _self_ = dynamic_cast<cv::ml::SVMSGD*>(((pyopencv_ml_SVMSGD_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVMSGD' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getSvmsgdType());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVMSGD_getTermCriteria(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVMSGD* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVMSGD_Type))
        _self_ = dynamic_cast<cv::ml::SVMSGD*>(((pyopencv_ml_SVMSGD_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVMSGD' or its derivative)");
    TermCriteria retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTermCriteria());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVMSGD_getWeights(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVMSGD* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVMSGD_Type))
        _self_ = dynamic_cast<cv::ml::SVMSGD*>(((pyopencv_ml_SVMSGD_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVMSGD' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getWeights());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVMSGD_load_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    PyObject* pyobj_filepath = NULL;
    String filepath;
    PyObject* pyobj_nodeName = NULL;
    String nodeName;
    Ptr<SVMSGD> retval;

    const char* keywords[] = { "filepath", "nodeName", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:ml_SVMSGD.load", (char**)keywords, &pyobj_filepath, &pyobj_nodeName) &&
        pyopencv_to(pyobj_filepath, filepath, ArgInfo("filepath", 0)) &&
        pyopencv_to(pyobj_nodeName, nodeName, ArgInfo("nodeName", 0)) )
    {
        ERRWRAP2(retval = cv::ml::SVMSGD::load(filepath, nodeName));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVMSGD_setInitialStepSize(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVMSGD* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVMSGD_Type))
        _self_ = dynamic_cast<cv::ml::SVMSGD*>(((pyopencv_ml_SVMSGD_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVMSGD' or its derivative)");
    float InitialStepSize=0.f;

    const char* keywords[] = { "InitialStepSize", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "f:ml_SVMSGD.setInitialStepSize", (char**)keywords, &InitialStepSize) )
    {
        ERRWRAP2(_self_->setInitialStepSize(InitialStepSize));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVMSGD_setMarginRegularization(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVMSGD* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVMSGD_Type))
        _self_ = dynamic_cast<cv::ml::SVMSGD*>(((pyopencv_ml_SVMSGD_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVMSGD' or its derivative)");
    float marginRegularization=0.f;

    const char* keywords[] = { "marginRegularization", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "f:ml_SVMSGD.setMarginRegularization", (char**)keywords, &marginRegularization) )
    {
        ERRWRAP2(_self_->setMarginRegularization(marginRegularization));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVMSGD_setMarginType(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVMSGD* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVMSGD_Type))
        _self_ = dynamic_cast<cv::ml::SVMSGD*>(((pyopencv_ml_SVMSGD_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVMSGD' or its derivative)");
    int marginType=0;

    const char* keywords[] = { "marginType", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:ml_SVMSGD.setMarginType", (char**)keywords, &marginType) )
    {
        ERRWRAP2(_self_->setMarginType(marginType));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVMSGD_setOptimalParameters(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVMSGD* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVMSGD_Type))
        _self_ = dynamic_cast<cv::ml::SVMSGD*>(((pyopencv_ml_SVMSGD_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVMSGD' or its derivative)");
    int svmsgdType=SVMSGD::ASGD;
    int marginType=SVMSGD::SOFT_MARGIN;

    const char* keywords[] = { "svmsgdType", "marginType", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "|ii:ml_SVMSGD.setOptimalParameters", (char**)keywords, &svmsgdType, &marginType) )
    {
        ERRWRAP2(_self_->setOptimalParameters(svmsgdType, marginType));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVMSGD_setStepDecreasingPower(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVMSGD* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVMSGD_Type))
        _self_ = dynamic_cast<cv::ml::SVMSGD*>(((pyopencv_ml_SVMSGD_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVMSGD' or its derivative)");
    float stepDecreasingPower=0.f;

    const char* keywords[] = { "stepDecreasingPower", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "f:ml_SVMSGD.setStepDecreasingPower", (char**)keywords, &stepDecreasingPower) )
    {
        ERRWRAP2(_self_->setStepDecreasingPower(stepDecreasingPower));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVMSGD_setSvmsgdType(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVMSGD* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVMSGD_Type))
        _self_ = dynamic_cast<cv::ml::SVMSGD*>(((pyopencv_ml_SVMSGD_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVMSGD' or its derivative)");
    int svmsgdType=0;

    const char* keywords[] = { "svmsgdType", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:ml_SVMSGD.setSvmsgdType", (char**)keywords, &svmsgdType) )
    {
        ERRWRAP2(_self_->setSvmsgdType(svmsgdType));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_SVMSGD_setTermCriteria(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::SVMSGD* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_SVMSGD_Type))
        _self_ = dynamic_cast<cv::ml::SVMSGD*>(((pyopencv_ml_SVMSGD_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_SVMSGD' or its derivative)");
    PyObject* pyobj_val = NULL;
    TermCriteria val;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:ml_SVMSGD.setTermCriteria", (char**)keywords, &pyobj_val) &&
        pyopencv_to(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->setTermCriteria(val));
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_ml_SVMSGD_methods[] =
{
    {"create", (PyCFunction)pyopencv_cv_ml_ml_SVMSGD_create_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "create() -> retval\n.   @brief Creates empty model.\n.   * Use StatModel::train to train the model. Since %SVMSGD has several parameters, you may want to\n.   * find the best parameters for your problem or use setOptimalParameters() to set some default parameters."},
    {"getInitialStepSize", (PyCFunction)pyopencv_cv_ml_ml_SVMSGD_getInitialStepSize, METH_VARARGS | METH_KEYWORDS, "getInitialStepSize() -> retval\n.   @see setInitialStepSize"},
    {"getMarginRegularization", (PyCFunction)pyopencv_cv_ml_ml_SVMSGD_getMarginRegularization, METH_VARARGS | METH_KEYWORDS, "getMarginRegularization() -> retval\n.   @see setMarginRegularization"},
    {"getMarginType", (PyCFunction)pyopencv_cv_ml_ml_SVMSGD_getMarginType, METH_VARARGS | METH_KEYWORDS, "getMarginType() -> retval\n.   @see setMarginType"},
    {"getShift", (PyCFunction)pyopencv_cv_ml_ml_SVMSGD_getShift, METH_VARARGS | METH_KEYWORDS, "getShift() -> retval\n.   * @return the shift of the trained model (decision function f(x) = weights * x + shift)."},
    {"getStepDecreasingPower", (PyCFunction)pyopencv_cv_ml_ml_SVMSGD_getStepDecreasingPower, METH_VARARGS | METH_KEYWORDS, "getStepDecreasingPower() -> retval\n.   @see setStepDecreasingPower"},
    {"getSvmsgdType", (PyCFunction)pyopencv_cv_ml_ml_SVMSGD_getSvmsgdType, METH_VARARGS | METH_KEYWORDS, "getSvmsgdType() -> retval\n.   @see setSvmsgdType"},
    {"getTermCriteria", (PyCFunction)pyopencv_cv_ml_ml_SVMSGD_getTermCriteria, METH_VARARGS | METH_KEYWORDS, "getTermCriteria() -> retval\n.   @see setTermCriteria"},
    {"getWeights", (PyCFunction)pyopencv_cv_ml_ml_SVMSGD_getWeights, METH_VARARGS | METH_KEYWORDS, "getWeights() -> retval\n.   * @return the weights of the trained model (decision function f(x) = weights * x + shift)."},
    {"load", (PyCFunction)pyopencv_cv_ml_ml_SVMSGD_load_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "load(filepath[, nodeName]) -> retval\n.   @brief Loads and creates a serialized SVMSGD from a file\n.   *\n.   * Use SVMSGD::save to serialize and store an SVMSGD to disk.\n.   * Load the SVMSGD from this file again, by calling this function with the path to the file.\n.   * Optionally specify the node for the file containing the classifier\n.   *\n.   * @param filepath path to serialized SVMSGD\n.   * @param nodeName name of node containing the classifier"},
    {"setInitialStepSize", (PyCFunction)pyopencv_cv_ml_ml_SVMSGD_setInitialStepSize, METH_VARARGS | METH_KEYWORDS, "setInitialStepSize(InitialStepSize) -> None\n.   @copybrief getInitialStepSize @see getInitialStepSize"},
    {"setMarginRegularization", (PyCFunction)pyopencv_cv_ml_ml_SVMSGD_setMarginRegularization, METH_VARARGS | METH_KEYWORDS, "setMarginRegularization(marginRegularization) -> None\n.   @copybrief getMarginRegularization @see getMarginRegularization"},
    {"setMarginType", (PyCFunction)pyopencv_cv_ml_ml_SVMSGD_setMarginType, METH_VARARGS | METH_KEYWORDS, "setMarginType(marginType) -> None\n.   @copybrief getMarginType @see getMarginType"},
    {"setOptimalParameters", (PyCFunction)pyopencv_cv_ml_ml_SVMSGD_setOptimalParameters, METH_VARARGS | METH_KEYWORDS, "setOptimalParameters([, svmsgdType[, marginType]]) -> None\n.   @brief Function sets optimal parameters values for chosen SVM SGD model.\n.   * @param svmsgdType is the type of SVMSGD classifier.\n.   * @param marginType is the type of margin constraint."},
    {"setStepDecreasingPower", (PyCFunction)pyopencv_cv_ml_ml_SVMSGD_setStepDecreasingPower, METH_VARARGS | METH_KEYWORDS, "setStepDecreasingPower(stepDecreasingPower) -> None\n.   @copybrief getStepDecreasingPower @see getStepDecreasingPower"},
    {"setSvmsgdType", (PyCFunction)pyopencv_cv_ml_ml_SVMSGD_setSvmsgdType, METH_VARARGS | METH_KEYWORDS, "setSvmsgdType(svmsgdType) -> None\n.   @copybrief getSvmsgdType @see getSvmsgdType"},
    {"setTermCriteria", (PyCFunction)pyopencv_cv_ml_ml_SVMSGD_setTermCriteria, METH_VARARGS | METH_KEYWORDS, "setTermCriteria(val) -> None\n.   @copybrief getTermCriteria @see getTermCriteria"},

    {NULL,          NULL}
};

static void pyopencv_ml_SVMSGD_specials(void)
{
    pyopencv_ml_SVMSGD_Type.tp_base = &pyopencv_ml_StatModel_Type;
    pyopencv_ml_SVMSGD_Type.tp_dealloc = pyopencv_ml_SVMSGD_dealloc;
    pyopencv_ml_SVMSGD_Type.tp_repr = pyopencv_ml_SVMSGD_repr;
    pyopencv_ml_SVMSGD_Type.tp_getset = pyopencv_ml_SVMSGD_getseters;
    pyopencv_ml_SVMSGD_Type.tp_init = (initproc)0;
    pyopencv_ml_SVMSGD_Type.tp_methods = pyopencv_ml_SVMSGD_methods;
}

static PyObject* pyopencv_ml_ANN_MLP_ANNEAL_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<ml_ANN_MLP_ANNEAL %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_ml_ANN_MLP_ANNEAL_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_ANNEAL_getAnnealCoolingRatio(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP_ANNEAL* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_ANNEAL_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP_ANNEAL*>(((pyopencv_ml_ANN_MLP_ANNEAL_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP_ANNEAL' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getAnnealCoolingRatio());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_ANNEAL_getAnnealFinalT(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP_ANNEAL* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_ANNEAL_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP_ANNEAL*>(((pyopencv_ml_ANN_MLP_ANNEAL_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP_ANNEAL' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getAnnealFinalT());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_ANNEAL_getAnnealInitialT(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP_ANNEAL* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_ANNEAL_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP_ANNEAL*>(((pyopencv_ml_ANN_MLP_ANNEAL_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP_ANNEAL' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getAnnealInitialT());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_ANNEAL_getAnnealItePerStep(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP_ANNEAL* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_ANNEAL_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP_ANNEAL*>(((pyopencv_ml_ANN_MLP_ANNEAL_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP_ANNEAL' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getAnnealItePerStep());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_ANNEAL_setAnnealCoolingRatio(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP_ANNEAL* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_ANNEAL_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP_ANNEAL*>(((pyopencv_ml_ANN_MLP_ANNEAL_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP_ANNEAL' or its derivative)");
    double val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:ml_ANN_MLP_ANNEAL.setAnnealCoolingRatio", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setAnnealCoolingRatio(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_ANNEAL_setAnnealFinalT(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP_ANNEAL* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_ANNEAL_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP_ANNEAL*>(((pyopencv_ml_ANN_MLP_ANNEAL_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP_ANNEAL' or its derivative)");
    double val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:ml_ANN_MLP_ANNEAL.setAnnealFinalT", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setAnnealFinalT(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_ANNEAL_setAnnealInitialT(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP_ANNEAL* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_ANNEAL_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP_ANNEAL*>(((pyopencv_ml_ANN_MLP_ANNEAL_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP_ANNEAL' or its derivative)");
    double val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:ml_ANN_MLP_ANNEAL.setAnnealInitialT", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setAnnealInitialT(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ml_ml_ANN_MLP_ANNEAL_setAnnealItePerStep(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ml;

    cv::ml::ANN_MLP_ANNEAL* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ml_ANN_MLP_ANNEAL_Type))
        _self_ = dynamic_cast<cv::ml::ANN_MLP_ANNEAL*>(((pyopencv_ml_ANN_MLP_ANNEAL_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ml_ANN_MLP_ANNEAL' or its derivative)");
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:ml_ANN_MLP_ANNEAL.setAnnealItePerStep", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setAnnealItePerStep(val));
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_ml_ANN_MLP_ANNEAL_methods[] =
{
    {"getAnnealCoolingRatio", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_ANNEAL_getAnnealCoolingRatio, METH_VARARGS | METH_KEYWORDS, "getAnnealCoolingRatio() -> retval\n.   @see setAnnealCoolingRatio"},
    {"getAnnealFinalT", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_ANNEAL_getAnnealFinalT, METH_VARARGS | METH_KEYWORDS, "getAnnealFinalT() -> retval\n.   @see setAnnealFinalT"},
    {"getAnnealInitialT", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_ANNEAL_getAnnealInitialT, METH_VARARGS | METH_KEYWORDS, "getAnnealInitialT() -> retval\n.   @see setAnnealInitialT"},
    {"getAnnealItePerStep", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_ANNEAL_getAnnealItePerStep, METH_VARARGS | METH_KEYWORDS, "getAnnealItePerStep() -> retval\n.   @see setAnnealItePerStep"},
    {"setAnnealCoolingRatio", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_ANNEAL_setAnnealCoolingRatio, METH_VARARGS | METH_KEYWORDS, "setAnnealCoolingRatio(val) -> None\n.   @copybrief getAnnealCoolingRatio @see getAnnealCoolingRatio"},
    {"setAnnealFinalT", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_ANNEAL_setAnnealFinalT, METH_VARARGS | METH_KEYWORDS, "setAnnealFinalT(val) -> None\n.   @copybrief getAnnealFinalT @see getAnnealFinalT"},
    {"setAnnealInitialT", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_ANNEAL_setAnnealInitialT, METH_VARARGS | METH_KEYWORDS, "setAnnealInitialT(val) -> None\n.   @copybrief getAnnealInitialT @see getAnnealInitialT"},
    {"setAnnealItePerStep", (PyCFunction)pyopencv_cv_ml_ml_ANN_MLP_ANNEAL_setAnnealItePerStep, METH_VARARGS | METH_KEYWORDS, "setAnnealItePerStep(val) -> None\n.   @copybrief getAnnealItePerStep @see getAnnealItePerStep"},

    {NULL,          NULL}
};

static void pyopencv_ml_ANN_MLP_ANNEAL_specials(void)
{
    pyopencv_ml_ANN_MLP_ANNEAL_Type.tp_base = &pyopencv_ml_ANN_MLP_Type;
    pyopencv_ml_ANN_MLP_ANNEAL_Type.tp_dealloc = pyopencv_ml_ANN_MLP_ANNEAL_dealloc;
    pyopencv_ml_ANN_MLP_ANNEAL_Type.tp_repr = pyopencv_ml_ANN_MLP_ANNEAL_repr;
    pyopencv_ml_ANN_MLP_ANNEAL_Type.tp_getset = pyopencv_ml_ANN_MLP_ANNEAL_getseters;
    pyopencv_ml_ANN_MLP_ANNEAL_Type.tp_init = (initproc)0;
    pyopencv_ml_ANN_MLP_ANNEAL_Type.tp_methods = pyopencv_ml_ANN_MLP_ANNEAL_methods;
}

static PyObject* pyopencv_BaseCascadeClassifier_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<BaseCascadeClassifier %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_BaseCascadeClassifier_getseters[] =
{
    {NULL}  /* Sentinel */
};



static PyMethodDef pyopencv_BaseCascadeClassifier_methods[] =
{

    {NULL,          NULL}
};

static void pyopencv_BaseCascadeClassifier_specials(void)
{
    pyopencv_BaseCascadeClassifier_Type.tp_base = &pyopencv_Algorithm_Type;
    pyopencv_BaseCascadeClassifier_Type.tp_dealloc = pyopencv_BaseCascadeClassifier_dealloc;
    pyopencv_BaseCascadeClassifier_Type.tp_repr = pyopencv_BaseCascadeClassifier_repr;
    pyopencv_BaseCascadeClassifier_Type.tp_getset = pyopencv_BaseCascadeClassifier_getseters;
    pyopencv_BaseCascadeClassifier_Type.tp_init = (initproc)0;
    pyopencv_BaseCascadeClassifier_Type.tp_methods = pyopencv_BaseCascadeClassifier_methods;
}

static PyObject* pyopencv_CascadeClassifier_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<CascadeClassifier %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_CascadeClassifier_getseters[] =
{
    {NULL}  /* Sentinel */
};

static int pyopencv_cv_CascadeClassifier_CascadeClassifier(pyopencv_CascadeClassifier_t* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    {

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        new (&(self->v)) Ptr<cv::CascadeClassifier>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::CascadeClassifier()));
        return 0;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_filename = NULL;
    String filename;

    const char* keywords[] = { "filename", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:CascadeClassifier", (char**)keywords, &pyobj_filename) &&
        pyopencv_to(pyobj_filename, filename, ArgInfo("filename", 0)) )
    {
        new (&(self->v)) Ptr<cv::CascadeClassifier>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::CascadeClassifier(filename)));
        return 0;
    }
    }

    return -1;
}

static PyObject* pyopencv_cv_CascadeClassifier_convert_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_oldcascade = NULL;
    String oldcascade;
    PyObject* pyobj_newcascade = NULL;
    String newcascade;
    bool retval;

    const char* keywords[] = { "oldcascade", "newcascade", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:CascadeClassifier.convert", (char**)keywords, &pyobj_oldcascade, &pyobj_newcascade) &&
        pyopencv_to(pyobj_oldcascade, oldcascade, ArgInfo("oldcascade", 0)) &&
        pyopencv_to(pyobj_newcascade, newcascade, ArgInfo("newcascade", 0)) )
    {
        ERRWRAP2(retval = cv::CascadeClassifier::convert(oldcascade, newcascade));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_CascadeClassifier_detectMultiScale(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::CascadeClassifier* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_CascadeClassifier_Type))
        _self_ = ((pyopencv_CascadeClassifier_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'CascadeClassifier' or its derivative)");
    {
    PyObject* pyobj_image = NULL;
    Mat image;
    vector_Rect objects;
    double scaleFactor=1.1;
    int minNeighbors=3;
    int flags=0;
    PyObject* pyobj_minSize = NULL;
    Size minSize;
    PyObject* pyobj_maxSize = NULL;
    Size maxSize;

    const char* keywords[] = { "image", "scaleFactor", "minNeighbors", "flags", "minSize", "maxSize", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|diiOO:CascadeClassifier.detectMultiScale", (char**)keywords, &pyobj_image, &scaleFactor, &minNeighbors, &flags, &pyobj_minSize, &pyobj_maxSize) &&
        pyopencv_to(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to(pyobj_minSize, minSize, ArgInfo("minSize", 0)) &&
        pyopencv_to(pyobj_maxSize, maxSize, ArgInfo("maxSize", 0)) )
    {
        ERRWRAP2(_self_->detectMultiScale(image, objects, scaleFactor, minNeighbors, flags, minSize, maxSize));
        return pyopencv_from(objects);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_image = NULL;
    UMat image;
    vector_Rect objects;
    double scaleFactor=1.1;
    int minNeighbors=3;
    int flags=0;
    PyObject* pyobj_minSize = NULL;
    Size minSize;
    PyObject* pyobj_maxSize = NULL;
    Size maxSize;

    const char* keywords[] = { "image", "scaleFactor", "minNeighbors", "flags", "minSize", "maxSize", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|diiOO:CascadeClassifier.detectMultiScale", (char**)keywords, &pyobj_image, &scaleFactor, &minNeighbors, &flags, &pyobj_minSize, &pyobj_maxSize) &&
        pyopencv_to(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to(pyobj_minSize, minSize, ArgInfo("minSize", 0)) &&
        pyopencv_to(pyobj_maxSize, maxSize, ArgInfo("maxSize", 0)) )
    {
        ERRWRAP2(_self_->detectMultiScale(image, objects, scaleFactor, minNeighbors, flags, minSize, maxSize));
        return pyopencv_from(objects);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_CascadeClassifier_detectMultiScale2(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::CascadeClassifier* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_CascadeClassifier_Type))
        _self_ = ((pyopencv_CascadeClassifier_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'CascadeClassifier' or its derivative)");
    {
    PyObject* pyobj_image = NULL;
    Mat image;
    vector_Rect objects;
    vector_int numDetections;
    double scaleFactor=1.1;
    int minNeighbors=3;
    int flags=0;
    PyObject* pyobj_minSize = NULL;
    Size minSize;
    PyObject* pyobj_maxSize = NULL;
    Size maxSize;

    const char* keywords[] = { "image", "scaleFactor", "minNeighbors", "flags", "minSize", "maxSize", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|diiOO:CascadeClassifier.detectMultiScale2", (char**)keywords, &pyobj_image, &scaleFactor, &minNeighbors, &flags, &pyobj_minSize, &pyobj_maxSize) &&
        pyopencv_to(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to(pyobj_minSize, minSize, ArgInfo("minSize", 0)) &&
        pyopencv_to(pyobj_maxSize, maxSize, ArgInfo("maxSize", 0)) )
    {
        ERRWRAP2(_self_->detectMultiScale(image, objects, numDetections, scaleFactor, minNeighbors, flags, minSize, maxSize));
        return Py_BuildValue("(NN)", pyopencv_from(objects), pyopencv_from(numDetections));
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_image = NULL;
    UMat image;
    vector_Rect objects;
    vector_int numDetections;
    double scaleFactor=1.1;
    int minNeighbors=3;
    int flags=0;
    PyObject* pyobj_minSize = NULL;
    Size minSize;
    PyObject* pyobj_maxSize = NULL;
    Size maxSize;

    const char* keywords[] = { "image", "scaleFactor", "minNeighbors", "flags", "minSize", "maxSize", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|diiOO:CascadeClassifier.detectMultiScale2", (char**)keywords, &pyobj_image, &scaleFactor, &minNeighbors, &flags, &pyobj_minSize, &pyobj_maxSize) &&
        pyopencv_to(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to(pyobj_minSize, minSize, ArgInfo("minSize", 0)) &&
        pyopencv_to(pyobj_maxSize, maxSize, ArgInfo("maxSize", 0)) )
    {
        ERRWRAP2(_self_->detectMultiScale(image, objects, numDetections, scaleFactor, minNeighbors, flags, minSize, maxSize));
        return Py_BuildValue("(NN)", pyopencv_from(objects), pyopencv_from(numDetections));
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_CascadeClassifier_detectMultiScale3(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::CascadeClassifier* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_CascadeClassifier_Type))
        _self_ = ((pyopencv_CascadeClassifier_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'CascadeClassifier' or its derivative)");
    {
    PyObject* pyobj_image = NULL;
    Mat image;
    vector_Rect objects;
    vector_int rejectLevels;
    vector_double levelWeights;
    double scaleFactor=1.1;
    int minNeighbors=3;
    int flags=0;
    PyObject* pyobj_minSize = NULL;
    Size minSize;
    PyObject* pyobj_maxSize = NULL;
    Size maxSize;
    bool outputRejectLevels=false;

    const char* keywords[] = { "image", "scaleFactor", "minNeighbors", "flags", "minSize", "maxSize", "outputRejectLevels", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|diiOOb:CascadeClassifier.detectMultiScale3", (char**)keywords, &pyobj_image, &scaleFactor, &minNeighbors, &flags, &pyobj_minSize, &pyobj_maxSize, &outputRejectLevels) &&
        pyopencv_to(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to(pyobj_minSize, minSize, ArgInfo("minSize", 0)) &&
        pyopencv_to(pyobj_maxSize, maxSize, ArgInfo("maxSize", 0)) )
    {
        ERRWRAP2(_self_->detectMultiScale(image, objects, rejectLevels, levelWeights, scaleFactor, minNeighbors, flags, minSize, maxSize, outputRejectLevels));
        return Py_BuildValue("(NNN)", pyopencv_from(objects), pyopencv_from(rejectLevels), pyopencv_from(levelWeights));
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_image = NULL;
    UMat image;
    vector_Rect objects;
    vector_int rejectLevels;
    vector_double levelWeights;
    double scaleFactor=1.1;
    int minNeighbors=3;
    int flags=0;
    PyObject* pyobj_minSize = NULL;
    Size minSize;
    PyObject* pyobj_maxSize = NULL;
    Size maxSize;
    bool outputRejectLevels=false;

    const char* keywords[] = { "image", "scaleFactor", "minNeighbors", "flags", "minSize", "maxSize", "outputRejectLevels", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|diiOOb:CascadeClassifier.detectMultiScale3", (char**)keywords, &pyobj_image, &scaleFactor, &minNeighbors, &flags, &pyobj_minSize, &pyobj_maxSize, &outputRejectLevels) &&
        pyopencv_to(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to(pyobj_minSize, minSize, ArgInfo("minSize", 0)) &&
        pyopencv_to(pyobj_maxSize, maxSize, ArgInfo("maxSize", 0)) )
    {
        ERRWRAP2(_self_->detectMultiScale(image, objects, rejectLevels, levelWeights, scaleFactor, minNeighbors, flags, minSize, maxSize, outputRejectLevels));
        return Py_BuildValue("(NNN)", pyopencv_from(objects), pyopencv_from(rejectLevels), pyopencv_from(levelWeights));
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_CascadeClassifier_empty(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::CascadeClassifier* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_CascadeClassifier_Type))
        _self_ = ((pyopencv_CascadeClassifier_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'CascadeClassifier' or its derivative)");
    bool retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->empty());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_CascadeClassifier_getFeatureType(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::CascadeClassifier* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_CascadeClassifier_Type))
        _self_ = ((pyopencv_CascadeClassifier_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'CascadeClassifier' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getFeatureType());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_CascadeClassifier_getOriginalWindowSize(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::CascadeClassifier* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_CascadeClassifier_Type))
        _self_ = ((pyopencv_CascadeClassifier_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'CascadeClassifier' or its derivative)");
    Size retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getOriginalWindowSize());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_CascadeClassifier_isOldFormatCascade(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::CascadeClassifier* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_CascadeClassifier_Type))
        _self_ = ((pyopencv_CascadeClassifier_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'CascadeClassifier' or its derivative)");
    bool retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->isOldFormatCascade());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_CascadeClassifier_load(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::CascadeClassifier* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_CascadeClassifier_Type))
        _self_ = ((pyopencv_CascadeClassifier_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'CascadeClassifier' or its derivative)");
    PyObject* pyobj_filename = NULL;
    String filename;
    bool retval;

    const char* keywords[] = { "filename", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:CascadeClassifier.load", (char**)keywords, &pyobj_filename) &&
        pyopencv_to(pyobj_filename, filename, ArgInfo("filename", 0)) )
    {
        ERRWRAP2(retval = _self_->load(filename));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_CascadeClassifier_read(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::CascadeClassifier* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_CascadeClassifier_Type))
        _self_ = ((pyopencv_CascadeClassifier_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'CascadeClassifier' or its derivative)");
    PyObject* pyobj_node = NULL;
    FileNode node;
    bool retval;

    const char* keywords[] = { "node", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:CascadeClassifier.read", (char**)keywords, &pyobj_node) &&
        pyopencv_to(pyobj_node, node, ArgInfo("node", 0)) )
    {
        ERRWRAP2(retval = _self_->read(node));
        return pyopencv_from(retval);
    }

    return NULL;
}



static PyMethodDef pyopencv_CascadeClassifier_methods[] =
{
    {"convert", (PyCFunction)pyopencv_cv_CascadeClassifier_convert_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "convert(oldcascade, newcascade) -> retval\n."},
    {"detectMultiScale", (PyCFunction)pyopencv_cv_CascadeClassifier_detectMultiScale, METH_VARARGS | METH_KEYWORDS, "detectMultiScale(image[, scaleFactor[, minNeighbors[, flags[, minSize[, maxSize]]]]]) -> objects\n.   @brief Detects objects of different sizes in the input image. The detected objects are returned as a list\n.   of rectangles.\n.   \n.   @param image Matrix of the type CV_8U containing an image where objects are detected.\n.   @param objects Vector of rectangles where each rectangle contains the detected object, the\n.   rectangles may be partially outside the original image.\n.   @param scaleFactor Parameter specifying how much the image size is reduced at each image scale.\n.   @param minNeighbors Parameter specifying how many neighbors each candidate rectangle should have\n.   to retain it.\n.   @param flags Parameter with the same meaning for an old cascade as in the function\n.   cvHaarDetectObjects. It is not used for a new cascade.\n.   @param minSize Minimum possible object size. Objects smaller than that are ignored.\n.   @param maxSize Maximum possible object size. Objects larger than that are ignored. If `maxSize == minSize` model is evaluated on single scale.\n.   \n.   The function is parallelized with the TBB library.\n.   \n.   @note\n.   -   (Python) A face detection example using cascade classifiers can be found at\n.   opencv_source_code/samples/python/facedetect.py"},
    {"detectMultiScale2", (PyCFunction)pyopencv_cv_CascadeClassifier_detectMultiScale2, METH_VARARGS | METH_KEYWORDS, "detectMultiScale2(image[, scaleFactor[, minNeighbors[, flags[, minSize[, maxSize]]]]]) -> objects, numDetections\n.   @overload\n.   @param image Matrix of the type CV_8U containing an image where objects are detected.\n.   @param objects Vector of rectangles where each rectangle contains the detected object, the\n.   rectangles may be partially outside the original image.\n.   @param numDetections Vector of detection numbers for the corresponding objects. An object's number\n.   of detections is the number of neighboring positively classified rectangles that were joined\n.   together to form the object.\n.   @param scaleFactor Parameter specifying how much the image size is reduced at each image scale.\n.   @param minNeighbors Parameter specifying how many neighbors each candidate rectangle should have\n.   to retain it.\n.   @param flags Parameter with the same meaning for an old cascade as in the function\n.   cvHaarDetectObjects. It is not used for a new cascade.\n.   @param minSize Minimum possible object size. Objects smaller than that are ignored.\n.   @param maxSize Maximum possible object size. Objects larger than that are ignored. If `maxSize == minSize` model is evaluated on single scale."},
    {"detectMultiScale3", (PyCFunction)pyopencv_cv_CascadeClassifier_detectMultiScale3, METH_VARARGS | METH_KEYWORDS, "detectMultiScale3(image[, scaleFactor[, minNeighbors[, flags[, minSize[, maxSize[, outputRejectLevels]]]]]]) -> objects, rejectLevels, levelWeights\n.   @overload\n.   This function allows you to retrieve the final stage decision certainty of classification.\n.   For this, one needs to set `outputRejectLevels` on true and provide the `rejectLevels` and `levelWeights` parameter.\n.   For each resulting detection, `levelWeights` will then contain the certainty of classification at the final stage.\n.   This value can then be used to separate strong from weaker classifications.\n.   \n.   A code sample on how to use it efficiently can be found below:\n.   @code\n.   Mat img;\n.   vector<double> weights;\n.   vector<int> levels;\n.   vector<Rect> detections;\n.   CascadeClassifier model(\"/path/to/your/model.xml\");\n.   model.detectMultiScale(img, detections, levels, weights, 1.1, 3, 0, Size(), Size(), true);\n.   cerr << \"Detection \" << detections[0] << \" with weight \" << weights[0] << endl;\n.   @endcode"},
    {"empty", (PyCFunction)pyopencv_cv_CascadeClassifier_empty, METH_VARARGS | METH_KEYWORDS, "empty() -> retval\n.   @brief Checks whether the classifier has been loaded."},
    {"getFeatureType", (PyCFunction)pyopencv_cv_CascadeClassifier_getFeatureType, METH_VARARGS | METH_KEYWORDS, "getFeatureType() -> retval\n."},
    {"getOriginalWindowSize", (PyCFunction)pyopencv_cv_CascadeClassifier_getOriginalWindowSize, METH_VARARGS | METH_KEYWORDS, "getOriginalWindowSize() -> retval\n."},
    {"isOldFormatCascade", (PyCFunction)pyopencv_cv_CascadeClassifier_isOldFormatCascade, METH_VARARGS | METH_KEYWORDS, "isOldFormatCascade() -> retval\n."},
    {"load", (PyCFunction)pyopencv_cv_CascadeClassifier_load, METH_VARARGS | METH_KEYWORDS, "load(filename) -> retval\n.   @brief Loads a classifier from a file.\n.   \n.   @param filename Name of the file from which the classifier is loaded. The file may contain an old\n.   HAAR classifier trained by the haartraining application or a new cascade classifier trained by the\n.   traincascade application."},
    {"read", (PyCFunction)pyopencv_cv_CascadeClassifier_read, METH_VARARGS | METH_KEYWORDS, "read(node) -> retval\n.   @brief Reads a classifier from a FileStorage node.\n.   \n.   @note The file may contain a new cascade classifier (trained traincascade application) only."},

    {NULL,          NULL}
};

static void pyopencv_CascadeClassifier_specials(void)
{
    pyopencv_CascadeClassifier_Type.tp_base = NULL;
    pyopencv_CascadeClassifier_Type.tp_dealloc = pyopencv_CascadeClassifier_dealloc;
    pyopencv_CascadeClassifier_Type.tp_repr = pyopencv_CascadeClassifier_repr;
    pyopencv_CascadeClassifier_Type.tp_getset = pyopencv_CascadeClassifier_getseters;
    pyopencv_CascadeClassifier_Type.tp_init = (initproc)pyopencv_cv_CascadeClassifier_CascadeClassifier;
    pyopencv_CascadeClassifier_Type.tp_methods = pyopencv_CascadeClassifier_methods;
}

static PyObject* pyopencv_HOGDescriptor_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<HOGDescriptor %p>", self);
    return PyString_FromString(str);
}


static PyObject* pyopencv_HOGDescriptor_get_L2HysThreshold(pyopencv_HOGDescriptor_t* p, void *closure)
{
    return pyopencv_from(p->v->L2HysThreshold);
}

static PyObject* pyopencv_HOGDescriptor_get_blockSize(pyopencv_HOGDescriptor_t* p, void *closure)
{
    return pyopencv_from(p->v->blockSize);
}

static PyObject* pyopencv_HOGDescriptor_get_blockStride(pyopencv_HOGDescriptor_t* p, void *closure)
{
    return pyopencv_from(p->v->blockStride);
}

static PyObject* pyopencv_HOGDescriptor_get_cellSize(pyopencv_HOGDescriptor_t* p, void *closure)
{
    return pyopencv_from(p->v->cellSize);
}

static PyObject* pyopencv_HOGDescriptor_get_derivAperture(pyopencv_HOGDescriptor_t* p, void *closure)
{
    return pyopencv_from(p->v->derivAperture);
}

static PyObject* pyopencv_HOGDescriptor_get_gammaCorrection(pyopencv_HOGDescriptor_t* p, void *closure)
{
    return pyopencv_from(p->v->gammaCorrection);
}

static PyObject* pyopencv_HOGDescriptor_get_histogramNormType(pyopencv_HOGDescriptor_t* p, void *closure)
{
    return pyopencv_from(p->v->histogramNormType);
}

static PyObject* pyopencv_HOGDescriptor_get_nbins(pyopencv_HOGDescriptor_t* p, void *closure)
{
    return pyopencv_from(p->v->nbins);
}

static PyObject* pyopencv_HOGDescriptor_get_nlevels(pyopencv_HOGDescriptor_t* p, void *closure)
{
    return pyopencv_from(p->v->nlevels);
}

static PyObject* pyopencv_HOGDescriptor_get_signedGradient(pyopencv_HOGDescriptor_t* p, void *closure)
{
    return pyopencv_from(p->v->signedGradient);
}

static PyObject* pyopencv_HOGDescriptor_get_svmDetector(pyopencv_HOGDescriptor_t* p, void *closure)
{
    return pyopencv_from(p->v->svmDetector);
}

static PyObject* pyopencv_HOGDescriptor_get_winSigma(pyopencv_HOGDescriptor_t* p, void *closure)
{
    return pyopencv_from(p->v->winSigma);
}

static PyObject* pyopencv_HOGDescriptor_get_winSize(pyopencv_HOGDescriptor_t* p, void *closure)
{
    return pyopencv_from(p->v->winSize);
}


static PyGetSetDef pyopencv_HOGDescriptor_getseters[] =
{
    {(char*)"L2HysThreshold", (getter)pyopencv_HOGDescriptor_get_L2HysThreshold, NULL, (char*)"L2HysThreshold", NULL},
    {(char*)"blockSize", (getter)pyopencv_HOGDescriptor_get_blockSize, NULL, (char*)"blockSize", NULL},
    {(char*)"blockStride", (getter)pyopencv_HOGDescriptor_get_blockStride, NULL, (char*)"blockStride", NULL},
    {(char*)"cellSize", (getter)pyopencv_HOGDescriptor_get_cellSize, NULL, (char*)"cellSize", NULL},
    {(char*)"derivAperture", (getter)pyopencv_HOGDescriptor_get_derivAperture, NULL, (char*)"derivAperture", NULL},
    {(char*)"gammaCorrection", (getter)pyopencv_HOGDescriptor_get_gammaCorrection, NULL, (char*)"gammaCorrection", NULL},
    {(char*)"histogramNormType", (getter)pyopencv_HOGDescriptor_get_histogramNormType, NULL, (char*)"histogramNormType", NULL},
    {(char*)"nbins", (getter)pyopencv_HOGDescriptor_get_nbins, NULL, (char*)"nbins", NULL},
    {(char*)"nlevels", (getter)pyopencv_HOGDescriptor_get_nlevels, NULL, (char*)"nlevels", NULL},
    {(char*)"signedGradient", (getter)pyopencv_HOGDescriptor_get_signedGradient, NULL, (char*)"signedGradient", NULL},
    {(char*)"svmDetector", (getter)pyopencv_HOGDescriptor_get_svmDetector, NULL, (char*)"svmDetector", NULL},
    {(char*)"winSigma", (getter)pyopencv_HOGDescriptor_get_winSigma, NULL, (char*)"winSigma", NULL},
    {(char*)"winSize", (getter)pyopencv_HOGDescriptor_get_winSize, NULL, (char*)"winSize", NULL},
    {NULL}  /* Sentinel */
};

static int pyopencv_cv_HOGDescriptor_HOGDescriptor(pyopencv_HOGDescriptor_t* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    {

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        new (&(self->v)) Ptr<cv::HOGDescriptor>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::HOGDescriptor()));
        return 0;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj__winSize = NULL;
    Size _winSize;
    PyObject* pyobj__blockSize = NULL;
    Size _blockSize;
    PyObject* pyobj__blockStride = NULL;
    Size _blockStride;
    PyObject* pyobj__cellSize = NULL;
    Size _cellSize;
    int _nbins=0;
    int _derivAperture=1;
    double _winSigma=-1;
    int _histogramNormType=HOGDescriptor::L2Hys;
    double _L2HysThreshold=0.2;
    bool _gammaCorrection=false;
    int _nlevels=HOGDescriptor::DEFAULT_NLEVELS;
    bool _signedGradient=false;

    const char* keywords[] = { "_winSize", "_blockSize", "_blockStride", "_cellSize", "_nbins", "_derivAperture", "_winSigma", "_histogramNormType", "_L2HysThreshold", "_gammaCorrection", "_nlevels", "_signedGradient", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOOOi|ididbib:HOGDescriptor", (char**)keywords, &pyobj__winSize, &pyobj__blockSize, &pyobj__blockStride, &pyobj__cellSize, &_nbins, &_derivAperture, &_winSigma, &_histogramNormType, &_L2HysThreshold, &_gammaCorrection, &_nlevels, &_signedGradient) &&
        pyopencv_to(pyobj__winSize, _winSize, ArgInfo("_winSize", 0)) &&
        pyopencv_to(pyobj__blockSize, _blockSize, ArgInfo("_blockSize", 0)) &&
        pyopencv_to(pyobj__blockStride, _blockStride, ArgInfo("_blockStride", 0)) &&
        pyopencv_to(pyobj__cellSize, _cellSize, ArgInfo("_cellSize", 0)) )
    {
        new (&(self->v)) Ptr<cv::HOGDescriptor>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::HOGDescriptor(_winSize, _blockSize, _blockStride, _cellSize, _nbins, _derivAperture, _winSigma, _histogramNormType, _L2HysThreshold, _gammaCorrection, _nlevels, _signedGradient)));
        return 0;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_filename = NULL;
    String filename;

    const char* keywords[] = { "filename", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:HOGDescriptor", (char**)keywords, &pyobj_filename) &&
        pyopencv_to(pyobj_filename, filename, ArgInfo("filename", 0)) )
    {
        new (&(self->v)) Ptr<cv::HOGDescriptor>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::HOGDescriptor(filename)));
        return 0;
    }
    }

    return -1;
}

static PyObject* pyopencv_cv_HOGDescriptor_checkDetectorSize(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::HOGDescriptor* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_HOGDescriptor_Type))
        _self_ = ((pyopencv_HOGDescriptor_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'HOGDescriptor' or its derivative)");
    bool retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->checkDetectorSize());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_HOGDescriptor_compute(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::HOGDescriptor* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_HOGDescriptor_Type))
        _self_ = ((pyopencv_HOGDescriptor_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'HOGDescriptor' or its derivative)");
    {
    PyObject* pyobj_img = NULL;
    Mat img;
    vector_float descriptors;
    PyObject* pyobj_winStride = NULL;
    Size winStride;
    PyObject* pyobj_padding = NULL;
    Size padding;
    PyObject* pyobj_locations = NULL;
    vector_Point locations=std::vector<Point>();

    const char* keywords[] = { "img", "winStride", "padding", "locations", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|OOO:HOGDescriptor.compute", (char**)keywords, &pyobj_img, &pyobj_winStride, &pyobj_padding, &pyobj_locations) &&
        pyopencv_to(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to(pyobj_winStride, winStride, ArgInfo("winStride", 0)) &&
        pyopencv_to(pyobj_padding, padding, ArgInfo("padding", 0)) &&
        pyopencv_to(pyobj_locations, locations, ArgInfo("locations", 0)) )
    {
        ERRWRAP2(_self_->compute(img, descriptors, winStride, padding, locations));
        return pyopencv_from(descriptors);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_img = NULL;
    UMat img;
    vector_float descriptors;
    PyObject* pyobj_winStride = NULL;
    Size winStride;
    PyObject* pyobj_padding = NULL;
    Size padding;
    PyObject* pyobj_locations = NULL;
    vector_Point locations=std::vector<Point>();

    const char* keywords[] = { "img", "winStride", "padding", "locations", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|OOO:HOGDescriptor.compute", (char**)keywords, &pyobj_img, &pyobj_winStride, &pyobj_padding, &pyobj_locations) &&
        pyopencv_to(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to(pyobj_winStride, winStride, ArgInfo("winStride", 0)) &&
        pyopencv_to(pyobj_padding, padding, ArgInfo("padding", 0)) &&
        pyopencv_to(pyobj_locations, locations, ArgInfo("locations", 0)) )
    {
        ERRWRAP2(_self_->compute(img, descriptors, winStride, padding, locations));
        return pyopencv_from(descriptors);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_HOGDescriptor_computeGradient(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::HOGDescriptor* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_HOGDescriptor_Type))
        _self_ = ((pyopencv_HOGDescriptor_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'HOGDescriptor' or its derivative)");
    {
    PyObject* pyobj_img = NULL;
    Mat img;
    PyObject* pyobj_grad = NULL;
    Mat grad;
    PyObject* pyobj_angleOfs = NULL;
    Mat angleOfs;
    PyObject* pyobj_paddingTL = NULL;
    Size paddingTL;
    PyObject* pyobj_paddingBR = NULL;
    Size paddingBR;

    const char* keywords[] = { "img", "grad", "angleOfs", "paddingTL", "paddingBR", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|OOOO:HOGDescriptor.computeGradient", (char**)keywords, &pyobj_img, &pyobj_grad, &pyobj_angleOfs, &pyobj_paddingTL, &pyobj_paddingBR) &&
        pyopencv_to(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to(pyobj_grad, grad, ArgInfo("grad", 1)) &&
        pyopencv_to(pyobj_angleOfs, angleOfs, ArgInfo("angleOfs", 1)) &&
        pyopencv_to(pyobj_paddingTL, paddingTL, ArgInfo("paddingTL", 0)) &&
        pyopencv_to(pyobj_paddingBR, paddingBR, ArgInfo("paddingBR", 0)) )
    {
        ERRWRAP2(_self_->computeGradient(img, grad, angleOfs, paddingTL, paddingBR));
        return Py_BuildValue("(NN)", pyopencv_from(grad), pyopencv_from(angleOfs));
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_img = NULL;
    Mat img;
    PyObject* pyobj_grad = NULL;
    Mat grad;
    PyObject* pyobj_angleOfs = NULL;
    Mat angleOfs;
    PyObject* pyobj_paddingTL = NULL;
    Size paddingTL;
    PyObject* pyobj_paddingBR = NULL;
    Size paddingBR;

    const char* keywords[] = { "img", "grad", "angleOfs", "paddingTL", "paddingBR", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|OOOO:HOGDescriptor.computeGradient", (char**)keywords, &pyobj_img, &pyobj_grad, &pyobj_angleOfs, &pyobj_paddingTL, &pyobj_paddingBR) &&
        pyopencv_to(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to(pyobj_grad, grad, ArgInfo("grad", 1)) &&
        pyopencv_to(pyobj_angleOfs, angleOfs, ArgInfo("angleOfs", 1)) &&
        pyopencv_to(pyobj_paddingTL, paddingTL, ArgInfo("paddingTL", 0)) &&
        pyopencv_to(pyobj_paddingBR, paddingBR, ArgInfo("paddingBR", 0)) )
    {
        ERRWRAP2(_self_->computeGradient(img, grad, angleOfs, paddingTL, paddingBR));
        return Py_BuildValue("(NN)", pyopencv_from(grad), pyopencv_from(angleOfs));
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_HOGDescriptor_detect(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::HOGDescriptor* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_HOGDescriptor_Type))
        _self_ = ((pyopencv_HOGDescriptor_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'HOGDescriptor' or its derivative)");
    {
    PyObject* pyobj_img = NULL;
    Mat img;
    vector_Point foundLocations;
    vector_double weights;
    double hitThreshold=0;
    PyObject* pyobj_winStride = NULL;
    Size winStride;
    PyObject* pyobj_padding = NULL;
    Size padding;
    PyObject* pyobj_searchLocations = NULL;
    vector_Point searchLocations=std::vector<Point>();

    const char* keywords[] = { "img", "hitThreshold", "winStride", "padding", "searchLocations", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|dOOO:HOGDescriptor.detect", (char**)keywords, &pyobj_img, &hitThreshold, &pyobj_winStride, &pyobj_padding, &pyobj_searchLocations) &&
        pyopencv_to(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to(pyobj_winStride, winStride, ArgInfo("winStride", 0)) &&
        pyopencv_to(pyobj_padding, padding, ArgInfo("padding", 0)) &&
        pyopencv_to(pyobj_searchLocations, searchLocations, ArgInfo("searchLocations", 0)) )
    {
        ERRWRAP2(_self_->detect(img, foundLocations, weights, hitThreshold, winStride, padding, searchLocations));
        return Py_BuildValue("(NN)", pyopencv_from(foundLocations), pyopencv_from(weights));
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_img = NULL;
    Mat img;
    vector_Point foundLocations;
    vector_double weights;
    double hitThreshold=0;
    PyObject* pyobj_winStride = NULL;
    Size winStride;
    PyObject* pyobj_padding = NULL;
    Size padding;
    PyObject* pyobj_searchLocations = NULL;
    vector_Point searchLocations=std::vector<Point>();

    const char* keywords[] = { "img", "hitThreshold", "winStride", "padding", "searchLocations", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|dOOO:HOGDescriptor.detect", (char**)keywords, &pyobj_img, &hitThreshold, &pyobj_winStride, &pyobj_padding, &pyobj_searchLocations) &&
        pyopencv_to(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to(pyobj_winStride, winStride, ArgInfo("winStride", 0)) &&
        pyopencv_to(pyobj_padding, padding, ArgInfo("padding", 0)) &&
        pyopencv_to(pyobj_searchLocations, searchLocations, ArgInfo("searchLocations", 0)) )
    {
        ERRWRAP2(_self_->detect(img, foundLocations, weights, hitThreshold, winStride, padding, searchLocations));
        return Py_BuildValue("(NN)", pyopencv_from(foundLocations), pyopencv_from(weights));
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_HOGDescriptor_detectMultiScale(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::HOGDescriptor* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_HOGDescriptor_Type))
        _self_ = ((pyopencv_HOGDescriptor_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'HOGDescriptor' or its derivative)");
    {
    PyObject* pyobj_img = NULL;
    Mat img;
    vector_Rect foundLocations;
    vector_double foundWeights;
    double hitThreshold=0;
    PyObject* pyobj_winStride = NULL;
    Size winStride;
    PyObject* pyobj_padding = NULL;
    Size padding;
    double scale=1.05;
    double finalThreshold=2.0;
    bool useMeanshiftGrouping=false;

    const char* keywords[] = { "img", "hitThreshold", "winStride", "padding", "scale", "finalThreshold", "useMeanshiftGrouping", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|dOOddb:HOGDescriptor.detectMultiScale", (char**)keywords, &pyobj_img, &hitThreshold, &pyobj_winStride, &pyobj_padding, &scale, &finalThreshold, &useMeanshiftGrouping) &&
        pyopencv_to(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to(pyobj_winStride, winStride, ArgInfo("winStride", 0)) &&
        pyopencv_to(pyobj_padding, padding, ArgInfo("padding", 0)) )
    {
        ERRWRAP2(_self_->detectMultiScale(img, foundLocations, foundWeights, hitThreshold, winStride, padding, scale, finalThreshold, useMeanshiftGrouping));
        return Py_BuildValue("(NN)", pyopencv_from(foundLocations), pyopencv_from(foundWeights));
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_img = NULL;
    UMat img;
    vector_Rect foundLocations;
    vector_double foundWeights;
    double hitThreshold=0;
    PyObject* pyobj_winStride = NULL;
    Size winStride;
    PyObject* pyobj_padding = NULL;
    Size padding;
    double scale=1.05;
    double finalThreshold=2.0;
    bool useMeanshiftGrouping=false;

    const char* keywords[] = { "img", "hitThreshold", "winStride", "padding", "scale", "finalThreshold", "useMeanshiftGrouping", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|dOOddb:HOGDescriptor.detectMultiScale", (char**)keywords, &pyobj_img, &hitThreshold, &pyobj_winStride, &pyobj_padding, &scale, &finalThreshold, &useMeanshiftGrouping) &&
        pyopencv_to(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to(pyobj_winStride, winStride, ArgInfo("winStride", 0)) &&
        pyopencv_to(pyobj_padding, padding, ArgInfo("padding", 0)) )
    {
        ERRWRAP2(_self_->detectMultiScale(img, foundLocations, foundWeights, hitThreshold, winStride, padding, scale, finalThreshold, useMeanshiftGrouping));
        return Py_BuildValue("(NN)", pyopencv_from(foundLocations), pyopencv_from(foundWeights));
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_HOGDescriptor_getDaimlerPeopleDetector_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    std::vector<float> retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = cv::HOGDescriptor::getDaimlerPeopleDetector());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_HOGDescriptor_getDefaultPeopleDetector_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    std::vector<float> retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = cv::HOGDescriptor::getDefaultPeopleDetector());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_HOGDescriptor_getDescriptorSize(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::HOGDescriptor* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_HOGDescriptor_Type))
        _self_ = ((pyopencv_HOGDescriptor_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'HOGDescriptor' or its derivative)");
    size_t retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDescriptorSize());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_HOGDescriptor_getWinSigma(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::HOGDescriptor* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_HOGDescriptor_Type))
        _self_ = ((pyopencv_HOGDescriptor_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'HOGDescriptor' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getWinSigma());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_HOGDescriptor_load(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::HOGDescriptor* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_HOGDescriptor_Type))
        _self_ = ((pyopencv_HOGDescriptor_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'HOGDescriptor' or its derivative)");
    PyObject* pyobj_filename = NULL;
    String filename;
    PyObject* pyobj_objname = NULL;
    String objname;
    bool retval;

    const char* keywords[] = { "filename", "objname", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:HOGDescriptor.load", (char**)keywords, &pyobj_filename, &pyobj_objname) &&
        pyopencv_to(pyobj_filename, filename, ArgInfo("filename", 0)) &&
        pyopencv_to(pyobj_objname, objname, ArgInfo("objname", 0)) )
    {
        ERRWRAP2(retval = _self_->load(filename, objname));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_HOGDescriptor_save(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::HOGDescriptor* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_HOGDescriptor_Type))
        _self_ = ((pyopencv_HOGDescriptor_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'HOGDescriptor' or its derivative)");
    PyObject* pyobj_filename = NULL;
    String filename;
    PyObject* pyobj_objname = NULL;
    String objname;

    const char* keywords[] = { "filename", "objname", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:HOGDescriptor.save", (char**)keywords, &pyobj_filename, &pyobj_objname) &&
        pyopencv_to(pyobj_filename, filename, ArgInfo("filename", 0)) &&
        pyopencv_to(pyobj_objname, objname, ArgInfo("objname", 0)) )
    {
        ERRWRAP2(_self_->save(filename, objname));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_HOGDescriptor_setSVMDetector(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::HOGDescriptor* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_HOGDescriptor_Type))
        _self_ = ((pyopencv_HOGDescriptor_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'HOGDescriptor' or its derivative)");
    {
    PyObject* pyobj__svmdetector = NULL;
    Mat _svmdetector;

    const char* keywords[] = { "_svmdetector", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:HOGDescriptor.setSVMDetector", (char**)keywords, &pyobj__svmdetector) &&
        pyopencv_to(pyobj__svmdetector, _svmdetector, ArgInfo("_svmdetector", 0)) )
    {
        ERRWRAP2(_self_->setSVMDetector(_svmdetector));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj__svmdetector = NULL;
    UMat _svmdetector;

    const char* keywords[] = { "_svmdetector", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:HOGDescriptor.setSVMDetector", (char**)keywords, &pyobj__svmdetector) &&
        pyopencv_to(pyobj__svmdetector, _svmdetector, ArgInfo("_svmdetector", 0)) )
    {
        ERRWRAP2(_self_->setSVMDetector(_svmdetector));
        Py_RETURN_NONE;
    }
    }

    return NULL;
}



static PyMethodDef pyopencv_HOGDescriptor_methods[] =
{
    {"checkDetectorSize", (PyCFunction)pyopencv_cv_HOGDescriptor_checkDetectorSize, METH_VARARGS | METH_KEYWORDS, "checkDetectorSize() -> retval\n.   @brief Checks if detector size equal to descriptor size."},
    {"compute", (PyCFunction)pyopencv_cv_HOGDescriptor_compute, METH_VARARGS | METH_KEYWORDS, "compute(img[, winStride[, padding[, locations]]]) -> descriptors\n.   @brief Computes HOG descriptors of given image.\n.   @param img Matrix of the type CV_8U containing an image where HOG features will be calculated.\n.   @param descriptors Matrix of the type CV_32F\n.   @param winStride Window stride. It must be a multiple of block stride.\n.   @param padding Padding\n.   @param locations Vector of Point"},
    {"computeGradient", (PyCFunction)pyopencv_cv_HOGDescriptor_computeGradient, METH_VARARGS | METH_KEYWORDS, "computeGradient(img[, grad[, angleOfs[, paddingTL[, paddingBR]]]]) -> grad, angleOfs\n.   @brief  Computes gradients and quantized gradient orientations.\n.   @param img Matrix contains the image to be computed\n.   @param grad Matrix of type CV_32FC2 contains computed gradients\n.   @param angleOfs Matrix of type CV_8UC2 contains quantized gradient orientations\n.   @param paddingTL Padding from top-left\n.   @param paddingBR Padding from bottom-right"},
    {"detect", (PyCFunction)pyopencv_cv_HOGDescriptor_detect, METH_VARARGS | METH_KEYWORDS, "detect(img[, hitThreshold[, winStride[, padding[, searchLocations]]]]) -> foundLocations, weights\n.   @brief Performs object detection without a multi-scale window.\n.   @param img Matrix of the type CV_8U or CV_8UC3 containing an image where objects are detected.\n.   @param foundLocations Vector of point where each point contains left-top corner point of detected object boundaries.\n.   @param weights Vector that will contain confidence values for each detected object.\n.   @param hitThreshold Threshold for the distance between features and SVM classifying plane.\n.   Usually it is 0 and should be specified in the detector coefficients (as the last free coefficient).\n.   But if the free coefficient is omitted (which is allowed), you can specify it manually here.\n.   @param winStride Window stride. It must be a multiple of block stride.\n.   @param padding Padding\n.   @param searchLocations Vector of Point includes set of requested locations to be evaluated."},
    {"detectMultiScale", (PyCFunction)pyopencv_cv_HOGDescriptor_detectMultiScale, METH_VARARGS | METH_KEYWORDS, "detectMultiScale(img[, hitThreshold[, winStride[, padding[, scale[, finalThreshold[, useMeanshiftGrouping]]]]]]) -> foundLocations, foundWeights\n.   @brief Detects objects of different sizes in the input image. The detected objects are returned as a list\n.   of rectangles.\n.   @param img Matrix of the type CV_8U or CV_8UC3 containing an image where objects are detected.\n.   @param foundLocations Vector of rectangles where each rectangle contains the detected object.\n.   @param foundWeights Vector that will contain confidence values for each detected object.\n.   @param hitThreshold Threshold for the distance between features and SVM classifying plane.\n.   Usually it is 0 and should be specified in the detector coefficients (as the last free coefficient).\n.   But if the free coefficient is omitted (which is allowed), you can specify it manually here.\n.   @param winStride Window stride. It must be a multiple of block stride.\n.   @param padding Padding\n.   @param scale Coefficient of the detection window increase.\n.   @param finalThreshold Final threshold\n.   @param useMeanshiftGrouping indicates grouping algorithm"},
    {"getDaimlerPeopleDetector", (PyCFunction)pyopencv_cv_HOGDescriptor_getDaimlerPeopleDetector_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "getDaimlerPeopleDetector() -> retval\n.   @brief Returns coefficients of the classifier trained for people detection (for 48x96 windows)."},
    {"getDefaultPeopleDetector", (PyCFunction)pyopencv_cv_HOGDescriptor_getDefaultPeopleDetector_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "getDefaultPeopleDetector() -> retval\n.   @brief Returns coefficients of the classifier trained for people detection (for 64x128 windows)."},
    {"getDescriptorSize", (PyCFunction)pyopencv_cv_HOGDescriptor_getDescriptorSize, METH_VARARGS | METH_KEYWORDS, "getDescriptorSize() -> retval\n.   @brief Returns the number of coefficients required for the classification."},
    {"getWinSigma", (PyCFunction)pyopencv_cv_HOGDescriptor_getWinSigma, METH_VARARGS | METH_KEYWORDS, "getWinSigma() -> retval\n.   @brief Returns winSigma value"},
    {"load", (PyCFunction)pyopencv_cv_HOGDescriptor_load, METH_VARARGS | METH_KEYWORDS, "load(filename[, objname]) -> retval\n.   @brief loads coefficients for the linear SVM classifier from a file\n.   @param filename Name of the file to read.\n.   @param objname The optional name of the node to read (if empty, the first top-level node will be used)."},
    {"save", (PyCFunction)pyopencv_cv_HOGDescriptor_save, METH_VARARGS | METH_KEYWORDS, "save(filename[, objname]) -> None\n.   @brief saves coefficients for the linear SVM classifier to a file\n.   @param filename File name\n.   @param objname Object name"},
    {"setSVMDetector", (PyCFunction)pyopencv_cv_HOGDescriptor_setSVMDetector, METH_VARARGS | METH_KEYWORDS, "setSVMDetector(_svmdetector) -> None\n.   @brief Sets coefficients for the linear SVM classifier.\n.   @param _svmdetector coefficients for the linear SVM classifier."},

    {NULL,          NULL}
};

static void pyopencv_HOGDescriptor_specials(void)
{
    pyopencv_HOGDescriptor_Type.tp_base = NULL;
    pyopencv_HOGDescriptor_Type.tp_dealloc = pyopencv_HOGDescriptor_dealloc;
    pyopencv_HOGDescriptor_Type.tp_repr = pyopencv_HOGDescriptor_repr;
    pyopencv_HOGDescriptor_Type.tp_getset = pyopencv_HOGDescriptor_getseters;
    pyopencv_HOGDescriptor_Type.tp_init = (initproc)pyopencv_cv_HOGDescriptor_HOGDescriptor;
    pyopencv_HOGDescriptor_Type.tp_methods = pyopencv_HOGDescriptor_methods;
}

static PyObject* pyopencv_phase_unwrapping_HistogramPhaseUnwrapping_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<phase_unwrapping_HistogramPhaseUnwrapping %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_phase_unwrapping_HistogramPhaseUnwrapping_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_phase_unwrapping_phase_unwrapping_HistogramPhaseUnwrapping_getInverseReliabilityMap(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::phase_unwrapping;

    cv::phase_unwrapping::HistogramPhaseUnwrapping* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_phase_unwrapping_HistogramPhaseUnwrapping_Type))
        _self_ = dynamic_cast<cv::phase_unwrapping::HistogramPhaseUnwrapping*>(((pyopencv_phase_unwrapping_HistogramPhaseUnwrapping_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'phase_unwrapping_HistogramPhaseUnwrapping' or its derivative)");
    {
    PyObject* pyobj_reliabilityMap = NULL;
    Mat reliabilityMap;

    const char* keywords[] = { "reliabilityMap", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "|O:phase_unwrapping_HistogramPhaseUnwrapping.getInverseReliabilityMap", (char**)keywords, &pyobj_reliabilityMap) &&
        pyopencv_to(pyobj_reliabilityMap, reliabilityMap, ArgInfo("reliabilityMap", 1)) )
    {
        ERRWRAP2(_self_->getInverseReliabilityMap(reliabilityMap));
        return pyopencv_from(reliabilityMap);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_reliabilityMap = NULL;
    UMat reliabilityMap;

    const char* keywords[] = { "reliabilityMap", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "|O:phase_unwrapping_HistogramPhaseUnwrapping.getInverseReliabilityMap", (char**)keywords, &pyobj_reliabilityMap) &&
        pyopencv_to(pyobj_reliabilityMap, reliabilityMap, ArgInfo("reliabilityMap", 1)) )
    {
        ERRWRAP2(_self_->getInverseReliabilityMap(reliabilityMap));
        return pyopencv_from(reliabilityMap);
    }
    }

    return NULL;
}



static PyMethodDef pyopencv_phase_unwrapping_HistogramPhaseUnwrapping_methods[] =
{
    {"getInverseReliabilityMap", (PyCFunction)pyopencv_cv_phase_unwrapping_phase_unwrapping_HistogramPhaseUnwrapping_getInverseReliabilityMap, METH_VARARGS | METH_KEYWORDS, "getInverseReliabilityMap([, reliabilityMap]) -> reliabilityMap\n.   * @brief Get the reliability map computed from the wrapped phase map.\n.   \n.   * @param reliabilityMap Image where the reliability map is stored."},

    {NULL,          NULL}
};

static void pyopencv_phase_unwrapping_HistogramPhaseUnwrapping_specials(void)
{
    pyopencv_phase_unwrapping_HistogramPhaseUnwrapping_Type.tp_base = &pyopencv_phase_unwrapping_PhaseUnwrapping_Type;
    pyopencv_phase_unwrapping_HistogramPhaseUnwrapping_Type.tp_dealloc = pyopencv_phase_unwrapping_HistogramPhaseUnwrapping_dealloc;
    pyopencv_phase_unwrapping_HistogramPhaseUnwrapping_Type.tp_repr = pyopencv_phase_unwrapping_HistogramPhaseUnwrapping_repr;
    pyopencv_phase_unwrapping_HistogramPhaseUnwrapping_Type.tp_getset = pyopencv_phase_unwrapping_HistogramPhaseUnwrapping_getseters;
    pyopencv_phase_unwrapping_HistogramPhaseUnwrapping_Type.tp_init = (initproc)0;
    pyopencv_phase_unwrapping_HistogramPhaseUnwrapping_Type.tp_methods = pyopencv_phase_unwrapping_HistogramPhaseUnwrapping_methods;
}

static PyObject* pyopencv_phase_unwrapping_PhaseUnwrapping_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<phase_unwrapping_PhaseUnwrapping %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_phase_unwrapping_PhaseUnwrapping_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_phase_unwrapping_phase_unwrapping_PhaseUnwrapping_unwrapPhaseMap(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::phase_unwrapping;

    cv::phase_unwrapping::PhaseUnwrapping* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_phase_unwrapping_PhaseUnwrapping_Type))
        _self_ = dynamic_cast<cv::phase_unwrapping::PhaseUnwrapping*>(((pyopencv_phase_unwrapping_PhaseUnwrapping_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'phase_unwrapping_PhaseUnwrapping' or its derivative)");
    {
    PyObject* pyobj_wrappedPhaseMap = NULL;
    Mat wrappedPhaseMap;
    PyObject* pyobj_unwrappedPhaseMap = NULL;
    Mat unwrappedPhaseMap;
    PyObject* pyobj_shadowMask = NULL;
    Mat shadowMask;

    const char* keywords[] = { "wrappedPhaseMap", "unwrappedPhaseMap", "shadowMask", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|OO:phase_unwrapping_PhaseUnwrapping.unwrapPhaseMap", (char**)keywords, &pyobj_wrappedPhaseMap, &pyobj_unwrappedPhaseMap, &pyobj_shadowMask) &&
        pyopencv_to(pyobj_wrappedPhaseMap, wrappedPhaseMap, ArgInfo("wrappedPhaseMap", 0)) &&
        pyopencv_to(pyobj_unwrappedPhaseMap, unwrappedPhaseMap, ArgInfo("unwrappedPhaseMap", 1)) &&
        pyopencv_to(pyobj_shadowMask, shadowMask, ArgInfo("shadowMask", 0)) )
    {
        ERRWRAP2(_self_->unwrapPhaseMap(wrappedPhaseMap, unwrappedPhaseMap, shadowMask));
        return pyopencv_from(unwrappedPhaseMap);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_wrappedPhaseMap = NULL;
    UMat wrappedPhaseMap;
    PyObject* pyobj_unwrappedPhaseMap = NULL;
    UMat unwrappedPhaseMap;
    PyObject* pyobj_shadowMask = NULL;
    UMat shadowMask;

    const char* keywords[] = { "wrappedPhaseMap", "unwrappedPhaseMap", "shadowMask", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|OO:phase_unwrapping_PhaseUnwrapping.unwrapPhaseMap", (char**)keywords, &pyobj_wrappedPhaseMap, &pyobj_unwrappedPhaseMap, &pyobj_shadowMask) &&
        pyopencv_to(pyobj_wrappedPhaseMap, wrappedPhaseMap, ArgInfo("wrappedPhaseMap", 0)) &&
        pyopencv_to(pyobj_unwrappedPhaseMap, unwrappedPhaseMap, ArgInfo("unwrappedPhaseMap", 1)) &&
        pyopencv_to(pyobj_shadowMask, shadowMask, ArgInfo("shadowMask", 0)) )
    {
        ERRWRAP2(_self_->unwrapPhaseMap(wrappedPhaseMap, unwrappedPhaseMap, shadowMask));
        return pyopencv_from(unwrappedPhaseMap);
    }
    }

    return NULL;
}



static PyMethodDef pyopencv_phase_unwrapping_PhaseUnwrapping_methods[] =
{
    {"unwrapPhaseMap", (PyCFunction)pyopencv_cv_phase_unwrapping_phase_unwrapping_PhaseUnwrapping_unwrapPhaseMap, METH_VARARGS | METH_KEYWORDS, "unwrapPhaseMap(wrappedPhaseMap[, unwrappedPhaseMap[, shadowMask]]) -> unwrappedPhaseMap\n.   * @brief Unwraps a 2D phase map.\n.   \n.   * @param wrappedPhaseMap The wrapped phase map that needs to be unwrapped.\n.   * @param unwrappedPhaseMap The unwrapped phase map.\n.   * @param shadowMask Optional parameter used when some pixels do not hold any phase information in the wrapped phase map."},

    {NULL,          NULL}
};

static void pyopencv_phase_unwrapping_PhaseUnwrapping_specials(void)
{
    pyopencv_phase_unwrapping_PhaseUnwrapping_Type.tp_base = &pyopencv_Algorithm_Type;
    pyopencv_phase_unwrapping_PhaseUnwrapping_Type.tp_dealloc = pyopencv_phase_unwrapping_PhaseUnwrapping_dealloc;
    pyopencv_phase_unwrapping_PhaseUnwrapping_Type.tp_repr = pyopencv_phase_unwrapping_PhaseUnwrapping_repr;
    pyopencv_phase_unwrapping_PhaseUnwrapping_Type.tp_getset = pyopencv_phase_unwrapping_PhaseUnwrapping_getseters;
    pyopencv_phase_unwrapping_PhaseUnwrapping_Type.tp_init = (initproc)0;
    pyopencv_phase_unwrapping_PhaseUnwrapping_Type.tp_methods = pyopencv_phase_unwrapping_PhaseUnwrapping_methods;
}

static PyObject* pyopencv_Tonemap_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<Tonemap %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_Tonemap_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_Tonemap_getGamma(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::Tonemap* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_Tonemap_Type))
        _self_ = dynamic_cast<cv::Tonemap*>(((pyopencv_Tonemap_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'Tonemap' or its derivative)");
    float retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getGamma());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Tonemap_process(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::Tonemap* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_Tonemap_Type))
        _self_ = dynamic_cast<cv::Tonemap*>(((pyopencv_Tonemap_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'Tonemap' or its derivative)");
    {
    PyObject* pyobj_src = NULL;
    Mat src;
    PyObject* pyobj_dst = NULL;
    Mat dst;

    const char* keywords[] = { "src", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:Tonemap.process", (char**)keywords, &pyobj_src, &pyobj_dst) &&
        pyopencv_to(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to(pyobj_dst, dst, ArgInfo("dst", 1)) )
    {
        ERRWRAP2(_self_->process(src, dst));
        return pyopencv_from(dst);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_src = NULL;
    UMat src;
    PyObject* pyobj_dst = NULL;
    UMat dst;

    const char* keywords[] = { "src", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:Tonemap.process", (char**)keywords, &pyobj_src, &pyobj_dst) &&
        pyopencv_to(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to(pyobj_dst, dst, ArgInfo("dst", 1)) )
    {
        ERRWRAP2(_self_->process(src, dst));
        return pyopencv_from(dst);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_Tonemap_setGamma(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::Tonemap* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_Tonemap_Type))
        _self_ = dynamic_cast<cv::Tonemap*>(((pyopencv_Tonemap_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'Tonemap' or its derivative)");
    float gamma=0.f;

    const char* keywords[] = { "gamma", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "f:Tonemap.setGamma", (char**)keywords, &gamma) )
    {
        ERRWRAP2(_self_->setGamma(gamma));
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_Tonemap_methods[] =
{
    {"getGamma", (PyCFunction)pyopencv_cv_Tonemap_getGamma, METH_VARARGS | METH_KEYWORDS, "getGamma() -> retval\n."},
    {"process", (PyCFunction)pyopencv_cv_Tonemap_process, METH_VARARGS | METH_KEYWORDS, "process(src[, dst]) -> dst\n.   @brief Tonemaps image\n.   \n.   @param src source image - 32-bit 3-channel Mat\n.   @param dst destination image - 32-bit 3-channel Mat with values in [0, 1] range"},
    {"setGamma", (PyCFunction)pyopencv_cv_Tonemap_setGamma, METH_VARARGS | METH_KEYWORDS, "setGamma(gamma) -> None\n."},

    {NULL,          NULL}
};

static void pyopencv_Tonemap_specials(void)
{
    pyopencv_Tonemap_Type.tp_base = &pyopencv_Algorithm_Type;
    pyopencv_Tonemap_Type.tp_dealloc = pyopencv_Tonemap_dealloc;
    pyopencv_Tonemap_Type.tp_repr = pyopencv_Tonemap_repr;
    pyopencv_Tonemap_Type.tp_getset = pyopencv_Tonemap_getseters;
    pyopencv_Tonemap_Type.tp_init = (initproc)0;
    pyopencv_Tonemap_Type.tp_methods = pyopencv_Tonemap_methods;
}

static PyObject* pyopencv_TonemapDrago_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<TonemapDrago %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_TonemapDrago_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_TonemapDrago_getBias(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TonemapDrago* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TonemapDrago_Type))
        _self_ = dynamic_cast<cv::TonemapDrago*>(((pyopencv_TonemapDrago_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TonemapDrago' or its derivative)");
    float retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getBias());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapDrago_getSaturation(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TonemapDrago* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TonemapDrago_Type))
        _self_ = dynamic_cast<cv::TonemapDrago*>(((pyopencv_TonemapDrago_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TonemapDrago' or its derivative)");
    float retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getSaturation());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapDrago_setBias(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TonemapDrago* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TonemapDrago_Type))
        _self_ = dynamic_cast<cv::TonemapDrago*>(((pyopencv_TonemapDrago_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TonemapDrago' or its derivative)");
    float bias=0.f;

    const char* keywords[] = { "bias", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "f:TonemapDrago.setBias", (char**)keywords, &bias) )
    {
        ERRWRAP2(_self_->setBias(bias));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapDrago_setSaturation(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TonemapDrago* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TonemapDrago_Type))
        _self_ = dynamic_cast<cv::TonemapDrago*>(((pyopencv_TonemapDrago_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TonemapDrago' or its derivative)");
    float saturation=0.f;

    const char* keywords[] = { "saturation", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "f:TonemapDrago.setSaturation", (char**)keywords, &saturation) )
    {
        ERRWRAP2(_self_->setSaturation(saturation));
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_TonemapDrago_methods[] =
{
    {"getBias", (PyCFunction)pyopencv_cv_TonemapDrago_getBias, METH_VARARGS | METH_KEYWORDS, "getBias() -> retval\n."},
    {"getSaturation", (PyCFunction)pyopencv_cv_TonemapDrago_getSaturation, METH_VARARGS | METH_KEYWORDS, "getSaturation() -> retval\n."},
    {"setBias", (PyCFunction)pyopencv_cv_TonemapDrago_setBias, METH_VARARGS | METH_KEYWORDS, "setBias(bias) -> None\n."},
    {"setSaturation", (PyCFunction)pyopencv_cv_TonemapDrago_setSaturation, METH_VARARGS | METH_KEYWORDS, "setSaturation(saturation) -> None\n."},

    {NULL,          NULL}
};

static void pyopencv_TonemapDrago_specials(void)
{
    pyopencv_TonemapDrago_Type.tp_base = &pyopencv_Tonemap_Type;
    pyopencv_TonemapDrago_Type.tp_dealloc = pyopencv_TonemapDrago_dealloc;
    pyopencv_TonemapDrago_Type.tp_repr = pyopencv_TonemapDrago_repr;
    pyopencv_TonemapDrago_Type.tp_getset = pyopencv_TonemapDrago_getseters;
    pyopencv_TonemapDrago_Type.tp_init = (initproc)0;
    pyopencv_TonemapDrago_Type.tp_methods = pyopencv_TonemapDrago_methods;
}

static PyObject* pyopencv_TonemapDurand_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<TonemapDurand %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_TonemapDurand_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_TonemapDurand_getContrast(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TonemapDurand* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TonemapDurand_Type))
        _self_ = dynamic_cast<cv::TonemapDurand*>(((pyopencv_TonemapDurand_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TonemapDurand' or its derivative)");
    float retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getContrast());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapDurand_getSaturation(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TonemapDurand* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TonemapDurand_Type))
        _self_ = dynamic_cast<cv::TonemapDurand*>(((pyopencv_TonemapDurand_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TonemapDurand' or its derivative)");
    float retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getSaturation());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapDurand_getSigmaColor(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TonemapDurand* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TonemapDurand_Type))
        _self_ = dynamic_cast<cv::TonemapDurand*>(((pyopencv_TonemapDurand_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TonemapDurand' or its derivative)");
    float retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getSigmaColor());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapDurand_getSigmaSpace(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TonemapDurand* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TonemapDurand_Type))
        _self_ = dynamic_cast<cv::TonemapDurand*>(((pyopencv_TonemapDurand_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TonemapDurand' or its derivative)");
    float retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getSigmaSpace());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapDurand_setContrast(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TonemapDurand* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TonemapDurand_Type))
        _self_ = dynamic_cast<cv::TonemapDurand*>(((pyopencv_TonemapDurand_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TonemapDurand' or its derivative)");
    float contrast=0.f;

    const char* keywords[] = { "contrast", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "f:TonemapDurand.setContrast", (char**)keywords, &contrast) )
    {
        ERRWRAP2(_self_->setContrast(contrast));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapDurand_setSaturation(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TonemapDurand* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TonemapDurand_Type))
        _self_ = dynamic_cast<cv::TonemapDurand*>(((pyopencv_TonemapDurand_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TonemapDurand' or its derivative)");
    float saturation=0.f;

    const char* keywords[] = { "saturation", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "f:TonemapDurand.setSaturation", (char**)keywords, &saturation) )
    {
        ERRWRAP2(_self_->setSaturation(saturation));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapDurand_setSigmaColor(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TonemapDurand* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TonemapDurand_Type))
        _self_ = dynamic_cast<cv::TonemapDurand*>(((pyopencv_TonemapDurand_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TonemapDurand' or its derivative)");
    float sigma_color=0.f;

    const char* keywords[] = { "sigma_color", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "f:TonemapDurand.setSigmaColor", (char**)keywords, &sigma_color) )
    {
        ERRWRAP2(_self_->setSigmaColor(sigma_color));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapDurand_setSigmaSpace(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TonemapDurand* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TonemapDurand_Type))
        _self_ = dynamic_cast<cv::TonemapDurand*>(((pyopencv_TonemapDurand_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TonemapDurand' or its derivative)");
    float sigma_space=0.f;

    const char* keywords[] = { "sigma_space", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "f:TonemapDurand.setSigmaSpace", (char**)keywords, &sigma_space) )
    {
        ERRWRAP2(_self_->setSigmaSpace(sigma_space));
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_TonemapDurand_methods[] =
{
    {"getContrast", (PyCFunction)pyopencv_cv_TonemapDurand_getContrast, METH_VARARGS | METH_KEYWORDS, "getContrast() -> retval\n."},
    {"getSaturation", (PyCFunction)pyopencv_cv_TonemapDurand_getSaturation, METH_VARARGS | METH_KEYWORDS, "getSaturation() -> retval\n."},
    {"getSigmaColor", (PyCFunction)pyopencv_cv_TonemapDurand_getSigmaColor, METH_VARARGS | METH_KEYWORDS, "getSigmaColor() -> retval\n."},
    {"getSigmaSpace", (PyCFunction)pyopencv_cv_TonemapDurand_getSigmaSpace, METH_VARARGS | METH_KEYWORDS, "getSigmaSpace() -> retval\n."},
    {"setContrast", (PyCFunction)pyopencv_cv_TonemapDurand_setContrast, METH_VARARGS | METH_KEYWORDS, "setContrast(contrast) -> None\n."},
    {"setSaturation", (PyCFunction)pyopencv_cv_TonemapDurand_setSaturation, METH_VARARGS | METH_KEYWORDS, "setSaturation(saturation) -> None\n."},
    {"setSigmaColor", (PyCFunction)pyopencv_cv_TonemapDurand_setSigmaColor, METH_VARARGS | METH_KEYWORDS, "setSigmaColor(sigma_color) -> None\n."},
    {"setSigmaSpace", (PyCFunction)pyopencv_cv_TonemapDurand_setSigmaSpace, METH_VARARGS | METH_KEYWORDS, "setSigmaSpace(sigma_space) -> None\n."},

    {NULL,          NULL}
};

static void pyopencv_TonemapDurand_specials(void)
{
    pyopencv_TonemapDurand_Type.tp_base = &pyopencv_Tonemap_Type;
    pyopencv_TonemapDurand_Type.tp_dealloc = pyopencv_TonemapDurand_dealloc;
    pyopencv_TonemapDurand_Type.tp_repr = pyopencv_TonemapDurand_repr;
    pyopencv_TonemapDurand_Type.tp_getset = pyopencv_TonemapDurand_getseters;
    pyopencv_TonemapDurand_Type.tp_init = (initproc)0;
    pyopencv_TonemapDurand_Type.tp_methods = pyopencv_TonemapDurand_methods;
}

static PyObject* pyopencv_TonemapReinhard_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<TonemapReinhard %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_TonemapReinhard_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_TonemapReinhard_getColorAdaptation(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TonemapReinhard* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TonemapReinhard_Type))
        _self_ = dynamic_cast<cv::TonemapReinhard*>(((pyopencv_TonemapReinhard_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TonemapReinhard' or its derivative)");
    float retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getColorAdaptation());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapReinhard_getIntensity(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TonemapReinhard* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TonemapReinhard_Type))
        _self_ = dynamic_cast<cv::TonemapReinhard*>(((pyopencv_TonemapReinhard_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TonemapReinhard' or its derivative)");
    float retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getIntensity());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapReinhard_getLightAdaptation(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TonemapReinhard* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TonemapReinhard_Type))
        _self_ = dynamic_cast<cv::TonemapReinhard*>(((pyopencv_TonemapReinhard_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TonemapReinhard' or its derivative)");
    float retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getLightAdaptation());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapReinhard_setColorAdaptation(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TonemapReinhard* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TonemapReinhard_Type))
        _self_ = dynamic_cast<cv::TonemapReinhard*>(((pyopencv_TonemapReinhard_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TonemapReinhard' or its derivative)");
    float color_adapt=0.f;

    const char* keywords[] = { "color_adapt", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "f:TonemapReinhard.setColorAdaptation", (char**)keywords, &color_adapt) )
    {
        ERRWRAP2(_self_->setColorAdaptation(color_adapt));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapReinhard_setIntensity(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TonemapReinhard* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TonemapReinhard_Type))
        _self_ = dynamic_cast<cv::TonemapReinhard*>(((pyopencv_TonemapReinhard_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TonemapReinhard' or its derivative)");
    float intensity=0.f;

    const char* keywords[] = { "intensity", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "f:TonemapReinhard.setIntensity", (char**)keywords, &intensity) )
    {
        ERRWRAP2(_self_->setIntensity(intensity));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapReinhard_setLightAdaptation(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TonemapReinhard* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TonemapReinhard_Type))
        _self_ = dynamic_cast<cv::TonemapReinhard*>(((pyopencv_TonemapReinhard_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TonemapReinhard' or its derivative)");
    float light_adapt=0.f;

    const char* keywords[] = { "light_adapt", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "f:TonemapReinhard.setLightAdaptation", (char**)keywords, &light_adapt) )
    {
        ERRWRAP2(_self_->setLightAdaptation(light_adapt));
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_TonemapReinhard_methods[] =
{
    {"getColorAdaptation", (PyCFunction)pyopencv_cv_TonemapReinhard_getColorAdaptation, METH_VARARGS | METH_KEYWORDS, "getColorAdaptation() -> retval\n."},
    {"getIntensity", (PyCFunction)pyopencv_cv_TonemapReinhard_getIntensity, METH_VARARGS | METH_KEYWORDS, "getIntensity() -> retval\n."},
    {"getLightAdaptation", (PyCFunction)pyopencv_cv_TonemapReinhard_getLightAdaptation, METH_VARARGS | METH_KEYWORDS, "getLightAdaptation() -> retval\n."},
    {"setColorAdaptation", (PyCFunction)pyopencv_cv_TonemapReinhard_setColorAdaptation, METH_VARARGS | METH_KEYWORDS, "setColorAdaptation(color_adapt) -> None\n."},
    {"setIntensity", (PyCFunction)pyopencv_cv_TonemapReinhard_setIntensity, METH_VARARGS | METH_KEYWORDS, "setIntensity(intensity) -> None\n."},
    {"setLightAdaptation", (PyCFunction)pyopencv_cv_TonemapReinhard_setLightAdaptation, METH_VARARGS | METH_KEYWORDS, "setLightAdaptation(light_adapt) -> None\n."},

    {NULL,          NULL}
};

static void pyopencv_TonemapReinhard_specials(void)
{
    pyopencv_TonemapReinhard_Type.tp_base = &pyopencv_Tonemap_Type;
    pyopencv_TonemapReinhard_Type.tp_dealloc = pyopencv_TonemapReinhard_dealloc;
    pyopencv_TonemapReinhard_Type.tp_repr = pyopencv_TonemapReinhard_repr;
    pyopencv_TonemapReinhard_Type.tp_getset = pyopencv_TonemapReinhard_getseters;
    pyopencv_TonemapReinhard_Type.tp_init = (initproc)0;
    pyopencv_TonemapReinhard_Type.tp_methods = pyopencv_TonemapReinhard_methods;
}

static PyObject* pyopencv_TonemapMantiuk_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<TonemapMantiuk %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_TonemapMantiuk_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_TonemapMantiuk_getSaturation(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TonemapMantiuk* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TonemapMantiuk_Type))
        _self_ = dynamic_cast<cv::TonemapMantiuk*>(((pyopencv_TonemapMantiuk_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TonemapMantiuk' or its derivative)");
    float retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getSaturation());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapMantiuk_getScale(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TonemapMantiuk* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TonemapMantiuk_Type))
        _self_ = dynamic_cast<cv::TonemapMantiuk*>(((pyopencv_TonemapMantiuk_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TonemapMantiuk' or its derivative)");
    float retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getScale());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapMantiuk_setSaturation(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TonemapMantiuk* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TonemapMantiuk_Type))
        _self_ = dynamic_cast<cv::TonemapMantiuk*>(((pyopencv_TonemapMantiuk_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TonemapMantiuk' or its derivative)");
    float saturation=0.f;

    const char* keywords[] = { "saturation", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "f:TonemapMantiuk.setSaturation", (char**)keywords, &saturation) )
    {
        ERRWRAP2(_self_->setSaturation(saturation));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapMantiuk_setScale(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::TonemapMantiuk* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_TonemapMantiuk_Type))
        _self_ = dynamic_cast<cv::TonemapMantiuk*>(((pyopencv_TonemapMantiuk_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'TonemapMantiuk' or its derivative)");
    float scale=0.f;

    const char* keywords[] = { "scale", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "f:TonemapMantiuk.setScale", (char**)keywords, &scale) )
    {
        ERRWRAP2(_self_->setScale(scale));
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_TonemapMantiuk_methods[] =
{
    {"getSaturation", (PyCFunction)pyopencv_cv_TonemapMantiuk_getSaturation, METH_VARARGS | METH_KEYWORDS, "getSaturation() -> retval\n."},
    {"getScale", (PyCFunction)pyopencv_cv_TonemapMantiuk_getScale, METH_VARARGS | METH_KEYWORDS, "getScale() -> retval\n."},
    {"setSaturation", (PyCFunction)pyopencv_cv_TonemapMantiuk_setSaturation, METH_VARARGS | METH_KEYWORDS, "setSaturation(saturation) -> None\n."},
    {"setScale", (PyCFunction)pyopencv_cv_TonemapMantiuk_setScale, METH_VARARGS | METH_KEYWORDS, "setScale(scale) -> None\n."},

    {NULL,          NULL}
};

static void pyopencv_TonemapMantiuk_specials(void)
{
    pyopencv_TonemapMantiuk_Type.tp_base = &pyopencv_Tonemap_Type;
    pyopencv_TonemapMantiuk_Type.tp_dealloc = pyopencv_TonemapMantiuk_dealloc;
    pyopencv_TonemapMantiuk_Type.tp_repr = pyopencv_TonemapMantiuk_repr;
    pyopencv_TonemapMantiuk_Type.tp_getset = pyopencv_TonemapMantiuk_getseters;
    pyopencv_TonemapMantiuk_Type.tp_init = (initproc)0;
    pyopencv_TonemapMantiuk_Type.tp_methods = pyopencv_TonemapMantiuk_methods;
}

static PyObject* pyopencv_AlignExposures_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<AlignExposures %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_AlignExposures_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_AlignExposures_process(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::AlignExposures* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_AlignExposures_Type))
        _self_ = dynamic_cast<cv::AlignExposures*>(((pyopencv_AlignExposures_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'AlignExposures' or its derivative)");
    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    vector_Mat dst;
    PyObject* pyobj_times = NULL;
    Mat times;
    PyObject* pyobj_response = NULL;
    Mat response;

    const char* keywords[] = { "src", "dst", "times", "response", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOOO:AlignExposures.process", (char**)keywords, &pyobj_src, &pyobj_dst, &pyobj_times, &pyobj_response) &&
        pyopencv_to(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to(pyobj_dst, dst, ArgInfo("dst", 0)) &&
        pyopencv_to(pyobj_times, times, ArgInfo("times", 0)) &&
        pyopencv_to(pyobj_response, response, ArgInfo("response", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times, response));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    vector_Mat dst;
    PyObject* pyobj_times = NULL;
    UMat times;
    PyObject* pyobj_response = NULL;
    UMat response;

    const char* keywords[] = { "src", "dst", "times", "response", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOOO:AlignExposures.process", (char**)keywords, &pyobj_src, &pyobj_dst, &pyobj_times, &pyobj_response) &&
        pyopencv_to(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to(pyobj_dst, dst, ArgInfo("dst", 0)) &&
        pyopencv_to(pyobj_times, times, ArgInfo("times", 0)) &&
        pyopencv_to(pyobj_response, response, ArgInfo("response", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times, response));
        Py_RETURN_NONE;
    }
    }

    return NULL;
}



static PyMethodDef pyopencv_AlignExposures_methods[] =
{
    {"process", (PyCFunction)pyopencv_cv_AlignExposures_process, METH_VARARGS | METH_KEYWORDS, "process(src, dst, times, response) -> None\n.   @brief Aligns images\n.   \n.   @param src vector of input images\n.   @param dst vector of aligned images\n.   @param times vector of exposure time values for each image\n.   @param response 256x1 matrix with inverse camera response function for each pixel value, it should\n.   have the same number of channels as images."},

    {NULL,          NULL}
};

static void pyopencv_AlignExposures_specials(void)
{
    pyopencv_AlignExposures_Type.tp_base = &pyopencv_Algorithm_Type;
    pyopencv_AlignExposures_Type.tp_dealloc = pyopencv_AlignExposures_dealloc;
    pyopencv_AlignExposures_Type.tp_repr = pyopencv_AlignExposures_repr;
    pyopencv_AlignExposures_Type.tp_getset = pyopencv_AlignExposures_getseters;
    pyopencv_AlignExposures_Type.tp_init = (initproc)0;
    pyopencv_AlignExposures_Type.tp_methods = pyopencv_AlignExposures_methods;
}

static PyObject* pyopencv_AlignMTB_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<AlignMTB %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_AlignMTB_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_AlignMTB_calculateShift(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::AlignMTB* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_AlignMTB_Type))
        _self_ = dynamic_cast<cv::AlignMTB*>(((pyopencv_AlignMTB_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'AlignMTB' or its derivative)");
    {
    PyObject* pyobj_img0 = NULL;
    Mat img0;
    PyObject* pyobj_img1 = NULL;
    Mat img1;
    Point retval;

    const char* keywords[] = { "img0", "img1", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:AlignMTB.calculateShift", (char**)keywords, &pyobj_img0, &pyobj_img1) &&
        pyopencv_to(pyobj_img0, img0, ArgInfo("img0", 0)) &&
        pyopencv_to(pyobj_img1, img1, ArgInfo("img1", 0)) )
    {
        ERRWRAP2(retval = _self_->calculateShift(img0, img1));
        return pyopencv_from(retval);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_img0 = NULL;
    UMat img0;
    PyObject* pyobj_img1 = NULL;
    UMat img1;
    Point retval;

    const char* keywords[] = { "img0", "img1", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:AlignMTB.calculateShift", (char**)keywords, &pyobj_img0, &pyobj_img1) &&
        pyopencv_to(pyobj_img0, img0, ArgInfo("img0", 0)) &&
        pyopencv_to(pyobj_img1, img1, ArgInfo("img1", 0)) )
    {
        ERRWRAP2(retval = _self_->calculateShift(img0, img1));
        return pyopencv_from(retval);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_AlignMTB_computeBitmaps(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::AlignMTB* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_AlignMTB_Type))
        _self_ = dynamic_cast<cv::AlignMTB*>(((pyopencv_AlignMTB_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'AlignMTB' or its derivative)");
    {
    PyObject* pyobj_img = NULL;
    Mat img;
    PyObject* pyobj_tb = NULL;
    Mat tb;
    PyObject* pyobj_eb = NULL;
    Mat eb;

    const char* keywords[] = { "img", "tb", "eb", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|OO:AlignMTB.computeBitmaps", (char**)keywords, &pyobj_img, &pyobj_tb, &pyobj_eb) &&
        pyopencv_to(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to(pyobj_tb, tb, ArgInfo("tb", 1)) &&
        pyopencv_to(pyobj_eb, eb, ArgInfo("eb", 1)) )
    {
        ERRWRAP2(_self_->computeBitmaps(img, tb, eb));
        return Py_BuildValue("(NN)", pyopencv_from(tb), pyopencv_from(eb));
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_img = NULL;
    UMat img;
    PyObject* pyobj_tb = NULL;
    UMat tb;
    PyObject* pyobj_eb = NULL;
    UMat eb;

    const char* keywords[] = { "img", "tb", "eb", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|OO:AlignMTB.computeBitmaps", (char**)keywords, &pyobj_img, &pyobj_tb, &pyobj_eb) &&
        pyopencv_to(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to(pyobj_tb, tb, ArgInfo("tb", 1)) &&
        pyopencv_to(pyobj_eb, eb, ArgInfo("eb", 1)) )
    {
        ERRWRAP2(_self_->computeBitmaps(img, tb, eb));
        return Py_BuildValue("(NN)", pyopencv_from(tb), pyopencv_from(eb));
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_AlignMTB_getCut(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::AlignMTB* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_AlignMTB_Type))
        _self_ = dynamic_cast<cv::AlignMTB*>(((pyopencv_AlignMTB_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'AlignMTB' or its derivative)");
    bool retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getCut());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_AlignMTB_getExcludeRange(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::AlignMTB* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_AlignMTB_Type))
        _self_ = dynamic_cast<cv::AlignMTB*>(((pyopencv_AlignMTB_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'AlignMTB' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getExcludeRange());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_AlignMTB_getMaxBits(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::AlignMTB* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_AlignMTB_Type))
        _self_ = dynamic_cast<cv::AlignMTB*>(((pyopencv_AlignMTB_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'AlignMTB' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMaxBits());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_AlignMTB_process(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::AlignMTB* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_AlignMTB_Type))
        _self_ = dynamic_cast<cv::AlignMTB*>(((pyopencv_AlignMTB_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'AlignMTB' or its derivative)");
    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    vector_Mat dst;
    PyObject* pyobj_times = NULL;
    Mat times;
    PyObject* pyobj_response = NULL;
    Mat response;

    const char* keywords[] = { "src", "dst", "times", "response", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOOO:AlignMTB.process", (char**)keywords, &pyobj_src, &pyobj_dst, &pyobj_times, &pyobj_response) &&
        pyopencv_to(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to(pyobj_dst, dst, ArgInfo("dst", 0)) &&
        pyopencv_to(pyobj_times, times, ArgInfo("times", 0)) &&
        pyopencv_to(pyobj_response, response, ArgInfo("response", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times, response));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    vector_Mat dst;
    PyObject* pyobj_times = NULL;
    UMat times;
    PyObject* pyobj_response = NULL;
    UMat response;

    const char* keywords[] = { "src", "dst", "times", "response", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOOO:AlignMTB.process", (char**)keywords, &pyobj_src, &pyobj_dst, &pyobj_times, &pyobj_response) &&
        pyopencv_to(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to(pyobj_dst, dst, ArgInfo("dst", 0)) &&
        pyopencv_to(pyobj_times, times, ArgInfo("times", 0)) &&
        pyopencv_to(pyobj_response, response, ArgInfo("response", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times, response));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    vector_Mat dst;

    const char* keywords[] = { "src", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:AlignMTB.process", (char**)keywords, &pyobj_src, &pyobj_dst) &&
        pyopencv_to(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to(pyobj_dst, dst, ArgInfo("dst", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst));
        Py_RETURN_NONE;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    vector_Mat dst;

    const char* keywords[] = { "src", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:AlignMTB.process", (char**)keywords, &pyobj_src, &pyobj_dst) &&
        pyopencv_to(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to(pyobj_dst, dst, ArgInfo("dst", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst));
        Py_RETURN_NONE;
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_AlignMTB_setCut(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::AlignMTB* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_AlignMTB_Type))
        _self_ = dynamic_cast<cv::AlignMTB*>(((pyopencv_AlignMTB_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'AlignMTB' or its derivative)");
    bool value=0;

    const char* keywords[] = { "value", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "b:AlignMTB.setCut", (char**)keywords, &value) )
    {
        ERRWRAP2(_self_->setCut(value));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_AlignMTB_setExcludeRange(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::AlignMTB* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_AlignMTB_Type))
        _self_ = dynamic_cast<cv::AlignMTB*>(((pyopencv_AlignMTB_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'AlignMTB' or its derivative)");
    int exclude_range=0;

    const char* keywords[] = { "exclude_range", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:AlignMTB.setExcludeRange", (char**)keywords, &exclude_range) )
    {
        ERRWRAP2(_self_->setExcludeRange(exclude_range));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_AlignMTB_setMaxBits(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::AlignMTB* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_AlignMTB_Type))
        _self_ = dynamic_cast<cv::AlignMTB*>(((pyopencv_AlignMTB_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'AlignMTB' or its derivative)");
    int max_bits=0;

    const char* keywords[] = { "max_bits", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:AlignMTB.setMaxBits", (char**)keywords, &max_bits) )
    {
        ERRWRAP2(_self_->setMaxBits(max_bits));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_AlignMTB_shiftMat(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::AlignMTB* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_AlignMTB_Type))
        _self_ = dynamic_cast<cv::AlignMTB*>(((pyopencv_AlignMTB_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'AlignMTB' or its derivative)");
    {
    PyObject* pyobj_src = NULL;
    Mat src;
    PyObject* pyobj_dst = NULL;
    Mat dst;
    PyObject* pyobj_shift = NULL;
    Point shift;

    const char* keywords[] = { "src", "shift", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|O:AlignMTB.shiftMat", (char**)keywords, &pyobj_src, &pyobj_shift, &pyobj_dst) &&
        pyopencv_to(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to(pyobj_shift, shift, ArgInfo("shift", 0)) )
    {
        ERRWRAP2(_self_->shiftMat(src, dst, shift));
        return pyopencv_from(dst);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_src = NULL;
    UMat src;
    PyObject* pyobj_dst = NULL;
    UMat dst;
    PyObject* pyobj_shift = NULL;
    Point shift;

    const char* keywords[] = { "src", "shift", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|O:AlignMTB.shiftMat", (char**)keywords, &pyobj_src, &pyobj_shift, &pyobj_dst) &&
        pyopencv_to(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to(pyobj_shift, shift, ArgInfo("shift", 0)) )
    {
        ERRWRAP2(_self_->shiftMat(src, dst, shift));
        return pyopencv_from(dst);
    }
    }

    return NULL;
}



static PyMethodDef pyopencv_AlignMTB_methods[] =
{
    {"calculateShift", (PyCFunction)pyopencv_cv_AlignMTB_calculateShift, METH_VARARGS | METH_KEYWORDS, "calculateShift(img0, img1) -> retval\n.   @brief Calculates shift between two images, i. e. how to shift the second image to correspond it with the\n.   first.\n.   \n.   @param img0 first image\n.   @param img1 second image"},
    {"computeBitmaps", (PyCFunction)pyopencv_cv_AlignMTB_computeBitmaps, METH_VARARGS | METH_KEYWORDS, "computeBitmaps(img[, tb[, eb]]) -> tb, eb\n.   @brief Computes median threshold and exclude bitmaps of given image.\n.   \n.   @param img input image\n.   @param tb median threshold bitmap\n.   @param eb exclude bitmap"},
    {"getCut", (PyCFunction)pyopencv_cv_AlignMTB_getCut, METH_VARARGS | METH_KEYWORDS, "getCut() -> retval\n."},
    {"getExcludeRange", (PyCFunction)pyopencv_cv_AlignMTB_getExcludeRange, METH_VARARGS | METH_KEYWORDS, "getExcludeRange() -> retval\n."},
    {"getMaxBits", (PyCFunction)pyopencv_cv_AlignMTB_getMaxBits, METH_VARARGS | METH_KEYWORDS, "getMaxBits() -> retval\n."},
    {"process", (PyCFunction)pyopencv_cv_AlignMTB_process, METH_VARARGS | METH_KEYWORDS, "process(src, dst, times, response) -> None\n.   \n\n\n\nprocess(src, dst) -> None\n.   @brief Short version of process, that doesn't take extra arguments.\n.   \n.   @param src vector of input images\n.   @param dst vector of aligned images"},
    {"setCut", (PyCFunction)pyopencv_cv_AlignMTB_setCut, METH_VARARGS | METH_KEYWORDS, "setCut(value) -> None\n."},
    {"setExcludeRange", (PyCFunction)pyopencv_cv_AlignMTB_setExcludeRange, METH_VARARGS | METH_KEYWORDS, "setExcludeRange(exclude_range) -> None\n."},
    {"setMaxBits", (PyCFunction)pyopencv_cv_AlignMTB_setMaxBits, METH_VARARGS | METH_KEYWORDS, "setMaxBits(max_bits) -> None\n."},
    {"shiftMat", (PyCFunction)pyopencv_cv_AlignMTB_shiftMat, METH_VARARGS | METH_KEYWORDS, "shiftMat(src, shift[, dst]) -> dst\n.   @brief Helper function, that shift Mat filling new regions with zeros.\n.   \n.   @param src input image\n.   @param dst result image\n.   @param shift shift value"},

    {NULL,          NULL}
};

static void pyopencv_AlignMTB_specials(void)
{
    pyopencv_AlignMTB_Type.tp_base = &pyopencv_AlignExposures_Type;
    pyopencv_AlignMTB_Type.tp_dealloc = pyopencv_AlignMTB_dealloc;
    pyopencv_AlignMTB_Type.tp_repr = pyopencv_AlignMTB_repr;
    pyopencv_AlignMTB_Type.tp_getset = pyopencv_AlignMTB_getseters;
    pyopencv_AlignMTB_Type.tp_init = (initproc)0;
    pyopencv_AlignMTB_Type.tp_methods = pyopencv_AlignMTB_methods;
}

static PyObject* pyopencv_CalibrateCRF_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<CalibrateCRF %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_CalibrateCRF_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_CalibrateCRF_process(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::CalibrateCRF* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_CalibrateCRF_Type))
        _self_ = dynamic_cast<cv::CalibrateCRF*>(((pyopencv_CalibrateCRF_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'CalibrateCRF' or its derivative)");
    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    Mat dst;
    PyObject* pyobj_times = NULL;
    Mat times;

    const char* keywords[] = { "src", "times", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|O:CalibrateCRF.process", (char**)keywords, &pyobj_src, &pyobj_times, &pyobj_dst) &&
        pyopencv_to(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to(pyobj_times, times, ArgInfo("times", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times));
        return pyopencv_from(dst);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    UMat dst;
    PyObject* pyobj_times = NULL;
    UMat times;

    const char* keywords[] = { "src", "times", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|O:CalibrateCRF.process", (char**)keywords, &pyobj_src, &pyobj_times, &pyobj_dst) &&
        pyopencv_to(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to(pyobj_times, times, ArgInfo("times", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times));
        return pyopencv_from(dst);
    }
    }

    return NULL;
}



static PyMethodDef pyopencv_CalibrateCRF_methods[] =
{
    {"process", (PyCFunction)pyopencv_cv_CalibrateCRF_process, METH_VARARGS | METH_KEYWORDS, "process(src, times[, dst]) -> dst\n.   @brief Recovers inverse camera response.\n.   \n.   @param src vector of input images\n.   @param dst 256x1 matrix with inverse camera response function\n.   @param times vector of exposure time values for each image"},

    {NULL,          NULL}
};

static void pyopencv_CalibrateCRF_specials(void)
{
    pyopencv_CalibrateCRF_Type.tp_base = &pyopencv_Algorithm_Type;
    pyopencv_CalibrateCRF_Type.tp_dealloc = pyopencv_CalibrateCRF_dealloc;
    pyopencv_CalibrateCRF_Type.tp_repr = pyopencv_CalibrateCRF_repr;
    pyopencv_CalibrateCRF_Type.tp_getset = pyopencv_CalibrateCRF_getseters;
    pyopencv_CalibrateCRF_Type.tp_init = (initproc)0;
    pyopencv_CalibrateCRF_Type.tp_methods = pyopencv_CalibrateCRF_methods;
}

static PyObject* pyopencv_CalibrateDebevec_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<CalibrateDebevec %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_CalibrateDebevec_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_CalibrateDebevec_getLambda(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::CalibrateDebevec* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_CalibrateDebevec_Type))
        _self_ = dynamic_cast<cv::CalibrateDebevec*>(((pyopencv_CalibrateDebevec_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'CalibrateDebevec' or its derivative)");
    float retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getLambda());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_CalibrateDebevec_getRandom(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::CalibrateDebevec* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_CalibrateDebevec_Type))
        _self_ = dynamic_cast<cv::CalibrateDebevec*>(((pyopencv_CalibrateDebevec_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'CalibrateDebevec' or its derivative)");
    bool retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getRandom());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_CalibrateDebevec_getSamples(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::CalibrateDebevec* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_CalibrateDebevec_Type))
        _self_ = dynamic_cast<cv::CalibrateDebevec*>(((pyopencv_CalibrateDebevec_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'CalibrateDebevec' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getSamples());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_CalibrateDebevec_setLambda(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::CalibrateDebevec* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_CalibrateDebevec_Type))
        _self_ = dynamic_cast<cv::CalibrateDebevec*>(((pyopencv_CalibrateDebevec_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'CalibrateDebevec' or its derivative)");
    float lambda=0.f;

    const char* keywords[] = { "lambda", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "f:CalibrateDebevec.setLambda", (char**)keywords, &lambda) )
    {
        ERRWRAP2(_self_->setLambda(lambda));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_CalibrateDebevec_setRandom(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::CalibrateDebevec* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_CalibrateDebevec_Type))
        _self_ = dynamic_cast<cv::CalibrateDebevec*>(((pyopencv_CalibrateDebevec_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'CalibrateDebevec' or its derivative)");
    bool random=0;

    const char* keywords[] = { "random", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "b:CalibrateDebevec.setRandom", (char**)keywords, &random) )
    {
        ERRWRAP2(_self_->setRandom(random));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_CalibrateDebevec_setSamples(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::CalibrateDebevec* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_CalibrateDebevec_Type))
        _self_ = dynamic_cast<cv::CalibrateDebevec*>(((pyopencv_CalibrateDebevec_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'CalibrateDebevec' or its derivative)");
    int samples=0;

    const char* keywords[] = { "samples", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:CalibrateDebevec.setSamples", (char**)keywords, &samples) )
    {
        ERRWRAP2(_self_->setSamples(samples));
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_CalibrateDebevec_methods[] =
{
    {"getLambda", (PyCFunction)pyopencv_cv_CalibrateDebevec_getLambda, METH_VARARGS | METH_KEYWORDS, "getLambda() -> retval\n."},
    {"getRandom", (PyCFunction)pyopencv_cv_CalibrateDebevec_getRandom, METH_VARARGS | METH_KEYWORDS, "getRandom() -> retval\n."},
    {"getSamples", (PyCFunction)pyopencv_cv_CalibrateDebevec_getSamples, METH_VARARGS | METH_KEYWORDS, "getSamples() -> retval\n."},
    {"setLambda", (PyCFunction)pyopencv_cv_CalibrateDebevec_setLambda, METH_VARARGS | METH_KEYWORDS, "setLambda(lambda) -> None\n."},
    {"setRandom", (PyCFunction)pyopencv_cv_CalibrateDebevec_setRandom, METH_VARARGS | METH_KEYWORDS, "setRandom(random) -> None\n."},
    {"setSamples", (PyCFunction)pyopencv_cv_CalibrateDebevec_setSamples, METH_VARARGS | METH_KEYWORDS, "setSamples(samples) -> None\n."},

    {NULL,          NULL}
};

static void pyopencv_CalibrateDebevec_specials(void)
{
    pyopencv_CalibrateDebevec_Type.tp_base = &pyopencv_CalibrateCRF_Type;
    pyopencv_CalibrateDebevec_Type.tp_dealloc = pyopencv_CalibrateDebevec_dealloc;
    pyopencv_CalibrateDebevec_Type.tp_repr = pyopencv_CalibrateDebevec_repr;
    pyopencv_CalibrateDebevec_Type.tp_getset = pyopencv_CalibrateDebevec_getseters;
    pyopencv_CalibrateDebevec_Type.tp_init = (initproc)0;
    pyopencv_CalibrateDebevec_Type.tp_methods = pyopencv_CalibrateDebevec_methods;
}

static PyObject* pyopencv_CalibrateRobertson_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<CalibrateRobertson %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_CalibrateRobertson_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_CalibrateRobertson_getMaxIter(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::CalibrateRobertson* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_CalibrateRobertson_Type))
        _self_ = dynamic_cast<cv::CalibrateRobertson*>(((pyopencv_CalibrateRobertson_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'CalibrateRobertson' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMaxIter());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_CalibrateRobertson_getRadiance(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::CalibrateRobertson* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_CalibrateRobertson_Type))
        _self_ = dynamic_cast<cv::CalibrateRobertson*>(((pyopencv_CalibrateRobertson_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'CalibrateRobertson' or its derivative)");
    Mat retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getRadiance());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_CalibrateRobertson_getThreshold(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::CalibrateRobertson* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_CalibrateRobertson_Type))
        _self_ = dynamic_cast<cv::CalibrateRobertson*>(((pyopencv_CalibrateRobertson_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'CalibrateRobertson' or its derivative)");
    float retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getThreshold());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_CalibrateRobertson_setMaxIter(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::CalibrateRobertson* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_CalibrateRobertson_Type))
        _self_ = dynamic_cast<cv::CalibrateRobertson*>(((pyopencv_CalibrateRobertson_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'CalibrateRobertson' or its derivative)");
    int max_iter=0;

    const char* keywords[] = { "max_iter", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:CalibrateRobertson.setMaxIter", (char**)keywords, &max_iter) )
    {
        ERRWRAP2(_self_->setMaxIter(max_iter));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_CalibrateRobertson_setThreshold(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::CalibrateRobertson* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_CalibrateRobertson_Type))
        _self_ = dynamic_cast<cv::CalibrateRobertson*>(((pyopencv_CalibrateRobertson_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'CalibrateRobertson' or its derivative)");
    float threshold=0.f;

    const char* keywords[] = { "threshold", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "f:CalibrateRobertson.setThreshold", (char**)keywords, &threshold) )
    {
        ERRWRAP2(_self_->setThreshold(threshold));
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_CalibrateRobertson_methods[] =
{
    {"getMaxIter", (PyCFunction)pyopencv_cv_CalibrateRobertson_getMaxIter, METH_VARARGS | METH_KEYWORDS, "getMaxIter() -> retval\n."},
    {"getRadiance", (PyCFunction)pyopencv_cv_CalibrateRobertson_getRadiance, METH_VARARGS | METH_KEYWORDS, "getRadiance() -> retval\n."},
    {"getThreshold", (PyCFunction)pyopencv_cv_CalibrateRobertson_getThreshold, METH_VARARGS | METH_KEYWORDS, "getThreshold() -> retval\n."},
    {"setMaxIter", (PyCFunction)pyopencv_cv_CalibrateRobertson_setMaxIter, METH_VARARGS | METH_KEYWORDS, "setMaxIter(max_iter) -> None\n."},
    {"setThreshold", (PyCFunction)pyopencv_cv_CalibrateRobertson_setThreshold, METH_VARARGS | METH_KEYWORDS, "setThreshold(threshold) -> None\n."},

    {NULL,          NULL}
};

static void pyopencv_CalibrateRobertson_specials(void)
{
    pyopencv_CalibrateRobertson_Type.tp_base = &pyopencv_CalibrateCRF_Type;
    pyopencv_CalibrateRobertson_Type.tp_dealloc = pyopencv_CalibrateRobertson_dealloc;
    pyopencv_CalibrateRobertson_Type.tp_repr = pyopencv_CalibrateRobertson_repr;
    pyopencv_CalibrateRobertson_Type.tp_getset = pyopencv_CalibrateRobertson_getseters;
    pyopencv_CalibrateRobertson_Type.tp_init = (initproc)0;
    pyopencv_CalibrateRobertson_Type.tp_methods = pyopencv_CalibrateRobertson_methods;
}

static PyObject* pyopencv_MergeExposures_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<MergeExposures %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_MergeExposures_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_MergeExposures_process(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::MergeExposures* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_MergeExposures_Type))
        _self_ = dynamic_cast<cv::MergeExposures*>(((pyopencv_MergeExposures_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'MergeExposures' or its derivative)");
    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    Mat dst;
    PyObject* pyobj_times = NULL;
    Mat times;
    PyObject* pyobj_response = NULL;
    Mat response;

    const char* keywords[] = { "src", "times", "response", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOO|O:MergeExposures.process", (char**)keywords, &pyobj_src, &pyobj_times, &pyobj_response, &pyobj_dst) &&
        pyopencv_to(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to(pyobj_times, times, ArgInfo("times", 0)) &&
        pyopencv_to(pyobj_response, response, ArgInfo("response", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times, response));
        return pyopencv_from(dst);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    UMat dst;
    PyObject* pyobj_times = NULL;
    UMat times;
    PyObject* pyobj_response = NULL;
    UMat response;

    const char* keywords[] = { "src", "times", "response", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOO|O:MergeExposures.process", (char**)keywords, &pyobj_src, &pyobj_times, &pyobj_response, &pyobj_dst) &&
        pyopencv_to(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to(pyobj_times, times, ArgInfo("times", 0)) &&
        pyopencv_to(pyobj_response, response, ArgInfo("response", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times, response));
        return pyopencv_from(dst);
    }
    }

    return NULL;
}



static PyMethodDef pyopencv_MergeExposures_methods[] =
{
    {"process", (PyCFunction)pyopencv_cv_MergeExposures_process, METH_VARARGS | METH_KEYWORDS, "process(src, times, response[, dst]) -> dst\n.   @brief Merges images.\n.   \n.   @param src vector of input images\n.   @param dst result image\n.   @param times vector of exposure time values for each image\n.   @param response 256x1 matrix with inverse camera response function for each pixel value, it should\n.   have the same number of channels as images."},

    {NULL,          NULL}
};

static void pyopencv_MergeExposures_specials(void)
{
    pyopencv_MergeExposures_Type.tp_base = &pyopencv_Algorithm_Type;
    pyopencv_MergeExposures_Type.tp_dealloc = pyopencv_MergeExposures_dealloc;
    pyopencv_MergeExposures_Type.tp_repr = pyopencv_MergeExposures_repr;
    pyopencv_MergeExposures_Type.tp_getset = pyopencv_MergeExposures_getseters;
    pyopencv_MergeExposures_Type.tp_init = (initproc)0;
    pyopencv_MergeExposures_Type.tp_methods = pyopencv_MergeExposures_methods;
}

static PyObject* pyopencv_MergeDebevec_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<MergeDebevec %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_MergeDebevec_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_MergeDebevec_process(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::MergeDebevec* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_MergeDebevec_Type))
        _self_ = dynamic_cast<cv::MergeDebevec*>(((pyopencv_MergeDebevec_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'MergeDebevec' or its derivative)");
    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    Mat dst;
    PyObject* pyobj_times = NULL;
    Mat times;
    PyObject* pyobj_response = NULL;
    Mat response;

    const char* keywords[] = { "src", "times", "response", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOO|O:MergeDebevec.process", (char**)keywords, &pyobj_src, &pyobj_times, &pyobj_response, &pyobj_dst) &&
        pyopencv_to(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to(pyobj_times, times, ArgInfo("times", 0)) &&
        pyopencv_to(pyobj_response, response, ArgInfo("response", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times, response));
        return pyopencv_from(dst);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    UMat dst;
    PyObject* pyobj_times = NULL;
    UMat times;
    PyObject* pyobj_response = NULL;
    UMat response;

    const char* keywords[] = { "src", "times", "response", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOO|O:MergeDebevec.process", (char**)keywords, &pyobj_src, &pyobj_times, &pyobj_response, &pyobj_dst) &&
        pyopencv_to(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to(pyobj_times, times, ArgInfo("times", 0)) &&
        pyopencv_to(pyobj_response, response, ArgInfo("response", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times, response));
        return pyopencv_from(dst);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    Mat dst;
    PyObject* pyobj_times = NULL;
    Mat times;

    const char* keywords[] = { "src", "times", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|O:MergeDebevec.process", (char**)keywords, &pyobj_src, &pyobj_times, &pyobj_dst) &&
        pyopencv_to(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to(pyobj_times, times, ArgInfo("times", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times));
        return pyopencv_from(dst);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    UMat dst;
    PyObject* pyobj_times = NULL;
    UMat times;

    const char* keywords[] = { "src", "times", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|O:MergeDebevec.process", (char**)keywords, &pyobj_src, &pyobj_times, &pyobj_dst) &&
        pyopencv_to(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to(pyobj_times, times, ArgInfo("times", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times));
        return pyopencv_from(dst);
    }
    }

    return NULL;
}



static PyMethodDef pyopencv_MergeDebevec_methods[] =
{
    {"process", (PyCFunction)pyopencv_cv_MergeDebevec_process, METH_VARARGS | METH_KEYWORDS, "process(src, times, response[, dst]) -> dst\n.   \n\n\n\nprocess(src, times[, dst]) -> dst\n."},

    {NULL,          NULL}
};

static void pyopencv_MergeDebevec_specials(void)
{
    pyopencv_MergeDebevec_Type.tp_base = &pyopencv_MergeExposures_Type;
    pyopencv_MergeDebevec_Type.tp_dealloc = pyopencv_MergeDebevec_dealloc;
    pyopencv_MergeDebevec_Type.tp_repr = pyopencv_MergeDebevec_repr;
    pyopencv_MergeDebevec_Type.tp_getset = pyopencv_MergeDebevec_getseters;
    pyopencv_MergeDebevec_Type.tp_init = (initproc)0;
    pyopencv_MergeDebevec_Type.tp_methods = pyopencv_MergeDebevec_methods;
}

static PyObject* pyopencv_MergeMertens_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<MergeMertens %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_MergeMertens_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_MergeMertens_getContrastWeight(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::MergeMertens* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_MergeMertens_Type))
        _self_ = dynamic_cast<cv::MergeMertens*>(((pyopencv_MergeMertens_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'MergeMertens' or its derivative)");
    float retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getContrastWeight());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_MergeMertens_getExposureWeight(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::MergeMertens* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_MergeMertens_Type))
        _self_ = dynamic_cast<cv::MergeMertens*>(((pyopencv_MergeMertens_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'MergeMertens' or its derivative)");
    float retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getExposureWeight());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_MergeMertens_getSaturationWeight(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::MergeMertens* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_MergeMertens_Type))
        _self_ = dynamic_cast<cv::MergeMertens*>(((pyopencv_MergeMertens_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'MergeMertens' or its derivative)");
    float retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getSaturationWeight());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_MergeMertens_process(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::MergeMertens* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_MergeMertens_Type))
        _self_ = dynamic_cast<cv::MergeMertens*>(((pyopencv_MergeMertens_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'MergeMertens' or its derivative)");
    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    Mat dst;
    PyObject* pyobj_times = NULL;
    Mat times;
    PyObject* pyobj_response = NULL;
    Mat response;

    const char* keywords[] = { "src", "times", "response", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOO|O:MergeMertens.process", (char**)keywords, &pyobj_src, &pyobj_times, &pyobj_response, &pyobj_dst) &&
        pyopencv_to(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to(pyobj_times, times, ArgInfo("times", 0)) &&
        pyopencv_to(pyobj_response, response, ArgInfo("response", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times, response));
        return pyopencv_from(dst);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    UMat dst;
    PyObject* pyobj_times = NULL;
    UMat times;
    PyObject* pyobj_response = NULL;
    UMat response;

    const char* keywords[] = { "src", "times", "response", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOO|O:MergeMertens.process", (char**)keywords, &pyobj_src, &pyobj_times, &pyobj_response, &pyobj_dst) &&
        pyopencv_to(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to(pyobj_times, times, ArgInfo("times", 0)) &&
        pyopencv_to(pyobj_response, response, ArgInfo("response", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times, response));
        return pyopencv_from(dst);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    Mat dst;

    const char* keywords[] = { "src", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:MergeMertens.process", (char**)keywords, &pyobj_src, &pyobj_dst) &&
        pyopencv_to(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to(pyobj_dst, dst, ArgInfo("dst", 1)) )
    {
        ERRWRAP2(_self_->process(src, dst));
        return pyopencv_from(dst);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    UMat dst;

    const char* keywords[] = { "src", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:MergeMertens.process", (char**)keywords, &pyobj_src, &pyobj_dst) &&
        pyopencv_to(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to(pyobj_dst, dst, ArgInfo("dst", 1)) )
    {
        ERRWRAP2(_self_->process(src, dst));
        return pyopencv_from(dst);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_MergeMertens_setContrastWeight(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::MergeMertens* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_MergeMertens_Type))
        _self_ = dynamic_cast<cv::MergeMertens*>(((pyopencv_MergeMertens_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'MergeMertens' or its derivative)");
    float contrast_weiht=0.f;

    const char* keywords[] = { "contrast_weiht", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "f:MergeMertens.setContrastWeight", (char**)keywords, &contrast_weiht) )
    {
        ERRWRAP2(_self_->setContrastWeight(contrast_weiht));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_MergeMertens_setExposureWeight(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::MergeMertens* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_MergeMertens_Type))
        _self_ = dynamic_cast<cv::MergeMertens*>(((pyopencv_MergeMertens_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'MergeMertens' or its derivative)");
    float exposure_weight=0.f;

    const char* keywords[] = { "exposure_weight", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "f:MergeMertens.setExposureWeight", (char**)keywords, &exposure_weight) )
    {
        ERRWRAP2(_self_->setExposureWeight(exposure_weight));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_MergeMertens_setSaturationWeight(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::MergeMertens* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_MergeMertens_Type))
        _self_ = dynamic_cast<cv::MergeMertens*>(((pyopencv_MergeMertens_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'MergeMertens' or its derivative)");
    float saturation_weight=0.f;

    const char* keywords[] = { "saturation_weight", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "f:MergeMertens.setSaturationWeight", (char**)keywords, &saturation_weight) )
    {
        ERRWRAP2(_self_->setSaturationWeight(saturation_weight));
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_MergeMertens_methods[] =
{
    {"getContrastWeight", (PyCFunction)pyopencv_cv_MergeMertens_getContrastWeight, METH_VARARGS | METH_KEYWORDS, "getContrastWeight() -> retval\n."},
    {"getExposureWeight", (PyCFunction)pyopencv_cv_MergeMertens_getExposureWeight, METH_VARARGS | METH_KEYWORDS, "getExposureWeight() -> retval\n."},
    {"getSaturationWeight", (PyCFunction)pyopencv_cv_MergeMertens_getSaturationWeight, METH_VARARGS | METH_KEYWORDS, "getSaturationWeight() -> retval\n."},
    {"process", (PyCFunction)pyopencv_cv_MergeMertens_process, METH_VARARGS | METH_KEYWORDS, "process(src, times, response[, dst]) -> dst\n.   \n\n\n\nprocess(src[, dst]) -> dst\n.   @brief Short version of process, that doesn't take extra arguments.\n.   \n.   @param src vector of input images\n.   @param dst result image"},
    {"setContrastWeight", (PyCFunction)pyopencv_cv_MergeMertens_setContrastWeight, METH_VARARGS | METH_KEYWORDS, "setContrastWeight(contrast_weiht) -> None\n."},
    {"setExposureWeight", (PyCFunction)pyopencv_cv_MergeMertens_setExposureWeight, METH_VARARGS | METH_KEYWORDS, "setExposureWeight(exposure_weight) -> None\n."},
    {"setSaturationWeight", (PyCFunction)pyopencv_cv_MergeMertens_setSaturationWeight, METH_VARARGS | METH_KEYWORDS, "setSaturationWeight(saturation_weight) -> None\n."},

    {NULL,          NULL}
};

static void pyopencv_MergeMertens_specials(void)
{
    pyopencv_MergeMertens_Type.tp_base = &pyopencv_MergeExposures_Type;
    pyopencv_MergeMertens_Type.tp_dealloc = pyopencv_MergeMertens_dealloc;
    pyopencv_MergeMertens_Type.tp_repr = pyopencv_MergeMertens_repr;
    pyopencv_MergeMertens_Type.tp_getset = pyopencv_MergeMertens_getseters;
    pyopencv_MergeMertens_Type.tp_init = (initproc)0;
    pyopencv_MergeMertens_Type.tp_methods = pyopencv_MergeMertens_methods;
}

static PyObject* pyopencv_MergeRobertson_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<MergeRobertson %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_MergeRobertson_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_MergeRobertson_process(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::MergeRobertson* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_MergeRobertson_Type))
        _self_ = dynamic_cast<cv::MergeRobertson*>(((pyopencv_MergeRobertson_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'MergeRobertson' or its derivative)");
    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    Mat dst;
    PyObject* pyobj_times = NULL;
    Mat times;
    PyObject* pyobj_response = NULL;
    Mat response;

    const char* keywords[] = { "src", "times", "response", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOO|O:MergeRobertson.process", (char**)keywords, &pyobj_src, &pyobj_times, &pyobj_response, &pyobj_dst) &&
        pyopencv_to(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to(pyobj_times, times, ArgInfo("times", 0)) &&
        pyopencv_to(pyobj_response, response, ArgInfo("response", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times, response));
        return pyopencv_from(dst);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    UMat dst;
    PyObject* pyobj_times = NULL;
    UMat times;
    PyObject* pyobj_response = NULL;
    UMat response;

    const char* keywords[] = { "src", "times", "response", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOO|O:MergeRobertson.process", (char**)keywords, &pyobj_src, &pyobj_times, &pyobj_response, &pyobj_dst) &&
        pyopencv_to(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to(pyobj_times, times, ArgInfo("times", 0)) &&
        pyopencv_to(pyobj_response, response, ArgInfo("response", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times, response));
        return pyopencv_from(dst);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    Mat dst;
    PyObject* pyobj_times = NULL;
    Mat times;

    const char* keywords[] = { "src", "times", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|O:MergeRobertson.process", (char**)keywords, &pyobj_src, &pyobj_times, &pyobj_dst) &&
        pyopencv_to(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to(pyobj_times, times, ArgInfo("times", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times));
        return pyopencv_from(dst);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    UMat dst;
    PyObject* pyobj_times = NULL;
    UMat times;

    const char* keywords[] = { "src", "times", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|O:MergeRobertson.process", (char**)keywords, &pyobj_src, &pyobj_times, &pyobj_dst) &&
        pyopencv_to(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to(pyobj_times, times, ArgInfo("times", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times));
        return pyopencv_from(dst);
    }
    }

    return NULL;
}



static PyMethodDef pyopencv_MergeRobertson_methods[] =
{
    {"process", (PyCFunction)pyopencv_cv_MergeRobertson_process, METH_VARARGS | METH_KEYWORDS, "process(src, times, response[, dst]) -> dst\n.   \n\n\n\nprocess(src, times[, dst]) -> dst\n."},

    {NULL,          NULL}
};

static void pyopencv_MergeRobertson_specials(void)
{
    pyopencv_MergeRobertson_Type.tp_base = &pyopencv_MergeExposures_Type;
    pyopencv_MergeRobertson_Type.tp_dealloc = pyopencv_MergeRobertson_dealloc;
    pyopencv_MergeRobertson_Type.tp_repr = pyopencv_MergeRobertson_repr;
    pyopencv_MergeRobertson_Type.tp_getset = pyopencv_MergeRobertson_getseters;
    pyopencv_MergeRobertson_Type.tp_init = (initproc)0;
    pyopencv_MergeRobertson_Type.tp_methods = pyopencv_MergeRobertson_methods;
}

static PyObject* pyopencv_plot_Plot2d_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<plot_Plot2d %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_plot_Plot2d_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_plot_plot_Plot2d_create_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::plot;

    {
    PyObject* pyobj_data = NULL;
    Mat data;
    Ptr<Plot2d> retval;

    const char* keywords[] = { "data", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:plot_Plot2d.create", (char**)keywords, &pyobj_data) &&
        pyopencv_to(pyobj_data, data, ArgInfo("data", 0)) )
    {
        ERRWRAP2(retval = cv::plot::Plot2d::create(data));
        return pyopencv_from(retval);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_data = NULL;
    UMat data;
    Ptr<Plot2d> retval;

    const char* keywords[] = { "data", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:plot_Plot2d.create", (char**)keywords, &pyobj_data) &&
        pyopencv_to(pyobj_data, data, ArgInfo("data", 0)) )
    {
        ERRWRAP2(retval = cv::plot::Plot2d::create(data));
        return pyopencv_from(retval);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_dataX = NULL;
    Mat dataX;
    PyObject* pyobj_dataY = NULL;
    Mat dataY;
    Ptr<Plot2d> retval;

    const char* keywords[] = { "dataX", "dataY", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:plot_Plot2d.create", (char**)keywords, &pyobj_dataX, &pyobj_dataY) &&
        pyopencv_to(pyobj_dataX, dataX, ArgInfo("dataX", 0)) &&
        pyopencv_to(pyobj_dataY, dataY, ArgInfo("dataY", 0)) )
    {
        ERRWRAP2(retval = cv::plot::Plot2d::create(dataX, dataY));
        return pyopencv_from(retval);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_dataX = NULL;
    UMat dataX;
    PyObject* pyobj_dataY = NULL;
    UMat dataY;
    Ptr<Plot2d> retval;

    const char* keywords[] = { "dataX", "dataY", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:plot_Plot2d.create", (char**)keywords, &pyobj_dataX, &pyobj_dataY) &&
        pyopencv_to(pyobj_dataX, dataX, ArgInfo("dataX", 0)) &&
        pyopencv_to(pyobj_dataY, dataY, ArgInfo("dataY", 0)) )
    {
        ERRWRAP2(retval = cv::plot::Plot2d::create(dataX, dataY));
        return pyopencv_from(retval);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_plot_plot_Plot2d_render(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::plot;

    cv::plot::Plot2d* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_plot_Plot2d_Type))
        _self_ = dynamic_cast<cv::plot::Plot2d*>(((pyopencv_plot_Plot2d_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'plot_Plot2d' or its derivative)");
    {
    PyObject* pyobj__plotResult = NULL;
    Mat _plotResult;

    const char* keywords[] = { "_plotResult", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "|O:plot_Plot2d.render", (char**)keywords, &pyobj__plotResult) &&
        pyopencv_to(pyobj__plotResult, _plotResult, ArgInfo("_plotResult", 1)) )
    {
        ERRWRAP2(_self_->render(_plotResult));
        return pyopencv_from(_plotResult);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj__plotResult = NULL;
    UMat _plotResult;

    const char* keywords[] = { "_plotResult", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "|O:plot_Plot2d.render", (char**)keywords, &pyobj__plotResult) &&
        pyopencv_to(pyobj__plotResult, _plotResult, ArgInfo("_plotResult", 1)) )
    {
        ERRWRAP2(_self_->render(_plotResult));
        return pyopencv_from(_plotResult);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_plot_plot_Plot2d_setGridLinesNumber(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::plot;

    cv::plot::Plot2d* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_plot_Plot2d_Type))
        _self_ = dynamic_cast<cv::plot::Plot2d*>(((pyopencv_plot_Plot2d_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'plot_Plot2d' or its derivative)");
    int gridLinesNumber=0;

    const char* keywords[] = { "gridLinesNumber", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:plot_Plot2d.setGridLinesNumber", (char**)keywords, &gridLinesNumber) )
    {
        ERRWRAP2(_self_->setGridLinesNumber(gridLinesNumber));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_plot_plot_Plot2d_setInvertOrientation(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::plot;

    cv::plot::Plot2d* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_plot_Plot2d_Type))
        _self_ = dynamic_cast<cv::plot::Plot2d*>(((pyopencv_plot_Plot2d_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'plot_Plot2d' or its derivative)");
    bool _invertOrientation=0;

    const char* keywords[] = { "_invertOrientation", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "b:plot_Plot2d.setInvertOrientation", (char**)keywords, &_invertOrientation) )
    {
        ERRWRAP2(_self_->setInvertOrientation(_invertOrientation));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_plot_plot_Plot2d_setMaxX(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::plot;

    cv::plot::Plot2d* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_plot_Plot2d_Type))
        _self_ = dynamic_cast<cv::plot::Plot2d*>(((pyopencv_plot_Plot2d_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'plot_Plot2d' or its derivative)");
    double _plotMaxX=0;

    const char* keywords[] = { "_plotMaxX", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:plot_Plot2d.setMaxX", (char**)keywords, &_plotMaxX) )
    {
        ERRWRAP2(_self_->setMaxX(_plotMaxX));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_plot_plot_Plot2d_setMaxY(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::plot;

    cv::plot::Plot2d* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_plot_Plot2d_Type))
        _self_ = dynamic_cast<cv::plot::Plot2d*>(((pyopencv_plot_Plot2d_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'plot_Plot2d' or its derivative)");
    double _plotMaxY=0;

    const char* keywords[] = { "_plotMaxY", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:plot_Plot2d.setMaxY", (char**)keywords, &_plotMaxY) )
    {
        ERRWRAP2(_self_->setMaxY(_plotMaxY));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_plot_plot_Plot2d_setMinX(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::plot;

    cv::plot::Plot2d* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_plot_Plot2d_Type))
        _self_ = dynamic_cast<cv::plot::Plot2d*>(((pyopencv_plot_Plot2d_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'plot_Plot2d' or its derivative)");
    double _plotMinX=0;

    const char* keywords[] = { "_plotMinX", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:plot_Plot2d.setMinX", (char**)keywords, &_plotMinX) )
    {
        ERRWRAP2(_self_->setMinX(_plotMinX));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_plot_plot_Plot2d_setMinY(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::plot;

    cv::plot::Plot2d* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_plot_Plot2d_Type))
        _self_ = dynamic_cast<cv::plot::Plot2d*>(((pyopencv_plot_Plot2d_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'plot_Plot2d' or its derivative)");
    double _plotMinY=0;

    const char* keywords[] = { "_plotMinY", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:plot_Plot2d.setMinY", (char**)keywords, &_plotMinY) )
    {
        ERRWRAP2(_self_->setMinY(_plotMinY));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_plot_plot_Plot2d_setNeedPlotLine(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::plot;

    cv::plot::Plot2d* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_plot_Plot2d_Type))
        _self_ = dynamic_cast<cv::plot::Plot2d*>(((pyopencv_plot_Plot2d_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'plot_Plot2d' or its derivative)");
    bool _needPlotLine=0;

    const char* keywords[] = { "_needPlotLine", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "b:plot_Plot2d.setNeedPlotLine", (char**)keywords, &_needPlotLine) )
    {
        ERRWRAP2(_self_->setNeedPlotLine(_needPlotLine));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_plot_plot_Plot2d_setPlotAxisColor(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::plot;

    cv::plot::Plot2d* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_plot_Plot2d_Type))
        _self_ = dynamic_cast<cv::plot::Plot2d*>(((pyopencv_plot_Plot2d_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'plot_Plot2d' or its derivative)");
    PyObject* pyobj__plotAxisColor = NULL;
    Scalar _plotAxisColor;

    const char* keywords[] = { "_plotAxisColor", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:plot_Plot2d.setPlotAxisColor", (char**)keywords, &pyobj__plotAxisColor) &&
        pyopencv_to(pyobj__plotAxisColor, _plotAxisColor, ArgInfo("_plotAxisColor", 0)) )
    {
        ERRWRAP2(_self_->setPlotAxisColor(_plotAxisColor));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_plot_plot_Plot2d_setPlotBackgroundColor(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::plot;

    cv::plot::Plot2d* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_plot_Plot2d_Type))
        _self_ = dynamic_cast<cv::plot::Plot2d*>(((pyopencv_plot_Plot2d_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'plot_Plot2d' or its derivative)");
    PyObject* pyobj__plotBackgroundColor = NULL;
    Scalar _plotBackgroundColor;

    const char* keywords[] = { "_plotBackgroundColor", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:plot_Plot2d.setPlotBackgroundColor", (char**)keywords, &pyobj__plotBackgroundColor) &&
        pyopencv_to(pyobj__plotBackgroundColor, _plotBackgroundColor, ArgInfo("_plotBackgroundColor", 0)) )
    {
        ERRWRAP2(_self_->setPlotBackgroundColor(_plotBackgroundColor));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_plot_plot_Plot2d_setPlotGridColor(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::plot;

    cv::plot::Plot2d* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_plot_Plot2d_Type))
        _self_ = dynamic_cast<cv::plot::Plot2d*>(((pyopencv_plot_Plot2d_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'plot_Plot2d' or its derivative)");
    PyObject* pyobj__plotGridColor = NULL;
    Scalar _plotGridColor;

    const char* keywords[] = { "_plotGridColor", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:plot_Plot2d.setPlotGridColor", (char**)keywords, &pyobj__plotGridColor) &&
        pyopencv_to(pyobj__plotGridColor, _plotGridColor, ArgInfo("_plotGridColor", 0)) )
    {
        ERRWRAP2(_self_->setPlotGridColor(_plotGridColor));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_plot_plot_Plot2d_setPlotLineColor(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::plot;

    cv::plot::Plot2d* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_plot_Plot2d_Type))
        _self_ = dynamic_cast<cv::plot::Plot2d*>(((pyopencv_plot_Plot2d_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'plot_Plot2d' or its derivative)");
    PyObject* pyobj__plotLineColor = NULL;
    Scalar _plotLineColor;

    const char* keywords[] = { "_plotLineColor", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:plot_Plot2d.setPlotLineColor", (char**)keywords, &pyobj__plotLineColor) &&
        pyopencv_to(pyobj__plotLineColor, _plotLineColor, ArgInfo("_plotLineColor", 0)) )
    {
        ERRWRAP2(_self_->setPlotLineColor(_plotLineColor));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_plot_plot_Plot2d_setPlotLineWidth(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::plot;

    cv::plot::Plot2d* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_plot_Plot2d_Type))
        _self_ = dynamic_cast<cv::plot::Plot2d*>(((pyopencv_plot_Plot2d_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'plot_Plot2d' or its derivative)");
    int _plotLineWidth=0;

    const char* keywords[] = { "_plotLineWidth", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:plot_Plot2d.setPlotLineWidth", (char**)keywords, &_plotLineWidth) )
    {
        ERRWRAP2(_self_->setPlotLineWidth(_plotLineWidth));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_plot_plot_Plot2d_setPlotSize(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::plot;

    cv::plot::Plot2d* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_plot_Plot2d_Type))
        _self_ = dynamic_cast<cv::plot::Plot2d*>(((pyopencv_plot_Plot2d_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'plot_Plot2d' or its derivative)");
    int _plotSizeWidth=0;
    int _plotSizeHeight=0;

    const char* keywords[] = { "_plotSizeWidth", "_plotSizeHeight", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "ii:plot_Plot2d.setPlotSize", (char**)keywords, &_plotSizeWidth, &_plotSizeHeight) )
    {
        ERRWRAP2(_self_->setPlotSize(_plotSizeWidth, _plotSizeHeight));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_plot_plot_Plot2d_setPlotTextColor(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::plot;

    cv::plot::Plot2d* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_plot_Plot2d_Type))
        _self_ = dynamic_cast<cv::plot::Plot2d*>(((pyopencv_plot_Plot2d_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'plot_Plot2d' or its derivative)");
    PyObject* pyobj__plotTextColor = NULL;
    Scalar _plotTextColor;

    const char* keywords[] = { "_plotTextColor", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:plot_Plot2d.setPlotTextColor", (char**)keywords, &pyobj__plotTextColor) &&
        pyopencv_to(pyobj__plotTextColor, _plotTextColor, ArgInfo("_plotTextColor", 0)) )
    {
        ERRWRAP2(_self_->setPlotTextColor(_plotTextColor));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_plot_plot_Plot2d_setPointIdxToPrint(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::plot;

    cv::plot::Plot2d* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_plot_Plot2d_Type))
        _self_ = dynamic_cast<cv::plot::Plot2d*>(((pyopencv_plot_Plot2d_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'plot_Plot2d' or its derivative)");
    int pointIdx=0;

    const char* keywords[] = { "pointIdx", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:plot_Plot2d.setPointIdxToPrint", (char**)keywords, &pointIdx) )
    {
        ERRWRAP2(_self_->setPointIdxToPrint(pointIdx));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_plot_plot_Plot2d_setShowGrid(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::plot;

    cv::plot::Plot2d* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_plot_Plot2d_Type))
        _self_ = dynamic_cast<cv::plot::Plot2d*>(((pyopencv_plot_Plot2d_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'plot_Plot2d' or its derivative)");
    bool needShowGrid=0;

    const char* keywords[] = { "needShowGrid", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "b:plot_Plot2d.setShowGrid", (char**)keywords, &needShowGrid) )
    {
        ERRWRAP2(_self_->setShowGrid(needShowGrid));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_plot_plot_Plot2d_setShowText(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::plot;

    cv::plot::Plot2d* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_plot_Plot2d_Type))
        _self_ = dynamic_cast<cv::plot::Plot2d*>(((pyopencv_plot_Plot2d_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'plot_Plot2d' or its derivative)");
    bool needShowText=0;

    const char* keywords[] = { "needShowText", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "b:plot_Plot2d.setShowText", (char**)keywords, &needShowText) )
    {
        ERRWRAP2(_self_->setShowText(needShowText));
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_plot_Plot2d_methods[] =
{
    {"create", (PyCFunction)pyopencv_cv_plot_plot_Plot2d_create_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "create(data) -> retval\n.   * @brief Creates Plot2d object\n.   *\n.   * @param data \\f$1xN\\f$ or \\f$Nx1\\f$ matrix containing \\f$Y\\f$ values of points to plot. \\f$X\\f$ values\n.   * will be equal to indexes of correspondind elements in data matrix.\n\n\n\ncreate(dataX, dataY) -> retval\n.   * @brief Creates Plot2d object\n.   *\n.   * @param dataX \\f$1xN\\f$ or \\f$Nx1\\f$ matrix \\f$X\\f$ values of points to plot.\n.   * @param dataY \\f$1xN\\f$ or \\f$Nx1\\f$ matrix containing \\f$Y\\f$ values of points to plot."},
    {"render", (PyCFunction)pyopencv_cv_plot_plot_Plot2d_render, METH_VARARGS | METH_KEYWORDS, "render([, _plotResult]) -> _plotResult\n."},
    {"setGridLinesNumber", (PyCFunction)pyopencv_cv_plot_plot_Plot2d_setGridLinesNumber, METH_VARARGS | METH_KEYWORDS, "setGridLinesNumber(gridLinesNumber) -> None\n."},
    {"setInvertOrientation", (PyCFunction)pyopencv_cv_plot_plot_Plot2d_setInvertOrientation, METH_VARARGS | METH_KEYWORDS, "setInvertOrientation(_invertOrientation) -> None\n."},
    {"setMaxX", (PyCFunction)pyopencv_cv_plot_plot_Plot2d_setMaxX, METH_VARARGS | METH_KEYWORDS, "setMaxX(_plotMaxX) -> None\n."},
    {"setMaxY", (PyCFunction)pyopencv_cv_plot_plot_Plot2d_setMaxY, METH_VARARGS | METH_KEYWORDS, "setMaxY(_plotMaxY) -> None\n."},
    {"setMinX", (PyCFunction)pyopencv_cv_plot_plot_Plot2d_setMinX, METH_VARARGS | METH_KEYWORDS, "setMinX(_plotMinX) -> None\n."},
    {"setMinY", (PyCFunction)pyopencv_cv_plot_plot_Plot2d_setMinY, METH_VARARGS | METH_KEYWORDS, "setMinY(_plotMinY) -> None\n."},
    {"setNeedPlotLine", (PyCFunction)pyopencv_cv_plot_plot_Plot2d_setNeedPlotLine, METH_VARARGS | METH_KEYWORDS, "setNeedPlotLine(_needPlotLine) -> None\n.   * @brief Switches data visualization mode\n.   *\n.   * @param _needPlotLine if true then neighbour plot points will be connected by lines.\n.   * In other case data will be plotted as a set of standalone points."},
    {"setPlotAxisColor", (PyCFunction)pyopencv_cv_plot_plot_Plot2d_setPlotAxisColor, METH_VARARGS | METH_KEYWORDS, "setPlotAxisColor(_plotAxisColor) -> None\n."},
    {"setPlotBackgroundColor", (PyCFunction)pyopencv_cv_plot_plot_Plot2d_setPlotBackgroundColor, METH_VARARGS | METH_KEYWORDS, "setPlotBackgroundColor(_plotBackgroundColor) -> None\n."},
    {"setPlotGridColor", (PyCFunction)pyopencv_cv_plot_plot_Plot2d_setPlotGridColor, METH_VARARGS | METH_KEYWORDS, "setPlotGridColor(_plotGridColor) -> None\n."},
    {"setPlotLineColor", (PyCFunction)pyopencv_cv_plot_plot_Plot2d_setPlotLineColor, METH_VARARGS | METH_KEYWORDS, "setPlotLineColor(_plotLineColor) -> None\n."},
    {"setPlotLineWidth", (PyCFunction)pyopencv_cv_plot_plot_Plot2d_setPlotLineWidth, METH_VARARGS | METH_KEYWORDS, "setPlotLineWidth(_plotLineWidth) -> None\n."},
    {"setPlotSize", (PyCFunction)pyopencv_cv_plot_plot_Plot2d_setPlotSize, METH_VARARGS | METH_KEYWORDS, "setPlotSize(_plotSizeWidth, _plotSizeHeight) -> None\n."},
    {"setPlotTextColor", (PyCFunction)pyopencv_cv_plot_plot_Plot2d_setPlotTextColor, METH_VARARGS | METH_KEYWORDS, "setPlotTextColor(_plotTextColor) -> None\n."},
    {"setPointIdxToPrint", (PyCFunction)pyopencv_cv_plot_plot_Plot2d_setPointIdxToPrint, METH_VARARGS | METH_KEYWORDS, "setPointIdxToPrint(pointIdx) -> None\n.   * @brief Sets the index of a point which coordinates will be printed on the top left corner of the plot (if ShowText flag is true).\n.   *\n.   * @param pointIdx index of the required point in data array."},
    {"setShowGrid", (PyCFunction)pyopencv_cv_plot_plot_Plot2d_setShowGrid, METH_VARARGS | METH_KEYWORDS, "setShowGrid(needShowGrid) -> None\n."},
    {"setShowText", (PyCFunction)pyopencv_cv_plot_plot_Plot2d_setShowText, METH_VARARGS | METH_KEYWORDS, "setShowText(needShowText) -> None\n."},

    {NULL,          NULL}
};

static void pyopencv_plot_Plot2d_specials(void)
{
    pyopencv_plot_Plot2d_Type.tp_base = &pyopencv_Algorithm_Type;
    pyopencv_plot_Plot2d_Type.tp_dealloc = pyopencv_plot_Plot2d_dealloc;
    pyopencv_plot_Plot2d_Type.tp_repr = pyopencv_plot_Plot2d_repr;
    pyopencv_plot_Plot2d_Type.tp_getset = pyopencv_plot_Plot2d_getseters;
    pyopencv_plot_Plot2d_Type.tp_init = (initproc)0;
    pyopencv_plot_Plot2d_Type.tp_methods = pyopencv_plot_Plot2d_methods;
}

static PyObject* pyopencv_reg_Map_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<reg_Map %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_reg_Map_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_reg_reg_Map_compose(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::Map* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_Map_Type))
        _self_ = ((pyopencv_reg_Map_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_Map' or its derivative)");
    PyObject* pyobj_map = NULL;
    Ptr<Map> map;

    const char* keywords[] = { "map", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:reg_Map.compose", (char**)keywords, &pyobj_map) &&
        pyopencv_to(pyobj_map, map, ArgInfo("map", 0)) )
    {
        ERRWRAP2(_self_->compose(map));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_reg_reg_Map_inverseMap(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::Map* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_Map_Type))
        _self_ = ((pyopencv_reg_Map_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_Map' or its derivative)");
    cv::Ptr<Map> retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->inverseMap());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_reg_reg_Map_inverseWarp(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::Map* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_Map_Type))
        _self_ = ((pyopencv_reg_Map_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_Map' or its derivative)");
    {
    PyObject* pyobj_img1 = NULL;
    Mat img1;
    PyObject* pyobj_img2 = NULL;
    Mat img2;

    const char* keywords[] = { "img1", "img2", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:reg_Map.inverseWarp", (char**)keywords, &pyobj_img1, &pyobj_img2) &&
        pyopencv_to(pyobj_img1, img1, ArgInfo("img1", 0)) &&
        pyopencv_to(pyobj_img2, img2, ArgInfo("img2", 1)) )
    {
        ERRWRAP2(_self_->inverseWarp(img1, img2));
        return pyopencv_from(img2);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_img1 = NULL;
    UMat img1;
    PyObject* pyobj_img2 = NULL;
    UMat img2;

    const char* keywords[] = { "img1", "img2", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:reg_Map.inverseWarp", (char**)keywords, &pyobj_img1, &pyobj_img2) &&
        pyopencv_to(pyobj_img1, img1, ArgInfo("img1", 0)) &&
        pyopencv_to(pyobj_img2, img2, ArgInfo("img2", 1)) )
    {
        ERRWRAP2(_self_->inverseWarp(img1, img2));
        return pyopencv_from(img2);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_reg_reg_Map_scale(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::Map* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_Map_Type))
        _self_ = ((pyopencv_reg_Map_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_Map' or its derivative)");
    double factor=0;

    const char* keywords[] = { "factor", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:reg_Map.scale", (char**)keywords, &factor) )
    {
        ERRWRAP2(_self_->scale(factor));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_reg_reg_Map_warp(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::Map* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_Map_Type))
        _self_ = ((pyopencv_reg_Map_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_Map' or its derivative)");
    {
    PyObject* pyobj_img1 = NULL;
    Mat img1;
    PyObject* pyobj_img2 = NULL;
    Mat img2;

    const char* keywords[] = { "img1", "img2", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:reg_Map.warp", (char**)keywords, &pyobj_img1, &pyobj_img2) &&
        pyopencv_to(pyobj_img1, img1, ArgInfo("img1", 0)) &&
        pyopencv_to(pyobj_img2, img2, ArgInfo("img2", 1)) )
    {
        ERRWRAP2(_self_->warp(img1, img2));
        return pyopencv_from(img2);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_img1 = NULL;
    UMat img1;
    PyObject* pyobj_img2 = NULL;
    UMat img2;

    const char* keywords[] = { "img1", "img2", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:reg_Map.warp", (char**)keywords, &pyobj_img1, &pyobj_img2) &&
        pyopencv_to(pyobj_img1, img1, ArgInfo("img1", 0)) &&
        pyopencv_to(pyobj_img2, img2, ArgInfo("img2", 1)) )
    {
        ERRWRAP2(_self_->warp(img1, img2));
        return pyopencv_from(img2);
    }
    }

    return NULL;
}



static PyMethodDef pyopencv_reg_Map_methods[] =
{
    {"compose", (PyCFunction)pyopencv_cv_reg_reg_Map_compose, METH_VARARGS | METH_KEYWORDS, "compose(map) -> None\n."},
    {"inverseMap", (PyCFunction)pyopencv_cv_reg_reg_Map_inverseMap, METH_VARARGS | METH_KEYWORDS, "inverseMap() -> retval\n."},
    {"inverseWarp", (PyCFunction)pyopencv_cv_reg_reg_Map_inverseWarp, METH_VARARGS | METH_KEYWORDS, "inverseWarp(img1[, img2]) -> img2\n."},
    {"scale", (PyCFunction)pyopencv_cv_reg_reg_Map_scale, METH_VARARGS | METH_KEYWORDS, "scale(factor) -> None\n."},
    {"warp", (PyCFunction)pyopencv_cv_reg_reg_Map_warp, METH_VARARGS | METH_KEYWORDS, "warp(img1[, img2]) -> img2\n."},

    {NULL,          NULL}
};

static void pyopencv_reg_Map_specials(void)
{
    pyopencv_reg_Map_Type.tp_base = NULL;
    pyopencv_reg_Map_Type.tp_dealloc = pyopencv_reg_Map_dealloc;
    pyopencv_reg_Map_Type.tp_repr = pyopencv_reg_Map_repr;
    pyopencv_reg_Map_Type.tp_getset = pyopencv_reg_Map_getseters;
    pyopencv_reg_Map_Type.tp_init = (initproc)0;
    pyopencv_reg_Map_Type.tp_methods = pyopencv_reg_Map_methods;
}

static PyObject* pyopencv_reg_MapAffine_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<reg_MapAffine %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_reg_MapAffine_getseters[] =
{
    {NULL}  /* Sentinel */
};

static int pyopencv_cv_reg_reg_MapAffine_MapAffine(pyopencv_reg_MapAffine_t* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    {

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        new (&(self->v)) Ptr<cv::reg::MapAffine>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::reg::MapAffine()));
        return 0;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_linTr = NULL;
    Mat linTr;
    PyObject* pyobj_shift = NULL;
    Mat shift;

    const char* keywords[] = { "linTr", "shift", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:MapAffine", (char**)keywords, &pyobj_linTr, &pyobj_shift) &&
        pyopencv_to(pyobj_linTr, linTr, ArgInfo("linTr", 0)) &&
        pyopencv_to(pyobj_shift, shift, ArgInfo("shift", 0)) )
    {
        new (&(self->v)) Ptr<cv::reg::MapAffine>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::reg::MapAffine(linTr, shift)));
        return 0;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_linTr = NULL;
    UMat linTr;
    PyObject* pyobj_shift = NULL;
    UMat shift;

    const char* keywords[] = { "linTr", "shift", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:MapAffine", (char**)keywords, &pyobj_linTr, &pyobj_shift) &&
        pyopencv_to(pyobj_linTr, linTr, ArgInfo("linTr", 0)) &&
        pyopencv_to(pyobj_shift, shift, ArgInfo("shift", 0)) )
    {
        new (&(self->v)) Ptr<cv::reg::MapAffine>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::reg::MapAffine(linTr, shift)));
        return 0;
    }
    }

    return -1;
}

static PyObject* pyopencv_cv_reg_reg_MapAffine_compose(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapAffine* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapAffine_Type))
        _self_ = ((pyopencv_reg_MapAffine_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapAffine' or its derivative)");
    PyObject* pyobj_map = NULL;
    Ptr<Map> map;

    const char* keywords[] = { "map", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:reg_MapAffine.compose", (char**)keywords, &pyobj_map) &&
        pyopencv_to(pyobj_map, map, ArgInfo("map", 0)) )
    {
        ERRWRAP2(_self_->compose(map));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_reg_reg_MapAffine_getLinTr(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapAffine* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapAffine_Type))
        _self_ = ((pyopencv_reg_MapAffine_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapAffine' or its derivative)");
    {
    PyObject* pyobj_linTr = NULL;
    Mat linTr;

    const char* keywords[] = { "linTr", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "|O:reg_MapAffine.getLinTr", (char**)keywords, &pyobj_linTr) &&
        pyopencv_to(pyobj_linTr, linTr, ArgInfo("linTr", 1)) )
    {
        ERRWRAP2(_self_->getLinTr(linTr));
        return pyopencv_from(linTr);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_linTr = NULL;
    UMat linTr;

    const char* keywords[] = { "linTr", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "|O:reg_MapAffine.getLinTr", (char**)keywords, &pyobj_linTr) &&
        pyopencv_to(pyobj_linTr, linTr, ArgInfo("linTr", 1)) )
    {
        ERRWRAP2(_self_->getLinTr(linTr));
        return pyopencv_from(linTr);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_reg_reg_MapAffine_getShift(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapAffine* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapAffine_Type))
        _self_ = ((pyopencv_reg_MapAffine_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapAffine' or its derivative)");
    {
    PyObject* pyobj_shift = NULL;
    Mat shift;

    const char* keywords[] = { "shift", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "|O:reg_MapAffine.getShift", (char**)keywords, &pyobj_shift) &&
        pyopencv_to(pyobj_shift, shift, ArgInfo("shift", 1)) )
    {
        ERRWRAP2(_self_->getShift(shift));
        return pyopencv_from(shift);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_shift = NULL;
    UMat shift;

    const char* keywords[] = { "shift", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "|O:reg_MapAffine.getShift", (char**)keywords, &pyobj_shift) &&
        pyopencv_to(pyobj_shift, shift, ArgInfo("shift", 1)) )
    {
        ERRWRAP2(_self_->getShift(shift));
        return pyopencv_from(shift);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_reg_reg_MapAffine_inverseMap(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapAffine* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapAffine_Type))
        _self_ = ((pyopencv_reg_MapAffine_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapAffine' or its derivative)");
    cv::Ptr<Map> retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->inverseMap());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_reg_reg_MapAffine_inverseWarp(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapAffine* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapAffine_Type))
        _self_ = ((pyopencv_reg_MapAffine_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapAffine' or its derivative)");
    {
    PyObject* pyobj_img1 = NULL;
    Mat img1;
    PyObject* pyobj_img2 = NULL;
    Mat img2;

    const char* keywords[] = { "img1", "img2", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:reg_MapAffine.inverseWarp", (char**)keywords, &pyobj_img1, &pyobj_img2) &&
        pyopencv_to(pyobj_img1, img1, ArgInfo("img1", 0)) &&
        pyopencv_to(pyobj_img2, img2, ArgInfo("img2", 1)) )
    {
        ERRWRAP2(_self_->inverseWarp(img1, img2));
        return pyopencv_from(img2);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_img1 = NULL;
    UMat img1;
    PyObject* pyobj_img2 = NULL;
    UMat img2;

    const char* keywords[] = { "img1", "img2", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:reg_MapAffine.inverseWarp", (char**)keywords, &pyobj_img1, &pyobj_img2) &&
        pyopencv_to(pyobj_img1, img1, ArgInfo("img1", 0)) &&
        pyopencv_to(pyobj_img2, img2, ArgInfo("img2", 1)) )
    {
        ERRWRAP2(_self_->inverseWarp(img1, img2));
        return pyopencv_from(img2);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_reg_reg_MapAffine_scale(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapAffine* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapAffine_Type))
        _self_ = ((pyopencv_reg_MapAffine_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapAffine' or its derivative)");
    double factor=0;

    const char* keywords[] = { "factor", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:reg_MapAffine.scale", (char**)keywords, &factor) )
    {
        ERRWRAP2(_self_->scale(factor));
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_reg_MapAffine_methods[] =
{
    {"compose", (PyCFunction)pyopencv_cv_reg_reg_MapAffine_compose, METH_VARARGS | METH_KEYWORDS, "compose(map) -> None\n."},
    {"getLinTr", (PyCFunction)pyopencv_cv_reg_reg_MapAffine_getLinTr, METH_VARARGS | METH_KEYWORDS, "getLinTr([, linTr]) -> linTr\n."},
    {"getShift", (PyCFunction)pyopencv_cv_reg_reg_MapAffine_getShift, METH_VARARGS | METH_KEYWORDS, "getShift([, shift]) -> shift\n."},
    {"inverseMap", (PyCFunction)pyopencv_cv_reg_reg_MapAffine_inverseMap, METH_VARARGS | METH_KEYWORDS, "inverseMap() -> retval\n."},
    {"inverseWarp", (PyCFunction)pyopencv_cv_reg_reg_MapAffine_inverseWarp, METH_VARARGS | METH_KEYWORDS, "inverseWarp(img1[, img2]) -> img2\n."},
    {"scale", (PyCFunction)pyopencv_cv_reg_reg_MapAffine_scale, METH_VARARGS | METH_KEYWORDS, "scale(factor) -> None\n."},

    {NULL,          NULL}
};

static void pyopencv_reg_MapAffine_specials(void)
{
    pyopencv_reg_MapAffine_Type.tp_base = &pyopencv_reg_Map_Type;
    pyopencv_reg_MapAffine_Type.tp_dealloc = pyopencv_reg_MapAffine_dealloc;
    pyopencv_reg_MapAffine_Type.tp_repr = pyopencv_reg_MapAffine_repr;
    pyopencv_reg_MapAffine_Type.tp_getset = pyopencv_reg_MapAffine_getseters;
    pyopencv_reg_MapAffine_Type.tp_init = (initproc)pyopencv_cv_reg_reg_MapAffine_MapAffine;
    pyopencv_reg_MapAffine_Type.tp_methods = pyopencv_reg_MapAffine_methods;
}

static PyObject* pyopencv_reg_Mapper_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<reg_Mapper %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_reg_Mapper_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_reg_reg_Mapper_calculate(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::Mapper* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_Mapper_Type))
        _self_ = ((pyopencv_reg_Mapper_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_Mapper' or its derivative)");
    {
    PyObject* pyobj_img1 = NULL;
    Mat img1;
    PyObject* pyobj_img2 = NULL;
    Mat img2;
    PyObject* pyobj_init = NULL;
    Ptr<Map> init=cv::Ptr<Map>();
    cv::Ptr<Map> retval;

    const char* keywords[] = { "img1", "img2", "init", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|O:reg_Mapper.calculate", (char**)keywords, &pyobj_img1, &pyobj_img2, &pyobj_init) &&
        pyopencv_to(pyobj_img1, img1, ArgInfo("img1", 0)) &&
        pyopencv_to(pyobj_img2, img2, ArgInfo("img2", 0)) &&
        pyopencv_to(pyobj_init, init, ArgInfo("init", 0)) )
    {
        ERRWRAP2(retval = _self_->calculate(img1, img2, init));
        return pyopencv_from(retval);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_img1 = NULL;
    UMat img1;
    PyObject* pyobj_img2 = NULL;
    UMat img2;
    PyObject* pyobj_init = NULL;
    Ptr<Map> init=cv::Ptr<Map>();
    cv::Ptr<Map> retval;

    const char* keywords[] = { "img1", "img2", "init", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|O:reg_Mapper.calculate", (char**)keywords, &pyobj_img1, &pyobj_img2, &pyobj_init) &&
        pyopencv_to(pyobj_img1, img1, ArgInfo("img1", 0)) &&
        pyopencv_to(pyobj_img2, img2, ArgInfo("img2", 0)) &&
        pyopencv_to(pyobj_init, init, ArgInfo("init", 0)) )
    {
        ERRWRAP2(retval = _self_->calculate(img1, img2, init));
        return pyopencv_from(retval);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_reg_reg_Mapper_getMap(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::Mapper* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_Mapper_Type))
        _self_ = ((pyopencv_reg_Mapper_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_Mapper' or its derivative)");
    cv::Ptr<Map> retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMap());
        return pyopencv_from(retval);
    }

    return NULL;
}



static PyMethodDef pyopencv_reg_Mapper_methods[] =
{
    {"calculate", (PyCFunction)pyopencv_cv_reg_reg_Mapper_calculate, METH_VARARGS | METH_KEYWORDS, "calculate(img1, img2[, init]) -> retval\n."},
    {"getMap", (PyCFunction)pyopencv_cv_reg_reg_Mapper_getMap, METH_VARARGS | METH_KEYWORDS, "getMap() -> retval\n."},

    {NULL,          NULL}
};

static void pyopencv_reg_Mapper_specials(void)
{
    pyopencv_reg_Mapper_Type.tp_base = NULL;
    pyopencv_reg_Mapper_Type.tp_dealloc = pyopencv_reg_Mapper_dealloc;
    pyopencv_reg_Mapper_Type.tp_repr = pyopencv_reg_Mapper_repr;
    pyopencv_reg_Mapper_Type.tp_getset = pyopencv_reg_Mapper_getseters;
    pyopencv_reg_Mapper_Type.tp_init = (initproc)0;
    pyopencv_reg_Mapper_Type.tp_methods = pyopencv_reg_Mapper_methods;
}

static PyObject* pyopencv_reg_MapperGradAffine_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<reg_MapperGradAffine %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_reg_MapperGradAffine_getseters[] =
{
    {NULL}  /* Sentinel */
};

static int pyopencv_cv_reg_reg_MapperGradAffine_MapperGradAffine(pyopencv_reg_MapperGradAffine_t* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;


    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        new (&(self->v)) Ptr<cv::reg::MapperGradAffine>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::reg::MapperGradAffine()));
        return 0;
    }

    return -1;
}

static PyObject* pyopencv_cv_reg_reg_MapperGradAffine_calculate(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapperGradAffine* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapperGradAffine_Type))
        _self_ = ((pyopencv_reg_MapperGradAffine_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapperGradAffine' or its derivative)");
    {
    PyObject* pyobj_img1 = NULL;
    Mat img1;
    PyObject* pyobj_img2 = NULL;
    Mat img2;
    PyObject* pyobj_init = NULL;
    Ptr<Map> init=cv::Ptr<Map>();
    cv::Ptr<Map> retval;

    const char* keywords[] = { "img1", "img2", "init", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|O:reg_MapperGradAffine.calculate", (char**)keywords, &pyobj_img1, &pyobj_img2, &pyobj_init) &&
        pyopencv_to(pyobj_img1, img1, ArgInfo("img1", 0)) &&
        pyopencv_to(pyobj_img2, img2, ArgInfo("img2", 0)) &&
        pyopencv_to(pyobj_init, init, ArgInfo("init", 0)) )
    {
        ERRWRAP2(retval = _self_->calculate(img1, img2, init));
        return pyopencv_from(retval);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_img1 = NULL;
    UMat img1;
    PyObject* pyobj_img2 = NULL;
    UMat img2;
    PyObject* pyobj_init = NULL;
    Ptr<Map> init=cv::Ptr<Map>();
    cv::Ptr<Map> retval;

    const char* keywords[] = { "img1", "img2", "init", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|O:reg_MapperGradAffine.calculate", (char**)keywords, &pyobj_img1, &pyobj_img2, &pyobj_init) &&
        pyopencv_to(pyobj_img1, img1, ArgInfo("img1", 0)) &&
        pyopencv_to(pyobj_img2, img2, ArgInfo("img2", 0)) &&
        pyopencv_to(pyobj_init, init, ArgInfo("init", 0)) )
    {
        ERRWRAP2(retval = _self_->calculate(img1, img2, init));
        return pyopencv_from(retval);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_reg_reg_MapperGradAffine_getMap(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapperGradAffine* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapperGradAffine_Type))
        _self_ = ((pyopencv_reg_MapperGradAffine_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapperGradAffine' or its derivative)");
    cv::Ptr<Map> retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMap());
        return pyopencv_from(retval);
    }

    return NULL;
}



static PyMethodDef pyopencv_reg_MapperGradAffine_methods[] =
{
    {"calculate", (PyCFunction)pyopencv_cv_reg_reg_MapperGradAffine_calculate, METH_VARARGS | METH_KEYWORDS, "calculate(img1, img2[, init]) -> retval\n."},
    {"getMap", (PyCFunction)pyopencv_cv_reg_reg_MapperGradAffine_getMap, METH_VARARGS | METH_KEYWORDS, "getMap() -> retval\n."},

    {NULL,          NULL}
};

static void pyopencv_reg_MapperGradAffine_specials(void)
{
    pyopencv_reg_MapperGradAffine_Type.tp_base = &pyopencv_reg_Mapper_Type;
    pyopencv_reg_MapperGradAffine_Type.tp_dealloc = pyopencv_reg_MapperGradAffine_dealloc;
    pyopencv_reg_MapperGradAffine_Type.tp_repr = pyopencv_reg_MapperGradAffine_repr;
    pyopencv_reg_MapperGradAffine_Type.tp_getset = pyopencv_reg_MapperGradAffine_getseters;
    pyopencv_reg_MapperGradAffine_Type.tp_init = (initproc)pyopencv_cv_reg_reg_MapperGradAffine_MapperGradAffine;
    pyopencv_reg_MapperGradAffine_Type.tp_methods = pyopencv_reg_MapperGradAffine_methods;
}

static PyObject* pyopencv_reg_MapperGradEuclid_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<reg_MapperGradEuclid %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_reg_MapperGradEuclid_getseters[] =
{
    {NULL}  /* Sentinel */
};

static int pyopencv_cv_reg_reg_MapperGradEuclid_MapperGradEuclid(pyopencv_reg_MapperGradEuclid_t* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;


    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        new (&(self->v)) Ptr<cv::reg::MapperGradEuclid>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::reg::MapperGradEuclid()));
        return 0;
    }

    return -1;
}

static PyObject* pyopencv_cv_reg_reg_MapperGradEuclid_calculate(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapperGradEuclid* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapperGradEuclid_Type))
        _self_ = ((pyopencv_reg_MapperGradEuclid_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapperGradEuclid' or its derivative)");
    {
    PyObject* pyobj_img1 = NULL;
    Mat img1;
    PyObject* pyobj_img2 = NULL;
    Mat img2;
    PyObject* pyobj_init = NULL;
    Ptr<Map> init=cv::Ptr<Map>();
    cv::Ptr<Map> retval;

    const char* keywords[] = { "img1", "img2", "init", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|O:reg_MapperGradEuclid.calculate", (char**)keywords, &pyobj_img1, &pyobj_img2, &pyobj_init) &&
        pyopencv_to(pyobj_img1, img1, ArgInfo("img1", 0)) &&
        pyopencv_to(pyobj_img2, img2, ArgInfo("img2", 0)) &&
        pyopencv_to(pyobj_init, init, ArgInfo("init", 0)) )
    {
        ERRWRAP2(retval = _self_->calculate(img1, img2, init));
        return pyopencv_from(retval);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_img1 = NULL;
    UMat img1;
    PyObject* pyobj_img2 = NULL;
    UMat img2;
    PyObject* pyobj_init = NULL;
    Ptr<Map> init=cv::Ptr<Map>();
    cv::Ptr<Map> retval;

    const char* keywords[] = { "img1", "img2", "init", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|O:reg_MapperGradEuclid.calculate", (char**)keywords, &pyobj_img1, &pyobj_img2, &pyobj_init) &&
        pyopencv_to(pyobj_img1, img1, ArgInfo("img1", 0)) &&
        pyopencv_to(pyobj_img2, img2, ArgInfo("img2", 0)) &&
        pyopencv_to(pyobj_init, init, ArgInfo("init", 0)) )
    {
        ERRWRAP2(retval = _self_->calculate(img1, img2, init));
        return pyopencv_from(retval);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_reg_reg_MapperGradEuclid_getMap(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapperGradEuclid* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapperGradEuclid_Type))
        _self_ = ((pyopencv_reg_MapperGradEuclid_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapperGradEuclid' or its derivative)");
    cv::Ptr<Map> retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMap());
        return pyopencv_from(retval);
    }

    return NULL;
}



static PyMethodDef pyopencv_reg_MapperGradEuclid_methods[] =
{
    {"calculate", (PyCFunction)pyopencv_cv_reg_reg_MapperGradEuclid_calculate, METH_VARARGS | METH_KEYWORDS, "calculate(img1, img2[, init]) -> retval\n."},
    {"getMap", (PyCFunction)pyopencv_cv_reg_reg_MapperGradEuclid_getMap, METH_VARARGS | METH_KEYWORDS, "getMap() -> retval\n."},

    {NULL,          NULL}
};

static void pyopencv_reg_MapperGradEuclid_specials(void)
{
    pyopencv_reg_MapperGradEuclid_Type.tp_base = &pyopencv_reg_Mapper_Type;
    pyopencv_reg_MapperGradEuclid_Type.tp_dealloc = pyopencv_reg_MapperGradEuclid_dealloc;
    pyopencv_reg_MapperGradEuclid_Type.tp_repr = pyopencv_reg_MapperGradEuclid_repr;
    pyopencv_reg_MapperGradEuclid_Type.tp_getset = pyopencv_reg_MapperGradEuclid_getseters;
    pyopencv_reg_MapperGradEuclid_Type.tp_init = (initproc)pyopencv_cv_reg_reg_MapperGradEuclid_MapperGradEuclid;
    pyopencv_reg_MapperGradEuclid_Type.tp_methods = pyopencv_reg_MapperGradEuclid_methods;
}

static PyObject* pyopencv_reg_MapperGradProj_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<reg_MapperGradProj %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_reg_MapperGradProj_getseters[] =
{
    {NULL}  /* Sentinel */
};

static int pyopencv_cv_reg_reg_MapperGradProj_MapperGradProj(pyopencv_reg_MapperGradProj_t* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;


    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        new (&(self->v)) Ptr<cv::reg::MapperGradProj>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::reg::MapperGradProj()));
        return 0;
    }

    return -1;
}

static PyObject* pyopencv_cv_reg_reg_MapperGradProj_calculate(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapperGradProj* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapperGradProj_Type))
        _self_ = ((pyopencv_reg_MapperGradProj_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapperGradProj' or its derivative)");
    {
    PyObject* pyobj_img1 = NULL;
    Mat img1;
    PyObject* pyobj_img2 = NULL;
    Mat img2;
    PyObject* pyobj_init = NULL;
    Ptr<Map> init=cv::Ptr<Map>();
    cv::Ptr<Map> retval;

    const char* keywords[] = { "img1", "img2", "init", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|O:reg_MapperGradProj.calculate", (char**)keywords, &pyobj_img1, &pyobj_img2, &pyobj_init) &&
        pyopencv_to(pyobj_img1, img1, ArgInfo("img1", 0)) &&
        pyopencv_to(pyobj_img2, img2, ArgInfo("img2", 0)) &&
        pyopencv_to(pyobj_init, init, ArgInfo("init", 0)) )
    {
        ERRWRAP2(retval = _self_->calculate(img1, img2, init));
        return pyopencv_from(retval);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_img1 = NULL;
    UMat img1;
    PyObject* pyobj_img2 = NULL;
    UMat img2;
    PyObject* pyobj_init = NULL;
    Ptr<Map> init=cv::Ptr<Map>();
    cv::Ptr<Map> retval;

    const char* keywords[] = { "img1", "img2", "init", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|O:reg_MapperGradProj.calculate", (char**)keywords, &pyobj_img1, &pyobj_img2, &pyobj_init) &&
        pyopencv_to(pyobj_img1, img1, ArgInfo("img1", 0)) &&
        pyopencv_to(pyobj_img2, img2, ArgInfo("img2", 0)) &&
        pyopencv_to(pyobj_init, init, ArgInfo("init", 0)) )
    {
        ERRWRAP2(retval = _self_->calculate(img1, img2, init));
        return pyopencv_from(retval);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_reg_reg_MapperGradProj_getMap(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapperGradProj* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapperGradProj_Type))
        _self_ = ((pyopencv_reg_MapperGradProj_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapperGradProj' or its derivative)");
    cv::Ptr<Map> retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMap());
        return pyopencv_from(retval);
    }

    return NULL;
}



static PyMethodDef pyopencv_reg_MapperGradProj_methods[] =
{
    {"calculate", (PyCFunction)pyopencv_cv_reg_reg_MapperGradProj_calculate, METH_VARARGS | METH_KEYWORDS, "calculate(img1, img2[, init]) -> retval\n."},
    {"getMap", (PyCFunction)pyopencv_cv_reg_reg_MapperGradProj_getMap, METH_VARARGS | METH_KEYWORDS, "getMap() -> retval\n."},

    {NULL,          NULL}
};

static void pyopencv_reg_MapperGradProj_specials(void)
{
    pyopencv_reg_MapperGradProj_Type.tp_base = &pyopencv_reg_Mapper_Type;
    pyopencv_reg_MapperGradProj_Type.tp_dealloc = pyopencv_reg_MapperGradProj_dealloc;
    pyopencv_reg_MapperGradProj_Type.tp_repr = pyopencv_reg_MapperGradProj_repr;
    pyopencv_reg_MapperGradProj_Type.tp_getset = pyopencv_reg_MapperGradProj_getseters;
    pyopencv_reg_MapperGradProj_Type.tp_init = (initproc)pyopencv_cv_reg_reg_MapperGradProj_MapperGradProj;
    pyopencv_reg_MapperGradProj_Type.tp_methods = pyopencv_reg_MapperGradProj_methods;
}

static PyObject* pyopencv_reg_MapperGradShift_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<reg_MapperGradShift %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_reg_MapperGradShift_getseters[] =
{
    {NULL}  /* Sentinel */
};

static int pyopencv_cv_reg_reg_MapperGradShift_MapperGradShift(pyopencv_reg_MapperGradShift_t* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;


    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        new (&(self->v)) Ptr<cv::reg::MapperGradShift>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::reg::MapperGradShift()));
        return 0;
    }

    return -1;
}

static PyObject* pyopencv_cv_reg_reg_MapperGradShift_calculate(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapperGradShift* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapperGradShift_Type))
        _self_ = ((pyopencv_reg_MapperGradShift_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapperGradShift' or its derivative)");
    {
    PyObject* pyobj_img1 = NULL;
    Mat img1;
    PyObject* pyobj_img2 = NULL;
    Mat img2;
    PyObject* pyobj_init = NULL;
    Ptr<Map> init=cv::Ptr<Map>();
    cv::Ptr<Map> retval;

    const char* keywords[] = { "img1", "img2", "init", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|O:reg_MapperGradShift.calculate", (char**)keywords, &pyobj_img1, &pyobj_img2, &pyobj_init) &&
        pyopencv_to(pyobj_img1, img1, ArgInfo("img1", 0)) &&
        pyopencv_to(pyobj_img2, img2, ArgInfo("img2", 0)) &&
        pyopencv_to(pyobj_init, init, ArgInfo("init", 0)) )
    {
        ERRWRAP2(retval = _self_->calculate(img1, img2, init));
        return pyopencv_from(retval);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_img1 = NULL;
    UMat img1;
    PyObject* pyobj_img2 = NULL;
    UMat img2;
    PyObject* pyobj_init = NULL;
    Ptr<Map> init=cv::Ptr<Map>();
    cv::Ptr<Map> retval;

    const char* keywords[] = { "img1", "img2", "init", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|O:reg_MapperGradShift.calculate", (char**)keywords, &pyobj_img1, &pyobj_img2, &pyobj_init) &&
        pyopencv_to(pyobj_img1, img1, ArgInfo("img1", 0)) &&
        pyopencv_to(pyobj_img2, img2, ArgInfo("img2", 0)) &&
        pyopencv_to(pyobj_init, init, ArgInfo("init", 0)) )
    {
        ERRWRAP2(retval = _self_->calculate(img1, img2, init));
        return pyopencv_from(retval);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_reg_reg_MapperGradShift_getMap(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapperGradShift* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapperGradShift_Type))
        _self_ = ((pyopencv_reg_MapperGradShift_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapperGradShift' or its derivative)");
    cv::Ptr<Map> retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMap());
        return pyopencv_from(retval);
    }

    return NULL;
}



static PyMethodDef pyopencv_reg_MapperGradShift_methods[] =
{
    {"calculate", (PyCFunction)pyopencv_cv_reg_reg_MapperGradShift_calculate, METH_VARARGS | METH_KEYWORDS, "calculate(img1, img2[, init]) -> retval\n."},
    {"getMap", (PyCFunction)pyopencv_cv_reg_reg_MapperGradShift_getMap, METH_VARARGS | METH_KEYWORDS, "getMap() -> retval\n."},

    {NULL,          NULL}
};

static void pyopencv_reg_MapperGradShift_specials(void)
{
    pyopencv_reg_MapperGradShift_Type.tp_base = &pyopencv_reg_Mapper_Type;
    pyopencv_reg_MapperGradShift_Type.tp_dealloc = pyopencv_reg_MapperGradShift_dealloc;
    pyopencv_reg_MapperGradShift_Type.tp_repr = pyopencv_reg_MapperGradShift_repr;
    pyopencv_reg_MapperGradShift_Type.tp_getset = pyopencv_reg_MapperGradShift_getseters;
    pyopencv_reg_MapperGradShift_Type.tp_init = (initproc)pyopencv_cv_reg_reg_MapperGradShift_MapperGradShift;
    pyopencv_reg_MapperGradShift_Type.tp_methods = pyopencv_reg_MapperGradShift_methods;
}

static PyObject* pyopencv_reg_MapperGradSimilar_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<reg_MapperGradSimilar %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_reg_MapperGradSimilar_getseters[] =
{
    {NULL}  /* Sentinel */
};

static int pyopencv_cv_reg_reg_MapperGradSimilar_MapperGradSimilar(pyopencv_reg_MapperGradSimilar_t* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;


    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        new (&(self->v)) Ptr<cv::reg::MapperGradSimilar>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::reg::MapperGradSimilar()));
        return 0;
    }

    return -1;
}

static PyObject* pyopencv_cv_reg_reg_MapperGradSimilar_calculate(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapperGradSimilar* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapperGradSimilar_Type))
        _self_ = ((pyopencv_reg_MapperGradSimilar_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapperGradSimilar' or its derivative)");
    {
    PyObject* pyobj_img1 = NULL;
    Mat img1;
    PyObject* pyobj_img2 = NULL;
    Mat img2;
    PyObject* pyobj_init = NULL;
    Ptr<Map> init=cv::Ptr<Map>();
    cv::Ptr<Map> retval;

    const char* keywords[] = { "img1", "img2", "init", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|O:reg_MapperGradSimilar.calculate", (char**)keywords, &pyobj_img1, &pyobj_img2, &pyobj_init) &&
        pyopencv_to(pyobj_img1, img1, ArgInfo("img1", 0)) &&
        pyopencv_to(pyobj_img2, img2, ArgInfo("img2", 0)) &&
        pyopencv_to(pyobj_init, init, ArgInfo("init", 0)) )
    {
        ERRWRAP2(retval = _self_->calculate(img1, img2, init));
        return pyopencv_from(retval);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_img1 = NULL;
    UMat img1;
    PyObject* pyobj_img2 = NULL;
    UMat img2;
    PyObject* pyobj_init = NULL;
    Ptr<Map> init=cv::Ptr<Map>();
    cv::Ptr<Map> retval;

    const char* keywords[] = { "img1", "img2", "init", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|O:reg_MapperGradSimilar.calculate", (char**)keywords, &pyobj_img1, &pyobj_img2, &pyobj_init) &&
        pyopencv_to(pyobj_img1, img1, ArgInfo("img1", 0)) &&
        pyopencv_to(pyobj_img2, img2, ArgInfo("img2", 0)) &&
        pyopencv_to(pyobj_init, init, ArgInfo("init", 0)) )
    {
        ERRWRAP2(retval = _self_->calculate(img1, img2, init));
        return pyopencv_from(retval);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_reg_reg_MapperGradSimilar_getMap(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapperGradSimilar* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapperGradSimilar_Type))
        _self_ = ((pyopencv_reg_MapperGradSimilar_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapperGradSimilar' or its derivative)");
    cv::Ptr<Map> retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMap());
        return pyopencv_from(retval);
    }

    return NULL;
}



static PyMethodDef pyopencv_reg_MapperGradSimilar_methods[] =
{
    {"calculate", (PyCFunction)pyopencv_cv_reg_reg_MapperGradSimilar_calculate, METH_VARARGS | METH_KEYWORDS, "calculate(img1, img2[, init]) -> retval\n."},
    {"getMap", (PyCFunction)pyopencv_cv_reg_reg_MapperGradSimilar_getMap, METH_VARARGS | METH_KEYWORDS, "getMap() -> retval\n."},

    {NULL,          NULL}
};

static void pyopencv_reg_MapperGradSimilar_specials(void)
{
    pyopencv_reg_MapperGradSimilar_Type.tp_base = &pyopencv_reg_Mapper_Type;
    pyopencv_reg_MapperGradSimilar_Type.tp_dealloc = pyopencv_reg_MapperGradSimilar_dealloc;
    pyopencv_reg_MapperGradSimilar_Type.tp_repr = pyopencv_reg_MapperGradSimilar_repr;
    pyopencv_reg_MapperGradSimilar_Type.tp_getset = pyopencv_reg_MapperGradSimilar_getseters;
    pyopencv_reg_MapperGradSimilar_Type.tp_init = (initproc)pyopencv_cv_reg_reg_MapperGradSimilar_MapperGradSimilar;
    pyopencv_reg_MapperGradSimilar_Type.tp_methods = pyopencv_reg_MapperGradSimilar_methods;
}

static PyObject* pyopencv_reg_MapperPyramid_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<reg_MapperPyramid %p>", self);
    return PyString_FromString(str);
}


static PyObject* pyopencv_reg_MapperPyramid_get_numIterPerScale_(pyopencv_reg_MapperPyramid_t* p, void *closure)
{
    return pyopencv_from(p->v->numIterPerScale_);
}

static int pyopencv_reg_MapperPyramid_set_numIterPerScale_(pyopencv_reg_MapperPyramid_t* p, PyObject *value, void *closure)
{
    if (value == NULL)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the numIterPerScale_ attribute");
        return -1;
    }
    return pyopencv_to(value, p->v->numIterPerScale_) ? 0 : -1;
}

static PyObject* pyopencv_reg_MapperPyramid_get_numLev_(pyopencv_reg_MapperPyramid_t* p, void *closure)
{
    return pyopencv_from(p->v->numLev_);
}

static int pyopencv_reg_MapperPyramid_set_numLev_(pyopencv_reg_MapperPyramid_t* p, PyObject *value, void *closure)
{
    if (value == NULL)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the numLev_ attribute");
        return -1;
    }
    return pyopencv_to(value, p->v->numLev_) ? 0 : -1;
}


static PyGetSetDef pyopencv_reg_MapperPyramid_getseters[] =
{
    {(char*)"numIterPerScale_", (getter)pyopencv_reg_MapperPyramid_get_numIterPerScale_, (setter)pyopencv_reg_MapperPyramid_set_numIterPerScale_, (char*)"numIterPerScale_", NULL},
    {(char*)"numLev_", (getter)pyopencv_reg_MapperPyramid_get_numLev_, (setter)pyopencv_reg_MapperPyramid_set_numLev_, (char*)"numLev_", NULL},
    {NULL}  /* Sentinel */
};

static int pyopencv_cv_reg_reg_MapperPyramid_MapperPyramid(pyopencv_reg_MapperPyramid_t* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    PyObject* pyobj_baseMapper = NULL;
    Ptr<Mapper> baseMapper;

    const char* keywords[] = { "baseMapper", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:MapperPyramid", (char**)keywords, &pyobj_baseMapper) &&
        pyopencv_to(pyobj_baseMapper, baseMapper, ArgInfo("baseMapper", 0)) )
    {
        new (&(self->v)) Ptr<cv::reg::MapperPyramid>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::reg::MapperPyramid(baseMapper)));
        return 0;
    }

    return -1;
}

static PyObject* pyopencv_cv_reg_reg_MapperPyramid_calculate(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapperPyramid* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapperPyramid_Type))
        _self_ = ((pyopencv_reg_MapperPyramid_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapperPyramid' or its derivative)");
    {
    PyObject* pyobj_img1 = NULL;
    Mat img1;
    PyObject* pyobj_img2 = NULL;
    Mat img2;
    PyObject* pyobj_init = NULL;
    Ptr<Map> init=cv::Ptr<Map>();
    cv::Ptr<Map> retval;

    const char* keywords[] = { "img1", "img2", "init", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|O:reg_MapperPyramid.calculate", (char**)keywords, &pyobj_img1, &pyobj_img2, &pyobj_init) &&
        pyopencv_to(pyobj_img1, img1, ArgInfo("img1", 0)) &&
        pyopencv_to(pyobj_img2, img2, ArgInfo("img2", 0)) &&
        pyopencv_to(pyobj_init, init, ArgInfo("init", 0)) )
    {
        ERRWRAP2(retval = _self_->calculate(img1, img2, init));
        return pyopencv_from(retval);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_img1 = NULL;
    UMat img1;
    PyObject* pyobj_img2 = NULL;
    UMat img2;
    PyObject* pyobj_init = NULL;
    Ptr<Map> init=cv::Ptr<Map>();
    cv::Ptr<Map> retval;

    const char* keywords[] = { "img1", "img2", "init", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO|O:reg_MapperPyramid.calculate", (char**)keywords, &pyobj_img1, &pyobj_img2, &pyobj_init) &&
        pyopencv_to(pyobj_img1, img1, ArgInfo("img1", 0)) &&
        pyopencv_to(pyobj_img2, img2, ArgInfo("img2", 0)) &&
        pyopencv_to(pyobj_init, init, ArgInfo("init", 0)) )
    {
        ERRWRAP2(retval = _self_->calculate(img1, img2, init));
        return pyopencv_from(retval);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_reg_reg_MapperPyramid_getMap(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapperPyramid* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapperPyramid_Type))
        _self_ = ((pyopencv_reg_MapperPyramid_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapperPyramid' or its derivative)");
    cv::Ptr<Map> retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMap());
        return pyopencv_from(retval);
    }

    return NULL;
}



static PyMethodDef pyopencv_reg_MapperPyramid_methods[] =
{
    {"calculate", (PyCFunction)pyopencv_cv_reg_reg_MapperPyramid_calculate, METH_VARARGS | METH_KEYWORDS, "calculate(img1, img2[, init]) -> retval\n."},
    {"getMap", (PyCFunction)pyopencv_cv_reg_reg_MapperPyramid_getMap, METH_VARARGS | METH_KEYWORDS, "getMap() -> retval\n."},

    {NULL,          NULL}
};

static void pyopencv_reg_MapperPyramid_specials(void)
{
    pyopencv_reg_MapperPyramid_Type.tp_base = &pyopencv_reg_Mapper_Type;
    pyopencv_reg_MapperPyramid_Type.tp_dealloc = pyopencv_reg_MapperPyramid_dealloc;
    pyopencv_reg_MapperPyramid_Type.tp_repr = pyopencv_reg_MapperPyramid_repr;
    pyopencv_reg_MapperPyramid_Type.tp_getset = pyopencv_reg_MapperPyramid_getseters;
    pyopencv_reg_MapperPyramid_Type.tp_init = (initproc)pyopencv_cv_reg_reg_MapperPyramid_MapperPyramid;
    pyopencv_reg_MapperPyramid_Type.tp_methods = pyopencv_reg_MapperPyramid_methods;
}

static PyObject* pyopencv_reg_MapTypeCaster_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<reg_MapTypeCaster %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_reg_MapTypeCaster_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_reg_reg_MapTypeCaster_toAffine_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    PyObject* pyobj_sourceMap = NULL;
    Ptr<Map> sourceMap;
    Ptr<MapAffine> retval;

    const char* keywords[] = { "sourceMap", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:reg_MapTypeCaster.toAffine", (char**)keywords, &pyobj_sourceMap) &&
        pyopencv_to(pyobj_sourceMap, sourceMap, ArgInfo("sourceMap", 0)) )
    {
        ERRWRAP2(retval = cv::reg::MapTypeCaster::toAffine(sourceMap));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_reg_reg_MapTypeCaster_toProjec_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    PyObject* pyobj_sourceMap = NULL;
    Ptr<Map> sourceMap;
    Ptr<MapProjec> retval;

    const char* keywords[] = { "sourceMap", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:reg_MapTypeCaster.toProjec", (char**)keywords, &pyobj_sourceMap) &&
        pyopencv_to(pyobj_sourceMap, sourceMap, ArgInfo("sourceMap", 0)) )
    {
        ERRWRAP2(retval = cv::reg::MapTypeCaster::toProjec(sourceMap));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_reg_reg_MapTypeCaster_toShift_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    PyObject* pyobj_sourceMap = NULL;
    Ptr<Map> sourceMap;
    Ptr<MapShift> retval;

    const char* keywords[] = { "sourceMap", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:reg_MapTypeCaster.toShift", (char**)keywords, &pyobj_sourceMap) &&
        pyopencv_to(pyobj_sourceMap, sourceMap, ArgInfo("sourceMap", 0)) )
    {
        ERRWRAP2(retval = cv::reg::MapTypeCaster::toShift(sourceMap));
        return pyopencv_from(retval);
    }

    return NULL;
}



static PyMethodDef pyopencv_reg_MapTypeCaster_methods[] =
{
    {"toAffine", (PyCFunction)pyopencv_cv_reg_reg_MapTypeCaster_toAffine_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "toAffine(sourceMap) -> retval\n."},
    {"toProjec", (PyCFunction)pyopencv_cv_reg_reg_MapTypeCaster_toProjec_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "toProjec(sourceMap) -> retval\n."},
    {"toShift", (PyCFunction)pyopencv_cv_reg_reg_MapTypeCaster_toShift_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "toShift(sourceMap) -> retval\n."},

    {NULL,          NULL}
};

static void pyopencv_reg_MapTypeCaster_specials(void)
{
    pyopencv_reg_MapTypeCaster_Type.tp_base = NULL;
    pyopencv_reg_MapTypeCaster_Type.tp_dealloc = pyopencv_reg_MapTypeCaster_dealloc;
    pyopencv_reg_MapTypeCaster_Type.tp_repr = pyopencv_reg_MapTypeCaster_repr;
    pyopencv_reg_MapTypeCaster_Type.tp_getset = pyopencv_reg_MapTypeCaster_getseters;
    pyopencv_reg_MapTypeCaster_Type.tp_init = (initproc)0;
    pyopencv_reg_MapTypeCaster_Type.tp_methods = pyopencv_reg_MapTypeCaster_methods;
}

static PyObject* pyopencv_reg_MapProjec_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<reg_MapProjec %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_reg_MapProjec_getseters[] =
{
    {NULL}  /* Sentinel */
};

static int pyopencv_cv_reg_reg_MapProjec_MapProjec(pyopencv_reg_MapProjec_t* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    {

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        new (&(self->v)) Ptr<cv::reg::MapProjec>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::reg::MapProjec()));
        return 0;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_projTr = NULL;
    Mat projTr;

    const char* keywords[] = { "projTr", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:MapProjec", (char**)keywords, &pyobj_projTr) &&
        pyopencv_to(pyobj_projTr, projTr, ArgInfo("projTr", 0)) )
    {
        new (&(self->v)) Ptr<cv::reg::MapProjec>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::reg::MapProjec(projTr)));
        return 0;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_projTr = NULL;
    UMat projTr;

    const char* keywords[] = { "projTr", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:MapProjec", (char**)keywords, &pyobj_projTr) &&
        pyopencv_to(pyobj_projTr, projTr, ArgInfo("projTr", 0)) )
    {
        new (&(self->v)) Ptr<cv::reg::MapProjec>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::reg::MapProjec(projTr)));
        return 0;
    }
    }

    return -1;
}

static PyObject* pyopencv_cv_reg_reg_MapProjec_compose(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapProjec* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapProjec_Type))
        _self_ = ((pyopencv_reg_MapProjec_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapProjec' or its derivative)");
    PyObject* pyobj_map = NULL;
    Ptr<Map> map;

    const char* keywords[] = { "map", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:reg_MapProjec.compose", (char**)keywords, &pyobj_map) &&
        pyopencv_to(pyobj_map, map, ArgInfo("map", 0)) )
    {
        ERRWRAP2(_self_->compose(map));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_reg_reg_MapProjec_getProjTr(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapProjec* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapProjec_Type))
        _self_ = ((pyopencv_reg_MapProjec_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapProjec' or its derivative)");
    {
    PyObject* pyobj_projTr = NULL;
    Mat projTr;

    const char* keywords[] = { "projTr", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "|O:reg_MapProjec.getProjTr", (char**)keywords, &pyobj_projTr) &&
        pyopencv_to(pyobj_projTr, projTr, ArgInfo("projTr", 1)) )
    {
        ERRWRAP2(_self_->getProjTr(projTr));
        return pyopencv_from(projTr);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_projTr = NULL;
    UMat projTr;

    const char* keywords[] = { "projTr", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "|O:reg_MapProjec.getProjTr", (char**)keywords, &pyobj_projTr) &&
        pyopencv_to(pyobj_projTr, projTr, ArgInfo("projTr", 1)) )
    {
        ERRWRAP2(_self_->getProjTr(projTr));
        return pyopencv_from(projTr);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_reg_reg_MapProjec_inverseMap(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapProjec* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapProjec_Type))
        _self_ = ((pyopencv_reg_MapProjec_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapProjec' or its derivative)");
    cv::Ptr<Map> retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->inverseMap());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_reg_reg_MapProjec_inverseWarp(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapProjec* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapProjec_Type))
        _self_ = ((pyopencv_reg_MapProjec_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapProjec' or its derivative)");
    {
    PyObject* pyobj_img1 = NULL;
    Mat img1;
    PyObject* pyobj_img2 = NULL;
    Mat img2;

    const char* keywords[] = { "img1", "img2", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:reg_MapProjec.inverseWarp", (char**)keywords, &pyobj_img1, &pyobj_img2) &&
        pyopencv_to(pyobj_img1, img1, ArgInfo("img1", 0)) &&
        pyopencv_to(pyobj_img2, img2, ArgInfo("img2", 1)) )
    {
        ERRWRAP2(_self_->inverseWarp(img1, img2));
        return pyopencv_from(img2);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_img1 = NULL;
    UMat img1;
    PyObject* pyobj_img2 = NULL;
    UMat img2;

    const char* keywords[] = { "img1", "img2", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:reg_MapProjec.inverseWarp", (char**)keywords, &pyobj_img1, &pyobj_img2) &&
        pyopencv_to(pyobj_img1, img1, ArgInfo("img1", 0)) &&
        pyopencv_to(pyobj_img2, img2, ArgInfo("img2", 1)) )
    {
        ERRWRAP2(_self_->inverseWarp(img1, img2));
        return pyopencv_from(img2);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_reg_reg_MapProjec_normalize(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapProjec* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapProjec_Type))
        _self_ = ((pyopencv_reg_MapProjec_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapProjec' or its derivative)");

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->normalize());
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_reg_reg_MapProjec_scale(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapProjec* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapProjec_Type))
        _self_ = ((pyopencv_reg_MapProjec_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapProjec' or its derivative)");
    double factor=0;

    const char* keywords[] = { "factor", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:reg_MapProjec.scale", (char**)keywords, &factor) )
    {
        ERRWRAP2(_self_->scale(factor));
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_reg_MapProjec_methods[] =
{
    {"compose", (PyCFunction)pyopencv_cv_reg_reg_MapProjec_compose, METH_VARARGS | METH_KEYWORDS, "compose(map) -> None\n."},
    {"getProjTr", (PyCFunction)pyopencv_cv_reg_reg_MapProjec_getProjTr, METH_VARARGS | METH_KEYWORDS, "getProjTr([, projTr]) -> projTr\n."},
    {"inverseMap", (PyCFunction)pyopencv_cv_reg_reg_MapProjec_inverseMap, METH_VARARGS | METH_KEYWORDS, "inverseMap() -> retval\n."},
    {"inverseWarp", (PyCFunction)pyopencv_cv_reg_reg_MapProjec_inverseWarp, METH_VARARGS | METH_KEYWORDS, "inverseWarp(img1[, img2]) -> img2\n."},
    {"normalize", (PyCFunction)pyopencv_cv_reg_reg_MapProjec_normalize, METH_VARARGS | METH_KEYWORDS, "normalize() -> None\n."},
    {"scale", (PyCFunction)pyopencv_cv_reg_reg_MapProjec_scale, METH_VARARGS | METH_KEYWORDS, "scale(factor) -> None\n."},

    {NULL,          NULL}
};

static void pyopencv_reg_MapProjec_specials(void)
{
    pyopencv_reg_MapProjec_Type.tp_base = &pyopencv_reg_Map_Type;
    pyopencv_reg_MapProjec_Type.tp_dealloc = pyopencv_reg_MapProjec_dealloc;
    pyopencv_reg_MapProjec_Type.tp_repr = pyopencv_reg_MapProjec_repr;
    pyopencv_reg_MapProjec_Type.tp_getset = pyopencv_reg_MapProjec_getseters;
    pyopencv_reg_MapProjec_Type.tp_init = (initproc)pyopencv_cv_reg_reg_MapProjec_MapProjec;
    pyopencv_reg_MapProjec_Type.tp_methods = pyopencv_reg_MapProjec_methods;
}

static PyObject* pyopencv_reg_MapShift_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<reg_MapShift %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_reg_MapShift_getseters[] =
{
    {NULL}  /* Sentinel */
};

static int pyopencv_cv_reg_reg_MapShift_MapShift(pyopencv_reg_MapShift_t* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    {

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        new (&(self->v)) Ptr<cv::reg::MapShift>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::reg::MapShift()));
        return 0;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_shift = NULL;
    Mat shift;

    const char* keywords[] = { "shift", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:MapShift", (char**)keywords, &pyobj_shift) &&
        pyopencv_to(pyobj_shift, shift, ArgInfo("shift", 0)) )
    {
        new (&(self->v)) Ptr<cv::reg::MapShift>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::reg::MapShift(shift)));
        return 0;
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_shift = NULL;
    UMat shift;

    const char* keywords[] = { "shift", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:MapShift", (char**)keywords, &pyobj_shift) &&
        pyopencv_to(pyobj_shift, shift, ArgInfo("shift", 0)) )
    {
        new (&(self->v)) Ptr<cv::reg::MapShift>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::reg::MapShift(shift)));
        return 0;
    }
    }

    return -1;
}

static PyObject* pyopencv_cv_reg_reg_MapShift_compose(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapShift* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapShift_Type))
        _self_ = ((pyopencv_reg_MapShift_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapShift' or its derivative)");
    PyObject* pyobj_map = NULL;
    Ptr<Map> map;

    const char* keywords[] = { "map", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:reg_MapShift.compose", (char**)keywords, &pyobj_map) &&
        pyopencv_to(pyobj_map, map, ArgInfo("map", 0)) )
    {
        ERRWRAP2(_self_->compose(map));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_reg_reg_MapShift_getShift(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapShift* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapShift_Type))
        _self_ = ((pyopencv_reg_MapShift_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapShift' or its derivative)");
    {
    PyObject* pyobj_shift = NULL;
    Mat shift;

    const char* keywords[] = { "shift", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "|O:reg_MapShift.getShift", (char**)keywords, &pyobj_shift) &&
        pyopencv_to(pyobj_shift, shift, ArgInfo("shift", 1)) )
    {
        ERRWRAP2(_self_->getShift(shift));
        return pyopencv_from(shift);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_shift = NULL;
    UMat shift;

    const char* keywords[] = { "shift", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "|O:reg_MapShift.getShift", (char**)keywords, &pyobj_shift) &&
        pyopencv_to(pyobj_shift, shift, ArgInfo("shift", 1)) )
    {
        ERRWRAP2(_self_->getShift(shift));
        return pyopencv_from(shift);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_reg_reg_MapShift_inverseMap(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapShift* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapShift_Type))
        _self_ = ((pyopencv_reg_MapShift_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapShift' or its derivative)");
    cv::Ptr<Map> retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->inverseMap());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_reg_reg_MapShift_inverseWarp(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapShift* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapShift_Type))
        _self_ = ((pyopencv_reg_MapShift_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapShift' or its derivative)");
    {
    PyObject* pyobj_img1 = NULL;
    Mat img1;
    PyObject* pyobj_img2 = NULL;
    Mat img2;

    const char* keywords[] = { "img1", "img2", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:reg_MapShift.inverseWarp", (char**)keywords, &pyobj_img1, &pyobj_img2) &&
        pyopencv_to(pyobj_img1, img1, ArgInfo("img1", 0)) &&
        pyopencv_to(pyobj_img2, img2, ArgInfo("img2", 1)) )
    {
        ERRWRAP2(_self_->inverseWarp(img1, img2));
        return pyopencv_from(img2);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_img1 = NULL;
    UMat img1;
    PyObject* pyobj_img2 = NULL;
    UMat img2;

    const char* keywords[] = { "img1", "img2", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|O:reg_MapShift.inverseWarp", (char**)keywords, &pyobj_img1, &pyobj_img2) &&
        pyopencv_to(pyobj_img1, img1, ArgInfo("img1", 0)) &&
        pyopencv_to(pyobj_img2, img2, ArgInfo("img2", 1)) )
    {
        ERRWRAP2(_self_->inverseWarp(img1, img2));
        return pyopencv_from(img2);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_reg_reg_MapShift_scale(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::reg;

    cv::reg::MapShift* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_reg_MapShift_Type))
        _self_ = ((pyopencv_reg_MapShift_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'reg_MapShift' or its derivative)");
    double factor=0;

    const char* keywords[] = { "factor", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:reg_MapShift.scale", (char**)keywords, &factor) )
    {
        ERRWRAP2(_self_->scale(factor));
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_reg_MapShift_methods[] =
{
    {"compose", (PyCFunction)pyopencv_cv_reg_reg_MapShift_compose, METH_VARARGS | METH_KEYWORDS, "compose(map) -> None\n."},
    {"getShift", (PyCFunction)pyopencv_cv_reg_reg_MapShift_getShift, METH_VARARGS | METH_KEYWORDS, "getShift([, shift]) -> shift\n."},
    {"inverseMap", (PyCFunction)pyopencv_cv_reg_reg_MapShift_inverseMap, METH_VARARGS | METH_KEYWORDS, "inverseMap() -> retval\n."},
    {"inverseWarp", (PyCFunction)pyopencv_cv_reg_reg_MapShift_inverseWarp, METH_VARARGS | METH_KEYWORDS, "inverseWarp(img1[, img2]) -> img2\n."},
    {"scale", (PyCFunction)pyopencv_cv_reg_reg_MapShift_scale, METH_VARARGS | METH_KEYWORDS, "scale(factor) -> None\n."},

    {NULL,          NULL}
};

static void pyopencv_reg_MapShift_specials(void)
{
    pyopencv_reg_MapShift_Type.tp_base = &pyopencv_reg_Map_Type;
    pyopencv_reg_MapShift_Type.tp_dealloc = pyopencv_reg_MapShift_dealloc;
    pyopencv_reg_MapShift_Type.tp_repr = pyopencv_reg_MapShift_repr;
    pyopencv_reg_MapShift_Type.tp_getset = pyopencv_reg_MapShift_getseters;
    pyopencv_reg_MapShift_Type.tp_init = (initproc)pyopencv_cv_reg_reg_MapShift_MapShift;
    pyopencv_reg_MapShift_Type.tp_methods = pyopencv_reg_MapShift_methods;
}

static PyObject* pyopencv_ppf_match_3d_ICP_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<ppf_match_3d_ICP %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_ppf_match_3d_ICP_getseters[] =
{
    {NULL}  /* Sentinel */
};

static int pyopencv_cv_ppf_match_3d_ppf_match_3d_ICP_ICP(pyopencv_ppf_match_3d_ICP_t* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ppf_match_3d;

    {

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        new (&(self->v)) Ptr<cv::ppf_match_3d::ICP>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::ppf_match_3d::ICP()));
        return 0;
    }
    }
    PyErr_Clear();

    {
    int iterations=0;
    float tolerence=0.05f;
    float rejectionScale=2.5f;
    int numLevels=6;
    int sampleType=ICP::ICP_SAMPLING_TYPE_UNIFORM;
    int numMaxCorr=1;

    const char* keywords[] = { "iterations", "tolerence", "rejectionScale", "numLevels", "sampleType", "numMaxCorr", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i|ffiii:ICP", (char**)keywords, &iterations, &tolerence, &rejectionScale, &numLevels, &sampleType, &numMaxCorr) )
    {
        new (&(self->v)) Ptr<cv::ppf_match_3d::ICP>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::ppf_match_3d::ICP(iterations, tolerence, rejectionScale, numLevels, sampleType, numMaxCorr)));
        return 0;
    }
    }

    return -1;
}

static PyObject* pyopencv_cv_ppf_match_3d_ppf_match_3d_ICP_registerModelToScene(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv::ppf_match_3d;

    cv::ppf_match_3d::ICP* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_ppf_match_3d_ICP_Type))
        _self_ = ((pyopencv_ppf_match_3d_ICP_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'ppf_match_3d_ICP' or its derivative)");
    {
    PyObject* pyobj_srcPC = NULL;
    Mat srcPC;
    PyObject* pyobj_dstPC = NULL;
    Mat dstPC;
    double residual;
    Matx44d pose;
    int retval;

    const char* keywords[] = { "srcPC", "dstPC", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:ppf_match_3d_ICP.registerModelToScene", (char**)keywords, &pyobj_srcPC, &pyobj_dstPC) &&
        pyopencv_to(pyobj_srcPC, srcPC, ArgInfo("srcPC", 0)) &&
        pyopencv_to(pyobj_dstPC, dstPC, ArgInfo("dstPC", 0)) )
    {
        ERRWRAP2(retval = _self_->registerModelToScene(srcPC, dstPC, residual, pose));
        return Py_BuildValue("(NNN)", pyopencv_from(retval), pyopencv_from(residual), pyopencv_from(pose));
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_srcPC = NULL;
    Mat srcPC;
    PyObject* pyobj_dstPC = NULL;
    Mat dstPC;
    double residual;
    Matx44d pose;
    int retval;

    const char* keywords[] = { "srcPC", "dstPC", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OO:ppf_match_3d_ICP.registerModelToScene", (char**)keywords, &pyobj_srcPC, &pyobj_dstPC) &&
        pyopencv_to(pyobj_srcPC, srcPC, ArgInfo("srcPC", 0)) &&
        pyopencv_to(pyobj_dstPC, dstPC, ArgInfo("dstPC", 0)) )
    {
        ERRWRAP2(retval = _self_->registerModelToScene(srcPC, dstPC, residual, pose));
        return Py_BuildValue("(NNN)", pyopencv_from(retval), pyopencv_from(residual), pyopencv_from(pose));
    }
    }

    return NULL;
}



static PyMethodDef pyopencv_ppf_match_3d_ICP_methods[] =
{
    {"registerModelToScene", (PyCFunction)pyopencv_cv_ppf_match_3d_ppf_match_3d_ICP_registerModelToScene, METH_VARARGS | METH_KEYWORDS, "registerModelToScene(srcPC, dstPC) -> retval, residual, pose\n.   *  \\brief Perform registration\n.   *\n.   *  @param [in] srcPC The input point cloud for the model. Expected to have the normals (Nx6). Currently,\n.   *  CV_32F is the only supported data type.\n.   *  @param [in] dstPC The input point cloud for the scene. It is assumed that the model is registered on the scene. Scene remains static. Expected to have the normals (Nx6). Currently, CV_32F is the only supported data type.\n.   *  @param [out] residual The output registration error.\n.   *  @param [out] pose Transformation between srcPC and dstPC.\n.   *  \\return On successful termination, the function returns 0.\n.   *\n.   *  \\details It is assumed that the model is registered on the scene. Scene remains static, while the model transforms. The output poses transform the models onto the scene. Because of the point to plane minimization, the scene is expected to have the normals available. Expected to have the normals (Nx6)."},

    {NULL,          NULL}
};

static void pyopencv_ppf_match_3d_ICP_specials(void)
{
    pyopencv_ppf_match_3d_ICP_Type.tp_base = NULL;
    pyopencv_ppf_match_3d_ICP_Type.tp_dealloc = pyopencv_ppf_match_3d_ICP_dealloc;
    pyopencv_ppf_match_3d_ICP_Type.tp_repr = pyopencv_ppf_match_3d_ICP_repr;
    pyopencv_ppf_match_3d_ICP_Type.tp_getset = pyopencv_ppf_match_3d_ICP_getseters;
    pyopencv_ppf_match_3d_ICP_Type.tp_init = (initproc)pyopencv_cv_ppf_match_3d_ppf_match_3d_ICP_ICP;
    pyopencv_ppf_match_3d_ICP_Type.tp_methods = pyopencv_ppf_match_3d_ICP_methods;
}

static PyObject* pyopencv_ppf_match_3d_PoseCluster3D_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<ppf_match_3d_PoseCluster3D %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_ppf_match_3d_PoseCluster3D_getseters[] =
{
    {NULL}  /* Sentinel */
};



static PyMethodDef pyopencv_ppf_match_3d_PoseCluster3D_methods[] =
{

    {NULL,          NULL}
};

static void pyopencv_ppf_match_3d_PoseCluster3D_specials(void)
{
    pyopencv_ppf_match_3d_PoseCluster3D_Type.tp_base = NULL;
    pyopencv_ppf_match_3d_PoseCluster3D_Type.tp_dealloc = pyopencv_ppf_match_3d_PoseCluster3D_dealloc;
    pyopencv_ppf_match_3d_PoseCluster3D_Type.tp_repr = pyopencv_ppf_match_3d_PoseCluster3D_repr;
    pyopencv_ppf_match_3d_PoseCluster3D_Type.tp_getset = pyopencv_ppf_match_3d_PoseCluster3D_getseters;
    pyopencv_ppf_match_3d_PoseCluster3D_Type.tp_init = (initproc)0;
    pyopencv_ppf_match_3d_PoseCluster3D_Type.tp_methods = pyopencv_ppf_match_3d_PoseCluster3D_methods;
}

static PyObject* pyopencv_ppf_match_3d_PPF3DDetector_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<ppf_match_3d_PPF3DDetector %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_ppf_match_3d_PPF3DDetector_getseters[] =
{
    {NULL}  /* Sentinel */
};



static PyMethodDef pyopencv_ppf_match_3d_PPF3DDetector_methods[] =
{

    {NULL,          NULL}
};

static void pyopencv_ppf_match_3d_PPF3DDetector_specials(void)
{
    pyopencv_ppf_match_3d_PPF3DDetector_Type.tp_base = NULL;
    pyopencv_ppf_match_3d_PPF3DDetector_Type.tp_dealloc = pyopencv_ppf_match_3d_PPF3DDetector_dealloc;
    pyopencv_ppf_match_3d_PPF3DDetector_Type.tp_repr = pyopencv_ppf_match_3d_PPF3DDetector_repr;
    pyopencv_ppf_match_3d_PPF3DDetector_Type.tp_getset = pyopencv_ppf_match_3d_PPF3DDetector_getseters;
    pyopencv_ppf_match_3d_PPF3DDetector_Type.tp_init = (initproc)0;
    pyopencv_ppf_match_3d_PPF3DDetector_Type.tp_methods = pyopencv_ppf_match_3d_PPF3DDetector_methods;
}

static PyObject* pyopencv_BackgroundSubtractor_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<BackgroundSubtractor %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_BackgroundSubtractor_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_BackgroundSubtractor_apply(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractor* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractor_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractor*>(((pyopencv_BackgroundSubtractor_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractor' or its derivative)");
    {
    PyObject* pyobj_image = NULL;
    Mat image;
    PyObject* pyobj_fgmask = NULL;
    Mat fgmask;
    double learningRate=-1;

    const char* keywords[] = { "image", "fgmask", "learningRate", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|Od:BackgroundSubtractor.apply", (char**)keywords, &pyobj_image, &pyobj_fgmask, &learningRate) &&
        pyopencv_to(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to(pyobj_fgmask, fgmask, ArgInfo("fgmask", 1)) )
    {
        ERRWRAP2(_self_->apply(image, fgmask, learningRate));
        return pyopencv_from(fgmask);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_image = NULL;
    UMat image;
    PyObject* pyobj_fgmask = NULL;
    UMat fgmask;
    double learningRate=-1;

    const char* keywords[] = { "image", "fgmask", "learningRate", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|Od:BackgroundSubtractor.apply", (char**)keywords, &pyobj_image, &pyobj_fgmask, &learningRate) &&
        pyopencv_to(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to(pyobj_fgmask, fgmask, ArgInfo("fgmask", 1)) )
    {
        ERRWRAP2(_self_->apply(image, fgmask, learningRate));
        return pyopencv_from(fgmask);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractor_getBackgroundImage(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractor* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractor_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractor*>(((pyopencv_BackgroundSubtractor_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractor' or its derivative)");
    {
    PyObject* pyobj_backgroundImage = NULL;
    Mat backgroundImage;

    const char* keywords[] = { "backgroundImage", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "|O:BackgroundSubtractor.getBackgroundImage", (char**)keywords, &pyobj_backgroundImage) &&
        pyopencv_to(pyobj_backgroundImage, backgroundImage, ArgInfo("backgroundImage", 1)) )
    {
        ERRWRAP2(_self_->getBackgroundImage(backgroundImage));
        return pyopencv_from(backgroundImage);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_backgroundImage = NULL;
    UMat backgroundImage;

    const char* keywords[] = { "backgroundImage", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "|O:BackgroundSubtractor.getBackgroundImage", (char**)keywords, &pyobj_backgroundImage) &&
        pyopencv_to(pyobj_backgroundImage, backgroundImage, ArgInfo("backgroundImage", 1)) )
    {
        ERRWRAP2(_self_->getBackgroundImage(backgroundImage));
        return pyopencv_from(backgroundImage);
    }
    }

    return NULL;
}



static PyMethodDef pyopencv_BackgroundSubtractor_methods[] =
{
    {"apply", (PyCFunction)pyopencv_cv_BackgroundSubtractor_apply, METH_VARARGS | METH_KEYWORDS, "apply(image[, fgmask[, learningRate]]) -> fgmask\n.   @brief Computes a foreground mask.\n.   \n.   @param image Next video frame.\n.   @param fgmask The output foreground mask as an 8-bit binary image.\n.   @param learningRate The value between 0 and 1 that indicates how fast the background model is\n.   learnt. Negative parameter value makes the algorithm to use some automatically chosen learning\n.   rate. 0 means that the background model is not updated at all, 1 means that the background model\n.   is completely reinitialized from the last frame."},
    {"getBackgroundImage", (PyCFunction)pyopencv_cv_BackgroundSubtractor_getBackgroundImage, METH_VARARGS | METH_KEYWORDS, "getBackgroundImage([, backgroundImage]) -> backgroundImage\n.   @brief Computes a background image.\n.   \n.   @param backgroundImage The output background image.\n.   \n.   @note Sometimes the background image can be very blurry, as it contain the average background\n.   statistics."},

    {NULL,          NULL}
};

static void pyopencv_BackgroundSubtractor_specials(void)
{
    pyopencv_BackgroundSubtractor_Type.tp_base = &pyopencv_Algorithm_Type;
    pyopencv_BackgroundSubtractor_Type.tp_dealloc = pyopencv_BackgroundSubtractor_dealloc;
    pyopencv_BackgroundSubtractor_Type.tp_repr = pyopencv_BackgroundSubtractor_repr;
    pyopencv_BackgroundSubtractor_Type.tp_getset = pyopencv_BackgroundSubtractor_getseters;
    pyopencv_BackgroundSubtractor_Type.tp_init = (initproc)0;
    pyopencv_BackgroundSubtractor_Type.tp_methods = pyopencv_BackgroundSubtractor_methods;
}

static PyObject* pyopencv_BackgroundSubtractorMOG2_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<BackgroundSubtractorMOG2 %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_BackgroundSubtractorMOG2_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_apply(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorMOG2* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorMOG2_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorMOG2*>(((pyopencv_BackgroundSubtractorMOG2_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    {
    PyObject* pyobj_image = NULL;
    Mat image;
    PyObject* pyobj_fgmask = NULL;
    Mat fgmask;
    double learningRate=-1;

    const char* keywords[] = { "image", "fgmask", "learningRate", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|Od:BackgroundSubtractorMOG2.apply", (char**)keywords, &pyobj_image, &pyobj_fgmask, &learningRate) &&
        pyopencv_to(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to(pyobj_fgmask, fgmask, ArgInfo("fgmask", 1)) )
    {
        ERRWRAP2(_self_->apply(image, fgmask, learningRate));
        return pyopencv_from(fgmask);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_image = NULL;
    UMat image;
    PyObject* pyobj_fgmask = NULL;
    UMat fgmask;
    double learningRate=-1;

    const char* keywords[] = { "image", "fgmask", "learningRate", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O|Od:BackgroundSubtractorMOG2.apply", (char**)keywords, &pyobj_image, &pyobj_fgmask, &learningRate) &&
        pyopencv_to(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to(pyobj_fgmask, fgmask, ArgInfo("fgmask", 1)) )
    {
        ERRWRAP2(_self_->apply(image, fgmask, learningRate));
        return pyopencv_from(fgmask);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_getBackgroundRatio(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorMOG2* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorMOG2_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorMOG2*>(((pyopencv_BackgroundSubtractorMOG2_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getBackgroundRatio());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_getComplexityReductionThreshold(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorMOG2* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorMOG2_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorMOG2*>(((pyopencv_BackgroundSubtractorMOG2_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getComplexityReductionThreshold());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_getDetectShadows(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorMOG2* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorMOG2_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorMOG2*>(((pyopencv_BackgroundSubtractorMOG2_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    bool retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDetectShadows());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_getHistory(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorMOG2* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorMOG2_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorMOG2*>(((pyopencv_BackgroundSubtractorMOG2_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getHistory());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_getNMixtures(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorMOG2* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorMOG2_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorMOG2*>(((pyopencv_BackgroundSubtractorMOG2_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getNMixtures());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_getShadowThreshold(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorMOG2* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorMOG2_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorMOG2*>(((pyopencv_BackgroundSubtractorMOG2_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getShadowThreshold());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_getShadowValue(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorMOG2* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorMOG2_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorMOG2*>(((pyopencv_BackgroundSubtractorMOG2_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getShadowValue());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_getVarInit(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorMOG2* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorMOG2_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorMOG2*>(((pyopencv_BackgroundSubtractorMOG2_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getVarInit());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_getVarMax(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorMOG2* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorMOG2_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorMOG2*>(((pyopencv_BackgroundSubtractorMOG2_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getVarMax());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_getVarMin(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorMOG2* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorMOG2_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorMOG2*>(((pyopencv_BackgroundSubtractorMOG2_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getVarMin());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_getVarThreshold(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorMOG2* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorMOG2_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorMOG2*>(((pyopencv_BackgroundSubtractorMOG2_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getVarThreshold());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_getVarThresholdGen(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorMOG2* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorMOG2_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorMOG2*>(((pyopencv_BackgroundSubtractorMOG2_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getVarThresholdGen());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_setBackgroundRatio(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorMOG2* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorMOG2_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorMOG2*>(((pyopencv_BackgroundSubtractorMOG2_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    double ratio=0;

    const char* keywords[] = { "ratio", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:BackgroundSubtractorMOG2.setBackgroundRatio", (char**)keywords, &ratio) )
    {
        ERRWRAP2(_self_->setBackgroundRatio(ratio));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_setComplexityReductionThreshold(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorMOG2* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorMOG2_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorMOG2*>(((pyopencv_BackgroundSubtractorMOG2_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    double ct=0;

    const char* keywords[] = { "ct", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:BackgroundSubtractorMOG2.setComplexityReductionThreshold", (char**)keywords, &ct) )
    {
        ERRWRAP2(_self_->setComplexityReductionThreshold(ct));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_setDetectShadows(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorMOG2* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorMOG2_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorMOG2*>(((pyopencv_BackgroundSubtractorMOG2_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    bool detectShadows=0;

    const char* keywords[] = { "detectShadows", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "b:BackgroundSubtractorMOG2.setDetectShadows", (char**)keywords, &detectShadows) )
    {
        ERRWRAP2(_self_->setDetectShadows(detectShadows));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_setHistory(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorMOG2* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorMOG2_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorMOG2*>(((pyopencv_BackgroundSubtractorMOG2_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    int history=0;

    const char* keywords[] = { "history", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:BackgroundSubtractorMOG2.setHistory", (char**)keywords, &history) )
    {
        ERRWRAP2(_self_->setHistory(history));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_setNMixtures(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorMOG2* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorMOG2_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorMOG2*>(((pyopencv_BackgroundSubtractorMOG2_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    int nmixtures=0;

    const char* keywords[] = { "nmixtures", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:BackgroundSubtractorMOG2.setNMixtures", (char**)keywords, &nmixtures) )
    {
        ERRWRAP2(_self_->setNMixtures(nmixtures));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_setShadowThreshold(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorMOG2* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorMOG2_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorMOG2*>(((pyopencv_BackgroundSubtractorMOG2_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    double threshold=0;

    const char* keywords[] = { "threshold", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:BackgroundSubtractorMOG2.setShadowThreshold", (char**)keywords, &threshold) )
    {
        ERRWRAP2(_self_->setShadowThreshold(threshold));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_setShadowValue(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorMOG2* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorMOG2_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorMOG2*>(((pyopencv_BackgroundSubtractorMOG2_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    int value=0;

    const char* keywords[] = { "value", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:BackgroundSubtractorMOG2.setShadowValue", (char**)keywords, &value) )
    {
        ERRWRAP2(_self_->setShadowValue(value));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_setVarInit(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorMOG2* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorMOG2_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorMOG2*>(((pyopencv_BackgroundSubtractorMOG2_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    double varInit=0;

    const char* keywords[] = { "varInit", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:BackgroundSubtractorMOG2.setVarInit", (char**)keywords, &varInit) )
    {
        ERRWRAP2(_self_->setVarInit(varInit));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_setVarMax(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorMOG2* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorMOG2_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorMOG2*>(((pyopencv_BackgroundSubtractorMOG2_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    double varMax=0;

    const char* keywords[] = { "varMax", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:BackgroundSubtractorMOG2.setVarMax", (char**)keywords, &varMax) )
    {
        ERRWRAP2(_self_->setVarMax(varMax));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_setVarMin(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorMOG2* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorMOG2_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorMOG2*>(((pyopencv_BackgroundSubtractorMOG2_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    double varMin=0;

    const char* keywords[] = { "varMin", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:BackgroundSubtractorMOG2.setVarMin", (char**)keywords, &varMin) )
    {
        ERRWRAP2(_self_->setVarMin(varMin));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_setVarThreshold(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorMOG2* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorMOG2_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorMOG2*>(((pyopencv_BackgroundSubtractorMOG2_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    double varThreshold=0;

    const char* keywords[] = { "varThreshold", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:BackgroundSubtractorMOG2.setVarThreshold", (char**)keywords, &varThreshold) )
    {
        ERRWRAP2(_self_->setVarThreshold(varThreshold));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_setVarThresholdGen(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorMOG2* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorMOG2_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorMOG2*>(((pyopencv_BackgroundSubtractorMOG2_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    double varThresholdGen=0;

    const char* keywords[] = { "varThresholdGen", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:BackgroundSubtractorMOG2.setVarThresholdGen", (char**)keywords, &varThresholdGen) )
    {
        ERRWRAP2(_self_->setVarThresholdGen(varThresholdGen));
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_BackgroundSubtractorMOG2_methods[] =
{
    {"apply", (PyCFunction)pyopencv_cv_BackgroundSubtractorMOG2_apply, METH_VARARGS | METH_KEYWORDS, "apply(image[, fgmask[, learningRate]]) -> fgmask\n.   @brief Computes a foreground mask.\n.   \n.   @param image Next video frame. Floating point frame will be used without scaling and should be in range \\f$[0,255]\\f$.\n.   @param fgmask The output foreground mask as an 8-bit binary image.\n.   @param learningRate The value between 0 and 1 that indicates how fast the background model is\n.   learnt. Negative parameter value makes the algorithm to use some automatically chosen learning\n.   rate. 0 means that the background model is not updated at all, 1 means that the background model\n.   is completely reinitialized from the last frame."},
    {"getBackgroundRatio", (PyCFunction)pyopencv_cv_BackgroundSubtractorMOG2_getBackgroundRatio, METH_VARARGS | METH_KEYWORDS, "getBackgroundRatio() -> retval\n.   @brief Returns the \"background ratio\" parameter of the algorithm\n.   \n.   If a foreground pixel keeps semi-constant value for about backgroundRatio\\*history frames, it's\n.   considered background and added to the model as a center of a new component. It corresponds to TB\n.   parameter in the paper."},
    {"getComplexityReductionThreshold", (PyCFunction)pyopencv_cv_BackgroundSubtractorMOG2_getComplexityReductionThreshold, METH_VARARGS | METH_KEYWORDS, "getComplexityReductionThreshold() -> retval\n.   @brief Returns the complexity reduction threshold\n.   \n.   This parameter defines the number of samples needed to accept to prove the component exists. CT=0.05\n.   is a default value for all the samples. By setting CT=0 you get an algorithm very similar to the\n.   standard Stauffer&Grimson algorithm."},
    {"getDetectShadows", (PyCFunction)pyopencv_cv_BackgroundSubtractorMOG2_getDetectShadows, METH_VARARGS | METH_KEYWORDS, "getDetectShadows() -> retval\n.   @brief Returns the shadow detection flag\n.   \n.   If true, the algorithm detects shadows and marks them. See createBackgroundSubtractorMOG2 for\n.   details."},
    {"getHistory", (PyCFunction)pyopencv_cv_BackgroundSubtractorMOG2_getHistory, METH_VARARGS | METH_KEYWORDS, "getHistory() -> retval\n.   @brief Returns the number of last frames that affect the background model"},
    {"getNMixtures", (PyCFunction)pyopencv_cv_BackgroundSubtractorMOG2_getNMixtures, METH_VARARGS | METH_KEYWORDS, "getNMixtures() -> retval\n.   @brief Returns the number of gaussian components in the background model"},
    {"getShadowThreshold", (PyCFunction)pyopencv_cv_BackgroundSubtractorMOG2_getShadowThreshold, METH_VARARGS | METH_KEYWORDS, "getShadowThreshold() -> retval\n.   @brief Returns the shadow threshold\n.   \n.   A shadow is detected if pixel is a darker version of the background. The shadow threshold (Tau in\n.   the paper) is a threshold defining how much darker the shadow can be. Tau= 0.5 means that if a pixel\n.   is more than twice darker then it is not shadow. See Prati, Mikic, Trivedi and Cucchiara,\n.   *Detecting Moving Shadows...*, IEEE PAMI,2003."},
    {"getShadowValue", (PyCFunction)pyopencv_cv_BackgroundSubtractorMOG2_getShadowValue, METH_VARARGS | METH_KEYWORDS, "getShadowValue() -> retval\n.   @brief Returns the shadow value\n.   \n.   Shadow value is the value used to mark shadows in the foreground mask. Default value is 127. Value 0\n.   in the mask always means background, 255 means foreground."},
    {"getVarInit", (PyCFunction)pyopencv_cv_BackgroundSubtractorMOG2_getVarInit, METH_VARARGS | METH_KEYWORDS, "getVarInit() -> retval\n.   @brief Returns the initial variance of each gaussian component"},
    {"getVarMax", (PyCFunction)pyopencv_cv_BackgroundSubtractorMOG2_getVarMax, METH_VARARGS | METH_KEYWORDS, "getVarMax() -> retval\n."},
    {"getVarMin", (PyCFunction)pyopencv_cv_BackgroundSubtractorMOG2_getVarMin, METH_VARARGS | METH_KEYWORDS, "getVarMin() -> retval\n."},
    {"getVarThreshold", (PyCFunction)pyopencv_cv_BackgroundSubtractorMOG2_getVarThreshold, METH_VARARGS | METH_KEYWORDS, "getVarThreshold() -> retval\n.   @brief Returns the variance threshold for the pixel-model match\n.   \n.   The main threshold on the squared Mahalanobis distance to decide if the sample is well described by\n.   the background model or not. Related to Cthr from the paper."},
    {"getVarThresholdGen", (PyCFunction)pyopencv_cv_BackgroundSubtractorMOG2_getVarThresholdGen, METH_VARARGS | METH_KEYWORDS, "getVarThresholdGen() -> retval\n.   @brief Returns the variance threshold for the pixel-model match used for new mixture component generation\n.   \n.   Threshold for the squared Mahalanobis distance that helps decide when a sample is close to the\n.   existing components (corresponds to Tg in the paper). If a pixel is not close to any component, it\n.   is considered foreground or added as a new component. 3 sigma =\\> Tg=3\\*3=9 is default. A smaller Tg\n.   value generates more components. A higher Tg value may result in a small number of components but\n.   they can grow too large."},
    {"setBackgroundRatio", (PyCFunction)pyopencv_cv_BackgroundSubtractorMOG2_setBackgroundRatio, METH_VARARGS | METH_KEYWORDS, "setBackgroundRatio(ratio) -> None\n.   @brief Sets the \"background ratio\" parameter of the algorithm"},
    {"setComplexityReductionThreshold", (PyCFunction)pyopencv_cv_BackgroundSubtractorMOG2_setComplexityReductionThreshold, METH_VARARGS | METH_KEYWORDS, "setComplexityReductionThreshold(ct) -> None\n.   @brief Sets the complexity reduction threshold"},
    {"setDetectShadows", (PyCFunction)pyopencv_cv_BackgroundSubtractorMOG2_setDetectShadows, METH_VARARGS | METH_KEYWORDS, "setDetectShadows(detectShadows) -> None\n.   @brief Enables or disables shadow detection"},
    {"setHistory", (PyCFunction)pyopencv_cv_BackgroundSubtractorMOG2_setHistory, METH_VARARGS | METH_KEYWORDS, "setHistory(history) -> None\n.   @brief Sets the number of last frames that affect the background model"},
    {"setNMixtures", (PyCFunction)pyopencv_cv_BackgroundSubtractorMOG2_setNMixtures, METH_VARARGS | METH_KEYWORDS, "setNMixtures(nmixtures) -> None\n.   @brief Sets the number of gaussian components in the background model.\n.   \n.   The model needs to be reinitalized to reserve memory."},
    {"setShadowThreshold", (PyCFunction)pyopencv_cv_BackgroundSubtractorMOG2_setShadowThreshold, METH_VARARGS | METH_KEYWORDS, "setShadowThreshold(threshold) -> None\n.   @brief Sets the shadow threshold"},
    {"setShadowValue", (PyCFunction)pyopencv_cv_BackgroundSubtractorMOG2_setShadowValue, METH_VARARGS | METH_KEYWORDS, "setShadowValue(value) -> None\n.   @brief Sets the shadow value"},
    {"setVarInit", (PyCFunction)pyopencv_cv_BackgroundSubtractorMOG2_setVarInit, METH_VARARGS | METH_KEYWORDS, "setVarInit(varInit) -> None\n.   @brief Sets the initial variance of each gaussian component"},
    {"setVarMax", (PyCFunction)pyopencv_cv_BackgroundSubtractorMOG2_setVarMax, METH_VARARGS | METH_KEYWORDS, "setVarMax(varMax) -> None\n."},
    {"setVarMin", (PyCFunction)pyopencv_cv_BackgroundSubtractorMOG2_setVarMin, METH_VARARGS | METH_KEYWORDS, "setVarMin(varMin) -> None\n."},
    {"setVarThreshold", (PyCFunction)pyopencv_cv_BackgroundSubtractorMOG2_setVarThreshold, METH_VARARGS | METH_KEYWORDS, "setVarThreshold(varThreshold) -> None\n.   @brief Sets the variance threshold for the pixel-model match"},
    {"setVarThresholdGen", (PyCFunction)pyopencv_cv_BackgroundSubtractorMOG2_setVarThresholdGen, METH_VARARGS | METH_KEYWORDS, "setVarThresholdGen(varThresholdGen) -> None\n.   @brief Sets the variance threshold for the pixel-model match used for new mixture component generation"},

    {NULL,          NULL}
};

static void pyopencv_BackgroundSubtractorMOG2_specials(void)
{
    pyopencv_BackgroundSubtractorMOG2_Type.tp_base = &pyopencv_BackgroundSubtractor_Type;
    pyopencv_BackgroundSubtractorMOG2_Type.tp_dealloc = pyopencv_BackgroundSubtractorMOG2_dealloc;
    pyopencv_BackgroundSubtractorMOG2_Type.tp_repr = pyopencv_BackgroundSubtractorMOG2_repr;
    pyopencv_BackgroundSubtractorMOG2_Type.tp_getset = pyopencv_BackgroundSubtractorMOG2_getseters;
    pyopencv_BackgroundSubtractorMOG2_Type.tp_init = (initproc)0;
    pyopencv_BackgroundSubtractorMOG2_Type.tp_methods = pyopencv_BackgroundSubtractorMOG2_methods;
}

static PyObject* pyopencv_BackgroundSubtractorKNN_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<BackgroundSubtractorKNN %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_BackgroundSubtractorKNN_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_BackgroundSubtractorKNN_getDetectShadows(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorKNN* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorKNN_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorKNN*>(((pyopencv_BackgroundSubtractorKNN_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorKNN' or its derivative)");
    bool retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDetectShadows());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorKNN_getDist2Threshold(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorKNN* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorKNN_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorKNN*>(((pyopencv_BackgroundSubtractorKNN_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorKNN' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDist2Threshold());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorKNN_getHistory(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorKNN* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorKNN_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorKNN*>(((pyopencv_BackgroundSubtractorKNN_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorKNN' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getHistory());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorKNN_getNSamples(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorKNN* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorKNN_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorKNN*>(((pyopencv_BackgroundSubtractorKNN_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorKNN' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getNSamples());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorKNN_getShadowThreshold(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorKNN* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorKNN_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorKNN*>(((pyopencv_BackgroundSubtractorKNN_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorKNN' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getShadowThreshold());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorKNN_getShadowValue(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorKNN* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorKNN_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorKNN*>(((pyopencv_BackgroundSubtractorKNN_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorKNN' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getShadowValue());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorKNN_getkNNSamples(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorKNN* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorKNN_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorKNN*>(((pyopencv_BackgroundSubtractorKNN_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorKNN' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getkNNSamples());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorKNN_setDetectShadows(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorKNN* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorKNN_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorKNN*>(((pyopencv_BackgroundSubtractorKNN_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorKNN' or its derivative)");
    bool detectShadows=0;

    const char* keywords[] = { "detectShadows", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "b:BackgroundSubtractorKNN.setDetectShadows", (char**)keywords, &detectShadows) )
    {
        ERRWRAP2(_self_->setDetectShadows(detectShadows));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorKNN_setDist2Threshold(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorKNN* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorKNN_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorKNN*>(((pyopencv_BackgroundSubtractorKNN_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorKNN' or its derivative)");
    double _dist2Threshold=0;

    const char* keywords[] = { "_dist2Threshold", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:BackgroundSubtractorKNN.setDist2Threshold", (char**)keywords, &_dist2Threshold) )
    {
        ERRWRAP2(_self_->setDist2Threshold(_dist2Threshold));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorKNN_setHistory(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorKNN* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorKNN_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorKNN*>(((pyopencv_BackgroundSubtractorKNN_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorKNN' or its derivative)");
    int history=0;

    const char* keywords[] = { "history", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:BackgroundSubtractorKNN.setHistory", (char**)keywords, &history) )
    {
        ERRWRAP2(_self_->setHistory(history));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorKNN_setNSamples(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorKNN* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorKNN_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorKNN*>(((pyopencv_BackgroundSubtractorKNN_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorKNN' or its derivative)");
    int _nN=0;

    const char* keywords[] = { "_nN", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:BackgroundSubtractorKNN.setNSamples", (char**)keywords, &_nN) )
    {
        ERRWRAP2(_self_->setNSamples(_nN));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorKNN_setShadowThreshold(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorKNN* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorKNN_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorKNN*>(((pyopencv_BackgroundSubtractorKNN_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorKNN' or its derivative)");
    double threshold=0;

    const char* keywords[] = { "threshold", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:BackgroundSubtractorKNN.setShadowThreshold", (char**)keywords, &threshold) )
    {
        ERRWRAP2(_self_->setShadowThreshold(threshold));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorKNN_setShadowValue(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorKNN* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorKNN_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorKNN*>(((pyopencv_BackgroundSubtractorKNN_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorKNN' or its derivative)");
    int value=0;

    const char* keywords[] = { "value", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:BackgroundSubtractorKNN.setShadowValue", (char**)keywords, &value) )
    {
        ERRWRAP2(_self_->setShadowValue(value));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorKNN_setkNNSamples(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::BackgroundSubtractorKNN* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_BackgroundSubtractorKNN_Type))
        _self_ = dynamic_cast<cv::BackgroundSubtractorKNN*>(((pyopencv_BackgroundSubtractorKNN_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorKNN' or its derivative)");
    int _nkNN=0;

    const char* keywords[] = { "_nkNN", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:BackgroundSubtractorKNN.setkNNSamples", (char**)keywords, &_nkNN) )
    {
        ERRWRAP2(_self_->setkNNSamples(_nkNN));
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_BackgroundSubtractorKNN_methods[] =
{
    {"getDetectShadows", (PyCFunction)pyopencv_cv_BackgroundSubtractorKNN_getDetectShadows, METH_VARARGS | METH_KEYWORDS, "getDetectShadows() -> retval\n.   @brief Returns the shadow detection flag\n.   \n.   If true, the algorithm detects shadows and marks them. See createBackgroundSubtractorKNN for\n.   details."},
    {"getDist2Threshold", (PyCFunction)pyopencv_cv_BackgroundSubtractorKNN_getDist2Threshold, METH_VARARGS | METH_KEYWORDS, "getDist2Threshold() -> retval\n.   @brief Returns the threshold on the squared distance between the pixel and the sample\n.   \n.   The threshold on the squared distance between the pixel and the sample to decide whether a pixel is\n.   close to a data sample."},
    {"getHistory", (PyCFunction)pyopencv_cv_BackgroundSubtractorKNN_getHistory, METH_VARARGS | METH_KEYWORDS, "getHistory() -> retval\n.   @brief Returns the number of last frames that affect the background model"},
    {"getNSamples", (PyCFunction)pyopencv_cv_BackgroundSubtractorKNN_getNSamples, METH_VARARGS | METH_KEYWORDS, "getNSamples() -> retval\n.   @brief Returns the number of data samples in the background model"},
    {"getShadowThreshold", (PyCFunction)pyopencv_cv_BackgroundSubtractorKNN_getShadowThreshold, METH_VARARGS | METH_KEYWORDS, "getShadowThreshold() -> retval\n.   @brief Returns the shadow threshold\n.   \n.   A shadow is detected if pixel is a darker version of the background. The shadow threshold (Tau in\n.   the paper) is a threshold defining how much darker the shadow can be. Tau= 0.5 means that if a pixel\n.   is more than twice darker then it is not shadow. See Prati, Mikic, Trivedi and Cucchiara,\n.   *Detecting Moving Shadows...*, IEEE PAMI,2003."},
    {"getShadowValue", (PyCFunction)pyopencv_cv_BackgroundSubtractorKNN_getShadowValue, METH_VARARGS | METH_KEYWORDS, "getShadowValue() -> retval\n.   @brief Returns the shadow value\n.   \n.   Shadow value is the value used to mark shadows in the foreground mask. Default value is 127. Value 0\n.   in the mask always means background, 255 means foreground."},
    {"getkNNSamples", (PyCFunction)pyopencv_cv_BackgroundSubtractorKNN_getkNNSamples, METH_VARARGS | METH_KEYWORDS, "getkNNSamples() -> retval\n.   @brief Returns the number of neighbours, the k in the kNN.\n.   \n.   K is the number of samples that need to be within dist2Threshold in order to decide that that\n.   pixel is matching the kNN background model."},
    {"setDetectShadows", (PyCFunction)pyopencv_cv_BackgroundSubtractorKNN_setDetectShadows, METH_VARARGS | METH_KEYWORDS, "setDetectShadows(detectShadows) -> None\n.   @brief Enables or disables shadow detection"},
    {"setDist2Threshold", (PyCFunction)pyopencv_cv_BackgroundSubtractorKNN_setDist2Threshold, METH_VARARGS | METH_KEYWORDS, "setDist2Threshold(_dist2Threshold) -> None\n.   @brief Sets the threshold on the squared distance"},
    {"setHistory", (PyCFunction)pyopencv_cv_BackgroundSubtractorKNN_setHistory, METH_VARARGS | METH_KEYWORDS, "setHistory(history) -> None\n.   @brief Sets the number of last frames that affect the background model"},
    {"setNSamples", (PyCFunction)pyopencv_cv_BackgroundSubtractorKNN_setNSamples, METH_VARARGS | METH_KEYWORDS, "setNSamples(_nN) -> None\n.   @brief Sets the number of data samples in the background model.\n.   \n.   The model needs to be reinitalized to reserve memory."},
    {"setShadowThreshold", (PyCFunction)pyopencv_cv_BackgroundSubtractorKNN_setShadowThreshold, METH_VARARGS | METH_KEYWORDS, "setShadowThreshold(threshold) -> None\n.   @brief Sets the shadow threshold"},
    {"setShadowValue", (PyCFunction)pyopencv_cv_BackgroundSubtractorKNN_setShadowValue, METH_VARARGS | METH_KEYWORDS, "setShadowValue(value) -> None\n.   @brief Sets the shadow value"},
    {"setkNNSamples", (PyCFunction)pyopencv_cv_BackgroundSubtractorKNN_setkNNSamples, METH_VARARGS | METH_KEYWORDS, "setkNNSamples(_nkNN) -> None\n.   @brief Sets the k in the kNN. How many nearest neighbours need to match."},

    {NULL,          NULL}
};

static void pyopencv_BackgroundSubtractorKNN_specials(void)
{
    pyopencv_BackgroundSubtractorKNN_Type.tp_base = &pyopencv_BackgroundSubtractor_Type;
    pyopencv_BackgroundSubtractorKNN_Type.tp_dealloc = pyopencv_BackgroundSubtractorKNN_dealloc;
    pyopencv_BackgroundSubtractorKNN_Type.tp_repr = pyopencv_BackgroundSubtractorKNN_repr;
    pyopencv_BackgroundSubtractorKNN_Type.tp_getset = pyopencv_BackgroundSubtractorKNN_getseters;
    pyopencv_BackgroundSubtractorKNN_Type.tp_init = (initproc)0;
    pyopencv_BackgroundSubtractorKNN_Type.tp_methods = pyopencv_BackgroundSubtractorKNN_methods;
}

static PyObject* pyopencv_KalmanFilter_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<KalmanFilter %p>", self);
    return PyString_FromString(str);
}


static PyObject* pyopencv_KalmanFilter_get_controlMatrix(pyopencv_KalmanFilter_t* p, void *closure)
{
    return pyopencv_from(p->v->controlMatrix);
}

static int pyopencv_KalmanFilter_set_controlMatrix(pyopencv_KalmanFilter_t* p, PyObject *value, void *closure)
{
    if (value == NULL)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the controlMatrix attribute");
        return -1;
    }
    return pyopencv_to(value, p->v->controlMatrix) ? 0 : -1;
}

static PyObject* pyopencv_KalmanFilter_get_errorCovPost(pyopencv_KalmanFilter_t* p, void *closure)
{
    return pyopencv_from(p->v->errorCovPost);
}

static int pyopencv_KalmanFilter_set_errorCovPost(pyopencv_KalmanFilter_t* p, PyObject *value, void *closure)
{
    if (value == NULL)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the errorCovPost attribute");
        return -1;
    }
    return pyopencv_to(value, p->v->errorCovPost) ? 0 : -1;
}

static PyObject* pyopencv_KalmanFilter_get_errorCovPre(pyopencv_KalmanFilter_t* p, void *closure)
{
    return pyopencv_from(p->v->errorCovPre);
}

static int pyopencv_KalmanFilter_set_errorCovPre(pyopencv_KalmanFilter_t* p, PyObject *value, void *closure)
{
    if (value == NULL)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the errorCovPre attribute");
        return -1;
    }
    return pyopencv_to(value, p->v->errorCovPre) ? 0 : -1;
}

static PyObject* pyopencv_KalmanFilter_get_gain(pyopencv_KalmanFilter_t* p, void *closure)
{
    return pyopencv_from(p->v->gain);
}

static int pyopencv_KalmanFilter_set_gain(pyopencv_KalmanFilter_t* p, PyObject *value, void *closure)
{
    if (value == NULL)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the gain attribute");
        return -1;
    }
    return pyopencv_to(value, p->v->gain) ? 0 : -1;
}

static PyObject* pyopencv_KalmanFilter_get_measurementMatrix(pyopencv_KalmanFilter_t* p, void *closure)
{
    return pyopencv_from(p->v->measurementMatrix);
}

static int pyopencv_KalmanFilter_set_measurementMatrix(pyopencv_KalmanFilter_t* p, PyObject *value, void *closure)
{
    if (value == NULL)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the measurementMatrix attribute");
        return -1;
    }
    return pyopencv_to(value, p->v->measurementMatrix) ? 0 : -1;
}

static PyObject* pyopencv_KalmanFilter_get_measurementNoiseCov(pyopencv_KalmanFilter_t* p, void *closure)
{
    return pyopencv_from(p->v->measurementNoiseCov);
}

static int pyopencv_KalmanFilter_set_measurementNoiseCov(pyopencv_KalmanFilter_t* p, PyObject *value, void *closure)
{
    if (value == NULL)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the measurementNoiseCov attribute");
        return -1;
    }
    return pyopencv_to(value, p->v->measurementNoiseCov) ? 0 : -1;
}

static PyObject* pyopencv_KalmanFilter_get_processNoiseCov(pyopencv_KalmanFilter_t* p, void *closure)
{
    return pyopencv_from(p->v->processNoiseCov);
}

static int pyopencv_KalmanFilter_set_processNoiseCov(pyopencv_KalmanFilter_t* p, PyObject *value, void *closure)
{
    if (value == NULL)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the processNoiseCov attribute");
        return -1;
    }
    return pyopencv_to(value, p->v->processNoiseCov) ? 0 : -1;
}

static PyObject* pyopencv_KalmanFilter_get_statePost(pyopencv_KalmanFilter_t* p, void *closure)
{
    return pyopencv_from(p->v->statePost);
}

static int pyopencv_KalmanFilter_set_statePost(pyopencv_KalmanFilter_t* p, PyObject *value, void *closure)
{
    if (value == NULL)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the statePost attribute");
        return -1;
    }
    return pyopencv_to(value, p->v->statePost) ? 0 : -1;
}

static PyObject* pyopencv_KalmanFilter_get_statePre(pyopencv_KalmanFilter_t* p, void *closure)
{
    return pyopencv_from(p->v->statePre);
}

static int pyopencv_KalmanFilter_set_statePre(pyopencv_KalmanFilter_t* p, PyObject *value, void *closure)
{
    if (value == NULL)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the statePre attribute");
        return -1;
    }
    return pyopencv_to(value, p->v->statePre) ? 0 : -1;
}

static PyObject* pyopencv_KalmanFilter_get_transitionMatrix(pyopencv_KalmanFilter_t* p, void *closure)
{
    return pyopencv_from(p->v->transitionMatrix);
}

static int pyopencv_KalmanFilter_set_transitionMatrix(pyopencv_KalmanFilter_t* p, PyObject *value, void *closure)
{
    if (value == NULL)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the transitionMatrix attribute");
        return -1;
    }
    return pyopencv_to(value, p->v->transitionMatrix) ? 0 : -1;
}


static PyGetSetDef pyopencv_KalmanFilter_getseters[] =
{
    {(char*)"controlMatrix", (getter)pyopencv_KalmanFilter_get_controlMatrix, (setter)pyopencv_KalmanFilter_set_controlMatrix, (char*)"controlMatrix", NULL},
    {(char*)"errorCovPost", (getter)pyopencv_KalmanFilter_get_errorCovPost, (setter)pyopencv_KalmanFilter_set_errorCovPost, (char*)"errorCovPost", NULL},
    {(char*)"errorCovPre", (getter)pyopencv_KalmanFilter_get_errorCovPre, (setter)pyopencv_KalmanFilter_set_errorCovPre, (char*)"errorCovPre", NULL},
    {(char*)"gain", (getter)pyopencv_KalmanFilter_get_gain, (setter)pyopencv_KalmanFilter_set_gain, (char*)"gain", NULL},
    {(char*)"measurementMatrix", (getter)pyopencv_KalmanFilter_get_measurementMatrix, (setter)pyopencv_KalmanFilter_set_measurementMatrix, (char*)"measurementMatrix", NULL},
    {(char*)"measurementNoiseCov", (getter)pyopencv_KalmanFilter_get_measurementNoiseCov, (setter)pyopencv_KalmanFilter_set_measurementNoiseCov, (char*)"measurementNoiseCov", NULL},
    {(char*)"processNoiseCov", (getter)pyopencv_KalmanFilter_get_processNoiseCov, (setter)pyopencv_KalmanFilter_set_processNoiseCov, (char*)"processNoiseCov", NULL},
    {(char*)"statePost", (getter)pyopencv_KalmanFilter_get_statePost, (setter)pyopencv_KalmanFilter_set_statePost, (char*)"statePost", NULL},
    {(char*)"statePre", (getter)pyopencv_KalmanFilter_get_statePre, (setter)pyopencv_KalmanFilter_set_statePre, (char*)"statePre", NULL},
    {(char*)"transitionMatrix", (getter)pyopencv_KalmanFilter_get_transitionMatrix, (setter)pyopencv_KalmanFilter_set_transitionMatrix, (char*)"transitionMatrix", NULL},
    {NULL}  /* Sentinel */
};

static int pyopencv_cv_KalmanFilter_KalmanFilter(pyopencv_KalmanFilter_t* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    {

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        new (&(self->v)) Ptr<cv::KalmanFilter>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::KalmanFilter()));
        return 0;
    }
    }
    PyErr_Clear();

    {
    int dynamParams=0;
    int measureParams=0;
    int controlParams=0;
    int type=CV_32F;

    const char* keywords[] = { "dynamParams", "measureParams", "controlParams", "type", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "ii|ii:KalmanFilter", (char**)keywords, &dynamParams, &measureParams, &controlParams, &type) )
    {
        new (&(self->v)) Ptr<cv::KalmanFilter>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::KalmanFilter(dynamParams, measureParams, controlParams, type)));
        return 0;
    }
    }

    return -1;
}

static PyObject* pyopencv_cv_KalmanFilter_correct(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::KalmanFilter* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_KalmanFilter_Type))
        _self_ = ((pyopencv_KalmanFilter_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'KalmanFilter' or its derivative)");
    {
    PyObject* pyobj_measurement = NULL;
    Mat measurement;
    Mat retval;

    const char* keywords[] = { "measurement", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:KalmanFilter.correct", (char**)keywords, &pyobj_measurement) &&
        pyopencv_to(pyobj_measurement, measurement, ArgInfo("measurement", 0)) )
    {
        ERRWRAP2(retval = _self_->correct(measurement));
        return pyopencv_from(retval);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_measurement = NULL;
    Mat measurement;
    Mat retval;

    const char* keywords[] = { "measurement", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "O:KalmanFilter.correct", (char**)keywords, &pyobj_measurement) &&
        pyopencv_to(pyobj_measurement, measurement, ArgInfo("measurement", 0)) )
    {
        ERRWRAP2(retval = _self_->correct(measurement));
        return pyopencv_from(retval);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_KalmanFilter_predict(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::KalmanFilter* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_KalmanFilter_Type))
        _self_ = ((pyopencv_KalmanFilter_t*)self)->v.get();
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'KalmanFilter' or its derivative)");
    {
    PyObject* pyobj_control = NULL;
    Mat control;
    Mat retval;

    const char* keywords[] = { "control", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "|O:KalmanFilter.predict", (char**)keywords, &pyobj_control) &&
        pyopencv_to(pyobj_control, control, ArgInfo("control", 0)) )
    {
        ERRWRAP2(retval = _self_->predict(control));
        return pyopencv_from(retval);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_control = NULL;
    Mat control;
    Mat retval;

    const char* keywords[] = { "control", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "|O:KalmanFilter.predict", (char**)keywords, &pyobj_control) &&
        pyopencv_to(pyobj_control, control, ArgInfo("control", 0)) )
    {
        ERRWRAP2(retval = _self_->predict(control));
        return pyopencv_from(retval);
    }
    }

    return NULL;
}



static PyMethodDef pyopencv_KalmanFilter_methods[] =
{
    {"correct", (PyCFunction)pyopencv_cv_KalmanFilter_correct, METH_VARARGS | METH_KEYWORDS, "correct(measurement) -> retval\n.   @brief Updates the predicted state from the measurement.\n.   \n.   @param measurement The measured system parameters"},
    {"predict", (PyCFunction)pyopencv_cv_KalmanFilter_predict, METH_VARARGS | METH_KEYWORDS, "predict([, control]) -> retval\n.   @brief Computes a predicted state.\n.   \n.   @param control The optional input control"},

    {NULL,          NULL}
};

static void pyopencv_KalmanFilter_specials(void)
{
    pyopencv_KalmanFilter_Type.tp_base = NULL;
    pyopencv_KalmanFilter_Type.tp_dealloc = pyopencv_KalmanFilter_dealloc;
    pyopencv_KalmanFilter_Type.tp_repr = pyopencv_KalmanFilter_repr;
    pyopencv_KalmanFilter_Type.tp_getset = pyopencv_KalmanFilter_getseters;
    pyopencv_KalmanFilter_Type.tp_init = (initproc)pyopencv_cv_KalmanFilter_KalmanFilter;
    pyopencv_KalmanFilter_Type.tp_methods = pyopencv_KalmanFilter_methods;
}

static PyObject* pyopencv_DenseOpticalFlow_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<DenseOpticalFlow %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_DenseOpticalFlow_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_DenseOpticalFlow_calc(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::DenseOpticalFlow* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_DenseOpticalFlow_Type))
        _self_ = dynamic_cast<cv::DenseOpticalFlow*>(((pyopencv_DenseOpticalFlow_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'DenseOpticalFlow' or its derivative)");
    {
    PyObject* pyobj_I0 = NULL;
    Mat I0;
    PyObject* pyobj_I1 = NULL;
    Mat I1;
    PyObject* pyobj_flow = NULL;
    Mat flow;

    const char* keywords[] = { "I0", "I1", "flow", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOO:DenseOpticalFlow.calc", (char**)keywords, &pyobj_I0, &pyobj_I1, &pyobj_flow) &&
        pyopencv_to(pyobj_I0, I0, ArgInfo("I0", 0)) &&
        pyopencv_to(pyobj_I1, I1, ArgInfo("I1", 0)) &&
        pyopencv_to(pyobj_flow, flow, ArgInfo("flow", 1)) )
    {
        ERRWRAP2(_self_->calc(I0, I1, flow));
        return pyopencv_from(flow);
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_I0 = NULL;
    UMat I0;
    PyObject* pyobj_I1 = NULL;
    UMat I1;
    PyObject* pyobj_flow = NULL;
    UMat flow;

    const char* keywords[] = { "I0", "I1", "flow", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOO:DenseOpticalFlow.calc", (char**)keywords, &pyobj_I0, &pyobj_I1, &pyobj_flow) &&
        pyopencv_to(pyobj_I0, I0, ArgInfo("I0", 0)) &&
        pyopencv_to(pyobj_I1, I1, ArgInfo("I1", 0)) &&
        pyopencv_to(pyobj_flow, flow, ArgInfo("flow", 1)) )
    {
        ERRWRAP2(_self_->calc(I0, I1, flow));
        return pyopencv_from(flow);
    }
    }

    return NULL;
}

static PyObject* pyopencv_cv_DenseOpticalFlow_collectGarbage(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::DenseOpticalFlow* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_DenseOpticalFlow_Type))
        _self_ = dynamic_cast<cv::DenseOpticalFlow*>(((pyopencv_DenseOpticalFlow_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'DenseOpticalFlow' or its derivative)");

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->collectGarbage());
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_DenseOpticalFlow_methods[] =
{
    {"calc", (PyCFunction)pyopencv_cv_DenseOpticalFlow_calc, METH_VARARGS | METH_KEYWORDS, "calc(I0, I1, flow) -> flow\n.   @brief Calculates an optical flow.\n.   \n.   @param I0 first 8-bit single-channel input image.\n.   @param I1 second input image of the same size and the same type as prev.\n.   @param flow computed flow image that has the same size as prev and type CV_32FC2."},
    {"collectGarbage", (PyCFunction)pyopencv_cv_DenseOpticalFlow_collectGarbage, METH_VARARGS | METH_KEYWORDS, "collectGarbage() -> None\n.   @brief Releases all inner buffers."},

    {NULL,          NULL}
};

static void pyopencv_DenseOpticalFlow_specials(void)
{
    pyopencv_DenseOpticalFlow_Type.tp_base = &pyopencv_Algorithm_Type;
    pyopencv_DenseOpticalFlow_Type.tp_dealloc = pyopencv_DenseOpticalFlow_dealloc;
    pyopencv_DenseOpticalFlow_Type.tp_repr = pyopencv_DenseOpticalFlow_repr;
    pyopencv_DenseOpticalFlow_Type.tp_getset = pyopencv_DenseOpticalFlow_getseters;
    pyopencv_DenseOpticalFlow_Type.tp_init = (initproc)0;
    pyopencv_DenseOpticalFlow_Type.tp_methods = pyopencv_DenseOpticalFlow_methods;
}

static PyObject* pyopencv_SparseOpticalFlow_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<SparseOpticalFlow %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_SparseOpticalFlow_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_SparseOpticalFlow_calc(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::SparseOpticalFlow* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_SparseOpticalFlow_Type))
        _self_ = dynamic_cast<cv::SparseOpticalFlow*>(((pyopencv_SparseOpticalFlow_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'SparseOpticalFlow' or its derivative)");
    {
    PyObject* pyobj_prevImg = NULL;
    Mat prevImg;
    PyObject* pyobj_nextImg = NULL;
    Mat nextImg;
    PyObject* pyobj_prevPts = NULL;
    Mat prevPts;
    PyObject* pyobj_nextPts = NULL;
    Mat nextPts;
    PyObject* pyobj_status = NULL;
    Mat status;
    PyObject* pyobj_err = NULL;
    Mat err;

    const char* keywords[] = { "prevImg", "nextImg", "prevPts", "nextPts", "status", "err", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOOO|OO:SparseOpticalFlow.calc", (char**)keywords, &pyobj_prevImg, &pyobj_nextImg, &pyobj_prevPts, &pyobj_nextPts, &pyobj_status, &pyobj_err) &&
        pyopencv_to(pyobj_prevImg, prevImg, ArgInfo("prevImg", 0)) &&
        pyopencv_to(pyobj_nextImg, nextImg, ArgInfo("nextImg", 0)) &&
        pyopencv_to(pyobj_prevPts, prevPts, ArgInfo("prevPts", 0)) &&
        pyopencv_to(pyobj_nextPts, nextPts, ArgInfo("nextPts", 1)) &&
        pyopencv_to(pyobj_status, status, ArgInfo("status", 1)) &&
        pyopencv_to(pyobj_err, err, ArgInfo("err", 1)) )
    {
        ERRWRAP2(_self_->calc(prevImg, nextImg, prevPts, nextPts, status, err));
        return Py_BuildValue("(NNN)", pyopencv_from(nextPts), pyopencv_from(status), pyopencv_from(err));
    }
    }
    PyErr_Clear();

    {
    PyObject* pyobj_prevImg = NULL;
    UMat prevImg;
    PyObject* pyobj_nextImg = NULL;
    UMat nextImg;
    PyObject* pyobj_prevPts = NULL;
    UMat prevPts;
    PyObject* pyobj_nextPts = NULL;
    UMat nextPts;
    PyObject* pyobj_status = NULL;
    UMat status;
    PyObject* pyobj_err = NULL;
    UMat err;

    const char* keywords[] = { "prevImg", "nextImg", "prevPts", "nextPts", "status", "err", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "OOOO|OO:SparseOpticalFlow.calc", (char**)keywords, &pyobj_prevImg, &pyobj_nextImg, &pyobj_prevPts, &pyobj_nextPts, &pyobj_status, &pyobj_err) &&
        pyopencv_to(pyobj_prevImg, prevImg, ArgInfo("prevImg", 0)) &&
        pyopencv_to(pyobj_nextImg, nextImg, ArgInfo("nextImg", 0)) &&
        pyopencv_to(pyobj_prevPts, prevPts, ArgInfo("prevPts", 0)) &&
        pyopencv_to(pyobj_nextPts, nextPts, ArgInfo("nextPts", 1)) &&
        pyopencv_to(pyobj_status, status, ArgInfo("status", 1)) &&
        pyopencv_to(pyobj_err, err, ArgInfo("err", 1)) )
    {
        ERRWRAP2(_self_->calc(prevImg, nextImg, prevPts, nextPts, status, err));
        return Py_BuildValue("(NNN)", pyopencv_from(nextPts), pyopencv_from(status), pyopencv_from(err));
    }
    }

    return NULL;
}



static PyMethodDef pyopencv_SparseOpticalFlow_methods[] =
{
    {"calc", (PyCFunction)pyopencv_cv_SparseOpticalFlow_calc, METH_VARARGS | METH_KEYWORDS, "calc(prevImg, nextImg, prevPts, nextPts[, status[, err]]) -> nextPts, status, err\n.   @brief Calculates a sparse optical flow.\n.   \n.   @param prevImg First input image.\n.   @param nextImg Second input image of the same size and the same type as prevImg.\n.   @param prevPts Vector of 2D points for which the flow needs to be found.\n.   @param nextPts Output vector of 2D points containing the calculated new positions of input features in the second image.\n.   @param status Output status vector. Each element of the vector is set to 1 if the\n.   flow for the corresponding features has been found. Otherwise, it is set to 0.\n.   @param err Optional output vector that contains error response for each point (inverse confidence)."},

    {NULL,          NULL}
};

static void pyopencv_SparseOpticalFlow_specials(void)
{
    pyopencv_SparseOpticalFlow_Type.tp_base = &pyopencv_Algorithm_Type;
    pyopencv_SparseOpticalFlow_Type.tp_dealloc = pyopencv_SparseOpticalFlow_dealloc;
    pyopencv_SparseOpticalFlow_Type.tp_repr = pyopencv_SparseOpticalFlow_repr;
    pyopencv_SparseOpticalFlow_Type.tp_getset = pyopencv_SparseOpticalFlow_getseters;
    pyopencv_SparseOpticalFlow_Type.tp_init = (initproc)0;
    pyopencv_SparseOpticalFlow_Type.tp_methods = pyopencv_SparseOpticalFlow_methods;
}

static PyObject* pyopencv_DualTVL1OpticalFlow_repr(PyObject* self)
{
    char str[1000];
    sprintf(str, "<DualTVL1OpticalFlow %p>", self);
    return PyString_FromString(str);
}



static PyGetSetDef pyopencv_DualTVL1OpticalFlow_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyObject* pyopencv_cv_DualTVL1OpticalFlow_create_cls(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    double tau=0.25;
    double lambda=0.15;
    double theta=0.3;
    int nscales=5;
    int warps=5;
    double epsilon=0.01;
    int innnerIterations=30;
    int outerIterations=10;
    double scaleStep=0.8;
    double gamma=0.0;
    int medianFiltering=5;
    bool useInitialFlow=false;
    Ptr<DualTVL1OpticalFlow> retval;

    const char* keywords[] = { "tau", "lambda", "theta", "nscales", "warps", "epsilon", "innnerIterations", "outerIterations", "scaleStep", "gamma", "medianFiltering", "useInitialFlow", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "|dddiidiiddib:DualTVL1OpticalFlow.create", (char**)keywords, &tau, &lambda, &theta, &nscales, &warps, &epsilon, &innnerIterations, &outerIterations, &scaleStep, &gamma, &medianFiltering, &useInitialFlow) )
    {
        ERRWRAP2(retval = cv::DualTVL1OpticalFlow::create(tau, lambda, theta, nscales, warps, epsilon, innnerIterations, outerIterations, scaleStep, gamma, medianFiltering, useInitialFlow));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_DualTVL1OpticalFlow_getEpsilon(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::DualTVL1OpticalFlow* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_DualTVL1OpticalFlow_Type))
        _self_ = dynamic_cast<cv::DualTVL1OpticalFlow*>(((pyopencv_DualTVL1OpticalFlow_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'DualTVL1OpticalFlow' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getEpsilon());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_DualTVL1OpticalFlow_getGamma(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::DualTVL1OpticalFlow* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_DualTVL1OpticalFlow_Type))
        _self_ = dynamic_cast<cv::DualTVL1OpticalFlow*>(((pyopencv_DualTVL1OpticalFlow_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'DualTVL1OpticalFlow' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getGamma());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_DualTVL1OpticalFlow_getInnerIterations(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::DualTVL1OpticalFlow* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_DualTVL1OpticalFlow_Type))
        _self_ = dynamic_cast<cv::DualTVL1OpticalFlow*>(((pyopencv_DualTVL1OpticalFlow_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'DualTVL1OpticalFlow' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getInnerIterations());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_DualTVL1OpticalFlow_getLambda(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::DualTVL1OpticalFlow* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_DualTVL1OpticalFlow_Type))
        _self_ = dynamic_cast<cv::DualTVL1OpticalFlow*>(((pyopencv_DualTVL1OpticalFlow_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'DualTVL1OpticalFlow' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getLambda());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_DualTVL1OpticalFlow_getMedianFiltering(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::DualTVL1OpticalFlow* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_DualTVL1OpticalFlow_Type))
        _self_ = dynamic_cast<cv::DualTVL1OpticalFlow*>(((pyopencv_DualTVL1OpticalFlow_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'DualTVL1OpticalFlow' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMedianFiltering());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_DualTVL1OpticalFlow_getOuterIterations(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::DualTVL1OpticalFlow* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_DualTVL1OpticalFlow_Type))
        _self_ = dynamic_cast<cv::DualTVL1OpticalFlow*>(((pyopencv_DualTVL1OpticalFlow_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'DualTVL1OpticalFlow' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getOuterIterations());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_DualTVL1OpticalFlow_getScaleStep(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::DualTVL1OpticalFlow* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_DualTVL1OpticalFlow_Type))
        _self_ = dynamic_cast<cv::DualTVL1OpticalFlow*>(((pyopencv_DualTVL1OpticalFlow_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'DualTVL1OpticalFlow' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getScaleStep());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_DualTVL1OpticalFlow_getScalesNumber(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::DualTVL1OpticalFlow* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_DualTVL1OpticalFlow_Type))
        _self_ = dynamic_cast<cv::DualTVL1OpticalFlow*>(((pyopencv_DualTVL1OpticalFlow_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'DualTVL1OpticalFlow' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getScalesNumber());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_DualTVL1OpticalFlow_getTau(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::DualTVL1OpticalFlow* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_DualTVL1OpticalFlow_Type))
        _self_ = dynamic_cast<cv::DualTVL1OpticalFlow*>(((pyopencv_DualTVL1OpticalFlow_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'DualTVL1OpticalFlow' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTau());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_DualTVL1OpticalFlow_getTheta(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::DualTVL1OpticalFlow* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_DualTVL1OpticalFlow_Type))
        _self_ = dynamic_cast<cv::DualTVL1OpticalFlow*>(((pyopencv_DualTVL1OpticalFlow_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'DualTVL1OpticalFlow' or its derivative)");
    double retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTheta());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_DualTVL1OpticalFlow_getUseInitialFlow(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::DualTVL1OpticalFlow* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_DualTVL1OpticalFlow_Type))
        _self_ = dynamic_cast<cv::DualTVL1OpticalFlow*>(((pyopencv_DualTVL1OpticalFlow_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'DualTVL1OpticalFlow' or its derivative)");
    bool retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getUseInitialFlow());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_DualTVL1OpticalFlow_getWarpingsNumber(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::DualTVL1OpticalFlow* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_DualTVL1OpticalFlow_Type))
        _self_ = dynamic_cast<cv::DualTVL1OpticalFlow*>(((pyopencv_DualTVL1OpticalFlow_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'DualTVL1OpticalFlow' or its derivative)");
    int retval;

    if(PyObject_Size(args) == 0 && (kw == NULL || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getWarpingsNumber());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_DualTVL1OpticalFlow_setEpsilon(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::DualTVL1OpticalFlow* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_DualTVL1OpticalFlow_Type))
        _self_ = dynamic_cast<cv::DualTVL1OpticalFlow*>(((pyopencv_DualTVL1OpticalFlow_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'DualTVL1OpticalFlow' or its derivative)");
    double val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:DualTVL1OpticalFlow.setEpsilon", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setEpsilon(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_DualTVL1OpticalFlow_setGamma(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::DualTVL1OpticalFlow* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_DualTVL1OpticalFlow_Type))
        _self_ = dynamic_cast<cv::DualTVL1OpticalFlow*>(((pyopencv_DualTVL1OpticalFlow_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'DualTVL1OpticalFlow' or its derivative)");
    double val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:DualTVL1OpticalFlow.setGamma", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setGamma(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_DualTVL1OpticalFlow_setInnerIterations(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::DualTVL1OpticalFlow* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_DualTVL1OpticalFlow_Type))
        _self_ = dynamic_cast<cv::DualTVL1OpticalFlow*>(((pyopencv_DualTVL1OpticalFlow_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'DualTVL1OpticalFlow' or its derivative)");
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:DualTVL1OpticalFlow.setInnerIterations", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setInnerIterations(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_DualTVL1OpticalFlow_setLambda(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::DualTVL1OpticalFlow* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_DualTVL1OpticalFlow_Type))
        _self_ = dynamic_cast<cv::DualTVL1OpticalFlow*>(((pyopencv_DualTVL1OpticalFlow_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'DualTVL1OpticalFlow' or its derivative)");
    double val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:DualTVL1OpticalFlow.setLambda", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setLambda(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_DualTVL1OpticalFlow_setMedianFiltering(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::DualTVL1OpticalFlow* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_DualTVL1OpticalFlow_Type))
        _self_ = dynamic_cast<cv::DualTVL1OpticalFlow*>(((pyopencv_DualTVL1OpticalFlow_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'DualTVL1OpticalFlow' or its derivative)");
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:DualTVL1OpticalFlow.setMedianFiltering", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setMedianFiltering(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_DualTVL1OpticalFlow_setOuterIterations(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::DualTVL1OpticalFlow* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_DualTVL1OpticalFlow_Type))
        _self_ = dynamic_cast<cv::DualTVL1OpticalFlow*>(((pyopencv_DualTVL1OpticalFlow_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'DualTVL1OpticalFlow' or its derivative)");
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:DualTVL1OpticalFlow.setOuterIterations", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setOuterIterations(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_DualTVL1OpticalFlow_setScaleStep(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::DualTVL1OpticalFlow* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_DualTVL1OpticalFlow_Type))
        _self_ = dynamic_cast<cv::DualTVL1OpticalFlow*>(((pyopencv_DualTVL1OpticalFlow_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'DualTVL1OpticalFlow' or its derivative)");
    double val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:DualTVL1OpticalFlow.setScaleStep", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setScaleStep(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_DualTVL1OpticalFlow_setScalesNumber(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::DualTVL1OpticalFlow* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_DualTVL1OpticalFlow_Type))
        _self_ = dynamic_cast<cv::DualTVL1OpticalFlow*>(((pyopencv_DualTVL1OpticalFlow_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'DualTVL1OpticalFlow' or its derivative)");
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:DualTVL1OpticalFlow.setScalesNumber", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setScalesNumber(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_DualTVL1OpticalFlow_setTau(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::DualTVL1OpticalFlow* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_DualTVL1OpticalFlow_Type))
        _self_ = dynamic_cast<cv::DualTVL1OpticalFlow*>(((pyopencv_DualTVL1OpticalFlow_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'DualTVL1OpticalFlow' or its derivative)");
    double val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:DualTVL1OpticalFlow.setTau", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setTau(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_DualTVL1OpticalFlow_setTheta(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::DualTVL1OpticalFlow* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_DualTVL1OpticalFlow_Type))
        _self_ = dynamic_cast<cv::DualTVL1OpticalFlow*>(((pyopencv_DualTVL1OpticalFlow_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'DualTVL1OpticalFlow' or its derivative)");
    double val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "d:DualTVL1OpticalFlow.setTheta", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setTheta(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_DualTVL1OpticalFlow_setUseInitialFlow(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::DualTVL1OpticalFlow* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_DualTVL1OpticalFlow_Type))
        _self_ = dynamic_cast<cv::DualTVL1OpticalFlow*>(((pyopencv_DualTVL1OpticalFlow_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'DualTVL1OpticalFlow' or its derivative)");
    bool val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "b:DualTVL1OpticalFlow.setUseInitialFlow", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setUseInitialFlow(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_DualTVL1OpticalFlow_setWarpingsNumber(PyObject* self, PyObject* args, PyObject* kw)
{
    using namespace cv;

    cv::DualTVL1OpticalFlow* _self_ = NULL;
    if(PyObject_TypeCheck(self, &pyopencv_DualTVL1OpticalFlow_Type))
        _self_ = dynamic_cast<cv::DualTVL1OpticalFlow*>(((pyopencv_DualTVL1OpticalFlow_t*)self)->v.get());
    if (_self_ == NULL)
        return failmsgp("Incorrect type of self (must be 'DualTVL1OpticalFlow' or its derivative)");
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(args, kw, "i:DualTVL1OpticalFlow.setWarpingsNumber", (char**)keywords, &val) )
    {
        ERRWRAP2(_self_->setWarpingsNumber(val));
        Py_RETURN_NONE;
    }

    return NULL;
}



static PyMethodDef pyopencv_DualTVL1OpticalFlow_methods[] =
{
    {"create", (PyCFunction)pyopencv_cv_DualTVL1OpticalFlow_create_cls, METH_VARARGS | METH_KEYWORDS | METH_CLASS, "create([, tau[, lambda[, theta[, nscales[, warps[, epsilon[, innnerIterations[, outerIterations[, scaleStep[, gamma[, medianFiltering[, useInitialFlow]]]]]]]]]]]]) -> retval\n.   @brief Creates instance of cv::DualTVL1OpticalFlow"},
    {"getEpsilon", (PyCFunction)pyopencv_cv_DualTVL1OpticalFlow_getEpsilon, METH_VARARGS | METH_KEYWORDS, "getEpsilon() -> retval\n.   @see setEpsilon"},
    {"getGamma", (PyCFunction)pyopencv_cv_DualTVL1OpticalFlow_getGamma, METH_VARARGS | METH_KEYWORDS, "getGamma() -> retval\n.   @see setGamma"},
    {"getInnerIterations", (PyCFunction)pyopencv_cv_DualTVL1OpticalFlow_getInnerIterations, METH_VARARGS | METH_KEYWORDS, "getInnerIterations() -> retval\n.   @see setInnerIterations"},
    {"getLambda", (PyCFunction)pyopencv_cv_DualTVL1OpticalFlow_getLambda, METH_VARARGS | METH_KEYWORDS, "getLambda() -> retval\n.   @see setLambda"},
    {"getMedianFiltering", (PyCFunction)pyopencv_cv_DualTVL1OpticalFlow_getMedianFiltering, METH_VARARGS | METH_KEYWORDS, "getMedianFiltering() -> retval\n.   @see setMedianFiltering"},
    {"getOuterIterations", (PyCFunction)pyopencv_cv_DualTVL1OpticalFlow_getOuterIterations, METH_VARARGS | METH_KEYWORDS, "getOuterIterations() -> retval\n.   @see setOuterIterations"},
    {"getScaleStep", (PyCFunction)pyopencv_cv_DualTVL1OpticalFlow_getScaleStep, METH_VARARGS | METH_KEYWORDS, "getScaleStep() -> retval\n.   @see setScaleStep"},
    {"getScalesNumber", (PyCFunction)pyopencv_cv_DualTVL1OpticalFlow_getScalesNumber, METH_VARARGS | METH_KEYWORDS, "getScalesNumber() -> retval\n.   @see setScalesNumber"},
    {"getTau", (PyCFunction)pyopencv_cv_DualTVL1OpticalFlow_getTau, METH_VARARGS | METH_KEYWORDS, "getTau() -> retval\n.   @see setTau"},
    {"getTheta", (PyCFunction)pyopencv_cv_DualTVL1OpticalFlow_getTheta, METH_VARARGS | METH_KEYWORDS, "getTheta() -> retval\n.   @see setTheta"},
    {"getUseInitialFlow", (PyCFunction)pyopencv_cv_DualTVL1OpticalFlow_getUseInitialFlow, METH_VARARGS | METH_KEYWORDS, "getUseInitialFlow() -> retval\n.   @see setUseInitialFlow"},
    {"getWarpingsNumber", (PyCFunction)pyopencv_cv_DualTVL1OpticalFlow_getWarpingsNumber, METH_VARARGS | METH_KEYWORDS, "getWarpingsNumber() -> retval\n.   @see setWarpingsNumber"},
    {"setEpsilon", (PyCFunction)pyopencv_cv_DualTVL1OpticalFlow_setEpsilon, METH_VARARGS | METH_KEYWORDS, "setEpsilon(val) -> None\n.   @copybrief getEpsilon @see getEpsilon"},
    {"setGamma", (PyCFunction)pyopencv_cv_DualTVL1OpticalFlow_setGamma, METH_VARARGS | METH_KEYWORDS, "setGamma(val) -> None\n.   @copybrief getGamma @see getGamma"},
    {"setInnerIterations", (PyCFunction)pyopencv_cv_DualTVL1OpticalFlow_setInnerIterations, METH_VARARGS | METH_KEYWORDS, "setInnerIterations(val) -> None\n.   @copybrief getInnerIterations @see getInnerIterations"},
    {"setLambda", (PyCFunction)pyopencv_cv_DualTVL1OpticalFlow_setLambda, METH_VARARGS | METH_KEYWORDS, "setLambda(val) -> None\n.   @copybrief getLambda @see getLambda"},
    {"setMedianFiltering", (PyCFunction)pyopencv_cv_DualTVL1OpticalFlow_setMedianFiltering, METH_VARARGS | METH_KEYWORDS, "setMedianFiltering(val) -> None\n.   @copybrief getMedianFiltering @see getMedianFiltering"},
    {"setOuterIterations", (PyCFunction)pyopencv_cv_DualTVL1OpticalFlow_setOuterIterations, METH_VARARGS | METH_KEYWORDS, "setOuterIterations(val) -> None\n.   @copybrief getOuterIterations @see getOuterIterations"},
    {"setScaleStep", (PyCFunction)pyopencv_cv_DualTVL1OpticalFlow_setScaleStep, METH_VARARGS | METH_KEYWORDS, "setScaleStep(val) -> None\n.   @copybrief getScaleStep @see getScaleStep"},
    {"setScalesNumber", (PyCFunction)pyopencv_cv_DualTVL1OpticalFlow_setScalesNumber, METH_VARARGS | METH_KEYWORDS, "setScalesNumber(val) -> None\n.   @copybrief getScalesNumber @see getScalesNumber"},
    {"setTau", (PyCFunction)pyopencv_cv_DualTVL1OpticalFlow_setTau, METH_VARARGS | METH_KEYWORDS, "setTau(val) -> None\n.   @copybrief getTau @see getTau"},
    {"setTheta", (PyCFunction)pyopencv_cv_DualTVL1OpticalFlow_setTheta, METH_VARARGS | METH_KEYWORDS, "setTheta(val) -> None\n.   @copybrief getThe