/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGAnimationElement.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGElement.h"
#include "JSSVGStringList.h"
#include "SVGAnimationElement.h"
#include "SVGElement.h"
#include "SVGStringList.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGAnimationElementTableValues[] =
{
    { "targetElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimationElementTargetElement), (intptr_t)0, NoIntrinsic },
    { "requiredFeatures", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimationElementRequiredFeatures), (intptr_t)0, NoIntrinsic },
    { "requiredExtensions", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimationElementRequiredExtensions), (intptr_t)0, NoIntrinsic },
    { "systemLanguage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimationElementSystemLanguage), (intptr_t)0, NoIntrinsic },
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimationElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimationElementTable = { 16, 15, JSSVGAnimationElementTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSSVGAnimationElementPrototypeTableValues[] =
{
    { "getStartTime", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGAnimationElementPrototypeFunctionGetStartTime), (intptr_t)0, NoIntrinsic },
    { "getCurrentTime", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGAnimationElementPrototypeFunctionGetCurrentTime), (intptr_t)0, NoIntrinsic },
    { "getSimpleDuration", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGAnimationElementPrototypeFunctionGetSimpleDuration), (intptr_t)0, NoIntrinsic },
    { "hasExtension", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGAnimationElementPrototypeFunctionHasExtension), (intptr_t)1, NoIntrinsic },
    { "beginElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGAnimationElementPrototypeFunctionBeginElement), (intptr_t)0, NoIntrinsic },
    { "beginElementAt", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGAnimationElementPrototypeFunctionBeginElementAt), (intptr_t)1, NoIntrinsic },
    { "endElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGAnimationElementPrototypeFunctionEndElement), (intptr_t)0, NoIntrinsic },
    { "endElementAt", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGAnimationElementPrototypeFunctionEndElementAt), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimationElementPrototypeTable = { 17, 15, JSSVGAnimationElementPrototypeTableValues, 0 };
const ClassInfo JSSVGAnimationElementPrototype::s_info = { "SVGAnimationElementPrototype", &Base::s_info, &JSSVGAnimationElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGAnimationElementPrototype) };

JSObject* JSSVGAnimationElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGAnimationElement>(exec, globalObject);
}

bool JSSVGAnimationElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGAnimationElementPrototype* thisObject = jsCast<JSSVGAnimationElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGAnimationElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGAnimationElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGAnimationElementPrototype* thisObject = jsCast<JSSVGAnimationElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGAnimationElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGAnimationElement::s_info = { "SVGAnimationElement", &Base::s_info, &JSSVGAnimationElementTable, 0 , CREATE_METHOD_TABLE(JSSVGAnimationElement) };

JSSVGAnimationElement::JSSVGAnimationElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGAnimationElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

void JSSVGAnimationElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGAnimationElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGAnimationElementPrototype::create(exec->globalData(), globalObject, JSSVGAnimationElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGAnimationElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGAnimationElement* thisObject = jsCast<JSSVGAnimationElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGAnimationElement, Base>(exec, &JSSVGAnimationElementTable, thisObject, propertyName, slot);
}

bool JSSVGAnimationElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGAnimationElement* thisObject = jsCast<JSSVGAnimationElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGAnimationElement, Base>(exec, &JSSVGAnimationElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGAnimationElementTargetElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimationElement* castedThis = jsCast<JSSVGAnimationElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAnimationElement* impl = static_cast<SVGAnimationElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->targetElement()));
    return result;
}


JSValue jsSVGAnimationElementRequiredFeatures(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimationElement* castedThis = jsCast<JSSVGAnimationElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAnimationElement* impl = static_cast<SVGAnimationElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredFeatures())));
    return result;
}


JSValue jsSVGAnimationElementRequiredExtensions(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimationElement* castedThis = jsCast<JSSVGAnimationElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAnimationElement* impl = static_cast<SVGAnimationElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredExtensions())));
    return result;
}


JSValue jsSVGAnimationElementSystemLanguage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimationElement* castedThis = jsCast<JSSVGAnimationElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAnimationElement* impl = static_cast<SVGAnimationElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->systemLanguage())));
    return result;
}


JSValue jsSVGAnimationElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimationElement* castedThis = jsCast<JSSVGAnimationElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAnimationElement* impl = static_cast<SVGAnimationElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


EncodedJSValue JSC_HOST_CALL jsSVGAnimationElementPrototypeFunctionGetStartTime(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGAnimationElement::s_info))
        return throwVMTypeError(exec);
    JSSVGAnimationElement* castedThis = jsCast<JSSVGAnimationElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGAnimationElement::s_info);
    SVGAnimationElement* impl = static_cast<SVGAnimationElement*>(castedThis->impl());

    JSC::JSValue result = jsNumber(impl->getStartTime());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGAnimationElementPrototypeFunctionGetCurrentTime(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGAnimationElement::s_info))
        return throwVMTypeError(exec);
    JSSVGAnimationElement* castedThis = jsCast<JSSVGAnimationElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGAnimationElement::s_info);
    SVGAnimationElement* impl = static_cast<SVGAnimationElement*>(castedThis->impl());

    JSC::JSValue result = jsNumber(impl->getCurrentTime());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGAnimationElementPrototypeFunctionGetSimpleDuration(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGAnimationElement::s_info))
        return throwVMTypeError(exec);
    JSSVGAnimationElement* castedThis = jsCast<JSSVGAnimationElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGAnimationElement::s_info);
    SVGAnimationElement* impl = static_cast<SVGAnimationElement*>(castedThis->impl());
    ExceptionCode ec = 0;

    JSC::JSValue result = jsNumber(impl->getSimpleDuration(ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGAnimationElementPrototypeFunctionHasExtension(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGAnimationElement::s_info))
        return throwVMTypeError(exec);
    JSSVGAnimationElement* castedThis = jsCast<JSSVGAnimationElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGAnimationElement::s_info);
    SVGAnimationElement* impl = static_cast<SVGAnimationElement*>(castedThis->impl());
    const String& extension(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasExtension(extension));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGAnimationElementPrototypeFunctionBeginElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGAnimationElement::s_info))
        return throwVMTypeError(exec);
    JSSVGAnimationElement* castedThis = jsCast<JSSVGAnimationElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGAnimationElement::s_info);
    SVGAnimationElement* impl = static_cast<SVGAnimationElement*>(castedThis->impl());
    impl->beginElement();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGAnimationElementPrototypeFunctionBeginElementAt(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGAnimationElement::s_info))
        return throwVMTypeError(exec);
    JSSVGAnimationElement* castedThis = jsCast<JSSVGAnimationElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGAnimationElement::s_info);
    SVGAnimationElement* impl = static_cast<SVGAnimationElement*>(castedThis->impl());
    float offset(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->beginElementAt(offset);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGAnimationElementPrototypeFunctionEndElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGAnimationElement::s_info))
        return throwVMTypeError(exec);
    JSSVGAnimationElement* castedThis = jsCast<JSSVGAnimationElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGAnimationElement::s_info);
    SVGAnimationElement* impl = static_cast<SVGAnimationElement*>(castedThis->impl());
    impl->endElement();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGAnimationElementPrototypeFunctionEndElementAt(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGAnimationElement::s_info))
        return throwVMTypeError(exec);
    JSSVGAnimationElement* castedThis = jsCast<JSSVGAnimationElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGAnimationElement::s_info);
    SVGAnimationElement* impl = static_cast<SVGAnimationElement*>(castedThis->impl());
    float offset(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->endElementAt(offset);
    return JSValue::encode(jsUndefined());
}


}

#endif // ENABLE(SVG)
