#!/bin/sh

########################################################################
#
#  Convert an rtf document to EPUB format using 'Ted'.
#
#  Usage	rtf2epub.sh something.rtf something.epub
#
#  This is an example. Refer to http://www.nllgg.nl/Ted/index.html for the
#  'Ted' documentation.
#
########################################################################

case $# in
    1)
	rtf="$1";
	epub=`basename "$1" .rtf`.epub
	;;
    2)
	rtf="$1";
	epub="$2";
	;;
    *)
	echo $0: '$#='$#
	exit 1
	;;
esac

Ted --saveTo "$rtf" "$epub"

