/* powerpc64-darwin.macho-entry.h
   created from powerpc64-darwin.macho-entry.bin, 9556 (0x2554) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2025 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2025 Laszlo Molnar
   Copyright (C) 2000-2025 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_POWERPC64_DARWIN_MACHO_ENTRY_SIZE    9556
#define STUB_POWERPC64_DARWIN_MACHO_ENTRY_ADLER32 0x062df4ed
#define STUB_POWERPC64_DARWIN_MACHO_ENTRY_CRC32   0xeef8619b

unsigned char stub_powerpc64_darwin_macho_entry[9556] = {
/* 0x0000 */ 127, 69, 76, 70,  2,  2,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   0,  1,  0, 21,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 31,232,
/* 0x0030 */   0,  0,  0,  0,  0, 64,  0,  0,  0,  0,  0, 64,  0,  0,  0,  0,
/* 0x0040 */  72,  0,  0,  1,124,  0, 41,236,125,168,  2,166, 40,  7,  0,  8,
/* 0x0050 */  64,130,  1, 72,248,166,  0,  0,124,132, 26, 20, 60,  0,128,  0,
/* 0x0060 */ 120,  0,  7,198,124,  9,  3,120, 56, 99,255,255, 56,165,255,255,
/* 0x0070 */  57, 64,255,255, 72,  0,  1, 20, 57, 32,  0,  1,125, 41, 28, 44,
/* 0x0080 */  56, 99,  0,  4,125, 41, 73, 20,121, 41,248, 36,124, 41,  0, 64,
/* 0x0090 */ 125, 41, 72, 20, 78,128,  0, 32,141,  3,  0,  1,157,  5,  0,  1,
/* 0x00a0 */ 124, 41,  0, 64,125, 41, 72, 20, 65,194,255,209, 65,225,255,236,
/* 0x00b0 */  56,224,  0,  1, 72,  0,  0, 20, 56,231,255,255,125, 41, 72, 21,
/* 0x00c0 */  65,194,255,185,124,231, 57, 20,125, 41, 72, 21, 65,194,255,173,
/* 0x00d0 */ 124,231, 57, 20,124, 41,  0, 64,125, 41, 72, 20, 65,194,255,157,
/* 0x00e0 */  65,192,255,216, 52,231,255,253, 57,  0,  0,  0, 65,192,  0, 40,
/* 0x00f0 */ 141, 99,  0,  1,120,231, 69,198,124,231,  6,118,124,234, 88,249,
/* 0x0100 */ 125, 74, 14,116, 65,194,  0,  0,113,107,  0,  1, 65,226,  0, 80,
/* 0x0110 */  72,  0,  0, 20,124, 41,  0, 64,125, 41, 72, 20, 65,194,255, 93,
/* 0x0120 */  65,225,  0, 60, 57,  0,  0,  1,124, 41,  0, 64,125, 41, 72, 20,
/* 0x0130 */  65,194,255, 73, 65,225,  0, 40,125, 41, 72, 21, 65,194,255, 61,
/* 0x0140 */ 125,  8, 65, 20,124, 41,  0, 64,125, 41, 72, 20, 65,194,255, 45,
/* 0x0150 */  65,192,255,232, 57,  8,  0,  2, 72,  0,  0, 16,125, 41, 72, 21,
/* 0x0160 */  65,194,255, 25,125,  8, 65, 20, 33,106,250,255, 57,  8,  0,  2,
/* 0x0170 */ 125,  8,  1,148,124,234, 42, 20,125,  9,  3,166,141,103,  0,  1,
/* 0x0180 */ 157,101,  0,  1, 67, 32,255,248, 56,224,  1,  0,124,  7, 41,236,
/* 0x0190 */ 124,  7, 26, 44, 75,255,255, 12,124,  0, 41,236,125,168,  2,166,
/* 0x01a0 */  40,  7,  0,  5, 64,130,  1, 48,248,166,  0,  0,124,132, 26, 20,
/* 0x01b0 */  60,  0,128,  0,120,  0,  7,198, 61, 32,128,  0,121, 41,  7,198,
/* 0x01c0 */  56, 99,255,255, 56,165,255,255, 57, 64,255,255, 72,  0,  0,248,
/* 0x01d0 */  57, 32,  0,  1,125, 41, 28, 44, 56, 99,  0,  4,125, 41, 73, 20,
/* 0x01e0 */ 121, 41,248, 36,124, 41,  0, 64,125, 41, 72, 20, 78,128,  0, 32,
/* 0x01f0 */ 141,  3,  0,  1,157,  5,  0,  1,124, 41,  0, 64,125, 41, 72, 20,
/* 0x0200 */  65,194,255,209, 65,225,255,236, 56,224,  0,  1, 72,  0,  0, 20,
/* 0x0210 */  56,231,255,255,125, 41, 72, 21, 65,194,255,185,124,231, 57, 21,
/* 0x0220 */ 125, 41, 72, 21, 65,194,255,173,124,231, 57, 21,124, 41,  0, 64,
/* 0x0230 */ 125, 41, 72, 20, 65,194,255,157, 65,192,255,216, 57,  0,  0,  0,
/* 0x0240 */  52,231,255,253, 84,231, 64, 46, 65,192,  0, 28,141, 99,  0,  1,
/* 0x0250 */ 124,234, 88,249,125, 74, 14,112, 44, 42,  0,  0, 65,194,  0,  0,
/* 0x0260 */  72,  0,  0, 12,125, 41, 72, 21, 65,194,255,105,125,  8, 65, 21,
/* 0x0270 */ 125, 41, 72, 21, 65,194,255, 93,125,  8, 65, 21, 64,130,  0, 40,
/* 0x0280 */  57,  0,  0,  1,125, 41, 72, 21, 65,194,255, 73,125,  8, 65, 21,
/* 0x0290 */ 124, 41,  0, 64,125, 41, 72, 20, 65,194,255, 57, 65,192,255,232,
/* 0x02a0 */  57,  8,  0,  2, 32,234,250,255, 57,  8,  0,  1,125,  8,  1,148,
/* 0x02b0 */ 124,234, 42, 20,125,  9,  3,166,141,  7,  0,  1,157,  5,  0,  1,
/* 0x02c0 */  67, 32,255,248, 56,224,  1,  0,124,  7, 41,236,124,  7, 26, 44,
/* 0x02d0 */  75,255,255, 40,124,  0, 41,236,125,168,  2,166, 40,  7,  0,  2,
/* 0x02e0 */  64,130,  0,236,248,166,  0,  0,124,132, 26, 20, 60,  0,128,  0,
/* 0x02f0 */ 120,  0,  7,198,124,  9,  3,120, 56, 99,255,255, 56,165,255,255,
/* 0x0300 */  57, 64,255,255, 72,  0,  0,184,125, 41, 73, 20,121, 41,248, 36,
/* 0x0310 */ 124, 41,  0, 64,125, 41, 72, 20, 76,226,  0, 32, 57, 32,  0,  1,
/* 0x0320 */ 125, 41, 28, 44, 56, 99,  0,  4, 75,255,255,224,141,  3,  0,  1,
/* 0x0330 */ 157,  5,  0,  1, 75,255,255,221, 65,225,255,244, 56,224,  0,  1,
/* 0x0340 */  75,255,255,209,124,231, 57, 21, 75,255,255,201, 65,192,255,244,
/* 0x0350 */  52,231,255,253, 57,  0,  0,  0, 65,192,  0, 24,141, 99,  0,  1,
/* 0x0360 */  84,231, 64, 46,124,234, 88,248, 85, 75,  0, 63, 65,194,  0,  0,
/* 0x0370 */  75,255,255,161,125,  8, 65, 21, 75,255,255,153,125,  8, 65, 21,
/* 0x0380 */  56,224,  0,  1, 64,194,  0, 28, 56,224,  0,  3, 57,  0,  0,  1,
/* 0x0390 */  75,255,255,129,125,  8, 65, 21, 75,255,255,121, 65,192,255,244,
/* 0x03a0 */  33,106,242,255,125,  8, 57, 20,124,234, 42, 20,125,  9,  3,166,
/* 0x03b0 */ 141,  7,  0,  1,157,  5,  0,  1, 67, 32,255,248, 56,224,  1,  0,
/* 0x03c0 */ 124,  7, 41,236,124,  7, 26, 44, 75,255,255,108, 40,  7,  0, 14,
/* 0x03d0 */  64,130,  0,  0,248, 33,255,145,124,  8,  2,166, 57, 38,  0,  4,
/* 0x03e0 */ 129,  6,  0,  4,124,167, 43,120, 56,164,255,254, 56,131,  0,  2,
/* 0x03f0 */ 137,131,  0,  0,248,  1,  0, 16,121,139,232,194,121,140,  7, 96,
/* 0x0400 */  56, 96,250,  0,124, 99, 88, 54, 56, 99,241,100,124, 38, 11,120,
/* 0x0410 */ 124, 33, 26, 20,120, 33,  6,100, 56,  0,  0,  0,124,195, 51,120,
/* 0x0420 */ 144,  9,  0,  0,248,  3,255,249,124, 33, 24, 64, 65,128,255,248,
/* 0x0430 */ 248,193,  0,  0,136,  4,255,255, 56,193,  0, 36, 56, 97,  0, 40,
/* 0x0440 */ 153,131,  0,  2,248,225,  0, 16,249, 33,  0, 24,120, 11,225,  2,
/* 0x0450 */ 120,  0,  7, 32,153, 99,  0,  1,152,  3,  0,  0,248, 33,255,145,
/* 0x0460 */  56, 33,  0,112,232,161,  0, 24,232,225,  0, 16,128,165,  0,  0,
/* 0x0470 */ 232, 33,  0,  0,124,165, 58, 20,232,  1,  0, 16, 56,165,255,255,
/* 0x0480 */ 232, 33,  0,  0,124,  8,  3,166, 72,  0,  0,  9, 72,  0, 11,188,
/* 0x0490 */ 124,  8,  2,166, 57, 64,  0,  1, 72,  0,  0,  1, 59, 99,  0,  4,
/* 0x04a0 */  59,227,  0,  2, 56,  0,  4,  0,137, 99,  0,  2,125, 75, 88, 48,
/* 0x04b0 */  57,107,255,255,121,107,  0, 32,249, 97,255, 96,137, 99,  0,  1,
/* 0x04c0 */ 125, 74, 88, 48, 57, 96,  0,  0, 57, 74,255,255,121, 74,  0, 32,
/* 0x04d0 */ 249, 65,255,104,137, 67,  0,  0,145,102,  0,  0,145,105,  0,  0,
/* 0x04e0 */ 125, 85,  7,180,137, 99,  0,  1,125, 75, 82, 20, 57, 96,  3,  0,
/* 0x04f0 */ 125,106, 80, 48, 57, 74,  7, 54,121, 74,  0, 32, 47,138,  0,  0,
/* 0x0500 */  57,106,  0,  1, 64,254,  0,  8, 57, 96,  0,  1, 53,107,255,255,
/* 0x0510 */  65,130,  0, 12,180, 31,  0,  2, 75,255,255,244, 56,  0,  0,  5,
/* 0x0520 */ 124,164, 42, 20,124,  9,  3,166, 57,100,  0,  5,124,159, 35,120,
/* 0x0530 */  57, 64,  0,  0,127,191, 40, 64, 64,158,  0, 12, 56, 96,  0,  1,
/* 0x0540 */  72,  0, 10, 88, 59,255,  0,  1,136, 31,255,255, 85, 74, 64, 46,
/* 0x0550 */ 124, 10, 83,120,121, 74,  0, 32, 66,  0,255,220, 56,  0,255,255,
/* 0x0560 */  63, 32,  0,255,120,  0,  0, 32, 58,192,  0,  1, 59,  0,  0,  1,
/* 0x0570 */  58,224,  0,  1, 58, 64,  0,  1, 57,128,  0,  0, 59,192,  0,  0,
/* 0x0580 */  59, 64,  0,  0, 99, 57,255,255, 58,128,  0,  1, 34,117,  0,  8,
/* 0x0590 */ 127,154, 64, 64, 64,156,  9,216,235,161,255, 96,127,128,200, 64,
/* 0x05a0 */ 127, 95,232, 56, 85,157, 32, 54,127,252,  7,180,127,189,  7,180,
/* 0x05b0 */ 127,188,234, 20,123,189, 15,164, 65,157,  0, 36,127,171, 40, 64,
/* 0x05c0 */  65,158,255,124,139,139,  0,  0, 85, 74, 64, 46,120,  0, 64, 40,
/* 0x05d0 */  57,107,  0,  1,127,138, 83,120,121, 74,  0, 32,125,251,234, 46,
/* 0x05e0 */  84, 16,170,254,126, 16,121,214,127,138,128, 64,122, 28,  0, 32,
/* 0x05f0 */  64,156,  1,228, 32, 15,  8,  0,235,225,255,104,127,222,158, 48,
/* 0x0600 */ 124,  0, 46,112,125,224,122, 20,127, 64,248, 56,125,251,235, 46,
/* 0x0610 */ 124, 29,168, 48, 47,140,  0,  6,127,190,234, 20, 31,189,  3,  0,
/* 0x0620 */ 123,189,  0, 32, 59,189,  7, 54,123,189, 15,164,127,187,234, 20,
/* 0x0630 */  65,157,  0, 16, 59,192,  0,  1,127,128,227,120, 72,  0,  1, 12,
/* 0x0640 */ 124, 18,208, 80, 59,192,  0,  1,120,  0,  0, 32,125,231,  0,174,
/* 0x0650 */  85,255,  8, 60,127,239,  7,180, 87,255,  5,238,127,156,200, 64,
/* 0x0660 */ 127,255,  7,180, 58, 63,  1,  0,126, 49,242, 20,122, 49, 15,164,
/* 0x0670 */  65,157,  0, 36,127,171, 40, 64, 65,158,254,196,136, 11,  0,  0,
/* 0x0680 */  85, 74, 64, 46,123,156, 64, 40, 57,107,  0,  1,124, 10, 83,120,
/* 0x0690 */ 121, 74,  0, 32,126, 29,138, 46, 87,128,170,254, 87,222,  8, 60,
/* 0x06a0 */ 124,  0,129,214,127, 10,  0, 64,120, 14,  0, 32, 47,191,  0,  0,
/* 0x06b0 */  64,152,  0, 36, 32, 16,  8,  0,127,222,  7,180,124,  0, 46,112,
/* 0x06c0 */ 126,  0,130, 20,125,220,115,120,126, 29,139, 46, 65,158,  0, 48,
/* 0x06d0 */  75,255,255,104,127,128,224, 80,125, 64, 80, 80, 86,  0,217,126,
/* 0x06e0 */ 126,  0,128, 80, 59,222,  0,  1,123,156,  0, 32,121, 74,  0, 32,
/* 0x06f0 */ 126, 29,139, 46,127,222,  7,180, 65,158,255, 64, 47,158,  0,255,
/* 0x0700 */  64,157,255, 80, 75,255,255, 52,127,128,200, 64,123,208, 15,164,
/* 0x0710 */  64,157,  0, 68,127,157,130, 46, 84, 31,170,254, 87,222,  8, 60,
/* 0x0720 */ 127,255,225,214,127,138,248, 64,123,241,  0, 32, 64,156,  0, 76,
/* 0x0730 */  32, 28,  8,  0,127,222,  7,180,124,  0, 46,112,127,128,226, 20,
/* 0x0740 */ 127,157,131, 46,126, 32,139,120, 47,158,  0,255, 64,157,255,188,
/* 0x0750 */  72,  0,  0, 80,127,171, 40, 64, 65,158,253,228,139,235,  0,  0,
/* 0x0760 */  85, 74, 64, 46,120,  0, 64, 40, 57,107,  0,  1,127,234, 83,120,
/* 0x0770 */ 121, 74,  0, 32, 75,255,255,160,124, 31,  0, 80,125, 95, 80, 80,
/* 0x0780 */  87,159,217,126,127,159,224, 80, 59,222,  0,  1,121, 74,  0, 32,
/* 0x0790 */ 127,157,131, 46,127,222,  7,180,120, 17,  0, 32, 75,255,255,168,
/* 0x07a0 */ 123,222,  6, 32, 59,250,  0,  1, 47,140,  0,  3,123,255,  0, 32,
/* 0x07b0 */ 127,199,209,174, 64,157,  7,172, 47,140,  0,  9, 65,157,  0, 12,
/* 0x07c0 */  57,140,255,253, 72,  0,  0,  8, 57,140,255,250,125,140,  7,180,
/* 0x07d0 */  72,  0,  7,148,124, 16,  0, 80, 85,254,217,126,126, 16, 80, 80,
/* 0x07e0 */ 125,254,120, 80, 59,140,  0,192,127,128,200, 64,125,251,235, 46,
/* 0x07f0 */ 120, 17,  0, 32,122, 10,  0, 32,123,156, 15,164, 65,157,  0, 36,
/* 0x0800 */ 127,171, 40, 64, 65,158,253, 56,137, 75,  0,  0, 86, 16, 64, 46,
/* 0x0810 */ 120, 17, 64, 40, 57,107,  0,  1,125, 74,131,120,121, 74,  0, 32,
/* 0x0820 */ 126, 27,226, 46, 86, 32,170,254,124,  0,129,214,127,138,  0, 64,
/* 0x0830 */ 120, 30,  0, 32, 64,156,  0, 68, 47,140,  0,  7, 32, 16,  8,  0,
/* 0x0840 */ 125,144, 16, 38, 85,140,239,254,124,  0, 46,112,126,  0,130, 20,
/* 0x0850 */ 127, 22,195,120,125,140,  0,208,126,248,187,120,126, 27,227, 46,
/* 0x0860 */ 121,140,240, 66, 59,163,  6,104,121,140, 16,  0,126, 87,147,120,
/* 0x0870 */  57,140,  0,  3, 72,  0,  2,124,127,192,136, 80, 86, 15,217,126,
/* 0x0880 */ 126, 15,128, 80,124,  0, 80, 80,127,158,200, 64,126, 27,227, 46,
/* 0x0890 */ 123,209,  0, 32,120, 10,  0, 32, 58, 28,  0, 24, 65,157,  0, 36,
/* 0x08a0 */ 127,171, 40, 64, 65,158,252,152,137, 75,  0,  0, 84,  0, 64, 46,
/* 0x08b0 */ 123,209, 64, 40, 57,107,  0,  1,125, 74,  3,120,121, 74,  0, 32,
/* 0x08c0 */ 125,251,130, 46, 86, 32,170,254,124,  0,121,214,127,138,  0, 64,
/* 0x08d0 */ 120, 30,  0, 32, 64,156,  0,208, 35,143,  8,  0,127,128,200, 64,
/* 0x08e0 */ 127,156, 46,112,125,252,122, 20, 59,189,  1,224,125,251,131, 46,
/* 0x08f0 */  65,157,  0, 36,127,171, 40, 64, 65,158,252, 68,120, 30, 64, 40,
/* 0x0900 */ 136, 11,  0,  0, 85, 74, 64, 46, 57,107,  0,  1,124, 10, 83,120,
/* 0x0910 */ 121, 74,  0, 32,126, 59,234, 46, 87,220,170,254,127,156,137,214,
/* 0x0920 */ 127,138,224, 64,123,128,  0, 32, 64,156,  0, 80, 35,241,  8,  0,
/* 0x0930 */  47,186,  0,  0,127,255, 46,112,126, 63,138, 20,126, 59,235, 46,
/* 0x0940 */  65,158,251,252, 47,140,  0,  7,127,242,208, 80,125,144, 16, 38,
/* 0x0950 */  85,140,239,254,123,255,  0, 32,125,140,  0,208,127,199,248,174,
/* 0x0960 */ 121,140,  7,164, 59,250,  0,  1, 57,140,  0, 11,123,255,  0, 32,
/* 0x0970 */ 127,199,209,174, 72,  0,  5,240, 86, 32,217,126,124,  0,136, 80,
/* 0x0980 */ 127,220,240, 80,125, 92, 80, 80,124, 27,235, 46,123,222,  0, 32,
/* 0x0990 */ 127,  0,195,120,121, 74,  0, 32,126, 88,147,120,126,242,187,120,
/* 0x09a0 */  72,  0,  0,124,126, 32,136, 80, 85,254,217,126,124,  0, 80, 80,
/* 0x09b0 */ 125,254,120, 80,127,145,200, 64,125,251,131, 46,122, 61,  0, 32,
/* 0x09c0 */ 120, 10,  0, 32, 58, 28,  0, 48, 65,157,  0, 36,127,171, 40, 64,
/* 0x09d0 */  65,158,251,108,137, 75,  0,  0, 84,  0, 64, 46,122, 61, 64, 40,
/* 0x09e0 */  57,107,  0,  1,125, 74,  3,120,121, 74,  0, 32,126, 59,130, 46,
/* 0x09f0 */  87,160,170,254,124,  0,137,214,127,138,  0, 64,120, 30,  0, 32,
/* 0x0a00 */  64,156,  0, 36, 32, 17,  8,  0,124,  0, 46,112,126, 32,138, 20,
/* 0x0a10 */ 127,  0,195,120,126, 59,131, 46,126,248,187,120,124, 23,  3,120,
/* 0x0a20 */  72,  0,  0,160,127,160,232, 80, 86, 62,217,126,124,  0, 80, 80,
/* 0x0a30 */ 126, 62,136, 80,127,157,200, 64,123,175,  0, 32,126, 59,131, 46,
/* 0x0a40 */ 120, 10,  0, 32, 59,156,  0, 72, 65,157,  0, 36,127,171, 40, 64,
/* 0x0a50 */  65,158,250,236,137, 75,  0,  0, 84,  0, 64, 46,123,175, 64, 40,
/* 0x0a60 */  57,107,  0,  1,125, 74,  3,120,121, 74,  0, 32,127,187,226, 46,
/* 0x0a70 */  85,224,170,254,124,  0,233,214,127,138,  0, 64,120, 30,  0, 32,
/* 0x0a80 */  64,156,  0, 24, 32, 29,  8,  0,124,  0, 46,112,124,  0,234, 20,
/* 0x0a90 */ 124, 27,227, 46, 72,  0,  0, 44,127,192,120, 80,125, 64, 80, 80,
/* 0x0aa0 */  87,160,217,126,124,  0,232, 80,121, 74,  0, 32,124, 27,227, 46,
/* 0x0ab0 */ 127,  0,195,120,123,222,  0, 32,126,216,179,120,124, 22,  3,120,
/* 0x0ac0 */  47,140,  0,  7,126, 64,147,120,125,144, 16, 38, 85,140,239,254,
/* 0x0ad0 */ 127, 18,195,120, 59,163, 10,108,126,248,187,120,124, 23,  3,120,
/* 0x0ae0 */ 125,140,  0,208,121,140,240, 66,121,140, 16,  0, 57,140,  0, 11,
/* 0x0af0 */ 127,158,200, 64, 65,157,  0, 36,127,171, 40, 64, 65,158,250, 64,
/* 0x0b00 */ 136, 11,  0,  0, 85, 74, 64, 46,123,222, 64, 40, 57,107,  0,  1,
/* 0x0b10 */ 124, 10, 83,120,121, 74,  0, 32,161,253,  0,  0, 87,220,170,254,
/* 0x0b20 */ 127,156,121,214,127,138,224, 64,123,128,  0, 32, 64,156,  0, 48,
/* 0x0b30 */  87,255, 24, 56, 34, 47,  8,  0,127,255,  7,180,126, 49, 46,112,
/* 0x0b40 */  59,255,  0,  2,126, 49,122, 20,123,255, 15,164,178, 61,  0,  0,
/* 0x0b50 */  58,  0,  0,  0,127,189,250, 20, 72,  0,  0,136,127,220,240, 80,
/* 0x0b60 */  85,241,217,126,127,156, 80, 80,126, 49,120, 80,127,158,200, 64,
/* 0x0b70 */ 123,208,  0, 32,178, 61,  0,  0,123,138,  0, 32, 65,157,  0, 36,
/* 0x0b80 */ 127,171, 40, 64, 65,158,249,184,137, 75,  0,  0, 87,156, 64, 46,
/* 0x0b90 */ 123,208, 64, 40, 57,107,  0,  1,125, 74,227,120,121, 74,  0, 32,
/* 0x0ba0 */ 163,157,  0,  2, 86, 30,170,254,127,222,225,214,127,138,240, 64,
/* 0x0bb0 */ 123,192,  0, 32, 64,156,  0, 52, 87,255, 24, 56, 35,220,  8,  0,
/* 0x0bc0 */ 127,255,  7,180,127,222, 46,112, 59,255,  0,130,127,158,226, 20,
/* 0x0bd0 */ 123,255, 15,164,179,157,  0,  2, 58,  0,  0,  8,127,189,250, 20,
/* 0x0be0 */  58, 32,  0,  3, 72,  0,  0, 44, 87,159,217,126,124, 30,128, 80,
/* 0x0bf0 */ 125, 94, 80, 80,127,255,224, 80,121, 74,  0, 32,179,253,  0,  2,
/* 0x0c00 */ 120,  0,  0, 32, 59,189,  2,  4, 58,  0,  0, 16, 58, 32,  0,  8,
/* 0x0c10 */  59,241,255,255, 59,192,  0,  1,123,255,  0, 32, 59,255,  0,  1,
/* 0x0c20 */ 127,233,  3,166,123,220, 15,164,127,128,200, 64,127,157,226, 20,
/* 0x0c30 */  65,157,  0, 36,127,171, 40, 64, 65,158,249,  4,139,235,  0,  0,
/* 0x0c40 */  85, 74, 64, 46,120,  0, 64, 40, 57,107,  0,  1,127,234, 83,120,
/* 0x0c50 */ 121, 74,  0, 32,161,252,  0,  0, 84, 31,170,254, 87,222,  8, 60,
/* 0x0c60 */ 127,255,121,214,127,138,248, 64,123,238,  0, 32, 64,156,  0, 32,
/* 0x0c70 */  32, 15,  8,  0,127,222,  7,180,124,  0, 46,112,125,224,122, 20,
/* 0x0c80 */ 125,192,115,120,177,252,  0,  0, 72,  0,  0, 40,124, 31,  0, 80,
/* 0x0c90 */ 125, 95, 80, 80, 85,255,217,126,125,255,120, 80, 59,222,  0,  1,
/* 0x0ca0 */ 177,252,  0,  0,120,  0,  0, 32,121, 74,  0, 32,127,222,  7,180,
/* 0x0cb0 */  66,  0,255,116,126,145,136, 48, 47,140,  0,  3,126, 49,128, 80,
/* 0x0cc0 */ 127,145,242, 20, 65,157,  2, 80, 47,156,  0,  3,127,158,227,120,
/* 0x0cd0 */  64,157,  0,  8, 59,192,  0,  3, 87,222, 48, 50,127,222,  7,180,
/* 0x0ce0 */  59,160,  0,  6, 59,222,  1,176,127,169,  3,166,123,222, 15,164,
/* 0x0cf0 */  59,224,  0,  1,123,241, 15,164,127,128,200, 64,126, 49,242, 20,
/* 0x0d00 */  65,157,  0, 36,127,171, 40, 64, 65,158,248, 52,139,171,  0,  0,
/* 0x0d10 */  85, 74, 64, 46,120,  0, 64, 40, 57,107,  0,  1,127,170, 83,120,
/* 0x0d20 */ 121, 74,  0, 32,126, 91,138, 46, 84, 29,170,254, 87,255,  8, 60,
/* 0x0d30 */ 127,189,145,214,127,138,232, 64,123,176,  0, 32, 64,156,  0, 32,
/* 0x0d40 */  32, 18,  8,  0,127,255,  7,180,124,  0, 46,112,126, 64,146, 20,
/* 0x0d50 */ 126,  0,131,120,126, 91,139, 46, 72,  0,  0, 40,124, 29,  0, 80,
/* 0x0d60 */ 125, 93, 80, 80, 86, 93,217,126,126, 93,144, 80, 59,255,  0,  1,
/* 0x0d70 */ 126, 91,139, 46,120,  0,  0, 32,121, 74,  0, 32,127,255,  7,180,
/* 0x0d80 */  66,  0,255,116, 59,255,255,192, 47,159,  0,  3,127,242,  7,180,
/* 0x0d90 */  64,157,  1,108, 87,241,  7,254, 47,159,  0, 13, 98, 49,  0,  2,
/* 0x0da0 */ 127,254, 14,112,122, 61,  0, 32, 65,157,  0, 40, 59,254,255,255,
/* 0x0db0 */  35,210,  2,176,127,253,  7,180,126, 63,248, 48,127,222,250, 20,
/* 0x0dc0 */ 123,222, 15,164, 59,222,255,254,127,219,242, 20, 72,  0,  0,116,
/* 0x0dd0 */  59,222,255,250,123,222,  0, 32, 59,222,  0,  1,127,201,  3,166,
/* 0x0de0 */ 127,128,200, 64, 65,157,  0, 36,127,171, 40, 64, 65,158,247, 80,
/* 0x0df0 */ 139,235,  0,  0, 85, 74, 64, 46,120,  0, 64, 40, 57,107,  0,  1,
/* 0x0e00 */ 127,234, 83,120,121, 74,  0, 32, 84, 30,248,126, 87,191,  8, 60,
/* 0x0e10 */ 127,138,240, 64,123,192,  0, 32,123,253,  0, 32, 65,156,  0, 20,
/* 0x0e20 */ 125, 94, 80, 80, 99,255,  0,  1,121, 74,  0, 32,123,253,  0, 32,
/* 0x0e30 */  66,  0,255,176,123,191, 32, 40, 59,195,  6, 72, 59,160,  0,  4,
/* 0x0e40 */  59,189,255,255, 58, 64,  0,  1,123,189,  0, 32, 58, 32,  0,  1,
/* 0x0e50 */  59,189,  0,  1,127,169,  3,166,122, 80, 15,164,127,128,200, 64,
/* 0x0e60 */ 126, 30,130, 20, 65,157,  0, 36,127,171, 40, 64, 65,158,246,208,
/* 0x0e70 */ 139,171,  0,  0, 85, 74, 64, 46,120,  0, 64, 40, 57,107,  0,  1,
/* 0x0e80 */ 127,170, 83,120,121, 74,  0, 32,161,240,  0,  0, 84, 29,170,254,
/* 0x0e90 */  86, 82,  8, 60,127,189,121,214,127,138,232, 64,123,174,  0, 32,
/* 0x0ea0 */  64,156,  0, 32, 32, 15,  8,  0,126, 82,  7,180,124,  0, 46,112,
/* 0x0eb0 */ 125,224,122, 20,125,192,115,120,177,240,  0,  0, 72,  0,  0, 48,
/* 0x0ec0 */ 124, 29,  0, 80,125, 93, 80, 80, 85,253,217,126,125,253,120, 80,
/* 0x0ed0 */  58, 82,  0,  1,177,240,  0,  0,126, 63,251,120,120,  0,  0, 32,
/* 0x0ee0 */ 121, 74,  0, 32,126, 82,  7,180,123,255,  0, 32, 86, 49,  8, 60,
/* 0x0ef0 */ 126, 49,  7,180, 66,  0,255,100, 72,  0,  0,  8,123,255,  0, 32,
/* 0x0f00 */  59,255,  0,  1,123,242,  0, 33, 65,130,  0,100, 57,140,  0,  7,
/* 0x0f10 */ 125,140,  7,180, 59,220,  0,  2,127,146,208, 64,127,222,  7,180,
/* 0x0f20 */  65,157,246, 28, 59,222,255,255,123,222,  0, 32, 59,222,  0,  1,
/* 0x0f30 */ 127,201,  3,166,127,242,208, 80, 59,186,  0,  1,123,255,  0, 32,
/* 0x0f40 */ 127,199,248,174,123,191,  0, 32,127,199,209,174, 66, 64,  0, 24,
/* 0x0f50 */ 127,157, 64, 64,127,250,251,120, 65,156,255,220, 72,  0,  0,  8,
/* 0x0f60 */  57,128,  0,  0,127,250,251,120, 75,255,246, 40, 61, 64,  0,255,
/* 0x0f70 */  97, 74,255,255,127,128, 80, 64, 65,157,  0, 16,127,171, 40, 64,
/* 0x0f80 */  65,158,245,188, 57,107,  0,  1,124,132, 88, 80, 56, 96,  0,  0,
/* 0x0f90 */ 144,134,  0,  0,147, 73,  0,  0, 72,  0,  0,  0,249,193,255,112,
/* 0x0fa0 */ 249,225,255,120,250,  1,255,128,250, 33,255,136,250, 65,255,144,
/* 0x0fb0 */ 250, 97,255,152,250,129,255,160,250,161,255,168,250,193,255,176,
/* 0x0fc0 */ 250,225,255,184,251,  1,255,192,251, 33,255,200,251, 65,255,208,
/* 0x0fd0 */ 251, 97,255,216,251,129,255,224,251,161,255,232,251,193,255,240,
/* 0x0fe0 */ 251,225,255,248,248,  1,  0, 16, 78,128,  0, 32,233,193,255,112,
/* 0x0ff0 */ 233,225,255,120,234,  1,255,128,234, 33,255,136,234, 65,255,144,
/* 0x1000 */ 234, 97,255,152,234,129,255,160,234,161,255,168,234,193,255,176,
/* 0x1010 */ 234,225,255,184,235,  1,255,192,235, 33,255,200,235, 65,255,208,
/* 0x1020 */ 235, 97,255,216,235,129,255,224,232,  1,  0, 16,235,161,255,232,
/* 0x1030 */ 124,  8,  3,166,235,193,255,240,235,225,255,248, 78,128,  0, 32,
/* 0x1040 */   0,  0,  0,  0,  0,  0,  0,  1, 72,  0,  0,  9, 72,  0, 12,112,
/* 0x1050 */ 249,225,255,120,249,193,255,112, 56,  0,  0,  0, 57, 96,  0,  1,
/* 0x1060 */ 250, 97,255,152,250, 65,255,144, 58, 99,  0,  4,251,225,255,248,
/* 0x1070 */ 251,193,255,240, 59,227,  0,  2,250,  1,255,128,250, 33,255,136,
/* 0x1080 */ 250,129,255,160,250,161,255,168,250,193,255,176,250,225,255,184,
/* 0x1090 */ 251,  1,255,192,251, 33,255,200,251, 65,255,208,251, 97,255,216,
/* 0x10a0 */ 251,129,255,224,251,161,255,232,137, 67,  0,  0,138, 67,  0,  1,
/* 0x10b0 */ 138, 35,  0,  2,144,  6,  0,  0,144,  9,  0,  0,125, 79,  7,180,
/* 0x10c0 */ 125,113,136, 48,125,107,144, 48, 58, 49,255,255, 57,107,255,255,
/* 0x10d0 */ 122, 49,  0, 32,121,114,  0, 32,137, 99,  0,  1,125,107, 82, 20,
/* 0x10e0 */  57, 64,  3,  0,125, 74, 88, 48, 57, 74,  7, 54,121, 75,  0, 33,
/* 0x10f0 */  65,130,  0, 40, 57, 75,255,255, 57, 96,  4,  0,121, 74,  0, 32,
/* 0x1100 */  57, 74,  0,  1,125, 73,  3,166, 96,  0,  0,  0, 96,  0,  0,  0,
/* 0x1110 */ 181,127,  0,  2, 66,  0,255,252,124,164, 42, 20,127,164, 40, 64,
/* 0x1120 */  65,158,  2,240, 59,224,  0,  4,137, 68,  0,  0, 57,100,  0,  1,
/* 0x1130 */ 127,233,  3,166, 57,132,  0,  5,127,171, 40, 64, 85, 74, 64, 46,
/* 0x1140 */  57,107,  0,  1, 65,158,  2,204,136, 11,255,255,124, 10, 83,120,
/* 0x1150 */ 121, 74,  0, 32, 66,  0,255,228, 47,168,  0,  0, 65,158, 11, 80,
/* 0x1160 */  56,  0,  0,  1, 57, 96,  0,  1,248,  1,255, 96,249, 97,255, 88,
/* 0x1170 */  32, 15,  0,  8, 59,224,255,255,144,  1,255, 84, 63, 32,  0,255,
/* 0x1180 */ 123,255,  0, 32, 57,192,  0,  1, 58,  0,  0,  1, 58,160,  0,  0,
/* 0x1190 */  57, 96,  0,  0, 58,192,  0,  0, 99, 57,255,255,126,221,136, 56,
/* 0x11a0 */  86,160, 32, 54,127,190,  7,180,124,  0,  7,180,127,222,  2, 20,
/* 0x11b0 */ 127,159,200, 64,123,222, 15,164, 65,157,  0, 36,127,172, 40, 64,
/* 0x11c0 */  65,158,  2, 80,136, 12,  0,  0, 85, 74, 64, 46,123,255, 64, 40,
/* 0x11d0 */  57,140,  0,  1,124, 10, 83,120,121, 74,  0, 32,127,147,242, 46,
/* 0x11e0 */  87,251,170,254,127,123,225,214,127,138,216, 64,123, 96,  0, 32,
/* 0x11f0 */  64,156,  2,112,131,225,255, 84,126,221,144, 56, 47,149,  0,  6,
/* 0x1200 */ 127,189,120, 48,125,107,254, 48, 35,252,  8,  0,127,255, 46,112,
/* 0x1210 */ 127,255,226, 20,125,107,234, 20,127,243,243, 46, 85,125, 64, 46,
/* 0x1220 */  85,107, 80, 42,127,189, 88, 80, 57, 96,  0,  1,123,189,  0, 32,
/* 0x1230 */  59,189,  7, 54,123,189, 15,164,127,179,234, 20, 64,157,  1, 40,
/* 0x1240 */ 127,240,176, 80, 57, 96,  0,  1,123,255,  0, 32,127, 71,248,174,
/* 0x1250 */  72,  0,  0, 40, 96,  0,  0,  0, 96,  0,  0,  0, 96,  0,  0,  0,
/* 0x1260 */ 127,125,243, 46,125,107,  7,180,127,224,251,120, 64,130,  0,172,
/* 0x1270 */  47,139,  0,255, 65,157,  0,172, 87, 90,  8, 60, 87, 95,  5,238,
/* 0x1280 */  85,120,  8, 60,127,255,  7,180, 59,223,  1,  0, 44, 63,  0,  0,
/* 0x1290 */ 127,222, 90, 20,127,  0,200, 64, 79,128,  0,  0,127, 11,195,120,
/* 0x12a0 */ 124,172, 40, 64, 59, 24,  0,  1, 85, 95, 64, 46,123,222, 15,164,
/* 0x12b0 */ 127, 90,  7,180, 65,153,  0, 28, 65,134,  1, 88,137, 76,  0,  0,
/* 0x12c0 */ 120,  0, 64, 40, 57,140,  0,  1,125, 74,251,120,121, 74,  0, 32,
/* 0x12d0 */ 127,157,242, 46, 84, 27,170,254,127,251,225,214, 35,124,  8,  0,
/* 0x12e0 */  87,151,217,126,127,123, 46,112,127, 10,248, 64,127,123,226, 20,
/* 0x12f0 */ 124, 31,  0, 80,126,159, 80, 80,127,151,224, 80,123,255,  0, 32,
/* 0x1300 */  65,152,255, 96,127,157,243, 46,127, 11,  7,180,120,  0,  0, 32,
/* 0x1310 */ 122,138,  0, 32, 64,158,255, 92, 47,139,  0,255, 64,253,  0, 72,
/* 0x1320 */ 121,107,  6, 32, 59,214,  0,  1,125,103,177,174,124, 31,  3,120,
/* 0x1330 */ 123,214,  0, 32, 47,149,  0,  9, 65,157,  8,104, 58,181,255,253,
/* 0x1340 */ 126,181,  7,180, 72,  0,  6, 84, 96,  0,  0,  0, 96,  0,  0,  0,
/* 0x1350 */ 127,107,  7,180, 47,139,  0,255,127,221,227, 46,127, 64,211,120,
/* 0x1360 */  65,157,  0,136, 85,123,  8, 60,127,128,200, 64,127, 44, 40, 64,
/* 0x1370 */ 127,120,219,120, 85, 95, 64, 46,121,124, 15,164, 65,157,  0, 28,
/* 0x1380 */  65,154,  0,144,137, 76,  0,  0,120,  0, 64, 40, 57,140,  0,  1,
/* 0x1390 */ 125, 74,251,120,121, 74,  0, 32,127, 93,226, 46, 84, 31,170,254,
/* 0x13a0 */  57,120,  0,  1,127,255,209,214, 35,218,  8,  0, 87, 88,217,126,
/* 0x13b0 */ 127,222, 46,112,127,138,248, 64,127, 24,208, 80,127,222,210, 20,
/* 0x13c0 */ 123,250,  0, 32, 65,156,255,140,125,107,  7,180,124, 31,  0, 80,
/* 0x13d0 */ 125, 95, 80, 80,127, 29,227, 46, 47,139,  0,255,120,  0,  0, 32,
/* 0x13e0 */ 121, 74,  0, 32, 64,157,255,128, 59,214,  0,  1,121,107,  6, 32,
/* 0x13f0 */ 123,222,  0, 32, 47,149,  0,  3,125,103,177,174,124, 31,  3,120,
/* 0x1400 */ 127,214,243,120, 65,157,255, 48, 58,160,  0,  0, 72,  0,  5,140,
/* 0x1410 */  56, 96,  0,  1,233,193,255,112,233,225,255,120,234,  1,255,128,
/* 0x1420 */ 234, 33,255,136,234, 65,255,144,234, 97,255,152,234,129,255,160,
/* 0x1430 */ 234,161,255,168,234,193,255,176,234,225,255,184,235,  1,255,192,
/* 0x1440 */ 235, 33,255,200,235, 65,255,208,235, 97,255,216,235,129,255,224,
/* 0x1450 */ 235,161,255,232,235,193,255,240,235,225,255,248, 78,128,  0, 32,
/* 0x1460 */ 124, 27,248, 80, 87,159,217,126,127,123, 80, 80,127,255,224, 80,
/* 0x1470 */  57,117,  0,192,127,128,200, 64,127,243,243, 46,120, 26,  0, 32,
/* 0x1480 */ 123,106,  0, 32,121,107, 15,164, 65,157,  0, 36,127,172, 40, 64,
/* 0x1490 */  65,158,255,128,137, 76,  0,  0, 87,123, 64, 46,120, 26, 64, 40,
/* 0x14a0 */  57,140,  0,  1,125, 74,219,120,121, 74,  0, 32,127,115, 90, 46,
/* 0x14b0 */  87, 64,170,254,124,  0,217,214,127,138,  0, 64,120, 28,  0, 32,
/* 0x14c0 */  64,156,  3, 16, 32, 27,  8,  0,250,  1,255,104, 47,149,  0,  7,
/* 0x14d0 */ 124,  0, 46,112,127, 96,218, 20, 59,  3,  6,104,127,115, 91, 46,
/* 0x14e0 */ 126,176, 16, 38, 86,181,239,254,126,181,  0,208,122,181,240, 66,
/* 0x14f0 */ 122,181, 16,  0, 58,181,  0,  3,127,156,200, 64, 65,157,  0, 36,
/* 0x1500 */ 127,172, 40, 64, 65,158,255, 12,137,108,  0,  0, 85, 74, 64, 46,
/* 0x1510 */ 123,156, 64, 40, 57,140,  0,  1,125,106, 83,120,121, 74,  0, 32,
/* 0x1520 */ 160, 24,  0,  0, 87,139,170,254,125,107,  1,214,127,138, 88, 64,
/* 0x1530 */ 121,127,  0, 32, 64,156,  4,156, 87,171, 24, 56, 35,192,  8,  0,
/* 0x1540 */ 125,107,  7,180,127,222, 46,112, 57,107,  0,  2,124, 30,  2, 20,
/* 0x1550 */ 121,107, 15,164,176, 24,  0,  0, 58,128,  0,  0,127, 24, 90, 20,
/* 0x1560 */  58,224,  0,  3, 57,119,255,255, 56,  0,  0,  1,121,107,  0, 32,
/* 0x1570 */  57,107,  0,  1,125,105,  3,166, 96,  0,  0,  0, 96,  0,  0,  0,
/* 0x1580 */ 120, 28, 15,164, 84, 26,  8, 60,127,159,200, 64,127, 44, 40, 64,
/* 0x1590 */ 127, 93,211,120, 85, 75, 64, 46,127,152,226, 20, 65,157,  0, 28,
/* 0x15a0 */  65,154,254,112,137, 76,  0,  0,123,255, 64, 40, 57,140,  0,  1,
/* 0x15b0 */ 125, 74, 91,120,121, 74,  0, 32,163,220,  0,  0, 87,235,170,254,
/* 0x15c0 */  56, 29,  0,  1,125,107,241,214, 35,190,  8,  0, 87,219,217,126,
/* 0x15d0 */ 127,189, 46,112,127,138, 88, 64,127,123,240, 80,127,221,242, 20,
/* 0x15e0 */ 121,125,  0, 32, 64,156,  2,236,127, 64,  7,180,179,220,  0,  0,
/* 0x15f0 */ 127,191,235,120, 66,  0,255,140, 57, 96,  0,  1, 47,149,  0,  3,
/* 0x1600 */ 125,119,184, 48,126,247,160, 80,126,247,  2, 20,146,225,255, 80,
/* 0x1610 */  65,157,  3, 24, 47,151,  0,  3,122,235,  0, 32, 65,157,  5,148,
/* 0x1620 */  85,120, 48, 50,127, 24,  7,180, 56,  0,  0,  6, 59, 24,  1,176,
/* 0x1630 */ 124,  9,  3,166,123, 24, 15,164, 57, 96,  0,  1, 96,  0,  0,  0,
/* 0x1640 */ 121,124, 15,164, 85,119,  8, 60,127,159,200, 64,127, 44, 40, 64,
/* 0x1650 */ 126,235,187,120, 85, 64, 64, 46,127,156,194, 20, 65,157,  0, 28,
/* 0x1660 */  65,154,253,176,137, 76,  0,  0,123,255, 64, 40, 57,140,  0,  1,
/* 0x1670 */ 125, 74,  3,120,121, 74,  0, 32,127,211,226, 46, 87,224,170,254,
/* 0x1680 */  57,107,  0,  1,124,  0,241,214, 35,190,  8,  0, 87,219,217,126,
/* 0x1690 */ 127,189, 46,112,127,138,  0, 64,127,123,240, 80,127,221,242, 20,
/* 0x16a0 */ 120, 29,  0, 32, 64,156,  2, 76,126,235,  7,180,127,211,227, 46,
/* 0x16b0 */ 127,191,235,120, 66,  0,255,140, 57,107,255,192, 47,139,  0,  3,
/* 0x16c0 */ 125,126,  7,180, 64,157,  2, 76, 85,122,  7,254, 47,139,  0, 13,
/* 0x16d0 */  99, 90,  0,  2,125,107, 14,112,123, 64,  0, 32, 65,157,  5, 48,
/* 0x16e0 */  57,107,255,255, 34, 30,  2,176,127, 90, 88, 48,125,107,  7,180,
/* 0x16f0 */ 126, 16,210, 20,122, 16, 15,164, 58, 16,255,254,126, 19,130, 20,
/* 0x1700 */  57,107,255,255, 59,192,  0,  1,121,107,  0, 32, 59,128,  0,  1,
/* 0x1710 */  57,107,  0,  1,125,105,  3,166, 72,  0,  0, 32, 96,  0,  0,  0,
/* 0x1720 */ 176, 27,  0,  0,126,254,  7,180,127,191,235,120, 87,156,  8, 60,
/* 0x1730 */ 127,156,  7,180, 66, 64,  1,224,123,219, 15,164, 87,215,  8, 60,
/* 0x1740 */ 127,159,200, 64,127, 44, 40, 64,126,254,187,120, 85, 75, 64, 46,
/* 0x1750 */ 127,112,218, 20, 65,157,  0, 28, 65,154,252,184,137, 76,  0,  0,
/* 0x1760 */ 123,255, 64, 40, 57,140,  0,  1,125, 74, 91,120,121, 74,  0, 32,
/* 0x1770 */ 160, 27,  0,  0, 87,235,170,254,127,148,211,120,125,107,  1,214,
/* 0x1780 */  35,160,  8,  0, 84, 24,217,126,127,189, 46,112,127,138, 88, 64,
/* 0x1790 */ 127, 24,  0, 80,124, 29,  2, 20,121,125,  0, 32, 65,156,255,132,
/* 0x17a0 */ 127,235,248, 80,125, 75, 80, 80,179, 27,  0,  0, 59,222,  0,  1,
/* 0x17b0 */ 123,255,  0, 32,121, 74,  0, 32,127,222,  7,180,122,154,  0, 32,
/* 0x17c0 */  75,255,255,108, 96,  0,  0,  0, 96,  0,  0,  0, 96,  0,  0,  0,
/* 0x17d0 */ 127,224,208, 80, 87,124,217,126,127,124,216, 80,124,  0, 80, 80,
/* 0x17e0 */ 127,159,200, 64,123,250,  0, 32,127,115, 91, 46,120, 10,  0, 32,
/* 0x17f0 */  59,139,  0, 24, 65,157,  0, 36,127,172, 40, 64, 65,158,252, 20,
/* 0x1800 */ 137, 76,  0,  0, 84,  0, 64, 46,123,250, 64, 40, 57,140,  0,  1,
/* 0x1810 */ 125, 74,  3,120,121, 74,  0, 32,127,243,226, 46, 87, 64,170,254,
/* 0x1820 */ 124,  0,249,214,127,138,  0, 64,120, 27,  0, 32, 64,156,  2, 52,
/* 0x1830 */  33,127,  8,  0,127,128,200, 64,125,107, 46,112,127,235,250, 20,
/* 0x1840 */  59,222,  1,224,127,243,227, 46, 65,157,  0, 36,127,172, 40, 64,
/* 0x1850 */  65,158,251,192,137,108,  0,  0, 85, 74, 64, 46,120, 27, 64, 40,
/* 0x1860 */  57,140,  0,  1,125,106, 83,120,121, 74,  0, 32,124, 19,242, 46,
/* 0x1870 */  87,107,170,254,125,107,  1,214,127,138, 88, 64,121,127,  0, 32,
/* 0x1880 */  64,156,  3, 56, 33, 96,  8,  0, 47,182,  0,  0,125,107, 46,112,
/* 0x1890 */ 124, 11,  2, 20,124, 19,243, 46, 65,158,251,120, 47,149,  0,  7,
/* 0x18a0 */ 125,112,176, 80,126,176, 16, 38, 86,181,239,254,121,107,  0, 32,
/* 0x18b0 */  56, 22,  0,  1,126,181,  0,208,122,181,  7,164,125,103, 88,174,
/* 0x18c0 */ 125,103,177,174, 58,181,  0, 11,120, 22,  0, 32, 72,  0,  0,204,
/* 0x18d0 */ 127,235,248, 80,125, 75, 80, 80,179,124,  0,  0,123,255,  0, 32,
/* 0x18e0 */ 121, 74,  0, 32,124,  0,  7,180, 66,  0,252,152, 75,255,253, 12,
/* 0x18f0 */ 127,224,248, 80,125, 64, 80, 80,127,115,227, 46,123,255,  0, 32,
/* 0x1900 */ 121, 74,  0, 32,125,107,  7,180, 66,  0,253, 56, 75,255,253,172,
/* 0x1910 */ 121,122,  0, 32, 59, 90,  0,  1,123, 80,  0, 33, 65,130,  0,132,
/* 0x1920 */  58,181,  0,  7,126,181,  7,180,127,144,176, 64, 65,157,250,228,
/* 0x1930 */ 128,  1,255, 80, 59,182,  0,  1,127,208,176, 80,123,222,  0, 32,
/* 0x1940 */ 126,220,179,120,125,125,  2, 20,125,112, 88, 80,125,126, 88, 80,
/* 0x1950 */ 121,107,  0, 32, 57,107,  0,  1,125,105,  3,166, 72,  0,  0, 20,
/* 0x1960 */ 126,220,179,120,123,222,  0, 32, 64,157,  0, 56, 59,182,  0,  1,
/* 0x1970 */ 125,103,240,174,127,136,232, 64, 59,222,  0,  1,123,182,  0, 32,
/* 0x1980 */ 125,103,225,174, 66,  0,255,220,232,  1,255,104,249,193,255, 96,
/* 0x1990 */ 233,193,255, 88,248,  1,255, 88,127,136,176, 64, 65,253,248,  0,
/* 0x19a0 */  61, 64,  0,255, 97, 74,255,255,127,159, 80, 64, 65,157,  0, 16,
/* 0x19b0 */ 127,172, 40, 64, 65,158,250, 92, 57,140,  0,  1,124,132, 96, 80,
/* 0x19c0 */  56, 96,  0,  0,144,134,  0,  0,146,201,  0,  0, 75,255,250, 72,
/* 0x19d0 */ 127,139,224, 80, 84, 31,217,126,125,107, 80, 80,124, 31,  0, 80,
/* 0x19e0 */ 127,156,200, 64,123,158,  0, 32,176, 24,  0,  0,121,106,  0, 32,
/* 0x19f0 */  65,157,  0, 36,127,172, 40, 64, 65,158,250, 24,137, 76,  0,  0,
/* 0x1a00 */  85,107, 64, 46,123,158, 64, 40, 57,140,  0,  1,125, 74, 91,120,
/* 0x1a10 */ 121, 74,  0, 32,160, 24,  0,  2, 87,203,170,254,125,107,  1,214,
/* 0x1a20 */ 127,138, 88, 64,121,127,  0, 32, 64,156,  1, 72, 87,171, 24, 56,
/* 0x1a30 */  35,192,  8,  0,125,107,  7,180,127,222, 46,112, 57,107,  0,130,
/* 0x1a40 */ 124, 30,  2, 20,121,107, 15,164,176, 24,  0,  2, 58,128,  0,  8,
/* 0x1a50 */ 127, 24, 90, 20, 58,224,  0,  3, 75,255,251, 12, 96,  0,  0,  0,
/* 0x1a60 */ 127, 64,208, 80, 87,251,217,126,127,192, 80, 80,127,251,248, 80,
/* 0x1a70 */ 127,154,200, 64,127,243,227, 46,123, 64,  0, 32,123,202,  0, 32,
/* 0x1a80 */  59,235,  0, 48, 65,157,  0, 36,127,172, 40, 64, 65,158,249,132,
/* 0x1a90 */ 137, 76,  0,  0, 87,192, 64, 46, 57,140,  0,  1,125, 74,  3,120,
/* 0x1aa0 */ 123, 64, 64, 40,121, 74,  0, 32,127,115,250, 46, 84, 30,170,254,
/* 0x1ab0 */ 127,222,217,214,127,138,240, 64,123,220,  0, 32, 65,156,  1, 44,
/* 0x1ac0 */ 124, 30,  0, 80, 87,124,217,126,127,222, 80, 80,127,156,216, 80,
/* 0x1ad0 */ 127,128,200, 64,120, 26,  0, 32,127,147,251, 46,123,202,  0, 32,
/* 0x1ae0 */  57,107,  0, 72, 65,157,  0, 36,127,172, 40, 64, 65,158,249, 36,
/* 0x1af0 */ 137, 76,  0,  0, 87,222, 64, 46,120, 26, 64, 40, 57,140,  0,  1,
/* 0x1b00 */ 125, 74,243,120,121, 74,  0, 32,127,243, 90, 46, 87, 64,170,254,
/* 0x1b10 */ 124,  0,249,214,127,138,  0, 64,120, 28,  0, 32, 64,156,  1,104,
/* 0x1b20 */  32, 31,  8,  0,250,  1,255,104,125,208,115,120,233,193,255, 96,
/* 0x1b30 */ 124,  0, 46,112,127,224,250, 20,127,243, 91, 46, 96,  0,  0,  0,
/* 0x1b40 */  47,149,  0,  7, 59,  3, 10,108,126,176, 16, 38, 86,181,239,254,
/* 0x1b50 */ 126,181,  0,208,122,181,240, 66,122,181, 16,  0, 58,181,  0, 11,
/* 0x1b60 */  75,255,249,152, 96,  0,  0,  0, 96,  0,  0,  0, 96,  0,  0,  0,
/* 0x1b70 */  84, 31,217,126,124, 31,  0, 80,125, 75, 80, 80,127,235,240, 80,
/* 0x1b80 */ 176, 24,  0,  2,121, 74,  0, 32, 59, 24,  2,  4,123,255,  0, 32,
/* 0x1b90 */  58,128,  0, 16, 58,224,  0,  8, 75,255,249,204, 96,  0,  0,  0,
/* 0x1ba0 */  58,181,255,250,126,181,  7,180, 75,255,253,240, 96,  0,  0,  0,
/* 0x1bb0 */  57, 96,  0,  3, 75,255,250,108, 84, 31,217,126,127,139,216, 80,
/* 0x1bc0 */ 125, 75, 80, 80,233, 97,255, 88,249,193,255, 88,124, 31,  0, 80,
/* 0x1bd0 */ 249, 97,255,104,123,156,  0, 32,233,193,255, 96,121, 74,  0, 32,
/* 0x1be0 */ 124, 19,243, 46, 75,255,255, 92, 33,123,  8,  0,250,  1,255,104,
/* 0x1bf0 */ 234,  1,255, 88,125,107, 46,112,127,107,218, 20,249,193,255, 88,
/* 0x1c00 */ 233,193,255, 96,127,115,251, 46, 75,255,255, 56, 57,107,255,250,
/* 0x1c10 */ 121,107,  0, 32, 57,107,  0,  1,125,105,  3,166, 96,  0,  0,  0,
/* 0x1c20 */ 127,159,200, 64, 84, 26,  8, 60,127, 44, 40, 64, 85, 75, 64, 46,
/* 0x1c30 */  65,157,  0, 28, 65,154,247,220,137, 76,  0,  0,123,255, 64, 40,
/* 0x1c40 */  57,140,  0,  1,125, 74, 91,120,121, 74,  0, 32, 87,235,248,126,
/* 0x1c50 */ 127,138, 88, 64,123, 64,  0, 32,121,127,  0, 32, 65,156,  0, 20,
/* 0x1c60 */ 125, 75, 80, 80, 99, 90,  0,  1,121, 74,  0, 32,123, 64,  0, 32,
/* 0x1c70 */  66,  0,255,176, 58,  3,  6, 72,120, 26, 32, 40, 57, 96,  0,  4,
/* 0x1c80 */  75,255,250,128, 87,254,217,126,127,254,248, 80,127,128,208, 80,
/* 0x1c90 */ 250,  1,255,104,234,  1,255, 96,125, 64, 80, 80,127,243, 91, 46,
/* 0x1ca0 */ 123,156,  0, 32,121, 74,  0, 32, 75,255,254,152, 58,192,  0,  0,
/* 0x1cb0 */  75,255,253, 12,  0,  0,  0,  0,  0,  0,  0,  0,232,230,  0,  0,
/* 0x1cc0 */ 125,168,  3,166,124,100, 24, 80,124,135, 40, 80, 56, 99,  0,  1,
/* 0x1cd0 */  56,132,  0,  1,248,134,  0,  0, 96,231,  0, 31,124,  0, 56,108,
/* 0x1ce0 */ 124, 39, 40, 64,124,  0, 63,172, 56,231,  0, 32, 65,128,255,240,
/* 0x1cf0 */ 124,  0,  4,172, 76,  0,  1, 44, 78,128,  0, 32,125,104,  2,166,
/* 0x1d00 */ 128,139,  0, 12,124,137,  3,166,128,203,  0,  8,136,235,  0, 16,
/* 0x1d10 */ 124,164, 90, 20, 56,165,  0, 20,124,102, 90, 20, 56, 99,  0,192,
/* 0x1d20 */ 140,  5,255,255,156,  3,255,255, 67, 32,255,248,127,233,  3,166,
/* 0x1d30 */  56,171,  0,128,248,193,255,248, 56,193,255,248,248, 33,255,113,
/* 0x1d40 */  78,128,  4, 32,127,232,  2,166, 75,255,255,181, 72,  0,  0,128,
/* 0x1d50 */   0,  0,  0,  0,102,105,108,101, 32,102,111,114,109, 97,116, 32,
/* 0x1d60 */ 101,108,102, 54, 52, 45,112,111,119,101,114,112, 99, 10, 10, 83,
/* 0x1d70 */ 101, 99,116,105,111,110,115, 58, 10, 73,100,120, 32, 78, 97,109,
/* 0x1d80 */ 101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,101, 32,
/* 0x1d90 */  32, 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1da0 */  32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32,
/* 0x1db0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 70,105,108,101, 32,111,102,
/* 0x1dc0 */ 102, 32, 32, 65,108,103,110, 32, 32, 70,108, 97,103,115, 10, 32,
/* 0x1dd0 */  32, 48, 32, 77, 65, 67, 79, 83, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x1de0 */  32, 48, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 52, 48, 32, 32,
/* 0x1df0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x1e00 */  32, 49, 32, 78, 82, 86, 95, 72, 69, 65, 68, 32, 32, 32, 32, 32,
/* 0x1e10 */  32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 52, 52, 32, 32, 50,
/* 0x1e20 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32,
/* 0x1e30 */  50, 32, 78, 82, 86, 50, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1e40 */  48, 49, 53, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 52, 52, 32,
/* 0x1e50 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x1e60 */  32, 32, 51, 32, 78, 82, 86, 50, 68, 32, 32, 32, 32, 32, 32, 32,
/* 0x1e70 */  32, 32, 48, 49, 51, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x1e80 */  57, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1e90 */  84, 83, 10, 32, 32, 52, 32, 78, 82, 86, 50, 66, 32, 32, 32, 32,
/* 0x1ea0 */  32, 32, 32, 32, 32, 48,102, 56, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x1eb0 */  48, 50,100, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1ec0 */  69, 78, 84, 83, 10, 32, 32, 53, 32, 76, 90, 77, 65, 95, 69, 76,
/* 0x1ed0 */  70, 48, 48, 32, 32, 32, 32, 48, 57, 52, 32, 32, 48, 32, 32, 48,
/* 0x1ee0 */  32, 32, 48, 51, 99, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1ef0 */  78, 84, 69, 78, 84, 83, 10, 32, 32, 54, 32, 76, 90, 77, 65, 95,
/* 0x1f00 */  68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 50, 56, 32, 32, 48, 32,
/* 0x1f10 */  32, 48, 32, 32, 48, 52, 54, 48, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1f20 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 55, 32, 76, 90, 77,
/* 0x1f30 */  65, 95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 98, 99, 48, 32,
/* 0x1f40 */  32, 48, 32, 32, 48, 32, 32, 48, 52, 56, 56, 32, 32, 50, 42, 42,
/* 0x1f50 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 56, 32,
/* 0x1f60 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 32, 32, 32, 48, 99,
/* 0x1f70 */  55, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 48, 52, 56, 32,
/* 0x1f80 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x1f90 */  32, 32, 57, 32, 78, 82, 86, 95, 84, 65, 73, 76, 32, 32, 32, 32,
/* 0x1fa0 */  32, 32, 48, 49, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 99,
/* 0x1fb0 */  98, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1fc0 */  84, 83, 10, 32, 49, 48, 32, 67, 70, 76, 85, 83, 72, 32, 32, 32,
/* 0x1fd0 */  32, 32, 32, 32, 32, 48, 50, 52, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x1fe0 */  48, 49, 99,100, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1ff0 */  84, 69, 78, 84, 83, 10, 32, 49, 49, 32, 69, 76, 70, 77, 65, 73,
/* 0x2000 */  78, 89, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32,
/* 0x2010 */  32, 48, 49, 99,102, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2020 */  78, 84, 69, 78, 84, 83, 10, 32, 49, 50, 32, 69, 76, 70, 77, 65,
/* 0x2030 */  73, 78, 90, 32, 32, 32, 32, 32, 32, 48, 53, 56, 32, 32, 48, 32,
/* 0x2040 */  32, 48, 32, 32, 48, 49, 99,102, 99, 32, 32, 50, 42, 42, 48, 32,
/* 0x2050 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 83, 89, 77, 66, 79, 76,
/* 0x2060 */  32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2070 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x2080 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 48, 32, 76, 90,
/* 0x2090 */  77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x20a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x20b0 */  32, 32, 78, 82, 86, 95, 84, 65, 73, 76, 32, 48, 32, 78, 82, 86,
/* 0x20c0 */  95, 84, 65, 73, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x20d0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69,
/* 0x20e0 */  76, 70, 77, 65, 73, 78, 90, 32, 48, 32, 69, 76, 70, 77, 65, 73,
/* 0x20f0 */  78, 90, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2100 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 65, 67, 79,
/* 0x2110 */  83, 48, 48, 48, 32, 48, 32, 77, 65, 67, 79, 83, 48, 48, 48, 10,
/* 0x2120 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2130 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 95, 72, 69, 65,
/* 0x2140 */  68, 32, 48, 32, 78, 82, 86, 95, 72, 69, 65, 68, 10, 48, 48, 48,
/* 0x2150 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x2160 */  32, 32, 32,100, 32, 32, 78, 82, 86, 50, 69, 32, 48, 32, 78, 82,
/* 0x2170 */  86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2180 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86,
/* 0x2190 */  50, 68, 32, 48, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48,
/* 0x21a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x21b0 */  32,100, 32, 32, 78, 82, 86, 50, 66, 32, 48, 32, 78, 82, 86, 50,
/* 0x21c0 */  66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x21d0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95,
/* 0x21e0 */  69, 76, 70, 48, 48, 32, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70,
/* 0x21f0 */  48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2200 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65,
/* 0x2210 */  95, 68, 69, 67, 49, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2220 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2230 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77,
/* 0x2240 */  65, 95, 68, 69, 67, 50, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68,
/* 0x2250 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2260 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 70,
/* 0x2270 */  76, 85, 83, 72, 32, 48, 32, 67, 70, 76, 85, 83, 72, 10, 48, 48,
/* 0x2280 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x2290 */  32, 32, 32, 32,100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 89, 32,
/* 0x22a0 */  48, 32, 69, 76, 70, 77, 65, 73, 78, 89, 10, 48, 48, 48, 48, 48,
/* 0x22b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32,
/* 0x22c0 */  32, 32, 32, 32, 77, 65, 67, 79, 83, 48, 48, 48, 32, 48, 32, 95,
/* 0x22d0 */ 115,116, 97,114,116, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x22e0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 77,
/* 0x22f0 */  65, 67, 79, 83, 48, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x2300 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x2310 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x2320 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2330 */  48, 48, 48, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50,
/* 0x2340 */  52, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 43, 48,
/* 0x2350 */ 120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x2360 */  56, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x2370 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 69,
/* 0x2380 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32,
/* 0x2390 */  32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x23a0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x23b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 99, 48, 32, 82, 95, 80,
/* 0x23c0 */  80, 67, 54, 52, 95, 82, 69, 76, 49, 52, 32, 32, 32, 32, 32, 78,
/* 0x23d0 */  82, 86, 95, 84, 65, 73, 76, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x23e0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x23f0 */  91, 78, 82, 86, 50, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x2400 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x2410 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x2420 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2430 */  99, 52, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 49, 52,
/* 0x2440 */  32, 32, 32, 32, 32, 78, 82, 86, 95, 84, 65, 73, 76, 10, 10, 82,
/* 0x2450 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x2460 */  83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 66, 93, 58, 10, 79,
/* 0x2470 */  70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2480 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2490 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x24a0 */  48, 48, 48, 48, 48, 48, 57, 56, 32, 82, 95, 80, 80, 67, 54, 52,
/* 0x24b0 */  95, 82, 69, 76, 49, 52, 32, 32, 32, 32, 32, 78, 82, 86, 95, 84,
/* 0x24c0 */  65, 73, 76, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x24d0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77,
/* 0x24e0 */  65, 95, 69, 76, 70, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x24f0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x2500 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x2510 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2520 */  48, 48, 52, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 49,
/* 0x2530 */  52, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,
/* 0x2540 */  43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2550 */  48, 50, 56, 10
};
