/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLTextAreaElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLFormElementPrivate.h"
#include "WebKitDOMHTMLTextAreaElementPrivate.h"
#include "WebKitDOMNodeListPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMValidityStatePrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLTextAreaElement* kit(WebCore::HTMLTextAreaElement* obj)
{
    return WEBKIT_DOM_HTML_TEXT_AREA_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLTextAreaElement* core(WebKitDOMHTMLTextAreaElement* request)
{
    return request ? static_cast<WebCore::HTMLTextAreaElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLTextAreaElement* wrapHTMLTextAreaElement(WebCore::HTMLTextAreaElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_TEXT_AREA_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_TEXT_AREA_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLTextAreaElement, webkit_dom_html_text_area_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_AUTOFOCUS,
    PROP_COLS,
    PROP_DIR_NAME,
    PROP_DISABLED,
    PROP_FORM,
    PROP_MAX_LENGTH,
    PROP_NAME,
    PROP_PLACEHOLDER,
    PROP_READ_ONLY,
    PROP_REQUIRED,
    PROP_ROWS,
    PROP_WRAP,
    PROP_TYPE,
    PROP_DEFAULT_VALUE,
    PROP_VALUE,
    PROP_TEXT_LENGTH,
    PROP_WILL_VALIDATE,
    PROP_VALIDITY,
    PROP_VALIDATION_MESSAGE,
    PROP_LABELS,
    PROP_SELECTION_START,
    PROP_SELECTION_END,
    PROP_SELECTION_DIRECTION,
};

static void webkit_dom_html_text_area_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLTextAreaElement* self = WEBKIT_DOM_HTML_TEXT_AREA_ELEMENT(object);
    WebCore::HTMLTextAreaElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_AUTOFOCUS: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::autofocusAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_COLS: {
        coreSelf->setCols((g_value_get_long(value)));
        break;
    }
    case PROP_DIR_NAME: {
        coreSelf->setAttribute(WebCore::HTMLNames::dirnameAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_DISABLED: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::disabledAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_MAX_LENGTH: {
        WebCore::ExceptionCode ec = 0;
        coreSelf->setMaxLength((g_value_get_long(value)), ec);
        break;
    }
    case PROP_NAME: {
        coreSelf->setAttribute(WebCore::HTMLNames::nameAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_PLACEHOLDER: {
        coreSelf->setAttribute(WebCore::HTMLNames::placeholderAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_READ_ONLY: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::readonlyAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_REQUIRED: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::requiredAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_ROWS: {
        coreSelf->setRows((g_value_get_long(value)));
        break;
    }
    case PROP_WRAP: {
        coreSelf->setAttribute(WebCore::HTMLNames::wrapAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_DEFAULT_VALUE: {
        coreSelf->setDefaultValue(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_VALUE: {
        coreSelf->setValue(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_SELECTION_START: {
        coreSelf->setSelectionStart((g_value_get_long(value)));
        break;
    }
    case PROP_SELECTION_END: {
        coreSelf->setSelectionEnd((g_value_get_long(value)));
        break;
    }
    case PROP_SELECTION_DIRECTION: {
        coreSelf->setSelectionDirection(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_text_area_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLTextAreaElement* self = WEBKIT_DOM_HTML_TEXT_AREA_ELEMENT(object);
    WebCore::HTMLTextAreaElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_AUTOFOCUS: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::autofocusAttr));
        break;
    }
    case PROP_COLS: {
        g_value_set_long(value, coreSelf->cols());
        break;
    }
    case PROP_DIR_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::dirnameAttr)));
        break;
    }
    case PROP_DISABLED: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::disabledAttr));
        break;
    }
    case PROP_FORM: {
        RefPtr<WebCore::HTMLFormElement> ptr = coreSelf->form();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_MAX_LENGTH: {
        g_value_set_long(value, coreSelf->maxLength());
        break;
    }
    case PROP_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getNameAttribute()));
        break;
    }
    case PROP_PLACEHOLDER: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::placeholderAttr)));
        break;
    }
    case PROP_READ_ONLY: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::readonlyAttr));
        break;
    }
    case PROP_REQUIRED: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::requiredAttr));
        break;
    }
    case PROP_ROWS: {
        g_value_set_long(value, coreSelf->rows());
        break;
    }
    case PROP_WRAP: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::wrapAttr)));
        break;
    }
    case PROP_TYPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->type()));
        break;
    }
    case PROP_DEFAULT_VALUE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->defaultValue()));
        break;
    }
    case PROP_VALUE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->value()));
        break;
    }
    case PROP_TEXT_LENGTH: {
        g_value_set_ulong(value, coreSelf->textLength());
        break;
    }
    case PROP_WILL_VALIDATE: {
        g_value_set_boolean(value, coreSelf->willValidate());
        break;
    }
    case PROP_VALIDITY: {
        RefPtr<WebCore::ValidityState> ptr = coreSelf->validity();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_VALIDATION_MESSAGE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->validationMessage()));
        break;
    }
    case PROP_LABELS: {
        RefPtr<WebCore::NodeList> ptr = coreSelf->labels();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_SELECTION_START: {
        g_value_set_long(value, coreSelf->selectionStart());
        break;
    }
    case PROP_SELECTION_END: {
        g_value_set_long(value, coreSelf->selectionEnd());
        break;
    }
    case PROP_SELECTION_DIRECTION: {
        g_value_take_string(value, convertToUTF8String(coreSelf->selectionDirection()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_text_area_element_class_init(WebKitDOMHTMLTextAreaElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_text_area_element_set_property;
    gobjectClass->get_property = webkit_dom_html_text_area_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_AUTOFOCUS,
                                    g_param_spec_boolean("autofocus", /* name */
                                                           "html_text_area_element_autofocus", /* short description */
                                                           "read-write  gboolean HTMLTextAreaElement.autofocus", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_COLS,
                                    g_param_spec_long("cols", /* name */
                                                           "html_text_area_element_cols", /* short description */
                                                           "read-write  glong HTMLTextAreaElement.cols", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DIR_NAME,
                                    g_param_spec_string("dir-name", /* name */
                                                           "html_text_area_element_dir-name", /* short description */
                                                           "read-write  gchar* HTMLTextAreaElement.dir-name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DISABLED,
                                    g_param_spec_boolean("disabled", /* name */
                                                           "html_text_area_element_disabled", /* short description */
                                                           "read-write  gboolean HTMLTextAreaElement.disabled", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FORM,
                                    g_param_spec_object("form", /* name */
                                                           "html_text_area_element_form", /* short description */
                                                           "read-only  WebKitDOMHTMLFormElement* HTMLTextAreaElement.form", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_FORM_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_MAX_LENGTH,
                                    g_param_spec_long("max-length", /* name */
                                                           "html_text_area_element_max-length", /* short description */
                                                           "read-write  glong HTMLTextAreaElement.max-length", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NAME,
                                    g_param_spec_string("name", /* name */
                                                           "html_text_area_element_name", /* short description */
                                                           "read-write  gchar* HTMLTextAreaElement.name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PLACEHOLDER,
                                    g_param_spec_string("placeholder", /* name */
                                                           "html_text_area_element_placeholder", /* short description */
                                                           "read-write  gchar* HTMLTextAreaElement.placeholder", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_READ_ONLY,
                                    g_param_spec_boolean("read-only", /* name */
                                                           "html_text_area_element_read-only", /* short description */
                                                           "read-write  gboolean HTMLTextAreaElement.read-only", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_REQUIRED,
                                    g_param_spec_boolean("required", /* name */
                                                           "html_text_area_element_required", /* short description */
                                                           "read-write  gboolean HTMLTextAreaElement.required", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ROWS,
                                    g_param_spec_long("rows", /* name */
                                                           "html_text_area_element_rows", /* short description */
                                                           "read-write  glong HTMLTextAreaElement.rows", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WRAP,
                                    g_param_spec_string("wrap", /* name */
                                                           "html_text_area_element_wrap", /* short description */
                                                           "read-write  gchar* HTMLTextAreaElement.wrap", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TYPE,
                                    g_param_spec_string("type", /* name */
                                                           "html_text_area_element_type", /* short description */
                                                           "read-only  gchar* HTMLTextAreaElement.type", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DEFAULT_VALUE,
                                    g_param_spec_string("default-value", /* name */
                                                           "html_text_area_element_default-value", /* short description */
                                                           "read-write  gchar* HTMLTextAreaElement.default-value", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VALUE,
                                    g_param_spec_string("value", /* name */
                                                           "html_text_area_element_value", /* short description */
                                                           "read-write  gchar* HTMLTextAreaElement.value", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TEXT_LENGTH,
                                    g_param_spec_ulong("text-length", /* name */
                                                           "html_text_area_element_text-length", /* short description */
                                                           "read-only  gulong HTMLTextAreaElement.text-length", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WILL_VALIDATE,
                                    g_param_spec_boolean("will-validate", /* name */
                                                           "html_text_area_element_will-validate", /* short description */
                                                           "read-only  gboolean HTMLTextAreaElement.will-validate", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VALIDITY,
                                    g_param_spec_object("validity", /* name */
                                                           "html_text_area_element_validity", /* short description */
                                                           "read-only  WebKitDOMValidityState* HTMLTextAreaElement.validity", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_VALIDITY_STATE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VALIDATION_MESSAGE,
                                    g_param_spec_string("validation-message", /* name */
                                                           "html_text_area_element_validation-message", /* short description */
                                                           "read-only  gchar* HTMLTextAreaElement.validation-message", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LABELS,
                                    g_param_spec_object("labels", /* name */
                                                           "html_text_area_element_labels", /* short description */
                                                           "read-only  WebKitDOMNodeList* HTMLTextAreaElement.labels", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NODE_LIST, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SELECTION_START,
                                    g_param_spec_long("selection-start", /* name */
                                                           "html_text_area_element_selection-start", /* short description */
                                                           "read-write  glong HTMLTextAreaElement.selection-start", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SELECTION_END,
                                    g_param_spec_long("selection-end", /* name */
                                                           "html_text_area_element_selection-end", /* short description */
                                                           "read-write  glong HTMLTextAreaElement.selection-end", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SELECTION_DIRECTION,
                                    g_param_spec_string("selection-direction", /* name */
                                                           "html_text_area_element_selection-direction", /* short description */
                                                           "read-write  gchar* HTMLTextAreaElement.selection-direction", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_html_text_area_element_init(WebKitDOMHTMLTextAreaElement* request)
{
}

gboolean
webkit_dom_html_text_area_element_check_validity(WebKitDOMHTMLTextAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self), FALSE);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    gboolean result = item->checkValidity();
    return result;
}

void
webkit_dom_html_text_area_element_set_custom_validity(WebKitDOMHTMLTextAreaElement* self, const gchar* error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self));
    g_return_if_fail(error);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    WTF::String convertedError = WTF::String::fromUTF8(error);
    item->setCustomValidity(convertedError);
}

void
webkit_dom_html_text_area_element_select(WebKitDOMHTMLTextAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self));
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    item->select();
}

void
webkit_dom_html_text_area_element_set_range_text(WebKitDOMHTMLTextAreaElement* self, const gchar* replacement, gulong start, gulong end, const gchar* selectionMode, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self));
    g_return_if_fail(replacement);
    g_return_if_fail(selectionMode);
    g_return_if_fail(!error || !*error);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    WTF::String convertedReplacement = WTF::String::fromUTF8(replacement);
    WTF::String convertedSelectionMode = WTF::String::fromUTF8(selectionMode);
    WebCore::ExceptionCode ec = 0;
    item->setRangeText(convertedReplacement, start, end, convertedSelectionMode, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_html_text_area_element_set_selection_range(WebKitDOMHTMLTextAreaElement* self, glong start, glong end, const gchar* direction)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self));
    g_return_if_fail(direction);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    WTF::String convertedDirection = WTF::String::fromUTF8(direction);
    item->setSelectionRange(start, end, convertedDirection);
}

gboolean
webkit_dom_html_text_area_element_get_autofocus(WebKitDOMHTMLTextAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self), FALSE);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::autofocusAttr);
    return result;
}

void
webkit_dom_html_text_area_element_set_autofocus(WebKitDOMHTMLTextAreaElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self));
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::autofocusAttr, value);
}

glong
webkit_dom_html_text_area_element_get_cols(WebKitDOMHTMLTextAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self), 0);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    glong result = item->cols();
    return result;
}

void
webkit_dom_html_text_area_element_set_cols(WebKitDOMHTMLTextAreaElement* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self));
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    item->setCols(value);
}

gchar*
webkit_dom_html_text_area_element_get_dir_name(WebKitDOMHTMLTextAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self), 0);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::dirnameAttr));
    return result;
}

void
webkit_dom_html_text_area_element_set_dir_name(WebKitDOMHTMLTextAreaElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::dirnameAttr, convertedValue);
}

gboolean
webkit_dom_html_text_area_element_get_disabled(WebKitDOMHTMLTextAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self), FALSE);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::disabledAttr);
    return result;
}

void
webkit_dom_html_text_area_element_set_disabled(WebKitDOMHTMLTextAreaElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self));
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::disabledAttr, value);
}

WebKitDOMHTMLFormElement*
webkit_dom_html_text_area_element_get_form(WebKitDOMHTMLTextAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self), 0);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    RefPtr<WebCore::HTMLFormElement> gobjectResult = WTF::getPtr(item->form());
    return WebKit::kit(gobjectResult.get());
}

glong
webkit_dom_html_text_area_element_get_max_length(WebKitDOMHTMLTextAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self), 0);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    glong result = item->maxLength();
    return result;
}

void
webkit_dom_html_text_area_element_set_max_length(WebKitDOMHTMLTextAreaElement* self, glong value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self));
    g_return_if_fail(!error || !*error);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->setMaxLength(value, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

gchar*
webkit_dom_html_text_area_element_get_name(WebKitDOMHTMLTextAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self), 0);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getNameAttribute());
    return result;
}

void
webkit_dom_html_text_area_element_set_name(WebKitDOMHTMLTextAreaElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::nameAttr, convertedValue);
}

gchar*
webkit_dom_html_text_area_element_get_placeholder(WebKitDOMHTMLTextAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self), 0);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::placeholderAttr));
    return result;
}

void
webkit_dom_html_text_area_element_set_placeholder(WebKitDOMHTMLTextAreaElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::placeholderAttr, convertedValue);
}

gboolean
webkit_dom_html_text_area_element_get_read_only(WebKitDOMHTMLTextAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self), FALSE);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::readonlyAttr);
    return result;
}

void
webkit_dom_html_text_area_element_set_read_only(WebKitDOMHTMLTextAreaElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self));
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::readonlyAttr, value);
}

gboolean
webkit_dom_html_text_area_element_get_required(WebKitDOMHTMLTextAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self), FALSE);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::requiredAttr);
    return result;
}

void
webkit_dom_html_text_area_element_set_required(WebKitDOMHTMLTextAreaElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self));
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::requiredAttr, value);
}

glong
webkit_dom_html_text_area_element_get_rows(WebKitDOMHTMLTextAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self), 0);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    glong result = item->rows();
    return result;
}

void
webkit_dom_html_text_area_element_set_rows(WebKitDOMHTMLTextAreaElement* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self));
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    item->setRows(value);
}

gchar*
webkit_dom_html_text_area_element_get_wrap(WebKitDOMHTMLTextAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self), 0);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::wrapAttr));
    return result;
}

void
webkit_dom_html_text_area_element_set_wrap(WebKitDOMHTMLTextAreaElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::wrapAttr, convertedValue);
}

gchar*
webkit_dom_html_text_area_element_get_default_value(WebKitDOMHTMLTextAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self), 0);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->defaultValue());
    return result;
}

void
webkit_dom_html_text_area_element_set_default_value(WebKitDOMHTMLTextAreaElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setDefaultValue(convertedValue);
}

gchar*
webkit_dom_html_text_area_element_get_value(WebKitDOMHTMLTextAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self), 0);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->value());
    return result;
}

void
webkit_dom_html_text_area_element_set_value(WebKitDOMHTMLTextAreaElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setValue(convertedValue);
}

gulong
webkit_dom_html_text_area_element_get_text_length(WebKitDOMHTMLTextAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self), 0);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    gulong result = item->textLength();
    return result;
}

gboolean
webkit_dom_html_text_area_element_get_will_validate(WebKitDOMHTMLTextAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self), FALSE);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    gboolean result = item->willValidate();
    return result;
}

WebKitDOMValidityState*
webkit_dom_html_text_area_element_get_validity(WebKitDOMHTMLTextAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self), 0);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    RefPtr<WebCore::ValidityState> gobjectResult = WTF::getPtr(item->validity());
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_html_text_area_element_get_validation_message(WebKitDOMHTMLTextAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self), 0);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->validationMessage());
    return result;
}

WebKitDOMNodeList*
webkit_dom_html_text_area_element_get_labels(WebKitDOMHTMLTextAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self), 0);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    RefPtr<WebCore::NodeList> gobjectResult = WTF::getPtr(item->labels());
    return WebKit::kit(gobjectResult.get());
}

glong
webkit_dom_html_text_area_element_get_selection_start(WebKitDOMHTMLTextAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self), 0);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    glong result = item->selectionStart();
    return result;
}

void
webkit_dom_html_text_area_element_set_selection_start(WebKitDOMHTMLTextAreaElement* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self));
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    item->setSelectionStart(value);
}

glong
webkit_dom_html_text_area_element_get_selection_end(WebKitDOMHTMLTextAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self), 0);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    glong result = item->selectionEnd();
    return result;
}

void
webkit_dom_html_text_area_element_set_selection_end(WebKitDOMHTMLTextAreaElement* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self));
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    item->setSelectionEnd(value);
}

gchar*
webkit_dom_html_text_area_element_get_selection_direction(WebKitDOMHTMLTextAreaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self), 0);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->selectionDirection());
    return result;
}

void
webkit_dom_html_text_area_element_set_selection_direction(WebKitDOMHTMLTextAreaElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TEXT_AREA_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTextAreaElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setSelectionDirection(convertedValue);
}

