/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMDocument.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMAttrPrivate.h"
#include "WebKitDOMCDATASectionPrivate.h"
#include "WebKitDOMCSSStyleDeclarationPrivate.h"
#include "WebKitDOMCommentPrivate.h"
#include "WebKitDOMDOMImplementationPrivate.h"
#include "WebKitDOMDOMNamedFlowCollectionPrivate.h"
#include "WebKitDOMDOMSecurityPolicyPrivate.h"
#include "WebKitDOMDOMWindowPrivate.h"
#include "WebKitDOMDocumentFragmentPrivate.h"
#include "WebKitDOMDocumentPrivate.h"
#include "WebKitDOMDocumentTypePrivate.h"
#include "WebKitDOMElementPrivate.h"
#include "WebKitDOMEntityReferencePrivate.h"
#include "WebKitDOMEventPrivate.h"
#include "WebKitDOMHTMLCollectionPrivate.h"
#include "WebKitDOMHTMLElementPrivate.h"
#include "WebKitDOMHTMLHeadElementPrivate.h"
#include "WebKitDOMNodeFilterPrivate.h"
#include "WebKitDOMNodeIteratorPrivate.h"
#include "WebKitDOMNodeListPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMProcessingInstructionPrivate.h"
#include "WebKitDOMRangePrivate.h"
#include "WebKitDOMStyleSheetListPrivate.h"
#include "WebKitDOMTextPrivate.h"
#include "WebKitDOMTreeWalkerPrivate.h"
#include "WebKitDOMXPathExpressionPrivate.h"
#include "WebKitDOMXPathNSResolverPrivate.h"
#include "WebKitDOMXPathResultPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMDocument* kit(WebCore::Document* obj)
{
    return WEBKIT_DOM_DOCUMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::Document* core(WebKitDOMDocument* request)
{
    return request ? static_cast<WebCore::Document*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMDocument* wrapDocument(WebCore::Document* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_DOCUMENT(g_object_new(WEBKIT_TYPE_DOM_DOCUMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMDocument, webkit_dom_document, WEBKIT_TYPE_DOM_NODE)

enum {
    PROP_0,
    PROP_DOCTYPE,
    PROP_IMPLEMENTATION,
    PROP_DOCUMENT_ELEMENT,
    PROP_INPUT_ENCODING,
    PROP_XML_ENCODING,
    PROP_XML_VERSION,
    PROP_XML_STANDALONE,
    PROP_DOCUMENT_URI,
    PROP_DEFAULT_VIEW,
    PROP_STYLE_SHEETS,
    PROP_TITLE,
    PROP_REFERRER,
    PROP_DOMAIN,
    PROP_URL,
    PROP_COOKIE,
    PROP_BODY,
    PROP_HEAD,
    PROP_IMAGES,
    PROP_APPLETS,
    PROP_LINKS,
    PROP_FORMS,
    PROP_ANCHORS,
    PROP_LAST_MODIFIED,
    PROP_CHARSET,
    PROP_DEFAULT_CHARSET,
    PROP_READY_STATE,
    PROP_CHARACTER_SET,
    PROP_PREFERRED_STYLESHEET_SET,
    PROP_SELECTED_STYLESHEET_SET,
    PROP_COMPAT_MODE,
    PROP_WEBKIT_IS_FULL_SCREEN,
    PROP_WEBKIT_FULL_SCREEN_KEYBOARD_INPUT_ALLOWED,
    PROP_WEBKIT_CURRENT_FULL_SCREEN_ELEMENT,
    PROP_WEBKIT_FULLSCREEN_ENABLED,
    PROP_WEBKIT_FULLSCREEN_ELEMENT,
    PROP_WEBKIT_POINTER_LOCK_ELEMENT,
    PROP_WEBKIT_VISIBILITY_STATE,
    PROP_WEBKIT_HIDDEN,
    PROP_SECURITY_POLICY,
};

static void webkit_dom_document_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMDocument* self = WEBKIT_DOM_DOCUMENT(object);
    WebCore::Document* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_XML_VERSION: {
        WebCore::ExceptionCode ec = 0;
        coreSelf->setXMLVersion(WTF::String::fromUTF8(g_value_get_string(value)), ec);
        break;
    }
    case PROP_XML_STANDALONE: {
        WebCore::ExceptionCode ec = 0;
        coreSelf->setXMLStandalone((g_value_get_boolean(value)), ec);
        break;
    }
    case PROP_DOCUMENT_URI: {
        coreSelf->setDocumentURI(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_TITLE: {
        coreSelf->setTitle(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_COOKIE: {
        WebCore::ExceptionCode ec = 0;
        coreSelf->setCookie(WTF::String::fromUTF8(g_value_get_string(value)), ec);
        break;
    }
    case PROP_CHARSET: {
        coreSelf->setCharset(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_SELECTED_STYLESHEET_SET: {
        coreSelf->setSelectedStylesheetSet(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_document_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMDocument* self = WEBKIT_DOM_DOCUMENT(object);
    WebCore::Document* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_DOCTYPE: {
        RefPtr<WebCore::DocumentType> ptr = coreSelf->doctype();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_IMPLEMENTATION: {
        RefPtr<WebCore::DOMImplementation> ptr = coreSelf->implementation();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_DOCUMENT_ELEMENT: {
        RefPtr<WebCore::Element> ptr = coreSelf->documentElement();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_INPUT_ENCODING: {
        g_value_take_string(value, convertToUTF8String(coreSelf->inputEncoding()));
        break;
    }
    case PROP_XML_ENCODING: {
        g_value_take_string(value, convertToUTF8String(coreSelf->xmlEncoding()));
        break;
    }
    case PROP_XML_VERSION: {
        g_value_take_string(value, convertToUTF8String(coreSelf->xmlVersion()));
        break;
    }
    case PROP_XML_STANDALONE: {
        g_value_set_boolean(value, coreSelf->xmlStandalone());
        break;
    }
    case PROP_DOCUMENT_URI: {
        g_value_take_string(value, convertToUTF8String(coreSelf->documentURI()));
        break;
    }
    case PROP_DEFAULT_VIEW: {
        RefPtr<WebCore::DOMWindow> ptr = coreSelf->defaultView();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_STYLE_SHEETS: {
        RefPtr<WebCore::StyleSheetList> ptr = coreSelf->styleSheets();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_TITLE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->title()));
        break;
    }
    case PROP_REFERRER: {
        g_value_take_string(value, convertToUTF8String(coreSelf->referrer()));
        break;
    }
    case PROP_DOMAIN: {
        g_value_take_string(value, convertToUTF8String(coreSelf->domain()));
        break;
    }
    case PROP_URL: {
        g_value_take_string(value, convertToUTF8String(coreSelf->url()));
        break;
    }
    case PROP_COOKIE: {
        WebCore::ExceptionCode ec = 0;
        g_value_take_string(value, convertToUTF8String(coreSelf->cookie(ec)));
        break;
    }
    case PROP_BODY: {
        RefPtr<WebCore::HTMLElement> ptr = coreSelf->body();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_HEAD: {
        RefPtr<WebCore::HTMLHeadElement> ptr = coreSelf->head();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_IMAGES: {
        RefPtr<WebCore::HTMLCollection> ptr = coreSelf->images();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_APPLETS: {
        RefPtr<WebCore::HTMLCollection> ptr = coreSelf->applets();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_LINKS: {
        RefPtr<WebCore::HTMLCollection> ptr = coreSelf->links();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_FORMS: {
        RefPtr<WebCore::HTMLCollection> ptr = coreSelf->forms();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_ANCHORS: {
        RefPtr<WebCore::HTMLCollection> ptr = coreSelf->anchors();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_LAST_MODIFIED: {
        g_value_take_string(value, convertToUTF8String(coreSelf->lastModified()));
        break;
    }
    case PROP_CHARSET: {
        g_value_take_string(value, convertToUTF8String(coreSelf->charset()));
        break;
    }
    case PROP_DEFAULT_CHARSET: {
        g_value_take_string(value, convertToUTF8String(coreSelf->defaultCharset()));
        break;
    }
    case PROP_READY_STATE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->readyState()));
        break;
    }
    case PROP_CHARACTER_SET: {
        g_value_take_string(value, convertToUTF8String(coreSelf->characterSet()));
        break;
    }
    case PROP_PREFERRED_STYLESHEET_SET: {
        g_value_take_string(value, convertToUTF8String(coreSelf->preferredStylesheetSet()));
        break;
    }
    case PROP_SELECTED_STYLESHEET_SET: {
        g_value_take_string(value, convertToUTF8String(coreSelf->selectedStylesheetSet()));
        break;
    }
    case PROP_COMPAT_MODE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->compatMode()));
        break;
    }
    case PROP_WEBKIT_IS_FULL_SCREEN: {
        g_value_set_boolean(value, coreSelf->webkitIsFullScreen());
        break;
    }
    case PROP_WEBKIT_FULL_SCREEN_KEYBOARD_INPUT_ALLOWED: {
        g_value_set_boolean(value, coreSelf->webkitFullScreenKeyboardInputAllowed());
        break;
    }
    case PROP_WEBKIT_CURRENT_FULL_SCREEN_ELEMENT: {
        RefPtr<WebCore::Element> ptr = coreSelf->webkitCurrentFullScreenElement();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_WEBKIT_FULLSCREEN_ENABLED: {
        g_value_set_boolean(value, coreSelf->webkitFullscreenEnabled());
        break;
    }
    case PROP_WEBKIT_FULLSCREEN_ELEMENT: {
        RefPtr<WebCore::Element> ptr = coreSelf->webkitFullscreenElement();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_WEBKIT_POINTER_LOCK_ELEMENT: {
#if ENABLE(POINTER_LOCK)
        RefPtr<WebCore::Element> ptr = coreSelf->webkitPointerLockElement();
        g_value_set_object(value, WebKit::kit(ptr.get()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Pointer Lock")
#endif /* ENABLE(POINTER_LOCK) */
        break;
    }
    case PROP_WEBKIT_VISIBILITY_STATE: {
#if ENABLE(PAGE_VISIBILITY_API)
        g_value_take_string(value, convertToUTF8String(coreSelf->webkitVisibilityState()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Page Visibility API")
#endif /* ENABLE(PAGE_VISIBILITY_API) */
        break;
    }
    case PROP_WEBKIT_HIDDEN: {
#if ENABLE(PAGE_VISIBILITY_API)
        g_value_set_boolean(value, coreSelf->webkitHidden());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Page Visibility API")
#endif /* ENABLE(PAGE_VISIBILITY_API) */
        break;
    }
    case PROP_SECURITY_POLICY: {
#if ENABLE(CSP_NEXT)
        RefPtr<WebCore::DOMSecurityPolicy> ptr = coreSelf->securityPolicy();
        g_value_set_object(value, WebKit::kit(ptr.get()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Csp Next")
#endif /* ENABLE(CSP_NEXT) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_document_class_init(WebKitDOMDocumentClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_document_set_property;
    gobjectClass->get_property = webkit_dom_document_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_DOCTYPE,
                                    g_param_spec_object("doctype", /* name */
                                                           "document_doctype", /* short description */
                                                           "read-only  WebKitDOMDocumentType* Document.doctype", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOCUMENT_TYPE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_IMPLEMENTATION,
                                    g_param_spec_object("implementation", /* name */
                                                           "document_implementation", /* short description */
                                                           "read-only  WebKitDOMDOMImplementation* Document.implementation", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOM_IMPLEMENTATION, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DOCUMENT_ELEMENT,
                                    g_param_spec_object("document-element", /* name */
                                                           "document_document-element", /* short description */
                                                           "read-only  WebKitDOMElement* Document.document-element", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_INPUT_ENCODING,
                                    g_param_spec_string("input-encoding", /* name */
                                                           "document_input-encoding", /* short description */
                                                           "read-only  gchar* Document.input-encoding", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_XML_ENCODING,
                                    g_param_spec_string("xml-encoding", /* name */
                                                           "document_xml-encoding", /* short description */
                                                           "read-only  gchar* Document.xml-encoding", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_XML_VERSION,
                                    g_param_spec_string("xml-version", /* name */
                                                           "document_xml-version", /* short description */
                                                           "read-write  gchar* Document.xml-version", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_XML_STANDALONE,
                                    g_param_spec_boolean("xml-standalone", /* name */
                                                           "document_xml-standalone", /* short description */
                                                           "read-write  gboolean Document.xml-standalone", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DOCUMENT_URI,
                                    g_param_spec_string("document-uri", /* name */
                                                           "document_document-uri", /* short description */
                                                           "read-write  gchar* Document.document-uri", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DEFAULT_VIEW,
                                    g_param_spec_object("default-view", /* name */
                                                           "document_default-view", /* short description */
                                                           "read-only  WebKitDOMDOMWindow* Document.default-view", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOM_WINDOW, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_STYLE_SHEETS,
                                    g_param_spec_object("style-sheets", /* name */
                                                           "document_style-sheets", /* short description */
                                                           "read-only  WebKitDOMStyleSheetList* Document.style-sheets", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_STYLE_SHEET_LIST, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TITLE,
                                    g_param_spec_string("title", /* name */
                                                           "document_title", /* short description */
                                                           "read-write  gchar* Document.title", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_REFERRER,
                                    g_param_spec_string("referrer", /* name */
                                                           "document_referrer", /* short description */
                                                           "read-only  gchar* Document.referrer", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DOMAIN,
                                    g_param_spec_string("domain", /* name */
                                                           "document_domain", /* short description */
                                                           "read-only  gchar* Document.domain", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_URL,
                                    g_param_spec_string("url", /* name */
                                                           "document_url", /* short description */
                                                           "read-only  gchar* Document.url", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_COOKIE,
                                    g_param_spec_string("cookie", /* name */
                                                           "document_cookie", /* short description */
                                                           "read-write  gchar* Document.cookie", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_BODY,
                                    g_param_spec_object("body", /* name */
                                                           "document_body", /* short description */
                                                           "read-write  WebKitDOMHTMLElement* Document.body", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HEAD,
                                    g_param_spec_object("head", /* name */
                                                           "document_head", /* short description */
                                                           "read-only  WebKitDOMHTMLHeadElement* Document.head", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_HEAD_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_IMAGES,
                                    g_param_spec_object("images", /* name */
                                                           "document_images", /* short description */
                                                           "read-only  WebKitDOMHTMLCollection* Document.images", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_COLLECTION, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_APPLETS,
                                    g_param_spec_object("applets", /* name */
                                                           "document_applets", /* short description */
                                                           "read-only  WebKitDOMHTMLCollection* Document.applets", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_COLLECTION, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LINKS,
                                    g_param_spec_object("links", /* name */
                                                           "document_links", /* short description */
                                                           "read-only  WebKitDOMHTMLCollection* Document.links", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_COLLECTION, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FORMS,
                                    g_param_spec_object("forms", /* name */
                                                           "document_forms", /* short description */
                                                           "read-only  WebKitDOMHTMLCollection* Document.forms", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_COLLECTION, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ANCHORS,
                                    g_param_spec_object("anchors", /* name */
                                                           "document_anchors", /* short description */
                                                           "read-only  WebKitDOMHTMLCollection* Document.anchors", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_COLLECTION, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LAST_MODIFIED,
                                    g_param_spec_string("last-modified", /* name */
                                                           "document_last-modified", /* short description */
                                                           "read-only  gchar* Document.last-modified", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CHARSET,
                                    g_param_spec_string("charset", /* name */
                                                           "document_charset", /* short description */
                                                           "read-write  gchar* Document.charset", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DEFAULT_CHARSET,
                                    g_param_spec_string("default-charset", /* name */
                                                           "document_default-charset", /* short description */
                                                           "read-only  gchar* Document.default-charset", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_READY_STATE,
                                    g_param_spec_string("ready-state", /* name */
                                                           "document_ready-state", /* short description */
                                                           "read-only  gchar* Document.ready-state", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CHARACTER_SET,
                                    g_param_spec_string("character-set", /* name */
                                                           "document_character-set", /* short description */
                                                           "read-only  gchar* Document.character-set", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PREFERRED_STYLESHEET_SET,
                                    g_param_spec_string("preferred-stylesheet-set", /* name */
                                                           "document_preferred-stylesheet-set", /* short description */
                                                           "read-only  gchar* Document.preferred-stylesheet-set", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SELECTED_STYLESHEET_SET,
                                    g_param_spec_string("selected-stylesheet-set", /* name */
                                                           "document_selected-stylesheet-set", /* short description */
                                                           "read-write  gchar* Document.selected-stylesheet-set", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_COMPAT_MODE,
                                    g_param_spec_string("compat-mode", /* name */
                                                           "document_compat-mode", /* short description */
                                                           "read-only  gchar* Document.compat-mode", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WEBKIT_IS_FULL_SCREEN,
                                    g_param_spec_boolean("webkit-is-full-screen", /* name */
                                                           "document_webkit-is-full-screen", /* short description */
                                                           "read-only  gboolean Document.webkit-is-full-screen", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WEBKIT_FULL_SCREEN_KEYBOARD_INPUT_ALLOWED,
                                    g_param_spec_boolean("webkit-full-screen-keyboard-input-allowed", /* name */
                                                           "document_webkit-full-screen-keyboard-input-allowed", /* short description */
                                                           "read-only  gboolean Document.webkit-full-screen-keyboard-input-allowed", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WEBKIT_CURRENT_FULL_SCREEN_ELEMENT,
                                    g_param_spec_object("webkit-current-full-screen-element", /* name */
                                                           "document_webkit-current-full-screen-element", /* short description */
                                                           "read-only  WebKitDOMElement* Document.webkit-current-full-screen-element", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WEBKIT_FULLSCREEN_ENABLED,
                                    g_param_spec_boolean("webkit-fullscreen-enabled", /* name */
                                                           "document_webkit-fullscreen-enabled", /* short description */
                                                           "read-only  gboolean Document.webkit-fullscreen-enabled", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WEBKIT_FULLSCREEN_ELEMENT,
                                    g_param_spec_object("webkit-fullscreen-element", /* name */
                                                           "document_webkit-fullscreen-element", /* short description */
                                                           "read-only  WebKitDOMElement* Document.webkit-fullscreen-element", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WEBKIT_POINTER_LOCK_ELEMENT,
                                    g_param_spec_object("webkit-pointer-lock-element", /* name */
                                                           "document_webkit-pointer-lock-element", /* short description */
                                                           "read-only  WebKitDOMElement* Document.webkit-pointer-lock-element", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WEBKIT_VISIBILITY_STATE,
                                    g_param_spec_string("webkit-visibility-state", /* name */
                                                           "document_webkit-visibility-state", /* short description */
                                                           "read-only  gchar* Document.webkit-visibility-state", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WEBKIT_HIDDEN,
                                    g_param_spec_boolean("webkit-hidden", /* name */
                                                           "document_webkit-hidden", /* short description */
                                                           "read-only  gboolean Document.webkit-hidden", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SECURITY_POLICY,
                                    g_param_spec_object("security-policy", /* name */
                                                           "document_security-policy", /* short description */
                                                           "read-only  WebKitDOMDOMSecurityPolicy* Document.security-policy", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOM_SECURITY_POLICY, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_document_init(WebKitDOMDocument* request)
{
}

WebKitDOMElement*
webkit_dom_document_create_element(WebKitDOMDocument* self, const gchar* tagName, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    g_return_val_if_fail(tagName, 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedTagName = WTF::String::fromUTF8(tagName);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::Element> gobjectResult = WTF::getPtr(item->createElement(convertedTagName, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMDocumentFragment*
webkit_dom_document_create_document_fragment(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    RefPtr<WebCore::DocumentFragment> gobjectResult = WTF::getPtr(item->createDocumentFragment());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMText*
webkit_dom_document_create_text_node(WebKitDOMDocument* self, const gchar* data)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    g_return_val_if_fail(data, 0);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedData = WTF::String::fromUTF8(data);
    RefPtr<WebCore::Text> gobjectResult = WTF::getPtr(item->createTextNode(convertedData));
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMComment*
webkit_dom_document_create_comment(WebKitDOMDocument* self, const gchar* data)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    g_return_val_if_fail(data, 0);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedData = WTF::String::fromUTF8(data);
    RefPtr<WebCore::Comment> gobjectResult = WTF::getPtr(item->createComment(convertedData));
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMCDATASection*
webkit_dom_document_create_cdata_section(WebKitDOMDocument* self, const gchar* data, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    g_return_val_if_fail(data, 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedData = WTF::String::fromUTF8(data);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::CDATASection> gobjectResult = WTF::getPtr(item->createCDATASection(convertedData, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMProcessingInstruction*
webkit_dom_document_create_processing_instruction(WebKitDOMDocument* self, const gchar* target, const gchar* data, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    g_return_val_if_fail(target, 0);
    g_return_val_if_fail(data, 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedTarget = WTF::String::fromUTF8(target);
    WTF::String convertedData = WTF::String::fromUTF8(data);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::ProcessingInstruction> gobjectResult = WTF::getPtr(item->createProcessingInstruction(convertedTarget, convertedData, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMAttr*
webkit_dom_document_create_attribute(WebKitDOMDocument* self, const gchar* name, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    g_return_val_if_fail(name, 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedName = WTF::String::fromUTF8(name);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::Attr> gobjectResult = WTF::getPtr(item->createAttribute(convertedName, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMEntityReference*
webkit_dom_document_create_entity_reference(WebKitDOMDocument* self, const gchar* name, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    g_return_val_if_fail(name, 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedName = WTF::String::fromUTF8(name);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::EntityReference> gobjectResult = WTF::getPtr(item->createEntityReference(convertedName, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNodeList*
webkit_dom_document_get_elements_by_tag_name(WebKitDOMDocument* self, const gchar* tagname)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    g_return_val_if_fail(tagname, 0);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedTagname = WTF::String::fromUTF8(tagname);
    RefPtr<WebCore::NodeList> gobjectResult = WTF::getPtr(item->getElementsByTagName(convertedTagname));
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNode*
webkit_dom_document_import_node(WebKitDOMDocument* self, WebKitDOMNode* importedNode, gboolean deep, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(importedNode), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Document* item = WebKit::core(self);
    WebCore::Node* convertedImportedNode = WebKit::core(importedNode);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->importNode(convertedImportedNode, deep, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMElement*
webkit_dom_document_create_element_ns(WebKitDOMDocument* self, const gchar* namespaceURI, const gchar* qualifiedName, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    g_return_val_if_fail(namespaceURI, 0);
    g_return_val_if_fail(qualifiedName, 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedNamespaceURI = WTF::String::fromUTF8(namespaceURI);
    WTF::String convertedQualifiedName = WTF::String::fromUTF8(qualifiedName);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::Element> gobjectResult = WTF::getPtr(item->createElementNS(convertedNamespaceURI, convertedQualifiedName, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMAttr*
webkit_dom_document_create_attribute_ns(WebKitDOMDocument* self, const gchar* namespaceURI, const gchar* qualifiedName, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    g_return_val_if_fail(namespaceURI, 0);
    g_return_val_if_fail(qualifiedName, 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedNamespaceURI = WTF::String::fromUTF8(namespaceURI);
    WTF::String convertedQualifiedName = WTF::String::fromUTF8(qualifiedName);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::Attr> gobjectResult = WTF::getPtr(item->createAttributeNS(convertedNamespaceURI, convertedQualifiedName, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNodeList*
webkit_dom_document_get_elements_by_tag_name_ns(WebKitDOMDocument* self, const gchar* namespaceURI, const gchar* localName)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    g_return_val_if_fail(namespaceURI, 0);
    g_return_val_if_fail(localName, 0);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedNamespaceURI = WTF::String::fromUTF8(namespaceURI);
    WTF::String convertedLocalName = WTF::String::fromUTF8(localName);
    RefPtr<WebCore::NodeList> gobjectResult = WTF::getPtr(item->getElementsByTagNameNS(convertedNamespaceURI, convertedLocalName));
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMElement*
webkit_dom_document_get_element_by_id(WebKitDOMDocument* self, const gchar* elementId)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    g_return_val_if_fail(elementId, 0);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedElementId = WTF::String::fromUTF8(elementId);
    RefPtr<WebCore::Element> gobjectResult = WTF::getPtr(item->getElementById(convertedElementId));
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNode*
webkit_dom_document_adopt_node(WebKitDOMDocument* self, WebKitDOMNode* source, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(source), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Document* item = WebKit::core(self);
    WebCore::Node* convertedSource = WebKit::core(source);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->adoptNode(convertedSource, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMEvent*
webkit_dom_document_create_event(WebKitDOMDocument* self, const gchar* eventType, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    g_return_val_if_fail(eventType, 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedEventType = WTF::String::fromUTF8(eventType);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::Event> gobjectResult = WTF::getPtr(item->createEvent(convertedEventType, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMRange*
webkit_dom_document_create_range(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    RefPtr<WebCore::Range> gobjectResult = WTF::getPtr(item->createRange());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNodeIterator*
webkit_dom_document_create_node_iterator(WebKitDOMDocument* self, WebKitDOMNode* root, gulong whatToShow, WebKitDOMNodeFilter* filter, gboolean expandEntityReferences, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(root), 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE_FILTER(filter), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Document* item = WebKit::core(self);
    WebCore::Node* convertedRoot = WebKit::core(root);
    WebCore::NodeFilter* convertedFilter = WebKit::core(filter);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::NodeIterator> gobjectResult = WTF::getPtr(item->createNodeIterator(convertedRoot, whatToShow, convertedFilter, expandEntityReferences, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMTreeWalker*
webkit_dom_document_create_tree_walker(WebKitDOMDocument* self, WebKitDOMNode* root, gulong whatToShow, WebKitDOMNodeFilter* filter, gboolean expandEntityReferences, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(root), 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE_FILTER(filter), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Document* item = WebKit::core(self);
    WebCore::Node* convertedRoot = WebKit::core(root);
    WebCore::NodeFilter* convertedFilter = WebKit::core(filter);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::TreeWalker> gobjectResult = WTF::getPtr(item->createTreeWalker(convertedRoot, whatToShow, convertedFilter, expandEntityReferences, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMCSSStyleDeclaration*
webkit_dom_document_get_override_style(WebKitDOMDocument* self, WebKitDOMElement* element, const gchar* pseudoElement)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(element), 0);
    g_return_val_if_fail(pseudoElement, 0);
    WebCore::Document* item = WebKit::core(self);
    WebCore::Element* convertedElement = WebKit::core(element);
    WTF::String convertedPseudoElement = WTF::String::fromUTF8(pseudoElement);
    RefPtr<WebCore::CSSStyleDeclaration> gobjectResult = WTF::getPtr(item->getOverrideStyle(convertedElement, convertedPseudoElement));
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMXPathExpression*
webkit_dom_document_create_expression(WebKitDOMDocument* self, const gchar* expression, WebKitDOMXPathNSResolver* resolver, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    g_return_val_if_fail(expression, 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_XPATH_NS_RESOLVER(resolver), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedExpression = WTF::String::fromUTF8(expression);
    WebCore::XPathNSResolver* convertedResolver = WebKit::core(resolver);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::XPathExpression> gobjectResult = WTF::getPtr(item->createExpression(convertedExpression, convertedResolver, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMXPathNSResolver*
webkit_dom_document_create_ns_resolver(WebKitDOMDocument* self, WebKitDOMNode* nodeResolver)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(nodeResolver), 0);
    WebCore::Document* item = WebKit::core(self);
    WebCore::Node* convertedNodeResolver = WebKit::core(nodeResolver);
    RefPtr<WebCore::XPathNSResolver> gobjectResult = WTF::getPtr(item->createNSResolver(convertedNodeResolver));
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMXPathResult*
webkit_dom_document_evaluate(WebKitDOMDocument* self, const gchar* expression, WebKitDOMNode* contextNode, WebKitDOMXPathNSResolver* resolver, gushort type, WebKitDOMXPathResult* inResult, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    g_return_val_if_fail(expression, 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(contextNode), 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_XPATH_NS_RESOLVER(resolver), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedExpression = WTF::String::fromUTF8(expression);
    WebCore::Node* convertedContextNode = WebKit::core(contextNode);
    WebCore::XPathNSResolver* convertedResolver = WebKit::core(resolver);
    WebCore::XPathResult* convertedInResult = WebKit::core(inResult);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::XPathResult> gobjectResult = WTF::getPtr(item->evaluate(convertedExpression, convertedContextNode, convertedResolver, type, convertedInResult, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

gboolean
webkit_dom_document_exec_command(WebKitDOMDocument* self, const gchar* command, gboolean userInterface, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), FALSE);
    g_return_val_if_fail(command, FALSE);
    g_return_val_if_fail(value, FALSE);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedCommand = WTF::String::fromUTF8(command);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    gboolean result = item->execCommand(convertedCommand, userInterface, convertedValue);
    return result;
}

gboolean
webkit_dom_document_query_command_enabled(WebKitDOMDocument* self, const gchar* command)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), FALSE);
    g_return_val_if_fail(command, FALSE);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedCommand = WTF::String::fromUTF8(command);
    gboolean result = item->queryCommandEnabled(convertedCommand);
    return result;
}

gboolean
webkit_dom_document_query_command_indeterm(WebKitDOMDocument* self, const gchar* command)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), FALSE);
    g_return_val_if_fail(command, FALSE);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedCommand = WTF::String::fromUTF8(command);
    gboolean result = item->queryCommandIndeterm(convertedCommand);
    return result;
}

gboolean
webkit_dom_document_query_command_state(WebKitDOMDocument* self, const gchar* command)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), FALSE);
    g_return_val_if_fail(command, FALSE);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedCommand = WTF::String::fromUTF8(command);
    gboolean result = item->queryCommandState(convertedCommand);
    return result;
}

gboolean
webkit_dom_document_query_command_supported(WebKitDOMDocument* self, const gchar* command)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), FALSE);
    g_return_val_if_fail(command, FALSE);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedCommand = WTF::String::fromUTF8(command);
    gboolean result = item->queryCommandSupported(convertedCommand);
    return result;
}

gchar*
webkit_dom_document_query_command_value(WebKitDOMDocument* self, const gchar* command)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    g_return_val_if_fail(command, 0);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedCommand = WTF::String::fromUTF8(command);
    gchar* result = convertToUTF8String(item->queryCommandValue(convertedCommand));
    return result;
}

WebKitDOMNodeList*
webkit_dom_document_get_elements_by_name(WebKitDOMDocument* self, const gchar* elementName)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    g_return_val_if_fail(elementName, 0);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedElementName = WTF::String::fromUTF8(elementName);
    RefPtr<WebCore::NodeList> gobjectResult = WTF::getPtr(item->getElementsByName(convertedElementName));
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMElement*
webkit_dom_document_element_from_point(WebKitDOMDocument* self, glong x, glong y)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    RefPtr<WebCore::Element> gobjectResult = WTF::getPtr(item->elementFromPoint(x, y));
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMRange*
webkit_dom_document_caret_range_from_point(WebKitDOMDocument* self, glong x, glong y)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    RefPtr<WebCore::Range> gobjectResult = WTF::getPtr(item->caretRangeFromPoint(x, y));
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMCSSStyleDeclaration*
webkit_dom_document_create_css_style_declaration(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    RefPtr<WebCore::CSSStyleDeclaration> gobjectResult = WTF::getPtr(item->createCSSStyleDeclaration());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNodeList*
webkit_dom_document_get_elements_by_class_name(WebKitDOMDocument* self, const gchar* tagname)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    g_return_val_if_fail(tagname, 0);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedTagname = WTF::String::fromUTF8(tagname);
    RefPtr<WebCore::NodeList> gobjectResult = WTF::getPtr(item->getElementsByClassName(convertedTagname));
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMElement*
webkit_dom_document_query_selector(WebKitDOMDocument* self, const gchar* selectors, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    g_return_val_if_fail(selectors, 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedSelectors = WTF::String::fromUTF8(selectors);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::Element> gobjectResult = WTF::getPtr(item->querySelector(convertedSelectors, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNodeList*
webkit_dom_document_query_selector_all(WebKitDOMDocument* self, const gchar* selectors, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    g_return_val_if_fail(selectors, 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedSelectors = WTF::String::fromUTF8(selectors);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::NodeList> gobjectResult = WTF::getPtr(item->querySelectorAll(convertedSelectors, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

void
webkit_dom_document_webkit_cancel_full_screen(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOCUMENT(self));
    WebCore::Document* item = WebKit::core(self);
    item->webkitCancelFullScreen();
}

void
webkit_dom_document_webkit_exit_fullscreen(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOCUMENT(self));
    WebCore::Document* item = WebKit::core(self);
    item->webkitExitFullscreen();
}

void
webkit_dom_document_webkit_exit_pointer_lock(WebKitDOMDocument* self)
{
#if ENABLE(POINTER_LOCK)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOCUMENT(self));
    WebCore::Document* item = WebKit::core(self);
    item->webkitExitPointerLock();
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Pointer Lock")
#endif /* ENABLE(POINTER_LOCK) */
}

WebKitDOMDOMNamedFlowCollection*
webkit_dom_document_webkit_get_named_flows(WebKitDOMDocument* self)
{
#if ENABLE(CSS_REGIONS)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    RefPtr<WebCore::DOMNamedFlowCollection> gobjectResult = WTF::getPtr(item->webkitGetNamedFlows());
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Css Regions")
    return 0;
#endif /* ENABLE(CSS_REGIONS) */
}

WebKitDOMDocumentType*
webkit_dom_document_get_doctype(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    RefPtr<WebCore::DocumentType> gobjectResult = WTF::getPtr(item->doctype());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMDOMImplementation*
webkit_dom_document_get_implementation(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    RefPtr<WebCore::DOMImplementation> gobjectResult = WTF::getPtr(item->implementation());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMElement*
webkit_dom_document_get_document_element(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    RefPtr<WebCore::Element> gobjectResult = WTF::getPtr(item->documentElement());
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_document_get_input_encoding(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->inputEncoding());
    return result;
}

gchar*
webkit_dom_document_get_xml_encoding(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->xmlEncoding());
    return result;
}

gchar*
webkit_dom_document_get_xml_version(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->xmlVersion());
    return result;
}

void
webkit_dom_document_set_xml_version(WebKitDOMDocument* self, const gchar* value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOCUMENT(self));
    g_return_if_fail(value);
    g_return_if_fail(!error || !*error);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    WebCore::ExceptionCode ec = 0;
    item->setXMLVersion(convertedValue, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

gboolean
webkit_dom_document_get_xml_standalone(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), FALSE);
    WebCore::Document* item = WebKit::core(self);
    gboolean result = item->xmlStandalone();
    return result;
}

void
webkit_dom_document_set_xml_standalone(WebKitDOMDocument* self, gboolean value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOCUMENT(self));
    g_return_if_fail(!error || !*error);
    WebCore::Document* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->setXMLStandalone(value, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

gchar*
webkit_dom_document_get_document_uri(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->documentURI());
    return result;
}

void
webkit_dom_document_set_document_uri(WebKitDOMDocument* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOCUMENT(self));
    g_return_if_fail(value);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setDocumentURI(convertedValue);
}

WebKitDOMDOMWindow*
webkit_dom_document_get_default_view(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    RefPtr<WebCore::DOMWindow> gobjectResult = WTF::getPtr(item->defaultView());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMStyleSheetList*
webkit_dom_document_get_style_sheets(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    RefPtr<WebCore::StyleSheetList> gobjectResult = WTF::getPtr(item->styleSheets());
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_document_get_title(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->title());
    return result;
}

void
webkit_dom_document_set_title(WebKitDOMDocument* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOCUMENT(self));
    g_return_if_fail(value);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setTitle(convertedValue);
}

gchar*
webkit_dom_document_get_referrer(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->referrer());
    return result;
}

gchar*
webkit_dom_document_get_domain(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->domain());
    return result;
}

gchar*
webkit_dom_document_get_cookie(WebKitDOMDocument* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Document* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    gchar* result = convertToUTF8String(item->cookie(ec));
    return result;
}

void
webkit_dom_document_set_cookie(WebKitDOMDocument* self, const gchar* value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOCUMENT(self));
    g_return_if_fail(value);
    g_return_if_fail(!error || !*error);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    WebCore::ExceptionCode ec = 0;
    item->setCookie(convertedValue, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

WebKitDOMHTMLElement*
webkit_dom_document_get_body(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    RefPtr<WebCore::HTMLElement> gobjectResult = WTF::getPtr(item->body());
    return WebKit::kit(gobjectResult.get());
}

void
webkit_dom_document_set_body(WebKitDOMDocument* self, WebKitDOMHTMLElement* value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOCUMENT(self));
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(value));
    g_return_if_fail(!error || !*error);
    WebCore::Document* item = WebKit::core(self);
    WebCore::HTMLElement* convertedValue = WebKit::core(value);
    WebCore::ExceptionCode ec = 0;
    item->setBody(convertedValue, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

WebKitDOMHTMLHeadElement*
webkit_dom_document_get_head(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    RefPtr<WebCore::HTMLHeadElement> gobjectResult = WTF::getPtr(item->head());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMHTMLCollection*
webkit_dom_document_get_images(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    RefPtr<WebCore::HTMLCollection> gobjectResult = WTF::getPtr(item->images());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMHTMLCollection*
webkit_dom_document_get_applets(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    RefPtr<WebCore::HTMLCollection> gobjectResult = WTF::getPtr(item->applets());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMHTMLCollection*
webkit_dom_document_get_links(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    RefPtr<WebCore::HTMLCollection> gobjectResult = WTF::getPtr(item->links());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMHTMLCollection*
webkit_dom_document_get_forms(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    RefPtr<WebCore::HTMLCollection> gobjectResult = WTF::getPtr(item->forms());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMHTMLCollection*
webkit_dom_document_get_anchors(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    RefPtr<WebCore::HTMLCollection> gobjectResult = WTF::getPtr(item->anchors());
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_document_get_last_modified(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->lastModified());
    return result;
}

gchar*
webkit_dom_document_get_charset(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->charset());
    return result;
}

void
webkit_dom_document_set_charset(WebKitDOMDocument* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOCUMENT(self));
    g_return_if_fail(value);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setCharset(convertedValue);
}

gchar*
webkit_dom_document_get_default_charset(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->defaultCharset());
    return result;
}

gchar*
webkit_dom_document_get_ready_state(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->readyState());
    return result;
}

gchar*
webkit_dom_document_get_character_set(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->characterSet());
    return result;
}

gchar*
webkit_dom_document_get_preferred_stylesheet_set(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->preferredStylesheetSet());
    return result;
}

gchar*
webkit_dom_document_get_selected_stylesheet_set(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->selectedStylesheetSet());
    return result;
}

void
webkit_dom_document_set_selected_stylesheet_set(WebKitDOMDocument* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOCUMENT(self));
    g_return_if_fail(value);
    WebCore::Document* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setSelectedStylesheetSet(convertedValue);
}

gchar*
webkit_dom_document_get_compat_mode(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->compatMode());
    return result;
}

gboolean
webkit_dom_document_get_webkit_is_full_screen(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), FALSE);
    WebCore::Document* item = WebKit::core(self);
    gboolean result = item->webkitIsFullScreen();
    return result;
}

gboolean
webkit_dom_document_get_webkit_full_screen_keyboard_input_allowed(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), FALSE);
    WebCore::Document* item = WebKit::core(self);
    gboolean result = item->webkitFullScreenKeyboardInputAllowed();
    return result;
}

WebKitDOMElement*
webkit_dom_document_get_webkit_current_full_screen_element(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    RefPtr<WebCore::Element> gobjectResult = WTF::getPtr(item->webkitCurrentFullScreenElement());
    return WebKit::kit(gobjectResult.get());
}

gboolean
webkit_dom_document_get_webkit_fullscreen_enabled(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), FALSE);
    WebCore::Document* item = WebKit::core(self);
    gboolean result = item->webkitFullscreenEnabled();
    return result;
}

WebKitDOMElement*
webkit_dom_document_get_webkit_fullscreen_element(WebKitDOMDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    RefPtr<WebCore::Element> gobjectResult = WTF::getPtr(item->webkitFullscreenElement());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMElement*
webkit_dom_document_get_webkit_pointer_lock_element(WebKitDOMDocument* self)
{
#if ENABLE(POINTER_LOCK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    RefPtr<WebCore::Element> gobjectResult = WTF::getPtr(item->webkitPointerLockElement());
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Pointer Lock")
    return 0;
#endif /* ENABLE(POINTER_LOCK) */
}

gchar*
webkit_dom_document_get_webkit_visibility_state(WebKitDOMDocument* self)
{
#if ENABLE(PAGE_VISIBILITY_API)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->webkitVisibilityState());
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Page Visibility API")
    return 0;
#endif /* ENABLE(PAGE_VISIBILITY_API) */
}

gboolean
webkit_dom_document_get_webkit_hidden(WebKitDOMDocument* self)
{
#if ENABLE(PAGE_VISIBILITY_API)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), FALSE);
    WebCore::Document* item = WebKit::core(self);
    gboolean result = item->webkitHidden();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Page Visibility API")
    return static_cast<gboolean>(0);
#endif /* ENABLE(PAGE_VISIBILITY_API) */
}

WebKitDOMDOMSecurityPolicy*
webkit_dom_document_get_security_policy(WebKitDOMDocument* self)
{
#if ENABLE(CSP_NEXT)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOCUMENT(self), 0);
    WebCore::Document* item = WebKit::core(self);
    RefPtr<WebCore::DOMSecurityPolicy> gobjectResult = WTF::getPtr(item->securityPolicy());
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Csp Next")
    return 0;
#endif /* ENABLE(CSP_NEXT) */
}

