/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLSelectElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLCollectionPrivate.h"
#include "WebKitDOMHTMLElementPrivate.h"
#include "WebKitDOMHTMLFormElementPrivate.h"
#include "WebKitDOMHTMLOptionsCollectionPrivate.h"
#include "WebKitDOMHTMLSelectElementPrivate.h"
#include "WebKitDOMNodeListPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMValidityStatePrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLSelectElement* kit(WebCore::HTMLSelectElement* obj)
{
    return WEBKIT_DOM_HTML_SELECT_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLSelectElement* core(WebKitDOMHTMLSelectElement* request)
{
    return request ? static_cast<WebCore::HTMLSelectElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLSelectElement* wrapHTMLSelectElement(WebCore::HTMLSelectElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_SELECT_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_SELECT_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLSelectElement, webkit_dom_html_select_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_AUTOFOCUS,
    PROP_DISABLED,
    PROP_FORM,
    PROP_MULTIPLE,
    PROP_NAME,
    PROP_REQUIRED,
    PROP_SIZE,
    PROP_TYPE,
    PROP_OPTIONS,
    PROP_LENGTH,
    PROP_SELECTED_OPTIONS,
    PROP_SELECTED_INDEX,
    PROP_VALUE,
    PROP_WILL_VALIDATE,
    PROP_VALIDITY,
    PROP_VALIDATION_MESSAGE,
    PROP_LABELS,
};

static void webkit_dom_html_select_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLSelectElement* self = WEBKIT_DOM_HTML_SELECT_ELEMENT(object);
    WebCore::HTMLSelectElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_AUTOFOCUS: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::autofocusAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_DISABLED: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::disabledAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_MULTIPLE: {
        coreSelf->setMultiple((g_value_get_boolean(value)));
        break;
    }
    case PROP_NAME: {
        coreSelf->setAttribute(WebCore::HTMLNames::nameAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_REQUIRED: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::requiredAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_SIZE: {
        coreSelf->setSize((g_value_get_long(value)));
        break;
    }
    case PROP_LENGTH: {
        WebCore::ExceptionCode ec = 0;
        coreSelf->setLength((g_value_get_ulong(value)), ec);
        break;
    }
    case PROP_SELECTED_INDEX: {
        coreSelf->setSelectedIndex((g_value_get_long(value)));
        break;
    }
    case PROP_VALUE: {
        coreSelf->setValue(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_select_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLSelectElement* self = WEBKIT_DOM_HTML_SELECT_ELEMENT(object);
    WebCore::HTMLSelectElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_AUTOFOCUS: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::autofocusAttr));
        break;
    }
    case PROP_DISABLED: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::disabledAttr));
        break;
    }
    case PROP_FORM: {
        RefPtr<WebCore::HTMLFormElement> ptr = coreSelf->form();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_MULTIPLE: {
        g_value_set_boolean(value, coreSelf->multiple());
        break;
    }
    case PROP_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getNameAttribute()));
        break;
    }
    case PROP_REQUIRED: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::requiredAttr));
        break;
    }
    case PROP_SIZE: {
        g_value_set_long(value, coreSelf->size());
        break;
    }
    case PROP_TYPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->type()));
        break;
    }
    case PROP_OPTIONS: {
        RefPtr<WebCore::HTMLOptionsCollection> ptr = coreSelf->options();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_LENGTH: {
        g_value_set_ulong(value, coreSelf->length());
        break;
    }
    case PROP_SELECTED_OPTIONS: {
        RefPtr<WebCore::HTMLCollection> ptr = coreSelf->selectedOptions();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_SELECTED_INDEX: {
        g_value_set_long(value, coreSelf->selectedIndex());
        break;
    }
    case PROP_VALUE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->value()));
        break;
    }
    case PROP_WILL_VALIDATE: {
        g_value_set_boolean(value, coreSelf->willValidate());
        break;
    }
    case PROP_VALIDITY: {
        RefPtr<WebCore::ValidityState> ptr = coreSelf->validity();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_VALIDATION_MESSAGE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->validationMessage()));
        break;
    }
    case PROP_LABELS: {
        RefPtr<WebCore::NodeList> ptr = coreSelf->labels();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_select_element_class_init(WebKitDOMHTMLSelectElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_select_element_set_property;
    gobjectClass->get_property = webkit_dom_html_select_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_AUTOFOCUS,
                                    g_param_spec_boolean("autofocus", /* name */
                                                           "html_select_element_autofocus", /* short description */
                                                           "read-write  gboolean HTMLSelectElement.autofocus", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DISABLED,
                                    g_param_spec_boolean("disabled", /* name */
                                                           "html_select_element_disabled", /* short description */
                                                           "read-write  gboolean HTMLSelectElement.disabled", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FORM,
                                    g_param_spec_object("form", /* name */
                                                           "html_select_element_form", /* short description */
                                                           "read-only  WebKitDOMHTMLFormElement* HTMLSelectElement.form", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_FORM_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_MULTIPLE,
                                    g_param_spec_boolean("multiple", /* name */
                                                           "html_select_element_multiple", /* short description */
                                                           "read-write  gboolean HTMLSelectElement.multiple", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NAME,
                                    g_param_spec_string("name", /* name */
                                                           "html_select_element_name", /* short description */
                                                           "read-write  gchar* HTMLSelectElement.name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_REQUIRED,
                                    g_param_spec_boolean("required", /* name */
                                                           "html_select_element_required", /* short description */
                                                           "read-write  gboolean HTMLSelectElement.required", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SIZE,
                                    g_param_spec_long("size", /* name */
                                                           "html_select_element_size", /* short description */
                                                           "read-write  glong HTMLSelectElement.size", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TYPE,
                                    g_param_spec_string("type", /* name */
                                                           "html_select_element_type", /* short description */
                                                           "read-only  gchar* HTMLSelectElement.type", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_OPTIONS,
                                    g_param_spec_object("options", /* name */
                                                           "html_select_element_options", /* short description */
                                                           "read-only  WebKitDOMHTMLOptionsCollection* HTMLSelectElement.options", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_OPTIONS_COLLECTION, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LENGTH,
                                    g_param_spec_ulong("length", /* name */
                                                           "html_select_element_length", /* short description */
                                                           "read-write  gulong HTMLSelectElement.length", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SELECTED_OPTIONS,
                                    g_param_spec_object("selected-options", /* name */
                                                           "html_select_element_selected-options", /* short description */
                                                           "read-only  WebKitDOMHTMLCollection* HTMLSelectElement.selected-options", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_COLLECTION, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SELECTED_INDEX,
                                    g_param_spec_long("selected-index", /* name */
                                                           "html_select_element_selected-index", /* short description */
                                                           "read-write  glong HTMLSelectElement.selected-index", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VALUE,
                                    g_param_spec_string("value", /* name */
                                                           "html_select_element_value", /* short description */
                                                           "read-write  gchar* HTMLSelectElement.value", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WILL_VALIDATE,
                                    g_param_spec_boolean("will-validate", /* name */
                                                           "html_select_element_will-validate", /* short description */
                                                           "read-only  gboolean HTMLSelectElement.will-validate", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VALIDITY,
                                    g_param_spec_object("validity", /* name */
                                                           "html_select_element_validity", /* short description */
                                                           "read-only  WebKitDOMValidityState* HTMLSelectElement.validity", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_VALIDITY_STATE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VALIDATION_MESSAGE,
                                    g_param_spec_string("validation-message", /* name */
                                                           "html_select_element_validation-message", /* short description */
                                                           "read-only  gchar* HTMLSelectElement.validation-message", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LABELS,
                                    g_param_spec_object("labels", /* name */
                                                           "html_select_element_labels", /* short description */
                                                           "read-only  WebKitDOMNodeList* HTMLSelectElement.labels", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NODE_LIST, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_html_select_element_init(WebKitDOMHTMLSelectElement* request)
{
}

WebKitDOMNode*
webkit_dom_html_select_element_item(WebKitDOMHTMLSelectElement* self, gulong index)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self), 0);
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->item(index));
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNode*
webkit_dom_html_select_element_named_item(WebKitDOMHTMLSelectElement* self, const gchar* name)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self), 0);
    g_return_val_if_fail(name, 0);
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    WTF::String convertedName = WTF::String::fromUTF8(name);
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->namedItem(convertedName));
    return WebKit::kit(gobjectResult.get());
}

void
webkit_dom_html_select_element_add(WebKitDOMHTMLSelectElement* self, WebKitDOMHTMLElement* element, WebKitDOMHTMLElement* before, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self));
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(element));
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ELEMENT(before));
    g_return_if_fail(!error || !*error);
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    WebCore::HTMLElement* convertedElement = WebKit::core(element);
    WebCore::HTMLElement* convertedBefore = WebKit::core(before);
    WebCore::ExceptionCode ec = 0;
    item->add(convertedElement, convertedBefore, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_html_select_element_remove(WebKitDOMHTMLSelectElement* self, glong index)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self));
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    item->remove(index);
}

gboolean
webkit_dom_html_select_element_check_validity(WebKitDOMHTMLSelectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self), FALSE);
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    gboolean result = item->checkValidity();
    return result;
}

void
webkit_dom_html_select_element_set_custom_validity(WebKitDOMHTMLSelectElement* self, const gchar* error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self));
    g_return_if_fail(error);
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    WTF::String convertedError = WTF::String::fromUTF8(error);
    item->setCustomValidity(convertedError);
}

gboolean
webkit_dom_html_select_element_get_autofocus(WebKitDOMHTMLSelectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self), FALSE);
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::autofocusAttr);
    return result;
}

void
webkit_dom_html_select_element_set_autofocus(WebKitDOMHTMLSelectElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self));
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::autofocusAttr, value);
}

gboolean
webkit_dom_html_select_element_get_disabled(WebKitDOMHTMLSelectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self), FALSE);
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::disabledAttr);
    return result;
}

void
webkit_dom_html_select_element_set_disabled(WebKitDOMHTMLSelectElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self));
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::disabledAttr, value);
}

WebKitDOMHTMLFormElement*
webkit_dom_html_select_element_get_form(WebKitDOMHTMLSelectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self), 0);
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    RefPtr<WebCore::HTMLFormElement> gobjectResult = WTF::getPtr(item->form());
    return WebKit::kit(gobjectResult.get());
}

gboolean
webkit_dom_html_select_element_get_multiple(WebKitDOMHTMLSelectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self), FALSE);
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    gboolean result = item->multiple();
    return result;
}

void
webkit_dom_html_select_element_set_multiple(WebKitDOMHTMLSelectElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self));
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    item->setMultiple(value);
}

gchar*
webkit_dom_html_select_element_get_name(WebKitDOMHTMLSelectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self), 0);
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getNameAttribute());
    return result;
}

void
webkit_dom_html_select_element_set_name(WebKitDOMHTMLSelectElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::nameAttr, convertedValue);
}

gboolean
webkit_dom_html_select_element_get_required(WebKitDOMHTMLSelectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self), FALSE);
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::requiredAttr);
    return result;
}

void
webkit_dom_html_select_element_set_required(WebKitDOMHTMLSelectElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self));
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::requiredAttr, value);
}

glong
webkit_dom_html_select_element_get_size(WebKitDOMHTMLSelectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self), 0);
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    glong result = item->size();
    return result;
}

void
webkit_dom_html_select_element_set_size(WebKitDOMHTMLSelectElement* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self));
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    item->setSize(value);
}

WebKitDOMHTMLOptionsCollection*
webkit_dom_html_select_element_get_options(WebKitDOMHTMLSelectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self), 0);
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    RefPtr<WebCore::HTMLOptionsCollection> gobjectResult = WTF::getPtr(item->options());
    return WebKit::kit(gobjectResult.get());
}

gulong
webkit_dom_html_select_element_get_length(WebKitDOMHTMLSelectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self), 0);
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    gulong result = item->length();
    return result;
}

void
webkit_dom_html_select_element_set_length(WebKitDOMHTMLSelectElement* self, gulong value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self));
    g_return_if_fail(!error || !*error);
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->setLength(value, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

WebKitDOMHTMLCollection*
webkit_dom_html_select_element_get_selected_options(WebKitDOMHTMLSelectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self), 0);
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    RefPtr<WebCore::HTMLCollection> gobjectResult = WTF::getPtr(item->selectedOptions());
    return WebKit::kit(gobjectResult.get());
}

glong
webkit_dom_html_select_element_get_selected_index(WebKitDOMHTMLSelectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self), 0);
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    glong result = item->selectedIndex();
    return result;
}

void
webkit_dom_html_select_element_set_selected_index(WebKitDOMHTMLSelectElement* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self));
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    item->setSelectedIndex(value);
}

gchar*
webkit_dom_html_select_element_get_value(WebKitDOMHTMLSelectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self), 0);
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->value());
    return result;
}

void
webkit_dom_html_select_element_set_value(WebKitDOMHTMLSelectElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setValue(convertedValue);
}

gboolean
webkit_dom_html_select_element_get_will_validate(WebKitDOMHTMLSelectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self), FALSE);
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    gboolean result = item->willValidate();
    return result;
}

WebKitDOMValidityState*
webkit_dom_html_select_element_get_validity(WebKitDOMHTMLSelectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self), 0);
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    RefPtr<WebCore::ValidityState> gobjectResult = WTF::getPtr(item->validity());
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_html_select_element_get_validation_message(WebKitDOMHTMLSelectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self), 0);
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->validationMessage());
    return result;
}

WebKitDOMNodeList*
webkit_dom_html_select_element_get_labels(WebKitDOMHTMLSelectElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_SELECT_ELEMENT(self), 0);
    WebCore::HTMLSelectElement* item = WebKit::core(self);
    RefPtr<WebCore::NodeList> gobjectResult = WTF::getPtr(item->labels());
    return WebKit::kit(gobjectResult.get());
}

