/* sql.c generated by valac 0.26.1, the Vala compiler
 * generated from sql.vala, do not modify */

/* sql.vala
 *
 * Copyright © 2011-2012 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *             By Seif Lotfy <seif@lotfy.com>
 * Copyright © 2011 Manish Sinha <manishsinha@ubuntu.com>
 * Copyright © 2012 Canonical Ltd.
 *             By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>
#include "zeitgeist-datamodel.h"
#include <gio/gio.h>


#define ZEITGEIST_SQ_LITE_TYPE_EVENT_VIEW_ROWS (zeitgeist_sq_lite_event_view_rows_get_type ())

#define ZEITGEIST_SQ_LITE_TYPE_DATABASE (zeitgeist_sq_lite_database_get_type ())
#define ZEITGEIST_SQ_LITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE, ZeitgeistSQLiteDatabase))
#define ZEITGEIST_SQ_LITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_SQ_LITE_TYPE_DATABASE, ZeitgeistSQLiteDatabaseClass))
#define ZEITGEIST_SQ_LITE_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE))
#define ZEITGEIST_SQ_LITE_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_SQ_LITE_TYPE_DATABASE))
#define ZEITGEIST_SQ_LITE_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE, ZeitgeistSQLiteDatabaseClass))

typedef struct _ZeitgeistSQLiteDatabase ZeitgeistSQLiteDatabase;
typedef struct _ZeitgeistSQLiteDatabaseClass ZeitgeistSQLiteDatabaseClass;
typedef struct _ZeitgeistSQLiteDatabasePrivate ZeitgeistSQLiteDatabasePrivate;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _Block2Data Block2Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ID,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_TIMESTAMP,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_INTERPRETATION,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_MANIFESTATION,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ACTOR,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_PAYLOAD,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ID,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_INTERPRETATION,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MANIFESTATION,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MIMETYPE,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_TEXT,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE_STATE,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_EVENT_ORIGIN,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_EVENT_ORIGIN_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ID_CURRENT,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_TEXT_ID,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE_ID,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ACTOR_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_ORIGIN,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_ORIGIN_URI
} ZeitgeistSQLiteEventViewRows;

typedef void (*ZeitgeistSQLiteDeletionCallback) (const gchar* table, gint64 rowid, void* user_data);
struct _ZeitgeistSQLiteDatabase {
	GObject parent_instance;
	ZeitgeistSQLiteDatabasePrivate * priv;
	sqlite3_stmt* event_insertion_stmt;
	sqlite3_stmt* id_retrieval_stmt;
	sqlite3_stmt* move_handling_stmt;
	sqlite3_stmt* payload_insertion_stmt;
	sqlite3* database;
};

struct _ZeitgeistSQLiteDatabaseClass {
	GObjectClass parent_class;
};

struct _ZeitgeistSQLiteDatabasePrivate {
	ZeitgeistSQLiteDeletionCallback deletion_callback;
	gpointer deletion_callback_target;
	GDestroyNotify deletion_callback_target_destroy_notify;
	gboolean is_read_only;
};

struct _Block1Data {
	int _ref_count_;
	ZeitgeistSQLiteDatabase* self;
	gint last_id;
};

struct _Block2Data {
	int _ref_count_;
	ZeitgeistSQLiteDatabase* self;
	ZeitgeistTimeRange* time_range;
};


static gpointer zeitgeist_sq_lite_database_parent_class = NULL;

GType zeitgeist_sq_lite_event_view_rows_get_type (void) G_GNUC_CONST;
GType zeitgeist_sq_lite_database_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_SQ_LITE_DATABASE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_SQ_LITE_TYPE_DATABASE, ZeitgeistSQLiteDatabasePrivate))
enum  {
	ZEITGEIST_SQ_LITE_DATABASE_DUMMY_PROPERTY
};
#define ZEITGEIST_SQ_LITE_DATABASE_DEFAULT_OPEN_FLAGS (SQLITE_OPEN_READWRITE | SQLITE_OPEN_CREATE)
ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_new (GError** error);
ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_construct (GType object_type, GError** error);
static void zeitgeist_sq_lite_database_open_database (ZeitgeistSQLiteDatabase* self, gboolean retry, GError** error);
static void zeitgeist_sq_lite_database_prepare_read_queries (ZeitgeistSQLiteDatabase* self, GError** error);
static void zeitgeist_sq_lite_database_prepare_modification_queries (ZeitgeistSQLiteDatabase* self, GError** error);
void zeitgeist_sq_lite_database_update_callback (ZeitgeistSQLiteDatabase* self, int action, const gchar* dbname, const gchar* table, gint64 rowid);
static void _zeitgeist_sq_lite_database_update_callback_sqlite_update_callback (gpointer self, int action, const gchar* dbname, const gchar* table, gint64 rowid);
ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_new_read_only (GError** error);
ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_construct_read_only (GType object_type, GError** error);
gint zeitgeist_sq_lite_database_schema_get_schema_version (sqlite3* database, GError** error);
#define ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CORE_SCHEMA_VERSION 10
void zeitgeist_sq_lite_database_schema_ensure_schema (sqlite3* database, GError** error);
static void zeitgeist_sq_lite_database_retire_database (GError** error);
guint32 zeitgeist_sq_lite_database_get_last_id (ZeitgeistSQLiteDatabase* self, GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gint __lambda5_ (Block1Data* _data1_, gint n_columns, gchar** values, int values_length1, gchar** column_names, int column_names_length1);
static gint ___lambda5__sqlite3_callback (gpointer self, gint n_columns, gchar** values, gchar** column_names);
void zeitgeist_sq_lite_database_assert_query_success (ZeitgeistSQLiteDatabase* self, gint rc, const gchar* msg, gint success_code, GError** error);
void zeitgeist_sq_lite_database_set_deletion_callback (ZeitgeistSQLiteDatabase* self, ZeitgeistSQLiteDeletionCallback callback, void* callback_target, GDestroyNotify callback_target_destroy_notify);
gchar* zeitgeist_sq_lite_database_get_sql_string_from_event_ids (ZeitgeistSQLiteDatabase* self, guint32* event_ids, int event_ids_length1);
ZeitgeistTimeRange* zeitgeist_sq_lite_database_get_time_range_for_event_ids (ZeitgeistSQLiteDatabase* self, guint32* event_ids, int event_ids_length1, GError** error);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gint __lambda6_ (Block2Data* _data2_, gint n_columns, gchar** values, int values_length1, gchar** column_names, int column_names_length1);
static gint ___lambda6__sqlite3_callback (gpointer self, gint n_columns, gchar** values, gchar** column_names);
void zeitgeist_sq_lite_database_insert_or_ignore_into_table (ZeitgeistSQLiteDatabase* self, const gchar* table_name, GPtrArray* values, GError** error);
void zeitgeist_sq_lite_database_begin_transaction (ZeitgeistSQLiteDatabase* self, GError** error);
void zeitgeist_sq_lite_database_end_transaction (ZeitgeistSQLiteDatabase* self, GError** error);
void zeitgeist_sq_lite_database_abort_transaction (ZeitgeistSQLiteDatabase* self, GError** error);
void zeitgeist_sq_lite_database_close (ZeitgeistSQLiteDatabase* self);
void zeitgeist_sq_lite_database_assert_not_corrupt (ZeitgeistSQLiteDatabase* self, gint rc, GError** error);
void zeitgeist_sq_lite_database_schema_set_corruption_flag (sqlite3* database, GError** error);
gboolean zeitgeist_sq_lite_database_analyze (ZeitgeistSQLiteDatabase* self, GError** error);
void zeitgeist_sq_lite_database_set_cache_size (ZeitgeistSQLiteDatabase* self, gint size);
void zeitgeist_sq_lite_database_schema_exec_query (sqlite3* database, const gchar* sql, GError** error);
static void zeitgeist_sq_lite_database_finalize (GObject* obj);


GType zeitgeist_sq_lite_event_view_rows_get_type (void) {
	static volatile gsize zeitgeist_sq_lite_event_view_rows_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_sq_lite_event_view_rows_type_id__volatile)) {
		static const GEnumValue values[] = {{ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ID, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ID", "id"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_TIMESTAMP, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_TIMESTAMP", "timestamp"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_INTERPRETATION, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_INTERPRETATION", "interpretation"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_MANIFESTATION, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_MANIFESTATION", "manifestation"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ACTOR, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ACTOR", "actor"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_PAYLOAD, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_PAYLOAD", "payload"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_URI, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_URI", "subject-uri"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ID, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ID", "subject-id"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_INTERPRETATION, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_INTERPRETATION", "subject-interpretation"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MANIFESTATION, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MANIFESTATION", "subject-manifestation"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN", "subject-origin"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN_URI, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN_URI", "subject-origin-uri"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MIMETYPE, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MIMETYPE", "subject-mimetype"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_TEXT, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_TEXT", "subject-text"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE", "subject-storage"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE_STATE, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE_STATE", "subject-storage-state"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_EVENT_ORIGIN, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_EVENT_ORIGIN", "event-origin"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_EVENT_ORIGIN_URI, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_EVENT_ORIGIN_URI", "event-origin-uri"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_URI, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_URI", "subject-current-uri"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ID_CURRENT, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ID_CURRENT", "subject-id-current"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_TEXT_ID, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_TEXT_ID", "subject-text-id"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE_ID, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE_ID", "subject-storage-id"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ACTOR_URI, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ACTOR_URI", "actor-uri"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_ORIGIN, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_ORIGIN", "subject-current-origin"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_ORIGIN_URI, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_ORIGIN_URI", "subject-current-origin-uri"}, {0, NULL, NULL}};
		GType zeitgeist_sq_lite_event_view_rows_type_id;
		zeitgeist_sq_lite_event_view_rows_type_id = g_enum_register_static ("ZeitgeistSQLiteEventViewRows", values);
		g_once_init_leave (&zeitgeist_sq_lite_event_view_rows_type_id__volatile, zeitgeist_sq_lite_event_view_rows_type_id);
	}
	return zeitgeist_sq_lite_event_view_rows_type_id__volatile;
}


static void _zeitgeist_sq_lite_database_update_callback_sqlite_update_callback (gpointer self, int action, const gchar* dbname, const gchar* table, gint64 rowid) {
	zeitgeist_sq_lite_database_update_callback ((ZeitgeistSQLiteDatabase*) self, action, dbname, table, rowid);
}


ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_construct (GType object_type, GError** error) {
	ZeitgeistSQLiteDatabase * self = NULL;
	sqlite3* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	self = (ZeitgeistSQLiteDatabase*) g_object_new (object_type, NULL);
	zeitgeist_sq_lite_database_open_database (self, TRUE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	zeitgeist_sq_lite_database_prepare_read_queries (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	zeitgeist_sq_lite_database_prepare_modification_queries (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = self->database;
	sqlite3_update_hook (_tmp0_, _zeitgeist_sq_lite_database_update_callback_sqlite_update_callback, self);
	return self;
}


ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_new (GError** error) {
	return zeitgeist_sq_lite_database_construct (ZEITGEIST_SQ_LITE_TYPE_DATABASE, error);
}


ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_construct_read_only (GType object_type, GError** error) {
	ZeitgeistSQLiteDatabase * self = NULL;
	sqlite3* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	self = (ZeitgeistSQLiteDatabase*) g_object_new (object_type, NULL);
	self->priv->is_read_only = TRUE;
	zeitgeist_sq_lite_database_open_database (self, FALSE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	zeitgeist_sq_lite_database_prepare_read_queries (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = self->database;
	sqlite3_update_hook (_tmp0_, _zeitgeist_sq_lite_database_update_callback_sqlite_update_callback, self);
	return self;
}


ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_new_read_only (GError** error) {
	return zeitgeist_sq_lite_database_construct_read_only (ZEITGEIST_SQ_LITE_TYPE_DATABASE, error);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void zeitgeist_sq_lite_database_open_database (ZeitgeistSQLiteDatabase* self, gboolean retry, GError** error) {
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gint flags = 0;
	gint rc = 0;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	sqlite3* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp20_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->is_read_only;
	if (_tmp1_) {
		_tmp0_ = SQLITE_OPEN_READONLY;
	} else {
		_tmp0_ = ZEITGEIST_SQ_LITE_DATABASE_DEFAULT_OPEN_FLAGS;
	}
	flags = _tmp0_;
	_tmp2_ = zeitgeist_utils_get_database_file_path ();
	_tmp3_ = flags;
	_tmp5_ = sqlite3_open_v2 (_tmp2_, &_tmp4_, _tmp3_, NULL);
	_sqlite3_close0 (self->database);
	self->database = _tmp4_;
	rc = _tmp5_;
	_tmp6_ = rc;
	if (_tmp6_ == SQLITE_OK) {
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = self->priv->is_read_only;
			if (_tmp7_) {
				gint ver = 0;
				sqlite3* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				_tmp8_ = self->database;
				_tmp9_ = zeitgeist_sq_lite_database_schema_get_schema_version (_tmp8_, &_inner_error_);
				ver = _tmp9_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						goto __catch2_zeitgeist_engine_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp10_ = ver;
				if (_tmp10_ < ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CORE_SCHEMA_VERSION) {
					GError* _tmp11_ = NULL;
					_tmp11_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN, "Unable to open database: old schema version");
					_inner_error_ = _tmp11_;
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						goto __catch2_zeitgeist_engine_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			} else {
				sqlite3* _tmp12_ = NULL;
				_tmp12_ = self->database;
				zeitgeist_sq_lite_database_schema_ensure_schema (_tmp12_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						goto __catch2_zeitgeist_engine_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		goto __finally2;
		__catch2_zeitgeist_engine_error:
		{
			GError* err = NULL;
			gboolean _tmp13_ = FALSE;
			GError* _tmp14_ = NULL;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp14_ = err;
			if (g_error_matches (_tmp14_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CORRUPT)) {
				gboolean _tmp15_ = FALSE;
				_tmp15_ = retry;
				_tmp13_ = _tmp15_;
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				rc = SQLITE_CORRUPT;
			} else {
				GError* _tmp16_ = NULL;
				_tmp16_ = err;
				if (g_error_matches (_tmp16_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN)) {
					rc = SQLITE_CANTOPEN;
				} else {
					GError* _tmp17_ = NULL;
					_tmp17_ = err;
					if (g_error_matches (_tmp17_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_BUSY)) {
						rc = SQLITE_BUSY;
					} else {
						GError* _tmp18_ = NULL;
						GError* _tmp19_ = NULL;
						_tmp18_ = err;
						_tmp19_ = _g_error_copy0 (_tmp18_);
						_inner_error_ = _tmp19_;
						_g_error_free0 (err);
						goto __finally2;
					}
				}
			}
			_g_error_free0 (err);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_tmp20_ = rc;
	if (_tmp20_ != SQLITE_OK) {
		gboolean _tmp21_ = FALSE;
		gint _tmp22_ = 0;
		_tmp22_ = rc;
		if (_tmp22_ == SQLITE_CORRUPT) {
			gboolean _tmp23_ = FALSE;
			_tmp23_ = retry;
			_tmp21_ = _tmp23_;
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			g_warning ("sql.vala:150: %s", "It looks like your database is corrupt. " "It will be renamed and a new one will be created.");
			zeitgeist_sq_lite_database_retire_database (&_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			zeitgeist_sq_lite_database_open_database (self, FALSE, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		} else {
			gboolean _tmp24_ = FALSE;
			gint _tmp25_ = 0;
			_tmp25_ = rc;
			if (_tmp25_ == SQLITE_PERM) {
				_tmp24_ = TRUE;
			} else {
				gint _tmp26_ = 0;
				_tmp26_ = rc;
				_tmp24_ = _tmp26_ == SQLITE_CANTOPEN;
			}
			if (_tmp24_) {
				sqlite3* _tmp27_ = NULL;
				const gchar* _tmp28_ = NULL;
				GError* _tmp29_ = NULL;
				_tmp27_ = self->database;
				_tmp28_ = sqlite3_errmsg (_tmp27_);
				_tmp29_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN, _tmp28_);
				_inner_error_ = _tmp29_;
				if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			} else {
				gint _tmp30_ = 0;
				_tmp30_ = rc;
				if (_tmp30_ == SQLITE_BUSY) {
					sqlite3* _tmp31_ = NULL;
					const gchar* _tmp32_ = NULL;
					GError* _tmp33_ = NULL;
					_tmp31_ = self->database;
					_tmp32_ = sqlite3_errmsg (_tmp31_);
					_tmp33_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_BUSY, _tmp32_);
					_inner_error_ = _tmp33_;
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				} else {
					gchar* message = NULL;
					gint _tmp34_ = 0;
					sqlite3* _tmp35_ = NULL;
					const gchar* _tmp36_ = NULL;
					gchar* _tmp37_ = NULL;
					const gchar* _tmp38_ = NULL;
					GError* _tmp39_ = NULL;
					_tmp34_ = rc;
					_tmp35_ = self->database;
					_tmp36_ = sqlite3_errmsg (_tmp35_);
					_tmp37_ = g_strdup_printf ("Can't open database: %d, %s", _tmp34_, _tmp36_);
					message = _tmp37_;
					_tmp38_ = message;
					_tmp39_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR, _tmp38_);
					_inner_error_ = _tmp39_;
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (message);
						return;
					} else {
						_g_free0 (message);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_free0 (message);
				}
			}
		}
	}
}


static void zeitgeist_sq_lite_database_retire_database (GError** error) {
	GError * _inner_error_ = NULL;
	{
		GFile* dbfile = NULL;
		const gchar* _tmp0_ = NULL;
		GFile* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		_tmp0_ = zeitgeist_utils_get_database_file_path ();
		_tmp1_ = g_file_new_for_path (_tmp0_);
		dbfile = _tmp1_;
		_tmp2_ = dbfile;
		_tmp3_ = zeitgeist_utils_get_database_file_retire_name ();
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_set_display_name (_tmp2_, _tmp4_, NULL, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp6_);
		_g_free0 (_tmp4_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (dbfile);
			goto __catch3_g_error;
		}
		_g_object_unref0 (dbfile);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* err = NULL;
		gchar* message = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = err;
		_tmp8_ = _tmp7_->message;
		_tmp9_ = g_strdup_printf ("Could not rename database: %s", _tmp8_);
		message = _tmp9_;
		_tmp10_ = message;
		_tmp11_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_RETIRE_FAILED, _tmp10_);
		_inner_error_ = _tmp11_;
		_g_free0 (message);
		_g_error_free0 (err);
		goto __finally3;
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ZeitgeistSQLiteDatabase* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gint _sqlite3_exec (sqlite3* self, const gchar* sql, sqlite3_callback callback, void* callback_target, gchar** errmsg) {
	gchar* _vala_errmsg = NULL;
	gint result = 0;
	const gchar* sqlite_errmsg = NULL;
	gint ec = 0;
	const gchar* _tmp0_ = NULL;
	sqlite3_callback _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	const gchar* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = sql;
	_tmp1_ = callback;
	_tmp1__target = callback_target;
	_tmp3_ = sqlite3_exec (self, _tmp0_, _tmp1_, _tmp1__target, (char**) (&_tmp2_));
	sqlite_errmsg = _tmp2_;
	ec = _tmp3_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp4_ = sqlite_errmsg;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp5_;
	}
	_tmp6_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp6_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}


static gint __lambda5_ (Block1Data* _data1_, gint n_columns, gchar** values, int values_length1, gchar** column_names, int column_names_length1) {
	ZeitgeistSQLiteDatabase* self;
	gint result = 0;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	const gchar* _tmp1_ = NULL;
	self = _data1_->self;
	_tmp0_ = values;
	_tmp0__length1 = values_length1;
	_tmp1_ = _tmp0_[0];
	if (_tmp1_ == NULL) {
		_data1_->last_id = 0;
	} else {
		gchar** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		_tmp2_ = values;
		_tmp2__length1 = values_length1;
		_tmp3_ = _tmp2_[0];
		_tmp4_ = atoi (_tmp3_);
		_data1_->last_id = _tmp4_;
	}
	result = 0;
	return result;
}


static gint ___lambda5__sqlite3_callback (gpointer self, gint n_columns, gchar** values, gchar** column_names) {
	gint result;
	result = __lambda5_ (self, n_columns, values, -1, column_names, -1);
	return result;
}


guint32 zeitgeist_sq_lite_database_get_last_id (ZeitgeistSQLiteDatabase* self, GError** error) {
	guint32 result = 0U;
	Block1Data* _data1_;
	gint rc = 0;
	sqlite3* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->last_id = -1;
	_tmp0_ = self->database;
	_tmp1_ = _sqlite3_exec (_tmp0_, "SELECT MAX(id) FROM event", ___lambda5__sqlite3_callback, _data1_, NULL);
	rc = _tmp1_;
	zeitgeist_sq_lite_database_assert_query_success (self, rc, "sql.vala:204: Can't query database", SQLITE_OK, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return 0U;
		} else {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0U;
		}
	}
	_vala_assert (_data1_->last_id != (-1), "last_id != -1");
	result = (guint32) _data1_->last_id;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


void zeitgeist_sq_lite_database_set_deletion_callback (ZeitgeistSQLiteDatabase* self, ZeitgeistSQLiteDeletionCallback callback, void* callback_target, GDestroyNotify callback_target_destroy_notify) {
	ZeitgeistSQLiteDeletionCallback _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GDestroyNotify _tmp0__target_destroy_notify = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = callback;
	_tmp0__target = callback_target;
	_tmp0__target_destroy_notify = callback_target_destroy_notify;
	callback_target_destroy_notify = NULL;
	(self->priv->deletion_callback_target_destroy_notify == NULL) ? NULL : (self->priv->deletion_callback_target_destroy_notify (self->priv->deletion_callback_target), NULL);
	self->priv->deletion_callback = NULL;
	self->priv->deletion_callback_target = NULL;
	self->priv->deletion_callback_target_destroy_notify = NULL;
	self->priv->deletion_callback = _tmp0_;
	self->priv->deletion_callback_target = _tmp0__target;
	self->priv->deletion_callback_target_destroy_notify = _tmp0__target_destroy_notify;
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
}


/**
         * Join all given event_ids into a comma-separated string suitable
         * for use in a SQL query like "WHERE id IN (...)".
         */
gchar* zeitgeist_sq_lite_database_get_sql_string_from_event_ids (ZeitgeistSQLiteDatabase* self, guint32* event_ids, int event_ids_length1) {
	gchar* result = NULL;
	guint32* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GString* sql_condition = NULL;
	GString* _tmp1_ = NULL;
	GString* _tmp2_ = NULL;
	guint32* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint32 _tmp4_ = 0U;
	GString* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = event_ids;
	_tmp0__length1 = event_ids_length1;
	g_return_val_if_fail (_tmp0__length1 > 0, NULL);
	_tmp1_ = g_string_new ("");
	sql_condition = _tmp1_;
	_tmp2_ = sql_condition;
	_tmp3_ = event_ids;
	_tmp3__length1 = event_ids_length1;
	_tmp4_ = _tmp3_[0];
	g_string_append_printf (_tmp2_, "%u", (guint) _tmp4_);
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_ = 0;
				guint32* _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				GString* _tmp9_ = NULL;
				guint32* _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				gint _tmp11_ = 0;
				guint32 _tmp12_ = 0U;
				if (!_tmp5_) {
					gint _tmp6_ = 0;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = event_ids;
				_tmp8__length1 = event_ids_length1;
				if (!(_tmp7_ < _tmp8__length1)) {
					break;
				}
				_tmp9_ = sql_condition;
				_tmp10_ = event_ids;
				_tmp10__length1 = event_ids_length1;
				_tmp11_ = i;
				_tmp12_ = _tmp10_[_tmp11_];
				g_string_append_printf (_tmp9_, ", %u", (guint) _tmp12_);
			}
		}
	}
	_tmp13_ = sql_condition;
	_tmp14_ = _tmp13_->str;
	_tmp15_ = g_strdup (_tmp14_);
	result = _tmp15_;
	_g_string_free0 (sql_condition);
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ZeitgeistSQLiteDatabase* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->time_range);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static gint __lambda6_ (Block2Data* _data2_, gint n_columns, gchar** values, int values_length1, gchar** column_names, int column_names_length1) {
	ZeitgeistSQLiteDatabase* self;
	gint result = 0;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	const gchar* _tmp1_ = NULL;
	self = _data2_->self;
	_tmp0_ = values;
	_tmp0__length1 = values_length1;
	_tmp1_ = _tmp0_[0];
	if (_tmp1_ != NULL) {
		gint64 start = 0LL;
		gchar** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		const gchar* _tmp3_ = NULL;
		gint64 _tmp4_ = 0LL;
		gint64 end = 0LL;
		gchar** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		const gchar* _tmp6_ = NULL;
		gint64 _tmp7_ = 0LL;
		gint64 _tmp8_ = 0LL;
		gint64 _tmp9_ = 0LL;
		ZeitgeistTimeRange* _tmp10_ = NULL;
		_tmp2_ = values;
		_tmp2__length1 = values_length1;
		_tmp3_ = _tmp2_[0];
		_tmp4_ = int64_parse (_tmp3_);
		start = _tmp4_;
		_tmp5_ = values;
		_tmp5__length1 = values_length1;
		_tmp6_ = _tmp5_[1];
		_tmp7_ = int64_parse (_tmp6_);
		end = _tmp7_;
		_tmp8_ = start;
		_tmp9_ = end;
		_tmp10_ = zeitgeist_time_range_new (_tmp8_, _tmp9_);
		_g_object_unref0 (_data2_->time_range);
		_data2_->time_range = _tmp10_;
	}
	result = 0;
	return result;
}


static gint ___lambda6__sqlite3_callback (gpointer self, gint n_columns, gchar** values, gchar** column_names) {
	gint result;
	result = __lambda6_ (self, n_columns, values, -1, column_names, -1);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


ZeitgeistTimeRange* zeitgeist_sq_lite_database_get_time_range_for_event_ids (ZeitgeistSQLiteDatabase* self, guint32* event_ids, int event_ids_length1, GError** error) {
	ZeitgeistTimeRange* result = NULL;
	Block2Data* _data2_;
	guint32* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar* sql = NULL;
	guint32* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint rc = 0;
	sqlite3* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	ZeitgeistTimeRange* _tmp10_ = NULL;
	ZeitgeistTimeRange* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = event_ids;
	_tmp0__length1 = event_ids_length1;
	if (_tmp0__length1 == 0) {
		result = NULL;
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return result;
	}
	_tmp1_ = event_ids;
	_tmp1__length1 = event_ids_length1;
	_tmp2_ = zeitgeist_sq_lite_database_get_sql_string_from_event_ids (self, _tmp1_, _tmp1__length1);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("\n" \
"                SELECT MIN(timestamp), MAX(timestamp)\n" \
"                FROM event\n" \
"                WHERE id IN (%s)\n" \
"                ", _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	sql = _tmp5_;
	_data2_->time_range = NULL;
	_tmp6_ = self->database;
	_tmp7_ = sql;
	_tmp8_ = _sqlite3_exec (_tmp6_, _tmp7_, ___lambda6__sqlite3_callback, _data2_, NULL);
	rc = _tmp8_;
	_tmp9_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (self, _tmp9_, "sql.vala:253: SQL Error", SQLITE_OK, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			return NULL;
		} else {
			_g_free0 (sql);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp10_ = _data2_->time_range;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	result = _tmp11_;
	_g_free0 (sql);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


void zeitgeist_sq_lite_database_insert_or_ignore_into_table (ZeitgeistSQLiteDatabase* self, const gchar* table_name, GPtrArray* values, GError** error) {
	GPtrArray* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint rc = 0;
	GString* sql = NULL;
	GString* _tmp3_ = NULL;
	GString* _tmp4_ = NULL;
	GString* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GString* _tmp7_ = NULL;
	sqlite3_stmt* stmt = NULL;
	sqlite3* _tmp15_ = NULL;
	GString* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	sqlite3_stmt* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	sqlite3_stmt* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (table_name != NULL);
	g_return_if_fail (values != NULL);
	_tmp0_ = values;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		return;
	}
	_tmp3_ = g_string_new ("");
	sql = _tmp3_;
	_tmp4_ = sql;
	g_string_append (_tmp4_, "INSERT OR IGNORE INTO ");
	_tmp5_ = sql;
	_tmp6_ = table_name;
	g_string_append (_tmp5_, _tmp6_);
	_tmp7_ = sql;
	g_string_append (_tmp7_, " (value) SELECT ?");
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gint _tmp10_ = 0;
				GPtrArray* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				GString* _tmp14_ = NULL;
				if (!_tmp8_) {
					gint _tmp9_ = 0;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = i;
				_tmp11_ = values;
				_tmp12_ = g_ptr_array_get_length (_tmp11_);
				_tmp13_ = _tmp12_;
				if (!(_tmp10_ < _tmp13_)) {
					break;
				}
				_tmp14_ = sql;
				g_string_append (_tmp14_, " UNION SELECT ?");
			}
		}
	}
	_tmp15_ = self->database;
	_tmp16_ = sql;
	_tmp17_ = _tmp16_->str;
	_tmp19_ = sqlite3_prepare_v2 (_tmp15_, _tmp17_, -1, &_tmp18_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp18_;
	rc = _tmp19_;
	_tmp20_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (self, _tmp20_, "sql.vala:275: SQL error", SQLITE_OK, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_sqlite3_finalize0 (stmt);
			_g_string_free0 (sql);
			return;
		} else {
			_sqlite3_finalize0 (stmt);
			_g_string_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp21_ = FALSE;
			_tmp21_ = TRUE;
			while (TRUE) {
				gint _tmp23_ = 0;
				GPtrArray* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
				sqlite3_stmt* _tmp27_ = NULL;
				gint _tmp28_ = 0;
				GPtrArray* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				gconstpointer _tmp31_ = NULL;
				gchar* _tmp32_ = NULL;
				GDestroyNotify _tmp33_ = NULL;
				if (!_tmp21_) {
					gint _tmp22_ = 0;
					_tmp22_ = i;
					i = _tmp22_ + 1;
				}
				_tmp21_ = FALSE;
				_tmp23_ = i;
				_tmp24_ = values;
				_tmp25_ = g_ptr_array_get_length (_tmp24_);
				_tmp26_ = _tmp25_;
				if (!(_tmp23_ < _tmp26_)) {
					break;
				}
				_tmp27_ = stmt;
				_tmp28_ = i;
				_tmp29_ = values;
				_tmp30_ = i;
				_tmp31_ = g_ptr_array_index (_tmp29_, (guint) _tmp30_);
				_tmp32_ = g_strdup ((const gchar*) _tmp31_);
				_tmp33_ = g_free;
				sqlite3_bind_text (_tmp27_, _tmp28_ + 1, _tmp32_, -1, _tmp33_);
			}
		}
	}
	_tmp34_ = stmt;
	_tmp35_ = sqlite3_step (_tmp34_);
	rc = _tmp35_;
	_tmp36_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (self, _tmp36_, "SQL error", SQLITE_DONE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_sqlite3_finalize0 (stmt);
			_g_string_free0 (sql);
			return;
		} else {
			_sqlite3_finalize0 (stmt);
			_g_string_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_sqlite3_finalize0 (stmt);
	_g_string_free0 (sql);
}


void zeitgeist_sq_lite_database_begin_transaction (ZeitgeistSQLiteDatabase* self, GError** error) {
	gint rc = 0;
	sqlite3* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->database;
	_tmp1_ = _sqlite3_exec (_tmp0_, "BEGIN", NULL, NULL, NULL);
	rc = _tmp1_;
	zeitgeist_sq_lite_database_assert_query_success (self, rc, "sql.vala:287: Can't start transaction", SQLITE_OK, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void zeitgeist_sq_lite_database_end_transaction (ZeitgeistSQLiteDatabase* self, GError** error) {
	gint rc = 0;
	sqlite3* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->database;
	_tmp1_ = _sqlite3_exec (_tmp0_, "COMMIT", NULL, NULL, NULL);
	rc = _tmp1_;
	zeitgeist_sq_lite_database_assert_query_success (self, rc, "sql.vala:293: Can't commit transaction", SQLITE_OK, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void zeitgeist_sq_lite_database_abort_transaction (ZeitgeistSQLiteDatabase* self, GError** error) {
	gint rc = 0;
	sqlite3* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->database;
	_tmp1_ = _sqlite3_exec (_tmp0_, "ROLLBACK", NULL, NULL, NULL);
	rc = _tmp1_;
	zeitgeist_sq_lite_database_assert_query_success (self, rc, "sql.vala:299: Can't rollback transaction", SQLITE_OK, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void zeitgeist_sq_lite_database_close (ZeitgeistSQLiteDatabase* self) {
	g_return_if_fail (self != NULL);
	_sqlite3_close0 (self->database);
	self->database = NULL;
}


/**
         * Ensure `rc' is SQLITE_OK. If it isn't, print an error message
         * and throw an error.
         *
         * @param rc error code returned by a SQLite call
         * @param msg message to print if `rc' indicates an error
         * @throws EngineError err
         */
void zeitgeist_sq_lite_database_assert_query_success (ZeitgeistSQLiteDatabase* self, gint rc, const gchar* msg, gint success_code, GError** error) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = rc;
	_tmp1_ = success_code;
	_tmp2_ = G_UNLIKELY (_tmp0_ != _tmp1_);
	if (_tmp2_) {
		gchar* error_message = NULL;
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		sqlite3* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		const gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		_tmp3_ = msg;
		_tmp4_ = rc;
		_tmp5_ = self->database;
		_tmp6_ = sqlite3_errmsg (_tmp5_);
		_tmp7_ = g_strdup_printf ("%s: %d, %s", _tmp3_, _tmp4_, _tmp6_);
		error_message = _tmp7_;
		_tmp8_ = error_message;
		g_warning ("sql.vala:350: %s\n", _tmp8_);
		_tmp9_ = rc;
		zeitgeist_sq_lite_database_assert_not_corrupt (self, _tmp9_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (error_message);
				return;
			} else {
				_g_free0 (error_message);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp10_ = error_message;
		_tmp11_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR, _tmp10_);
		_inner_error_ = _tmp11_;
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (error_message);
			return;
		} else {
			_g_free0 (error_message);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (error_message);
	}
}


/**
         * Ensure `rc' isn't SQLITE_CORRUPT. If it is, schedule a database
         * retire and Zeitgeist restart so a new database can be created,
         * unless in read-only mode, in which case EngineError.DATABASE_ERROR
         * will be thrown.
         *
         * This function should be called whenever assert_query_success isn't
         * used.
         *
         * @param rc error code returned by a SQLite call
         */
void zeitgeist_sq_lite_database_assert_not_corrupt (ZeitgeistSQLiteDatabase* self, gint rc, GError** error) {
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = rc;
	_tmp1_ = G_UNLIKELY (_tmp0_ == SQLITE_CORRUPT);
	if (_tmp1_) {
		sqlite3* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		sqlite3* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GError* _tmp10_ = NULL;
		_tmp2_ = self->database;
		_tmp3_ = sqlite3_errmsg (_tmp2_);
		_tmp4_ = g_strdup_printf ("It looks like your database is corrupt: %s", _tmp3_);
		_tmp5_ = _tmp4_;
		g_warning ("sql.vala:372: %s", _tmp5_);
		_g_free0 (_tmp5_);
		_tmp6_ = self->priv->is_read_only;
		if (!_tmp6_) {
			sqlite3* _tmp7_ = NULL;
			_tmp7_ = self->database;
			zeitgeist_sq_lite_database_schema_set_corruption_flag (_tmp7_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		_tmp8_ = self->database;
		_tmp9_ = sqlite3_errmsg (_tmp8_);
		_tmp10_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CORRUPT, _tmp9_);
		_inner_error_ = _tmp10_;
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void zeitgeist_sq_lite_database_prepare_read_queries (ZeitgeistSQLiteDatabase* self, GError** error) {
	gint rc = 0;
	gchar* sql = NULL;
	gchar* _tmp0_ = NULL;
	sqlite3* _tmp1_ = NULL;
	sqlite3_stmt* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("\n" \
"                SELECT id FROM event\n" \
"                WHERE timestamp=? AND interpretation=? AND\n" \
"                    manifestation=? AND actor=?\n" \
"                ");
	_g_free0 (sql);
	sql = _tmp0_;
	_tmp1_ = self->database;
	_tmp3_ = sqlite3_prepare_v2 (_tmp1_, sql, -1, &_tmp2_, NULL);
	_sqlite3_finalize0 (self->id_retrieval_stmt);
	self->id_retrieval_stmt = _tmp2_;
	rc = _tmp3_;
	zeitgeist_sq_lite_database_assert_query_success (self, rc, "sql.vala:397: Event ID retrieval query error", SQLITE_OK, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (sql);
}


static void zeitgeist_sq_lite_database_prepare_modification_queries (ZeitgeistSQLiteDatabase* self, GError** error) {
	gint rc = 0;
	gchar* sql = NULL;
	gchar* _tmp0_ = NULL;
	sqlite3* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
	sqlite3* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	sqlite3_stmt* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gchar* _tmp12_ = NULL;
	sqlite3* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	sqlite3_stmt* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("\n" \
"                INSERT INTO event (\n" \
"                    id, timestamp, interpretation, manifestation, acto" \
"r,\n" \
"                    origin, payload, subj_id, subj_id_current,\n" \
"                    subj_interpretation, subj_manifestation, subj_orig" \
"in,\n" \
"                    subj_origin_current, subj_mimetype, subj_text, sub" \
"j_storage\n" \
"                ) VALUES (\n" \
"                    ?, ?, ?, ?, ?,\n" \
"                    (SELECT id FROM uri WHERE value=?),\n" \
"                    ?,\n" \
"                    (SELECT id FROM uri WHERE value=?),\n" \
"                    (SELECT id FROM uri WHERE value=?),\n" \
"                    ?, ?,\n" \
"                    (SELECT id FROM uri WHERE value=?),\n" \
"                    (SELECT id FROM uri WHERE value=?),\n" \
"                    ?,\n" \
"                    (SELECT id FROM text WHERE value=?),\n" \
"                    (SELECT id FROM storage WHERE value=?)\n" \
"                )");
	_g_free0 (sql);
	sql = _tmp0_;
	_tmp1_ = self->database;
	_tmp2_ = sql;
	_tmp4_ = sqlite3_prepare_v2 (_tmp1_, _tmp2_, -1, &_tmp3_, NULL);
	_sqlite3_finalize0 (self->event_insertion_stmt);
	self->event_insertion_stmt = _tmp3_;
	rc = _tmp4_;
	_tmp5_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (self, _tmp5_, "sql.vala:427: Insertion query error", SQLITE_OK, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp6_ = g_strdup ("\n" \
"            UPDATE event\n" \
"                SET subj_id_current=(SELECT id FROM uri WHERE value=?)" \
"\n" \
"                ,   subj_origin_current=(SELECT id FROM uri WHERE valu" \
"e=?)\n" \
"                    WHERE subj_id_current=(SELECT id FROM uri WHERE va" \
"lue=?)\n" \
"                    AND interpretation!=? AND timestamp<?\n" \
"            ");
	_g_free0 (sql);
	sql = _tmp6_;
	_tmp7_ = self->database;
	_tmp8_ = sql;
	_tmp10_ = sqlite3_prepare_v2 (_tmp7_, _tmp8_, -1, &_tmp9_, NULL);
	_sqlite3_finalize0 (self->move_handling_stmt);
	self->move_handling_stmt = _tmp9_;
	rc = _tmp10_;
	_tmp11_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (self, _tmp11_, "sql.vala:438: Move handling error", SQLITE_OK, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp12_ = g_strdup ("\n" \
"                INSERT INTO payload (value) VALUES (?)\n" \
"            ");
	_g_free0 (sql);
	sql = _tmp12_;
	_tmp13_ = self->database;
	_tmp14_ = sql;
	_tmp16_ = sqlite3_prepare_v2 (_tmp13_, _tmp14_, -1, &_tmp15_, NULL);
	_sqlite3_finalize0 (self->payload_insertion_stmt);
	self->payload_insertion_stmt = _tmp15_;
	rc = _tmp16_;
	_tmp17_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (self, _tmp17_, "sql.vala:445: Payload insertion query error", SQLITE_OK, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (sql);
}


gboolean zeitgeist_sq_lite_database_analyze (ZeitgeistSQLiteDatabase* self, GError** error) {
	gboolean result = FALSE;
	gint rc = 0;
	sqlite3* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->database;
	_tmp1_ = _sqlite3_exec (_tmp0_, "ANALYZE", NULL, NULL, NULL);
	rc = _tmp1_;
	zeitgeist_sq_lite_database_assert_query_success (self, rc, "sql.vala:451: Event ID retrieval query error", SQLITE_OK, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = FALSE;
	return result;
}


void zeitgeist_sq_lite_database_set_cache_size (ZeitgeistSQLiteDatabase* self, gint size) {
	sqlite3* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->database;
	_tmp1_ = size;
	_tmp2_ = g_strdup_printf ("PRAGMA cache_size = %i", _tmp1_);
	_tmp3_ = _tmp2_;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp0_, _tmp3_, &_inner_error_);
	_g_free0 (_tmp3_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void zeitgeist_sq_lite_database_update_callback (ZeitgeistSQLiteDatabase* self, int action, const gchar* dbname, const gchar* table, gint64 rowid) {
	int _tmp0_ = 0;
	ZeitgeistSQLiteDeletionCallback _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dbname != NULL);
	g_return_if_fail (table != NULL);
	_tmp0_ = action;
	if (_tmp0_ != SQLITE_DELETE) {
		return;
	}
	_tmp1_ = self->priv->deletion_callback;
	_tmp1__target = self->priv->deletion_callback_target;
	if (_tmp1_ != NULL) {
		ZeitgeistSQLiteDeletionCallback _tmp2_ = NULL;
		void* _tmp2__target = NULL;
		const gchar* _tmp3_ = NULL;
		gint64 _tmp4_ = 0LL;
		_tmp2_ = self->priv->deletion_callback;
		_tmp2__target = self->priv->deletion_callback_target;
		_tmp3_ = table;
		_tmp4_ = rowid;
		_tmp2_ (_tmp3_, _tmp4_, _tmp2__target);
	}
}


static void zeitgeist_sq_lite_database_class_init (ZeitgeistSQLiteDatabaseClass * klass) {
	zeitgeist_sq_lite_database_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistSQLiteDatabasePrivate));
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_sq_lite_database_finalize;
}


static void zeitgeist_sq_lite_database_instance_init (ZeitgeistSQLiteDatabase * self) {
	self->priv = ZEITGEIST_SQ_LITE_DATABASE_GET_PRIVATE (self);
	self->priv->deletion_callback = NULL;
	self->priv->is_read_only = FALSE;
}


static void zeitgeist_sq_lite_database_finalize (GObject* obj) {
	ZeitgeistSQLiteDatabase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_SQ_LITE_TYPE_DATABASE, ZeitgeistSQLiteDatabase);
	_sqlite3_finalize0 (self->event_insertion_stmt);
	_sqlite3_finalize0 (self->id_retrieval_stmt);
	_sqlite3_finalize0 (self->move_handling_stmt);
	_sqlite3_finalize0 (self->payload_insertion_stmt);
	_sqlite3_close0 (self->database);
	(self->priv->deletion_callback_target_destroy_notify == NULL) ? NULL : (self->priv->deletion_callback_target_destroy_notify (self->priv->deletion_callback_target), NULL);
	self->priv->deletion_callback = NULL;
	self->priv->deletion_callback_target = NULL;
	self->priv->deletion_callback_target_destroy_notify = NULL;
	G_OBJECT_CLASS (zeitgeist_sq_lite_database_parent_class)->finalize (obj);
}


GType zeitgeist_sq_lite_database_get_type (void) {
	static volatile gsize zeitgeist_sq_lite_database_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_sq_lite_database_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistSQLiteDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_sq_lite_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistSQLiteDatabase), 0, (GInstanceInitFunc) zeitgeist_sq_lite_database_instance_init, NULL };
		GType zeitgeist_sq_lite_database_type_id;
		zeitgeist_sq_lite_database_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistSQLiteDatabase", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_sq_lite_database_type_id__volatile, zeitgeist_sq_lite_database_type_id);
	}
	return zeitgeist_sq_lite_database_type_id__volatile;
}



