/* result-set.c generated by valac 0.38.8, the Vala compiler
 * generated from result-set.vala, do not modify */

/*
 * Copyright © 2012 Canonical Ltd.
 *             By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 * Based upon a C implementation (© 2009 Canonical Ltd) by:
 *  Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>


#define ZEITGEIST_TYPE_RESULT_SET (zeitgeist_result_set_get_type ())
#define ZEITGEIST_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_RESULT_SET, ZeitgeistResultSet))
#define ZEITGEIST_IS_RESULT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_RESULT_SET))
#define ZEITGEIST_RESULT_SET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZEITGEIST_TYPE_RESULT_SET, ZeitgeistResultSetIface))

typedef struct _ZeitgeistResultSet ZeitgeistResultSet;
typedef struct _ZeitgeistResultSetIface ZeitgeistResultSetIface;

#define ZEITGEIST_TYPE_EVENT (zeitgeist_event_get_type ())
#define ZEITGEIST_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EVENT, ZeitgeistEvent))
#define ZEITGEIST_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EVENT, ZeitgeistEventClass))
#define ZEITGEIST_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EVENT))
#define ZEITGEIST_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EVENT))
#define ZEITGEIST_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EVENT, ZeitgeistEventClass))

typedef struct _ZeitgeistEvent ZeitgeistEvent;
typedef struct _ZeitgeistEventClass ZeitgeistEventClass;

struct _ZeitgeistResultSetIface {
	GTypeInterface parent_iface;
	guint (*size) (ZeitgeistResultSet* self);
	guint (*estimated_matches) (ZeitgeistResultSet* self);
	ZeitgeistEvent* (*next_value) (ZeitgeistResultSet* self);
	gboolean (*has_next) (ZeitgeistResultSet* self);
	guint (*tell) (ZeitgeistResultSet* self);
	void (*reset) (ZeitgeistResultSet* self);
};



GType zeitgeist_event_get_type (void) G_GNUC_CONST;
GType zeitgeist_result_set_get_type (void) G_GNUC_CONST;
guint zeitgeist_result_set_size (ZeitgeistResultSet* self);
guint zeitgeist_result_set_estimated_matches (ZeitgeistResultSet* self);
ZeitgeistEvent* zeitgeist_result_set_next_value (ZeitgeistResultSet* self);
gboolean zeitgeist_result_set_has_next (ZeitgeistResultSet* self);
guint zeitgeist_result_set_tell (ZeitgeistResultSet* self);
void zeitgeist_result_set_reset (ZeitgeistResultSet* self);
ZeitgeistResultSet* zeitgeist_result_set_iterator (ZeitgeistResultSet* self);


/**
     * Get the number of #ZeitgeistEvent<!-- -->s held in a #ZeitgeistResultSet.
     * Unlike the number obtained from zeitgeist_result_set_estimated_matches() the
     * size of the result set is always equal to the number of times you can call
     * zeitgeist_result_set_next().
     *
     * @return The number of events held in the result set
     */
guint zeitgeist_result_set_size (ZeitgeistResultSet* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return ZEITGEIST_RESULT_SET_GET_INTERFACE (self)->size (self);
}


/**
     * Get the total number of matches that would have been for the query
     * that generated the result set had it not been restricted in size.
     * For FTS the number of matches is estimated.
     *
     * For zeitgeist_log_find_events() and zeitgeist_log_get_events() this will
     * always be the same as zeitgeist_result_set_size(). For cases like
     * zeitgeist_index_search() where you specify a subset of the hits to retrieve
     * the estimated match count will often be bigger than the result set size.
     *
     * @return The number of events that matched the query
     */
guint zeitgeist_result_set_estimated_matches (ZeitgeistResultSet* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return ZEITGEIST_RESULT_SET_GET_INTERFACE (self)->estimated_matches (self);
}


/**
     * Get the current event from the result set and advance the cursor. To
     * ensure that calls to this method will succeed you can call
     * zeitgeist_result_set_has_next().
     *
     * @return The #ZeitgeistEvent at the current cursor position, or NULL
     *         if there are no events left.
     */
ZeitgeistEvent* zeitgeist_result_set_next_value (ZeitgeistResultSet* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return ZEITGEIST_RESULT_SET_GET_INTERFACE (self)->next_value (self);
}


/**
     * Check if a call to zeitgeist_result_set_next() will succeed.
     *
     * @return TRUE if and only if more events can be retrieved
     *         by calling zeitgeist_result_set_next()
     */
gboolean zeitgeist_result_set_has_next (ZeitgeistResultSet* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return ZEITGEIST_RESULT_SET_GET_INTERFACE (self)->has_next (self);
}


/**
     * Get the current position of the cursor.
     *
     * @return The current position of the cursor
     */
guint zeitgeist_result_set_tell (ZeitgeistResultSet* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return ZEITGEIST_RESULT_SET_GET_INTERFACE (self)->tell (self);
}


/**
     * Resets the result set to start iterating it again from scratch.
     *
     */
void zeitgeist_result_set_reset (ZeitgeistResultSet* self) {
	g_return_if_fail (self != NULL);
	ZEITGEIST_RESULT_SET_GET_INTERFACE (self)->reset (self);
}


/**
     * Do not use this method! It is only for use by Vala.
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


ZeitgeistResultSet* zeitgeist_result_set_iterator (ZeitgeistResultSet* self) {
	ZeitgeistResultSet* result = NULL;
	ZeitgeistResultSet* _tmp0_;
	_tmp0_ = _g_object_ref0 (self);
	result = _tmp0_;
	return result;
}


static void zeitgeist_result_set_base_init (ZeitgeistResultSetIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


/**
 * Cursor-like interface for results sets
 *
 * include: zeitgeist.h
 *
 * Interface for results returned by zeitgeist_log_find_events(),
 * zeitgeist_log_get_events(), and zeitgeist_index_search().
 *
 * This interface utilizes a cursor-like metaphor. You advance the cursor
 * by calling zeitgeist_result_set_next() or adjust it manually by calling
 * zeitgeist_result_set_seek().
 *
 * Calling zeitgeist_result_set_next() will also return the event at the
 * current cursor position. You may retrieve the current event without advancing
 * the cursor by calling zeitgeist_result_set_peek().
 *
 */
GType zeitgeist_result_set_get_type (void) {
	static volatile gsize zeitgeist_result_set_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_result_set_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistResultSetIface), (GBaseInitFunc) zeitgeist_result_set_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType zeitgeist_result_set_type_id;
		zeitgeist_result_set_type_id = g_type_register_static (G_TYPE_INTERFACE, "ZeitgeistResultSet", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (zeitgeist_result_set_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&zeitgeist_result_set_type_id__volatile, zeitgeist_result_set_type_id);
	}
	return zeitgeist_result_set_type_id__volatile;
}



