/*
 * Decompiled with CFR 0.152.
 */
package processing.app.helpers;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Toolkit;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class Keys {
    private static final int CTRL = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

    public static void bind(JComponent component, Action action) {
        Keys.bind(component, action, (KeyStroke)action.getValue("AcceleratorKey"));
    }

    public static void bind(JComponent component, Action action, KeyStroke keystroke) {
        Keys.bind(component, action, keystroke, 2);
    }

    public static void bind(JComponent component, Action action, KeyStroke keystroke, int condition) {
        if (action.isEnabled()) {
            Keys.enableBind(component, action, keystroke, condition);
        }
        component.getActionMap().put(action, action);
        action.addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("enabled")) {
                if (e.getNewValue().equals(Boolean.TRUE)) {
                    Keys.enableBind(component, action, keystroke, condition);
                } else {
                    Keys.disableBind(component, action, keystroke, condition);
                }
            }
        });
    }

    public static void killBinding(JComponent component, KeyStroke keystroke, int condition) {
        InputMap map = component.getInputMap(condition);
        map.remove(keystroke);
        if (map.get(keystroke) != null) {
            map.put(keystroke, new Object());
        }
    }

    public static void killBinding(JComponent component, KeyStroke key) {
        Keys.killBinding(component, key, 0);
        Keys.killBinding(component, key, 1);
        Keys.killBinding(component, key, 2);
    }

    public static void killFocusTraversalBinding(Component component, KeyStroke keystroke) {
        int[] sets;
        for (int set : sets = new int[]{0, 1, 2, 3}) {
            Set<AWTKeyStroke> keys = component.getFocusTraversalKeys(set);
            keys = new HashSet<AWTKeyStroke>(keys);
            if (set == 0) {
                keys.add(Keys.ctrlAlt(90));
            }
            if (!keys.remove(keystroke)) continue;
            component.setFocusTraversalKeys(set, keys);
        }
    }

    private static void enableBind(JComponent component, Action action, KeyStroke keystroke, int condition) {
        component.getInputMap(condition).put(keystroke, action);
    }

    private static void disableBind(JComponent component, Action action, KeyStroke keystroke, int condition) {
        component.getInputMap(condition).put(keystroke, action);
    }

    public static KeyStroke ctrl(int keyCode) {
        return KeyStroke.getKeyStroke(keyCode, CTRL);
    }

    public static KeyStroke ctrlShift(int keyCode) {
        return KeyStroke.getKeyStroke(keyCode, CTRL | 1);
    }

    public static KeyStroke ctrlAlt(int keyCode) {
        return KeyStroke.getKeyStroke(keyCode, CTRL | 8);
    }
}

