/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.report.ReportPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;

public final class ReportRequirementsPanel
extends ReportPanel {
    private static final Logger logger = Logger.getLogger(ReportRequirementsPanel.class.getName());
    private final List<Colony> colonies;
    private final Map<Colony, TypeCountMap<UnitType>> unitCount;
    private final Map<Colony, Set<UnitType>> canTrain;

    public ReportRequirementsPanel(FreeColClient freeColClient) {
        super(freeColClient, "reportRequirementsAction");
        Player player = this.getMyPlayer();
        this.colonies = player.getColonyList();
        JTextPane textPane = Utility.getDefaultTextPane();
        StyledDocument doc = textPane.getStyledDocument();
        this.unitCount = new HashMap<Colony, TypeCountMap<UnitType>>(this.colonies.size());
        this.canTrain = new HashMap<Colony, Set<UnitType>>(this.colonies.size());
        for (Colony colony : this.colonies) {
            TypeCountMap<UnitType> newUnitCount = new TypeCountMap<UnitType>();
            HashSet<UnitType> newCanTrain = new HashSet<UnitType>();
            for (Unit unit : colony.getUnitList()) {
                newUnitCount.incrementCount(unit.getType(), 1);
                if (!colony.canTrain(unit.getType())) continue;
                newCanTrain.add(unit.getType());
            }
            this.unitCount.put(colony, newUnitCount);
            this.canTrain.put(colony, newCanTrain);
        }
        for (Colony colony : this.colonies) {
            this.checkColony(colony, doc);
        }
        int width = this.reportPanel.getParent().getWidth();
        this.reportPanel.setLayout(new MigLayout("width " + width + "!"));
        this.reportPanel.add(textPane);
        textPane.setCaretPosition(0);
    }

    private void checkColony(Colony colony, StyledDocument doc) {
        UnitType expert;
        Specification spec = this.getSpecification();
        try {
            if (doc.getLength() > 0) {
                doc.insertString(doc.getLength(), "\n\n", doc.getStyle("regular"));
            }
            StyleConstants.setComponent(doc.getStyle("button"), this.createColonyButton(colony, true));
            doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Colony check fail", e);
        }
        HashSet<UnitType> missingExpertWarning = new HashSet<UnitType>();
        HashSet<UnitType> badAssignmentWarning = new HashSet<UnitType>();
        HashSet<GoodsType> productionWarning = new HashSet<GoodsType>();
        for (Unit unit : CollectionUtils.transform(colony.getUnits(), u -> u.getSkillLevel() > 0)) {
            Unit better = colony.getBetterExpert(unit);
            if (better == null || badAssignmentWarning.contains(unit.getType())) continue;
            this.addBadAssignmentWarning(doc, colony, unit, better);
            badAssignmentWarning.add(unit.getType());
        }
        for (ColonyTile colonyTile : colony.getColonyTiles()) {
            for (Unit unit : colonyTile.getUnitList()) {
                GoodsType workType = unit.getWorkType();
                expert = spec.getExpertForProducing(workType);
                if (this.unitCount.get(colony).getCount(expert) != 0 || !missingExpertWarning.add(expert)) continue;
                this.addExpertWarning(doc, colony, workType, expert);
            }
        }
        for (Building building : colony.getBuildings()) {
            for (AbstractGoods output : CollectionUtils.iterable(building.getOutputs())) {
                GoodsType goodsType = output.getType();
                expert = spec.getExpertForProducing(goodsType);
                if (goodsType != null && expert != null && !building.getUnitList().isEmpty() && !missingExpertWarning.contains(expert) && this.unitCount.get(colony).getCount(expert) == 0) {
                    if (!colony.goodsUseful(goodsType)) continue;
                    this.addExpertWarning(doc, colony, goodsType, expert);
                    missingExpertWarning.add(expert);
                }
                ProductionInfo info = building.getProductionInfo();
                if (goodsType == null || info == null || info.atMaximumProduction() || !productionWarning.add(goodsType)) continue;
                CollectionUtils.forEach(CollectionUtils.map(building.getInputs(), AbstractGoods::getType), gt -> this.addProductionWarning(doc, colony, goodsType, (GoodsType)gt));
            }
        }
        List<Colony.TileImprovementSuggestion> tileSuggestions = colony.getTileImprovementSuggestions();
        for (Colony.TileImprovementSuggestion tis : tileSuggestions) {
            if (tis.tileImprovementType == null) {
                this.addTileWarning(doc, colony, "report.requirements.exploreTile", tis.tile);
                continue;
            }
            String key = "report.requirements.tile." + tis.tileImprovementType.getSuffix();
            if (!Messages.containsKey(key)) continue;
            this.addTileWarning(doc, colony, key, tis.tile);
        }
        if (tileSuggestions.isEmpty() && missingExpertWarning.isEmpty() && badAssignmentWarning.isEmpty() && productionWarning.isEmpty()) {
            try {
                doc.insertString(doc.getLength(), "\n\n" + Messages.message("report.requirements.met"), doc.getStyle("regular"));
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Colony check fail", exception);
            }
        }
    }

    private void addTileWarning(StyledDocument doc, Colony colony, String messageId, Tile tile) {
        if (messageId == null || !Messages.containsKey(messageId)) {
            return;
        }
        Object t = StringTemplate.template(messageId).addStringTemplate("%location%", tile.getColonyTileLocationLabel(colony));
        try {
            doc.insertString(doc.getLength(), "\n\n" + Messages.message(t), doc.getStyle("regular"));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Tile warning fail", e);
        }
    }

    private void addBadAssignmentWarning(StyledDocument doc, Colony colony, Unit expert, Unit nonExpert) {
        GoodsType expertGoods = expert.getWorkType();
        GoodsType nonExpertGoods = nonExpert.getWorkType();
        String colonyName = colony.getName();
        String expertName = Messages.getName(expert.getType());
        String nonExpertName = Messages.getName(nonExpert.getType());
        String expertProductionName = Messages.message(expertGoods.getWorkingAsKey());
        String nonExpertProductionName = Messages.message(nonExpertGoods.getWorkingAsKey());
        String newMessage = Messages.message(((StringTemplate)((StringTemplate)((StringTemplate)((StringTemplate)StringTemplate.template("report.requirements.badAssignment").addName("%colony%", colonyName)).addName("%expert%", expertName)).addName("%expertWork%", expertProductionName)).addName("%nonExpert%", nonExpertName)).addName("%nonExpertWork%", nonExpertProductionName));
        try {
            doc.insertString(doc.getLength(), "\n\n" + newMessage, doc.getStyle("regular"));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Bad assignment fail", e);
        }
    }

    private void addExpertWarning(StyledDocument doc, Colony c, GoodsType goodsType, UnitType workType) {
        String newMessage = Messages.message(((StringTemplate)((StringTemplate)StringTemplate.template("report.requirements.noExpert").addName("%colony%", c.getName())).addName("%goods%", goodsType)).addName("%unit%", workType));
        try {
            doc.insertString(doc.getLength(), "\n\n" + newMessage, doc.getStyle("regular"));
            ArrayList<Colony> misusedExperts = new ArrayList<Colony>();
            ArrayList<Colony> severalExperts = new ArrayList<Colony>();
            ArrayList<Colony> canTrainExperts = new ArrayList<Colony>();
            for (Colony colony : this.colonies) {
                for (Unit unit : colony.getUnitList()) {
                    GoodsType expertise = unit.getType().getExpertProduction();
                    if (expertise != goodsType || unit.getSkillLevel() <= 0) continue;
                    if (unit.getLocation() instanceof Building) {
                        if (((Building)unit.getLocation()).canProduce(goodsType, unit.getType())) continue;
                        misusedExperts.add(colony);
                        continue;
                    }
                    if (expertise == unit.getWorkType()) continue;
                    misusedExperts.add(colony);
                }
                if (this.unitCount.get(colony).getCount(workType) > 1) {
                    severalExperts.add(colony);
                }
                if (!this.canTrain.get(colony).contains(workType)) continue;
                canTrainExperts.add(colony);
            }
            if (!misusedExperts.isEmpty()) {
                doc.insertString(doc.getLength(), "\n" + Messages.message(((StringTemplate)StringTemplate.template("report.requirements.misusedExperts").addName("%unit%", workType)).add("%work%", goodsType.getWorkingAsKey())) + " ", doc.getStyle("regular"));
                this.insertColonyButtons(doc, misusedExperts);
            }
            if (!severalExperts.isEmpty()) {
                doc.insertString(doc.getLength(), "\n" + Messages.message(StringTemplate.template("report.requirements.severalExperts").addName("%unit%", workType)) + " ", doc.getStyle("regular"));
                this.insertColonyButtons(doc, severalExperts);
            }
            if (!canTrainExperts.isEmpty()) {
                doc.insertString(doc.getLength(), "\n" + Messages.message(StringTemplate.template("report.requirements.canTrainExperts").addName("%unit%", workType)) + " ", doc.getStyle("regular"));
                this.insertColonyButtons(doc, canTrainExperts);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Assign experts fail", e);
        }
    }

    private void insertColonyButtons(StyledDocument doc, List<Colony> colonies) throws Exception {
        for (Colony colony : colonies) {
            StyleConstants.setComponent(doc.getStyle("button"), this.createColonyButton(colony, false));
            doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
            doc.insertString(doc.getLength(), ", ", doc.getStyle("regular"));
        }
        doc.remove(doc.getLength() - 2, 2);
    }

    private void addProductionWarning(StyledDocument doc, Colony colony, GoodsType output, GoodsType input) {
        String colonyName = colony.getName();
        String newMessage = Messages.message(((StringTemplate)((StringTemplate)StringTemplate.template("report.requirements.missingGoods").addName("%colony%", colonyName)).addNamed("%goods%", output)).addNamed("%input%", input));
        try {
            doc.insertString(doc.getLength(), "\n\n" + newMessage, doc.getStyle("regular"));
            ArrayList<Colony> withSurplus = new ArrayList<Colony>();
            ArrayList<Integer> theSurplus = new ArrayList<Integer>();
            for (Colony col : this.colonies) {
                int amount = colony.getAdjustedNetProductionOf(input);
                if (amount <= 0) continue;
                withSurplus.add(col);
                theSurplus.add(amount);
            }
            if (!withSurplus.isEmpty()) {
                String amount;
                doc.insertString(doc.getLength(), "\n" + Messages.message(StringTemplate.template("report.requirements.surplus").addNamed("%goods%", input)) + " ", doc.getStyle("regular"));
                for (int index = 0; index < withSurplus.size() - 1; ++index) {
                    amount = " (" + theSurplus.get(index) + ")";
                    StyleConstants.setComponent(doc.getStyle("button"), this.createColonyButton((Colony)withSurplus.get(index), amount, false));
                    doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
                    doc.insertString(doc.getLength(), ", ", doc.getStyle("regular"));
                }
                Colony lastColony = (Colony)withSurplus.get(withSurplus.size() - 1);
                amount = " (" + theSurplus.get(theSurplus.size() - 1) + ")";
                StyleConstants.setComponent(doc.getStyle("button"), this.createColonyButton(lastColony, amount, false));
                doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
            }
        }
        catch (BadLocationException ble) {
            logger.log(Level.WARNING, "Bad insert location", ble);
        }
    }

    private JButton createColonyButton(Colony colony, boolean headline) {
        return this.createColonyButton(colony, "", headline);
    }

    private JButton createColonyButton(Colony colony, String info, boolean headline) {
        String text = colony.getName() + info;
        JButton button = Utility.getLinkButton(text, null, colony.getId());
        if (headline) {
            button.setFont(FontLibrary.getScaledFont(Utility.FONTSPEC_SUBTITLE, text));
        }
        button.addActionListener(this);
        return button;
    }
}

