# Yamaha YM2203 (OPN)

a cost-reduced version of the YM2151 (OPM).
it only has 3 FM channels instead of 8 and removes stereo, the LFO and DT2 (coarse detune).

however it does contain an AY/SSG part which provides 3 channels of square wave with noise and envelope.

this chip was used in the NEC PC-88/PC-98 series of computers, the Fujitsu FM-7AV and in some arcade boards.

several variants of this chip were released as well, with more features.

## effects

- `11xx`: **set feedback of channel.**
- `12xx`: **set operator 1 level.**
- `13xx`: **set operator 2 level.**
- `14xx`: **set operator 3 level.**
- `15xx`: **set operator 4 level.**
- `16xy`: **set multiplier of operator.**
  - `x` is the operator from 1 to 4.
  - `y` is the new MULT value..
- `18xx`: **toggle extended channel 3 mode.**
  - `0` disables it and `1` enables it.
  - only in extended channel 3 chip.
- `19xx`: **set attack of all operators.**
- `1Axx`: **set attack of operator 1.**
- `1Bxx`: **set attack of operator 2.**
- `1Cxx`: **set attack of operator 3.**
- `1Dxx`: **set attack of operator 4.**
- `20xx`: **set SSG channel mode.** `xx` may be one of the following:
  - `0`: square
  - `1`: noise
  - `2`: square and noise
  - `3`: nothing (apparently)
  - `4`: envelope and square
  - `5`: envelope and noise
  - `6`: envelope and square and noise
  - `7`: nothing
- `21xx`: **set noise frequency.** `xx` is a value between 00 and 1F.
- `22xy`: **set envelope mode.**
  - `x` sets the envelope shape, which may be one of the following:
    - `0`: `\___` decay
    - `4`: `/___` attack once
    - `8`: `\\\\` saw
    - `9`: `\___` decay
    - `A`: `\/\/` inverse obelisco
    - `B`: `\¯¯¯` decay once
    - `C`: `////` inverse saw
    - `D`: `/¯¯¯` attack
    - `E`: `/\/\` obelisco
    - `F`: `/___` attack once
  - if `y` is 1 then the envelope will affect this channel.
- `23xx`: **set envelope period low byte.**
- `24xx`: **set envelope period high byte.**
- `25xx`: **slide envelope period up.**
- `26xx`: **slide envelope period down.**
- `29xy`: **enable SSG auto-envelope mode.**
  - in this mode the envelope period is set to the channel's notes, multiplied by a fraction.
  - `x` is the numerator.
  - `y` is the denominator.
  - if `x` or `y` are 0 this will disable auto-envelope mode.
- `30xx`: **enable envelope hard reset.**
  - this works by inserting a quick release and tiny delay before a new note.
- `50xy`: **set AM of operator.**
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` determines whether AM is on.
- `51xy`: **set SL of operator.**
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` is the value.
- `52xy`: **set RR of operator.**
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` is the value.
- `53xy`: **set DT of operator.**
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` is the value:
    - `0`: +0
    - `1`: +1
    - `2`: +2
    - `3`: +3
    - `4`: -0
    - `5`: -3
    - `6`: -2
    - `7`: -1
- `54xy`: **set RS of operator.**
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` is the value.
- `55xy`: **set SSG-EG of operator.**
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` is the value (0-8).
    - values between 0 and 7 set SSG-EG.
    - value 8 disables it.
- `56xx`: **set DR of all operators.**
- `57xx`: **set DR of operator 1.**
- `58xx`: **set DR of operator 2.**
- `59xx`: **set DR of operator 3.**
- `5Axx`: **set DR of operator 4.**
- `5Bxx`: **set D2R/SR of all operators.**
- `5Cxx`: **set D2R/SR of operator 1.**
- `5Dxx`: **set D2R/SR of operator 2.**
- `5Exx`: **set D2R/SR of operator 3.**
- `5Fxx`: **set D2R/SR of operator 4.**

## extended channel 3

in ExtCh mode, channel 3 is split into one column for each of its four operators and feedback are shared. the frequency of each operator may be controlled independently with notes and effects. this can be used for more polyphony or more complex sounds.

all four operators are still combined according to the algorithm in use. for example, algorithm 7 acts as four independent sine waves. algorithm 4 acts as two independent 2op sounds. even with algorithm 0, placing a note in any operator triggers that operator alone.

## info

this chip uses the [FM (OPN)](../4-instrument/fm-opn.md) and [AY-3-8910/SSG](../4-instrument/ay8910.md) instrument editor.


