/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.capsule.util.collection;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.util.EqualityComparator;
import io.usethesource.capsule.util.collection.Map0;
import io.usethesource.capsule.util.collection.Map1;
import io.usethesource.capsule.util.collection.Map2;
import io.usethesource.capsule.util.collection.Map3;
import io.usethesource.capsule.util.collection.Map4;
import io.usethesource.capsule.util.collection.Map5;
import io.usethesource.capsule.util.collection.MapEntry;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractSpecialisedImmutableMap<K, V>
implements Map.Immutable<K, V>,
Cloneable,
Serializable {
    private static Map.Immutable EMPTY_MAP = new Map0();

    private static <K, V> Map.Immutable<K, V> of() {
        return EMPTY_MAP;
    }

    public static <K, V> Map.Immutable<K, V> mapOf() {
        return EMPTY_MAP;
    }

    public static final <K, V> Map.Entry<K, V> entryOf(K key, V val) {
        return new MapEntry<K, V>(key, val);
    }

    public static <K, V> Map.Immutable<K, V> mapOf(K key1, V val1) {
        return new Map1<K, V>(key1, val1);
    }

    public static <K, V> Map.Immutable<K, V> mapOf(K key1, V val1, K key2, V val2) {
        return new Map2<K, V>(key1, val1, key2, val2);
    }

    public static <K, V> Map.Immutable<K, V> mapOf(K key1, V val1, K key2, V val2, K key3, V val3) {
        return new Map3<K, V>(key1, val1, key2, val2, key3, val3);
    }

    public static <K, V> Map.Immutable<K, V> mapOf(K key1, V val1, K key2, V val2, K key3, V val3, K key4, V val4) {
        return new Map4<K, V>(key1, val1, key2, val2, key3, val3, key4, val4);
    }

    public static <K, V> Map.Immutable<K, V> mapOf(K key1, V val1, K key2, V val2, K key3, V val3, K key4, V val4, K key5, V val5) {
        return new Map5<K, V>(key1, val1, key2, val2, key3, val3, key4, val4, key5, val5);
    }

    public static <K, V> Map.Immutable<K, V> mapOf(K key1, V val1, K key2, V val2, K key3, V val3, K key4, V val4, K key5, V val5, K key6, V val6) {
        Map.Transient<K, V> tmp = Map.Transient.of(key1, val1, key2, val2, key3, val3, key4, val4, key5, val5, key6, val6);
        return tmp.freeze();
    }

    public static <K, V> Map.Immutable<K, V> mapOf(Map<K, V> map) {
        if (map instanceof Map.Immutable) {
            return (Map.Immutable)map;
        }
        Map.Transient<K, V> tmp = Map.Transient.of();
        tmp.__putAll(map);
        return tmp.freeze();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean equals(Object other) {
        return this.equivalent(other, Object::equals);
    }

    @Override
    public boolean equivalent(Object other, EqualityComparator<Object> cmp) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof Map) {
            try {
                Map that = (Map)other;
                if (this.size() == that.size()) {
                    for (Map.Entry e : that.entrySet()) {
                        if (!this.containsKeyEquivalent(e.getKey(), cmp)) {
                            return false;
                        }
                        if (Objects.equals(e.getValue(), this.getEquivalent(e.getKey(), cmp))) continue;
                        return false;
                    }
                    return true;
                }
            }
            catch (ClassCastException unused) {
                return false;
            }
        }
        return false;
    }

    @Override
    public Iterator<V> valueIterator() {
        return this.values().iterator();
    }

    @Override
    public Iterator<Map.Entry<K, V>> entryIterator() {
        return this.entrySet().iterator();
    }

    @Override
    public Map.Immutable<K, V> __putAll(Map<? extends K, ? extends V> map) {
        Map.Transient<? extends K, ? extends V> tmp = this.asTransient();
        if (tmp.__putAll(map)) {
            return tmp.freeze();
        }
        return this;
    }

    @Override
    public Map.Immutable<K, V> __putAllEquivalent(Map<? extends K, ? extends V> map, EqualityComparator<Object> cmp) {
        Map.Transient<? extends K, ? extends V> tmp = this.asTransient();
        if (tmp.__putAllEquivalent(map, cmp)) {
            return tmp.freeze();
        }
        return this;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public boolean isTransientSupported() {
        return true;
    }
}

