/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jnati.deploy.artefact;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.sf.jnati.ArtefactDescriptor;
import net.sf.jnati.config.Configuration;
import net.sf.jnati.deploy.artefact.ArtefactFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Artefact {
    private String id;
    private String version;
    private File path;
    private List<ArtefactFile> fileList;
    private List<URL> repositoryList;
    private Configuration config;

    public Artefact(String id, String version) {
        if (id == null) {
            throw new NullPointerException("Null ID");
        }
        if (version == null) {
            throw new NullPointerException("Null version");
        }
        this.id = id;
        this.version = version;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public File getPath() {
        return this.path;
    }

    public void setPath(File path) {
        this.path = path;
    }

    public List<ArtefactFile> getFileList() {
        return this.fileList == null ? null : new ArrayList<ArtefactFile>(this.fileList);
    }

    public void setFileList(List<ArtefactFile> fileList) {
        this.fileList = fileList == null ? null : new ArrayList<ArtefactFile>(fileList);
    }

    public List<URL> getRepositoryList() {
        return this.repositoryList == null ? null : new ArrayList<URL>(this.repositoryList);
    }

    public void setRepositoryList(List<URL> repositoryList) {
        this.repositoryList = repositoryList == null ? null : new ArrayList<URL>(repositoryList);
    }

    public String toString() {
        return this.id + "-" + this.version + "-" + this.getOsArch();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public String getProperty(String key) {
        return this.config.getProperty(key);
    }

    public String getOsArch() {
        return this.getProperty("${jnati.artefactId}.${jnati.artefactVersion}.osarch");
    }

    public File getLocalRepository() {
        String s = this.getProperty("jnati.localRepository");
        return s == null ? null : new File(s);
    }

    public boolean getAutoDeploy() {
        String s = this.getProperty("jnati.autoDeploy");
        return Boolean.parseBoolean(s);
    }

    public boolean getAllowLocal() {
        String s = this.getProperty("jnati.allowDirectLoad");
        return Boolean.parseBoolean(s);
    }

    public boolean getAllowDownload() {
        String s = this.getProperty("jnati.allowDownload");
        return Boolean.parseBoolean(s);
    }

    public List<String> getRepositoryUrls() {
        String s = this.getProperty("${jnati.artefactId}.${jnati.artefactVersion}.repositoryUrls");
        ArrayList<String> list = new ArrayList<String>();
        for (String u : s.split(";")) {
            if ((u = u.trim()).length() <= 0) continue;
            list.add(u);
        }
        return list;
    }

    public ArtefactDescriptor getArtefactLocation() {
        return new ArtefactDescriptor(this.id, this.version, this.getOsArch(), this.path);
    }
}

