/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.thread;

import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.P3;
import org.jmol.thread.JmolThread;
import org.jmol.util.Logger;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

public class SpinThread
extends JmolThread {
    private TransformManager transformManager;
    private float endDegrees;
    private Lst<P3> endPositions;
    private float[] dihedralList;
    private float nDegrees;
    private BS bsAtoms;
    private boolean isNav;
    private boolean isGesture;
    private float myFps;
    private float angle;
    private boolean haveNotified;
    private int index;
    private BS[] bsBranches;
    private boolean isDone = false;
    private M4 m4;

    @Override
    public int setManager(Object manager, Viewer vwr, Object params) {
        this.transformManager = (TransformManager)manager;
        this.setViewer(vwr, "SpinThread");
        Object[] options = (Object[])params;
        if (options == null) {
            this.isNav = true;
        } else {
            this.endDegrees = ((Float)options[0]).floatValue();
            this.endPositions = (Lst)options[1];
            this.dihedralList = (float[])options[2];
            if (this.dihedralList != null) {
                this.bsBranches = vwr.ms.getBsBranches(this.dihedralList);
            }
            this.bsAtoms = (BS)options[3];
            this.isGesture = options[4] != null;
        }
        return 0;
    }

    @Override
    protected void run1(int mode) throws InterruptedException {
        while (true) {
            switch (mode) {
                case -1: {
                    this.myFps = this.isNav ? this.transformManager.navFps : this.transformManager.spinFps;
                    this.vwr.g.setB(this.isNav ? "_navigating" : "_spinning", true);
                    this.haveReference = true;
                    this.vwr.startHoverWatcher(false);
                    mode = 0;
                    break;
                }
                case 0: {
                    boolean isInMotion;
                    if (this.isReset || this.checkInterrupted(this.transformManager.spinThread)) {
                        mode = -2;
                        break;
                    }
                    if (this.isNav && this.myFps != this.transformManager.navFps) {
                        this.myFps = this.transformManager.navFps;
                        this.index = 0;
                        this.startTime = System.currentTimeMillis();
                    } else if (!this.isNav && this.myFps != this.transformManager.spinFps && this.bsAtoms == null) {
                        this.myFps = this.transformManager.spinFps;
                        this.index = 0;
                        this.startTime = System.currentTimeMillis();
                    }
                    if (this.myFps == 0.0f || !(!this.isNav ? this.transformManager.spinOn : this.transformManager.navOn)) {
                        mode = -2;
                        break;
                    }
                    boolean refreshNeeded = this.endDegrees >= 1.0E10f ? true : (this.isNav ? this.transformManager.navX != 0.0f || this.transformManager.navY != 0.0f || this.transformManager.navZ != 0.0f : this.transformManager.isSpinInternal && this.transformManager.internalRotationAxis.angle != 0.0f || this.transformManager.isSpinFixed && this.transformManager.fixedRotationAxis.angle != 0.0f || !this.transformManager.isSpinFixed && !this.transformManager.isSpinInternal && (this.transformManager.spinX != 0.0f || this.transformManager.spinY != 0.0f || this.transformManager.spinZ != 0.0f));
                    this.targetTime = (long)((float)(++this.index * 1000) / this.myFps);
                    this.currentTime = System.currentTimeMillis() - this.startTime;
                    this.sleepTime = (int)(this.targetTime - this.currentTime);
                    if (this.sleepTime < 0) {
                        if (!this.haveNotified) {
                            Logger.info("spinFPS is set too fast (" + this.myFps + ") -- can't keep up!");
                        }
                        this.haveNotified = true;
                        this.startTime -= (long)this.sleepTime;
                        this.sleepTime = 0;
                    }
                    boolean bl = isInMotion = this.bsAtoms == null && this.vwr.getInMotion(false);
                    if (isInMotion) {
                        if (this.isGesture) {
                            mode = -2;
                            break;
                        }
                        this.sleepTime += 1000;
                    }
                    if (refreshNeeded && !isInMotion && (this.transformManager.spinOn || this.transformManager.navOn)) {
                        this.doTransform();
                    }
                    mode = 1;
                    break;
                }
                case 1: {
                    while (!this.checkInterrupted(this.transformManager.spinThread) && !this.vwr.getRefreshing()) {
                        if (this.runSleep(10, 1)) continue;
                        return;
                    }
                    if (this.bsAtoms != null || this.vwr.g.waitForMoveTo && this.endDegrees != Float.MAX_VALUE) {
                        this.vwr.requestRepaintAndWait("spin thread");
                    } else {
                        this.vwr.refresh(1, "SpinThread");
                    }
                    if (this.endDegrees >= 1.0E10f ? (double)(this.nDegrees / this.endDegrees) > 0.99 : (!this.isNav && this.endDegrees >= 0.0f ? (double)this.nDegrees >= (double)this.endDegrees - 0.001 : (double)(-this.nDegrees) <= (double)this.endDegrees + 0.001)) {
                        this.isDone = true;
                        this.transformManager.setSpinOff();
                    }
                    if (!this.runSleep(this.sleepTime, 0)) {
                        return;
                    }
                    mode = 0;
                    break;
                }
                case -2: {
                    if (this.dihedralList != null) {
                        this.vwr.setDihedrals(this.dihedralList, this.bsBranches, 0.0f);
                    } else if (this.bsAtoms != null && this.endPositions != null) {
                        this.vwr.setAtomCoords(this.bsAtoms, 1145047050, this.endPositions);
                        this.bsAtoms = null;
                        this.endPositions = null;
                    }
                    if (!this.isReset) {
                        this.transformManager.setSpinOff();
                        this.vwr.startHoverWatcher(true);
                    }
                    this.stopped = !this.isDone;
                    this.resumeEval();
                    this.stopped = true;
                    return;
                }
            }
        }
    }

    private void doTransform() {
        if (this.dihedralList != null) {
            float f = 1.0f / this.myFps / this.endDegrees;
            this.vwr.setDihedrals(this.dihedralList, this.bsBranches, f);
            this.nDegrees += 1.0f / this.myFps;
        } else if (this.isNav) {
            this.transformManager.setNavigationOffsetRelative();
        } else if (this.transformManager.isSpinInternal || this.transformManager.isSpinFixed) {
            this.angle = (this.transformManager.isSpinInternal ? this.transformManager.internalRotationAxis : this.transformManager.fixedRotationAxis).angle / this.myFps;
            if (this.transformManager.isSpinInternal) {
                this.transformManager.rotateAxisAngleRadiansInternal(this.angle, this.bsAtoms, this.m4);
            } else {
                this.transformManager.rotateAxisAngleRadiansFixed(this.angle, this.bsAtoms);
            }
            this.nDegrees = (float)((double)this.nDegrees + Math.abs((double)this.angle * 57.29577951308232));
        } else {
            if (this.transformManager.spinX != 0.0f) {
                this.transformManager.rotateXRadians((float)((double)this.transformManager.spinX * (Math.PI / 180) / (double)this.myFps), null);
            }
            if (this.transformManager.spinY != 0.0f) {
                this.transformManager.rotateYRadians((float)((double)this.transformManager.spinY * (Math.PI / 180) / (double)this.myFps), null);
            }
            if (this.transformManager.spinZ != 0.0f) {
                this.transformManager.rotateZRadians((float)((double)this.transformManager.spinZ * (Math.PI / 180) / (double)this.myFps));
            }
        }
    }
}

