/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.EnumSet;
import org.jruby.RubySymbol;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.TwoOperandInstr;
import org.jruby.ir.operands.GlobalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class PutGlobalVarInstr
extends TwoOperandInstr
implements FixedArityInstr {
    public PutGlobalVarInstr(RubySymbol varName, Operand value2) {
        this(new GlobalVariable(varName), value2);
    }

    public PutGlobalVarInstr(GlobalVariable gvar, Operand value2) {
        super(Operation.PUT_GLOBAL_VAR, gvar, value2);
    }

    @Override
    public boolean computeScopeFlags(IRScope scope, EnumSet<IRFlags> flags2) {
        switch (this.getTarget().getId()) {
            case "$_": 
            case "$LAST_READ_LINE": {
                flags2.add(IRFlags.REQUIRES_LASTLINE);
                break;
            }
            case "$~": 
            case "$LAST_MATCH_INFO": 
            case "$`": 
            case "$PREMATCH": 
            case "$'": 
            case "$POSTMATCH": 
            case "$+": 
            case "$LAST_PAREN_MATCH": {
                flags2.add(IRFlags.REQUIRES_BACKREF);
                return true;
            }
        }
        return false;
    }

    public GlobalVariable getTarget() {
        return (GlobalVariable)this.getOperand1();
    }

    public Operand getValue() {
        return this.getOperand2();
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new PutGlobalVarInstr(this.getTarget().getName(), this.getValue().cloneForInlining(ii));
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getTarget());
        e.encode(this.getValue());
    }

    public static PutGlobalVarInstr decode(IRReaderDecoder d) {
        return new PutGlobalVarInstr((GlobalVariable)d.decodeOperand(), d.decodeOperand());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        GlobalVariable target2 = this.getTarget();
        IRubyObject value2 = (IRubyObject)this.getValue().retrieve(context, self2, currScope, currDynScope, temp);
        context.runtime.getGlobalVariables().set(target2.getId(), value2);
        return null;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.PutGlobalVarInstr(this);
    }
}

