# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class Job(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'state': 'str',
        'type': 'str',
        'data': 'dict(str, object)',
        'error': 'dict(str, object)',
        'created_at': 'datetime',
        'finished_on': 'datetime',
        'processed_on': 'datetime'
    }

    attribute_map = {
        'id': 'id',
        'state': 'state',
        'type': 'type',
        'data': 'data',
        'error': 'error',
        'created_at': 'createdAt',
        'finished_on': 'finishedOn',
        'processed_on': 'processedOn'
    }

    def __init__(self, id=None, state=None, type=None, data=None, error=None, created_at=None, finished_on=None, processed_on=None, local_vars_configuration=None):  # noqa: E501
        """Job - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._state = None
        self._type = None
        self._data = None
        self._error = None
        self._created_at = None
        self._finished_on = None
        self._processed_on = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if state is not None:
            self.state = state
        if type is not None:
            self.type = type
        if data is not None:
            self.data = data
        if error is not None:
            self.error = error
        if created_at is not None:
            self.created_at = created_at
        if finished_on is not None:
            self.finished_on = finished_on
        if processed_on is not None:
            self.processed_on = processed_on

    @property
    def id(self):
        """Gets the id of this Job.  # noqa: E501


        :return: The id of this Job.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Job.


        :param id: The id of this Job.  # noqa: E501
        :type id: int
        """
        if (self.local_vars_configuration.client_side_validation and
                id is not None and id < 0):  # noqa: E501
            raise ValueError("Invalid value for `id`, must be a value greater than or equal to `0`")  # noqa: E501

        self._id = id

    @property
    def state(self):
        """Gets the state of this Job.  # noqa: E501


        :return: The state of this Job.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Job.


        :param state: The state of this Job.  # noqa: E501
        :type state: str
        """
        allowed_values = ["active", "completed", "failed", "waiting", "delayed"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and state not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def type(self):
        """Gets the type of this Job.  # noqa: E501


        :return: The type of this Job.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Job.


        :param type: The type of this Job.  # noqa: E501
        :type type: str
        """
        allowed_values = ["activitypub-http-unicast", "activitypub-http-broadcast", "activitypub-http-fetcher", "activitypub-follow", "video-file-import", "video-transcoding", "email", "video-import", "videos-views", "activitypub-refresher", "video-redundancy"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def data(self):
        """Gets the data of this Job.  # noqa: E501


        :return: The data of this Job.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._data

    @data.setter
    def data(self, data):
        """Sets the data of this Job.


        :param data: The data of this Job.  # noqa: E501
        :type data: dict(str, object)
        """

        self._data = data

    @property
    def error(self):
        """Gets the error of this Job.  # noqa: E501


        :return: The error of this Job.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this Job.


        :param error: The error of this Job.  # noqa: E501
        :type error: dict(str, object)
        """

        self._error = error

    @property
    def created_at(self):
        """Gets the created_at of this Job.  # noqa: E501


        :return: The created_at of this Job.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Job.


        :param created_at: The created_at of this Job.  # noqa: E501
        :type created_at: datetime
        """

        self._created_at = created_at

    @property
    def finished_on(self):
        """Gets the finished_on of this Job.  # noqa: E501


        :return: The finished_on of this Job.  # noqa: E501
        :rtype: datetime
        """
        return self._finished_on

    @finished_on.setter
    def finished_on(self, finished_on):
        """Sets the finished_on of this Job.


        :param finished_on: The finished_on of this Job.  # noqa: E501
        :type finished_on: datetime
        """

        self._finished_on = finished_on

    @property
    def processed_on(self):
        """Gets the processed_on of this Job.  # noqa: E501


        :return: The processed_on of this Job.  # noqa: E501
        :rtype: datetime
        """
        return self._processed_on

    @processed_on.setter
    def processed_on(self, processed_on):
        """Sets the processed_on of this Job.


        :param processed_on: The processed_on of this Job.  # noqa: E501
        :type processed_on: datetime
        """

        self._processed_on = processed_on

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Job):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Job):
            return True

        return self.to_dict() != other.to_dict()
