/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.render;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.imageio.ImageIO;
import net.osmand.PlatformUtil;
import net.sourceforge.offroad.OsmWindow;
import org.apache.commons.logging.Log;

public class RenderingIcons {
    private static final Log log = PlatformUtil.getLog(RenderingIcons.class);
    private static Map<String, JarEntry> shaderIcons = new LinkedHashMap<String, JarEntry>();
    private static Map<String, JarEntry> smallIcons = new LinkedHashMap<String, JarEntry>();
    private static Map<String, JarEntry> bigIcons = new LinkedHashMap<String, JarEntry>();
    private static Map<String, BufferedImage> iconsBmp = new LinkedHashMap<String, BufferedImage>();
    static URL sJarResource;

    public static boolean containsSmallIcon(String s) {
        return smallIcons.containsKey(s);
    }

    public static boolean containsBigIcon(String s) {
        return bigIcons.containsKey(s);
    }

    public static byte[] getIconRawData(String s) {
        JarEntry resId = shaderIcons.get(s);
        if (resId == null) {
            resId = smallIcons.get(s);
        }
        if (resId == null) {
            return null;
        }
        try {
            int bytesRead;
            InputStream inputStream = RenderingIcons.getIconStream(resId);
            ByteArrayOutputStream proxyOutputStream = new ByteArrayOutputStream(1024);
            byte[] ioBuffer = new byte[1024];
            while ((bytesRead = inputStream.read(ioBuffer)) >= 0) {
                proxyOutputStream.write(ioBuffer, 0, bytesRead);
            }
            inputStream.close();
            byte[] bitmapData = proxyOutputStream.toByteArray();
            log.info((Object)("Icon data length is " + bitmapData.length));
            return bitmapData;
        }
        catch (Throwable e) {
            log.error((Object)"Failed to get byte stream from icon", e);
            return null;
        }
    }

    public static BufferedImage getBigIcon(String s) {
        JarEntry resId = bigIcons.get(s);
        if (resId != null) {
            try {
                return ImageIO.read(RenderingIcons.getIconStream(resId));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static BufferedImage getIcon(String s, boolean includeShader) {
        if (s == null) {
            return null;
        }
        if (includeShader && shaderIcons.containsKey(s)) {
            s = "h_" + s;
        }
        if (!iconsBmp.containsKey(s)) {
            JarEntry resId;
            JarEntry jarEntry = resId = s.startsWith("h_") ? shaderIcons.get(s.substring(2)) : smallIcons.get(s);
            if (resId != null) {
                try {
                    BufferedImage bmp = ImageIO.read(RenderingIcons.getIconStream(resId));
                    iconsBmp.put(s, bmp);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    iconsBmp.put(s, null);
                }
            } else {
                iconsBmp.put(s, null);
            }
        }
        return iconsBmp.get(s);
    }

    public static InputStream getIconStream(JarEntry resId) throws IOException {
        URLConnection urlCon = sJarResource.openConnection();
        JarFile jar = ((JarURLConnection)urlCon).getJarFile();
        return jar.getInputStream(resId);
    }

    public static JarEntry getResId(String id2) {
        return id2.startsWith("h_") ? shaderIcons.get(id2.substring(2)) : smallIcons.get(id2);
    }

    public static void initIcons() {
        iconsBmp.clear();
        try {
            OsmWindow context = OsmWindow.getInstance();
            String osmandIconsDir = context.getOsmandIconsDir();
            Enumeration<URL> en = context.getClass().getClassLoader().getResources(osmandIconsDir);
            System.out.println("icon resources present: " + en.hasMoreElements());
            while (en.hasMoreElements()) {
                URL resource = en.nextElement();
                System.out.println("Trying resource " + resource);
                URLConnection conn = resource.openConnection();
                if (!(conn instanceof JarURLConnection)) continue;
                JarURLConnection urlcon = (JarURLConnection)conn;
                JarFile jar = urlcon.getJarFile();
                Throwable throwable = null;
                try {
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry jarEntry = entries.nextElement();
                        String entry = jarEntry.getName();
                        if (!entry.startsWith(osmandIconsDir)) continue;
                        sJarResource = resource;
                        String f = entry.toString().substring(osmandIconsDir.length()).replaceFirst("\\.png", "");
                        if (f.startsWith("h_")) {
                            shaderIcons.put(f.substring(2), jarEntry);
                            continue;
                        }
                        if (f.startsWith("mm_")) {
                            smallIcons.put(f.substring(3), jarEntry);
                            continue;
                        }
                        if (!f.startsWith("mx_")) continue;
                        bigIcons.put(f.substring(3), jarEntry);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jar == null) continue;
                    if (throwable != null) {
                        try {
                            jar.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jar.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println(e);
        }
    }

    static {
        RenderingIcons.initIcons();
    }
}

