/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.fieldcaps;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.action.fieldcaps.IndexFieldCapabilities;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

public class FieldCapabilitiesIndexResponse
extends ActionResponse
implements Writeable {
    private final String indexName;
    private final Map<String, IndexFieldCapabilities> responseMap;
    private final boolean canMatch;

    FieldCapabilitiesIndexResponse(String indexName, Map<String, IndexFieldCapabilities> responseMap, boolean canMatch) {
        this.indexName = indexName;
        this.responseMap = responseMap;
        this.canMatch = canMatch;
    }

    FieldCapabilitiesIndexResponse(StreamInput in) throws IOException {
        super(in);
        this.indexName = in.readString();
        this.responseMap = in.readMap(StreamInput::readString, IndexFieldCapabilities::new);
        this.canMatch = in.getVersion().onOrAfter((Version)LegacyESVersion.V_7_9_0) ? in.readBoolean() : true;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public boolean canMatch() {
        return this.canMatch;
    }

    public Map<String, IndexFieldCapabilities> get() {
        return this.responseMap;
    }

    public IndexFieldCapabilities getField(String field) {
        return this.responseMap.get(field);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.indexName);
        out.writeMap(this.responseMap, StreamOutput::writeString, (valueOut, fc) -> fc.writeTo(valueOut));
        if (out.getVersion().onOrAfter((Version)LegacyESVersion.V_7_9_0)) {
            out.writeBoolean(this.canMatch);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FieldCapabilitiesIndexResponse that = (FieldCapabilitiesIndexResponse)((Object)o);
        return this.canMatch == that.canMatch && Objects.equals(this.indexName, that.indexName) && Objects.equals(this.responseMap, that.responseMap);
    }

    public int hashCode() {
        return Objects.hash(this.indexName, this.responseMap, this.canMatch);
    }
}

