/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.transport.TransportResponse;

public class ClusterSettingsResponse
extends TransportResponse {
    private final Settings clusterSettings;

    public ClusterSettingsResponse(ClusterService clusterService) {
        this.clusterSettings = clusterService.getSettings();
    }

    public ClusterSettingsResponse(StreamInput in) throws IOException {
        super(in);
        this.clusterSettings = Settings.readSettingsFromStream(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        Settings.writeSettingsToStream(this.clusterSettings, out);
    }

    public String toString() {
        return "ClusterSettingsResponse{clusterSettings=" + this.clusterSettings + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ClusterSettingsResponse that = (ClusterSettingsResponse)((Object)o);
        return Objects.equals(this.clusterSettings, that.clusterSettings);
    }

    public int hashCode() {
        return Objects.hash(this.clusterSettings);
    }
}

