/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util;

import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;

public class FeatureFlags {
    public static final String SEGMENT_REPLICATION_EXPERIMENTAL = "opensearch.experimental.feature.segment_replication_experimental.enabled";
    public static final String SEARCHABLE_SNAPSHOT_EXTENDED_COMPATIBILITY = "opensearch.experimental.feature.searchable_snapshot.extended_compatibility.enabled";
    public static final String EXTENSIONS = "opensearch.experimental.feature.extensions.enabled";
    public static final String IDENTITY = "opensearch.experimental.feature.identity.enabled";
    public static final String CONCURRENT_SEGMENT_SEARCH = "opensearch.experimental.feature.concurrent_segment_search.enabled";
    public static final String TELEMETRY = "opensearch.experimental.feature.telemetry.enabled";
    private static Settings settings;
    public static final Setting<Boolean> SEGMENT_REPLICATION_EXPERIMENTAL_SETTING;
    public static final Setting<Boolean> EXTENSIONS_SETTING;
    public static final Setting<Boolean> IDENTITY_SETTING;
    public static final Setting<Boolean> TELEMETRY_SETTING;
    public static final Setting<Boolean> CONCURRENT_SEGMENT_SEARCH_SETTING;

    public static void initializeFeatureFlags(Settings openSearchSettings) {
        settings = openSearchSettings;
    }

    public static boolean isEnabled(String featureFlagName) {
        if ("true".equalsIgnoreCase(System.getProperty(featureFlagName))) {
            return true;
        }
        return settings != null && settings.getAsBoolean(featureFlagName, false) != false;
    }

    static {
        SEGMENT_REPLICATION_EXPERIMENTAL_SETTING = Setting.boolSetting(SEGMENT_REPLICATION_EXPERIMENTAL, false, Setting.Property.NodeScope);
        EXTENSIONS_SETTING = Setting.boolSetting(EXTENSIONS, false, Setting.Property.NodeScope);
        IDENTITY_SETTING = Setting.boolSetting(IDENTITY, false, Setting.Property.NodeScope);
        TELEMETRY_SETTING = Setting.boolSetting(TELEMETRY, false, Setting.Property.NodeScope);
        CONCURRENT_SEGMENT_SEARCH_SETTING = Setting.boolSetting(CONCURRENT_SEGMENT_SEARCH, false, Setting.Property.NodeScope);
    }
}

