"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _constants = require("../../utils/constants");

var _configSchema = require("@osd/config-schema");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function _default(services, router) {
  const {
    transformService
  } = services;
  router.get({
    path: _constants.NODE_API.TRANSFORMS,
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.number(),
        size: _configSchema.schema.number(),
        search: _configSchema.schema.string(),
        sortField: _configSchema.schema.string(),
        sortDirection: _configSchema.schema.string()
      })
    }
  }, transformService.getTransforms);
  router.get({
    path: `${_constants.NODE_API.TRANSFORMS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, transformService.getTransform);
  router.post({
    path: `${_constants.NODE_API.TRANSFORMS}/{id}/_stop`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, transformService.stopTransform);
  router.post({
    path: `${_constants.NODE_API.TRANSFORMS}/{id}/_start`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, transformService.startTransform);
  router.delete({
    path: `${_constants.NODE_API.TRANSFORMS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, transformService.deleteTransform);
  router.put({
    path: `${_constants.NODE_API.TRANSFORMS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        seqNo: _configSchema.schema.maybe(_configSchema.schema.number()),
        primaryTerm: _configSchema.schema.maybe(_configSchema.schema.number())
      }),
      body: _configSchema.schema.any()
    }
  }, transformService.putTransform);
  router.post({
    path: `${_constants.NODE_API._SEARCH_SAMPLE_DATA}/{index}`,
    validate: {
      params: _configSchema.schema.object({
        index: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        from: _configSchema.schema.number(),
        size: _configSchema.schema.number()
      }),
      body: _configSchema.schema.any()
    }
  }, transformService.searchSampleData);
  router.post({
    path: `${_constants.NODE_API.TRANSFORMS}/_preview`,
    validate: {
      body: _configSchema.schema.object({
        transform: _configSchema.schema.any()
      })
    }
  }, transformService.previewTransform);
}

module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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