from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.StepGeom import *
from OCC.Core.TCollection import *
from OCC.Core.StepRepr import *
from OCC.Core.StepData import *
from OCC.Core.StepBasic import *


class StepShape_Array1OfConnectedEdgeSet:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class StepShape_Array1OfConnectedFaceSet:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class StepShape_Array1OfEdge:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class StepShape_Array1OfFace:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class StepShape_Array1OfFaceBound:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class StepShape_Array1OfGeometricSetSelect:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> StepShape_GeometricSetSelect: ...
    def __setitem__(self, index: int, value: StepShape_GeometricSetSelect) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[StepShape_GeometricSetSelect]: ...
    def next(self) -> StepShape_GeometricSetSelect: ...
    __next__ = next
    def Init(self, theValue: StepShape_GeometricSetSelect) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> StepShape_GeometricSetSelect: ...
    def Last(self) -> StepShape_GeometricSetSelect: ...
    def Value(self, theIndex: int) -> StepShape_GeometricSetSelect: ...
    def SetValue(self, theIndex: int, theValue: StepShape_GeometricSetSelect) -> None: ...

class StepShape_Array1OfOrientedClosedShell:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class StepShape_Array1OfOrientedEdge:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class StepShape_Array1OfShapeDimensionRepresentationItem:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> StepShape_ShapeDimensionRepresentationItem: ...
    def __setitem__(self, index: int, value: StepShape_ShapeDimensionRepresentationItem) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[StepShape_ShapeDimensionRepresentationItem]: ...
    def next(self) -> StepShape_ShapeDimensionRepresentationItem: ...
    __next__ = next
    def Init(self, theValue: StepShape_ShapeDimensionRepresentationItem) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> StepShape_ShapeDimensionRepresentationItem: ...
    def Last(self) -> StepShape_ShapeDimensionRepresentationItem: ...
    def Value(self, theIndex: int) -> StepShape_ShapeDimensionRepresentationItem: ...
    def SetValue(self, theIndex: int, theValue: StepShape_ShapeDimensionRepresentationItem) -> None: ...

class StepShape_Array1OfShell:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> StepShape_Shell: ...
    def __setitem__(self, index: int, value: StepShape_Shell) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[StepShape_Shell]: ...
    def next(self) -> StepShape_Shell: ...
    __next__ = next
    def Init(self, theValue: StepShape_Shell) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> StepShape_Shell: ...
    def Last(self) -> StepShape_Shell: ...
    def Value(self, theIndex: int) -> StepShape_Shell: ...
    def SetValue(self, theIndex: int, theValue: StepShape_Shell) -> None: ...

class StepShape_Array1OfValueQualifier:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> StepShape_ValueQualifier: ...
    def __setitem__(self, index: int, value: StepShape_ValueQualifier) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[StepShape_ValueQualifier]: ...
    def next(self) -> StepShape_ValueQualifier: ...
    __next__ = next
    def Init(self, theValue: StepShape_ValueQualifier) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> StepShape_ValueQualifier: ...
    def Last(self) -> StepShape_ValueQualifier: ...
    def Value(self, theIndex: int) -> StepShape_ValueQualifier: ...
    def SetValue(self, theIndex: int, theValue: StepShape_ValueQualifier) -> None: ...

class StepShape_AngleRelator(IntEnum):
    StepShape_Equal: int = ...
    StepShape_Large: int = ...
    StepShape_Small: int = ...

StepShape_Equal = StepShape_AngleRelator.StepShape_Equal
StepShape_Large = StepShape_AngleRelator.StepShape_Large
StepShape_Small = StepShape_AngleRelator.StepShape_Small

class StepShape_BooleanOperator(IntEnum):
    StepShape_boDifference: int = ...
    StepShape_boIntersection: int = ...
    StepShape_boUnion: int = ...

StepShape_boDifference = StepShape_BooleanOperator.StepShape_boDifference
StepShape_boIntersection = StepShape_BooleanOperator.StepShape_boIntersection
StepShape_boUnion = StepShape_BooleanOperator.StepShape_boUnion

class StepShape_Block(StepGeom_GeometricRepresentationItem):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aPosition: StepGeom_Axis2Placement3d, aX: float, aY: float, aZ: float) -> None: ...
    def Position(self) -> StepGeom_Axis2Placement3d: ...
    def SetPosition(self, aPosition: StepGeom_Axis2Placement3d) -> None: ...
    def SetX(self, aX: float) -> None: ...
    def SetY(self, aY: float) -> None: ...
    def SetZ(self, aZ: float) -> None: ...
    def X(self) -> float: ...
    def Y(self) -> float: ...
    def Z(self) -> float: ...

class StepShape_BooleanOperand:
    def __init__(self) -> None: ...
    def BooleanResult(self) -> StepShape_BooleanResult: ...
    def CsgPrimitive(self) -> StepShape_CsgPrimitive: ...
    def HalfSpaceSolid(self) -> StepShape_HalfSpaceSolid: ...
    def SetBooleanResult(self, aBooleanResult: StepShape_BooleanResult) -> None: ...
    def SetCsgPrimitive(self, aCsgPrimitive: StepShape_CsgPrimitive) -> None: ...
    def SetHalfSpaceSolid(self, aHalfSpaceSolid: StepShape_HalfSpaceSolid) -> None: ...
    def SetSolidModel(self, aSolidModel: StepShape_SolidModel) -> None: ...
    def SetTypeOfContent(self, aTypeOfContent: int) -> None: ...
    def SolidModel(self) -> StepShape_SolidModel: ...
    def TypeOfContent(self) -> int: ...

class StepShape_BooleanResult(StepGeom_GeometricRepresentationItem):
    def __init__(self) -> None: ...
    def FirstOperand(self) -> StepShape_BooleanOperand: ...
    def Init(self, aName: TCollection_HAsciiString, aOperator: StepShape_BooleanOperator, aFirstOperand: StepShape_BooleanOperand, aSecondOperand: StepShape_BooleanOperand) -> None: ...
    def Operator(self) -> StepShape_BooleanOperator: ...
    def SecondOperand(self) -> StepShape_BooleanOperand: ...
    def SetFirstOperand(self, aFirstOperand: StepShape_BooleanOperand) -> None: ...
    def SetOperator(self, aOperator: StepShape_BooleanOperator) -> None: ...
    def SetSecondOperand(self, aSecondOperand: StepShape_BooleanOperand) -> None: ...

class StepShape_BoxDomain(Standard_Transient):
    def __init__(self) -> None: ...
    def Corner(self) -> StepGeom_CartesianPoint: ...
    def Init(self, aCorner: StepGeom_CartesianPoint, aXlength: float, aYlength: float, aZlength: float) -> None: ...
    def SetCorner(self, aCorner: StepGeom_CartesianPoint) -> None: ...
    def SetXlength(self, aXlength: float) -> None: ...
    def SetYlength(self, aYlength: float) -> None: ...
    def SetZlength(self, aZlength: float) -> None: ...
    def Xlength(self) -> float: ...
    def Ylength(self) -> float: ...
    def Zlength(self) -> float: ...

class StepShape_ConnectedFaceShapeRepresentation(StepRepr_Representation):
    def __init__(self) -> None: ...

class StepShape_ContextDependentShapeRepresentation(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(self, aRepRel: StepRepr_ShapeRepresentationRelationship, aProRel: StepRepr_ProductDefinitionShape) -> None: ...
    def RepresentationRelation(self) -> StepRepr_ShapeRepresentationRelationship: ...
    def RepresentedProductRelation(self) -> StepRepr_ProductDefinitionShape: ...
    def SetRepresentationRelation(self, aRepRel: StepRepr_ShapeRepresentationRelationship) -> None: ...
    def SetRepresentedProductRelation(self, aProRel: StepRepr_ProductDefinitionShape) -> None: ...

class StepShape_CsgPrimitive(StepData_SelectType):
    def __init__(self) -> None: ...
    def Block(self) -> StepShape_Block: ...
    def CaseNum(self, ent: Standard_Transient) -> int: ...
    def RightAngularWedge(self) -> StepShape_RightAngularWedge: ...
    def RightCircularCone(self) -> StepShape_RightCircularCone: ...
    def RightCircularCylinder(self) -> StepShape_RightCircularCylinder: ...
    def Sphere(self) -> StepShape_Sphere: ...
    def Torus(self) -> StepShape_Torus: ...

class StepShape_CsgSelect:
    def __init__(self) -> None: ...
    def BooleanResult(self) -> StepShape_BooleanResult: ...
    def CsgPrimitive(self) -> StepShape_CsgPrimitive: ...
    def SetBooleanResult(self, aBooleanResult: StepShape_BooleanResult) -> None: ...
    def SetCsgPrimitive(self, aCsgPrimitive: StepShape_CsgPrimitive) -> None: ...
    def SetTypeOfContent(self, aTypeOfContent: int) -> None: ...
    def TypeOfContent(self) -> int: ...

class StepShape_DefinitionalRepresentationAndShapeRepresentation(StepRepr_DefinitionalRepresentation):
    def __init__(self) -> None: ...

class StepShape_DimensionalCharacteristic(StepData_SelectType):
    def __init__(self) -> None: ...
    def CaseNum(self, ent: Standard_Transient) -> int: ...
    def DimensionalLocation(self) -> StepShape_DimensionalLocation: ...
    def DimensionalSize(self) -> StepShape_DimensionalSize: ...

class StepShape_DimensionalCharacteristicRepresentation(Standard_Transient):
    def __init__(self) -> None: ...
    def Dimension(self) -> StepShape_DimensionalCharacteristic: ...
    def Init(self, aDimension: StepShape_DimensionalCharacteristic, aRepresentation: StepShape_ShapeDimensionRepresentation) -> None: ...
    def Representation(self) -> StepShape_ShapeDimensionRepresentation: ...
    def SetDimension(self, Dimension: StepShape_DimensionalCharacteristic) -> None: ...
    def SetRepresentation(self, Representation: StepShape_ShapeDimensionRepresentation) -> None: ...

class StepShape_DimensionalLocation(StepRepr_ShapeAspectRelationship):
    def __init__(self) -> None: ...

class StepShape_DimensionalSize(Standard_Transient):
    def __init__(self) -> None: ...
    def AppliesTo(self) -> StepRepr_ShapeAspect: ...
    def Init(self, aAppliesTo: StepRepr_ShapeAspect, aName: TCollection_HAsciiString) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def SetAppliesTo(self, AppliesTo: StepRepr_ShapeAspect) -> None: ...
    def SetName(self, Name: TCollection_HAsciiString) -> None: ...

class StepShape_EdgeBasedWireframeModel(StepGeom_GeometricRepresentationItem):
    def __init__(self) -> None: ...
    def EbwmBoundary(self) -> StepShape_HArray1OfConnectedEdgeSet: ...
    def Init(self, aRepresentationItem_Name: TCollection_HAsciiString, aEbwmBoundary: StepShape_HArray1OfConnectedEdgeSet) -> None: ...
    def SetEbwmBoundary(self, EbwmBoundary: StepShape_HArray1OfConnectedEdgeSet) -> None: ...

class StepShape_FaceBasedSurfaceModel(StepGeom_GeometricRepresentationItem):
    def __init__(self) -> None: ...
    def FbsmFaces(self) -> StepShape_HArray1OfConnectedFaceSet: ...
    def Init(self, aRepresentationItem_Name: TCollection_HAsciiString, aFbsmFaces: StepShape_HArray1OfConnectedFaceSet) -> None: ...
    def SetFbsmFaces(self, FbsmFaces: StepShape_HArray1OfConnectedFaceSet) -> None: ...

class StepShape_GeometricSet(StepGeom_GeometricRepresentationItem):
    def __init__(self) -> None: ...
    def Elements(self) -> StepShape_HArray1OfGeometricSetSelect: ...
    def ElementsValue(self, num: int) -> StepShape_GeometricSetSelect: ...
    def Init(self, aName: TCollection_HAsciiString, aElements: StepShape_HArray1OfGeometricSetSelect) -> None: ...
    def NbElements(self) -> int: ...
    def SetElements(self, aElements: StepShape_HArray1OfGeometricSetSelect) -> None: ...

class StepShape_GeometricSetSelect(StepData_SelectType):
    def __init__(self) -> None: ...
    def CaseNum(self, ent: Standard_Transient) -> int: ...
    def Curve(self) -> StepGeom_Curve: ...
    def Point(self) -> StepGeom_Point: ...
    def Surface(self) -> StepGeom_Surface: ...

class StepShape_HalfSpaceSolid(StepGeom_GeometricRepresentationItem):
    def __init__(self) -> None: ...
    def AgreementFlag(self) -> bool: ...
    def BaseSurface(self) -> StepGeom_Surface: ...
    def Init(self, aName: TCollection_HAsciiString, aBaseSurface: StepGeom_Surface, aAgreementFlag: bool) -> None: ...
    def SetAgreementFlag(self, aAgreementFlag: bool) -> None: ...
    def SetBaseSurface(self, aBaseSurface: StepGeom_Surface) -> None: ...

class StepShape_LimitsAndFits(Standard_Transient):
    def __init__(self) -> None: ...
    def FormVariance(self) -> TCollection_HAsciiString: ...
    def Grade(self) -> TCollection_HAsciiString: ...
    def Init(self, form_variance: TCollection_HAsciiString, zone_variance: TCollection_HAsciiString, grade: TCollection_HAsciiString, source: TCollection_HAsciiString) -> None: ...
    def SetFormVariance(self, form_variance: TCollection_HAsciiString) -> None: ...
    def SetGrade(self, grade: TCollection_HAsciiString) -> None: ...
    def SetSource(self, source: TCollection_HAsciiString) -> None: ...
    def SetZoneVariance(self, zone_variance: TCollection_HAsciiString) -> None: ...
    def Source(self) -> TCollection_HAsciiString: ...
    def ZoneVariance(self) -> TCollection_HAsciiString: ...

class StepShape_MeasureQualification(Standard_Transient):
    def __init__(self) -> None: ...
    def Description(self) -> TCollection_HAsciiString: ...
    def Init(self, name: TCollection_HAsciiString, description: TCollection_HAsciiString, qualified_measure: StepBasic_MeasureWithUnit, qualifiers: StepShape_HArray1OfValueQualifier) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def NbQualifiers(self) -> int: ...
    def QualifiedMeasure(self) -> StepBasic_MeasureWithUnit: ...
    def Qualifiers(self) -> StepShape_HArray1OfValueQualifier: ...
    def QualifiersValue(self, num: int) -> StepShape_ValueQualifier: ...
    def SetDescription(self, description: TCollection_HAsciiString) -> None: ...
    def SetName(self, name: TCollection_HAsciiString) -> None: ...
    def SetQualifiedMeasure(self, qualified_measure: StepBasic_MeasureWithUnit) -> None: ...
    def SetQualifiers(self, qualifiers: StepShape_HArray1OfValueQualifier) -> None: ...
    def SetQualifiersValue(self, num: int, aqualifier: StepShape_ValueQualifier) -> None: ...

class StepShape_MeasureRepresentationItemAndQualifiedRepresentationItem(StepRepr_RepresentationItem):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aValueComponent: StepBasic_MeasureValueMember, aUnitComponent: StepBasic_Unit, qualifiers: StepShape_HArray1OfValueQualifier) -> None: ...
    def Measure(self) -> StepBasic_MeasureWithUnit: ...
    def NbQualifiers(self) -> int: ...
    def Qualifiers(self) -> StepShape_HArray1OfValueQualifier: ...
    def QualifiersValue(self, num: int) -> StepShape_ValueQualifier: ...
    def SetMeasure(self, Measure: StepBasic_MeasureWithUnit) -> None: ...
    def SetQualifiers(self, qualifiers: StepShape_HArray1OfValueQualifier) -> None: ...
    def SetQualifiersValue(self, num: int, aqualifier: StepShape_ValueQualifier) -> None: ...

class StepShape_PlusMinusTolerance(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(self, range: StepShape_ToleranceMethodDefinition, toleranced_dimension: StepShape_DimensionalCharacteristic) -> None: ...
    def Range(self) -> StepShape_ToleranceMethodDefinition: ...
    def SetRange(self, range: StepShape_ToleranceMethodDefinition) -> None: ...
    def SetTolerancedDimension(self, toleranced_dimension: StepShape_DimensionalCharacteristic) -> None: ...
    def TolerancedDimension(self) -> StepShape_DimensionalCharacteristic: ...

class StepShape_PrecisionQualifier(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(self, precision_value: int) -> None: ...
    def PrecisionValue(self) -> int: ...
    def SetPrecisionValue(self, precision_value: int) -> None: ...

class StepShape_QualifiedRepresentationItem(StepRepr_RepresentationItem):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, qualifiers: StepShape_HArray1OfValueQualifier) -> None: ...
    def NbQualifiers(self) -> int: ...
    def Qualifiers(self) -> StepShape_HArray1OfValueQualifier: ...
    def QualifiersValue(self, num: int) -> StepShape_ValueQualifier: ...
    def SetQualifiers(self, qualifiers: StepShape_HArray1OfValueQualifier) -> None: ...
    def SetQualifiersValue(self, num: int, aqualifier: StepShape_ValueQualifier) -> None: ...

class StepShape_ReversibleTopologyItem(StepData_SelectType):
    def __init__(self) -> None: ...
    def CaseNum(self, ent: Standard_Transient) -> int: ...
    def ClosedShell(self) -> StepShape_ClosedShell: ...
    def Edge(self) -> StepShape_Edge: ...
    def Face(self) -> StepShape_Face: ...
    def FaceBound(self) -> StepShape_FaceBound: ...
    def OpenShell(self) -> StepShape_OpenShell: ...
    def Path(self) -> StepShape_Path: ...

class StepShape_RightAngularWedge(StepGeom_GeometricRepresentationItem):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aPosition: StepGeom_Axis2Placement3d, aX: float, aY: float, aZ: float, aLtx: float) -> None: ...
    def Ltx(self) -> float: ...
    def Position(self) -> StepGeom_Axis2Placement3d: ...
    def SetLtx(self, aLtx: float) -> None: ...
    def SetPosition(self, aPosition: StepGeom_Axis2Placement3d) -> None: ...
    def SetX(self, aX: float) -> None: ...
    def SetY(self, aY: float) -> None: ...
    def SetZ(self, aZ: float) -> None: ...
    def X(self) -> float: ...
    def Y(self) -> float: ...
    def Z(self) -> float: ...

class StepShape_RightCircularCone(StepGeom_GeometricRepresentationItem):
    def __init__(self) -> None: ...
    def Height(self) -> float: ...
    def Init(self, aName: TCollection_HAsciiString, aPosition: StepGeom_Axis1Placement, aHeight: float, aRadius: float, aSemiAngle: float) -> None: ...
    def Position(self) -> StepGeom_Axis1Placement: ...
    def Radius(self) -> float: ...
    def SemiAngle(self) -> float: ...
    def SetHeight(self, aHeight: float) -> None: ...
    def SetPosition(self, aPosition: StepGeom_Axis1Placement) -> None: ...
    def SetRadius(self, aRadius: float) -> None: ...
    def SetSemiAngle(self, aSemiAngle: float) -> None: ...

class StepShape_RightCircularCylinder(StepGeom_GeometricRepresentationItem):
    def __init__(self) -> None: ...
    def Height(self) -> float: ...
    def Init(self, aName: TCollection_HAsciiString, aPosition: StepGeom_Axis1Placement, aHeight: float, aRadius: float) -> None: ...
    def Position(self) -> StepGeom_Axis1Placement: ...
    def Radius(self) -> float: ...
    def SetHeight(self, aHeight: float) -> None: ...
    def SetPosition(self, aPosition: StepGeom_Axis1Placement) -> None: ...
    def SetRadius(self, aRadius: float) -> None: ...

class StepShape_ShapeDefinitionRepresentation(StepRepr_PropertyDefinitionRepresentation):
    def __init__(self) -> None: ...

class StepShape_ShapeDimensionRepresentationItem(StepData_SelectType):
    def __init__(self) -> None: ...
    def CaseNum(self, ent: Standard_Transient) -> int: ...
    def CompoundRepresentationItem(self) -> StepRepr_CompoundRepresentationItem: ...
    def DescriptiveRepresentationItem(self) -> StepRepr_DescriptiveRepresentationItem: ...
    def MeasureRepresentationItem(self) -> StepRepr_MeasureRepresentationItem: ...
    def Placement(self) -> StepGeom_Placement: ...

class StepShape_ShapeRepresentation(StepRepr_Representation):
    def __init__(self) -> None: ...

class StepShape_Shell(StepData_SelectType):
    def __init__(self) -> None: ...
    def CaseNum(self, ent: Standard_Transient) -> int: ...
    def ClosedShell(self) -> StepShape_ClosedShell: ...
    def OpenShell(self) -> StepShape_OpenShell: ...

class StepShape_ShellBasedSurfaceModel(StepGeom_GeometricRepresentationItem):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aSbsmBoundary: StepShape_HArray1OfShell) -> None: ...
    def NbSbsmBoundary(self) -> int: ...
    def SbsmBoundary(self) -> StepShape_HArray1OfShell: ...
    def SbsmBoundaryValue(self, num: int) -> StepShape_Shell: ...
    def SetSbsmBoundary(self, aSbsmBoundary: StepShape_HArray1OfShell) -> None: ...

class StepShape_SolidModel(StepGeom_GeometricRepresentationItem):
    def __init__(self) -> None: ...

class StepShape_Sphere(StepGeom_GeometricRepresentationItem):
    def __init__(self) -> None: ...
    def Centre(self) -> StepGeom_Point: ...
    def Init(self, aName: TCollection_HAsciiString, aRadius: float, aCentre: StepGeom_Point) -> None: ...
    def Radius(self) -> float: ...
    def SetCentre(self, aCentre: StepGeom_Point) -> None: ...
    def SetRadius(self, aRadius: float) -> None: ...

class StepShape_SurfaceModel(StepData_SelectType):
    def __init__(self) -> None: ...
    def CaseNum(self, ent: Standard_Transient) -> int: ...
    def ShellBasedSurfaceModel(self) -> StepShape_ShellBasedSurfaceModel: ...

class StepShape_ToleranceMethodDefinition(StepData_SelectType):
    def __init__(self) -> None: ...
    def CaseNum(self, ent: Standard_Transient) -> int: ...
    def LimitsAndFits(self) -> StepShape_LimitsAndFits: ...
    def ToleranceValue(self) -> StepShape_ToleranceValue: ...

class StepShape_ToleranceValue(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(self, lower_bound: Standard_Transient, upper_bound: Standard_Transient) -> None: ...
    def LowerBound(self) -> Standard_Transient: ...
    def SetLowerBound(self, lower_bound: Standard_Transient) -> None: ...
    def SetUpperBound(self, upper_bound: Standard_Transient) -> None: ...
    def UpperBound(self) -> Standard_Transient: ...

class StepShape_TopologicalRepresentationItem(StepRepr_RepresentationItem):
    def __init__(self) -> None: ...

class StepShape_Torus(StepGeom_GeometricRepresentationItem):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aPosition: StepGeom_Axis1Placement, aMajorRadius: float, aMinorRadius: float) -> None: ...
    def MajorRadius(self) -> float: ...
    def MinorRadius(self) -> float: ...
    def Position(self) -> StepGeom_Axis1Placement: ...
    def SetMajorRadius(self, aMajorRadius: float) -> None: ...
    def SetMinorRadius(self, aMinorRadius: float) -> None: ...
    def SetPosition(self, aPosition: StepGeom_Axis1Placement) -> None: ...

class StepShape_TypeQualifier(Standard_Transient):
    def __init__(self) -> None: ...
    def Init(self, name: TCollection_HAsciiString) -> None: ...
    def Name(self) -> TCollection_HAsciiString: ...
    def SetName(self, name: TCollection_HAsciiString) -> None: ...

class StepShape_ValueFormatTypeQualifier(Standard_Transient):
    def __init__(self) -> None: ...
    def FormatType(self) -> TCollection_HAsciiString: ...
    def Init(self, theFormatType: TCollection_HAsciiString) -> None: ...
    def SetFormatType(self, theFormatType: TCollection_HAsciiString) -> None: ...

class StepShape_ValueQualifier(StepData_SelectType):
    def __init__(self) -> None: ...
    def CaseNum(self, ent: Standard_Transient) -> int: ...
    def PrecisionQualifier(self) -> StepShape_PrecisionQualifier: ...
    def TypeQualifier(self) -> StepShape_TypeQualifier: ...
    def ValueFormatTypeQualifier(self) -> StepShape_ValueFormatTypeQualifier: ...

class StepShape_AdvancedBrepShapeRepresentation(StepShape_ShapeRepresentation):
    def __init__(self) -> None: ...

class StepShape_AngularLocation(StepShape_DimensionalLocation):
    def __init__(self) -> None: ...
    def AngleSelection(self) -> StepShape_AngleRelator: ...
    def Init(self, aShapeAspectRelationship_Name: TCollection_HAsciiString, hasShapeAspectRelationship_Description: bool, aShapeAspectRelationship_Description: TCollection_HAsciiString, aShapeAspectRelationship_RelatingShapeAspect: StepRepr_ShapeAspect, aShapeAspectRelationship_RelatedShapeAspect: StepRepr_ShapeAspect, aAngleSelection: StepShape_AngleRelator) -> None: ...
    def SetAngleSelection(self, AngleSelection: StepShape_AngleRelator) -> None: ...

class StepShape_AngularSize(StepShape_DimensionalSize):
    def __init__(self) -> None: ...
    def AngleSelection(self) -> StepShape_AngleRelator: ...
    def Init(self, aDimensionalSize_AppliesTo: StepRepr_ShapeAspect, aDimensionalSize_Name: TCollection_HAsciiString, aAngleSelection: StepShape_AngleRelator) -> None: ...
    def SetAngleSelection(self, AngleSelection: StepShape_AngleRelator) -> None: ...

class StepShape_BoxedHalfSpace(StepShape_HalfSpaceSolid):
    def __init__(self) -> None: ...
    def Enclosure(self) -> StepShape_BoxDomain: ...
    def Init(self, aName: TCollection_HAsciiString, aBaseSurface: StepGeom_Surface, aAgreementFlag: bool, aEnclosure: StepShape_BoxDomain) -> None: ...
    def SetEnclosure(self, aEnclosure: StepShape_BoxDomain) -> None: ...

class StepShape_CompoundShapeRepresentation(StepShape_ShapeRepresentation):
    def __init__(self) -> None: ...

class StepShape_ConnectedEdgeSet(StepShape_TopologicalRepresentationItem):
    def __init__(self) -> None: ...
    def CesEdges(self) -> StepShape_HArray1OfEdge: ...
    def Init(self, aRepresentationItem_Name: TCollection_HAsciiString, aCesEdges: StepShape_HArray1OfEdge) -> None: ...
    def SetCesEdges(self, CesEdges: StepShape_HArray1OfEdge) -> None: ...

class StepShape_ConnectedFaceSet(StepShape_TopologicalRepresentationItem):
    def __init__(self) -> None: ...
    def CfsFaces(self) -> StepShape_HArray1OfFace: ...
    def CfsFacesValue(self, num: int) -> StepShape_Face: ...
    def Init(self, aName: TCollection_HAsciiString, aCfsFaces: StepShape_HArray1OfFace) -> None: ...
    def NbCfsFaces(self) -> int: ...
    def SetCfsFaces(self, aCfsFaces: StepShape_HArray1OfFace) -> None: ...

class StepShape_CsgShapeRepresentation(StepShape_ShapeRepresentation):
    def __init__(self) -> None: ...

class StepShape_CsgSolid(StepShape_SolidModel):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aTreeRootExpression: StepShape_CsgSelect) -> None: ...
    def SetTreeRootExpression(self, aTreeRootExpression: StepShape_CsgSelect) -> None: ...
    def TreeRootExpression(self) -> StepShape_CsgSelect: ...

class StepShape_DimensionalLocationWithPath(StepShape_DimensionalLocation):
    def __init__(self) -> None: ...
    def Init(self, aShapeAspectRelationship_Name: TCollection_HAsciiString, hasShapeAspectRelationship_Description: bool, aShapeAspectRelationship_Description: TCollection_HAsciiString, aShapeAspectRelationship_RelatingShapeAspect: StepRepr_ShapeAspect, aShapeAspectRelationship_RelatedShapeAspect: StepRepr_ShapeAspect, aPath: StepRepr_ShapeAspect) -> None: ...
    def Path(self) -> StepRepr_ShapeAspect: ...
    def SetPath(self, Path: StepRepr_ShapeAspect) -> None: ...

class StepShape_DimensionalSizeWithPath(StepShape_DimensionalSize):
    def __init__(self) -> None: ...
    def Init(self, aDimensionalSize_AppliesTo: StepRepr_ShapeAspect, aDimensionalSize_Name: TCollection_HAsciiString, aPath: StepRepr_ShapeAspect) -> None: ...
    def Path(self) -> StepRepr_ShapeAspect: ...
    def SetPath(self, Path: StepRepr_ShapeAspect) -> None: ...

class StepShape_DirectedDimensionalLocation(StepShape_DimensionalLocation):
    def __init__(self) -> None: ...

class StepShape_Edge(StepShape_TopologicalRepresentationItem):
    def __init__(self) -> None: ...
    def EdgeEnd(self) -> StepShape_Vertex: ...
    def EdgeStart(self) -> StepShape_Vertex: ...
    def Init(self, aName: TCollection_HAsciiString, aEdgeStart: StepShape_Vertex, aEdgeEnd: StepShape_Vertex) -> None: ...
    def SetEdgeEnd(self, aEdgeEnd: StepShape_Vertex) -> None: ...
    def SetEdgeStart(self, aEdgeStart: StepShape_Vertex) -> None: ...

class StepShape_EdgeBasedWireframeShapeRepresentation(StepShape_ShapeRepresentation):
    def __init__(self) -> None: ...

class StepShape_Face(StepShape_TopologicalRepresentationItem):
    def __init__(self) -> None: ...
    def Bounds(self) -> StepShape_HArray1OfFaceBound: ...
    def BoundsValue(self, num: int) -> StepShape_FaceBound: ...
    def Init(self, aName: TCollection_HAsciiString, aBounds: StepShape_HArray1OfFaceBound) -> None: ...
    def NbBounds(self) -> int: ...
    def SetBounds(self, aBounds: StepShape_HArray1OfFaceBound) -> None: ...

class StepShape_FaceBound(StepShape_TopologicalRepresentationItem):
    def __init__(self) -> None: ...
    def Bound(self) -> StepShape_Loop: ...
    def Init(self, aName: TCollection_HAsciiString, aBound: StepShape_Loop, aOrientation: bool) -> None: ...
    def Orientation(self) -> bool: ...
    def SetBound(self, aBound: StepShape_Loop) -> None: ...
    def SetOrientation(self, aOrientation: bool) -> None: ...

class StepShape_FacetedBrepShapeRepresentation(StepShape_ShapeRepresentation):
    def __init__(self) -> None: ...

class StepShape_GeometricCurveSet(StepShape_GeometricSet):
    def __init__(self) -> None: ...

class StepShape_GeometricallyBoundedSurfaceShapeRepresentation(StepShape_ShapeRepresentation):
    def __init__(self) -> None: ...

class StepShape_GeometricallyBoundedWireframeShapeRepresentation(StepShape_ShapeRepresentation):
    def __init__(self) -> None: ...

class StepShape_Loop(StepShape_TopologicalRepresentationItem):
    def __init__(self) -> None: ...

class StepShape_LoopAndPath(StepShape_TopologicalRepresentationItem):
    def __init__(self) -> None: ...
    def EdgeList(self) -> StepShape_HArray1OfOrientedEdge: ...
    def EdgeListValue(self, num: int) -> StepShape_OrientedEdge: ...
    @overload
    def Init(self, aName: TCollection_HAsciiString, aLoop: StepShape_Loop, aPath: StepShape_Path) -> None: ...
    @overload
    def Init(self, aName: TCollection_HAsciiString, aEdgeList: StepShape_HArray1OfOrientedEdge) -> None: ...
    def Loop(self) -> StepShape_Loop: ...
    def NbEdgeList(self) -> int: ...
    def Path(self) -> StepShape_Path: ...
    def SetEdgeList(self, aEdgeList: StepShape_HArray1OfOrientedEdge) -> None: ...
    def SetLoop(self, aLoop: StepShape_Loop) -> None: ...
    def SetPath(self, aPath: StepShape_Path) -> None: ...

class StepShape_ManifoldSolidBrep(StepShape_SolidModel):
    def __init__(self) -> None: ...
    @overload
    def Init(self, aName: TCollection_HAsciiString, aOuter: StepShape_ClosedShell) -> None: ...
    @overload
    def Init(self, aName: TCollection_HAsciiString, aOuter: StepShape_ConnectedFaceSet) -> None: ...
    def Outer(self) -> StepShape_ConnectedFaceSet: ...
    def SetOuter(self, aOuter: StepShape_ConnectedFaceSet) -> None: ...

class StepShape_ManifoldSurfaceShapeRepresentation(StepShape_ShapeRepresentation):
    def __init__(self) -> None: ...

class StepShape_NonManifoldSurfaceShapeRepresentation(StepShape_ShapeRepresentation):
    def __init__(self) -> None: ...

class StepShape_Path(StepShape_TopologicalRepresentationItem):
    def __init__(self) -> None: ...
    def EdgeList(self) -> StepShape_HArray1OfOrientedEdge: ...
    def EdgeListValue(self, num: int) -> StepShape_OrientedEdge: ...
    def Init(self, aName: TCollection_HAsciiString, aEdgeList: StepShape_HArray1OfOrientedEdge) -> None: ...
    def NbEdgeList(self) -> int: ...
    def SetEdgeList(self, aEdgeList: StepShape_HArray1OfOrientedEdge) -> None: ...

class StepShape_PointRepresentation(StepShape_ShapeRepresentation):
    def __init__(self) -> None: ...

class StepShape_ShapeDimensionRepresentation(StepShape_ShapeRepresentation):
    def __init__(self) -> None: ...
    @overload
    def Init(self, theName: TCollection_HAsciiString, theItems: StepRepr_HArray1OfRepresentationItem, theContextOfItems: StepRepr_RepresentationContext) -> None: ...
    @overload
    def Init(self, theName: TCollection_HAsciiString, theItems: StepShape_HArray1OfShapeDimensionRepresentationItem, theContextOfItems: StepRepr_RepresentationContext) -> None: ...
    def ItemsAP242(self) -> StepShape_HArray1OfShapeDimensionRepresentationItem: ...
    def SetItemsAP242(self, theItems: StepShape_HArray1OfShapeDimensionRepresentationItem) -> None: ...

class StepShape_ShapeRepresentationWithParameters(StepShape_ShapeRepresentation):
    def __init__(self) -> None: ...

class StepShape_SolidReplica(StepShape_SolidModel):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aParentSolid: StepShape_SolidModel, aTransformation: StepGeom_CartesianTransformationOperator3d) -> None: ...
    def ParentSolid(self) -> StepShape_SolidModel: ...
    def SetParentSolid(self, aParentSolid: StepShape_SolidModel) -> None: ...
    def SetTransformation(self, aTransformation: StepGeom_CartesianTransformationOperator3d) -> None: ...
    def Transformation(self) -> StepGeom_CartesianTransformationOperator3d: ...

class StepShape_SweptAreaSolid(StepShape_SolidModel):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aSweptArea: StepGeom_CurveBoundedSurface) -> None: ...
    def SetSweptArea(self, aSweptArea: StepGeom_CurveBoundedSurface) -> None: ...
    def SweptArea(self) -> StepGeom_CurveBoundedSurface: ...

class StepShape_SweptFaceSolid(StepShape_SolidModel):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aSweptArea: StepShape_FaceSurface) -> None: ...
    def SetSweptFace(self, aSweptArea: StepShape_FaceSurface) -> None: ...
    def SweptFace(self) -> StepShape_FaceSurface: ...

class StepShape_TransitionalShapeRepresentation(StepShape_ShapeRepresentation):
    def __init__(self) -> None: ...

class StepShape_Vertex(StepShape_TopologicalRepresentationItem):
    def __init__(self) -> None: ...

class StepShape_BrepWithVoids(StepShape_ManifoldSolidBrep):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aOuter: StepShape_ClosedShell, aVoids: StepShape_HArray1OfOrientedClosedShell) -> None: ...
    def NbVoids(self) -> int: ...
    def SetVoids(self, aVoids: StepShape_HArray1OfOrientedClosedShell) -> None: ...
    def Voids(self) -> StepShape_HArray1OfOrientedClosedShell: ...
    def VoidsValue(self, num: int) -> StepShape_OrientedClosedShell: ...

class StepShape_ClosedShell(StepShape_ConnectedFaceSet):
    def __init__(self) -> None: ...

class StepShape_ConnectedFaceSubSet(StepShape_ConnectedFaceSet):
    def __init__(self) -> None: ...
    def Init(self, aRepresentationItem_Name: TCollection_HAsciiString, aConnectedFaceSet_CfsFaces: StepShape_HArray1OfFace, aParentFaceSet: StepShape_ConnectedFaceSet) -> None: ...
    def ParentFaceSet(self) -> StepShape_ConnectedFaceSet: ...
    def SetParentFaceSet(self, ParentFaceSet: StepShape_ConnectedFaceSet) -> None: ...

class StepShape_EdgeCurve(StepShape_Edge):
    def __init__(self) -> None: ...
    def EdgeGeometry(self) -> StepGeom_Curve: ...
    def Init(self, aName: TCollection_HAsciiString, aEdgeStart: StepShape_Vertex, aEdgeEnd: StepShape_Vertex, aEdgeGeometry: StepGeom_Curve, aSameSense: bool) -> None: ...
    def SameSense(self) -> bool: ...
    def SetEdgeGeometry(self, aEdgeGeometry: StepGeom_Curve) -> None: ...
    def SetSameSense(self, aSameSense: bool) -> None: ...

class StepShape_EdgeLoop(StepShape_Loop):
    def __init__(self) -> None: ...
    def EdgeList(self) -> StepShape_HArray1OfOrientedEdge: ...
    def EdgeListValue(self, num: int) -> StepShape_OrientedEdge: ...
    def Init(self, aName: TCollection_HAsciiString, aEdgeList: StepShape_HArray1OfOrientedEdge) -> None: ...
    def NbEdgeList(self) -> int: ...
    def SetEdgeList(self, aEdgeList: StepShape_HArray1OfOrientedEdge) -> None: ...

class StepShape_ExtrudedAreaSolid(StepShape_SweptAreaSolid):
    def __init__(self) -> None: ...
    def Depth(self) -> float: ...
    def ExtrudedDirection(self) -> StepGeom_Direction: ...
    def Init(self, aName: TCollection_HAsciiString, aSweptArea: StepGeom_CurveBoundedSurface, aExtrudedDirection: StepGeom_Direction, aDepth: float) -> None: ...
    def SetDepth(self, aDepth: float) -> None: ...
    def SetExtrudedDirection(self, aExtrudedDirection: StepGeom_Direction) -> None: ...

class StepShape_ExtrudedFaceSolid(StepShape_SweptFaceSolid):
    def __init__(self) -> None: ...
    def Depth(self) -> float: ...
    def ExtrudedDirection(self) -> StepGeom_Direction: ...
    def Init(self, aName: TCollection_HAsciiString, aSweptArea: StepShape_FaceSurface, aExtrudedDirection: StepGeom_Direction, aDepth: float) -> None: ...
    def SetDepth(self, aDepth: float) -> None: ...
    def SetExtrudedDirection(self, aExtrudedDirection: StepGeom_Direction) -> None: ...

class StepShape_FaceOuterBound(StepShape_FaceBound):
    def __init__(self) -> None: ...

class StepShape_FaceSurface(StepShape_Face):
    def __init__(self) -> None: ...
    def FaceGeometry(self) -> StepGeom_Surface: ...
    def Init(self, aName: TCollection_HAsciiString, aBounds: StepShape_HArray1OfFaceBound, aFaceGeometry: StepGeom_Surface, aSameSense: bool) -> None: ...
    def SameSense(self) -> bool: ...
    def SetFaceGeometry(self, aFaceGeometry: StepGeom_Surface) -> None: ...
    def SetSameSense(self, aSameSense: bool) -> None: ...

class StepShape_FacetedBrep(StepShape_ManifoldSolidBrep):
    def __init__(self) -> None: ...

class StepShape_FacetedBrepAndBrepWithVoids(StepShape_ManifoldSolidBrep):
    def __init__(self) -> None: ...
    def BrepWithVoids(self) -> StepShape_BrepWithVoids: ...
    def FacetedBrep(self) -> StepShape_FacetedBrep: ...
    @overload
    def Init(self, aName: TCollection_HAsciiString, aOuter: StepShape_ClosedShell, aFacetedBrep: StepShape_FacetedBrep, aBrepWithVoids: StepShape_BrepWithVoids) -> None: ...
    @overload
    def Init(self, aName: TCollection_HAsciiString, aOuter: StepShape_ClosedShell, aVoids: StepShape_HArray1OfOrientedClosedShell) -> None: ...
    def NbVoids(self) -> int: ...
    def SetBrepWithVoids(self, aBrepWithVoids: StepShape_BrepWithVoids) -> None: ...
    def SetFacetedBrep(self, aFacetedBrep: StepShape_FacetedBrep) -> None: ...
    def SetVoids(self, aVoids: StepShape_HArray1OfOrientedClosedShell) -> None: ...
    def Voids(self) -> StepShape_HArray1OfOrientedClosedShell: ...
    def VoidsValue(self, num: int) -> StepShape_OrientedClosedShell: ...

class StepShape_OpenShell(StepShape_ConnectedFaceSet):
    def __init__(self) -> None: ...

class StepShape_OrientedEdge(StepShape_Edge):
    def __init__(self) -> None: ...
    def EdgeElement(self) -> StepShape_Edge: ...
    def EdgeEnd(self) -> StepShape_Vertex: ...
    def EdgeStart(self) -> StepShape_Vertex: ...
    def Init(self, aName: TCollection_HAsciiString, aEdgeElement: StepShape_Edge, aOrientation: bool) -> None: ...
    def Orientation(self) -> bool: ...
    def SetEdgeElement(self, aEdgeElement: StepShape_Edge) -> None: ...
    def SetEdgeEnd(self, aEdgeEnd: StepShape_Vertex) -> None: ...
    def SetEdgeStart(self, aEdgeStart: StepShape_Vertex) -> None: ...
    def SetOrientation(self, aOrientation: bool) -> None: ...

class StepShape_OrientedFace(StepShape_Face):
    def __init__(self) -> None: ...
    def Bounds(self) -> StepShape_HArray1OfFaceBound: ...
    def BoundsValue(self, num: int) -> StepShape_FaceBound: ...
    def FaceElement(self) -> StepShape_Face: ...
    def Init(self, aName: TCollection_HAsciiString, aFaceElement: StepShape_Face, aOrientation: bool) -> None: ...
    def NbBounds(self) -> int: ...
    def Orientation(self) -> bool: ...
    def SetBounds(self, aBounds: StepShape_HArray1OfFaceBound) -> None: ...
    def SetFaceElement(self, aFaceElement: StepShape_Face) -> None: ...
    def SetOrientation(self, aOrientation: bool) -> None: ...

class StepShape_OrientedPath(StepShape_Path):
    def __init__(self) -> None: ...
    def EdgeList(self) -> StepShape_HArray1OfOrientedEdge: ...
    def EdgeListValue(self, num: int) -> StepShape_OrientedEdge: ...
    def Init(self, aName: TCollection_HAsciiString, aPathElement: StepShape_EdgeLoop, aOrientation: bool) -> None: ...
    def NbEdgeList(self) -> int: ...
    def Orientation(self) -> bool: ...
    def PathElement(self) -> StepShape_EdgeLoop: ...
    def SetEdgeList(self, aEdgeList: StepShape_HArray1OfOrientedEdge) -> None: ...
    def SetOrientation(self, aOrientation: bool) -> None: ...
    def SetPathElement(self, aPathElement: StepShape_EdgeLoop) -> None: ...

class StepShape_PolyLoop(StepShape_Loop):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aPolygon: StepGeom_HArray1OfCartesianPoint) -> None: ...
    def NbPolygon(self) -> int: ...
    def Polygon(self) -> StepGeom_HArray1OfCartesianPoint: ...
    def PolygonValue(self, num: int) -> StepGeom_CartesianPoint: ...
    def SetPolygon(self, aPolygon: StepGeom_HArray1OfCartesianPoint) -> None: ...

class StepShape_RevolvedAreaSolid(StepShape_SweptAreaSolid):
    def __init__(self) -> None: ...
    def Angle(self) -> float: ...
    def Axis(self) -> StepGeom_Axis1Placement: ...
    def Init(self, aName: TCollection_HAsciiString, aSweptArea: StepGeom_CurveBoundedSurface, aAxis: StepGeom_Axis1Placement, aAngle: float) -> None: ...
    def SetAngle(self, aAngle: float) -> None: ...
    def SetAxis(self, aAxis: StepGeom_Axis1Placement) -> None: ...

class StepShape_RevolvedFaceSolid(StepShape_SweptFaceSolid):
    def __init__(self) -> None: ...
    def Angle(self) -> float: ...
    def Axis(self) -> StepGeom_Axis1Placement: ...
    @overload
    def Init(self, aName: TCollection_HAsciiString, aSweptArea: StepShape_FaceSurface) -> None: ...
    @overload
    def Init(self, aName: TCollection_HAsciiString, aSweptArea: StepShape_FaceSurface, aAxis: StepGeom_Axis1Placement, aAngle: float) -> None: ...
    def SetAngle(self, aAngle: float) -> None: ...
    def SetAxis(self, aAxis: StepGeom_Axis1Placement) -> None: ...

class StepShape_Subedge(StepShape_Edge):
    def __init__(self) -> None: ...
    def Init(self, aRepresentationItem_Name: TCollection_HAsciiString, aEdge_EdgeStart: StepShape_Vertex, aEdge_EdgeEnd: StepShape_Vertex, aParentEdge: StepShape_Edge) -> None: ...
    def ParentEdge(self) -> StepShape_Edge: ...
    def SetParentEdge(self, ParentEdge: StepShape_Edge) -> None: ...

class StepShape_Subface(StepShape_Face):
    def __init__(self) -> None: ...
    def Init(self, aRepresentationItem_Name: TCollection_HAsciiString, aFace_Bounds: StepShape_HArray1OfFaceBound, aParentFace: StepShape_Face) -> None: ...
    def ParentFace(self) -> StepShape_Face: ...
    def SetParentFace(self, ParentFace: StepShape_Face) -> None: ...

class StepShape_VertexLoop(StepShape_Loop):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aLoopVertex: StepShape_Vertex) -> None: ...
    def LoopVertex(self) -> StepShape_Vertex: ...
    def SetLoopVertex(self, aLoopVertex: StepShape_Vertex) -> None: ...

class StepShape_VertexPoint(StepShape_Vertex):
    def __init__(self) -> None: ...
    def Init(self, aName: TCollection_HAsciiString, aVertexGeometry: StepGeom_Point) -> None: ...
    def SetVertexGeometry(self, aVertexGeometry: StepGeom_Point) -> None: ...
    def VertexGeometry(self) -> StepGeom_Point: ...

class StepShape_AdvancedFace(StepShape_FaceSurface):
    def __init__(self) -> None: ...

class StepShape_OrientedClosedShell(StepShape_ClosedShell):
    def __init__(self) -> None: ...
    def CfsFaces(self) -> StepShape_HArray1OfFace: ...
    def CfsFacesValue(self, num: int) -> StepShape_Face: ...
    def ClosedShellElement(self) -> StepShape_ClosedShell: ...
    def Init(self, aName: TCollection_HAsciiString, aClosedShellElement: StepShape_ClosedShell, aOrientation: bool) -> None: ...
    def NbCfsFaces(self) -> int: ...
    def Orientation(self) -> bool: ...
    def SetCfsFaces(self, aCfsFaces: StepShape_HArray1OfFace) -> None: ...
    def SetClosedShellElement(self, aClosedShellElement: StepShape_ClosedShell) -> None: ...
    def SetOrientation(self, aOrientation: bool) -> None: ...

class StepShape_OrientedOpenShell(StepShape_OpenShell):
    def __init__(self) -> None: ...
    def CfsFaces(self) -> StepShape_HArray1OfFace: ...
    def CfsFacesValue(self, num: int) -> StepShape_Face: ...
    def Init(self, aName: TCollection_HAsciiString, aOpenShellElement: StepShape_OpenShell, aOrientation: bool) -> None: ...
    def NbCfsFaces(self) -> int: ...
    def OpenShellElement(self) -> StepShape_OpenShell: ...
    def Orientation(self) -> bool: ...
    def SetCfsFaces(self, aCfsFaces: StepShape_HArray1OfFace) -> None: ...
    def SetOpenShellElement(self, aOpenShellElement: StepShape_OpenShell) -> None: ...
    def SetOrientation(self, aOrientation: bool) -> None: ...

class StepShape_SeamEdge(StepShape_OrientedEdge):
    def __init__(self) -> None: ...
    def Init(self, aRepresentationItem_Name: TCollection_HAsciiString, aOrientedEdge_EdgeElement: StepShape_Edge, aOrientedEdge_Orientation: bool, aPcurveReference: StepGeom_Pcurve) -> None: ...
    def PcurveReference(self) -> StepGeom_Pcurve: ...
    def SetPcurveReference(self, PcurveReference: StepGeom_Pcurve) -> None: ...

# harray1 classes

class StepShape_HArray1OfShell(StepShape_Array1OfShell, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> StepShape_Array1OfShell: ...


class StepShape_HArray1OfFaceBound(StepShape_Array1OfFaceBound, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> StepShape_Array1OfFaceBound: ...


class StepShape_HArray1OfFace(StepShape_Array1OfFace, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> StepShape_Array1OfFace: ...


class StepShape_HArray1OfShapeDimensionRepresentationItem(StepShape_Array1OfShapeDimensionRepresentationItem, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> StepShape_Array1OfShapeDimensionRepresentationItem: ...


class StepShape_HArray1OfConnectedFaceSet(StepShape_Array1OfConnectedFaceSet, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> StepShape_Array1OfConnectedFaceSet: ...


class StepShape_HArray1OfConnectedEdgeSet(StepShape_Array1OfConnectedEdgeSet, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> StepShape_Array1OfConnectedEdgeSet: ...


class StepShape_HArray1OfEdge(StepShape_Array1OfEdge, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> StepShape_Array1OfEdge: ...


class StepShape_HArray1OfOrientedClosedShell(StepShape_Array1OfOrientedClosedShell, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> StepShape_Array1OfOrientedClosedShell: ...


class StepShape_HArray1OfValueQualifier(StepShape_Array1OfValueQualifier, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> StepShape_Array1OfValueQualifier: ...


class StepShape_HArray1OfOrientedEdge(StepShape_Array1OfOrientedEdge, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> StepShape_Array1OfOrientedEdge: ...


class StepShape_HArray1OfGeometricSetSelect(StepShape_Array1OfGeometricSetSelect, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> StepShape_Array1OfGeometricSetSelect: ...

# harray2 classes
# hsequence classes

