/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeEviction;
import org.apache.ivy.core.resolve.IvyNodeUsage;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.VisitData;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.util.Checks;

public class VisitNode {
    private IvyNode node;
    private VisitNode parent = null;
    private VisitNode root = null;
    private Collection path = null;
    private String parentConf = null;
    private String requestedConf;
    private String rootModuleConf;
    private ResolveData data;
    private Boolean isCircular;
    private IvyNodeUsage usage;

    public VisitNode(ResolveData resolveData, IvyNode ivyNode, VisitNode visitNode, String string, String string2) {
        this(resolveData, ivyNode, visitNode, string, string2, null);
    }

    public VisitNode(ResolveData resolveData, IvyNode ivyNode, VisitNode visitNode, String string, String string2, IvyNodeUsage ivyNodeUsage) {
        Checks.checkNotNull(resolveData, "data");
        Checks.checkNotNull(ivyNode, "node");
        Checks.checkNotNull(string, "rootModuleConf");
        this.data = resolveData;
        this.node = ivyNode;
        this.parent = visitNode;
        this.rootModuleConf = string;
        this.parentConf = string2;
        this.usage = ivyNodeUsage;
        this.data.register(this);
    }

    public IvyNode getNode() {
        return this.node;
    }

    public String getRequestedConf() {
        return this.requestedConf;
    }

    public void setRequestedConf(String string) {
        this.requestedConf = string;
    }

    public VisitNode getParent() {
        return this.parent;
    }

    public VisitNode getRoot() {
        if (this.root == null) {
            this.root = this.computeRoot();
        }
        return this.root;
    }

    public Collection getPath() {
        if (this.path == null) {
            this.path = this.computePath();
        }
        return this.path;
    }

    private Collection computePath() {
        if (this.parent != null) {
            LinkedHashSet<VisitNode> linkedHashSet = new LinkedHashSet<VisitNode>(this.parent.getPath());
            linkedHashSet.add(this);
            return linkedHashSet;
        }
        return Collections.singletonList(this);
    }

    private VisitNode computeRoot() {
        if (this.node.isRoot()) {
            return this;
        }
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return null;
    }

    public String getParentConf() {
        return this.parentConf;
    }

    public String getRootModuleConf() {
        return this.rootModuleConf;
    }

    public boolean isTransitive() {
        if (this.node.isRoot()) {
            return true;
        }
        if (!this.data.isTransitive()) {
            return false;
        }
        if (!this.isParentConfTransitive()) {
            return false;
        }
        DependencyDescriptor dependencyDescriptor = this.node.getDependencyDescriptor(this.getParentNode());
        if (dependencyDescriptor != null && dependencyDescriptor.isTransitive()) {
            return true;
        }
        return this.node.hasAnyMergedUsageWithTransitiveDependency(this.rootModuleConf);
    }

    protected boolean isParentConfTransitive() {
        Object object = this.getParent().getRequestedConf();
        if (object == null) {
            return true;
        }
        object = this.getParentNode().getConfiguration((String)object);
        return ((Configuration)object).isTransitive();
    }

    public void useRealNode() {
        IvyNode ivyNode;
        if (this.parent != null && (ivyNode = this.data.getNode(this.node.getId())) != null && ivyNode != this.node) {
            this.node = ivyNode;
        }
    }

    public boolean loadData(String string, boolean bl) {
        boolean bl2 = this.node.loadData(this.rootModuleConf, this.getParentNode(), this.parentConf, string, bl, this.getUsage());
        if (bl2) {
            this.useRealNode();
            if (this.data.getNode(this.node.getResolvedId()) == null || !this.data.getNode(this.node.getResolvedId()).getId().equals(this.node.getResolvedId())) {
                this.data.register(this.node.getResolvedId(), this);
            }
        }
        return bl2;
    }

    public Collection getDependencies(String string) {
        Object object = this.node.getDependencies(this.rootModuleConf, string, this.requestedConf);
        ArrayList<VisitNode> arrayList = new ArrayList<VisitNode>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            IvyNode ivyNode = (IvyNode)object.next();
            arrayList.add(this.traverseChild(string, ivyNode));
        }
        return arrayList;
    }

    VisitNode gotoNode(IvyNode ivyNode) {
        if (!this.getModuleId().equals(ivyNode.getModuleId())) {
            throw new IllegalArgumentException("You can't use gotoNode for a node which does not represent the same Module as the one represented by this node.\nCurrent node module id=" + this.getModuleId() + " Given node module id=" + ivyNode.getModuleId());
        }
        Object object = this.data.getVisitData(ivyNode.getId());
        if (object != null) {
            object = ((VisitData)object).getVisitNodes(this.rootModuleConf);
            object = object.iterator();
            while (object.hasNext()) {
                VisitNode visitNode = (VisitNode)object.next();
                if ((this.parent != null || visitNode.getParent() != null) && (this.parent == null || !this.parent.getId().equals(visitNode.getParent().getId()))) continue;
                visitNode.parentConf = this.parentConf;
                visitNode.usage = this.getUsage();
                return visitNode;
            }
        }
        VisitNode visitNode = this;
        return visitNode.traverse(visitNode.parent, this.parentConf, ivyNode, this.getUsage());
    }

    private IvyNodeUsage getUsage() {
        if (this.usage == null) {
            return this.node.getMainUsage();
        }
        return this.usage;
    }

    private VisitNode traverseChild(String string, IvyNode ivyNode) {
        VisitNode visitNode = this;
        return this.traverse(visitNode, string, ivyNode, null);
    }

    private VisitNode traverse(VisitNode visitNode, String string, IvyNode ivyNode, IvyNodeUsage ivyNodeUsage) {
        if (this.getPath().contains(ivyNode)) {
            VisitNode visitNode2 = this;
            IvyContext.getContext().getCircularDependencyStrategy().handleCircularDependency(visitNode2.toMrids(visitNode2.getPath(), ivyNode.getId()));
        }
        return new VisitNode(this.data, ivyNode, visitNode, this.rootModuleConf, string, ivyNodeUsage);
    }

    private ModuleRevisionId[] toMrids(Collection object, ModuleRevisionId moduleRevisionId) {
        ModuleRevisionId[] moduleRevisionIdArray = new ModuleRevisionId[object.size() + 1];
        int n = 0;
        object = object.iterator();
        while (object.hasNext()) {
            VisitNode visitNode = (VisitNode)object.next();
            moduleRevisionIdArray[n] = visitNode.getNode().getId();
            ++n;
        }
        moduleRevisionIdArray[moduleRevisionIdArray.length - 1] = moduleRevisionId;
        return moduleRevisionIdArray;
    }

    public ModuleRevisionId getResolvedId() {
        return this.node.getResolvedId();
    }

    public void updateConfsToFetch(Collection collection) {
        this.node.updateConfsToFetch(collection);
    }

    public ModuleRevisionId getId() {
        return this.node.getId();
    }

    public boolean isEvicted() {
        return this.node.isEvicted(this.rootModuleConf);
    }

    public String[] getRealConfs(String string) {
        return this.node.getRealConfs(string);
    }

    public boolean hasProblem() {
        return this.node.hasProblem();
    }

    public Configuration getConfiguration(String string) {
        return this.node.getConfiguration(string);
    }

    public IvyNodeEviction.EvictionData getEvictedData() {
        return this.node.getEvictedData(this.rootModuleConf);
    }

    public DependencyDescriptor getDependencyDescriptor() {
        return this.node.getDependencyDescriptor(this.getParentNode());
    }

    private IvyNode getParentNode() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getNode();
    }

    public boolean isCircular() {
        if (this.isCircular == null) {
            if (this.parent != null) {
                this.isCircular = Boolean.FALSE;
                for (VisitNode visitNode : this.parent.getPath()) {
                    if (!this.getId().getModuleId().equals(visitNode.getId().getModuleId())) continue;
                    this.isCircular = Boolean.TRUE;
                    break;
                }
            } else {
                this.isCircular = Boolean.FALSE;
            }
        }
        return this.isCircular;
    }

    public String[] getConfsToFetch() {
        return this.node.getConfsToFetch();
    }

    public String[] getRequiredConfigurations(VisitNode visitNode, String string) {
        return this.node.getRequiredConfigurations(visitNode.getNode(), string);
    }

    public ModuleId getModuleId() {
        return this.node.getModuleId();
    }

    public Collection getResolvedRevisions(ModuleId moduleId) {
        return this.node.getResolvedRevisions(moduleId, this.rootModuleConf);
    }

    public void markEvicted(IvyNodeEviction.EvictionData evictionData) {
        this.node.markEvicted(evictionData);
    }

    public void markEvicted(VisitNode visitNode, ConflictManager conflictManager, Collection collection) {
        this.node.markEvicted(this.rootModuleConf, visitNode.getNode(), conflictManager, collection);
    }

    public ModuleDescriptor getDescriptor() {
        return this.node.getDescriptor();
    }

    public IvyNodeEviction.EvictionData getEvictionDataInRoot(String string, VisitNode visitNode) {
        return this.node.getEvictionDataInRoot(string, visitNode.getNode());
    }

    public Collection getEvictedRevisions(ModuleId moduleId) {
        return this.node.getEvictedRevisions(moduleId, this.rootModuleConf);
    }

    public String toString() {
        return this.node.toString();
    }

    public boolean isConfRequiredByMergedUsageOnly(String string) {
        return this.node.isConfRequiredByMergedUsageOnly(this.rootModuleConf, string);
    }
}

