/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.ArrayList;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.JmxEnabled;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Valve;
import org.apache.catalina.util.LifecycleBase;
import org.apache.catalina.util.ToStringUtil;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public class StandardPipeline
extends LifecycleBase
implements Pipeline {
    private static final Log log = LogFactory.getLog(StandardPipeline.class);
    private static final StringManager sm = StringManager.getManager(StandardPipeline.class);
    protected Valve basic = null;
    protected Container container = null;
    protected Valve first = null;

    public StandardPipeline() {
        this(null);
    }

    public StandardPipeline(Container container) {
        this.setContainer(container);
    }

    @Override
    public boolean isAsyncSupported() {
        boolean bl;
        Valve valve = this.first != null ? this.first : this.basic;
        for (bl = true; bl && valve != null; bl &= valve.isAsyncSupported(), valve = valve.getNext()) {
        }
        return bl;
    }

    @Override
    public void findNonAsyncValves(Set<String> set) {
        Valve valve;
        Valve valve2 = valve = this.first != null ? this.first : this.basic;
        while (valve != null) {
            if (!valve.isAsyncSupported()) {
                set.add(valve.getClass().getName());
            }
            valve = valve.getNext();
        }
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        this.container = container;
    }

    @Override
    protected void initInternal() {
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        Valve valve = this.first;
        if (valve == null) {
            valve = this.basic;
        }
        while (valve != null) {
            if (valve instanceof Lifecycle) {
                ((Lifecycle)((Object)valve)).start();
            }
            valve = valve.getNext();
        }
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        Valve valve = this.first;
        if (valve == null) {
            valve = this.basic;
        }
        while (valve != null) {
            if (valve instanceof Lifecycle) {
                ((Lifecycle)((Object)valve)).stop();
            }
            valve = valve.getNext();
        }
    }

    @Override
    protected void destroyInternal() {
        Valve[] valveArray;
        for (Valve valve : valveArray = this.getValves()) {
            this.removeValve(valve);
        }
    }

    public String toString() {
        return ToStringUtil.toString(this);
    }

    @Override
    public Valve getBasic() {
        return this.basic;
    }

    @Override
    public void setBasic(Valve valve) {
        Valve valve2 = this.basic;
        if (valve2 == valve) {
            return;
        }
        if (valve2 != null) {
            if (this.getState().isAvailable() && valve2 instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)valve2)).stop();
                }
                catch (LifecycleException lifecycleException) {
                    log.error((Object)sm.getString("standardPipeline.basic.stop"), (Throwable)lifecycleException);
                }
            }
            if (valve2 instanceof Contained) {
                try {
                    ((Contained)((Object)valve2)).setContainer(null);
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                }
            }
        }
        if (valve == null) {
            return;
        }
        if (valve instanceof Contained) {
            ((Contained)((Object)valve)).setContainer(this.container);
        }
        if (this.getState().isAvailable() && valve instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)valve)).start();
            }
            catch (LifecycleException lifecycleException) {
                log.error((Object)sm.getString("standardPipeline.basic.start"), (Throwable)lifecycleException);
                return;
            }
        }
        for (Valve valve3 = this.first; valve3 != null; valve3 = valve3.getNext()) {
            if (valve3.getNext() != valve2) continue;
            valve3.setNext(valve);
            break;
        }
        this.basic = valve;
    }

    @Override
    public void addValve(Valve valve) {
        if (valve instanceof Contained) {
            ((Contained)((Object)valve)).setContainer(this.container);
        }
        if (this.getState().isAvailable() && valve instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)valve)).start();
            }
            catch (LifecycleException lifecycleException) {
                log.error((Object)sm.getString("standardPipeline.valve.start"), (Throwable)lifecycleException);
            }
        }
        if (this.first == null) {
            this.first = valve;
            valve.setNext(this.basic);
        } else {
            for (Valve valve2 = this.first; valve2 != null; valve2 = valve2.getNext()) {
                if (valve2.getNext() != this.basic) continue;
                valve2.setNext(valve);
                valve.setNext(this.basic);
                break;
            }
        }
        this.container.fireContainerEvent("addValve", valve);
    }

    @Override
    public Valve[] getValves() {
        ArrayList<Valve> arrayList = new ArrayList<Valve>();
        Valve valve = this.first;
        if (valve == null) {
            valve = this.basic;
        }
        while (valve != null) {
            arrayList.add(valve);
            valve = valve.getNext();
        }
        return arrayList.toArray(new Valve[0]);
    }

    public ObjectName[] getValveObjectNames() {
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
        Valve valve = this.first;
        if (valve == null) {
            valve = this.basic;
        }
        while (valve != null) {
            if (valve instanceof JmxEnabled) {
                arrayList.add(((JmxEnabled)((Object)valve)).getObjectName());
            }
            valve = valve.getNext();
        }
        return arrayList.toArray(new ObjectName[0]);
    }

    @Override
    public void removeValve(Valve valve) {
        Valve valve2;
        if (this.first == valve) {
            this.first = this.first.getNext();
            valve2 = null;
        } else {
            valve2 = this.first;
        }
        while (valve2 != null) {
            if (valve2.getNext() == valve) {
                valve2.setNext(valve.getNext());
                break;
            }
            valve2 = valve2.getNext();
        }
        if (this.first == this.basic) {
            this.first = null;
        }
        if (valve instanceof Contained) {
            ((Contained)((Object)valve)).setContainer(null);
        }
        if (valve instanceof Lifecycle) {
            if (this.getState().isAvailable()) {
                try {
                    ((Lifecycle)((Object)valve)).stop();
                }
                catch (LifecycleException lifecycleException) {
                    log.error((Object)sm.getString("standardPipeline.valve.stop"), (Throwable)lifecycleException);
                }
            }
            try {
                ((Lifecycle)((Object)valve)).destroy();
            }
            catch (LifecycleException lifecycleException) {
                log.error((Object)sm.getString("standardPipeline.valve.destroy"), (Throwable)lifecycleException);
            }
        }
        this.container.fireContainerEvent("removeValve", valve);
    }

    @Override
    public Valve getFirst() {
        if (this.first != null) {
            return this.first;
        }
        return this.basic;
    }
}

