"use strict";
/*
 * Wire
 * Copyright (C) 2019 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.useLongTouch = void 0;
const react_1 = require("react");
const useTimeout_1 = require("./useTimeout");
const useLongTouch = (element, onLongTouch, touchDuration = 800) => {
    const { startTimeout, removeTimeout } = (0, useTimeout_1.useTimeout)(onLongTouch, touchDuration);
    (0, react_1.useEffect)(() => {
        if (!element) {
            return () => { };
        }
        const onTouchStart = () => {
            startTimeout();
        };
        const onTouchEnd = () => {
            removeTimeout();
        };
        element.addEventListener('touchstart', onTouchStart, false);
        element.addEventListener('touchend', onTouchEnd, false);
        return () => {
            element.removeEventListener('touchstart', onTouchStart);
            element.removeEventListener('touchend', onTouchEnd);
        };
    }, [onLongTouch, touchDuration]);
};
exports.useLongTouch = useLongTouch;
