/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.Collection;
import java.util.HashMap;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.ModuleDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.PlainPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;

public class SourceModuleBinding
extends ModuleBinding {
    public final CompilationUnitScope scope;

    public SourceModuleBinding(char[] cArray, CompilationUnitScope compilationUnitScope, LookupEnvironment lookupEnvironment) {
        super(cArray);
        lookupEnvironment.knownModules.put(cArray, this);
        this.environment = new LookupEnvironment(lookupEnvironment, this);
        this.scope = compilationUnitScope;
        compilationUnitScope.environment = this.environment;
    }

    public void setRequires(ModuleBinding[] moduleBindingArray, ModuleBinding[] moduleBindingArray2) {
        ModuleBinding moduleBinding = this.environment.javaBaseModule();
        this.requires = this.merge(this.requires, moduleBindingArray, moduleBinding, ModuleBinding[]::new);
        this.requiresTransitive = this.merge(this.requiresTransitive, moduleBindingArray2, null, ModuleBinding[]::new);
    }

    public void setUses(TypeBinding[] typeBindingArray) {
        this.uses = this.merge(this.uses, typeBindingArray, null, TypeBinding[]::new);
    }

    @Override
    public TypeBinding[] getUses() {
        this.resolveTypes();
        return super.getUses();
    }

    @Override
    public TypeBinding[] getServices() {
        this.resolveTypes();
        return super.getServices();
    }

    @Override
    public TypeBinding[] getImplementations(TypeBinding typeBinding) {
        this.resolveTypes();
        return super.getImplementations(typeBinding);
    }

    private void resolveTypes() {
        ModuleDeclaration moduleDeclaration;
        if (this.scope != null && (moduleDeclaration = this.scope.referenceCompilationUnit().moduleDeclaration) != null) {
            moduleDeclaration.resolveTypeDirectives(this.scope);
        }
    }

    public void setServices(TypeBinding[] typeBindingArray) {
        this.services = this.merge(this.services, typeBindingArray, null, TypeBinding[]::new);
    }

    public void setImplementations(TypeBinding typeBinding, Collection<TypeBinding> collection) {
        if (this.implementations == null) {
            this.implementations = new HashMap();
        }
        this.implementations.put(typeBinding, collection.toArray(new TypeBinding[collection.size()]));
    }

    private <T> T[] merge(T[] TArray, T[] TArray2, T t, IntFunction<T[]> intFunction) {
        if (TArray.length == 0 && t == null) {
            if (TArray2.length > 0) {
                return TArray2;
            }
            return TArray;
        }
        int n = t == null ? 0 : 1;
        int n2 = TArray.length;
        int n3 = TArray2.length;
        T[] TArray3 = intFunction.apply(n + n2 + n3);
        if (t != null) {
            TArray3[0] = t;
        }
        System.arraycopy(TArray, 0, TArray3, n, n2);
        System.arraycopy(TArray2, 0, TArray3, n + n2, n3);
        return TArray3;
    }

    @Override
    Stream<ModuleBinding> getRequiredModules(boolean bl) {
        this.scope.referenceContext.moduleDeclaration.resolveModuleDirectives(this.scope);
        return super.getRequiredModules(bl);
    }

    @Override
    public ModuleBinding[] getAllRequiredModules() {
        this.scope.referenceContext.moduleDeclaration.resolveModuleDirectives(this.scope);
        return super.getAllRequiredModules();
    }

    @Override
    public PlainPackageBinding[] getExports() {
        this.scope.referenceContext.moduleDeclaration.resolvePackageDirectives(this.scope);
        return super.getExports();
    }

    @Override
    public PlainPackageBinding[] getOpens() {
        this.scope.referenceContext.moduleDeclaration.resolvePackageDirectives(this.scope);
        return super.getOpens();
    }

    @Override
    public long getAnnotationTagBits() {
        this.ensureAnnotationsResolved();
        return this.tagBits;
    }

    protected void ensureAnnotationsResolved() {
        if ((this.tagBits & 0x200000000L) == 0L && this.scope != null) {
            ModuleDeclaration moduleDeclaration = this.scope.referenceContext.moduleDeclaration;
            ASTNode.resolveAnnotations((BlockScope)moduleDeclaration.scope, moduleDeclaration.annotations, this);
            if ((this.tagBits & 0x400000000000L) != 0L) {
                this.modifiers |= 0x100000;
                this.tagBits |= 0x400000000L;
            }
            this.tagBits |= 0x200000000L;
        }
    }

    @Override
    public AnnotationBinding[] getAnnotations() {
        this.ensureAnnotationsResolved();
        return this.retrieveAnnotations(this);
    }

    @Override
    SimpleLookupTable storedAnnotations(boolean bl, boolean bl2) {
        if (this.scope != null) {
            SimpleLookupTable simpleLookupTable = super.storedAnnotations(bl, bl2);
            if (simpleLookupTable != null) {
                this.scope.referenceCompilationUnit().compilationResult.hasAnnotations = true;
            }
            return simpleLookupTable;
        }
        return null;
    }
}

