module irq_ena
(
   input         clk,
   input         resetn,
   input         irq,

   input         agent_address, 
   input  [31:0] agent_writedata,
   input  	 agent_read,
   input         agent_write,
   input  [3:0]  agent_byteenable,
   output [31:0] agent_readdata,
   output        agent_waitrequest,

   output        irq_out
);

reg ena_state;

initial   
    ena_state <= 1'b1;
always@(posedge clk or negedge resetn)
  if (!resetn)
    ena_state <= 1'b1;
  else if (agent_write)
    ena_state <= agent_writedata[0];

assign irq_out = irq & ena_state;

assign agent_waitrequest = 1'b0;
assign agent_readdata[0] = ena_state;
assign agent_readdata[31:1] = 31'b0;
  
endmodule

