/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.wizard;

import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.util.DisplayTextArea;
import com.install4j.runtime.wizard.WizardBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;

public abstract class WizardScreen
extends JPanel {
    public static final int CHECKBOX_WIDTH;
    public static final int RADIOBUTTON_WIDTH;
    private static int nameCount;
    private WizardBase wizardBase;
    private final String cardName;

    protected WizardScreen(WizardBase wizardBase) {
        this.wizardBase = wizardBase;
        this.cardName = String.valueOf(nameCount++);
    }

    public String getCardName() {
        return this.cardName;
    }

    protected WizardBase getWizardBase() {
        return this.wizardBase;
    }

    protected void activate() {
        this.wizardBase.activateScreen(this);
        this.requestFocus();
    }

    protected void deactivate() {
    }

    protected Window getParentWindow() {
        return (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
    }

    protected boolean supportsPrevious() {
        return true;
    }

    protected boolean supportsNext() {
        return true;
    }

    protected void initScreen() {
        this.setupComponent();
        this.setupEventHandlers();
    }

    protected void setupComponent() {
        this.setLayout(new BorderLayout());
        this.setComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
    }

    protected void setupEventHandlers() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                WizardScreen.this.invalidateDisplayTextAreas(WizardScreen.this);
                WizardScreen.this.validate();
            }
        });
    }

    private void invalidateDisplayTextAreas(JComponent container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof DisplayTextArea) {
                component.invalidate();
                continue;
            }
            if (!(component instanceof JComponent)) continue;
            this.invalidateDisplayTextAreas((JComponent)component);
        }
    }

    static {
        if (!InstallerUtil.isConsole() && !InstallerUtil.isUnattended()) {
            CHECKBOX_WIDTH = new JCheckBox().getPreferredSize().width;
            RADIOBUTTON_WIDTH = new JRadioButton().getPreferredSize().width;
        } else {
            CHECKBOX_WIDTH = 10;
            RADIOBUTTON_WIDTH = 10;
        }
        nameCount = 0;
    }
}

