/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless.symbol;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.painless.Location;
import org.opensearch.painless.lookup.PainlessLookupUtility;
import org.opensearch.painless.node.ANode;
import org.opensearch.painless.symbol.Decorator;
import org.opensearch.painless.symbol.ScriptScope;

public abstract class SemanticScope {
    protected final ScriptScope scriptScope;
    protected final Map<String, Variable> variables = new HashMap<String, Variable>();
    protected final Set<String> usedVariables;

    public static FunctionScope newFunctionScope(ScriptScope scriptScope, Class<?> returnType) {
        return new FunctionScope(scriptScope, returnType);
    }

    protected SemanticScope(ScriptScope scriptScope, Set<String> usedVariables) {
        this.scriptScope = Objects.requireNonNull(scriptScope);
        this.usedVariables = Objects.requireNonNull(usedVariables);
    }

    public LambdaScope newLambdaScope(Class<?> returnType) {
        return new LambdaScope(this, returnType);
    }

    public BlockScope newLocalScope() {
        return new BlockScope(this);
    }

    public ScriptScope getScriptScope() {
        return this.scriptScope;
    }

    public <T extends Decorator.Decoration> T putDecoration(ANode node, T decoration) {
        return this.scriptScope.put(node.getIdentifier(), decoration);
    }

    public <T extends Decorator.Decoration> T removeDecoration(ANode node, Class<T> type) {
        return this.scriptScope.remove(node.getIdentifier(), type);
    }

    public <T extends Decorator.Decoration> T getDecoration(ANode node, Class<T> type) {
        return this.scriptScope.get(node.getIdentifier(), type);
    }

    public boolean hasDecoration(ANode node, Class<? extends Decorator.Decoration> type) {
        return this.scriptScope.has(node.getIdentifier(), type);
    }

    public <T extends Decorator.Decoration> boolean copyDecoration(ANode originalNode, ANode targetNode, Class<T> type) {
        return this.scriptScope.copy(originalNode.getIdentifier(), targetNode.getIdentifier(), type);
    }

    public boolean setCondition(ANode node, Class<? extends Decorator.Condition> type) {
        return this.scriptScope.set(node.getIdentifier(), type);
    }

    public boolean deleteCondition(ANode node, Class<? extends Decorator.Condition> type) {
        return this.scriptScope.delete(node.getIdentifier(), type);
    }

    public boolean getCondition(ANode node, Class<? extends Decorator.Condition> type) {
        return this.scriptScope.exists(node.getIdentifier(), type);
    }

    public boolean replicateCondition(ANode originalNode, ANode targetNode, Class<? extends Decorator.Condition> type) {
        return this.scriptScope.replicate(originalNode.getIdentifier(), targetNode.getIdentifier(), type);
    }

    public abstract Class<?> getReturnType();

    public abstract String getReturnCanonicalTypeName();

    public Variable defineVariable(Location location, Class<?> type, String name, boolean isReadOnly) {
        if (this.isVariableDefined(name)) {
            throw location.createError(new IllegalArgumentException("variable [" + name + "] is already defined"));
        }
        Variable variable = new Variable(type, name, isReadOnly);
        this.variables.put(name, variable);
        return variable;
    }

    public abstract boolean isVariableDefined(String var1);

    public abstract Variable getVariable(Location var1, String var2);

    public Variable defineInternalVariable(Location location, Class<?> type, String name, boolean isReadOnly) {
        return this.defineVariable(location, type, "#" + name, isReadOnly);
    }

    public boolean isInternalVariableDefined(String name) {
        return this.isVariableDefined("#" + name);
    }

    public Variable getInternalVariable(Location location, String name) {
        return this.getVariable(location, "#" + name);
    }

    public Set<String> getUsedVariables() {
        return Collections.unmodifiableSet(this.usedVariables);
    }

    public static class BlockScope
    extends SemanticScope {
        protected final SemanticScope parent;

        protected BlockScope(SemanticScope parent) {
            super(parent.scriptScope, parent.usedVariables);
            this.parent = parent;
        }

        @Override
        public boolean isVariableDefined(String name) {
            if (this.variables.containsKey(name)) {
                return true;
            }
            return this.parent.isVariableDefined(name);
        }

        @Override
        public Variable getVariable(Location location, String name) {
            Objects.requireNonNull(location);
            Objects.requireNonNull(name);
            Variable variable = (Variable)this.variables.get(name);
            if (variable == null) {
                variable = this.parent.getVariable(location, name);
            } else {
                this.usedVariables.add(name);
            }
            return variable;
        }

        @Override
        public Class<?> getReturnType() {
            return this.parent.getReturnType();
        }

        @Override
        public String getReturnCanonicalTypeName() {
            return this.parent.getReturnCanonicalTypeName();
        }
    }

    public static class LambdaScope
    extends SemanticScope {
        protected final SemanticScope parent;
        protected final Class<?> returnType;
        protected final Set<Variable> captures = new HashSet<Variable>();

        protected LambdaScope(SemanticScope parent, Class<?> returnType) {
            super(parent.scriptScope, parent.usedVariables);
            this.parent = parent;
            this.returnType = returnType;
        }

        @Override
        public boolean isVariableDefined(String name) {
            if (this.variables.containsKey(name)) {
                return true;
            }
            return this.parent.isVariableDefined(name);
        }

        @Override
        public Variable getVariable(Location location, String name) {
            Objects.requireNonNull(location);
            Objects.requireNonNull(name);
            Variable variable = (Variable)this.variables.get(name);
            if (variable == null) {
                variable = this.parent.getVariable(location, name);
                variable = new Variable(variable.getType(), variable.getName(), true);
                this.captures.add(variable);
            } else {
                this.usedVariables.add(name);
            }
            return variable;
        }

        @Override
        public Class<?> getReturnType() {
            return this.returnType;
        }

        @Override
        public String getReturnCanonicalTypeName() {
            return PainlessLookupUtility.typeToCanonicalTypeName(this.returnType);
        }

        public Set<Variable> getCaptures() {
            return Collections.unmodifiableSet(this.captures);
        }
    }

    public static class FunctionScope
    extends SemanticScope {
        protected final Class<?> returnType;

        public FunctionScope(ScriptScope scriptScope, Class<?> returnType) {
            super(scriptScope, new HashSet<String>());
            this.returnType = Objects.requireNonNull(returnType);
        }

        @Override
        public boolean isVariableDefined(String name) {
            return this.variables.containsKey(name);
        }

        @Override
        public Variable getVariable(Location location, String name) {
            Objects.requireNonNull(location);
            Objects.requireNonNull(name);
            Variable variable = (Variable)this.variables.get(name);
            if (variable == null) {
                throw location.createError(new IllegalArgumentException("variable [" + name + "] is not defined"));
            }
            this.usedVariables.add(name);
            return variable;
        }

        @Override
        public Class<?> getReturnType() {
            return this.returnType;
        }

        @Override
        public String getReturnCanonicalTypeName() {
            return PainlessLookupUtility.typeToCanonicalTypeName(this.returnType);
        }
    }

    public static class Variable {
        protected final Class<?> type;
        protected final String name;
        protected final boolean isFinal;

        public Variable(Class<?> type, String name, boolean isFinal) {
            this.type = Objects.requireNonNull(type);
            this.name = Objects.requireNonNull(name);
            this.isFinal = isFinal;
        }

        public Class<?> getType() {
            return this.type;
        }

        public String getCanonicalTypeName() {
            return PainlessLookupUtility.typeToCanonicalTypeName(this.type);
        }

        public String getName() {
            return this.name;
        }

        public boolean isFinal() {
            return this.isFinal;
        }
    }
}

