/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions.action;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.Objects;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.extensions.proto.ExtensionIdentityProto;
import org.opensearch.extensions.proto.ExtensionTransportMessageProto;

public class TransportActionRequestFromExtension
extends ActionRequest {
    private final ExtensionIdentityProto.ExtensionIdentity identity;
    private final ExtensionTransportMessageProto.ExtensionTransportMessage request;

    public TransportActionRequestFromExtension(String action, ByteString requestBytes, String uniqueId) {
        this.identity = ExtensionIdentityProto.ExtensionIdentity.newBuilder().setUniqueId(uniqueId).build();
        this.request = ExtensionTransportMessageProto.ExtensionTransportMessage.newBuilder().setAction(action).setRequestBytes(requestBytes).build();
    }

    public TransportActionRequestFromExtension(StreamInput in) throws IOException {
        super(in);
        this.identity = ExtensionIdentityProto.ExtensionIdentity.parseFrom(in.readByteArray());
        this.request = ExtensionTransportMessageProto.ExtensionTransportMessage.parseFrom(in.readByteArray());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByteArray(this.identity.toByteArray());
        out.writeByteArray(this.request.toByteArray());
    }

    public String getAction() {
        return this.request.getAction();
    }

    public ByteString getRequestBytes() {
        return this.request.getRequestBytes();
    }

    public String getUniqueId() {
        return this.identity.getUniqueId();
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public String toString() {
        return "TransportActionRequestFromExtension{action=" + this.request.getAction() + ", requestBytes=" + this.request.getRequestBytes() + ", uniqueId=" + this.identity.getUniqueId() + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TransportActionRequestFromExtension that = (TransportActionRequestFromExtension)obj;
        return Objects.equals(this.request.getAction(), that.request.getAction()) && Objects.equals(this.request.getRequestBytes(), that.request.getRequestBytes()) && Objects.equals(this.identity.getUniqueId(), that.identity.getUniqueId());
    }

    public int hashCode() {
        return Objects.hash(this.request.getAction(), this.request.getRequestBytes(), this.identity.getUniqueId());
    }
}

