/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.telemetry.tracing;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opensearch.common.annotation.InternalApi;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.util.concurrent.ThreadContextStatePropagator;
import org.opensearch.telemetry.tracing.Span;
import org.opensearch.telemetry.tracing.SpanReference;
import org.opensearch.telemetry.tracing.TracerContextStorage;
import org.opensearch.telemetry.tracing.TracingTelemetry;

@InternalApi
public class ThreadContextBasedTracerContextStorage
implements TracerContextStorage<String, Span>,
ThreadContextStatePropagator {
    private final ThreadContext threadContext;
    private final TracingTelemetry tracingTelemetry;

    public ThreadContextBasedTracerContextStorage(ThreadContext threadContext, TracingTelemetry tracingTelemetry) {
        this.threadContext = Objects.requireNonNull(threadContext);
        this.tracingTelemetry = Objects.requireNonNull(tracingTelemetry);
        this.threadContext.registerThreadContextStatePropagator(this);
    }

    public Span get(String key) {
        return this.getCurrentSpan(key);
    }

    public void put(String key, Span span) {
        SpanReference currentSpanRef = (SpanReference)this.threadContext.getTransient(key);
        if (currentSpanRef == null) {
            this.threadContext.putTransient(key, new SpanReference(span));
        } else {
            currentSpanRef.setSpan(span);
        }
    }

    @Override
    public Map<String, Object> transients(Map<String, Object> source) {
        SpanReference current;
        HashMap<String, Object> transients = new HashMap<String, Object>();
        if (source.containsKey("current_span") && (current = (SpanReference)source.get("current_span")) != null) {
            transients.put("current_span", new SpanReference(current.getSpan()));
        }
        return transients;
    }

    @Override
    public Map<String, String> headers(Map<String, Object> source) {
        SpanReference current;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (source.containsKey("current_span") && (current = (SpanReference)source.get("current_span")) != null && current.getSpan() != null) {
            this.tracingTelemetry.getContextPropagator().inject(current.getSpan(), (key, value) -> headers.put((String)key, (String)value));
        }
        return headers;
    }

    Span getCurrentSpan(String key) {
        Optional<Span> optionalSpanFromContext = this.spanFromThreadContext(key);
        return optionalSpanFromContext.orElse(this.spanFromHeader());
    }

    private Optional<Span> spanFromThreadContext(String key) {
        SpanReference currentSpanRef = (SpanReference)this.threadContext.getTransient(key);
        return currentSpanRef == null ? Optional.empty() : Optional.ofNullable(currentSpanRef.getSpan());
    }

    private Span spanFromHeader() {
        Optional span = this.tracingTelemetry.getContextPropagator().extract(this.threadContext.getHeaders());
        return span.orElse(null);
    }
}

