/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.core;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.opensearch.performanceanalyzer.rca.exceptions.MalformedThresholdFile;
import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;
import org.opensearch.performanceanalyzer.rca.framework.core.Threshold;

public class ThresholdMain {
    private ConcurrentMap<String, Threshold> thresholdMap;
    private final String PATH_TO_THRESHOLD_DIR;
    private AtomicLong lastThresholdCheckEpochMillis = new AtomicLong();
    private final long THRESHOLD_CHECK_INTERVAL_MILLIS;
    private static final long MINUTES_TO_MILLIS = 60000L;
    private static final String THRESHOLD_FILE_EXTENSION = ".json";

    public ThresholdMain(String pathToThresholdDir, RcaConf rcaConf) {
        this.thresholdMap = new ConcurrentHashMap<String, Threshold>();
        this.PATH_TO_THRESHOLD_DIR = pathToThresholdDir;
        this.lastThresholdCheckEpochMillis.set(System.currentTimeMillis());
        this.THRESHOLD_CHECK_INTERVAL_MILLIS = rcaConf.getNewThresholdCheckPeriodicityMins() * 60000L;
        this.lastThresholdCheckEpochMillis.set(0L);
    }

    private Threshold addNewThreshold(String thresholdName) throws IOException, MalformedThresholdFile {
        JsonFactory factory = new JsonFactory();
        factory.enable(JsonParser.Feature.ALLOW_COMMENTS);
        ObjectMapper mapper = new ObjectMapper(factory);
        Path path = Paths.get(this.PATH_TO_THRESHOLD_DIR, thresholdName + THRESHOLD_FILE_EXTENSION);
        Threshold th = (Threshold)mapper.readValue(path.toFile(), Threshold.class);
        th.setPathToFile(path.toString());
        th.setCreationTime(this.lastThresholdCheckEpochMillis.get());
        th.validate();
        this.thresholdMap.put(thresholdName, th);
        return th;
    }

    public String get(String thresholdName, RcaConf rcaConf) throws IOException, MalformedThresholdFile {
        long lastModified;
        Threshold th = (Threshold)this.thresholdMap.get(thresholdName);
        long currTimeMillis = 0L;
        boolean timeToUpdate = false;
        if (this.lastThresholdCheckEpochMillis.get() == 0L) {
            currTimeMillis = System.currentTimeMillis();
            this.lastThresholdCheckEpochMillis.set(currTimeMillis);
        } else if (currTimeMillis - this.lastThresholdCheckEpochMillis.get() >= this.THRESHOLD_CHECK_INTERVAL_MILLIS) {
            currTimeMillis = System.currentTimeMillis();
            this.lastThresholdCheckEpochMillis.set(currTimeMillis);
            timeToUpdate = true;
        }
        if (th == null) {
            th = this.addNewThreshold(thresholdName);
        } else if (timeToUpdate && (lastModified = new File(th.getPathToFile()).lastModified()) > th.getCreationTime()) {
            this.thresholdMap.remove(thresholdName);
            th = this.addNewThreshold(thresholdName);
        }
        return th.get(rcaConf);
    }
}

