/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.store.rca.hotheap;

import java.time.Clock;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.opensearch.performanceanalyzer.commons.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.commons.stats.ServiceMetrics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.rca.configs.HighHeapUsageYoungGenRcaConfig;
import org.opensearch.performanceanalyzer.rca.framework.api.Metric;
import org.opensearch.performanceanalyzer.rca.framework.api.Rca;
import org.opensearch.performanceanalyzer.rca.framework.api.Resources;
import org.opensearch.performanceanalyzer.rca.framework.api.aggregators.SlidingWindow;
import org.opensearch.performanceanalyzer.rca.framework.api.aggregators.SlidingWindowData;
import org.opensearch.performanceanalyzer.rca.framework.api.contexts.ResourceContext;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.MetricFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.api.persist.SQLParsingUtil;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotResourceSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.ResourceUtil;
import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;
import org.opensearch.performanceanalyzer.rca.framework.metrics.RcaVerticesMetrics;
import org.opensearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;

public class HighHeapUsageYoungGenRca
extends Rca<ResourceFlowUnit<HotResourceSummary>> {
    private static final Logger LOG = LogManager.getLogger(HighHeapUsageYoungGenRca.class);
    private static final String FULL_GC_TIME_TOO_HIGH = "fullGcTimeTooHigh";
    private static final String PROMOTION_RATE_TOO_HIGH = "promotionRateTooHigh";
    private static final String YOUNG_GC_TIME_TOO_HIGH = "youngGcTimeTooHigh";
    private static final String PREMATURE_PROMOTION_TOO_HIGH = "prematurePromotionTooHigh";
    private static final String CMS_COLLECTOR = "ConcurrentMarkSweep";
    private static final int PROMOTION_RATE_SLIDING_WINDOW_IN_MINS = 10;
    private static final double FULL_GC_TIME_THRES_MS = 10000.0;
    private static final double CONVERT_BYTES_TO_MEGABYTES = Math.pow(1024.0, 2.0);
    private final Metric heap_Used;
    private final Metric gc_Collection_Time;
    private final Metric gc_Collection_Event;
    private final Metric gc_type;
    private final int rcaPeriod;
    private final double lowerBoundThreshold;
    private int counter;
    private final SlidingWindow<SlidingWindowData> minorGcTimeDeque;
    private final SlidingWindow<SlidingWindowData> fullGcTimeDeque;
    private final SlidingWindow<SlidingWindowData> promotionRateDeque;
    private final SlidingWindow<SlidingWindowData> garbagePromotedDeque;
    private int promotionRateThreshold;
    private int youngGenGcTimeThreshold;
    private double garbagePromotionPctThreshold;
    private double youngGenPromotedBytes = 0.0;
    private double maxOldGen = 0.0;
    private double prevOldGen = 0.0;
    protected Clock clock = Clock.systemUTC();

    public <M extends Metric> HighHeapUsageYoungGenRca(int rcaPeriod, double lowerBoundThreshold, M heap_Used, M gc_Collection_Time, M gc_Collection_Event, M gc_Type) {
        super(5L);
        this.heap_Used = heap_Used;
        this.gc_Collection_Time = gc_Collection_Time;
        this.gc_Collection_Event = gc_Collection_Event;
        this.gc_type = gc_Type;
        this.rcaPeriod = rcaPeriod;
        this.lowerBoundThreshold = lowerBoundThreshold >= 0.0 && lowerBoundThreshold <= 1.0 ? lowerBoundThreshold : 1.0;
        this.counter = 0;
        this.minorGcTimeDeque = new SlidingWindow(10, TimeUnit.MINUTES);
        this.fullGcTimeDeque = new SlidingWindow(10, TimeUnit.MINUTES);
        this.promotionRateThreshold = 500;
        this.youngGenGcTimeThreshold = 400;
        this.garbagePromotedDeque = new SlidingWindow(10, TimeUnit.MINUTES);
        this.promotionRateDeque = new SlidingWindow<SlidingWindowData>(10, TimeUnit.MINUTES){

            @Override
            protected void add(SlidingWindowData e) {
                if (!this.windowDeque.isEmpty() && e.getValue() > ((SlidingWindowData)this.windowDeque.peekFirst()).getValue()) {
                    this.sum += e.getValue() - ((SlidingWindowData)this.windowDeque.peekFirst()).getValue();
                }
            }

            @Override
            protected void remove(SlidingWindowData e) {
                if (!this.windowDeque.isEmpty() && e.getValue() < ((SlidingWindowData)this.windowDeque.peekLast()).getValue()) {
                    this.sum -= ((SlidingWindowData)this.windowDeque.peekLast()).getValue() - e.getValue();
                }
            }
        };
    }

    public <M extends Metric> HighHeapUsageYoungGenRca(int rcaPeriod, M heap_Used, M gc_Collection_Time, M gc_Collection_Event, M gcType) {
        this(rcaPeriod, 1.0, heap_Used, gc_Collection_Time, gc_Collection_Event, gcType);
    }

    private boolean fullGcTimeTooHigh(double avgFullGcTime) {
        return !Double.isNaN(avgFullGcTime) && avgFullGcTime > 10000.0;
    }

    private boolean promotionRateTooHigh(double avgPromotionRate, double modifier) {
        return !Double.isNaN(avgPromotionRate) && avgPromotionRate > (double)this.promotionRateThreshold * modifier;
    }

    private boolean youngGcTimeTooHigh(double avgYoungGCTime) {
        return !Double.isNaN(avgYoungGCTime) && avgYoungGCTime > (double)this.youngGenGcTimeThreshold;
    }

    private boolean prematurePromotionTooHigh(double avgGarbagePromoted) {
        return !Double.isNaN(avgGarbagePromoted) && avgGarbagePromoted <= 1.0 && avgGarbagePromoted > this.garbagePromotionPctThreshold;
    }

    private double getFollowerCheckTimeoutMs() {
        return 10000.0;
    }

    private ResourceFlowUnit<HotResourceSummary> computeFlowUnit(double avgPromotionRate, double avgYoungGCTime, double avgGarbagePromoted, double avgFullGCTime) {
        LOG.debug("computing avgPromotionRate = {} , avgGCTime = {}, avgGarbagePromoted = {}, avgFullGcTime = {},", (Object)avgPromotionRate, (Object)avgYoungGCTime, (Object)avgGarbagePromoted, (Object)avgFullGCTime);
        ResourceContext context = new ResourceContext(Resources.State.UNHEALTHY);
        HotResourceSummary summary = null;
        boolean unhealthy = true;
        if (this.fullGcTimeTooHigh(avgFullGCTime)) {
            LOG.info("Average full GC time is unhealthy " + avgFullGCTime);
            summary = new HotResourceSummary(ResourceUtil.FULL_GC_PAUSE_TIME, this.getFollowerCheckTimeoutMs(), avgFullGCTime, 600);
            ServiceMetrics.RCA_VERTICES_METRICS_AGGREGATOR.updateStat((MeasurementSet)RcaVerticesMetrics.YOUNG_GEN_RCA_NAMED_COUNT, FULL_GC_TIME_TOO_HIGH, (Number)1);
        } else if (this.promotionRateTooHigh(avgPromotionRate, this.lowerBoundThreshold)) {
            summary = new HotResourceSummary(ResourceUtil.YOUNG_GEN_PROMOTION_RATE, (double)this.promotionRateThreshold * this.lowerBoundThreshold, avgPromotionRate, 600);
            ServiceMetrics.RCA_VERTICES_METRICS_AGGREGATOR.updateStat((MeasurementSet)RcaVerticesMetrics.YOUNG_GEN_RCA_NAMED_COUNT, PROMOTION_RATE_TOO_HIGH, (Number)1);
        } else if (this.youngGcTimeTooHigh(avgYoungGCTime)) {
            summary = new HotResourceSummary(ResourceUtil.MINOR_GC_PAUSE_TIME, this.youngGenGcTimeThreshold, avgYoungGCTime, 600);
            ServiceMetrics.RCA_VERTICES_METRICS_AGGREGATOR.updateStat((MeasurementSet)RcaVerticesMetrics.YOUNG_GEN_RCA_NAMED_COUNT, YOUNG_GC_TIME_TOO_HIGH, (Number)1);
        } else if (this.prematurePromotionTooHigh(avgGarbagePromoted)) {
            summary = new HotResourceSummary(ResourceUtil.YOUNG_GEN_PROMOTION_RATE, this.garbagePromotionPctThreshold, avgGarbagePromoted, 600);
            ServiceMetrics.RCA_VERTICES_METRICS_AGGREGATOR.updateStat((MeasurementSet)RcaVerticesMetrics.YOUNG_GEN_RCA_NAMED_COUNT, PREMATURE_PROMOTION_TOO_HIGH, (Number)1);
        } else {
            unhealthy = false;
            context = new ResourceContext(Resources.State.HEALTHY);
        }
        if (unhealthy) {
            LOG.debug("avgPromotionRate = {} , avgGCTime = {}, avgGarbagePromoted = {}, avgFullGcTime = {},", (Object)avgPromotionRate, (Object)avgYoungGCTime, (Object)avgGarbagePromoted, (Object)avgFullGCTime);
            ServiceMetrics.RCA_VERTICES_METRICS_AGGREGATOR.updateStat((MeasurementSet)RcaVerticesMetrics.NUM_YOUNG_GEN_RCA_TRIGGERED, (Number)1);
        }
        return new ResourceFlowUnit<HotResourceSummary>(this.clock.millis(), context, summary);
    }

    private void computePromotionHealth(double currOldGen, double fullGcCount, long currTimeStamp) {
        double promoted;
        if (currOldGen > this.maxOldGen) {
            this.maxOldGen = currOldGen;
        }
        if ((promoted = currOldGen - this.prevOldGen) >= 0.0) {
            this.youngGenPromotedBytes += promoted;
        } else if (fullGcCount > 0.0 && this.youngGenPromotedBytes > 0.0) {
            double reclaimed = this.maxOldGen - currOldGen;
            double garbageReclaimedPct = reclaimed / this.youngGenPromotedBytes;
            if (garbageReclaimedPct <= 1.0 && garbageReclaimedPct >= 0.0) {
                this.garbagePromotedDeque.next(new SlidingWindowData(currTimeStamp, garbageReclaimedPct));
            }
            this.youngGenPromotedBytes = 0.0;
            this.maxOldGen = currOldGen;
        }
        this.prevOldGen = currOldGen;
    }

    protected boolean isCollectorCMS() {
        if (this.gc_type == null) {
            throw new IllegalStateException("RCA: " + this.name() + "was not configured in the graph to take GC_Type as a metric. Please check the analysis graph!");
        }
        List gcTypeFlowUnits = this.gc_type.getFlowUnits();
        Field memTypeField = AllMetrics.GCInfoDimension.MEMORY_POOL.getField();
        Field collectorField = AllMetrics.GCInfoDimension.COLLECTOR_NAME.getField();
        for (MetricFlowUnit gcTypeFlowUnit : gcTypeFlowUnits) {
            if (gcTypeFlowUnit.isEmpty()) continue;
            Result<Record> records = gcTypeFlowUnit.getData();
            for (Record record : records) {
                String memType = (String)record.get(memTypeField);
                if (!AllMetrics.GCType.OLD_GEN.toString().equals(memType)) continue;
                return CMS_COLLECTOR.equals(record.get(collectorField));
            }
        }
        return true;
    }

    @Override
    public ResourceFlowUnit<HotResourceSummary> operate() {
        if (!this.isCollectorCMS()) {
            return new ResourceFlowUnit<HotResourceSummary>(System.currentTimeMillis());
        }
        long currTimeStamp = this.clock.millis();
        ++this.counter;
        LOG.debug("HighHeapUsageYoungGenRca getting collection event flow units");
        double fullGcCount = 0.0;
        for (MetricFlowUnit metricFU : this.gc_Collection_Event.getFlowUnits()) {
            if (metricFU.isEmpty() || !Double.isNaN(fullGcCount = SQLParsingUtil.readDataFromSqlResult(metricFU.getData(), (Field<String>)AllMetrics.HeapDimension.MEM_TYPE.getField(), AllMetrics.GCType.OLD_GEN.toString(), "max"))) continue;
            fullGcCount = 0.0;
            LOG.error("Failed to parse metric in FlowUnit from {}", (Object)this.gc_Collection_Event.getClass().getName());
        }
        LOG.debug("HighHeapUsageYoungGenRca getting heap used flow units");
        for (MetricFlowUnit metricFU : this.heap_Used.getFlowUnits()) {
            if (metricFU.isEmpty()) continue;
            double oldGenHeapUsed = SQLParsingUtil.readDataFromSqlResult(metricFU.getData(), (Field<String>)AllMetrics.HeapDimension.MEM_TYPE.getField(), AllMetrics.GCType.OLD_GEN.toString(), "max");
            if (!Double.isNaN(oldGenHeapUsed)) {
                this.promotionRateDeque.next(new SlidingWindowData(currTimeStamp, oldGenHeapUsed / CONVERT_BYTES_TO_MEGABYTES));
                this.computePromotionHealth(oldGenHeapUsed, fullGcCount, currTimeStamp);
                continue;
            }
            LOG.error("Failed to parse metric in FlowUnit from {}", (Object)this.heap_Used.getClass().getName());
        }
        LOG.debug("HighHeapUsageYoungGenRca getting collection time flow units");
        for (MetricFlowUnit metricFU : this.gc_Collection_Time.getFlowUnits()) {
            double totFullGCTime;
            if (metricFU.isEmpty()) continue;
            double totYoungGCTime = SQLParsingUtil.readDataFromSqlResult(metricFU.getData(), (Field<String>)AllMetrics.HeapDimension.MEM_TYPE.getField(), AllMetrics.GCType.TOT_YOUNG_GC.toString(), "max");
            if (!Double.isNaN(totYoungGCTime)) {
                this.minorGcTimeDeque.next(new SlidingWindowData(currTimeStamp, totYoungGCTime));
            }
            if (!Double.isNaN(totFullGCTime = SQLParsingUtil.readDataFromSqlResult(metricFU.getData(), (Field<String>)AllMetrics.HeapDimension.MEM_TYPE.getField(), AllMetrics.GCType.TOT_FULL_GC.toString(), "max"))) {
                this.fullGcTimeDeque.next(new SlidingWindowData(currTimeStamp, totFullGCTime));
                continue;
            }
            LOG.error("Failed to parse metric in FlowUnit from {}", (Object)this.gc_Collection_Time.getClass().getName());
        }
        if (this.counter == this.rcaPeriod) {
            LOG.debug("HighHeapUsageYoungGenRca computing data...");
            this.counter = 0;
            double avgPromotionRate = this.promotionRateDeque.readAvg(TimeUnit.SECONDS);
            double avgYoungGCTime = this.minorGcTimeDeque.readAvg(TimeUnit.SECONDS);
            double avgGarbagePromoted = this.garbagePromotedDeque.readAvg();
            double avgFullGCTime = this.fullGcTimeDeque.readAvg();
            return this.computeFlowUnit(avgPromotionRate, avgYoungGCTime, avgGarbagePromoted, avgFullGCTime);
        }
        LOG.debug("RCA: Empty FlowUnit returned for Young Gen RCA");
        return new ResourceFlowUnit<HotResourceSummary>(this.clock.millis());
    }

    @Override
    public void readRcaConf(RcaConf conf) {
        HighHeapUsageYoungGenRcaConfig configObj = conf.getHighHeapUsageYoungGenRcaConfig();
        this.promotionRateThreshold = configObj.getPromotionRateThreshold();
        this.youngGenGcTimeThreshold = configObj.getYoungGenGcTimeThreshold();
        this.garbagePromotionPctThreshold = configObj.getGarbagePromotionPctThreshold();
    }

    @Override
    public void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper args) {
        throw new IllegalArgumentException(this.name() + "'s generateFlowUnitListFromWire() should not be required.");
    }
}

