/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.Configuration;
import com.azure.core.util.ConfigurationProperty;
import com.azure.core.util.ConfigurationPropertyBuilder;

public class TracingOptions {
    private static final ConfigurationProperty<Boolean> IS_DISABLED_PROPERTY = ConfigurationPropertyBuilder.ofBoolean("tracing.disabled").environmentVariableName("AZURE_TRACING_DISABLED").shared(true).defaultValue(false).build();
    private boolean isEnabled = Configuration.getGlobalConfiguration().get(IS_DISABLED_PROPERTY) == false;

    public static TracingOptions fromConfiguration(Configuration configuration) {
        if (configuration.contains(IS_DISABLED_PROPERTY)) {
            return new TracingOptions().setEnabled(configuration.get(IS_DISABLED_PROPERTY) == false);
        }
        return new TracingOptions();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public TracingOptions setEnabled(boolean enabled) {
        this.isEnabled = enabled;
        return this;
    }
}

