/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.expression;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.common.utils.StringUtils;

public class AggregateFunction
extends UnresolvedExpression {
    private final String funcName;
    private final UnresolvedExpression field;
    private final List<UnresolvedExpression> argList;
    private UnresolvedExpression condition;
    private Boolean distinct = false;

    public AggregateFunction(String funcName, UnresolvedExpression field) {
        this.funcName = funcName;
        this.field = field;
        this.argList = Collections.emptyList();
    }

    public AggregateFunction(String funcName, UnresolvedExpression field, Boolean distinct) {
        this.funcName = funcName;
        this.field = field;
        this.argList = Collections.emptyList();
        this.distinct = distinct;
    }

    public List<UnresolvedExpression> getChild() {
        return Collections.singletonList(this.field);
    }

    @Override
    public <R, C> R accept(AbstractNodeVisitor<R, C> nodeVisitor, C context) {
        return nodeVisitor.visitAggregateFunction(this, context);
    }

    @Override
    public String toString() {
        return StringUtils.format((String)"%s(%s)", (Object[])new Object[]{this.funcName, this.field});
    }

    @Generated
    public String getFuncName() {
        return this.funcName;
    }

    @Generated
    public UnresolvedExpression getField() {
        return this.field;
    }

    @Generated
    public List<UnresolvedExpression> getArgList() {
        return this.argList;
    }

    @Generated
    public UnresolvedExpression condition() {
        return this.condition;
    }

    @Generated
    public Boolean getDistinct() {
        return this.distinct;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AggregateFunction)) {
            return false;
        }
        AggregateFunction other = (AggregateFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$distinct = this.getDistinct();
        Boolean other$distinct = other.getDistinct();
        if (this$distinct == null ? other$distinct != null : !((Object)this$distinct).equals(other$distinct)) {
            return false;
        }
        String this$funcName = this.getFuncName();
        String other$funcName = other.getFuncName();
        if (this$funcName == null ? other$funcName != null : !this$funcName.equals(other$funcName)) {
            return false;
        }
        UnresolvedExpression this$field = this.getField();
        UnresolvedExpression other$field = other.getField();
        if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
            return false;
        }
        List<UnresolvedExpression> this$argList = this.getArgList();
        List<UnresolvedExpression> other$argList = other.getArgList();
        if (this$argList == null ? other$argList != null : !((Object)this$argList).equals(other$argList)) {
            return false;
        }
        UnresolvedExpression this$condition = this.condition();
        UnresolvedExpression other$condition = other.condition();
        return !(this$condition == null ? other$condition != null : !((Object)this$condition).equals(other$condition));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AggregateFunction;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $distinct = this.getDistinct();
        result = result * 59 + ($distinct == null ? 43 : ((Object)$distinct).hashCode());
        String $funcName = this.getFuncName();
        result = result * 59 + ($funcName == null ? 43 : $funcName.hashCode());
        UnresolvedExpression $field = this.getField();
        result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
        List<UnresolvedExpression> $argList = this.getArgList();
        result = result * 59 + ($argList == null ? 43 : ((Object)$argList).hashCode());
        UnresolvedExpression $condition = this.condition();
        result = result * 59 + ($condition == null ? 43 : ((Object)$condition).hashCode());
        return result;
    }

    @Generated
    public AggregateFunction(String funcName, UnresolvedExpression field, List<UnresolvedExpression> argList) {
        this.funcName = funcName;
        this.field = field;
        this.argList = argList;
    }

    @Generated
    public AggregateFunction condition(UnresolvedExpression condition) {
        this.condition = condition;
        return this;
    }
}

