/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.output.execute.metrics_correlation;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.exception.MLException;
import org.opensearch.ml.common.output.execute.metrics_correlation.MCorrModelTensor;
import org.opensearch.ml.common.output.model.ModelResultFilter;

public class MCorrModelTensors
implements Writeable,
ToXContentObject {
    @Generated
    private static final Logger log = LogManager.getLogger(MCorrModelTensors.class);
    public static final String OUTPUT_FIELD = "output";
    private List<MCorrModelTensor> mCorrModelTensors;

    public MCorrModelTensors(List<MCorrModelTensor> mCorrModelTensors) {
        this.mCorrModelTensors = mCorrModelTensors;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.mCorrModelTensors != null && this.mCorrModelTensors.size() > 0) {
            for (MCorrModelTensor output : this.mCorrModelTensors) {
                output.toXContent(builder, params);
            }
        }
        return builder;
    }

    public MCorrModelTensors(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.mCorrModelTensors = new ArrayList<MCorrModelTensor>();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                this.mCorrModelTensors.add(new MCorrModelTensor(in));
            }
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.mCorrModelTensors != null && this.mCorrModelTensors.size() > 0) {
            out.writeBoolean(true);
            out.writeInt(this.mCorrModelTensors.size());
            for (MCorrModelTensor output : this.mCorrModelTensors) {
                output.writeTo(out);
            }
        } else {
            out.writeBoolean(false);
        }
    }

    public void filter(ModelResultFilter resultFilter) {
        boolean returnNumber = resultFilter.isReturnNumber();
        List<String> targetResponse = resultFilter.getTargetResponse();
        List<Integer> targetResponsePositions = resultFilter.getTargetResponsePositions();
        if (!(targetResponse != null && targetResponse.size() != 0 || targetResponsePositions != null && targetResponsePositions.size() != 0)) {
            this.mCorrModelTensors.forEach(output -> this.filter((MCorrModelTensor)output, returnNumber));
            return;
        }
        ArrayList<MCorrModelTensor> targetOutput = new ArrayList<MCorrModelTensor>();
        if (this.mCorrModelTensors != null) {
            for (int i = 0; i < this.mCorrModelTensors.size(); ++i) {
                MCorrModelTensor output2 = this.mCorrModelTensors.get(i);
                if (targetResponse != null && targetResponse.contains(output2.getEvent_window())) {
                    this.filter(output2, returnNumber);
                    targetOutput.add(output2);
                    continue;
                }
                if (targetResponsePositions == null || !targetResponsePositions.contains(i)) continue;
                this.filter(output2, returnNumber);
                targetOutput.add(output2);
            }
        }
        this.mCorrModelTensors = targetOutput;
    }

    private void filter(MCorrModelTensor output, boolean returnNUmber) {
        if (!returnNUmber) {
            output.setEvent_pattern(null);
            output.setSuspected_metrics(null);
            output.setEvent_window(null);
        }
    }

    public byte[] toBytes() {
        byte[] byArray;
        BytesStreamOutput bytesStreamOutput = new BytesStreamOutput();
        try {
            this.writeTo((StreamOutput)bytesStreamOutput);
            bytesStreamOutput.flush();
            byArray = bytesStreamOutput.bytes().toBytesRef().bytes;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bytesStreamOutput.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new MLException("Failed to parse result", e);
            }
        }
        bytesStreamOutput.close();
        return byArray;
    }

    public static MCorrModelTensors fromBytes(byte[] bytes) {
        MCorrModelTensors mCorrModelTensors;
        block8: {
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            StreamInput streamInput = BytesReference.fromByteBuffer((ByteBuffer)byteBuffer).streamInput();
            try {
                mCorrModelTensors = new MCorrModelTensors(streamInput);
                if (streamInput == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (streamInput != null) {
                        try {
                            streamInput.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    String errorMsg = "Failed to parse output";
                    throw new MLException(errorMsg, e);
                }
            }
            streamInput.close();
        }
        return mCorrModelTensors;
    }

    @Generated
    public static MCorrModelTensorsBuilder builder() {
        return new MCorrModelTensorsBuilder();
    }

    @Generated
    public List<MCorrModelTensor> getMCorrModelTensors() {
        return this.mCorrModelTensors;
    }

    @Generated
    public static class MCorrModelTensorsBuilder {
        @Generated
        private List<MCorrModelTensor> mCorrModelTensors;

        @Generated
        MCorrModelTensorsBuilder() {
        }

        @Generated
        public MCorrModelTensorsBuilder mCorrModelTensors(List<MCorrModelTensor> mCorrModelTensors) {
            this.mCorrModelTensors = mCorrModelTensors;
            return this;
        }

        @Generated
        public MCorrModelTensors build() {
            return new MCorrModelTensors(this.mCorrModelTensors);
        }

        @Generated
        public String toString() {
            return "MCorrModelTensors.MCorrModelTensorsBuilder(mCorrModelTensors=" + this.mCorrModelTensors + ")";
        }
    }
}

